/* Copyright (c) 2017, Intel Corporation.
 * 
 * SSX1 XBAR header file
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
*/


#ifndef _SSX1_SSX_H
#define _SSX1_SSX_H

/*! \defgroup SSX1_SSX Register File SSX1_SSX - SSX1_ssx */
/*! @{ */

/*! Base Address of SSX1 */
#define SSX1_MODULE_BASE 0x18000000u

/*! \defgroup REG0_TREG0_RT_TREG0_RT_COMPONENT Register REG0_TREG0_RT_TREG0_RT_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_RT_TREG0_RT_COMPONENT 0x0
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_RT_TREG0_RT_COMPONENT 0x18000000u

/*! Register Reset Value */
#define REG0_TREG0_RT_TREG0_RT_COMPONENT_RST 0x0000000062003532u

/*! Field REV - rev */
#define REG0_TREG0_RT_TREG0_RT_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TREG0_RT_TREG0_RT_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TREG0_RT_TREG0_RT_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TREG0_RT_TREG0_RT_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TREG0_RT_TREG0_RT_NETWORK Register REG0_TREG0_RT_TREG0_RT_NETWORK - network */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_RT_TREG0_RT_NETWORK 0x10
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_RT_TREG0_RT_NETWORK 0x18000010u

/*! Register Reset Value */
#define REG0_TREG0_RT_TREG0_RT_NETWORK_RST 0x0000000000000000u

/*! Field REV - rev */
#define REG0_TREG0_RT_TREG0_RT_NETWORK_REV_POS 32
/*! Field REV - rev */
#define REG0_TREG0_RT_TREG0_RT_NETWORK_REV_MASK 0xFFFF00000000u

/*! Field ID - id */
#define REG0_TREG0_RT_TREG0_RT_NETWORK_ID_POS 48
/*! Field ID - id */
#define REG0_TREG0_RT_TREG0_RT_NETWORK_ID_MASK 0xFFFF000000000000u

/*! @} */

/*! \defgroup REG0_TREG0_RT_TREG0_RT_INITID_READBACK Register REG0_TREG0_RT_TREG0_RT_INITID_READBACK - initid_readback */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_RT_TREG0_RT_INITID_READBACK 0x70
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_RT_TREG0_RT_INITID_READBACK 0x18000070u

/*! Register Reset Value */
#define REG0_TREG0_RT_TREG0_RT_INITID_READBACK_RST 0x0000000000000000u

/*! Field INITID - initid */
#define REG0_TREG0_RT_TREG0_RT_INITID_READBACK_INITID_POS 0
/*! Field INITID - initid */
#define REG0_TREG0_RT_TREG0_RT_INITID_READBACK_INITID_MASK 0xFFu

/*! @} */

/*! \defgroup REG0_TREG0_RT_TREG0_RT_NETWORK_CONTROL Register REG0_TREG0_RT_TREG0_RT_NETWORK_CONTROL - network_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_RT_TREG0_RT_NETWORK_CONTROL 0x78
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_RT_TREG0_RT_NETWORK_CONTROL 0x18000078u

/*! Register Reset Value */
#define REG0_TREG0_RT_TREG0_RT_NETWORK_CONTROL_RST 0x0000000000000000u

/*! Field TIMEOUT_BASE - timeout_base */
#define REG0_TREG0_RT_TREG0_RT_NETWORK_CONTROL_TIMEOUT_BASE_POS 8
/*! Field TIMEOUT_BASE - timeout_base */
#define REG0_TREG0_RT_TREG0_RT_NETWORK_CONTROL_TIMEOUT_BASE_MASK 0x700u

/*! Field CLOCK_GATE_DISABLE - clock_gate_disable */
#define REG0_TREG0_RT_TREG0_RT_NETWORK_CONTROL_CLOCK_GATE_DISABLE_POS 56
/*! Field CLOCK_GATE_DISABLE - clock_gate_disable */
#define REG0_TREG0_RT_TREG0_RT_NETWORK_CONTROL_CLOCK_GATE_DISABLE_MASK 0x100000000000000u

/*! @} */

/*! \defgroup REG0_TREG0_SI_TREG0_SI_CONTROL Register REG0_TREG0_SI_TREG0_SI_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_SI_TREG0_SI_CONTROL 0x420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_SI_TREG0_SI_CONTROL 0x18000420u

/*! Register Reset Value */
#define REG0_TREG0_SI_TREG0_SI_CONTROL_RST 0x0000000000000000u

/*! Field CLOCK_GATE_DISABLE - clock_gate_disable */
#define REG0_TREG0_SI_TREG0_SI_CONTROL_CLOCK_GATE_DISABLE_POS 56
/*! Field CLOCK_GATE_DISABLE - clock_gate_disable */
#define REG0_TREG0_SI_TREG0_SI_CONTROL_CLOCK_GATE_DISABLE_MASK 0x100000000000000u

/*! @} */

/*! \defgroup REG0_TREG0_SI_TREG0_SI_FLAG_STATUS_0 Register REG0_TREG0_SI_TREG0_SI_FLAG_STATUS_0 - flag_status_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_SI_TREG0_SI_FLAG_STATUS_0 0x510
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_SI_TREG0_SI_FLAG_STATUS_0 0x18000510u

/*! Register Reset Value */
#define REG0_TREG0_SI_TREG0_SI_FLAG_STATUS_0_RST 0x0000000000000000u

/*! Field STATUS - status */
#define REG0_TREG0_SI_TREG0_SI_FLAG_STATUS_0_STATUS_POS 0
/*! Field STATUS - status */
#define REG0_TREG0_SI_TREG0_SI_FLAG_STATUS_0_STATUS_MASK 0xFFFFFFFFFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TREG0_SI_TREG0_SI_FLAG_STATUS_1 Register REG0_TREG0_SI_TREG0_SI_FLAG_STATUS_1 - flag_status_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_SI_TREG0_SI_FLAG_STATUS_1 0x530
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_SI_TREG0_SI_FLAG_STATUS_1 0x18000530u

/*! Register Reset Value */
#define REG0_TREG0_SI_TREG0_SI_FLAG_STATUS_1_RST 0x0000000000000000u

/*! Field STATUS - status */
#define REG0_TREG0_SI_TREG0_SI_FLAG_STATUS_1_STATUS_POS 0
/*! Field STATUS - status */
#define REG0_TREG0_SI_TREG0_SI_FLAG_STATUS_1_STATUS_MASK 0xFFFFFFFFFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TSSB_TA_TSSB_TA_COMPONENT Register REG0_TSSB_TA_TSSB_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TSSB_TA_TSSB_TA_COMPONENT 0x1000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TSSB_TA_TSSB_TA_COMPONENT 0x18001000u

/*! Register Reset Value */
#define REG0_TSSB_TA_TSSB_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TSSB_TA_TSSB_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TSSB_TA_TSSB_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TSSB_TA_TSSB_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TSSB_TA_TSSB_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TSSB_TA_TSSB_TA_CORE Register REG0_TSSB_TA_TSSB_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TSSB_TA_TSSB_TA_CORE 0x1018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TSSB_TA_TSSB_TA_CORE 0x18001018u

/*! Register Reset Value */
#define REG0_TSSB_TA_TSSB_TA_CORE_RST 0x000088C3000B0001u

/*! Field REV_CODE - rev_code */
#define REG0_TSSB_TA_TSSB_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TSSB_TA_TSSB_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TSSB_TA_TSSB_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TSSB_TA_TSSB_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TSSB_TA_TSSB_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TSSB_TA_TSSB_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL Register REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL 0x1020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL 0x18001020u

/*! Register Reset Value */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TSSB_TA_TSSB_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TSSB_TA_TSSB_TA_AGENT_STATUS Register REG0_TSSB_TA_TSSB_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS 0x1028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TSSB_TA_TSSB_TA_AGENT_STATUS 0x18001028u

/*! Register Reset Value */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TSSB_TA_TSSB_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TSSB_TA_TSSB_TA_ERROR_LOG Register REG0_TSSB_TA_TSSB_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG 0x1058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TSSB_TA_TSSB_TA_ERROR_LOG 0x18001058u

/*! Register Reset Value */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TSSB_TA_TSSB_TA_ERROR_LOG_ADDR Register REG0_TSSB_TA_TSSB_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG_ADDR 0x1060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TSSB_TA_TSSB_TA_ERROR_LOG_ADDR 0x18001060u

/*! Register Reset Value */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TSSB_TA_TSSB_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TSSB_TA_TSSB_TA_BANDWIDTH_0 Register REG0_TSSB_TA_TSSB_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_0 0x1100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TSSB_TA_TSSB_TA_BANDWIDTH_0 0x18001100u

/*! Register Reset Value */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TSSB_TA_TSSB_TA_BANDWIDTH_1 Register REG0_TSSB_TA_TSSB_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_1 0x1108
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TSSB_TA_TSSB_TA_BANDWIDTH_1 0x18001108u

/*! Register Reset Value */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TSSB_TA_TSSB_TA_BANDWIDTH_2 Register REG0_TSSB_TA_TSSB_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_2 0x1110
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TSSB_TA_TSSB_TA_BANDWIDTH_2 0x18001110u

/*! Register Reset Value */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TSSB_TA_TSSB_TA_BANDWIDTH_3 Register REG0_TSSB_TA_TSSB_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_3 0x1118
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TSSB_TA_TSSB_TA_BANDWIDTH_3 0x18001118u

/*! Register Reset Value */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TSSB_TA_TSSB_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0 Register REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0 0x1200
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0 0x18001200u

/*! Register Reset Value */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TSSB_TA_TSSB_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TROM_TA_TROM_TA_COMPONENT Register REG0_TROM_TA_TROM_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TROM_TA_TROM_TA_COMPONENT 0x1400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TROM_TA_TROM_TA_COMPONENT 0x18001400u

/*! Register Reset Value */
#define REG0_TROM_TA_TROM_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TROM_TA_TROM_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TROM_TA_TROM_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TROM_TA_TROM_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TROM_TA_TROM_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TROM_TA_TROM_TA_CORE Register REG0_TROM_TA_TROM_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TROM_TA_TROM_TA_CORE 0x1418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TROM_TA_TROM_TA_CORE 0x18001418u

/*! Register Reset Value */
#define REG0_TROM_TA_TROM_TA_CORE_RST 0x000088C300080001u

/*! Field REV_CODE - rev_code */
#define REG0_TROM_TA_TROM_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TROM_TA_TROM_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TROM_TA_TROM_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TROM_TA_TROM_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TROM_TA_TROM_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TROM_TA_TROM_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TROM_TA_TROM_TA_AGENT_CONTROL Register REG0_TROM_TA_TROM_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL 0x1420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TROM_TA_TROM_TA_AGENT_CONTROL 0x18001420u

/*! Register Reset Value */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TROM_TA_TROM_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TROM_TA_TROM_TA_AGENT_STATUS Register REG0_TROM_TA_TROM_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS 0x1428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TROM_TA_TROM_TA_AGENT_STATUS 0x18001428u

/*! Register Reset Value */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TROM_TA_TROM_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TROM_TA_TROM_TA_ERROR_LOG Register REG0_TROM_TA_TROM_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG 0x1458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TROM_TA_TROM_TA_ERROR_LOG 0x18001458u

/*! Register Reset Value */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TROM_TA_TROM_TA_ERROR_LOG_ADDR Register REG0_TROM_TA_TROM_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG_ADDR 0x1460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TROM_TA_TROM_TA_ERROR_LOG_ADDR 0x18001460u

/*! Register Reset Value */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TROM_TA_TROM_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TROM_TA_TROM_TA_BANDWIDTH_0 Register REG0_TROM_TA_TROM_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_0 0x1500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TROM_TA_TROM_TA_BANDWIDTH_0 0x18001500u

/*! Register Reset Value */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TROM_TA_TROM_TA_BANDWIDTH_1 Register REG0_TROM_TA_TROM_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_1 0x1508
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TROM_TA_TROM_TA_BANDWIDTH_1 0x18001508u

/*! Register Reset Value */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TROM_TA_TROM_TA_BANDWIDTH_2 Register REG0_TROM_TA_TROM_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_2 0x1510
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TROM_TA_TROM_TA_BANDWIDTH_2 0x18001510u

/*! Register Reset Value */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TROM_TA_TROM_TA_BANDWIDTH_3 Register REG0_TROM_TA_TROM_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_3 0x1518
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TROM_TA_TROM_TA_BANDWIDTH_3 0x18001518u

/*! Register Reset Value */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TROM_TA_TROM_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0 Register REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0 0x1600
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0 0x18001600u

/*! Register Reset Value */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TROM_TA_TROM_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TOTP_TA_TOTP_TA_COMPONENT Register REG0_TOTP_TA_TOTP_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_TA_TOTP_TA_COMPONENT 0x1800
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_TA_TOTP_TA_COMPONENT 0x18001800u

/*! Register Reset Value */
#define REG0_TOTP_TA_TOTP_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TOTP_TA_TOTP_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TOTP_TA_TOTP_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TOTP_TA_TOTP_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TOTP_TA_TOTP_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TOTP_TA_TOTP_TA_CORE Register REG0_TOTP_TA_TOTP_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_TA_TOTP_TA_CORE 0x1818
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_TA_TOTP_TA_CORE 0x18001818u

/*! Register Reset Value */
#define REG0_TOTP_TA_TOTP_TA_CORE_RST 0x000088C300070001u

/*! Field REV_CODE - rev_code */
#define REG0_TOTP_TA_TOTP_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TOTP_TA_TOTP_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TOTP_TA_TOTP_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TOTP_TA_TOTP_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TOTP_TA_TOTP_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TOTP_TA_TOTP_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL Register REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL 0x1820
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL 0x18001820u

/*! Register Reset Value */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TOTP_TA_TOTP_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TOTP_TA_TOTP_TA_AGENT_STATUS Register REG0_TOTP_TA_TOTP_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS 0x1828
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_TA_TOTP_TA_AGENT_STATUS 0x18001828u

/*! Register Reset Value */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TOTP_TA_TOTP_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TOTP_TA_TOTP_TA_ERROR_LOG Register REG0_TOTP_TA_TOTP_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG 0x1858
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_TA_TOTP_TA_ERROR_LOG 0x18001858u

/*! Register Reset Value */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TOTP_TA_TOTP_TA_ERROR_LOG_ADDR Register REG0_TOTP_TA_TOTP_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG_ADDR 0x1860
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_TA_TOTP_TA_ERROR_LOG_ADDR 0x18001860u

/*! Register Reset Value */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TOTP_TA_TOTP_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TOTP_TA_TOTP_TA_BANDWIDTH_0 Register REG0_TOTP_TA_TOTP_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_0 0x1900
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_TA_TOTP_TA_BANDWIDTH_0 0x18001900u

/*! Register Reset Value */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TOTP_TA_TOTP_TA_BANDWIDTH_1 Register REG0_TOTP_TA_TOTP_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_1 0x1908
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_TA_TOTP_TA_BANDWIDTH_1 0x18001908u

/*! Register Reset Value */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TOTP_TA_TOTP_TA_BANDWIDTH_2 Register REG0_TOTP_TA_TOTP_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_2 0x1910
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_TA_TOTP_TA_BANDWIDTH_2 0x18001910u

/*! Register Reset Value */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TOTP_TA_TOTP_TA_BANDWIDTH_3 Register REG0_TOTP_TA_TOTP_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_3 0x1918
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_TA_TOTP_TA_BANDWIDTH_3 0x18001918u

/*! Register Reset Value */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TOTP_TA_TOTP_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0 Register REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0 0x1A00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0 0x18001A00u

/*! Register Reset Value */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TOTP_TA_TOTP_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TCBM1_TA_TCBM1_TA_COMPONENT Register REG0_TCBM1_TA_TCBM1_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_TA_TCBM1_TA_COMPONENT 0x1C00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_TA_TCBM1_TA_COMPONENT 0x18001C00u

/*! Register Reset Value */
#define REG0_TCBM1_TA_TCBM1_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TCBM1_TA_TCBM1_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TCBM1_TA_TCBM1_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TCBM1_TA_TCBM1_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TCBM1_TA_TCBM1_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TCBM1_TA_TCBM1_TA_CORE Register REG0_TCBM1_TA_TCBM1_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_TA_TCBM1_TA_CORE 0x1C18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_TA_TCBM1_TA_CORE 0x18001C18u

/*! Register Reset Value */
#define REG0_TCBM1_TA_TCBM1_TA_CORE_RST 0x000050C500090001u

/*! Field REV_CODE - rev_code */
#define REG0_TCBM1_TA_TCBM1_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TCBM1_TA_TCBM1_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TCBM1_TA_TCBM1_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TCBM1_TA_TCBM1_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TCBM1_TA_TCBM1_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TCBM1_TA_TCBM1_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL Register REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL 0x1C20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL 0x18001C20u

/*! Register Reset Value */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS Register REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS 0x1C28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS 0x18001C28u

/*! Register Reset Value */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TCBM1_TA_TCBM1_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG Register REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG 0x1C58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG 0x18001C58u

/*! Register Reset Value */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_ADDR Register REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_ADDR 0x1C60
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_ADDR 0x18001C60u

/*! Register Reset Value */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TCBM1_TA_TCBM1_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_0 Register REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_0 0x1D00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_0 0x18001D00u

/*! Register Reset Value */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_0_RST 0x2000200020002000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_1 Register REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_1 0x1D08
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_1 0x18001D08u

/*! Register Reset Value */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_2 Register REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_2 0x1D10
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_2 0x18001D10u

/*! Register Reset Value */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_3 Register REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_3 0x1D18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_3 0x18001D18u

/*! Register Reset Value */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TCBM1_TA_TCBM1_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0 Register REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0 0x1E00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0 0x18001E00u

/*! Register Reset Value */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_RST 0x0404040404040404u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TCBM1_TA_TCBM1_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TCBM2_TA_TCBM2_TA_COMPONENT Register REG0_TCBM2_TA_TCBM2_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_TA_TCBM2_TA_COMPONENT 0x2000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_TA_TCBM2_TA_COMPONENT 0x18002000u

/*! Register Reset Value */
#define REG0_TCBM2_TA_TCBM2_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TCBM2_TA_TCBM2_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TCBM2_TA_TCBM2_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TCBM2_TA_TCBM2_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TCBM2_TA_TCBM2_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TCBM2_TA_TCBM2_TA_CORE Register REG0_TCBM2_TA_TCBM2_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_TA_TCBM2_TA_CORE 0x2018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_TA_TCBM2_TA_CORE 0x18002018u

/*! Register Reset Value */
#define REG0_TCBM2_TA_TCBM2_TA_CORE_RST 0x000050C501090001u

/*! Field REV_CODE - rev_code */
#define REG0_TCBM2_TA_TCBM2_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TCBM2_TA_TCBM2_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TCBM2_TA_TCBM2_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TCBM2_TA_TCBM2_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TCBM2_TA_TCBM2_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TCBM2_TA_TCBM2_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL Register REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL 0x2020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL 0x18002020u

/*! Register Reset Value */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS Register REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS 0x2028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS 0x18002028u

/*! Register Reset Value */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TCBM2_TA_TCBM2_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG Register REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG 0x2058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG 0x18002058u

/*! Register Reset Value */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_ADDR Register REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_ADDR 0x2060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_ADDR 0x18002060u

/*! Register Reset Value */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TCBM2_TA_TCBM2_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_0 Register REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_0 0x2100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_0 0x18002100u

/*! Register Reset Value */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_0_RST 0x2000200020002000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_1 Register REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_1 0x2108
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_1 0x18002108u

/*! Register Reset Value */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_2 Register REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_2 0x2110
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_2 0x18002110u

/*! Register Reset Value */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_3 Register REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_3 0x2118
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_3 0x18002118u

/*! Register Reset Value */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TCBM2_TA_TCBM2_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0 Register REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0 0x2200
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0 0x18002200u

/*! Register Reset Value */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_RST 0x0404040404040404u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TCBM2_TA_TCBM2_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TE123_TA_TE123_TA_COMPONENT Register REG0_TE123_TA_TE123_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_TA_TE123_TA_COMPONENT 0x2800
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_TA_TE123_TA_COMPONENT 0x18002800u

/*! Register Reset Value */
#define REG0_TE123_TA_TE123_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TE123_TA_TE123_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TE123_TA_TE123_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TE123_TA_TE123_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TE123_TA_TE123_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TE123_TA_TE123_TA_CORE Register REG0_TE123_TA_TE123_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_TA_TE123_TA_CORE 0x2818
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_TA_TE123_TA_CORE 0x18002818u

/*! Register Reset Value */
#define REG0_TE123_TA_TE123_TA_CORE_RST 0x0000CAFE000F0000u

/*! Field REV_CODE - rev_code */
#define REG0_TE123_TA_TE123_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TE123_TA_TE123_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TE123_TA_TE123_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TE123_TA_TE123_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TE123_TA_TE123_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TE123_TA_TE123_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TE123_TA_TE123_TA_AGENT_CONTROL Register REG0_TE123_TA_TE123_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL 0x2820
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_TA_TE123_TA_AGENT_CONTROL 0x18002820u

/*! Register Reset Value */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TE123_TA_TE123_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TE123_TA_TE123_TA_AGENT_STATUS Register REG0_TE123_TA_TE123_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS 0x2828
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_TA_TE123_TA_AGENT_STATUS 0x18002828u

/*! Register Reset Value */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TE123_TA_TE123_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TE123_TA_TE123_TA_ERROR_LOG Register REG0_TE123_TA_TE123_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG 0x2858
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_TA_TE123_TA_ERROR_LOG 0x18002858u

/*! Register Reset Value */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG_REQ_INFO_MASK 0x7FFF00000000u

/*! @} */

/*! \defgroup REG0_TE123_TA_TE123_TA_ERROR_LOG_ADDR Register REG0_TE123_TA_TE123_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG_ADDR 0x2860
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_TA_TE123_TA_ERROR_LOG_ADDR 0x18002860u

/*! Register Reset Value */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TE123_TA_TE123_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TE123_TA_TE123_TA_BANDWIDTH_0 Register REG0_TE123_TA_TE123_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_0 0x2900
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_TA_TE123_TA_BANDWIDTH_0 0x18002900u

/*! Register Reset Value */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TE123_TA_TE123_TA_BANDWIDTH_1 Register REG0_TE123_TA_TE123_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_1 0x2908
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_TA_TE123_TA_BANDWIDTH_1 0x18002908u

/*! Register Reset Value */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TE123_TA_TE123_TA_BANDWIDTH_2 Register REG0_TE123_TA_TE123_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_2 0x2910
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_TA_TE123_TA_BANDWIDTH_2 0x18002910u

/*! Register Reset Value */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TE123_TA_TE123_TA_BANDWIDTH_3 Register REG0_TE123_TA_TE123_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_3 0x2918
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_TA_TE123_TA_BANDWIDTH_3 0x18002918u

/*! Register Reset Value */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TE123_TA_TE123_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0 Register REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0 0x2A00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0 0x18002A00u

/*! Register Reset Value */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TE123_TA_TE123_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMA3_TA_TDM3_TA_COMPONENT Register REG0_TDMA3_TA_TDM3_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_TA_TDM3_TA_COMPONENT 0x2C00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_TA_TDM3_TA_COMPONENT 0x18002C00u

/*! Register Reset Value */
#define REG0_TDMA3_TA_TDM3_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TDMA3_TA_TDM3_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TDMA3_TA_TDM3_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TDMA3_TA_TDM3_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TDMA3_TA_TDM3_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TDMA3_TA_TDM3_TA_CORE Register REG0_TDMA3_TA_TDM3_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_TA_TDM3_TA_CORE 0x2C18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_TA_TDM3_TA_CORE 0x18002C18u

/*! Register Reset Value */
#define REG0_TDMA3_TA_TDM3_TA_CORE_RST 0x000088C3000C0001u

/*! Field REV_CODE - rev_code */
#define REG0_TDMA3_TA_TDM3_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TDMA3_TA_TDM3_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TDMA3_TA_TDM3_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TDMA3_TA_TDM3_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TDMA3_TA_TDM3_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TDMA3_TA_TDM3_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL Register REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL 0x2C20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL 0x18002C20u

/*! Register Reset Value */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS Register REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS 0x2C28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS 0x18002C28u

/*! Register Reset Value */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TDMA3_TA_TDM3_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TDMA3_TA_TDM3_TA_ERROR_LOG Register REG0_TDMA3_TA_TDM3_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG 0x2C58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_TA_TDM3_TA_ERROR_LOG 0x18002C58u

/*! Register Reset Value */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_ADDR Register REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_ADDR 0x2C60
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_ADDR 0x18002C60u

/*! Register Reset Value */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TDMA3_TA_TDM3_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_0 Register REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_0 0x2D00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_0 0x18002D00u

/*! Register Reset Value */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_1 Register REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_1 0x2D08
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_1 0x18002D08u

/*! Register Reset Value */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_2 Register REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_2 0x2D10
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_2 0x18002D10u

/*! Register Reset Value */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_3 Register REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_3 0x2D18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_3 0x18002D18u

/*! Register Reset Value */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TDMA3_TA_TDM3_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0 Register REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0 0x2E00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0 0x18002E00u

/*! Register Reset Value */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TDMA3_TA_TDM3_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMAT1_TA_TDMAT1_TA_COMPONENT Register REG0_TDMAT1_TA_TDMAT1_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_TA_TDMAT1_TA_COMPONENT 0x3000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_TA_TDMAT1_TA_COMPONENT 0x18003000u

/*! Register Reset Value */
#define REG0_TDMAT1_TA_TDMAT1_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TDMAT1_TA_TDMAT1_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TDMAT1_TA_TDMAT1_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TDMAT1_TA_TDMAT1_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TDMAT1_TA_TDMAT1_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TDMAT1_TA_TDMAT1_TA_CORE Register REG0_TDMAT1_TA_TDMAT1_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_TA_TDMAT1_TA_CORE 0x3018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_TA_TDMAT1_TA_CORE 0x18003018u

/*! Register Reset Value */
#define REG0_TDMAT1_TA_TDMAT1_TA_CORE_RST 0x000088C300230001u

/*! Field REV_CODE - rev_code */
#define REG0_TDMAT1_TA_TDMAT1_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TDMAT1_TA_TDMAT1_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TDMAT1_TA_TDMAT1_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TDMAT1_TA_TDMAT1_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TDMAT1_TA_TDMAT1_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TDMAT1_TA_TDMAT1_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL Register REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL 0x3020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL 0x18003020u

/*! Register Reset Value */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS Register REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS 0x3028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS 0x18003028u

/*! Register Reset Value */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TDMAT1_TA_TDMAT1_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG Register REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG 0x3058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG 0x18003058u

/*! Register Reset Value */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_ADDR Register REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_ADDR 0x3060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_ADDR 0x18003060u

/*! Register Reset Value */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TDMAT1_TA_TDMAT1_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_0 Register REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_0 0x3100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_0 0x18003100u

/*! Register Reset Value */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_1 Register REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_1 0x3108
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_1 0x18003108u

/*! Register Reset Value */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_2 Register REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_2 0x3110
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_2 0x18003110u

/*! Register Reset Value */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_3 Register REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_3 0x3118
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_3 0x18003118u

/*! Register Reset Value */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TDMAT1_TA_TDMAT1_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0 Register REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0 0x3200
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0 0x18003200u

/*! Register Reset Value */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TDMAT1_TA_TDMAT1_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDMAR2_IA_IDMAR2_IA_COMPONENT Register REG0_IDMAR2_IA_IDMAR2_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_IA_IDMAR2_IA_COMPONENT 0x3400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_IA_IDMAR2_IA_COMPONENT 0x18003400u

/*! Register Reset Value */
#define REG0_IDMAR2_IA_IDMAR2_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IDMAR2_IA_IDMAR2_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IDMAR2_IA_IDMAR2_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IDMAR2_IA_IDMAR2_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IDMAR2_IA_IDMAR2_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IDMAR2_IA_IDMAR2_IA_CORE Register REG0_IDMAR2_IA_IDMAR2_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_IA_IDMAR2_IA_CORE 0x3418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_IA_IDMAR2_IA_CORE 0x18003418u

/*! Register Reset Value */
#define REG0_IDMAR2_IA_IDMAR2_IA_CORE_RST 0x000050C500140001u

/*! Field REV_CODE - rev_code */
#define REG0_IDMAR2_IA_IDMAR2_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IDMAR2_IA_IDMAR2_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IDMAR2_IA_IDMAR2_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IDMAR2_IA_IDMAR2_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMAR2_IA_IDMAR2_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMAR2_IA_IDMAR2_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL Register REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL 0x3420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL 0x18003420u

/*! Register Reset Value */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS Register REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS 0x3428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS 0x18003428u

/*! Register Reset Value */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMAR2_IA_IDMAR2_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG Register REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG 0x3458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG 0x18003458u

/*! Register Reset Value */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_ADDR Register REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_ADDR 0x3460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_ADDR 0x18003460u

/*! Register Reset Value */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_ADDR_ADDR_POS 3
/*! Field ADDR - addr */
#define REG0_IDMAR2_IA_IDMAR2_IA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFF8u

/*! @} */

/*! \defgroup REG0_IDMAR2_IA_IDMAR2_IA_ADDR_FILL_IN Register REG0_IDMAR2_IA_IDMAR2_IA_ADDR_FILL_IN - addr_fill_in */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_IA_IDMAR2_IA_ADDR_FILL_IN 0x3470
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_IA_IDMAR2_IA_ADDR_FILL_IN 0x18003470u

/*! Register Reset Value */
#define REG0_IDMAR2_IA_IDMAR2_IA_ADDR_FILL_IN_RST 0x0000000000000000u

/*! Field VALUE - value */
#define REG0_IDMAR2_IA_IDMAR2_IA_ADDR_FILL_IN_VALUE_POS 32
/*! Field VALUE - value */
#define REG0_IDMAR2_IA_IDMAR2_IA_ADDR_FILL_IN_VALUE_MASK 0x100000000u

/*! @} */

/*! \defgroup REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0 Register REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0 0x3500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0 0x18003500u

/*! Register Reset Value */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMAR2_IA_IDMAR2_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDMAT2_IA_IDMAT2_IA_COMPONENT Register REG0_IDMAT2_IA_IDMAT2_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAT2_IA_IDMAT2_IA_COMPONENT 0x3800
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAT2_IA_IDMAT2_IA_COMPONENT 0x18003800u

/*! Register Reset Value */
#define REG0_IDMAT2_IA_IDMAT2_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IDMAT2_IA_IDMAT2_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IDMAT2_IA_IDMAT2_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IDMAT2_IA_IDMAT2_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IDMAT2_IA_IDMAT2_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IDMAT2_IA_IDMAT2_IA_CORE Register REG0_IDMAT2_IA_IDMAT2_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAT2_IA_IDMAT2_IA_CORE 0x3818
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAT2_IA_IDMAT2_IA_CORE 0x18003818u

/*! Register Reset Value */
#define REG0_IDMAT2_IA_IDMAT2_IA_CORE_RST 0x000050C500130001u

/*! Field REV_CODE - rev_code */
#define REG0_IDMAT2_IA_IDMAT2_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IDMAT2_IA_IDMAT2_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IDMAT2_IA_IDMAT2_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IDMAT2_IA_IDMAT2_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMAT2_IA_IDMAT2_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMAT2_IA_IDMAT2_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL Register REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL 0x3820
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL 0x18003820u

/*! Register Reset Value */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS Register REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS 0x3828
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS 0x18003828u

/*! Register Reset Value */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMAT2_IA_IDMAT2_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG Register REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG 0x3858
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG 0x18003858u

/*! Register Reset Value */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_ADDR Register REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_ADDR 0x3860
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_ADDR 0x18003860u

/*! Register Reset Value */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_ADDR_ADDR_POS 3
/*! Field ADDR - addr */
#define REG0_IDMAT2_IA_IDMAT2_IA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFF8u

/*! @} */

/*! \defgroup REG0_IDMAT2_IA_IDMAT2_IA_ADDR_FILL_IN Register REG0_IDMAT2_IA_IDMAT2_IA_ADDR_FILL_IN - addr_fill_in */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAT2_IA_IDMAT2_IA_ADDR_FILL_IN 0x3870
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAT2_IA_IDMAT2_IA_ADDR_FILL_IN 0x18003870u

/*! Register Reset Value */
#define REG0_IDMAT2_IA_IDMAT2_IA_ADDR_FILL_IN_RST 0x0000000000000000u

/*! Field VALUE - value */
#define REG0_IDMAT2_IA_IDMAT2_IA_ADDR_FILL_IN_VALUE_POS 32
/*! Field VALUE - value */
#define REG0_IDMAT2_IA_IDMAT2_IA_ADDR_FILL_IN_VALUE_MASK 0x100000000u

/*! @} */

/*! \defgroup REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0 Register REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0 0x3900
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0 0x18003900u

/*! Register Reset Value */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMAT2_IA_IDMAT2_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDMA1RDES_IA_IDMARDES1_IA_COMPONENT Register REG0_IDMA1RDES_IA_IDMARDES1_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_COMPONENT 0x3C00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA1RDES_IA_IDMARDES1_IA_COMPONENT 0x18003C00u

/*! Register Reset Value */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IDMA1RDES_IA_IDMARDES1_IA_CORE Register REG0_IDMA1RDES_IA_IDMARDES1_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_CORE 0x3C18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA1RDES_IA_IDMARDES1_IA_CORE 0x18003C18u

/*! Register Reset Value */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_CORE_RST 0x000050C501240001u

/*! Field REV_CODE - rev_code */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL Register REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL 0x3C20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL 0x18003C20u

/*! Register Reset Value */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS Register REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS 0x3C28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS 0x18003C28u

/*! Register Reset Value */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG Register REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG 0x3C58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG 0x18003C58u

/*! Register Reset Value */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_ADDR Register REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_ADDR 0x3C60
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_ADDR 0x18003C60u

/*! Register Reset Value */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_ADDR_ADDR_POS 3
/*! Field ADDR - addr */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFF8u

/*! @} */

/*! \defgroup REG0_IDMA1RDES_IA_IDMARDES1_IA_ADDR_FILL_IN Register REG0_IDMA1RDES_IA_IDMARDES1_IA_ADDR_FILL_IN - addr_fill_in */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ADDR_FILL_IN 0x3C70
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA1RDES_IA_IDMARDES1_IA_ADDR_FILL_IN 0x18003C70u

/*! Register Reset Value */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ADDR_FILL_IN_RST 0x0000000000000000u

/*! Field VALUE - value */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ADDR_FILL_IN_VALUE_POS 32
/*! Field VALUE - value */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_ADDR_FILL_IN_VALUE_MASK 0x100000000u

/*! @} */

/*! \defgroup REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0 Register REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0 0x3D00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0 0x18003D00u

/*! Register Reset Value */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMA1RDES_IA_IDMARDES1_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TEX04_TA_TEX04_TA_COMPONENT Register REG0_TEX04_TA_TEX04_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_TA_TEX04_TA_COMPONENT 0x4000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_TA_TEX04_TA_COMPONENT 0x18004000u

/*! Register Reset Value */
#define REG0_TEX04_TA_TEX04_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TEX04_TA_TEX04_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TEX04_TA_TEX04_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TEX04_TA_TEX04_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TEX04_TA_TEX04_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TEX04_TA_TEX04_TA_CORE Register REG0_TEX04_TA_TEX04_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_TA_TEX04_TA_CORE 0x4018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_TA_TEX04_TA_CORE 0x18004018u

/*! Register Reset Value */
#define REG0_TEX04_TA_TEX04_TA_CORE_RST 0x000050C50F040001u

/*! Field REV_CODE - rev_code */
#define REG0_TEX04_TA_TEX04_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TEX04_TA_TEX04_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TEX04_TA_TEX04_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TEX04_TA_TEX04_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TEX04_TA_TEX04_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TEX04_TA_TEX04_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL Register REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL 0x4020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL 0x18004020u

/*! Register Reset Value */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TEX04_TA_TEX04_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TEX04_TA_TEX04_TA_AGENT_STATUS Register REG0_TEX04_TA_TEX04_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS 0x4028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_TA_TEX04_TA_AGENT_STATUS 0x18004028u

/*! Register Reset Value */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TEX04_TA_TEX04_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TEX04_TA_TEX04_TA_ERROR_LOG Register REG0_TEX04_TA_TEX04_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG 0x4058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_TA_TEX04_TA_ERROR_LOG 0x18004058u

/*! Register Reset Value */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TEX04_TA_TEX04_TA_ERROR_LOG_ADDR Register REG0_TEX04_TA_TEX04_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG_ADDR 0x4060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_TA_TEX04_TA_ERROR_LOG_ADDR 0x18004060u

/*! Register Reset Value */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TEX04_TA_TEX04_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TEX04_TA_TEX04_TA_BANDWIDTH_0 Register REG0_TEX04_TA_TEX04_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_0 0x4100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_TA_TEX04_TA_BANDWIDTH_0 0x18004100u

/*! Register Reset Value */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TEX04_TA_TEX04_TA_BANDWIDTH_1 Register REG0_TEX04_TA_TEX04_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_1 0x4108
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_TA_TEX04_TA_BANDWIDTH_1 0x18004108u

/*! Register Reset Value */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TEX04_TA_TEX04_TA_BANDWIDTH_2 Register REG0_TEX04_TA_TEX04_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_2 0x4110
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_TA_TEX04_TA_BANDWIDTH_2 0x18004110u

/*! Register Reset Value */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TEX04_TA_TEX04_TA_BANDWIDTH_3 Register REG0_TEX04_TA_TEX04_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_3 0x4118
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_TA_TEX04_TA_BANDWIDTH_3 0x18004118u

/*! Register Reset Value */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TEX04_TA_TEX04_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0 Register REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0 0x4200
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0 0x18004200u

/*! Register Reset Value */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TEX04_TA_TEX04_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDDES3_IA_IDMADES3_IA_COMPONENT Register REG0_IDDES3_IA_IDMADES3_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDDES3_IA_IDMADES3_IA_COMPONENT 0x4400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDDES3_IA_IDMADES3_IA_COMPONENT 0x18004400u

/*! Register Reset Value */
#define REG0_IDDES3_IA_IDMADES3_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IDDES3_IA_IDMADES3_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IDDES3_IA_IDMADES3_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IDDES3_IA_IDMADES3_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IDDES3_IA_IDMADES3_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IDDES3_IA_IDMADES3_IA_CORE Register REG0_IDDES3_IA_IDMADES3_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDDES3_IA_IDMADES3_IA_CORE 0x4418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDDES3_IA_IDMADES3_IA_CORE 0x18004418u

/*! Register Reset Value */
#define REG0_IDDES3_IA_IDMADES3_IA_CORE_RST 0x000050C5000C0001u

/*! Field REV_CODE - rev_code */
#define REG0_IDDES3_IA_IDMADES3_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IDDES3_IA_IDMADES3_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IDDES3_IA_IDMADES3_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IDDES3_IA_IDMADES3_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDDES3_IA_IDMADES3_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDDES3_IA_IDMADES3_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL Register REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL 0x4420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL 0x18004420u

/*! Register Reset Value */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS Register REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS 0x4428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS 0x18004428u

/*! Register Reset Value */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDDES3_IA_IDMADES3_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG Register REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG 0x4458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG 0x18004458u

/*! Register Reset Value */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_ADDR Register REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_ADDR 0x4460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_ADDR 0x18004460u

/*! Register Reset Value */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_ADDR_ADDR_POS 3
/*! Field ADDR - addr */
#define REG0_IDDES3_IA_IDMADES3_IA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFF8u

/*! @} */

/*! \defgroup REG0_IDDES3_IA_IDMADES3_IA_ADDR_FILL_IN Register REG0_IDDES3_IA_IDMADES3_IA_ADDR_FILL_IN - addr_fill_in */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDDES3_IA_IDMADES3_IA_ADDR_FILL_IN 0x4470
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDDES3_IA_IDMADES3_IA_ADDR_FILL_IN 0x18004470u

/*! Register Reset Value */
#define REG0_IDDES3_IA_IDMADES3_IA_ADDR_FILL_IN_RST 0x0000000000000000u

/*! Field VALUE - value */
#define REG0_IDDES3_IA_IDMADES3_IA_ADDR_FILL_IN_VALUE_POS 32
/*! Field VALUE - value */
#define REG0_IDDES3_IA_IDMADES3_IA_ADDR_FILL_IN_VALUE_MASK 0x100000000u

/*! @} */

/*! \defgroup REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0 Register REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0 0x4500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0 0x18004500u

/*! Register Reset Value */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDDES3_IA_IDMADES3_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDMAR3_IA_IDMAR3_IA_COMPONENT Register REG0_IDMAR3_IA_IDMAR3_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR3_IA_IDMAR3_IA_COMPONENT 0x4800
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR3_IA_IDMAR3_IA_COMPONENT 0x18004800u

/*! Register Reset Value */
#define REG0_IDMAR3_IA_IDMAR3_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IDMAR3_IA_IDMAR3_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IDMAR3_IA_IDMAR3_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IDMAR3_IA_IDMAR3_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IDMAR3_IA_IDMAR3_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IDMAR3_IA_IDMAR3_IA_CORE Register REG0_IDMAR3_IA_IDMAR3_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR3_IA_IDMAR3_IA_CORE 0x4818
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR3_IA_IDMAR3_IA_CORE 0x18004818u

/*! Register Reset Value */
#define REG0_IDMAR3_IA_IDMAR3_IA_CORE_RST 0x000050C5000D0001u

/*! Field REV_CODE - rev_code */
#define REG0_IDMAR3_IA_IDMAR3_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IDMAR3_IA_IDMAR3_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IDMAR3_IA_IDMAR3_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IDMAR3_IA_IDMAR3_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMAR3_IA_IDMAR3_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMAR3_IA_IDMAR3_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL Register REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL 0x4820
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL 0x18004820u

/*! Register Reset Value */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS Register REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS 0x4828
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS 0x18004828u

/*! Register Reset Value */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMAR3_IA_IDMAR3_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG Register REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG 0x4858
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG 0x18004858u

/*! Register Reset Value */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_ADDR Register REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_ADDR 0x4860
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_ADDR 0x18004860u

/*! Register Reset Value */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_ADDR_ADDR_POS 3
/*! Field ADDR - addr */
#define REG0_IDMAR3_IA_IDMAR3_IA_ERROR_LOG_ADDR_ADDR_MASK 0x1FFFFFFF8u

/*! @} */

/*! \defgroup REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0 Register REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0 0x4900
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0 0x18004900u

/*! Register Reset Value */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMAR3_IA_IDMAR3_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDR2DES_IA_IDMARDES2_IA_COMPONENT Register REG0_IDR2DES_IA_IDMARDES2_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDR2DES_IA_IDMARDES2_IA_COMPONENT 0x4C00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDR2DES_IA_IDMARDES2_IA_COMPONENT 0x18004C00u

/*! Register Reset Value */
#define REG0_IDR2DES_IA_IDMARDES2_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IDR2DES_IA_IDMARDES2_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IDR2DES_IA_IDMARDES2_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IDR2DES_IA_IDMARDES2_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IDR2DES_IA_IDMARDES2_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IDR2DES_IA_IDMARDES2_IA_CORE Register REG0_IDR2DES_IA_IDMARDES2_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDR2DES_IA_IDMARDES2_IA_CORE 0x4C18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDR2DES_IA_IDMARDES2_IA_CORE 0x18004C18u

/*! Register Reset Value */
#define REG0_IDR2DES_IA_IDMARDES2_IA_CORE_RST 0x000050C501260001u

/*! Field REV_CODE - rev_code */
#define REG0_IDR2DES_IA_IDMARDES2_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IDR2DES_IA_IDMARDES2_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IDR2DES_IA_IDMARDES2_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IDR2DES_IA_IDMARDES2_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDR2DES_IA_IDMARDES2_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDR2DES_IA_IDMARDES2_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL Register REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL 0x4C20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL 0x18004C20u

/*! Register Reset Value */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS Register REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS 0x4C28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS 0x18004C28u

/*! Register Reset Value */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG Register REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG 0x4C58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG 0x18004C58u

/*! Register Reset Value */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_ADDR Register REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_ADDR 0x4C60
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_ADDR 0x18004C60u

/*! Register Reset Value */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_ADDR_ADDR_POS 3
/*! Field ADDR - addr */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFF8u

/*! @} */

/*! \defgroup REG0_IDR2DES_IA_IDMARDES2_IA_ADDR_FILL_IN Register REG0_IDR2DES_IA_IDMARDES2_IA_ADDR_FILL_IN - addr_fill_in */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ADDR_FILL_IN 0x4C70
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDR2DES_IA_IDMARDES2_IA_ADDR_FILL_IN 0x18004C70u

/*! Register Reset Value */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ADDR_FILL_IN_RST 0x0000000000000000u

/*! Field VALUE - value */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ADDR_FILL_IN_VALUE_POS 32
/*! Field VALUE - value */
#define REG0_IDR2DES_IA_IDMARDES2_IA_ADDR_FILL_IN_VALUE_MASK 0x100000000u

/*! @} */

/*! \defgroup REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0 Register REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0 0x4D00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0 0x18004D00u

/*! Register Reset Value */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDR2DES_IA_IDMARDES2_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_ITEP_IA_ITEP_IA_COMPONENT Register REG0_ITEP_IA_ITEP_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_ITEP_IA_ITEP_IA_COMPONENT 0x5000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_ITEP_IA_ITEP_IA_COMPONENT 0x18005000u

/*! Register Reset Value */
#define REG0_ITEP_IA_ITEP_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_ITEP_IA_ITEP_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_ITEP_IA_ITEP_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_ITEP_IA_ITEP_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_ITEP_IA_ITEP_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_ITEP_IA_ITEP_IA_CORE Register REG0_ITEP_IA_ITEP_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_ITEP_IA_ITEP_IA_CORE 0x5018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_ITEP_IA_ITEP_IA_CORE 0x18005018u

/*! Register Reset Value */
#define REG0_ITEP_IA_ITEP_IA_CORE_RST 0x0000CAFE006B0000u

/*! Field REV_CODE - rev_code */
#define REG0_ITEP_IA_ITEP_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_ITEP_IA_ITEP_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_ITEP_IA_ITEP_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_ITEP_IA_ITEP_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_ITEP_IA_ITEP_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_ITEP_IA_ITEP_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL Register REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL 0x5020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL 0x18005020u

/*! Register Reset Value */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_ITEP_IA_ITEP_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_ITEP_IA_ITEP_IA_AGENT_STATUS Register REG0_ITEP_IA_ITEP_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS 0x5028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_ITEP_IA_ITEP_IA_AGENT_STATUS 0x18005028u

/*! Register Reset Value */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_ITEP_IA_ITEP_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_ITEP_IA_ITEP_IA_ERROR_LOG Register REG0_ITEP_IA_ITEP_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG 0x5058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_ITEP_IA_ITEP_IA_ERROR_LOG 0x18005058u

/*! Register Reset Value */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_ITEP_IA_ITEP_IA_ERROR_LOG_ADDR Register REG0_ITEP_IA_ITEP_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_ADDR 0x5060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_ITEP_IA_ITEP_IA_ERROR_LOG_ADDR 0x18005060u

/*! Register Reset Value */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_ADDR_ADDR_POS 2
/*! Field ADDR - addr */
#define REG0_ITEP_IA_ITEP_IA_ERROR_LOG_ADDR_ADDR_MASK 0x1FFFFFFFCu

/*! @} */

/*! \defgroup REG0_ITEP_IA_ITEP_IA_CORE_FLAG Register REG0_ITEP_IA_ITEP_IA_CORE_FLAG - core_flag */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_ITEP_IA_ITEP_IA_CORE_FLAG 0x5068
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_ITEP_IA_ITEP_IA_CORE_FLAG 0x18005068u

/*! Register Reset Value */
#define REG0_ITEP_IA_ITEP_IA_CORE_FLAG_RST 0x0000000000000000u

/*! Field ENABLE_0 - enable_0 */
#define REG0_ITEP_IA_ITEP_IA_CORE_FLAG_ENABLE_0_POS 0
/*! Field ENABLE_0 - enable_0 */
#define REG0_ITEP_IA_ITEP_IA_CORE_FLAG_ENABLE_0_MASK 0x1u

/*! Field ENABLE_1 - enable_1 */
#define REG0_ITEP_IA_ITEP_IA_CORE_FLAG_ENABLE_1_POS 1
/*! Field ENABLE_1 - enable_1 */
#define REG0_ITEP_IA_ITEP_IA_CORE_FLAG_ENABLE_1_MASK 0x2u

/*! Field ENABLE_2 - enable_2 */
#define REG0_ITEP_IA_ITEP_IA_CORE_FLAG_ENABLE_2_POS 2
/*! Field ENABLE_2 - enable_2 */
#define REG0_ITEP_IA_ITEP_IA_CORE_FLAG_ENABLE_2_MASK 0x4u

/*! Field ENABLE_3 - enable_3 */
#define REG0_ITEP_IA_ITEP_IA_CORE_FLAG_ENABLE_3_POS 3
/*! Field ENABLE_3 - enable_3 */
#define REG0_ITEP_IA_ITEP_IA_CORE_FLAG_ENABLE_3_MASK 0x8u

/*! @} */

/*! \defgroup REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0 Register REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0 0x5100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0 0x18005100u

/*! Register Reset Value */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_ITEP_IA_ITEP_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDMAR2_TA_TDMAR2_TA_COMPONENT Register REG0_IDMAR2_TA_TDMAR2_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_TA_TDMAR2_TA_COMPONENT 0x5400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_TA_TDMAR2_TA_COMPONENT 0x18005400u

/*! Register Reset Value */
#define REG0_IDMAR2_TA_TDMAR2_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_IDMAR2_TA_TDMAR2_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IDMAR2_TA_TDMAR2_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IDMAR2_TA_TDMAR2_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IDMAR2_TA_TDMAR2_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IDMAR2_TA_TDMAR2_TA_CORE Register REG0_IDMAR2_TA_TDMAR2_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_TA_TDMAR2_TA_CORE 0x5418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_TA_TDMAR2_TA_CORE 0x18005418u

/*! Register Reset Value */
#define REG0_IDMAR2_TA_TDMAR2_TA_CORE_RST 0x000088C300140001u

/*! Field REV_CODE - rev_code */
#define REG0_IDMAR2_TA_TDMAR2_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IDMAR2_TA_TDMAR2_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IDMAR2_TA_TDMAR2_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IDMAR2_TA_TDMAR2_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMAR2_TA_TDMAR2_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMAR2_TA_TDMAR2_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL Register REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL 0x5420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL 0x18005420u

/*! Register Reset Value */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS Register REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS 0x5428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS 0x18005428u

/*! Register Reset Value */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_IDMAR2_TA_TDMAR2_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG Register REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG 0x5458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG 0x18005458u

/*! Register Reset Value */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_ADDR Register REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_ADDR 0x5460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_ADDR 0x18005460u

/*! Register Reset Value */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_IDMAR2_TA_TDMAR2_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_0 Register REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_0 0x5500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_0 0x18005500u

/*! Register Reset Value */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_1 Register REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_1 0x5508
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_1 0x18005508u

/*! Register Reset Value */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_2 Register REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_2 0x5510
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_2 0x18005510u

/*! Register Reset Value */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_3 Register REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_3 0x5518
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_3 0x18005518u

/*! Register Reset Value */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_IDMAR2_TA_TDMAR2_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0 Register REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0 0x5600
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0 0x18005600u

/*! Register Reset Value */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_IDMAR2_TA_TDMAR2_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TQSPIC_TA_TQSPIC_TA_COMPONENT Register REG0_TQSPIC_TA_TQSPIC_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_TA_TQSPIC_TA_COMPONENT 0x5800
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_TA_TQSPIC_TA_COMPONENT 0x18005800u

/*! Register Reset Value */
#define REG0_TQSPIC_TA_TQSPIC_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TQSPIC_TA_TQSPIC_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TQSPIC_TA_TQSPIC_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TQSPIC_TA_TQSPIC_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TQSPIC_TA_TQSPIC_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TQSPIC_TA_TQSPIC_TA_CORE Register REG0_TQSPIC_TA_TQSPIC_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_TA_TQSPIC_TA_CORE 0x5818
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_TA_TQSPIC_TA_CORE 0x18005818u

/*! Register Reset Value */
#define REG0_TQSPIC_TA_TQSPIC_TA_CORE_RST 0x000050C501380001u

/*! Field REV_CODE - rev_code */
#define REG0_TQSPIC_TA_TQSPIC_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TQSPIC_TA_TQSPIC_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TQSPIC_TA_TQSPIC_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TQSPIC_TA_TQSPIC_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TQSPIC_TA_TQSPIC_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TQSPIC_TA_TQSPIC_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL Register REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL 0x5820
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL 0x18005820u

/*! Register Reset Value */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS Register REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS 0x5828
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS 0x18005828u

/*! Register Reset Value */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TQSPIC_TA_TQSPIC_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG Register REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG 0x5858
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG 0x18005858u

/*! Register Reset Value */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_REQ_INFO_MASK 0xF00000000u

/*! @} */

/*! \defgroup REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_ADDR Register REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_ADDR 0x5860
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_ADDR 0x18005860u

/*! Register Reset Value */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TQSPIC_TA_TQSPIC_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFu

/*! @} */

/*! \defgroup REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_0 Register REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_0 0x5900
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_0 0x18005900u

/*! Register Reset Value */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_1 Register REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_1 0x5908
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_1 0x18005908u

/*! Register Reset Value */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_2 Register REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_2 0x5910
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_2 0x18005910u

/*! Register Reset Value */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_3 Register REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_3 0x5918
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_3 0x18005918u

/*! Register Reset Value */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TQSPIC_TA_TQSPIC_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0 Register REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0 0x5A00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0 0x18005A00u

/*! Register Reset Value */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TQSPIC_TA_TQSPIC_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IP31G_IA_IP31G_IA_COMPONENT Register REG0_IP31G_IA_IP31G_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IP31G_IA_IP31G_IA_COMPONENT 0x5C00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IP31G_IA_IP31G_IA_COMPONENT 0x18005C00u

/*! Register Reset Value */
#define REG0_IP31G_IA_IP31G_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IP31G_IA_IP31G_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IP31G_IA_IP31G_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IP31G_IA_IP31G_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IP31G_IA_IP31G_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IP31G_IA_IP31G_IA_CORE Register REG0_IP31G_IA_IP31G_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IP31G_IA_IP31G_IA_CORE 0x5C18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IP31G_IA_IP31G_IA_CORE 0x18005C18u

/*! Register Reset Value */
#define REG0_IP31G_IA_IP31G_IA_CORE_RST 0x0000CAFE001B0000u

/*! Field REV_CODE - rev_code */
#define REG0_IP31G_IA_IP31G_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IP31G_IA_IP31G_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IP31G_IA_IP31G_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IP31G_IA_IP31G_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IP31G_IA_IP31G_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IP31G_IA_IP31G_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL Register REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL 0x5C20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL 0x18005C20u

/*! Register Reset Value */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IP31G_IA_IP31G_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IP31G_IA_IP31G_IA_AGENT_STATUS Register REG0_IP31G_IA_IP31G_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS 0x5C28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IP31G_IA_IP31G_IA_AGENT_STATUS 0x18005C28u

/*! Register Reset Value */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IP31G_IA_IP31G_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IP31G_IA_IP31G_IA_ERROR_LOG Register REG0_IP31G_IA_IP31G_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG 0x5C58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IP31G_IA_IP31G_IA_ERROR_LOG 0x18005C58u

/*! Register Reset Value */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IP31G_IA_IP31G_IA_ERROR_LOG_ADDR Register REG0_IP31G_IA_IP31G_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_ADDR 0x5C60
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IP31G_IA_IP31G_IA_ERROR_LOG_ADDR 0x18005C60u

/*! Register Reset Value */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_ADDR_ADDR_POS 2
/*! Field ADDR - addr */
#define REG0_IP31G_IA_IP31G_IA_ERROR_LOG_ADDR_ADDR_MASK 0x1FFFFFFFCu

/*! @} */

/*! \defgroup REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0 Register REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0 0x5D00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0 0x18005D00u

/*! Register Reset Value */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IP31G_IA_IP31G_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IL2_IA_IL2_IA_COMPONENT Register REG0_IL2_IA_IL2_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IL2_IA_IL2_IA_COMPONENT 0x6000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IL2_IA_IL2_IA_COMPONENT 0x18006000u

/*! Register Reset Value */
#define REG0_IL2_IA_IL2_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IL2_IA_IL2_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IL2_IA_IL2_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IL2_IA_IL2_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IL2_IA_IL2_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IL2_IA_IL2_IA_CORE Register REG0_IL2_IA_IL2_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IL2_IA_IL2_IA_CORE 0x6018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IL2_IA_IL2_IA_CORE 0x18006018u

/*! Register Reset Value */
#define REG0_IL2_IA_IL2_IA_CORE_RST 0x000050C5006A0001u

/*! Field REV_CODE - rev_code */
#define REG0_IL2_IA_IL2_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IL2_IA_IL2_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IL2_IA_IL2_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IL2_IA_IL2_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IL2_IA_IL2_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IL2_IA_IL2_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IL2_IA_IL2_IA_AGENT_CONTROL Register REG0_IL2_IA_IL2_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL 0x6020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IL2_IA_IL2_IA_AGENT_CONTROL 0x18006020u

/*! Register Reset Value */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IL2_IA_IL2_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IL2_IA_IL2_IA_AGENT_STATUS Register REG0_IL2_IA_IL2_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS 0x6028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IL2_IA_IL2_IA_AGENT_STATUS 0x18006028u

/*! Register Reset Value */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IL2_IA_IL2_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IL2_IA_IL2_IA_ERROR_LOG Register REG0_IL2_IA_IL2_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG 0x6058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IL2_IA_IL2_IA_ERROR_LOG 0x18006058u

/*! Register Reset Value */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IL2_IA_IL2_IA_ERROR_LOG_ADDR Register REG0_IL2_IA_IL2_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_ADDR 0x6060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IL2_IA_IL2_IA_ERROR_LOG_ADDR 0x18006060u

/*! Register Reset Value */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_ADDR_ADDR_POS 3
/*! Field ADDR - addr */
#define REG0_IL2_IA_IL2_IA_ERROR_LOG_ADDR_ADDR_MASK 0x1FFFFFFF8u

/*! @} */

/*! \defgroup REG0_IL2_IA_IL2_IA_CORE_FLAG Register REG0_IL2_IA_IL2_IA_CORE_FLAG - core_flag */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IL2_IA_IL2_IA_CORE_FLAG 0x6068
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IL2_IA_IL2_IA_CORE_FLAG 0x18006068u

/*! Register Reset Value */
#define REG0_IL2_IA_IL2_IA_CORE_FLAG_RST 0x0000000000000000u

/*! Field ENABLE_0 - enable_0 */
#define REG0_IL2_IA_IL2_IA_CORE_FLAG_ENABLE_0_POS 0
/*! Field ENABLE_0 - enable_0 */
#define REG0_IL2_IA_IL2_IA_CORE_FLAG_ENABLE_0_MASK 0x1u

/*! Field ENABLE_1 - enable_1 */
#define REG0_IL2_IA_IL2_IA_CORE_FLAG_ENABLE_1_POS 1
/*! Field ENABLE_1 - enable_1 */
#define REG0_IL2_IA_IL2_IA_CORE_FLAG_ENABLE_1_MASK 0x2u

/*! Field ENABLE_2 - enable_2 */
#define REG0_IL2_IA_IL2_IA_CORE_FLAG_ENABLE_2_POS 2
/*! Field ENABLE_2 - enable_2 */
#define REG0_IL2_IA_IL2_IA_CORE_FLAG_ENABLE_2_MASK 0x4u

/*! Field ENABLE_3 - enable_3 */
#define REG0_IL2_IA_IL2_IA_CORE_FLAG_ENABLE_3_POS 3
/*! Field ENABLE_3 - enable_3 */
#define REG0_IL2_IA_IL2_IA_CORE_FLAG_ENABLE_3_MASK 0x8u

/*! @} */

/*! \defgroup REG0_IL2_IA_IL2_IA_BANDWIDTH_0 Register REG0_IL2_IA_IL2_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0 0x6100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IL2_IA_IL2_IA_BANDWIDTH_0 0x18006100u

/*! Register Reset Value */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IL2_IA_IL2_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IPON_IA_IPON_IA_COMPONENT Register REG0_IPON_IA_IPON_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPON_IA_IPON_IA_COMPONENT 0x6400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPON_IA_IPON_IA_COMPONENT 0x18006400u

/*! Register Reset Value */
#define REG0_IPON_IA_IPON_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IPON_IA_IPON_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IPON_IA_IPON_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IPON_IA_IPON_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IPON_IA_IPON_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IPON_IA_IPON_IA_CORE Register REG0_IPON_IA_IPON_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPON_IA_IPON_IA_CORE 0x6418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPON_IA_IPON_IA_CORE 0x18006418u

/*! Register Reset Value */
#define REG0_IPON_IA_IPON_IA_CORE_RST 0x000050C501030001u

/*! Field REV_CODE - rev_code */
#define REG0_IPON_IA_IPON_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IPON_IA_IPON_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IPON_IA_IPON_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IPON_IA_IPON_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IPON_IA_IPON_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IPON_IA_IPON_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IPON_IA_IPON_IA_AGENT_CONTROL Register REG0_IPON_IA_IPON_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL 0x6420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPON_IA_IPON_IA_AGENT_CONTROL 0x18006420u

/*! Register Reset Value */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IPON_IA_IPON_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IPON_IA_IPON_IA_AGENT_STATUS Register REG0_IPON_IA_IPON_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS 0x6428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPON_IA_IPON_IA_AGENT_STATUS 0x18006428u

/*! Register Reset Value */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IPON_IA_IPON_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IPON_IA_IPON_IA_ERROR_LOG Register REG0_IPON_IA_IPON_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG 0x6458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPON_IA_IPON_IA_ERROR_LOG 0x18006458u

/*! Register Reset Value */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IPON_IA_IPON_IA_ERROR_LOG_ADDR Register REG0_IPON_IA_IPON_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_ADDR 0x6460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPON_IA_IPON_IA_ERROR_LOG_ADDR 0x18006460u

/*! Register Reset Value */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_ADDR_ADDR_POS 2
/*! Field ADDR - addr */
#define REG0_IPON_IA_IPON_IA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFCu

/*! @} */

/*! \defgroup REG0_IPON_IA_IPON_IA_ADDR_FILL_IN Register REG0_IPON_IA_IPON_IA_ADDR_FILL_IN - addr_fill_in */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPON_IA_IPON_IA_ADDR_FILL_IN 0x6470
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPON_IA_IPON_IA_ADDR_FILL_IN 0x18006470u

/*! Register Reset Value */
#define REG0_IPON_IA_IPON_IA_ADDR_FILL_IN_RST 0x0000000000000000u

/*! Field VALUE - value */
#define REG0_IPON_IA_IPON_IA_ADDR_FILL_IN_VALUE_POS 32
/*! Field VALUE - value */
#define REG0_IPON_IA_IPON_IA_ADDR_FILL_IN_VALUE_MASK 0x100000000u

/*! @} */

/*! \defgroup REG0_IPON_IA_IPON_IA_BANDWIDTH_0 Register REG0_IPON_IA_IPON_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0 0x6500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPON_IA_IPON_IA_BANDWIDTH_0 0x18006500u

/*! Register Reset Value */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IPON_IA_IPON_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPON_TA_TPON_TA_COMPONENT Register REG0_TPON_TA_TPON_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_TA_TPON_TA_COMPONENT 0x6800
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_TA_TPON_TA_COMPONENT 0x18006800u

/*! Register Reset Value */
#define REG0_TPON_TA_TPON_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TPON_TA_TPON_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TPON_TA_TPON_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TPON_TA_TPON_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TPON_TA_TPON_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TPON_TA_TPON_TA_CORE Register REG0_TPON_TA_TPON_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_TA_TPON_TA_CORE 0x6818
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_TA_TPON_TA_CORE 0x18006818u

/*! Register Reset Value */
#define REG0_TPON_TA_TPON_TA_CORE_RST 0x000088C300700001u

/*! Field REV_CODE - rev_code */
#define REG0_TPON_TA_TPON_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TPON_TA_TPON_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TPON_TA_TPON_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TPON_TA_TPON_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPON_TA_TPON_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPON_TA_TPON_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TPON_TA_TPON_TA_AGENT_CONTROL Register REG0_TPON_TA_TPON_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL 0x6820
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_TA_TPON_TA_AGENT_CONTROL 0x18006820u

/*! Register Reset Value */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TPON_TA_TPON_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPON_TA_TPON_TA_AGENT_STATUS Register REG0_TPON_TA_TPON_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS 0x6828
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_TA_TPON_TA_AGENT_STATUS 0x18006828u

/*! Register Reset Value */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TPON_TA_TPON_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPON_TA_TPON_TA_ERROR_LOG Register REG0_TPON_TA_TPON_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG 0x6858
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_TA_TPON_TA_ERROR_LOG 0x18006858u

/*! Register Reset Value */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TPON_TA_TPON_TA_ERROR_LOG_ADDR Register REG0_TPON_TA_TPON_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG_ADDR 0x6860
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_TA_TPON_TA_ERROR_LOG_ADDR 0x18006860u

/*! Register Reset Value */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TPON_TA_TPON_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TPON_TA_TPON_TA_BANDWIDTH_0 Register REG0_TPON_TA_TPON_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_0 0x6900
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_TA_TPON_TA_BANDWIDTH_0 0x18006900u

/*! Register Reset Value */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPON_TA_TPON_TA_BANDWIDTH_1 Register REG0_TPON_TA_TPON_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_1 0x6908
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_TA_TPON_TA_BANDWIDTH_1 0x18006908u

/*! Register Reset Value */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPON_TA_TPON_TA_BANDWIDTH_2 Register REG0_TPON_TA_TPON_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_2 0x6910
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_TA_TPON_TA_BANDWIDTH_2 0x18006910u

/*! Register Reset Value */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPON_TA_TPON_TA_BANDWIDTH_3 Register REG0_TPON_TA_TPON_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_3 0x6918
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_TA_TPON_TA_BANDWIDTH_3 0x18006918u

/*! Register Reset Value */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPON_TA_TPON_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0 Register REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0 0x6A00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0 0x18006A00u

/*! Register Reset Value */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPON_TA_TPON_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDT1DES_IA_IDMATDES1_IA_COMPONENT Register REG0_IDT1DES_IA_IDMATDES1_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT1DES_IA_IDMATDES1_IA_COMPONENT 0x6C00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT1DES_IA_IDMATDES1_IA_COMPONENT 0x18006C00u

/*! Register Reset Value */
#define REG0_IDT1DES_IA_IDMATDES1_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IDT1DES_IA_IDMATDES1_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IDT1DES_IA_IDMATDES1_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IDT1DES_IA_IDMATDES1_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IDT1DES_IA_IDMATDES1_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IDT1DES_IA_IDMATDES1_IA_CORE Register REG0_IDT1DES_IA_IDMATDES1_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT1DES_IA_IDMATDES1_IA_CORE 0x6C18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT1DES_IA_IDMATDES1_IA_CORE 0x18006C18u

/*! Register Reset Value */
#define REG0_IDT1DES_IA_IDMATDES1_IA_CORE_RST 0x000050C501230001u

/*! Field REV_CODE - rev_code */
#define REG0_IDT1DES_IA_IDMATDES1_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IDT1DES_IA_IDMATDES1_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IDT1DES_IA_IDMATDES1_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IDT1DES_IA_IDMATDES1_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDT1DES_IA_IDMATDES1_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDT1DES_IA_IDMATDES1_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL Register REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL 0x6C20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL 0x18006C20u

/*! Register Reset Value */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS Register REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS 0x6C28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS 0x18006C28u

/*! Register Reset Value */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG Register REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG 0x6C58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG 0x18006C58u

/*! Register Reset Value */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_ADDR Register REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_ADDR 0x6C60
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_ADDR 0x18006C60u

/*! Register Reset Value */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_ADDR_ADDR_POS 3
/*! Field ADDR - addr */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFF8u

/*! @} */

/*! \defgroup REG0_IDT1DES_IA_IDMATDES1_IA_ADDR_FILL_IN Register REG0_IDT1DES_IA_IDMATDES1_IA_ADDR_FILL_IN - addr_fill_in */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ADDR_FILL_IN 0x6C70
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT1DES_IA_IDMATDES1_IA_ADDR_FILL_IN 0x18006C70u

/*! Register Reset Value */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ADDR_FILL_IN_RST 0x0000000000000000u

/*! Field VALUE - value */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ADDR_FILL_IN_VALUE_POS 32
/*! Field VALUE - value */
#define REG0_IDT1DES_IA_IDMATDES1_IA_ADDR_FILL_IN_VALUE_MASK 0x100000000u

/*! @} */

/*! \defgroup REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0 Register REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0 0x6D00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0 0x18006D00u

/*! Register Reset Value */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDT1DES_IA_IDMATDES1_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDDR_TA_TDDR_TA_COMPONENT Register REG0_TDDR_TA_TDDR_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_TA_TDDR_TA_COMPONENT 0x7000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_TA_TDDR_TA_COMPONENT 0x18007000u

/*! Register Reset Value */
#define REG0_TDDR_TA_TDDR_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TDDR_TA_TDDR_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TDDR_TA_TDDR_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TDDR_TA_TDDR_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TDDR_TA_TDDR_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TDDR_TA_TDDR_TA_CORE Register REG0_TDDR_TA_TDDR_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_TA_TDDR_TA_CORE 0x7018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_TA_TDDR_TA_CORE 0x18007018u

/*! Register Reset Value */
#define REG0_TDDR_TA_TDDR_TA_CORE_RST 0x000050C500650003u

/*! Field REV_CODE - rev_code */
#define REG0_TDDR_TA_TDDR_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TDDR_TA_TDDR_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TDDR_TA_TDDR_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TDDR_TA_TDDR_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TDDR_TA_TDDR_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TDDR_TA_TDDR_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL Register REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL 0x7020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL 0x18007020u

/*! Register Reset Value */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TDDR_TA_TDDR_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TDDR_TA_TDDR_TA_AGENT_STATUS Register REG0_TDDR_TA_TDDR_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS 0x7028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_TA_TDDR_TA_AGENT_STATUS 0x18007028u

/*! Register Reset Value */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TDDR_TA_TDDR_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TDDR_TA_TDDR_TA_ERROR_LOG Register REG0_TDDR_TA_TDDR_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG 0x7058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_TA_TDDR_TA_ERROR_LOG 0x18007058u

/*! Register Reset Value */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG_REQ_INFO_MASK 0x7F00000000u

/*! @} */

/*! \defgroup REG0_TDDR_TA_TDDR_TA_ERROR_LOG_ADDR Register REG0_TDDR_TA_TDDR_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG_ADDR 0x7060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_TA_TDDR_TA_ERROR_LOG_ADDR 0x18007060u

/*! Register Reset Value */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TDDR_TA_TDDR_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TDDR_TA_TDDR_TA_BANDWIDTH_0 Register REG0_TDDR_TA_TDDR_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_0 0x7100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_TA_TDDR_TA_BANDWIDTH_0 0x18007100u

/*! Register Reset Value */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDDR_TA_TDDR_TA_BANDWIDTH_1 Register REG0_TDDR_TA_TDDR_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_1 0x7108
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_TA_TDDR_TA_BANDWIDTH_1 0x18007108u

/*! Register Reset Value */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDDR_TA_TDDR_TA_BANDWIDTH_2 Register REG0_TDDR_TA_TDDR_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_2 0x7110
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_TA_TDDR_TA_BANDWIDTH_2 0x18007110u

/*! Register Reset Value */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDDR_TA_TDDR_TA_BANDWIDTH_3 Register REG0_TDDR_TA_TDDR_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_3 0x7118
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_TA_TDDR_TA_BANDWIDTH_3 0x18007118u

/*! Register Reset Value */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TDDR_TA_TDDR_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0 Register REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0 0x7200
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0 0x18007200u

/*! Register Reset Value */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1 Register REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1 - alloc_limit_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1 0x7208
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1 0x18007208u

/*! Register Reset Value */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_RST 0x0000000000000000u

/*! Field MIN_VALUE_4 - min_value_4 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MIN_VALUE_4_POS 0
/*! Field MIN_VALUE_4 - min_value_4 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MIN_VALUE_4_MASK 0xFFu

/*! Field MAX_VALUE_4 - max_value_4 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MAX_VALUE_4_POS 8
/*! Field MAX_VALUE_4 - max_value_4 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MAX_VALUE_4_MASK 0xFF00u

/*! Field MIN_VALUE_5 - min_value_5 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MIN_VALUE_5_POS 16
/*! Field MIN_VALUE_5 - min_value_5 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MIN_VALUE_5_MASK 0xFF0000u

/*! Field MAX_VALUE_5 - max_value_5 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MAX_VALUE_5_POS 24
/*! Field MAX_VALUE_5 - max_value_5 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MAX_VALUE_5_MASK 0xFF000000u

/*! Field MIN_VALUE_6 - min_value_6 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MIN_VALUE_6_POS 32
/*! Field MIN_VALUE_6 - min_value_6 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MIN_VALUE_6_MASK 0xFF00000000u

/*! Field MAX_VALUE_6 - max_value_6 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MAX_VALUE_6_POS 40
/*! Field MAX_VALUE_6 - max_value_6 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MAX_VALUE_6_MASK 0xFF0000000000u

/*! Field MIN_VALUE_7 - min_value_7 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MIN_VALUE_7_POS 48
/*! Field MIN_VALUE_7 - min_value_7 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MIN_VALUE_7_MASK 0xFF000000000000u

/*! Field MAX_VALUE_7 - max_value_7 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MAX_VALUE_7_POS 56
/*! Field MAX_VALUE_7 - max_value_7 */
#define REG0_TDDR_TA_TDDR_TA_ALLOC_LIMIT_1_MAX_VALUE_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDMAR1_IA_IDMAR1_IA_COMPONENT Register REG0_IDMAR1_IA_IDMAR1_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR1_IA_IDMAR1_IA_COMPONENT 0x7400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR1_IA_IDMAR1_IA_COMPONENT 0x18007400u

/*! Register Reset Value */
#define REG0_IDMAR1_IA_IDMAR1_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IDMAR1_IA_IDMAR1_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IDMAR1_IA_IDMAR1_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IDMAR1_IA_IDMAR1_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IDMAR1_IA_IDMAR1_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IDMAR1_IA_IDMAR1_IA_CORE Register REG0_IDMAR1_IA_IDMAR1_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR1_IA_IDMAR1_IA_CORE 0x7418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR1_IA_IDMAR1_IA_CORE 0x18007418u

/*! Register Reset Value */
#define REG0_IDMAR1_IA_IDMAR1_IA_CORE_RST 0x000050C500240001u

/*! Field REV_CODE - rev_code */
#define REG0_IDMAR1_IA_IDMAR1_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IDMAR1_IA_IDMAR1_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IDMAR1_IA_IDMAR1_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IDMAR1_IA_IDMAR1_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMAR1_IA_IDMAR1_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMAR1_IA_IDMAR1_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL Register REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL 0x7420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL 0x18007420u

/*! Register Reset Value */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS Register REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS 0x7428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS 0x18007428u

/*! Register Reset Value */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMAR1_IA_IDMAR1_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG Register REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG 0x7458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG 0x18007458u

/*! Register Reset Value */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_ADDR Register REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_ADDR 0x7460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_ADDR 0x18007460u

/*! Register Reset Value */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_ADDR_ADDR_POS 3
/*! Field ADDR - addr */
#define REG0_IDMAR1_IA_IDMAR1_IA_ERROR_LOG_ADDR_ADDR_MASK 0x1FFFFFFF8u

/*! @} */

/*! \defgroup REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0 Register REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0 0x7500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0 0x18007500u

/*! Register Reset Value */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMAR1_IA_IDMAR1_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDT2DES_IA_IDMATDES2_IA_COMPONENT Register REG0_IDT2DES_IA_IDMATDES2_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT2DES_IA_IDMATDES2_IA_COMPONENT 0x7800
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT2DES_IA_IDMATDES2_IA_COMPONENT 0x18007800u

/*! Register Reset Value */
#define REG0_IDT2DES_IA_IDMATDES2_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IDT2DES_IA_IDMATDES2_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IDT2DES_IA_IDMATDES2_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IDT2DES_IA_IDMATDES2_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IDT2DES_IA_IDMATDES2_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IDT2DES_IA_IDMATDES2_IA_CORE Register REG0_IDT2DES_IA_IDMATDES2_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT2DES_IA_IDMATDES2_IA_CORE 0x7818
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT2DES_IA_IDMATDES2_IA_CORE 0x18007818u

/*! Register Reset Value */
#define REG0_IDT2DES_IA_IDMATDES2_IA_CORE_RST 0x000050C501250001u

/*! Field REV_CODE - rev_code */
#define REG0_IDT2DES_IA_IDMATDES2_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IDT2DES_IA_IDMATDES2_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IDT2DES_IA_IDMATDES2_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IDT2DES_IA_IDMATDES2_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDT2DES_IA_IDMATDES2_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDT2DES_IA_IDMATDES2_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL Register REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL 0x7820
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL 0x18007820u

/*! Register Reset Value */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS Register REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS 0x7828
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS 0x18007828u

/*! Register Reset Value */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG Register REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG 0x7858
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG 0x18007858u

/*! Register Reset Value */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_ADDR Register REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_ADDR 0x7860
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_ADDR 0x18007860u

/*! Register Reset Value */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_ADDR_ADDR_POS 3
/*! Field ADDR - addr */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFF8u

/*! @} */

/*! \defgroup REG0_IDT2DES_IA_IDMATDES2_IA_ADDR_FILL_IN Register REG0_IDT2DES_IA_IDMATDES2_IA_ADDR_FILL_IN - addr_fill_in */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ADDR_FILL_IN 0x7870
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT2DES_IA_IDMATDES2_IA_ADDR_FILL_IN 0x18007870u

/*! Register Reset Value */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ADDR_FILL_IN_RST 0x0000000000000000u

/*! Field VALUE - value */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ADDR_FILL_IN_VALUE_POS 32
/*! Field VALUE - value */
#define REG0_IDT2DES_IA_IDMATDES2_IA_ADDR_FILL_IN_VALUE_MASK 0x100000000u

/*! @} */

/*! \defgroup REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0 Register REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0 0x7900
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0 0x18007900u

/*! Register Reset Value */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDT2DES_IA_IDMATDES2_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TGSWIP_TA_TGSWIP_TA_COMPONENT Register REG0_TGSWIP_TA_TGSWIP_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_TA_TGSWIP_TA_COMPONENT 0x7C00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_TA_TGSWIP_TA_COMPONENT 0x18007C00u

/*! Register Reset Value */
#define REG0_TGSWIP_TA_TGSWIP_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TGSWIP_TA_TGSWIP_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TGSWIP_TA_TGSWIP_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TGSWIP_TA_TGSWIP_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TGSWIP_TA_TGSWIP_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TGSWIP_TA_TGSWIP_TA_CORE Register REG0_TGSWIP_TA_TGSWIP_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_TA_TGSWIP_TA_CORE 0x7C18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_TA_TGSWIP_TA_CORE 0x18007C18u

/*! Register Reset Value */
#define REG0_TGSWIP_TA_TGSWIP_TA_CORE_RST 0x000050C500200001u

/*! Field REV_CODE - rev_code */
#define REG0_TGSWIP_TA_TGSWIP_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TGSWIP_TA_TGSWIP_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TGSWIP_TA_TGSWIP_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TGSWIP_TA_TGSWIP_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TGSWIP_TA_TGSWIP_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TGSWIP_TA_TGSWIP_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL Register REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL 0x7C20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL 0x18007C20u

/*! Register Reset Value */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS Register REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS 0x7C28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS 0x18007C28u

/*! Register Reset Value */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TGSWIP_TA_TGSWIP_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG Register REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG 0x7C58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG 0x18007C58u

/*! Register Reset Value */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_REQ_INFO_MASK 0xFFFFFFFF00000000u

/*! @} */

/*! \defgroup REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_ADDR Register REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_ADDR 0x7C60
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_ADDR 0x18007C60u

/*! Register Reset Value */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TGSWIP_TA_TGSWIP_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_0 Register REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_0 0x7D00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_0 0x18007D00u

/*! Register Reset Value */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_1 Register REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_1 0x7D08
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_1 0x18007D08u

/*! Register Reset Value */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_2 Register REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_2 0x7D10
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_2 0x18007D10u

/*! Register Reset Value */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_3 Register REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_3 0x7D18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_3 0x18007D18u

/*! Register Reset Value */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TGSWIP_TA_TGSWIP_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0 Register REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0 0x7E00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0 0x18007E00u

/*! Register Reset Value */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TGSWIP_TA_TGSWIP_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCTL_TA_TPCTL_TA_COMPONENT Register REG0_TPCTL_TA_TPCTL_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_TA_TPCTL_TA_COMPONENT 0x8000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_TA_TPCTL_TA_COMPONENT 0x18008000u

/*! Register Reset Value */
#define REG0_TPCTL_TA_TPCTL_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TPCTL_TA_TPCTL_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TPCTL_TA_TPCTL_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TPCTL_TA_TPCTL_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TPCTL_TA_TPCTL_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TPCTL_TA_TPCTL_TA_CORE Register REG0_TPCTL_TA_TPCTL_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_TA_TPCTL_TA_CORE 0x8018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_TA_TPCTL_TA_CORE 0x18008018u

/*! Register Reset Value */
#define REG0_TPCTL_TA_TPCTL_TA_CORE_RST 0x000050C500630001u

/*! Field REV_CODE - rev_code */
#define REG0_TPCTL_TA_TPCTL_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TPCTL_TA_TPCTL_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TPCTL_TA_TPCTL_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TPCTL_TA_TPCTL_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPCTL_TA_TPCTL_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPCTL_TA_TPCTL_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL Register REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL 0x8020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL 0x18008020u

/*! Register Reset Value */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS Register REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS 0x8028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS 0x18008028u

/*! Register Reset Value */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TPCTL_TA_TPCTL_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG Register REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG 0x8058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG 0x18008058u

/*! Register Reset Value */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_ADDR Register REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_ADDR 0x8060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_ADDR 0x18008060u

/*! Register Reset Value */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TPCTL_TA_TPCTL_TA_ERROR_LOG_ADDR_ADDR_MASK 0x7FFFu

/*! @} */

/*! \defgroup REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_0 Register REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_0 0x8100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_0 0x18008100u

/*! Register Reset Value */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_1 Register REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_1 0x8108
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_1 0x18008108u

/*! Register Reset Value */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_2 Register REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_2 0x8110
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_2 0x18008110u

/*! Register Reset Value */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_3 Register REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_3 0x8118
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_3 0x18008118u

/*! Register Reset Value */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPCTL_TA_TPCTL_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0 Register REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0 0x8200
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0 0x18008200u

/*! Register Reset Value */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPCTL_TA_TPCTL_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TQSPID_TA_TQSPID_TA_COMPONENT Register REG0_TQSPID_TA_TQSPID_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPID_TA_TQSPID_TA_COMPONENT 0x8400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPID_TA_TQSPID_TA_COMPONENT 0x18008400u

/*! Register Reset Value */
#define REG0_TQSPID_TA_TQSPID_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TQSPID_TA_TQSPID_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TQSPID_TA_TQSPID_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TQSPID_TA_TQSPID_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TQSPID_TA_TQSPID_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TQSPID_TA_TQSPID_TA_CORE Register REG0_TQSPID_TA_TQSPID_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPID_TA_TQSPID_TA_CORE 0x8418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPID_TA_TQSPID_TA_CORE 0x18008418u

/*! Register Reset Value */
#define REG0_TQSPID_TA_TQSPID_TA_CORE_RST 0x000050C501370001u

/*! Field REV_CODE - rev_code */
#define REG0_TQSPID_TA_TQSPID_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TQSPID_TA_TQSPID_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TQSPID_TA_TQSPID_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TQSPID_TA_TQSPID_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TQSPID_TA_TQSPID_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TQSPID_TA_TQSPID_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL Register REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL 0x8420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL 0x18008420u

/*! Register Reset Value */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS Register REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS 0x8428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS 0x18008428u

/*! Register Reset Value */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TQSPID_TA_TQSPID_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG Register REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG 0x8458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG 0x18008458u

/*! Register Reset Value */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_REQ_INFO_MASK 0xF00000000u

/*! @} */

/*! \defgroup REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_ADDR Register REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_ADDR 0x8460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_ADDR 0x18008460u

/*! Register Reset Value */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TQSPID_TA_TQSPID_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_0 Register REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_0 0x8500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_0 0x18008500u

/*! Register Reset Value */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_1 Register REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_1 0x8508
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_1 0x18008508u

/*! Register Reset Value */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_2 Register REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_2 0x8510
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_2 0x18008510u

/*! Register Reset Value */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_3 Register REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_3 0x8518
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_3 0x18008518u

/*! Register Reset Value */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TQSPID_TA_TQSPID_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0 Register REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0 0x8600
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0 0x18008600u

/*! Register Reset Value */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TQSPID_TA_TQSPID_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TACA_IA_IACA_IA_COMPONENT Register REG0_TACA_IA_IACA_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_IA_IACA_IA_COMPONENT 0x8800
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_IA_IACA_IA_COMPONENT 0x18008800u

/*! Register Reset Value */
#define REG0_TACA_IA_IACA_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_TACA_IA_IACA_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TACA_IA_IACA_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TACA_IA_IACA_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TACA_IA_IACA_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TACA_IA_IACA_IA_CORE Register REG0_TACA_IA_IACA_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_IA_IACA_IA_CORE 0x8818
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_IA_IACA_IA_CORE 0x18008818u

/*! Register Reset Value */
#define REG0_TACA_IA_IACA_IA_CORE_RST 0x000050C501010001u

/*! Field REV_CODE - rev_code */
#define REG0_TACA_IA_IACA_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TACA_IA_IACA_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TACA_IA_IACA_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TACA_IA_IACA_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TACA_IA_IACA_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TACA_IA_IACA_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TACA_IA_IACA_IA_AGENT_CONTROL Register REG0_TACA_IA_IACA_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL 0x8820
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_IA_IACA_IA_AGENT_CONTROL 0x18008820u

/*! Register Reset Value */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_TACA_IA_IACA_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TACA_IA_IACA_IA_AGENT_STATUS Register REG0_TACA_IA_IACA_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS 0x8828
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_IA_IACA_IA_AGENT_STATUS 0x18008828u

/*! Register Reset Value */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_TACA_IA_IACA_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TACA_IA_IACA_IA_ERROR_LOG Register REG0_TACA_IA_IACA_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG 0x8858
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_IA_IACA_IA_ERROR_LOG 0x18008858u

/*! Register Reset Value */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_REQ_INFO_MASK 0x7F00000000u

/*! @} */

/*! \defgroup REG0_TACA_IA_IACA_IA_ERROR_LOG_ADDR Register REG0_TACA_IA_IACA_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_ADDR 0x8860
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_IA_IACA_IA_ERROR_LOG_ADDR 0x18008860u

/*! Register Reset Value */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_ADDR_ADDR_POS 3
/*! Field ADDR - addr */
#define REG0_TACA_IA_IACA_IA_ERROR_LOG_ADDR_ADDR_MASK 0x1FFFFFFF8u

/*! @} */

/*! \defgroup REG0_TACA_IA_IACA_IA_CORE_FLAG Register REG0_TACA_IA_IACA_IA_CORE_FLAG - core_flag */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_IA_IACA_IA_CORE_FLAG 0x8868
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_IA_IACA_IA_CORE_FLAG 0x18008868u

/*! Register Reset Value */
#define REG0_TACA_IA_IACA_IA_CORE_FLAG_RST 0x0000000000000000u

/*! Field ENABLE_0 - enable_0 */
#define REG0_TACA_IA_IACA_IA_CORE_FLAG_ENABLE_0_POS 0
/*! Field ENABLE_0 - enable_0 */
#define REG0_TACA_IA_IACA_IA_CORE_FLAG_ENABLE_0_MASK 0x1u

/*! Field ENABLE_1 - enable_1 */
#define REG0_TACA_IA_IACA_IA_CORE_FLAG_ENABLE_1_POS 1
/*! Field ENABLE_1 - enable_1 */
#define REG0_TACA_IA_IACA_IA_CORE_FLAG_ENABLE_1_MASK 0x2u

/*! Field ENABLE_2 - enable_2 */
#define REG0_TACA_IA_IACA_IA_CORE_FLAG_ENABLE_2_POS 2
/*! Field ENABLE_2 - enable_2 */
#define REG0_TACA_IA_IACA_IA_CORE_FLAG_ENABLE_2_MASK 0x4u

/*! Field ENABLE_3 - enable_3 */
#define REG0_TACA_IA_IACA_IA_CORE_FLAG_ENABLE_3_POS 3
/*! Field ENABLE_3 - enable_3 */
#define REG0_TACA_IA_IACA_IA_CORE_FLAG_ENABLE_3_MASK 0x8u

/*! @} */

/*! \defgroup REG0_TACA_IA_IACA_IA_BANDWIDTH_0 Register REG0_TACA_IA_IACA_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0 0x8900
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_IA_IACA_IA_BANDWIDTH_0 0x18008900u

/*! Register Reset Value */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_TACA_IA_IACA_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPUB_TA_TPUB_TA_COMPONENT Register REG0_TPUB_TA_TPUB_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_TA_TPUB_TA_COMPONENT 0x9000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_TA_TPUB_TA_COMPONENT 0x18009000u

/*! Register Reset Value */
#define REG0_TPUB_TA_TPUB_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TPUB_TA_TPUB_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TPUB_TA_TPUB_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TPUB_TA_TPUB_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TPUB_TA_TPUB_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TPUB_TA_TPUB_TA_CORE Register REG0_TPUB_TA_TPUB_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_TA_TPUB_TA_CORE 0x9018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_TA_TPUB_TA_CORE 0x18009018u

/*! Register Reset Value */
#define REG0_TPUB_TA_TPUB_TA_CORE_RST 0x000050C500640001u

/*! Field REV_CODE - rev_code */
#define REG0_TPUB_TA_TPUB_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TPUB_TA_TPUB_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TPUB_TA_TPUB_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TPUB_TA_TPUB_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPUB_TA_TPUB_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPUB_TA_TPUB_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL Register REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL 0x9020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL 0x18009020u

/*! Register Reset Value */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TPUB_TA_TPUB_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPUB_TA_TPUB_TA_AGENT_STATUS Register REG0_TPUB_TA_TPUB_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS 0x9028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_TA_TPUB_TA_AGENT_STATUS 0x18009028u

/*! Register Reset Value */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TPUB_TA_TPUB_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPUB_TA_TPUB_TA_ERROR_LOG Register REG0_TPUB_TA_TPUB_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG 0x9058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_TA_TPUB_TA_ERROR_LOG 0x18009058u

/*! Register Reset Value */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TPUB_TA_TPUB_TA_ERROR_LOG_ADDR Register REG0_TPUB_TA_TPUB_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG_ADDR 0x9060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_TA_TPUB_TA_ERROR_LOG_ADDR 0x18009060u

/*! Register Reset Value */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TPUB_TA_TPUB_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFu

/*! @} */

/*! \defgroup REG0_TPUB_TA_TPUB_TA_BANDWIDTH_0 Register REG0_TPUB_TA_TPUB_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_0 0x9100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_TA_TPUB_TA_BANDWIDTH_0 0x18009100u

/*! Register Reset Value */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPUB_TA_TPUB_TA_BANDWIDTH_1 Register REG0_TPUB_TA_TPUB_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_1 0x9108
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_TA_TPUB_TA_BANDWIDTH_1 0x18009108u

/*! Register Reset Value */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPUB_TA_TPUB_TA_BANDWIDTH_2 Register REG0_TPUB_TA_TPUB_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_2 0x9110
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_TA_TPUB_TA_BANDWIDTH_2 0x18009110u

/*! Register Reset Value */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPUB_TA_TPUB_TA_BANDWIDTH_3 Register REG0_TPUB_TA_TPUB_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_3 0x9118
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_TA_TPUB_TA_BANDWIDTH_3 0x18009118u

/*! Register Reset Value */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPUB_TA_TPUB_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0 Register REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0 0x9200
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0 0x18009200u

/*! Register Reset Value */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPUB_TA_TPUB_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCR1_TA_TPCIE_CR1_TA_COMPONENT Register REG0_TPCR1_TA_TPCIE_CR1_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_COMPONENT 0x9400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR1_TA_TPCIE_CR1_TA_COMPONENT 0x18009400u

/*! Register Reset Value */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TPCR1_TA_TPCIE_CR1_TA_CORE Register REG0_TPCR1_TA_TPCIE_CR1_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_CORE 0x9418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR1_TA_TPCIE_CR1_TA_CORE 0x18009418u

/*! Register Reset Value */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_CORE_RST 0x000050C500380001u

/*! Field REV_CODE - rev_code */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL Register REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL 0x9420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL 0x18009420u

/*! Register Reset Value */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS Register REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS 0x9428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS 0x18009428u

/*! Register Reset Value */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG Register REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG 0x9458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG 0x18009458u

/*! Register Reset Value */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_ADDR Register REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_ADDR 0x9460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_ADDR 0x18009460u

/*! Register Reset Value */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_0 Register REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_0 0x9500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_0 0x18009500u

/*! Register Reset Value */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_1 Register REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_1 0x9508
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_1 0x18009508u

/*! Register Reset Value */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_2 Register REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_2 0x9510
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_2 0x18009510u

/*! Register Reset Value */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_3 Register REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_3 0x9518
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_3 0x18009518u

/*! Register Reset Value */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0 Register REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0 0x9600
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0 0x18009600u

/*! Register Reset Value */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPCR1_TA_TPCIE_CR1_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCR2_TA_TPCIE_CR2_TA_COMPONENT Register REG0_TPCR2_TA_TPCIE_CR2_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_COMPONENT 0x9C00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR2_TA_TPCIE_CR2_TA_COMPONENT 0x18009C00u

/*! Register Reset Value */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TPCR2_TA_TPCIE_CR2_TA_CORE Register REG0_TPCR2_TA_TPCIE_CR2_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_CORE 0x9C18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR2_TA_TPCIE_CR2_TA_CORE 0x18009C18u

/*! Register Reset Value */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_CORE_RST 0x000050C500340001u

/*! Field REV_CODE - rev_code */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL Register REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL 0x9C20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL 0x18009C20u

/*! Register Reset Value */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS Register REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS 0x9C28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS 0x18009C28u

/*! Register Reset Value */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG Register REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG 0x9C58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG 0x18009C58u

/*! Register Reset Value */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_ADDR Register REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_ADDR 0x9C60
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_ADDR 0x18009C60u

/*! Register Reset Value */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_0 Register REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_0 0x9D00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_0 0x18009D00u

/*! Register Reset Value */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_1 Register REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_1 0x9D08
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_1 0x18009D08u

/*! Register Reset Value */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_2 Register REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_2 0x9D10
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_2 0x18009D10u

/*! Register Reset Value */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_3 Register REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_3 0x9D18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_3 0x18009D18u

/*! Register Reset Value */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0 Register REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0 0x9E00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0 0x18009E00u

/*! Register Reset Value */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPCR2_TA_TPCIE_CR2_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMAT2_TA_TDMAT2_TA_COMPONENT Register REG0_TDMAT2_TA_TDMAT2_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT2_TA_TDMAT2_TA_COMPONENT 0xA400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT2_TA_TDMAT2_TA_COMPONENT 0x1800A400u

/*! Register Reset Value */
#define REG0_TDMAT2_TA_TDMAT2_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TDMAT2_TA_TDMAT2_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TDMAT2_TA_TDMAT2_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TDMAT2_TA_TDMAT2_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TDMAT2_TA_TDMAT2_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TDMAT2_TA_TDMAT2_TA_CORE Register REG0_TDMAT2_TA_TDMAT2_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT2_TA_TDMAT2_TA_CORE 0xA418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT2_TA_TDMAT2_TA_CORE 0x1800A418u

/*! Register Reset Value */
#define REG0_TDMAT2_TA_TDMAT2_TA_CORE_RST 0x000088C300130001u

/*! Field REV_CODE - rev_code */
#define REG0_TDMAT2_TA_TDMAT2_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TDMAT2_TA_TDMAT2_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TDMAT2_TA_TDMAT2_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TDMAT2_TA_TDMAT2_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TDMAT2_TA_TDMAT2_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TDMAT2_TA_TDMAT2_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL Register REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL 0xA420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL 0x1800A420u

/*! Register Reset Value */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS Register REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS 0xA428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS 0x1800A428u

/*! Register Reset Value */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TDMAT2_TA_TDMAT2_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG Register REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG 0xA458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG 0x1800A458u

/*! Register Reset Value */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_ADDR Register REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_ADDR 0xA460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_ADDR 0x1800A460u

/*! Register Reset Value */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TDMAT2_TA_TDMAT2_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_0 Register REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_0 0xA500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_0 0x1800A500u

/*! Register Reset Value */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_1 Register REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_1 0xA508
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_1 0x1800A508u

/*! Register Reset Value */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_2 Register REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_2 0xA510
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_2 0x1800A510u

/*! Register Reset Value */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_3 Register REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_3 0xA518
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_3 0x1800A518u

/*! Register Reset Value */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TDMAT2_TA_TDMAT2_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0 Register REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0 0xA600
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0 0x1800A600u

/*! Register Reset Value */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TDMAT2_TA_TDMAT2_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMAR1_TA_TDMAR1_TA_COMPONENT Register REG0_TDMAR1_TA_TDMAR1_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAR1_TA_TDMAR1_TA_COMPONENT 0xA800
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAR1_TA_TDMAR1_TA_COMPONENT 0x1800A800u

/*! Register Reset Value */
#define REG0_TDMAR1_TA_TDMAR1_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TDMAR1_TA_TDMAR1_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TDMAR1_TA_TDMAR1_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TDMAR1_TA_TDMAR1_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TDMAR1_TA_TDMAR1_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TDMAR1_TA_TDMAR1_TA_CORE Register REG0_TDMAR1_TA_TDMAR1_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAR1_TA_TDMAR1_TA_CORE 0xA818
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAR1_TA_TDMAR1_TA_CORE 0x1800A818u

/*! Register Reset Value */
#define REG0_TDMAR1_TA_TDMAR1_TA_CORE_RST 0x000088C300240001u

/*! Field REV_CODE - rev_code */
#define REG0_TDMAR1_TA_TDMAR1_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TDMAR1_TA_TDMAR1_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TDMAR1_TA_TDMAR1_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TDMAR1_TA_TDMAR1_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TDMAR1_TA_TDMAR1_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TDMAR1_TA_TDMAR1_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL Register REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL 0xA820
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL 0x1800A820u

/*! Register Reset Value */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS Register REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS 0xA828
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS 0x1800A828u

/*! Register Reset Value */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TDMAR1_TA_TDMAR1_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG Register REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG 0xA858
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG 0x1800A858u

/*! Register Reset Value */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_ADDR Register REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_ADDR 0xA860
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_ADDR 0x1800A860u

/*! Register Reset Value */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TDMAR1_TA_TDMAR1_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_0 Register REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_0 0xA900
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_0 0x1800A900u

/*! Register Reset Value */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_1 Register REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_1 0xA908
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_1 0x1800A908u

/*! Register Reset Value */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_2 Register REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_2 0xA910
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_2 0x1800A910u

/*! Register Reset Value */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_3 Register REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_3 0xA918
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_3 0x1800A918u

/*! Register Reset Value */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TDMAR1_TA_TDMAR1_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0 Register REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0 0xAA00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0 0x1800AA00u

/*! Register Reset Value */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TDMAR1_TA_TDMAR1_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TACA_TA_TACA_TA_COMPONENT Register REG0_TACA_TA_TACA_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_TA_TACA_TA_COMPONENT 0xAC00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_TA_TACA_TA_COMPONENT 0x1800AC00u

/*! Register Reset Value */
#define REG0_TACA_TA_TACA_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TACA_TA_TACA_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TACA_TA_TACA_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TACA_TA_TACA_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TACA_TA_TACA_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TACA_TA_TACA_TA_CORE Register REG0_TACA_TA_TACA_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_TA_TACA_TA_CORE 0xAC18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_TA_TACA_TA_CORE 0x1800AC18u

/*! Register Reset Value */
#define REG0_TACA_TA_TACA_TA_CORE_RST 0x000050C501200001u

/*! Field REV_CODE - rev_code */
#define REG0_TACA_TA_TACA_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TACA_TA_TACA_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TACA_TA_TACA_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TACA_TA_TACA_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TACA_TA_TACA_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TACA_TA_TACA_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TACA_TA_TACA_TA_AGENT_CONTROL Register REG0_TACA_TA_TACA_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL 0xAC20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_TA_TACA_TA_AGENT_CONTROL 0x1800AC20u

/*! Register Reset Value */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TACA_TA_TACA_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TACA_TA_TACA_TA_AGENT_STATUS Register REG0_TACA_TA_TACA_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS 0xAC28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_TA_TACA_TA_AGENT_STATUS 0x1800AC28u

/*! Register Reset Value */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TACA_TA_TACA_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TACA_TA_TACA_TA_ERROR_LOG Register REG0_TACA_TA_TACA_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG 0xAC58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_TA_TACA_TA_ERROR_LOG 0x1800AC58u

/*! Register Reset Value */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG_REQ_INFO_MASK 0x7F00000000u

/*! @} */

/*! \defgroup REG0_TACA_TA_TACA_TA_ERROR_LOG_ADDR Register REG0_TACA_TA_TACA_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG_ADDR 0xAC60
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_TA_TACA_TA_ERROR_LOG_ADDR 0x1800AC60u

/*! Register Reset Value */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TACA_TA_TACA_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TACA_TA_TACA_TA_BANDWIDTH_0 Register REG0_TACA_TA_TACA_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_0 0xAD00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_TA_TACA_TA_BANDWIDTH_0 0x1800AD00u

/*! Register Reset Value */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TACA_TA_TACA_TA_BANDWIDTH_1 Register REG0_TACA_TA_TACA_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_1 0xAD08
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_TA_TACA_TA_BANDWIDTH_1 0x1800AD08u

/*! Register Reset Value */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TACA_TA_TACA_TA_BANDWIDTH_2 Register REG0_TACA_TA_TACA_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_2 0xAD10
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_TA_TACA_TA_BANDWIDTH_2 0x1800AD10u

/*! Register Reset Value */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TACA_TA_TACA_TA_BANDWIDTH_3 Register REG0_TACA_TA_TACA_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_3 0xAD18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_TA_TACA_TA_BANDWIDTH_3 0x1800AD18u

/*! Register Reset Value */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TACA_TA_TACA_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0 Register REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0 0xAE00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0 0x1800AE00u

/*! Register Reset Value */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TACA_TA_TACA_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IPC1W_IA_IPC1W_IA_COMPONENT Register REG0_IPC1W_IA_IPC1W_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC1W_IA_IPC1W_IA_COMPONENT 0xB000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC1W_IA_IPC1W_IA_COMPONENT 0x1800B000u

/*! Register Reset Value */
#define REG0_IPC1W_IA_IPC1W_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IPC1W_IA_IPC1W_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IPC1W_IA_IPC1W_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IPC1W_IA_IPC1W_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IPC1W_IA_IPC1W_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IPC1W_IA_IPC1W_IA_CORE Register REG0_IPC1W_IA_IPC1W_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC1W_IA_IPC1W_IA_CORE 0xB018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC1W_IA_IPC1W_IA_CORE 0x1800B018u

/*! Register Reset Value */
#define REG0_IPC1W_IA_IPC1W_IA_CORE_RST 0x0000CAFE01360000u

/*! Field REV_CODE - rev_code */
#define REG0_IPC1W_IA_IPC1W_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IPC1W_IA_IPC1W_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IPC1W_IA_IPC1W_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IPC1W_IA_IPC1W_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IPC1W_IA_IPC1W_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IPC1W_IA_IPC1W_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL Register REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL 0xB020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL 0x1800B020u

/*! Register Reset Value */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS Register REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS 0xB028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS 0x1800B028u

/*! Register Reset Value */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IPC1W_IA_IPC1W_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG Register REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG 0xB058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG 0x1800B058u

/*! Register Reset Value */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_REQ_INFO_MASK 0x7FFF00000000u

/*! @} */

/*! \defgroup REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_ADDR Register REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_ADDR 0xB060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_ADDR 0x1800B060u

/*! Register Reset Value */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_ADDR_ADDR_POS 4
/*! Field ADDR - addr */
#define REG0_IPC1W_IA_IPC1W_IA_ERROR_LOG_ADDR_ADDR_MASK 0x1FFFFFFF0u

/*! @} */

/*! \defgroup REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0 Register REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0 0xB100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0 0x1800B100u

/*! Register Reset Value */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IPC1W_IA_IPC1W_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IPC1R_IA_IPC1R_IA_COMPONENT Register REG0_IPC1R_IA_IPC1R_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC1R_IA_IPC1R_IA_COMPONENT 0xB400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC1R_IA_IPC1R_IA_COMPONENT 0x1800B400u

/*! Register Reset Value */
#define REG0_IPC1R_IA_IPC1R_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IPC1R_IA_IPC1R_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IPC1R_IA_IPC1R_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IPC1R_IA_IPC1R_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IPC1R_IA_IPC1R_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IPC1R_IA_IPC1R_IA_CORE Register REG0_IPC1R_IA_IPC1R_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC1R_IA_IPC1R_IA_CORE 0xB418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC1R_IA_IPC1R_IA_CORE 0x1800B418u

/*! Register Reset Value */
#define REG0_IPC1R_IA_IPC1R_IA_CORE_RST 0x0000CAFE00360000u

/*! Field REV_CODE - rev_code */
#define REG0_IPC1R_IA_IPC1R_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IPC1R_IA_IPC1R_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IPC1R_IA_IPC1R_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IPC1R_IA_IPC1R_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IPC1R_IA_IPC1R_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IPC1R_IA_IPC1R_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL Register REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL 0xB420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL 0x1800B420u

/*! Register Reset Value */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS Register REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS 0xB428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS 0x1800B428u

/*! Register Reset Value */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IPC1R_IA_IPC1R_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG Register REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG 0xB458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG 0x1800B458u

/*! Register Reset Value */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_REQ_INFO_MASK 0x7FFF00000000u

/*! @} */

/*! \defgroup REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_ADDR Register REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_ADDR 0xB460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_ADDR 0x1800B460u

/*! Register Reset Value */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_ADDR_ADDR_POS 4
/*! Field ADDR - addr */
#define REG0_IPC1R_IA_IPC1R_IA_ERROR_LOG_ADDR_ADDR_MASK 0x1FFFFFFF0u

/*! @} */

/*! \defgroup REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0 Register REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0 0xB500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0 0x1800B500u

/*! Register Reset Value */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IPC1R_IA_IPC1R_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IPC2W_IA_IPC2W_IA_COMPONENT Register REG0_IPC2W_IA_IPC2W_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC2W_IA_IPC2W_IA_COMPONENT 0xB800
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC2W_IA_IPC2W_IA_COMPONENT 0x1800B800u

/*! Register Reset Value */
#define REG0_IPC2W_IA_IPC2W_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IPC2W_IA_IPC2W_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IPC2W_IA_IPC2W_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IPC2W_IA_IPC2W_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IPC2W_IA_IPC2W_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IPC2W_IA_IPC2W_IA_CORE Register REG0_IPC2W_IA_IPC2W_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC2W_IA_IPC2W_IA_CORE 0xB818
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC2W_IA_IPC2W_IA_CORE 0x1800B818u

/*! Register Reset Value */
#define REG0_IPC2W_IA_IPC2W_IA_CORE_RST 0x0000CAFE01320000u

/*! Field REV_CODE - rev_code */
#define REG0_IPC2W_IA_IPC2W_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IPC2W_IA_IPC2W_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IPC2W_IA_IPC2W_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IPC2W_IA_IPC2W_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IPC2W_IA_IPC2W_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IPC2W_IA_IPC2W_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL Register REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL 0xB820
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL 0x1800B820u

/*! Register Reset Value */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS Register REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS 0xB828
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS 0x1800B828u

/*! Register Reset Value */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IPC2W_IA_IPC2W_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG Register REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG 0xB858
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG 0x1800B858u

/*! Register Reset Value */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_REQ_INFO_MASK 0x7FFF00000000u

/*! @} */

/*! \defgroup REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_ADDR Register REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_ADDR 0xB860
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_ADDR 0x1800B860u

/*! Register Reset Value */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_ADDR_ADDR_POS 4
/*! Field ADDR - addr */
#define REG0_IPC2W_IA_IPC2W_IA_ERROR_LOG_ADDR_ADDR_MASK 0x1FFFFFFF0u

/*! @} */

/*! \defgroup REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0 Register REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0 0xB900
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0 0x1800B900u

/*! Register Reset Value */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IPC2W_IA_IPC2W_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IPC2R_IA_IPC2R_IA_COMPONENT Register REG0_IPC2R_IA_IPC2R_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC2R_IA_IPC2R_IA_COMPONENT 0xBC00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC2R_IA_IPC2R_IA_COMPONENT 0x1800BC00u

/*! Register Reset Value */
#define REG0_IPC2R_IA_IPC2R_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IPC2R_IA_IPC2R_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IPC2R_IA_IPC2R_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IPC2R_IA_IPC2R_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IPC2R_IA_IPC2R_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IPC2R_IA_IPC2R_IA_CORE Register REG0_IPC2R_IA_IPC2R_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC2R_IA_IPC2R_IA_CORE 0xBC18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC2R_IA_IPC2R_IA_CORE 0x1800BC18u

/*! Register Reset Value */
#define REG0_IPC2R_IA_IPC2R_IA_CORE_RST 0x0000CAFE00320000u

/*! Field REV_CODE - rev_code */
#define REG0_IPC2R_IA_IPC2R_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IPC2R_IA_IPC2R_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IPC2R_IA_IPC2R_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IPC2R_IA_IPC2R_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IPC2R_IA_IPC2R_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IPC2R_IA_IPC2R_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL Register REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL 0xBC20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL 0x1800BC20u

/*! Register Reset Value */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS Register REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS 0xBC28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS 0x1800BC28u

/*! Register Reset Value */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IPC2R_IA_IPC2R_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG Register REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG 0xBC58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG 0x1800BC58u

/*! Register Reset Value */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_REQ_INFO_MASK 0x7FFF00000000u

/*! @} */

/*! \defgroup REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_ADDR Register REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_ADDR 0xBC60
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_ADDR 0x1800BC60u

/*! Register Reset Value */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_ADDR_ADDR_POS 4
/*! Field ADDR - addr */
#define REG0_IPC2R_IA_IPC2R_IA_ERROR_LOG_ADDR_ADDR_MASK 0x1FFFFFFF0u

/*! @} */

/*! \defgroup REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0 Register REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0 0xBD00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0 0x1800BD00u

/*! Register Reset Value */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IPC2R_IA_IPC2R_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI2_TA_TPCI2_TA_COMPONENT Register REG0_TPCI2_TA_TPCI2_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2_TA_TPCI2_TA_COMPONENT 0xC000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2_TA_TPCI2_TA_COMPONENT 0x1800C000u

/*! Register Reset Value */
#define REG0_TPCI2_TA_TPCI2_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TPCI2_TA_TPCI2_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TPCI2_TA_TPCI2_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TPCI2_TA_TPCI2_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TPCI2_TA_TPCI2_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TPCI2_TA_TPCI2_TA_CORE Register REG0_TPCI2_TA_TPCI2_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2_TA_TPCI2_TA_CORE 0xC018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2_TA_TPCI2_TA_CORE 0x1800C018u

/*! Register Reset Value */
#define REG0_TPCI2_TA_TPCI2_TA_CORE_RST 0x000050C500320001u

/*! Field REV_CODE - rev_code */
#define REG0_TPCI2_TA_TPCI2_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TPCI2_TA_TPCI2_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TPCI2_TA_TPCI2_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TPCI2_TA_TPCI2_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPCI2_TA_TPCI2_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPCI2_TA_TPCI2_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL Register REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL 0xC020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL 0x1800C020u

/*! Register Reset Value */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS Register REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS 0xC028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS 0x1800C028u

/*! Register Reset Value */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TPCI2_TA_TPCI2_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG Register REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG 0xC058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG 0x1800C058u

/*! Register Reset Value */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_REQ_INFO_MASK 0x7FFF00000000u

/*! @} */

/*! \defgroup REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_ADDR Register REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_ADDR 0xC060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_ADDR 0x1800C060u

/*! Register Reset Value */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TPCI2_TA_TPCI2_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_0 Register REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_0 0xC100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_0 0x1800C100u

/*! Register Reset Value */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_1 Register REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_1 0xC108
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_1 0x1800C108u

/*! Register Reset Value */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_2 Register REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_2 0xC110
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_2 0x1800C110u

/*! Register Reset Value */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_3 Register REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_3 0xC118
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_3 0x1800C118u

/*! Register Reset Value */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPCI2_TA_TPCI2_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0 Register REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0 0xC200
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0 0x1800C200u

/*! Register Reset Value */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPCI2_TA_TPCI2_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI1_TA_TPCI1_TA_COMPONENT Register REG0_TPCI1_TA_TPCI1_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1_TA_TPCI1_TA_COMPONENT 0xC400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1_TA_TPCI1_TA_COMPONENT 0x1800C400u

/*! Register Reset Value */
#define REG0_TPCI1_TA_TPCI1_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TPCI1_TA_TPCI1_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TPCI1_TA_TPCI1_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TPCI1_TA_TPCI1_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TPCI1_TA_TPCI1_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TPCI1_TA_TPCI1_TA_CORE Register REG0_TPCI1_TA_TPCI1_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1_TA_TPCI1_TA_CORE 0xC418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1_TA_TPCI1_TA_CORE 0x1800C418u

/*! Register Reset Value */
#define REG0_TPCI1_TA_TPCI1_TA_CORE_RST 0x000050C500360001u

/*! Field REV_CODE - rev_code */
#define REG0_TPCI1_TA_TPCI1_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TPCI1_TA_TPCI1_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TPCI1_TA_TPCI1_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TPCI1_TA_TPCI1_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPCI1_TA_TPCI1_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPCI1_TA_TPCI1_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL Register REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL 0xC420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL 0x1800C420u

/*! Register Reset Value */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS Register REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS 0xC428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS 0x1800C428u

/*! Register Reset Value */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TPCI1_TA_TPCI1_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG Register REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG 0xC458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG 0x1800C458u

/*! Register Reset Value */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_REQ_INFO_MASK 0x7FFF00000000u

/*! @} */

/*! \defgroup REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_ADDR Register REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_ADDR 0xC460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_ADDR 0x1800C460u

/*! Register Reset Value */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TPCI1_TA_TPCI1_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_0 Register REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_0 0xC500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_0 0x1800C500u

/*! Register Reset Value */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_1 Register REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_1 0xC508
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_1 0x1800C508u

/*! Register Reset Value */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_2 Register REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_2 0xC510
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_2 0x1800C510u

/*! Register Reset Value */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_3 Register REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_3 0xC518
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_3 0x1800C518u

/*! Register Reset Value */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPCI1_TA_TPCI1_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0 Register REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0 0xC600
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0 0x1800C600u

/*! Register Reset Value */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPCI1_TA_TPCI1_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TMSI1_TA_TMSI1_TA_COMPONENT Register REG0_TMSI1_TA_TMSI1_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI1_TA_TMSI1_TA_COMPONENT 0xD000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI1_TA_TMSI1_TA_COMPONENT 0x1800D000u

/*! Register Reset Value */
#define REG0_TMSI1_TA_TMSI1_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TMSI1_TA_TMSI1_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TMSI1_TA_TMSI1_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TMSI1_TA_TMSI1_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TMSI1_TA_TMSI1_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TMSI1_TA_TMSI1_TA_CORE Register REG0_TMSI1_TA_TMSI1_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI1_TA_TMSI1_TA_CORE 0xD018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI1_TA_TMSI1_TA_CORE 0x1800D018u

/*! Register Reset Value */
#define REG0_TMSI1_TA_TMSI1_TA_CORE_RST 0x000088C300370001u

/*! Field REV_CODE - rev_code */
#define REG0_TMSI1_TA_TMSI1_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TMSI1_TA_TMSI1_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TMSI1_TA_TMSI1_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TMSI1_TA_TMSI1_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TMSI1_TA_TMSI1_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TMSI1_TA_TMSI1_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL Register REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL 0xD020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL 0x1800D020u

/*! Register Reset Value */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS Register REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS 0xD028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS 0x1800D028u

/*! Register Reset Value */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TMSI1_TA_TMSI1_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG Register REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG 0xD058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG 0x1800D058u

/*! Register Reset Value */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_ADDR Register REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_ADDR 0xD060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_ADDR 0x1800D060u

/*! Register Reset Value */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TMSI1_TA_TMSI1_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_0 Register REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_0 0xD100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_0 0x1800D100u

/*! Register Reset Value */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_1 Register REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_1 0xD108
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_1 0x1800D108u

/*! Register Reset Value */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_2 Register REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_2 0xD110
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_2 0x1800D110u

/*! Register Reset Value */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_3 Register REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_3 0xD118
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_3 0x1800D118u

/*! Register Reset Value */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TMSI1_TA_TMSI1_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0 Register REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0 0xD200
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0 0x1800D200u

/*! Register Reset Value */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TMSI1_TA_TMSI1_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TMSI2_TA_TMSI2_TA_COMPONENT Register REG0_TMSI2_TA_TMSI2_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI2_TA_TMSI2_TA_COMPONENT 0xD400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI2_TA_TMSI2_TA_COMPONENT 0x1800D400u

/*! Register Reset Value */
#define REG0_TMSI2_TA_TMSI2_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TMSI2_TA_TMSI2_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TMSI2_TA_TMSI2_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TMSI2_TA_TMSI2_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TMSI2_TA_TMSI2_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TMSI2_TA_TMSI2_TA_CORE Register REG0_TMSI2_TA_TMSI2_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI2_TA_TMSI2_TA_CORE 0xD418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI2_TA_TMSI2_TA_CORE 0x1800D418u

/*! Register Reset Value */
#define REG0_TMSI2_TA_TMSI2_TA_CORE_RST 0x000088C300330001u

/*! Field REV_CODE - rev_code */
#define REG0_TMSI2_TA_TMSI2_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TMSI2_TA_TMSI2_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TMSI2_TA_TMSI2_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TMSI2_TA_TMSI2_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TMSI2_TA_TMSI2_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TMSI2_TA_TMSI2_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL Register REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL 0xD420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL 0x1800D420u

/*! Register Reset Value */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS Register REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS 0xD428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS 0x1800D428u

/*! Register Reset Value */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TMSI2_TA_TMSI2_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG Register REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG 0xD458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG 0x1800D458u

/*! Register Reset Value */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_ADDR Register REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_ADDR 0xD460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_ADDR 0x1800D460u

/*! Register Reset Value */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TMSI2_TA_TMSI2_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_0 Register REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_0 0xD500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_0 0x1800D500u

/*! Register Reset Value */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_1 Register REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_1 0xD508
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_1 0x1800D508u

/*! Register Reset Value */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_2 Register REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_2 0xD510
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_2 0x1800D510u

/*! Register Reset Value */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_3 Register REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_3 0xD518
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_3 0x1800D518u

/*! Register Reset Value */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TMSI2_TA_TMSI2_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0 Register REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0 0xD600
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0 0x1800D600u

/*! Register Reset Value */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TMSI2_TA_TMSI2_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IE123W_IA_IE123W_IA_COMPONENT Register REG0_IE123W_IA_IE123W_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123W_IA_IE123W_IA_COMPONENT 0x10800
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123W_IA_IE123W_IA_COMPONENT 0x18010800u

/*! Register Reset Value */
#define REG0_IE123W_IA_IE123W_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IE123W_IA_IE123W_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IE123W_IA_IE123W_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IE123W_IA_IE123W_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IE123W_IA_IE123W_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IE123W_IA_IE123W_IA_CORE Register REG0_IE123W_IA_IE123W_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123W_IA_IE123W_IA_CORE 0x10818
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123W_IA_IE123W_IA_CORE 0x18010818u

/*! Register Reset Value */
#define REG0_IE123W_IA_IE123W_IA_CORE_RST 0x0000CAFE010F0000u

/*! Field REV_CODE - rev_code */
#define REG0_IE123W_IA_IE123W_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IE123W_IA_IE123W_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IE123W_IA_IE123W_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IE123W_IA_IE123W_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IE123W_IA_IE123W_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IE123W_IA_IE123W_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL Register REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL 0x10820
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL 0x18010820u

/*! Register Reset Value */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IE123W_IA_IE123W_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IE123W_IA_IE123W_IA_AGENT_STATUS Register REG0_IE123W_IA_IE123W_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS 0x10828
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123W_IA_IE123W_IA_AGENT_STATUS 0x18010828u

/*! Register Reset Value */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IE123W_IA_IE123W_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IE123W_IA_IE123W_IA_ERROR_LOG Register REG0_IE123W_IA_IE123W_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG 0x10858
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123W_IA_IE123W_IA_ERROR_LOG 0x18010858u

/*! Register Reset Value */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_REQ_INFO_MASK 0x7FFF00000000u

/*! @} */

/*! \defgroup REG0_IE123W_IA_IE123W_IA_ERROR_LOG_ADDR Register REG0_IE123W_IA_IE123W_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_ADDR 0x10860
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123W_IA_IE123W_IA_ERROR_LOG_ADDR 0x18010860u

/*! Register Reset Value */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_ADDR_ADDR_POS 2
/*! Field ADDR - addr */
#define REG0_IE123W_IA_IE123W_IA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFCu

/*! @} */

/*! \defgroup REG0_IE123W_IA_IE123W_IA_ADDR_FILL_IN Register REG0_IE123W_IA_IE123W_IA_ADDR_FILL_IN - addr_fill_in */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123W_IA_IE123W_IA_ADDR_FILL_IN 0x10870
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123W_IA_IE123W_IA_ADDR_FILL_IN 0x18010870u

/*! Register Reset Value */
#define REG0_IE123W_IA_IE123W_IA_ADDR_FILL_IN_RST 0x0000000000000000u

/*! Field VALUE - value */
#define REG0_IE123W_IA_IE123W_IA_ADDR_FILL_IN_VALUE_POS 32
/*! Field VALUE - value */
#define REG0_IE123W_IA_IE123W_IA_ADDR_FILL_IN_VALUE_MASK 0x100000000u

/*! @} */

/*! \defgroup REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0 Register REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0 0x10900
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0 0x18010900u

/*! Register Reset Value */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IE123W_IA_IE123W_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IE123R_IA_IE123R_IA_COMPONENT Register REG0_IE123R_IA_IE123R_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123R_IA_IE123R_IA_COMPONENT 0x10C00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123R_IA_IE123R_IA_COMPONENT 0x18010C00u

/*! Register Reset Value */
#define REG0_IE123R_IA_IE123R_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IE123R_IA_IE123R_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IE123R_IA_IE123R_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IE123R_IA_IE123R_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IE123R_IA_IE123R_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IE123R_IA_IE123R_IA_CORE Register REG0_IE123R_IA_IE123R_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123R_IA_IE123R_IA_CORE 0x10C18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123R_IA_IE123R_IA_CORE 0x18010C18u

/*! Register Reset Value */
#define REG0_IE123R_IA_IE123R_IA_CORE_RST 0x0000CAFE000F0000u

/*! Field REV_CODE - rev_code */
#define REG0_IE123R_IA_IE123R_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IE123R_IA_IE123R_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IE123R_IA_IE123R_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IE123R_IA_IE123R_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IE123R_IA_IE123R_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IE123R_IA_IE123R_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL Register REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL 0x10C20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL 0x18010C20u

/*! Register Reset Value */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IE123R_IA_IE123R_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IE123R_IA_IE123R_IA_AGENT_STATUS Register REG0_IE123R_IA_IE123R_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS 0x10C28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123R_IA_IE123R_IA_AGENT_STATUS 0x18010C28u

/*! Register Reset Value */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IE123R_IA_IE123R_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IE123R_IA_IE123R_IA_ERROR_LOG Register REG0_IE123R_IA_IE123R_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG 0x10C58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123R_IA_IE123R_IA_ERROR_LOG 0x18010C58u

/*! Register Reset Value */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_REQ_INFO_MASK 0x7FFF00000000u

/*! @} */

/*! \defgroup REG0_IE123R_IA_IE123R_IA_ERROR_LOG_ADDR Register REG0_IE123R_IA_IE123R_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_ADDR 0x10C60
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123R_IA_IE123R_IA_ERROR_LOG_ADDR 0x18010C60u

/*! Register Reset Value */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_ADDR_ADDR_POS 2
/*! Field ADDR - addr */
#define REG0_IE123R_IA_IE123R_IA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFCu

/*! @} */

/*! \defgroup REG0_IE123R_IA_IE123R_IA_ADDR_FILL_IN Register REG0_IE123R_IA_IE123R_IA_ADDR_FILL_IN - addr_fill_in */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123R_IA_IE123R_IA_ADDR_FILL_IN 0x10C70
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123R_IA_IE123R_IA_ADDR_FILL_IN 0x18010C70u

/*! Register Reset Value */
#define REG0_IE123R_IA_IE123R_IA_ADDR_FILL_IN_RST 0x0000000000000000u

/*! Field VALUE - value */
#define REG0_IE123R_IA_IE123R_IA_ADDR_FILL_IN_VALUE_POS 32
/*! Field VALUE - value */
#define REG0_IE123R_IA_IE123R_IA_ADDR_FILL_IN_VALUE_MASK 0x100000000u

/*! @} */

/*! \defgroup REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0 Register REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0 0x10D00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0 0x18010D00u

/*! Register Reset Value */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IE123R_IA_IE123R_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDMA3_IA_IDMAT3_IA_COMPONENT Register REG0_IDMA3_IA_IDMAT3_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA3_IA_IDMAT3_IA_COMPONENT 0x11400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA3_IA_IDMAT3_IA_COMPONENT 0x18011400u

/*! Register Reset Value */
#define REG0_IDMA3_IA_IDMAT3_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IDMA3_IA_IDMAT3_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IDMA3_IA_IDMAT3_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IDMA3_IA_IDMAT3_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IDMA3_IA_IDMAT3_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IDMA3_IA_IDMAT3_IA_CORE Register REG0_IDMA3_IA_IDMAT3_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA3_IA_IDMAT3_IA_CORE 0x11418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA3_IA_IDMAT3_IA_CORE 0x18011418u

/*! Register Reset Value */
#define REG0_IDMA3_IA_IDMAT3_IA_CORE_RST 0x000050C5000C0001u

/*! Field REV_CODE - rev_code */
#define REG0_IDMA3_IA_IDMAT3_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IDMA3_IA_IDMAT3_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IDMA3_IA_IDMAT3_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IDMA3_IA_IDMAT3_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMA3_IA_IDMAT3_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMA3_IA_IDMAT3_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL Register REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL 0x11420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL 0x18011420u

/*! Register Reset Value */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS Register REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS 0x11428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS 0x18011428u

/*! Register Reset Value */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMA3_IA_IDMAT3_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG Register REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG 0x11458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG 0x18011458u

/*! Register Reset Value */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_ADDR Register REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_ADDR 0x11460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_ADDR 0x18011460u

/*! Register Reset Value */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_ADDR_ADDR_POS 3
/*! Field ADDR - addr */
#define REG0_IDMA3_IA_IDMAT3_IA_ERROR_LOG_ADDR_ADDR_MASK 0x1FFFFFFF8u

/*! @} */

/*! \defgroup REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0 Register REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0 0x11500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0 0x18011500u

/*! Register Reset Value */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMA3_IA_IDMAT3_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDMAT1_IA_IDMAT1_IA_COMPONENT Register REG0_IDMAT1_IA_IDMAT1_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAT1_IA_IDMAT1_IA_COMPONENT 0x11800
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAT1_IA_IDMAT1_IA_COMPONENT 0x18011800u

/*! Register Reset Value */
#define REG0_IDMAT1_IA_IDMAT1_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IDMAT1_IA_IDMAT1_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IDMAT1_IA_IDMAT1_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IDMAT1_IA_IDMAT1_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IDMAT1_IA_IDMAT1_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IDMAT1_IA_IDMAT1_IA_CORE Register REG0_IDMAT1_IA_IDMAT1_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAT1_IA_IDMAT1_IA_CORE 0x11818
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAT1_IA_IDMAT1_IA_CORE 0x18011818u

/*! Register Reset Value */
#define REG0_IDMAT1_IA_IDMAT1_IA_CORE_RST 0x000050C500230001u

/*! Field REV_CODE - rev_code */
#define REG0_IDMAT1_IA_IDMAT1_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IDMAT1_IA_IDMAT1_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IDMAT1_IA_IDMAT1_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IDMAT1_IA_IDMAT1_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMAT1_IA_IDMAT1_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMAT1_IA_IDMAT1_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL Register REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL 0x11820
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL 0x18011820u

/*! Register Reset Value */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS Register REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS 0x11828
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS 0x18011828u

/*! Register Reset Value */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMAT1_IA_IDMAT1_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG Register REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG 0x11858
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG 0x18011858u

/*! Register Reset Value */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_ADDR Register REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_ADDR 0x11860
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_ADDR 0x18011860u

/*! Register Reset Value */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_ADDR_ADDR_POS 3
/*! Field ADDR - addr */
#define REG0_IDMAT1_IA_IDMAT1_IA_ERROR_LOG_ADDR_ADDR_MASK 0x1FFFFFFF8u

/*! @} */

/*! \defgroup REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0 Register REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0 0x11900
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0 0x18011900u

/*! Register Reset Value */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMAT1_IA_IDMAT1_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TLNPPV4_TA_TLNPPV4_TA_COMPONENT Register REG0_TLNPPV4_TA_TLNPPV4_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_COMPONENT 0x12000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TLNPPV4_TA_TLNPPV4_TA_COMPONENT 0x18012000u

/*! Register Reset Value */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TLNPPV4_TA_TLNPPV4_TA_CORE Register REG0_TLNPPV4_TA_TLNPPV4_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_CORE 0x12018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TLNPPV4_TA_TLNPPV4_TA_CORE 0x18012018u

/*! Register Reset Value */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_CORE_RST 0x000050C50F020001u

/*! Field REV_CODE - rev_code */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL Register REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL 0x12020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL 0x18012020u

/*! Register Reset Value */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS Register REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS 0x12028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS 0x18012028u

/*! Register Reset Value */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG Register REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG 0x12058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG 0x18012058u

/*! Register Reset Value */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_ADDR Register REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_ADDR 0x12060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_ADDR 0x18012060u

/*! Register Reset Value */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_0 Register REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_0 0x12100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_0 0x18012100u

/*! Register Reset Value */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_1 Register REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_1 0x12108
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_1 0x18012108u

/*! Register Reset Value */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_2 Register REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_2 0x12110
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_2 0x18012110u

/*! Register Reset Value */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_3 Register REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_3 0x12118
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_3 0x18012118u

/*! Register Reset Value */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0 Register REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0 0x12200
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0 0x18012200u

/*! Register Reset Value */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TLNPPV4_TA_TLNPPV4_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TXPCS_TA_TXPCS_TA_COMPONENT Register REG0_TXPCS_TA_TXPCS_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TXPCS_TA_TXPCS_TA_COMPONENT 0x12400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TXPCS_TA_TXPCS_TA_COMPONENT 0x18012400u

/*! Register Reset Value */
#define REG0_TXPCS_TA_TXPCS_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TXPCS_TA_TXPCS_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TXPCS_TA_TXPCS_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TXPCS_TA_TXPCS_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TXPCS_TA_TXPCS_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TXPCS_TA_TXPCS_TA_CORE Register REG0_TXPCS_TA_TXPCS_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TXPCS_TA_TXPCS_TA_CORE 0x12418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TXPCS_TA_TXPCS_TA_CORE 0x18012418u

/*! Register Reset Value */
#define REG0_TXPCS_TA_TXPCS_TA_CORE_RST 0x000050C500200001u

/*! Field REV_CODE - rev_code */
#define REG0_TXPCS_TA_TXPCS_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TXPCS_TA_TXPCS_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TXPCS_TA_TXPCS_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TXPCS_TA_TXPCS_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TXPCS_TA_TXPCS_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TXPCS_TA_TXPCS_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL Register REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL 0x12420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL 0x18012420u

/*! Register Reset Value */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS Register REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS 0x12428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS 0x18012428u

/*! Register Reset Value */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TXPCS_TA_TXPCS_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG Register REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG 0x12458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG 0x18012458u

/*! Register Reset Value */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_ADDR Register REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_ADDR 0x12460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_ADDR 0x18012460u

/*! Register Reset Value */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TXPCS_TA_TXPCS_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_0 Register REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_0 0x12500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_0 0x18012500u

/*! Register Reset Value */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_1 Register REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_1 0x12508
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_1 0x18012508u

/*! Register Reset Value */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_2 Register REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_2 0x12510
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_2 0x18012510u

/*! Register Reset Value */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_3 Register REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_3 0x12518
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_3 0x18012518u

/*! Register Reset Value */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TXPCS_TA_TXPCS_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0 Register REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0 0x12600
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0 0x18012600u

/*! Register Reset Value */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TXPCS_TA_TXPCS_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IDMA0_IA_IDMA0_IA_COMPONENT Register REG0_IDMA0_IA_IDMA0_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA0_IA_IDMA0_IA_COMPONENT 0x12C00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA0_IA_IDMA0_IA_COMPONENT 0x18012C00u

/*! Register Reset Value */
#define REG0_IDMA0_IA_IDMA0_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IDMA0_IA_IDMA0_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IDMA0_IA_IDMA0_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IDMA0_IA_IDMA0_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IDMA0_IA_IDMA0_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IDMA0_IA_IDMA0_IA_CORE Register REG0_IDMA0_IA_IDMA0_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA0_IA_IDMA0_IA_CORE 0x12C18
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA0_IA_IDMA0_IA_CORE 0x18012C18u

/*! Register Reset Value */
#define REG0_IDMA0_IA_IDMA0_IA_CORE_RST 0x000050C500020001u

/*! Field REV_CODE - rev_code */
#define REG0_IDMA0_IA_IDMA0_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IDMA0_IA_IDMA0_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IDMA0_IA_IDMA0_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IDMA0_IA_IDMA0_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMA0_IA_IDMA0_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IDMA0_IA_IDMA0_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL Register REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL 0x12C20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL 0x18012C20u

/*! Register Reset Value */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS Register REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS 0x12C28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS 0x18012C28u

/*! Register Reset Value */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IDMA0_IA_IDMA0_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG Register REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG 0x12C58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG 0x18012C58u

/*! Register Reset Value */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_ADDR Register REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_ADDR 0x12C60
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_ADDR 0x18012C60u

/*! Register Reset Value */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_ADDR_ADDR_POS 2
/*! Field ADDR - addr */
#define REG0_IDMA0_IA_IDMA0_IA_ERROR_LOG_ADDR_ADDR_MASK 0x1FFFFFFFCu

/*! @} */

/*! \defgroup REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0 Register REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0 0x12D00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0 0x18012D00u

/*! Register Reset Value */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IDMA0_IA_IDMA0_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_IPPV4_IA_ILNPPV4_IA_COMPONENT Register REG0_IPPV4_IA_ILNPPV4_IA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPPV4_IA_ILNPPV4_IA_COMPONENT 0x13000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPPV4_IA_ILNPPV4_IA_COMPONENT 0x18013000u

/*! Register Reset Value */
#define REG0_IPPV4_IA_ILNPPV4_IA_COMPONENT_RST 0x0000000060103532u

/*! Field REV - rev */
#define REG0_IPPV4_IA_ILNPPV4_IA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_IPPV4_IA_ILNPPV4_IA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_IPPV4_IA_ILNPPV4_IA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_IPPV4_IA_ILNPPV4_IA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_IPPV4_IA_ILNPPV4_IA_CORE Register REG0_IPPV4_IA_ILNPPV4_IA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE 0x13018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPPV4_IA_ILNPPV4_IA_CORE 0x18013018u

/*! Register Reset Value */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_RST 0x000050C50F200001u

/*! Field REV_CODE - rev_code */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL Register REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL 0x13020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL 0x18013020u

/*! Register Reset Value */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_RESP_TIMEOUT_MASK 0x700u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_BURST_TIMEOUT_MASK 0x70000u

/*! Field MERROR_REP - merror_rep */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_MERROR_REP_POS 24
/*! Field MERROR_REP - merror_rep */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_MERROR_REP_MASK 0x1000000u

/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_POS 25
/*! Field RESP_TIMEOUT_REP - resp_timeout_rep */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_RESP_TIMEOUT_REP_MASK 0x2000000u

/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_POS 26
/*! Field BURST_TIMEOUT_REP - burst_timeout_rep */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_BURST_TIMEOUT_REP_MASK 0x4000000u

/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_POS 27
/*! Field ALL_INBAND_ERROR_REP - all_inband_error_rep */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_ALL_INBAND_ERROR_REP_MASK 0x8000000u

/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_POS 28
/*! Field INBAND_ERROR_PRIMARY_REP - inband_error_primary_rep */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_INBAND_ERROR_PRIMARY_REP_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_POS 29
/*! Field INBAND_ERROR_SECONDARY_REP - inband_error_secondary_rep */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_INBAND_ERROR_SECONDARY_REP_MASK 0x20000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! Field RFU0 - rfu0 */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_CONTROL_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS Register REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS 0x13028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS 0x18013028u

/*! Register Reset Value */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field REQ_ACTIVE - req_active */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_REQ_ACTIVE_POS 4
/*! Field REQ_ACTIVE - req_active */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_REQ_ACTIVE_MASK 0x10u

/*! Field RESP_WAITING - resp_waiting */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_RESP_WAITING_POS 5
/*! Field RESP_WAITING - resp_waiting */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_RESP_WAITING_MASK 0x20u

/*! Field BURST - burst */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_RESP_TIMEOUT_POS 8
/*! Field RESP_TIMEOUT - resp_timeout */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_RESP_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_BURST_TIMEOUT_POS 16
/*! Field BURST_TIMEOUT - burst_timeout */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_BURST_TIMEOUT_MASK 0x10000u

/*! Field MERROR - merror */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_MERROR_POS 24
/*! Field MERROR - merror */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_MERROR_MASK 0x1000000u

/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_POS 28
/*! Field INBAND_ERROR_PRIMARY - inband_error_primary */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_INBAND_ERROR_PRIMARY_MASK 0x10000000u

/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_POS 29
/*! Field INBAND_ERROR_SECONDARY - inband_error_secondary */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_INBAND_ERROR_SECONDARY_MASK 0x20000000u

/*! Field RFU0 - rfu0 */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_RFU0_POS 31
/*! Field RFU0 - rfu0 */
#define REG0_IPPV4_IA_ILNPPV4_IA_AGENT_STATUS_RFU0_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG Register REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG 0x13058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG 0x18013058u

/*! Register Reset Value */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field RFU0 - rfu0 */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_RFU0_POS 16
/*! Field RFU0 - rfu0 */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_RFU0_MASK 0x30000u

/*! Field RFU1 - rfu1 */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_RFU1_POS 18
/*! Field RFU1 - rfu1 */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_RFU1_MASK 0xC0000u

/*! Field RFU2 - rfu2 */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_RFU2_POS 20
/*! Field RFU2 - rfu2 */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_RFU2_MASK 0xF00000u

/*! Field CODE - code */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_CODE_MASK 0x7000000u

/*! Field SECONDARY - secondary */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_ADDR Register REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_ADDR 0x13060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_ADDR 0x18013060u

/*! Register Reset Value */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_ADDR_ADDR_POS 3
/*! Field ADDR - addr */
#define REG0_IPPV4_IA_ILNPPV4_IA_ERROR_LOG_ADDR_ADDR_MASK 0x1FFFFFFF8u

/*! @} */

/*! \defgroup REG0_IPPV4_IA_ILNPPV4_IA_CORE_FLAG Register REG0_IPPV4_IA_ILNPPV4_IA_CORE_FLAG - core_flag */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_FLAG 0x13068
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPPV4_IA_ILNPPV4_IA_CORE_FLAG 0x18013068u

/*! Register Reset Value */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_FLAG_RST 0x0000000000000000u

/*! Field ENABLE_0 - enable_0 */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_FLAG_ENABLE_0_POS 0
/*! Field ENABLE_0 - enable_0 */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_FLAG_ENABLE_0_MASK 0x1u

/*! Field ENABLE_1 - enable_1 */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_FLAG_ENABLE_1_POS 1
/*! Field ENABLE_1 - enable_1 */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_FLAG_ENABLE_1_MASK 0x2u

/*! Field ENABLE_2 - enable_2 */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_FLAG_ENABLE_2_POS 2
/*! Field ENABLE_2 - enable_2 */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_FLAG_ENABLE_2_MASK 0x4u

/*! Field ENABLE_3 - enable_3 */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_FLAG_ENABLE_3_POS 3
/*! Field ENABLE_3 - enable_3 */
#define REG0_IPPV4_IA_ILNPPV4_IA_CORE_FLAG_ENABLE_3_MASK 0x8u

/*! @} */

/*! \defgroup REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0 Register REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0 0x13100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0 0x18013100u

/*! Register Reset Value */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_RST 0x0101010101010101u

/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_0_POS 0
/*! Field TARGET_GROUP_0 - target_group_0 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_0_MASK 0xFFu

/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_1_POS 8
/*! Field TARGET_GROUP_1 - target_group_1 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_1_MASK 0xFF00u

/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_2_POS 16
/*! Field TARGET_GROUP_2 - target_group_2 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_2_MASK 0xFF0000u

/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_3_POS 24
/*! Field TARGET_GROUP_3 - target_group_3 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_3_MASK 0xFF000000u

/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_4_POS 32
/*! Field TARGET_GROUP_4 - target_group_4 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_4_MASK 0xFF00000000u

/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_5_POS 40
/*! Field TARGET_GROUP_5 - target_group_5 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_5_MASK 0xFF0000000000u

/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_6_POS 48
/*! Field TARGET_GROUP_6 - target_group_6 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_6_MASK 0xFF000000000000u

/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_7_POS 56
/*! Field TARGET_GROUP_7 - target_group_7 */
#define REG0_IPPV4_IA_ILNPPV4_IA_BANDWIDTH_0_TARGET_GROUP_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI1DBI_TPCI1DBI_TA_COMPONENT Register REG0_TPCI1DBI_TPCI1DBI_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1DBI_TPCI1DBI_TA_COMPONENT 0x14000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1DBI_TPCI1DBI_TA_COMPONENT 0x18014000u

/*! Register Reset Value */
#define REG0_TPCI1DBI_TPCI1DBI_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TPCI1DBI_TPCI1DBI_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TPCI1DBI_TPCI1DBI_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TPCI1DBI_TPCI1DBI_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TPCI1DBI_TPCI1DBI_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TPCI1DBI_TPCI1DBI_TA_CORE Register REG0_TPCI1DBI_TPCI1DBI_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1DBI_TPCI1DBI_TA_CORE 0x14018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1DBI_TPCI1DBI_TA_CORE 0x18014018u

/*! Register Reset Value */
#define REG0_TPCI1DBI_TPCI1DBI_TA_CORE_RST 0x000050C501360001u

/*! Field REV_CODE - rev_code */
#define REG0_TPCI1DBI_TPCI1DBI_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TPCI1DBI_TPCI1DBI_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TPCI1DBI_TPCI1DBI_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TPCI1DBI_TPCI1DBI_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPCI1DBI_TPCI1DBI_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPCI1DBI_TPCI1DBI_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL Register REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL 0x14020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL 0x18014020u

/*! Register Reset Value */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS Register REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS 0x14028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS 0x18014028u

/*! Register Reset Value */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG Register REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG 0x14058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG 0x18014058u

/*! Register Reset Value */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_REQ_INFO_MASK 0x7FFF00000000u

/*! @} */

/*! \defgroup REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_ADDR Register REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_ADDR 0x14060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_ADDR 0x18014060u

/*! Register Reset Value */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_0 Register REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_0 0x14100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_0 0x18014100u

/*! Register Reset Value */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_1 Register REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_1 0x14108
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_1 0x18014108u

/*! Register Reset Value */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_2 Register REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_2 0x14110
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_2 0x18014110u

/*! Register Reset Value */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_3 Register REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_3 0x14118
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_3 0x18014118u

/*! Register Reset Value */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0 Register REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0 0x14200
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0 0x18014200u

/*! Register Reset Value */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPCI1DBI_TPCI1DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI2DBI_TPCI2DBI_TA_COMPONENT Register REG0_TPCI2DBI_TPCI2DBI_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2DBI_TPCI2DBI_TA_COMPONENT 0x14400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2DBI_TPCI2DBI_TA_COMPONENT 0x18014400u

/*! Register Reset Value */
#define REG0_TPCI2DBI_TPCI2DBI_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TPCI2DBI_TPCI2DBI_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TPCI2DBI_TPCI2DBI_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TPCI2DBI_TPCI2DBI_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TPCI2DBI_TPCI2DBI_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TPCI2DBI_TPCI2DBI_TA_CORE Register REG0_TPCI2DBI_TPCI2DBI_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2DBI_TPCI2DBI_TA_CORE 0x14418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2DBI_TPCI2DBI_TA_CORE 0x18014418u

/*! Register Reset Value */
#define REG0_TPCI2DBI_TPCI2DBI_TA_CORE_RST 0x000050C501320001u

/*! Field REV_CODE - rev_code */
#define REG0_TPCI2DBI_TPCI2DBI_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TPCI2DBI_TPCI2DBI_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TPCI2DBI_TPCI2DBI_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TPCI2DBI_TPCI2DBI_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPCI2DBI_TPCI2DBI_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TPCI2DBI_TPCI2DBI_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL Register REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL 0x14420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL 0x18014420u

/*! Register Reset Value */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS Register REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS 0x14428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS 0x18014428u

/*! Register Reset Value */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG Register REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG 0x14458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG 0x18014458u

/*! Register Reset Value */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_REQ_INFO_MASK 0x7FFF00000000u

/*! @} */

/*! \defgroup REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_ADDR Register REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_ADDR 0x14460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_ADDR 0x18014460u

/*! Register Reset Value */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_0 Register REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_0 0x14500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_0 0x18014500u

/*! Register Reset Value */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_1 Register REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_1 0x14508
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_1 0x18014508u

/*! Register Reset Value */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_2 Register REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_2 0x14510
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_2 0x18014510u

/*! Register Reset Value */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_3 Register REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_3 0x14518
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_3 0x18014518u

/*! Register Reset Value */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0 Register REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0 0x14600
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0 0x18014600u

/*! Register Reset Value */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TPCI2DBI_TPCI2DBI_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TMACS_TA_TMAC_TA_COMPONENT Register REG0_TMACS_TA_TMAC_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMACS_TA_TMAC_TA_COMPONENT 0x15000
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMACS_TA_TMAC_TA_COMPONENT 0x18015000u

/*! Register Reset Value */
#define REG0_TMACS_TA_TMAC_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TMACS_TA_TMAC_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TMACS_TA_TMAC_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TMACS_TA_TMAC_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TMACS_TA_TMAC_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TMACS_TA_TMAC_TA_CORE Register REG0_TMACS_TA_TMAC_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMACS_TA_TMAC_TA_CORE 0x15018
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMACS_TA_TMAC_TA_CORE 0x18015018u

/*! Register Reset Value */
#define REG0_TMACS_TA_TMAC_TA_CORE_RST 0x000050C500690001u

/*! Field REV_CODE - rev_code */
#define REG0_TMACS_TA_TMAC_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TMACS_TA_TMAC_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TMACS_TA_TMAC_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TMACS_TA_TMAC_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TMACS_TA_TMAC_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TMACS_TA_TMAC_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL Register REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL 0x15020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL 0x18015020u

/*! Register Reset Value */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TMACS_TA_TMAC_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TMACS_TA_TMAC_TA_AGENT_STATUS Register REG0_TMACS_TA_TMAC_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS 0x15028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMACS_TA_TMAC_TA_AGENT_STATUS 0x18015028u

/*! Register Reset Value */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TMACS_TA_TMAC_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TMACS_TA_TMAC_TA_ERROR_LOG Register REG0_TMACS_TA_TMAC_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG 0x15058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMACS_TA_TMAC_TA_ERROR_LOG 0x18015058u

/*! Register Reset Value */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TMACS_TA_TMAC_TA_ERROR_LOG_ADDR Register REG0_TMACS_TA_TMAC_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG_ADDR 0x15060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMACS_TA_TMAC_TA_ERROR_LOG_ADDR 0x18015060u

/*! Register Reset Value */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TMACS_TA_TMAC_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TMACS_TA_TMAC_TA_BANDWIDTH_0 Register REG0_TMACS_TA_TMAC_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_0 0x15100
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMACS_TA_TMAC_TA_BANDWIDTH_0 0x18015100u

/*! Register Reset Value */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TMACS_TA_TMAC_TA_BANDWIDTH_1 Register REG0_TMACS_TA_TMAC_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_1 0x15108
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMACS_TA_TMAC_TA_BANDWIDTH_1 0x18015108u

/*! Register Reset Value */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TMACS_TA_TMAC_TA_BANDWIDTH_2 Register REG0_TMACS_TA_TMAC_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_2 0x15110
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMACS_TA_TMAC_TA_BANDWIDTH_2 0x18015110u

/*! Register Reset Value */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TMACS_TA_TMAC_TA_BANDWIDTH_3 Register REG0_TMACS_TA_TMAC_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_3 0x15118
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMACS_TA_TMAC_TA_BANDWIDTH_3 0x18015118u

/*! Register Reset Value */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TMACS_TA_TMAC_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0 Register REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0 0x15200
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0 0x18015200u

/*! Register Reset Value */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TMACS_TA_TMAC_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TIOCU1_TA_TIOCU1_TA_COMPONENT Register REG0_TIOCU1_TA_TIOCU1_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TIOCU1_TA_TIOCU1_TA_COMPONENT 0x15400
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TIOCU1_TA_TIOCU1_TA_COMPONENT 0x18015400u

/*! Register Reset Value */
#define REG0_TIOCU1_TA_TIOCU1_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TIOCU1_TA_TIOCU1_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TIOCU1_TA_TIOCU1_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TIOCU1_TA_TIOCU1_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TIOCU1_TA_TIOCU1_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TIOCU1_TA_TIOCU1_TA_CORE Register REG0_TIOCU1_TA_TIOCU1_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TIOCU1_TA_TIOCU1_TA_CORE 0x15418
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TIOCU1_TA_TIOCU1_TA_CORE 0x18015418u

/*! Register Reset Value */
#define REG0_TIOCU1_TA_TIOCU1_TA_CORE_RST 0x000050C500620001u

/*! Field REV_CODE - rev_code */
#define REG0_TIOCU1_TA_TIOCU1_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TIOCU1_TA_TIOCU1_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TIOCU1_TA_TIOCU1_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TIOCU1_TA_TIOCU1_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TIOCU1_TA_TIOCU1_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TIOCU1_TA_TIOCU1_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL Register REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL 0x15420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL 0x18015420u

/*! Register Reset Value */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS Register REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS 0x15428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS 0x18015428u

/*! Register Reset Value */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TIOCU1_TA_TIOCU1_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG Register REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG 0x15458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG 0x18015458u

/*! Register Reset Value */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_ADDR Register REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_ADDR 0x15460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_ADDR 0x18015460u

/*! Register Reset Value */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TIOCU1_TA_TIOCU1_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_0 Register REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_0 0x15500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_0 0x18015500u

/*! Register Reset Value */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_1 Register REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_1 0x15508
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_1 0x18015508u

/*! Register Reset Value */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_2 Register REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_2 0x15510
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_2 0x18015510u

/*! Register Reset Value */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_3 Register REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_3 0x15518
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_3 0x18015518u

/*! Register Reset Value */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TIOCU1_TA_TIOCU1_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0 Register REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0 0x15600
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0 0x18015600u

/*! Register Reset Value */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TIOCU1_TA_TIOCU1_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDM4_TA_TDM4_TA_COMPONENT Register REG0_TDM4_TA_TDM4_TA_COMPONENT - component */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDM4_TA_TDM4_TA_COMPONENT 0x15800
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDM4_TA_TDM4_TA_COMPONENT 0x18015800u

/*! Register Reset Value */
#define REG0_TDM4_TA_TDM4_TA_COMPONENT_RST 0x0000000060203532u

/*! Field REV - rev */
#define REG0_TDM4_TA_TDM4_TA_COMPONENT_REV_POS 0
/*! Field REV - rev */
#define REG0_TDM4_TA_TDM4_TA_COMPONENT_REV_MASK 0xFFFFu

/*! Field CODE - code */
#define REG0_TDM4_TA_TDM4_TA_COMPONENT_CODE_POS 16
/*! Field CODE - code */
#define REG0_TDM4_TA_TDM4_TA_COMPONENT_CODE_MASK 0xFFFF0000u

/*! @} */

/*! \defgroup REG0_TDM4_TA_TDM4_TA_CORE Register REG0_TDM4_TA_TDM4_TA_CORE - core */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDM4_TA_TDM4_TA_CORE 0x15818
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDM4_TA_TDM4_TA_CORE 0x18015818u

/*! Register Reset Value */
#define REG0_TDM4_TA_TDM4_TA_CORE_RST 0x000088C309120001u

/*! Field REV_CODE - rev_code */
#define REG0_TDM4_TA_TDM4_TA_CORE_REV_CODE_POS 0
/*! Field REV_CODE - rev_code */
#define REG0_TDM4_TA_TDM4_TA_CORE_REV_CODE_MASK 0xFFFFu

/*! Field CORE_CODE - core_code */
#define REG0_TDM4_TA_TDM4_TA_CORE_CORE_CODE_POS 16
/*! Field CORE_CODE - core_code */
#define REG0_TDM4_TA_TDM4_TA_CORE_CORE_CODE_MASK 0xFFFF0000u

/*! Field VENDOR_CODE - vendor_code */
#define REG0_TDM4_TA_TDM4_TA_CORE_VENDOR_CODE_POS 32
/*! Field VENDOR_CODE - vendor_code */
#define REG0_TDM4_TA_TDM4_TA_CORE_VENDOR_CODE_MASK 0xFFFF00000000u

/*! @} */

/*! \defgroup REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL Register REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL - agent_control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL 0x15820
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL 0x18015820u

/*! Register Reset Value */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_CORE_RESET_MASK 0x1u

/*! Field REJECT - reject */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_REJECT_POS 4
/*! Field REJECT - reject */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_REJECT_MASK 0x10u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_REQ_TIMEOUT_MASK 0x700u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_POS 16
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_MASK 0x70000u

/*! Field SERROR_REP - serror_rep */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_SERROR_REP_POS 24
/*! Field SERROR_REP - serror_rep */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_SERROR_REP_MASK 0x1000000u

/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_POS 25
/*! Field REQ_TIMEOUT_REP - req_timeout_rep */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_REQ_TIMEOUT_REP_MASK 0x2000000u

/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_POS 26
/*! Field FUNCTIONAL_RESET_TIMEOUT_REP - functional_reset_timeout_rep */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_FUNCTIONAL_RESET_TIMEOUT_REP_MASK 0x4000000u

/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_POS 27
/*! Field AUTO_WAKEUP_RESP_CODE - auto_wakeup_resp_code */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_AUTO_WAKEUP_RESP_CODE_MASK 0x8000000u

/*! Field RFU0 - rfu0 */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_RFU2_POS 30
/*! Field RFU2 - rfu2 */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_RFU2_MASK 0x40000000u

/*! Field RFU3 - rfu3 */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_RFU3_POS 31
/*! Field RFU3 - rfu3 */
#define REG0_TDM4_TA_TDM4_TA_AGENT_CONTROL_RFU3_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TDM4_TA_TDM4_TA_AGENT_STATUS Register REG0_TDM4_TA_TDM4_TA_AGENT_STATUS - agent_status */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS 0x15828
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDM4_TA_TDM4_TA_AGENT_STATUS 0x18015828u

/*! Register Reset Value */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_RST 0x0000000000000000u

/*! Field CORE_RESET - core_reset */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_CORE_RESET_POS 0
/*! Field CORE_RESET - core_reset */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_CORE_RESET_MASK 0x1u

/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_POS 3
/*! Field FUNCTIONAL_RESET_TIMEOUT - functional_reset_timeout */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_FUNCTIONAL_RESET_TIMEOUT_MASK 0x8u

/*! Field REQ_WAITING - req_waiting */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_REQ_WAITING_POS 4
/*! Field REQ_WAITING - req_waiting */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_REQ_WAITING_MASK 0x10u

/*! Field RESP_ACTIVE - resp_active */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_RESP_ACTIVE_POS 5
/*! Field RESP_ACTIVE - resp_active */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_RESP_ACTIVE_MASK 0x20u

/*! Field BURST - burst */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_BURST_POS 6
/*! Field BURST - burst */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_BURST_MASK 0x40u

/*! Field READEX - readex */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_READEX_POS 7
/*! Field READEX - readex */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_READEX_MASK 0x80u

/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_REQ_TIMEOUT_POS 8
/*! Field REQ_TIMEOUT - req_timeout */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_REQ_TIMEOUT_MASK 0x100u

/*! Field TIMEBASE - timebase */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_TIMEBASE_POS 12
/*! Field TIMEBASE - timebase */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_TIMEBASE_MASK 0xF000u

/*! Field BURST_CLOSE - burst_close */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_BURST_CLOSE_POS 16
/*! Field BURST_CLOSE - burst_close */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_BURST_CLOSE_MASK 0x10000u

/*! Field SERROR - serror */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_SERROR_POS 24
/*! Field SERROR - serror */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_SERROR_MASK 0x1000000u

/*! Field RFU0 - rfu0 */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_RFU0_POS 28
/*! Field RFU0 - rfu0 */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_RFU0_MASK 0x10000000u

/*! Field RFU1 - rfu1 */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_RFU1_POS 29
/*! Field RFU1 - rfu1 */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_RFU1_MASK 0x20000000u

/*! Field RFU2 - rfu2 */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_RFU2_POS 31
/*! Field RFU2 - rfu2 */
#define REG0_TDM4_TA_TDM4_TA_AGENT_STATUS_RFU2_MASK 0x80000000u

/*! @} */

/*! \defgroup REG0_TDM4_TA_TDM4_TA_ERROR_LOG Register REG0_TDM4_TA_TDM4_TA_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG 0x15858
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDM4_TA_TDM4_TA_ERROR_LOG 0x18015858u

/*! Register Reset Value */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG_CMD_MASK 0x7u

/*! Field INITID - initid */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field CODE - code */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG_CODE_MASK 0xF000000u

/*! Field MULTI - multi */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field REQ_INFO - req_info */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG_REQ_INFO_POS 32
/*! Field REQ_INFO - req_info */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG_REQ_INFO_MASK 0xFF00000000u

/*! @} */

/*! \defgroup REG0_TDM4_TA_TDM4_TA_ERROR_LOG_ADDR Register REG0_TDM4_TA_TDM4_TA_ERROR_LOG_ADDR - error_log_addr */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG_ADDR 0x15860
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDM4_TA_TDM4_TA_ERROR_LOG_ADDR 0x18015860u

/*! Register Reset Value */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG_ADDR_RST 0x0000000000000000u

/*! Field ADDR - addr */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG_ADDR_ADDR_POS 0
/*! Field ADDR - addr */
#define REG0_TDM4_TA_TDM4_TA_ERROR_LOG_ADDR_ADDR_MASK 0xFFFFFFFFu

/*! @} */

/*! \defgroup REG0_TDM4_TA_TDM4_TA_BANDWIDTH_0 Register REG0_TDM4_TA_TDM4_TA_BANDWIDTH_0 - bandwidth_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_0 0x15900
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDM4_TA_TDM4_TA_BANDWIDTH_0 0x18015900u

/*! Register Reset Value */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_0_RST 0x0000000000000000u

/*! Field FRACTION_0 - fraction_0 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_0_FRACTION_0_POS 8
/*! Field FRACTION_0 - fraction_0 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_0_FRACTION_0_MASK 0xFF00u

/*! Field FRACTION_1 - fraction_1 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_0_FRACTION_1_POS 24
/*! Field FRACTION_1 - fraction_1 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_0_FRACTION_1_MASK 0xFF000000u

/*! Field FRACTION_2 - fraction_2 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_0_FRACTION_2_POS 40
/*! Field FRACTION_2 - fraction_2 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_0_FRACTION_2_MASK 0xFF0000000000u

/*! Field FRACTION_3 - fraction_3 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_0_FRACTION_3_POS 56
/*! Field FRACTION_3 - fraction_3 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_0_FRACTION_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDM4_TA_TDM4_TA_BANDWIDTH_1 Register REG0_TDM4_TA_TDM4_TA_BANDWIDTH_1 - bandwidth_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_1 0x15908
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDM4_TA_TDM4_TA_BANDWIDTH_1 0x18015908u

/*! Register Reset Value */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_1_RST 0x0000000000000000u

/*! Field FRACTION_4 - fraction_4 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_1_FRACTION_4_POS 8
/*! Field FRACTION_4 - fraction_4 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_1_FRACTION_4_MASK 0xFF00u

/*! Field FRACTION_5 - fraction_5 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_1_FRACTION_5_POS 24
/*! Field FRACTION_5 - fraction_5 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_1_FRACTION_5_MASK 0xFF000000u

/*! Field FRACTION_6 - fraction_6 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_1_FRACTION_6_POS 40
/*! Field FRACTION_6 - fraction_6 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_1_FRACTION_6_MASK 0xFF0000000000u

/*! Field FRACTION_7 - fraction_7 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_1_FRACTION_7_POS 56
/*! Field FRACTION_7 - fraction_7 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_1_FRACTION_7_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDM4_TA_TDM4_TA_BANDWIDTH_2 Register REG0_TDM4_TA_TDM4_TA_BANDWIDTH_2 - bandwidth_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_2 0x15910
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDM4_TA_TDM4_TA_BANDWIDTH_2 0x18015910u

/*! Register Reset Value */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_2_RST 0x0000000000000000u

/*! Field FRACTION_8 - fraction_8 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_2_FRACTION_8_POS 8
/*! Field FRACTION_8 - fraction_8 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_2_FRACTION_8_MASK 0xFF00u

/*! Field FRACTION_9 - fraction_9 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_2_FRACTION_9_POS 24
/*! Field FRACTION_9 - fraction_9 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_2_FRACTION_9_MASK 0xFF000000u

/*! Field FRACTION_10 - fraction_10 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_2_FRACTION_10_POS 40
/*! Field FRACTION_10 - fraction_10 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_2_FRACTION_10_MASK 0xFF0000000000u

/*! Field FRACTION_11 - fraction_11 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_2_FRACTION_11_POS 56
/*! Field FRACTION_11 - fraction_11 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_2_FRACTION_11_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDM4_TA_TDM4_TA_BANDWIDTH_3 Register REG0_TDM4_TA_TDM4_TA_BANDWIDTH_3 - bandwidth_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_3 0x15918
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDM4_TA_TDM4_TA_BANDWIDTH_3 0x18015918u

/*! Register Reset Value */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_3_RST 0x0000000000000000u

/*! Field FRACTION_12 - fraction_12 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_3_FRACTION_12_POS 8
/*! Field FRACTION_12 - fraction_12 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_3_FRACTION_12_MASK 0xFF00u

/*! Field FRACTION_13 - fraction_13 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_3_FRACTION_13_POS 24
/*! Field FRACTION_13 - fraction_13 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_3_FRACTION_13_MASK 0xFF000000u

/*! Field FRACTION_14 - fraction_14 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_3_FRACTION_14_POS 40
/*! Field FRACTION_14 - fraction_14 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_3_FRACTION_14_MASK 0xFF0000000000u

/*! Field FRACTION_15 - fraction_15 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_3_FRACTION_15_POS 56
/*! Field FRACTION_15 - fraction_15 */
#define REG0_TDM4_TA_TDM4_TA_BANDWIDTH_3_FRACTION_15_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0 Register REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0 - alloc_limit_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0 0x15A00
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0 0x18015A00u

/*! Register Reset Value */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_RST 0x0000000000000000u

/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MIN_VALUE_0_POS 0
/*! Field MIN_VALUE_0 - min_value_0 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MIN_VALUE_0_MASK 0xFFu

/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MAX_VALUE_0_POS 8
/*! Field MAX_VALUE_0 - max_value_0 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MAX_VALUE_0_MASK 0xFF00u

/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MIN_VALUE_1_POS 16
/*! Field MIN_VALUE_1 - min_value_1 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MIN_VALUE_1_MASK 0xFF0000u

/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MAX_VALUE_1_POS 24
/*! Field MAX_VALUE_1 - max_value_1 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MAX_VALUE_1_MASK 0xFF000000u

/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MIN_VALUE_2_POS 32
/*! Field MIN_VALUE_2 - min_value_2 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MIN_VALUE_2_MASK 0xFF00000000u

/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MAX_VALUE_2_POS 40
/*! Field MAX_VALUE_2 - max_value_2 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MAX_VALUE_2_MASK 0xFF0000000000u

/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MIN_VALUE_3_POS 48
/*! Field MIN_VALUE_3 - min_value_3 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MIN_VALUE_3_MASK 0xFF000000000000u

/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MAX_VALUE_3_POS 56
/*! Field MAX_VALUE_3 - max_value_3 */
#define REG0_TDM4_TA_TDM4_TA_ALLOC_LIMIT_0_MAX_VALUE_3_MASK 0xFF00000000000000u

/*! @} */

/*! \defgroup REG0_TREG0_PM_TREG0_PM_ERROR_LOG Register REG0_TREG0_PM_TREG0_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG 0x80020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_PM_TREG0_PM_ERROR_LOG 0x18080020u

/*! Register Reset Value */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_REGION_MASK 0x10u

/*! Field INITID - initid */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TREG0_PM_TREG0_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TREG0_PM_TREG0_PM_CONTROL Register REG0_TREG0_PM_TREG0_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_PM_TREG0_PM_CONTROL 0x80028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_PM_TREG0_PM_CONTROL 0x18080028u

/*! Register Reset Value */
#define REG0_TREG0_PM_TREG0_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TREG0_PM_TREG0_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TREG0_PM_TREG0_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TREG0_PM_TREG0_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TREG0_PM_TREG0_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TREG0_PM_TREG0_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TREG0_PM_TREG0_PM_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! @} */

/*! \defgroup REG0_TREG0_PM_TREG0_PM_ERROR_CLEAR_SINGLE Register REG0_TREG0_PM_TREG0_PM_ERROR_CLEAR_SINGLE - error_clear_single */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_PM_TREG0_PM_ERROR_CLEAR_SINGLE 0x80030
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_PM_TREG0_PM_ERROR_CLEAR_SINGLE 0x18080030u

/*! Register Reset Value */
#define REG0_TREG0_PM_TREG0_PM_ERROR_CLEAR_SINGLE_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TREG0_PM_TREG0_PM_ERROR_CLEAR_SINGLE_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TREG0_PM_TREG0_PM_ERROR_CLEAR_SINGLE_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TREG0_PM_TREG0_PM_ERROR_CLEAR_MULTI Register REG0_TREG0_PM_TREG0_PM_ERROR_CLEAR_MULTI - error_clear_multi */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_PM_TREG0_PM_ERROR_CLEAR_MULTI 0x80038
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_PM_TREG0_PM_ERROR_CLEAR_MULTI 0x18080038u

/*! Register Reset Value */
#define REG0_TREG0_PM_TREG0_PM_ERROR_CLEAR_MULTI_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TREG0_PM_TREG0_PM_ERROR_CLEAR_MULTI_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TREG0_PM_TREG0_PM_ERROR_CLEAR_MULTI_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TREG0_PM_TREG0_PM_READ_PERMISSION_0 Register REG0_TREG0_PM_TREG0_PM_READ_PERMISSION_0 - read_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_PM_TREG0_PM_READ_PERMISSION_0 0x80050
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_PM_TREG0_PM_READ_PERMISSION_0 0x18080050u

/*! Register Reset Value */
#define REG0_TREG0_PM_TREG0_PM_READ_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TREG0_PM_TREG0_PM_READ_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TREG0_PM_TREG0_PM_READ_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TREG0_PM_TREG0_PM_WRITE_PERMISSION_0 Register REG0_TREG0_PM_TREG0_PM_WRITE_PERMISSION_0 - write_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_PM_TREG0_PM_WRITE_PERMISSION_0 0x80058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_PM_TREG0_PM_WRITE_PERMISSION_0 0x18080058u

/*! Register Reset Value */
#define REG0_TREG0_PM_TREG0_PM_WRITE_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TREG0_PM_TREG0_PM_WRITE_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TREG0_PM_TREG0_PM_WRITE_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TREG0_PM_TREG0_PM_ADDR_MATCH_1 Register REG0_TREG0_PM_TREG0_PM_ADDR_MATCH_1 - addr_match_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_PM_TREG0_PM_ADDR_MATCH_1 0x80060
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_PM_TREG0_PM_ADDR_MATCH_1 0x18080060u

/*! Register Reset Value */
#define REG0_TREG0_PM_TREG0_PM_ADDR_MATCH_1_RST 0x0000000000080050u

/*! Field ADDR_SPACE - addr_space */
#define REG0_TREG0_PM_TREG0_PM_ADDR_MATCH_1_ADDR_SPACE_POS 0
/*! Field ADDR_SPACE - addr_space */
#define REG0_TREG0_PM_TREG0_PM_ADDR_MATCH_1_ADDR_SPACE_MASK 0x7u

/*! Field SIZE - size */
#define REG0_TREG0_PM_TREG0_PM_ADDR_MATCH_1_SIZE_POS 3
/*! Field SIZE - size */
#define REG0_TREG0_PM_TREG0_PM_ADDR_MATCH_1_SIZE_MASK 0xF8u

/*! Field LEVEL - level */
#define REG0_TREG0_PM_TREG0_PM_ADDR_MATCH_1_LEVEL_POS 9
/*! Field LEVEL - level */
#define REG0_TREG0_PM_TREG0_PM_ADDR_MATCH_1_LEVEL_MASK 0x200u

/*! Field BASE_ADDR - base_addr */
#define REG0_TREG0_PM_TREG0_PM_ADDR_MATCH_1_BASE_ADDR_POS 10
/*! Field BASE_ADDR - base_addr */
#define REG0_TREG0_PM_TREG0_PM_ADDR_MATCH_1_BASE_ADDR_MASK 0x1FFC00u

/*! @} */

/*! \defgroup REG0_TREG0_PM_TREG0_PM_READ_PERMISSION_1 Register REG0_TREG0_PM_TREG0_PM_READ_PERMISSION_1 - read_permission_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_PM_TREG0_PM_READ_PERMISSION_1 0x80070
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_PM_TREG0_PM_READ_PERMISSION_1 0x18080070u

/*! Register Reset Value */
#define REG0_TREG0_PM_TREG0_PM_READ_PERMISSION_1_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TREG0_PM_TREG0_PM_READ_PERMISSION_1_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TREG0_PM_TREG0_PM_READ_PERMISSION_1_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TREG0_PM_TREG0_PM_WRITE_PERMISSION_1 Register REG0_TREG0_PM_TREG0_PM_WRITE_PERMISSION_1 - write_permission_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TREG0_PM_TREG0_PM_WRITE_PERMISSION_1 0x80078
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TREG0_PM_TREG0_PM_WRITE_PERMISSION_1 0x18080078u

/*! Register Reset Value */
#define REG0_TREG0_PM_TREG0_PM_WRITE_PERMISSION_1_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TREG0_PM_TREG0_PM_WRITE_PERMISSION_1_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TREG0_PM_TREG0_PM_WRITE_PERMISSION_1_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TOTP_PM_TOTP_PM_ERROR_LOG Register REG0_TOTP_PM_TOTP_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG 0x80C20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_PM_TOTP_PM_ERROR_LOG 0x18080C20u

/*! Register Reset Value */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_REGION_MASK 0xF0u

/*! Field INITID - initid */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TOTP_PM_TOTP_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TOTP_PM_TOTP_PM_CONTROL Register REG0_TOTP_PM_TOTP_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_PM_TOTP_PM_CONTROL 0x80C28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_PM_TOTP_PM_CONTROL 0x18080C28u

/*! Register Reset Value */
#define REG0_TOTP_PM_TOTP_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TOTP_PM_TOTP_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TOTP_PM_TOTP_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TOTP_PM_TOTP_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TOTP_PM_TOTP_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TOTP_PM_TOTP_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TOTP_PM_TOTP_PM_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! @} */

/*! \defgroup REG0_TOTP_PM_TOTP_PM_ERROR_CLEAR_SINGLE Register REG0_TOTP_PM_TOTP_PM_ERROR_CLEAR_SINGLE - error_clear_single */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_PM_TOTP_PM_ERROR_CLEAR_SINGLE 0x80C30
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_PM_TOTP_PM_ERROR_CLEAR_SINGLE 0x18080C30u

/*! Register Reset Value */
#define REG0_TOTP_PM_TOTP_PM_ERROR_CLEAR_SINGLE_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TOTP_PM_TOTP_PM_ERROR_CLEAR_SINGLE_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TOTP_PM_TOTP_PM_ERROR_CLEAR_SINGLE_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TOTP_PM_TOTP_PM_ERROR_CLEAR_MULTI Register REG0_TOTP_PM_TOTP_PM_ERROR_CLEAR_MULTI - error_clear_multi */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_PM_TOTP_PM_ERROR_CLEAR_MULTI 0x80C38
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_PM_TOTP_PM_ERROR_CLEAR_MULTI 0x18080C38u

/*! Register Reset Value */
#define REG0_TOTP_PM_TOTP_PM_ERROR_CLEAR_MULTI_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TOTP_PM_TOTP_PM_ERROR_CLEAR_MULTI_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TOTP_PM_TOTP_PM_ERROR_CLEAR_MULTI_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TOTP_PM_TOTP_PM_READ_PERMISSION_0 Register REG0_TOTP_PM_TOTP_PM_READ_PERMISSION_0 - read_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_PM_TOTP_PM_READ_PERMISSION_0 0x80C50
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_PM_TOTP_PM_READ_PERMISSION_0 0x18080C50u

/*! Register Reset Value */
#define REG0_TOTP_PM_TOTP_PM_READ_PERMISSION_0_RST 0x0000000000000000u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TOTP_PM_TOTP_PM_READ_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TOTP_PM_TOTP_PM_READ_PERMISSION_0_BIT_VECTOR_MASK 0x1Fu

/*! @} */

/*! \defgroup REG0_TOTP_PM_TOTP_PM_WRITE_PERMISSION_0 Register REG0_TOTP_PM_TOTP_PM_WRITE_PERMISSION_0 - write_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TOTP_PM_TOTP_PM_WRITE_PERMISSION_0 0x80C58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TOTP_PM_TOTP_PM_WRITE_PERMISSION_0 0x18080C58u

/*! Register Reset Value */
#define REG0_TOTP_PM_TOTP_PM_WRITE_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TOTP_PM_TOTP_PM_WRITE_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TOTP_PM_TOTP_PM_WRITE_PERMISSION_0_BIT_VECTOR_MASK 0x1Fu

/*! @} */

/*! \defgroup REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG Register REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG 0x81020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG 0x18081020u

/*! Register Reset Value */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_REGION_MASK 0xF0u

/*! Field INITID - initid */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TCBM1_PM_TCBM1_PM_CONTROL Register REG0_TCBM1_PM_TCBM1_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_PM_TCBM1_PM_CONTROL 0x81028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_PM_TCBM1_PM_CONTROL 0x18081028u

/*! Register Reset Value */
#define REG0_TCBM1_PM_TCBM1_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TCBM1_PM_TCBM1_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TCBM1_PM_TCBM1_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TCBM1_PM_TCBM1_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TCBM1_PM_TCBM1_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TCBM1_PM_TCBM1_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TCBM1_PM_TCBM1_PM_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! @} */

/*! \defgroup REG0_TCBM1_PM_TCBM1_PM_ERROR_CLEAR_SINGLE Register REG0_TCBM1_PM_TCBM1_PM_ERROR_CLEAR_SINGLE - error_clear_single */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_CLEAR_SINGLE 0x81030
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_PM_TCBM1_PM_ERROR_CLEAR_SINGLE 0x18081030u

/*! Register Reset Value */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_CLEAR_SINGLE_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_CLEAR_SINGLE_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_CLEAR_SINGLE_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TCBM1_PM_TCBM1_PM_ERROR_CLEAR_MULTI Register REG0_TCBM1_PM_TCBM1_PM_ERROR_CLEAR_MULTI - error_clear_multi */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_CLEAR_MULTI 0x81038
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_PM_TCBM1_PM_ERROR_CLEAR_MULTI 0x18081038u

/*! Register Reset Value */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_CLEAR_MULTI_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_CLEAR_MULTI_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TCBM1_PM_TCBM1_PM_ERROR_CLEAR_MULTI_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TCBM1_PM_TCBM1_PM_READ_PERMISSION_0 Register REG0_TCBM1_PM_TCBM1_PM_READ_PERMISSION_0 - read_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_PM_TCBM1_PM_READ_PERMISSION_0 0x81050
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_PM_TCBM1_PM_READ_PERMISSION_0 0x18081050u

/*! Register Reset Value */
#define REG0_TCBM1_PM_TCBM1_PM_READ_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TCBM1_PM_TCBM1_PM_READ_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TCBM1_PM_TCBM1_PM_READ_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TCBM1_PM_TCBM1_PM_WRITE_PERMISSION_0 Register REG0_TCBM1_PM_TCBM1_PM_WRITE_PERMISSION_0 - write_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM1_PM_TCBM1_PM_WRITE_PERMISSION_0 0x81058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM1_PM_TCBM1_PM_WRITE_PERMISSION_0 0x18081058u

/*! Register Reset Value */
#define REG0_TCBM1_PM_TCBM1_PM_WRITE_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TCBM1_PM_TCBM1_PM_WRITE_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TCBM1_PM_TCBM1_PM_WRITE_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG Register REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG 0x81420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG 0x18081420u

/*! Register Reset Value */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_REGION_MASK 0xF0u

/*! Field INITID - initid */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TCBM2_PM_TCBM2_PM_CONTROL Register REG0_TCBM2_PM_TCBM2_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_PM_TCBM2_PM_CONTROL 0x81428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_PM_TCBM2_PM_CONTROL 0x18081428u

/*! Register Reset Value */
#define REG0_TCBM2_PM_TCBM2_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TCBM2_PM_TCBM2_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TCBM2_PM_TCBM2_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TCBM2_PM_TCBM2_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TCBM2_PM_TCBM2_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TCBM2_PM_TCBM2_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TCBM2_PM_TCBM2_PM_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! @} */

/*! \defgroup REG0_TCBM2_PM_TCBM2_PM_ERROR_CLEAR_SINGLE Register REG0_TCBM2_PM_TCBM2_PM_ERROR_CLEAR_SINGLE - error_clear_single */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_CLEAR_SINGLE 0x81430
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_PM_TCBM2_PM_ERROR_CLEAR_SINGLE 0x18081430u

/*! Register Reset Value */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_CLEAR_SINGLE_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_CLEAR_SINGLE_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_CLEAR_SINGLE_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TCBM2_PM_TCBM2_PM_ERROR_CLEAR_MULTI Register REG0_TCBM2_PM_TCBM2_PM_ERROR_CLEAR_MULTI - error_clear_multi */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_CLEAR_MULTI 0x81438
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_PM_TCBM2_PM_ERROR_CLEAR_MULTI 0x18081438u

/*! Register Reset Value */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_CLEAR_MULTI_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_CLEAR_MULTI_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TCBM2_PM_TCBM2_PM_ERROR_CLEAR_MULTI_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TCBM2_PM_TCBM2_PM_READ_PERMISSION_0 Register REG0_TCBM2_PM_TCBM2_PM_READ_PERMISSION_0 - read_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_PM_TCBM2_PM_READ_PERMISSION_0 0x81450
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_PM_TCBM2_PM_READ_PERMISSION_0 0x18081450u

/*! Register Reset Value */
#define REG0_TCBM2_PM_TCBM2_PM_READ_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TCBM2_PM_TCBM2_PM_READ_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TCBM2_PM_TCBM2_PM_READ_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TCBM2_PM_TCBM2_PM_WRITE_PERMISSION_0 Register REG0_TCBM2_PM_TCBM2_PM_WRITE_PERMISSION_0 - write_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TCBM2_PM_TCBM2_PM_WRITE_PERMISSION_0 0x81458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TCBM2_PM_TCBM2_PM_WRITE_PERMISSION_0 0x18081458u

/*! Register Reset Value */
#define REG0_TCBM2_PM_TCBM2_PM_WRITE_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TCBM2_PM_TCBM2_PM_WRITE_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TCBM2_PM_TCBM2_PM_WRITE_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TE123_PM_TE123_PM_ERROR_LOG Register REG0_TE123_PM_TE123_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG 0x81C20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_PM_TE123_PM_ERROR_LOG 0x18081C20u

/*! Register Reset Value */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_REGION_MASK 0xF0u

/*! Field INITID - initid */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TE123_PM_TE123_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TE123_PM_TE123_PM_CONTROL Register REG0_TE123_PM_TE123_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_PM_TE123_PM_CONTROL 0x81C28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_PM_TE123_PM_CONTROL 0x18081C28u

/*! Register Reset Value */
#define REG0_TE123_PM_TE123_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TE123_PM_TE123_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TE123_PM_TE123_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TE123_PM_TE123_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TE123_PM_TE123_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TE123_PM_TE123_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TE123_PM_TE123_PM_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! @} */

/*! \defgroup REG0_TE123_PM_TE123_PM_ERROR_CLEAR_SINGLE Register REG0_TE123_PM_TE123_PM_ERROR_CLEAR_SINGLE - error_clear_single */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_PM_TE123_PM_ERROR_CLEAR_SINGLE 0x81C30
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_PM_TE123_PM_ERROR_CLEAR_SINGLE 0x18081C30u

/*! Register Reset Value */
#define REG0_TE123_PM_TE123_PM_ERROR_CLEAR_SINGLE_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TE123_PM_TE123_PM_ERROR_CLEAR_SINGLE_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TE123_PM_TE123_PM_ERROR_CLEAR_SINGLE_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TE123_PM_TE123_PM_ERROR_CLEAR_MULTI Register REG0_TE123_PM_TE123_PM_ERROR_CLEAR_MULTI - error_clear_multi */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_PM_TE123_PM_ERROR_CLEAR_MULTI 0x81C38
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_PM_TE123_PM_ERROR_CLEAR_MULTI 0x18081C38u

/*! Register Reset Value */
#define REG0_TE123_PM_TE123_PM_ERROR_CLEAR_MULTI_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TE123_PM_TE123_PM_ERROR_CLEAR_MULTI_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TE123_PM_TE123_PM_ERROR_CLEAR_MULTI_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TE123_PM_TE123_PM_READ_PERMISSION_0 Register REG0_TE123_PM_TE123_PM_READ_PERMISSION_0 - read_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_PM_TE123_PM_READ_PERMISSION_0 0x81C50
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_PM_TE123_PM_READ_PERMISSION_0 0x18081C50u

/*! Register Reset Value */
#define REG0_TE123_PM_TE123_PM_READ_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TE123_PM_TE123_PM_READ_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TE123_PM_TE123_PM_READ_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TE123_PM_TE123_PM_WRITE_PERMISSION_0 Register REG0_TE123_PM_TE123_PM_WRITE_PERMISSION_0 - write_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TE123_PM_TE123_PM_WRITE_PERMISSION_0 0x81C58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TE123_PM_TE123_PM_WRITE_PERMISSION_0 0x18081C58u

/*! Register Reset Value */
#define REG0_TE123_PM_TE123_PM_WRITE_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TE123_PM_TE123_PM_WRITE_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TE123_PM_TE123_PM_WRITE_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TDMA3_PM_TDM3_PM_ERROR_LOG Register REG0_TDMA3_PM_TDM3_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG 0x82020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_PM_TDM3_PM_ERROR_LOG 0x18082020u

/*! Register Reset Value */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_REGION_MASK 0xF0u

/*! Field INITID - initid */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TDMA3_PM_TDM3_PM_CONTROL Register REG0_TDMA3_PM_TDM3_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_PM_TDM3_PM_CONTROL 0x82028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_PM_TDM3_PM_CONTROL 0x18082028u

/*! Register Reset Value */
#define REG0_TDMA3_PM_TDM3_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TDMA3_PM_TDM3_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TDMA3_PM_TDM3_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TDMA3_PM_TDM3_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TDMA3_PM_TDM3_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TDMA3_PM_TDM3_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TDMA3_PM_TDM3_PM_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! @} */

/*! \defgroup REG0_TDMA3_PM_TDM3_PM_ERROR_CLEAR_SINGLE Register REG0_TDMA3_PM_TDM3_PM_ERROR_CLEAR_SINGLE - error_clear_single */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_CLEAR_SINGLE 0x82030
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_PM_TDM3_PM_ERROR_CLEAR_SINGLE 0x18082030u

/*! Register Reset Value */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_CLEAR_SINGLE_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_CLEAR_SINGLE_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_CLEAR_SINGLE_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TDMA3_PM_TDM3_PM_ERROR_CLEAR_MULTI Register REG0_TDMA3_PM_TDM3_PM_ERROR_CLEAR_MULTI - error_clear_multi */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_CLEAR_MULTI 0x82038
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_PM_TDM3_PM_ERROR_CLEAR_MULTI 0x18082038u

/*! Register Reset Value */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_CLEAR_MULTI_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_CLEAR_MULTI_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TDMA3_PM_TDM3_PM_ERROR_CLEAR_MULTI_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TDMA3_PM_TDM3_PM_READ_PERMISSION_0 Register REG0_TDMA3_PM_TDM3_PM_READ_PERMISSION_0 - read_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_PM_TDM3_PM_READ_PERMISSION_0 0x82050
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_PM_TDM3_PM_READ_PERMISSION_0 0x18082050u

/*! Register Reset Value */
#define REG0_TDMA3_PM_TDM3_PM_READ_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDMA3_PM_TDM3_PM_READ_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDMA3_PM_TDM3_PM_READ_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TDMA3_PM_TDM3_PM_WRITE_PERMISSION_0 Register REG0_TDMA3_PM_TDM3_PM_WRITE_PERMISSION_0 - write_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMA3_PM_TDM3_PM_WRITE_PERMISSION_0 0x82058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMA3_PM_TDM3_PM_WRITE_PERMISSION_0 0x18082058u

/*! Register Reset Value */
#define REG0_TDMA3_PM_TDM3_PM_WRITE_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDMA3_PM_TDM3_PM_WRITE_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDMA3_PM_TDM3_PM_WRITE_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG Register REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG 0x82420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG 0x18082420u

/*! Register Reset Value */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_REGION_MASK 0xF0u

/*! Field INITID - initid */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TDMAT1_PM_TDMAT1_PM_CONTROL Register REG0_TDMAT1_PM_TDMAT1_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_PM_TDMAT1_PM_CONTROL 0x82428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_PM_TDMAT1_PM_CONTROL 0x18082428u

/*! Register Reset Value */
#define REG0_TDMAT1_PM_TDMAT1_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TDMAT1_PM_TDMAT1_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TDMAT1_PM_TDMAT1_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TDMAT1_PM_TDMAT1_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TDMAT1_PM_TDMAT1_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TDMAT1_PM_TDMAT1_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TDMAT1_PM_TDMAT1_PM_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! @} */

/*! \defgroup REG0_TDMAT1_PM_TDMAT1_PM_ERROR_CLEAR_SINGLE Register REG0_TDMAT1_PM_TDMAT1_PM_ERROR_CLEAR_SINGLE - error_clear_single */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_CLEAR_SINGLE 0x82430
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_PM_TDMAT1_PM_ERROR_CLEAR_SINGLE 0x18082430u

/*! Register Reset Value */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_CLEAR_SINGLE_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_CLEAR_SINGLE_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_CLEAR_SINGLE_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TDMAT1_PM_TDMAT1_PM_ERROR_CLEAR_MULTI Register REG0_TDMAT1_PM_TDMAT1_PM_ERROR_CLEAR_MULTI - error_clear_multi */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_CLEAR_MULTI 0x82438
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_PM_TDMAT1_PM_ERROR_CLEAR_MULTI 0x18082438u

/*! Register Reset Value */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_CLEAR_MULTI_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_CLEAR_MULTI_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TDMAT1_PM_TDMAT1_PM_ERROR_CLEAR_MULTI_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TDMAT1_PM_TDMAT1_PM_READ_PERMISSION_0 Register REG0_TDMAT1_PM_TDMAT1_PM_READ_PERMISSION_0 - read_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_PM_TDMAT1_PM_READ_PERMISSION_0 0x82450
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_PM_TDMAT1_PM_READ_PERMISSION_0 0x18082450u

/*! Register Reset Value */
#define REG0_TDMAT1_PM_TDMAT1_PM_READ_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDMAT1_PM_TDMAT1_PM_READ_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDMAT1_PM_TDMAT1_PM_READ_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TDMAT1_PM_TDMAT1_PM_WRITE_PERMISSION_0 Register REG0_TDMAT1_PM_TDMAT1_PM_WRITE_PERMISSION_0 - write_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT1_PM_TDMAT1_PM_WRITE_PERMISSION_0 0x82458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT1_PM_TDMAT1_PM_WRITE_PERMISSION_0 0x18082458u

/*! Register Reset Value */
#define REG0_TDMAT1_PM_TDMAT1_PM_WRITE_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDMAT1_PM_TDMAT1_PM_WRITE_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDMAT1_PM_TDMAT1_PM_WRITE_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TEX04_PM_TEX04_PM_ERROR_LOG Register REG0_TEX04_PM_TEX04_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG 0x84020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_PM_TEX04_PM_ERROR_LOG 0x18084020u

/*! Register Reset Value */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_REGION_MASK 0xF0u

/*! Field INITID - initid */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TEX04_PM_TEX04_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TEX04_PM_TEX04_PM_CONTROL Register REG0_TEX04_PM_TEX04_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_PM_TEX04_PM_CONTROL 0x84028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_PM_TEX04_PM_CONTROL 0x18084028u

/*! Register Reset Value */
#define REG0_TEX04_PM_TEX04_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TEX04_PM_TEX04_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TEX04_PM_TEX04_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TEX04_PM_TEX04_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TEX04_PM_TEX04_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TEX04_PM_TEX04_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TEX04_PM_TEX04_PM_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! @} */

/*! \defgroup REG0_TEX04_PM_TEX04_PM_ERROR_CLEAR_SINGLE Register REG0_TEX04_PM_TEX04_PM_ERROR_CLEAR_SINGLE - error_clear_single */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_PM_TEX04_PM_ERROR_CLEAR_SINGLE 0x84030
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_PM_TEX04_PM_ERROR_CLEAR_SINGLE 0x18084030u

/*! Register Reset Value */
#define REG0_TEX04_PM_TEX04_PM_ERROR_CLEAR_SINGLE_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TEX04_PM_TEX04_PM_ERROR_CLEAR_SINGLE_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TEX04_PM_TEX04_PM_ERROR_CLEAR_SINGLE_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TEX04_PM_TEX04_PM_ERROR_CLEAR_MULTI Register REG0_TEX04_PM_TEX04_PM_ERROR_CLEAR_MULTI - error_clear_multi */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_PM_TEX04_PM_ERROR_CLEAR_MULTI 0x84038
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_PM_TEX04_PM_ERROR_CLEAR_MULTI 0x18084038u

/*! Register Reset Value */
#define REG0_TEX04_PM_TEX04_PM_ERROR_CLEAR_MULTI_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TEX04_PM_TEX04_PM_ERROR_CLEAR_MULTI_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TEX04_PM_TEX04_PM_ERROR_CLEAR_MULTI_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TEX04_PM_TEX04_PM_READ_PERMISSION_0 Register REG0_TEX04_PM_TEX04_PM_READ_PERMISSION_0 - read_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_PM_TEX04_PM_READ_PERMISSION_0 0x84050
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_PM_TEX04_PM_READ_PERMISSION_0 0x18084050u

/*! Register Reset Value */
#define REG0_TEX04_PM_TEX04_PM_READ_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TEX04_PM_TEX04_PM_READ_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TEX04_PM_TEX04_PM_READ_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TEX04_PM_TEX04_PM_WRITE_PERMISSION_0 Register REG0_TEX04_PM_TEX04_PM_WRITE_PERMISSION_0 - write_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TEX04_PM_TEX04_PM_WRITE_PERMISSION_0 0x84058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TEX04_PM_TEX04_PM_WRITE_PERMISSION_0 0x18084058u

/*! Register Reset Value */
#define REG0_TEX04_PM_TEX04_PM_WRITE_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TEX04_PM_TEX04_PM_WRITE_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TEX04_PM_TEX04_PM_WRITE_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_ERROR_LOG Register REG0_TDDR_PM_TDDR_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG 0x84420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_ERROR_LOG 0x18084420u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_REGION_MASK 0x70u

/*! Field INITID - initid */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TDDR_PM_TDDR_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_CONTROL Register REG0_TDDR_PM_TDDR_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_CONTROL 0x84428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_CONTROL 0x18084428u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TDDR_PM_TDDR_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TDDR_PM_TDDR_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TDDR_PM_TDDR_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TDDR_PM_TDDR_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TDDR_PM_TDDR_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TDDR_PM_TDDR_PM_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_ERROR_CLEAR_SINGLE Register REG0_TDDR_PM_TDDR_PM_ERROR_CLEAR_SINGLE - error_clear_single */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_ERROR_CLEAR_SINGLE 0x84430
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_ERROR_CLEAR_SINGLE 0x18084430u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_ERROR_CLEAR_SINGLE_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TDDR_PM_TDDR_PM_ERROR_CLEAR_SINGLE_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TDDR_PM_TDDR_PM_ERROR_CLEAR_SINGLE_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_ERROR_CLEAR_MULTI Register REG0_TDDR_PM_TDDR_PM_ERROR_CLEAR_MULTI - error_clear_multi */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_ERROR_CLEAR_MULTI 0x84438
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_ERROR_CLEAR_MULTI 0x18084438u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_ERROR_CLEAR_MULTI_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TDDR_PM_TDDR_PM_ERROR_CLEAR_MULTI_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TDDR_PM_TDDR_PM_ERROR_CLEAR_MULTI_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_0 Register REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_0 - read_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_0 0x84450
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_0 0x18084450u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_0_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_0_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_0 Register REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_0 - write_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_0 0x84458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_0 0x18084458u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_0_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_0_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_1 Register REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_1 - addr_match_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_1 0x84460
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_1 0x18084460u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_1_RST 0x0000000000000000u

/*! Field ADDR_SPACE - addr_space */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_1_ADDR_SPACE_POS 0
/*! Field ADDR_SPACE - addr_space */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_1_ADDR_SPACE_MASK 0x7u

/*! Field SIZE - size */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_1_SIZE_POS 3
/*! Field SIZE - size */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_1_SIZE_MASK 0xF8u

/*! Field LEVEL - level */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_1_LEVEL_POS 9
/*! Field LEVEL - level */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_1_LEVEL_MASK 0x200u

/*! Field BASE_ADDR - base_addr */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_1_BASE_ADDR_POS 10
/*! Field BASE_ADDR - base_addr */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_1_BASE_ADDR_MASK 0xFFFFFC00u

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_1 Register REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_1 - read_permission_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_1 0x84470
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_1 0x18084470u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_1_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_1_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_1_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_1 Register REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_1 - write_permission_1 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_1 0x84478
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_1 0x18084478u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_1_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_1_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_1_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_2 Register REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_2 - addr_match_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_2 0x84480
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_2 0x18084480u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_2_RST 0x0000000000000000u

/*! Field ADDR_SPACE - addr_space */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_2_ADDR_SPACE_POS 0
/*! Field ADDR_SPACE - addr_space */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_2_ADDR_SPACE_MASK 0x7u

/*! Field SIZE - size */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_2_SIZE_POS 3
/*! Field SIZE - size */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_2_SIZE_MASK 0xF8u

/*! Field LEVEL - level */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_2_LEVEL_POS 9
/*! Field LEVEL - level */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_2_LEVEL_MASK 0x200u

/*! Field BASE_ADDR - base_addr */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_2_BASE_ADDR_POS 10
/*! Field BASE_ADDR - base_addr */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_2_BASE_ADDR_MASK 0xFFFFFC00u

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_2 Register REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_2 - read_permission_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_2 0x84490
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_2 0x18084490u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_2_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_2_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_2_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_2 Register REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_2 - write_permission_2 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_2 0x84498
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_2 0x18084498u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_2_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_2_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_2_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_3 Register REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_3 - addr_match_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_3 0x844A0
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_3 0x180844A0u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_3_RST 0x0000000000000000u

/*! Field ADDR_SPACE - addr_space */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_3_ADDR_SPACE_POS 0
/*! Field ADDR_SPACE - addr_space */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_3_ADDR_SPACE_MASK 0x7u

/*! Field SIZE - size */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_3_SIZE_POS 3
/*! Field SIZE - size */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_3_SIZE_MASK 0xF8u

/*! Field LEVEL - level */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_3_LEVEL_POS 9
/*! Field LEVEL - level */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_3_LEVEL_MASK 0x200u

/*! Field BASE_ADDR - base_addr */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_3_BASE_ADDR_POS 10
/*! Field BASE_ADDR - base_addr */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_3_BASE_ADDR_MASK 0xFFFFFC00u

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_3 Register REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_3 - read_permission_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_3 0x844B0
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_3 0x180844B0u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_3_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_3_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_3_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_3 Register REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_3 - write_permission_3 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_3 0x844B8
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_3 0x180844B8u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_3_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_3_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_3_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_4 Register REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_4 - addr_match_4 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_4 0x844C0
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_4 0x180844C0u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_4_RST 0x0000000000000000u

/*! Field ADDR_SPACE - addr_space */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_4_ADDR_SPACE_POS 0
/*! Field ADDR_SPACE - addr_space */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_4_ADDR_SPACE_MASK 0x7u

/*! Field SIZE - size */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_4_SIZE_POS 3
/*! Field SIZE - size */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_4_SIZE_MASK 0xF8u

/*! Field LEVEL - level */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_4_LEVEL_POS 9
/*! Field LEVEL - level */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_4_LEVEL_MASK 0x200u

/*! Field BASE_ADDR - base_addr */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_4_BASE_ADDR_POS 10
/*! Field BASE_ADDR - base_addr */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_4_BASE_ADDR_MASK 0xFFFFFC00u

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_4 Register REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_4 - read_permission_4 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_4 0x844D0
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_4 0x180844D0u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_4_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_4_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_4_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_4 Register REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_4 - write_permission_4 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_4 0x844D8
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_4 0x180844D8u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_4_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_4_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_4_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_5 Register REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_5 - addr_match_5 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_5 0x844E0
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_5 0x180844E0u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_5_RST 0x0000000000000000u

/*! Field ADDR_SPACE - addr_space */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_5_ADDR_SPACE_POS 0
/*! Field ADDR_SPACE - addr_space */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_5_ADDR_SPACE_MASK 0x7u

/*! Field SIZE - size */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_5_SIZE_POS 3
/*! Field SIZE - size */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_5_SIZE_MASK 0xF8u

/*! Field LEVEL - level */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_5_LEVEL_POS 9
/*! Field LEVEL - level */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_5_LEVEL_MASK 0x200u

/*! Field BASE_ADDR - base_addr */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_5_BASE_ADDR_POS 10
/*! Field BASE_ADDR - base_addr */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_5_BASE_ADDR_MASK 0xFFFFFC00u

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_5 Register REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_5 - read_permission_5 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_5 0x844F0
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_5 0x180844F0u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_5_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_5_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_5_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_5 Register REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_5 - write_permission_5 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_5 0x844F8
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_5 0x180844F8u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_5_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_5_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_5_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_6 Register REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_6 - addr_match_6 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_6 0x84500
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_6 0x18084500u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_6_RST 0x0000000000000000u

/*! Field ADDR_SPACE - addr_space */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_6_ADDR_SPACE_POS 0
/*! Field ADDR_SPACE - addr_space */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_6_ADDR_SPACE_MASK 0x7u

/*! Field SIZE - size */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_6_SIZE_POS 3
/*! Field SIZE - size */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_6_SIZE_MASK 0xF8u

/*! Field LEVEL - level */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_6_LEVEL_POS 9
/*! Field LEVEL - level */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_6_LEVEL_MASK 0x200u

/*! Field BASE_ADDR - base_addr */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_6_BASE_ADDR_POS 10
/*! Field BASE_ADDR - base_addr */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_6_BASE_ADDR_MASK 0xFFFFFC00u

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_6 Register REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_6 - read_permission_6 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_6 0x84510
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_6 0x18084510u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_6_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_6_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_6_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_6 Register REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_6 - write_permission_6 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_6 0x84518
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_6 0x18084518u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_6_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_6_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_6_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_7 Register REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_7 - addr_match_7 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_7 0x84520
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_7 0x18084520u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_7_RST 0x0000000000000000u

/*! Field ADDR_SPACE - addr_space */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_7_ADDR_SPACE_POS 0
/*! Field ADDR_SPACE - addr_space */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_7_ADDR_SPACE_MASK 0x7u

/*! Field SIZE - size */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_7_SIZE_POS 3
/*! Field SIZE - size */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_7_SIZE_MASK 0xF8u

/*! Field LEVEL - level */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_7_LEVEL_POS 9
/*! Field LEVEL - level */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_7_LEVEL_MASK 0x200u

/*! Field BASE_ADDR - base_addr */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_7_BASE_ADDR_POS 10
/*! Field BASE_ADDR - base_addr */
#define REG0_TDDR_PM_TDDR_PM_ADDR_MATCH_7_BASE_ADDR_MASK 0xFFFFFC00u

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_7 Register REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_7 - read_permission_7 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_7 0x84530
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_7 0x18084530u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_7_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_7_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_7_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_7 Register REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_7 - write_permission_7 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_7 0x84538
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_7 0x18084538u

/*! Register Reset Value */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_7_RST 0x000000000000007Fu

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_7_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_7_BIT_VECTOR_MASK 0x7Fu

/*! @} */

/*! \defgroup REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG Register REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG 0x84820
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG 0x18084820u

/*! Register Reset Value */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_REGION_MASK 0xF0u

/*! Field INITID - initid */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TPCTL_PM_TPCTL_PM_CONTROL Register REG0_TPCTL_PM_TPCTL_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_PM_TPCTL_PM_CONTROL 0x84828
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_PM_TPCTL_PM_CONTROL 0x18084828u

/*! Register Reset Value */
#define REG0_TPCTL_PM_TPCTL_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TPCTL_PM_TPCTL_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TPCTL_PM_TPCTL_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TPCTL_PM_TPCTL_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TPCTL_PM_TPCTL_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TPCTL_PM_TPCTL_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TPCTL_PM_TPCTL_PM_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! @} */

/*! \defgroup REG0_TPCTL_PM_TPCTL_PM_ERROR_CLEAR_SINGLE Register REG0_TPCTL_PM_TPCTL_PM_ERROR_CLEAR_SINGLE - error_clear_single */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_CLEAR_SINGLE 0x84830
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_PM_TPCTL_PM_ERROR_CLEAR_SINGLE 0x18084830u

/*! Register Reset Value */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_CLEAR_SINGLE_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_CLEAR_SINGLE_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_CLEAR_SINGLE_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TPCTL_PM_TPCTL_PM_ERROR_CLEAR_MULTI Register REG0_TPCTL_PM_TPCTL_PM_ERROR_CLEAR_MULTI - error_clear_multi */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_CLEAR_MULTI 0x84838
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_PM_TPCTL_PM_ERROR_CLEAR_MULTI 0x18084838u

/*! Register Reset Value */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_CLEAR_MULTI_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_CLEAR_MULTI_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TPCTL_PM_TPCTL_PM_ERROR_CLEAR_MULTI_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TPCTL_PM_TPCTL_PM_READ_PERMISSION_0 Register REG0_TPCTL_PM_TPCTL_PM_READ_PERMISSION_0 - read_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_PM_TPCTL_PM_READ_PERMISSION_0 0x84850
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_PM_TPCTL_PM_READ_PERMISSION_0 0x18084850u

/*! Register Reset Value */
#define REG0_TPCTL_PM_TPCTL_PM_READ_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TPCTL_PM_TPCTL_PM_READ_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TPCTL_PM_TPCTL_PM_READ_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TPCTL_PM_TPCTL_PM_WRITE_PERMISSION_0 Register REG0_TPCTL_PM_TPCTL_PM_WRITE_PERMISSION_0 - write_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPCTL_PM_TPCTL_PM_WRITE_PERMISSION_0 0x84858
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPCTL_PM_TPCTL_PM_WRITE_PERMISSION_0 0x18084858u

/*! Register Reset Value */
#define REG0_TPCTL_PM_TPCTL_PM_WRITE_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TPCTL_PM_TPCTL_PM_WRITE_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TPCTL_PM_TPCTL_PM_WRITE_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TPUB_PM_TPUB_PM_ERROR_LOG Register REG0_TPUB_PM_TPUB_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG 0x84C20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_PM_TPUB_PM_ERROR_LOG 0x18084C20u

/*! Register Reset Value */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_REGION_MASK 0xF0u

/*! Field INITID - initid */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TPUB_PM_TPUB_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TPUB_PM_TPUB_PM_CONTROL Register REG0_TPUB_PM_TPUB_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_PM_TPUB_PM_CONTROL 0x84C28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_PM_TPUB_PM_CONTROL 0x18084C28u

/*! Register Reset Value */
#define REG0_TPUB_PM_TPUB_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TPUB_PM_TPUB_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TPUB_PM_TPUB_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TPUB_PM_TPUB_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TPUB_PM_TPUB_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TPUB_PM_TPUB_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TPUB_PM_TPUB_PM_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! @} */

/*! \defgroup REG0_TPUB_PM_TPUB_PM_ERROR_CLEAR_SINGLE Register REG0_TPUB_PM_TPUB_PM_ERROR_CLEAR_SINGLE - error_clear_single */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_PM_TPUB_PM_ERROR_CLEAR_SINGLE 0x84C30
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_PM_TPUB_PM_ERROR_CLEAR_SINGLE 0x18084C30u

/*! Register Reset Value */
#define REG0_TPUB_PM_TPUB_PM_ERROR_CLEAR_SINGLE_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TPUB_PM_TPUB_PM_ERROR_CLEAR_SINGLE_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TPUB_PM_TPUB_PM_ERROR_CLEAR_SINGLE_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TPUB_PM_TPUB_PM_ERROR_CLEAR_MULTI Register REG0_TPUB_PM_TPUB_PM_ERROR_CLEAR_MULTI - error_clear_multi */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_PM_TPUB_PM_ERROR_CLEAR_MULTI 0x84C38
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_PM_TPUB_PM_ERROR_CLEAR_MULTI 0x18084C38u

/*! Register Reset Value */
#define REG0_TPUB_PM_TPUB_PM_ERROR_CLEAR_MULTI_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TPUB_PM_TPUB_PM_ERROR_CLEAR_MULTI_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TPUB_PM_TPUB_PM_ERROR_CLEAR_MULTI_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TPUB_PM_TPUB_PM_READ_PERMISSION_0 Register REG0_TPUB_PM_TPUB_PM_READ_PERMISSION_0 - read_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_PM_TPUB_PM_READ_PERMISSION_0 0x84C50
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_PM_TPUB_PM_READ_PERMISSION_0 0x18084C50u

/*! Register Reset Value */
#define REG0_TPUB_PM_TPUB_PM_READ_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TPUB_PM_TPUB_PM_READ_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TPUB_PM_TPUB_PM_READ_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TPUB_PM_TPUB_PM_WRITE_PERMISSION_0 Register REG0_TPUB_PM_TPUB_PM_WRITE_PERMISSION_0 - write_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPUB_PM_TPUB_PM_WRITE_PERMISSION_0 0x84C58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPUB_PM_TPUB_PM_WRITE_PERMISSION_0 0x18084C58u

/*! Register Reset Value */
#define REG0_TPUB_PM_TPUB_PM_WRITE_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TPUB_PM_TPUB_PM_WRITE_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TPUB_PM_TPUB_PM_WRITE_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TPON_PM_TPON_PM_ERROR_LOG Register REG0_TPON_PM_TPON_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG 0x85020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_PM_TPON_PM_ERROR_LOG 0x18085020u

/*! Register Reset Value */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_REGION_MASK 0xF0u

/*! Field INITID - initid */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TPON_PM_TPON_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TPON_PM_TPON_PM_CONTROL Register REG0_TPON_PM_TPON_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_PM_TPON_PM_CONTROL 0x85028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_PM_TPON_PM_CONTROL 0x18085028u

/*! Register Reset Value */
#define REG0_TPON_PM_TPON_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TPON_PM_TPON_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TPON_PM_TPON_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TPON_PM_TPON_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TPON_PM_TPON_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TPON_PM_TPON_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TPON_PM_TPON_PM_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! @} */

/*! \defgroup REG0_TPON_PM_TPON_PM_ERROR_CLEAR_SINGLE Register REG0_TPON_PM_TPON_PM_ERROR_CLEAR_SINGLE - error_clear_single */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_PM_TPON_PM_ERROR_CLEAR_SINGLE 0x85030
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_PM_TPON_PM_ERROR_CLEAR_SINGLE 0x18085030u

/*! Register Reset Value */
#define REG0_TPON_PM_TPON_PM_ERROR_CLEAR_SINGLE_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TPON_PM_TPON_PM_ERROR_CLEAR_SINGLE_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TPON_PM_TPON_PM_ERROR_CLEAR_SINGLE_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TPON_PM_TPON_PM_ERROR_CLEAR_MULTI Register REG0_TPON_PM_TPON_PM_ERROR_CLEAR_MULTI - error_clear_multi */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_PM_TPON_PM_ERROR_CLEAR_MULTI 0x85038
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_PM_TPON_PM_ERROR_CLEAR_MULTI 0x18085038u

/*! Register Reset Value */
#define REG0_TPON_PM_TPON_PM_ERROR_CLEAR_MULTI_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TPON_PM_TPON_PM_ERROR_CLEAR_MULTI_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TPON_PM_TPON_PM_ERROR_CLEAR_MULTI_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TPON_PM_TPON_PM_READ_PERMISSION_0 Register REG0_TPON_PM_TPON_PM_READ_PERMISSION_0 - read_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_PM_TPON_PM_READ_PERMISSION_0 0x85050
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_PM_TPON_PM_READ_PERMISSION_0 0x18085050u

/*! Register Reset Value */
#define REG0_TPON_PM_TPON_PM_READ_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TPON_PM_TPON_PM_READ_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TPON_PM_TPON_PM_READ_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TPON_PM_TPON_PM_WRITE_PERMISSION_0 Register REG0_TPON_PM_TPON_PM_WRITE_PERMISSION_0 - write_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TPON_PM_TPON_PM_WRITE_PERMISSION_0 0x85058
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TPON_PM_TPON_PM_WRITE_PERMISSION_0 0x18085058u

/*! Register Reset Value */
#define REG0_TPON_PM_TPON_PM_WRITE_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TPON_PM_TPON_PM_WRITE_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TPON_PM_TPON_PM_WRITE_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG Register REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG 0x85420
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG 0x18085420u

/*! Register Reset Value */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_REGION_MASK 0xF0u

/*! Field INITID - initid */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TGSWIP_PM_TGSWIP_PM_CONTROL Register REG0_TGSWIP_PM_TGSWIP_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_PM_TGSWIP_PM_CONTROL 0x85428
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_PM_TGSWIP_PM_CONTROL 0x18085428u

/*! Register Reset Value */
#define REG0_TGSWIP_PM_TGSWIP_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TGSWIP_PM_TGSWIP_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TGSWIP_PM_TGSWIP_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TGSWIP_PM_TGSWIP_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TGSWIP_PM_TGSWIP_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TGSWIP_PM_TGSWIP_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TGSWIP_PM_TGSWIP_PM_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! @} */

/*! \defgroup REG0_TGSWIP_PM_TGSWIP_PM_ERROR_CLEAR_SINGLE Register REG0_TGSWIP_PM_TGSWIP_PM_ERROR_CLEAR_SINGLE - error_clear_single */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_CLEAR_SINGLE 0x85430
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_PM_TGSWIP_PM_ERROR_CLEAR_SINGLE 0x18085430u

/*! Register Reset Value */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_CLEAR_SINGLE_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_CLEAR_SINGLE_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_CLEAR_SINGLE_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TGSWIP_PM_TGSWIP_PM_ERROR_CLEAR_MULTI Register REG0_TGSWIP_PM_TGSWIP_PM_ERROR_CLEAR_MULTI - error_clear_multi */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_CLEAR_MULTI 0x85438
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_PM_TGSWIP_PM_ERROR_CLEAR_MULTI 0x18085438u

/*! Register Reset Value */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_CLEAR_MULTI_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_CLEAR_MULTI_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TGSWIP_PM_TGSWIP_PM_ERROR_CLEAR_MULTI_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TGSWIP_PM_TGSWIP_PM_READ_PERMISSION_0 Register REG0_TGSWIP_PM_TGSWIP_PM_READ_PERMISSION_0 - read_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_PM_TGSWIP_PM_READ_PERMISSION_0 0x85450
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_PM_TGSWIP_PM_READ_PERMISSION_0 0x18085450u

/*! Register Reset Value */
#define REG0_TGSWIP_PM_TGSWIP_PM_READ_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TGSWIP_PM_TGSWIP_PM_READ_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TGSWIP_PM_TGSWIP_PM_READ_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TGSWIP_PM_TGSWIP_PM_WRITE_PERMISSION_0 Register REG0_TGSWIP_PM_TGSWIP_PM_WRITE_PERMISSION_0 - write_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TGSWIP_PM_TGSWIP_PM_WRITE_PERMISSION_0 0x85458
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TGSWIP_PM_TGSWIP_PM_WRITE_PERMISSION_0 0x18085458u

/*! Register Reset Value */
#define REG0_TGSWIP_PM_TGSWIP_PM_WRITE_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TGSWIP_PM_TGSWIP_PM_WRITE_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TGSWIP_PM_TGSWIP_PM_WRITE_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG Register REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG 0x85820
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG 0x18085820u

/*! Register Reset Value */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_REGION_MASK 0xF0u

/*! Field INITID - initid */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TQSPIC_PM_TQSPIC_PM_CONTROL Register REG0_TQSPIC_PM_TQSPIC_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_PM_TQSPIC_PM_CONTROL 0x85828
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_PM_TQSPIC_PM_CONTROL 0x18085828u

/*! Register Reset Value */
#define REG0_TQSPIC_PM_TQSPIC_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TQSPIC_PM_TQSPIC_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TQSPIC_PM_TQSPIC_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TQSPIC_PM_TQSPIC_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TQSPIC_PM_TQSPIC_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TQSPIC_PM_TQSPIC_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TQSPIC_PM_TQSPIC_PM_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! @} */

/*! \defgroup REG0_TQSPIC_PM_TQSPIC_PM_ERROR_CLEAR_SINGLE Register REG0_TQSPIC_PM_TQSPIC_PM_ERROR_CLEAR_SINGLE - error_clear_single */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_CLEAR_SINGLE 0x85830
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_PM_TQSPIC_PM_ERROR_CLEAR_SINGLE 0x18085830u

/*! Register Reset Value */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_CLEAR_SINGLE_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_CLEAR_SINGLE_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_CLEAR_SINGLE_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TQSPIC_PM_TQSPIC_PM_ERROR_CLEAR_MULTI Register REG0_TQSPIC_PM_TQSPIC_PM_ERROR_CLEAR_MULTI - error_clear_multi */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_CLEAR_MULTI 0x85838
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_PM_TQSPIC_PM_ERROR_CLEAR_MULTI 0x18085838u

/*! Register Reset Value */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_CLEAR_MULTI_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_CLEAR_MULTI_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TQSPIC_PM_TQSPIC_PM_ERROR_CLEAR_MULTI_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TQSPIC_PM_TQSPIC_PM_READ_PERMISSION_0 Register REG0_TQSPIC_PM_TQSPIC_PM_READ_PERMISSION_0 - read_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_PM_TQSPIC_PM_READ_PERMISSION_0 0x85850
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_PM_TQSPIC_PM_READ_PERMISSION_0 0x18085850u

/*! Register Reset Value */
#define REG0_TQSPIC_PM_TQSPIC_PM_READ_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TQSPIC_PM_TQSPIC_PM_READ_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TQSPIC_PM_TQSPIC_PM_READ_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TQSPIC_PM_TQSPIC_PM_WRITE_PERMISSION_0 Register REG0_TQSPIC_PM_TQSPIC_PM_WRITE_PERMISSION_0 - write_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TQSPIC_PM_TQSPIC_PM_WRITE_PERMISSION_0 0x85858
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TQSPIC_PM_TQSPIC_PM_WRITE_PERMISSION_0 0x18085858u

/*! Register Reset Value */
#define REG0_TQSPIC_PM_TQSPIC_PM_WRITE_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TQSPIC_PM_TQSPIC_PM_WRITE_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TQSPIC_PM_TQSPIC_PM_WRITE_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TMSI_PM_TMSI1_PM_ERROR_LOG Register REG0_TMSI_PM_TMSI1_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG 0x85C20
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI_PM_TMSI1_PM_ERROR_LOG 0x18085C20u

/*! Register Reset Value */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_REGION_MASK 0xF0u

/*! Field INITID - initid */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TMSI_PM_TMSI1_PM_CONTROL Register REG0_TMSI_PM_TMSI1_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI_PM_TMSI1_PM_CONTROL 0x85C28
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI_PM_TMSI1_PM_CONTROL 0x18085C28u

/*! Register Reset Value */
#define REG0_TMSI_PM_TMSI1_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TMSI_PM_TMSI1_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TMSI_PM_TMSI1_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TMSI_PM_TMSI1_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TMSI_PM_TMSI1_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TMSI_PM_TMSI1_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TMSI_PM_TMSI1_PM_CONTROL_SECONDARY_REP_SHADOW_MASK 0x40000000u

/*! @} */

/*! \defgroup REG0_TMSI_PM_TMSI1_PM_ERROR_CLEAR_SINGLE Register REG0_TMSI_PM_TMSI1_PM_ERROR_CLEAR_SINGLE - error_clear_single */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_CLEAR_SINGLE 0x85C30
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI_PM_TMSI1_PM_ERROR_CLEAR_SINGLE 0x18085C30u

/*! Register Reset Value */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_CLEAR_SINGLE_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_CLEAR_SINGLE_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_CLEAR_SINGLE_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TMSI_PM_TMSI1_PM_ERROR_CLEAR_MULTI Register REG0_TMSI_PM_TMSI1_PM_ERROR_CLEAR_MULTI - error_clear_multi */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_CLEAR_MULTI 0x85C38
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI_PM_TMSI1_PM_ERROR_CLEAR_MULTI 0x18085C38u

/*! Register Reset Value */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_CLEAR_MULTI_RST 0x0000000000000000u

/*! Field CLEAR - clear */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_CLEAR_MULTI_CLEAR_POS 0
/*! Field CLEAR - clear */
#define REG0_TMSI_PM_TMSI1_PM_ERROR_CLEAR_MULTI_CLEAR_MASK 0x1u

/*! @} */

/*! \defgroup REG0_TMSI_PM_TMSI1_PM_READ_PERMISSION_0 Register REG0_TMSI_PM_TMSI1_PM_READ_PERMISSION_0 - read_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI_PM_TMSI1_PM_READ_PERMISSION_0 0x85C50
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI_PM_TMSI1_PM_READ_PERMISSION_0 0x18085C50u

/*! Register Reset Value */
#define REG0_TMSI_PM_TMSI1_PM_READ_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TMSI_PM_TMSI1_PM_READ_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TMSI_PM_TMSI1_PM_READ_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TMSI_PM_TMSI1_PM_WRITE_PERMISSION_0 Register REG0_TMSI_PM_TMSI1_PM_WRITE_PERMISSION_0 - write_permission_0 */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TMSI_PM_TMSI1_PM_WRITE_PERMISSION_0 0x85C58
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TMSI_PM_TMSI1_PM_WRITE_PERMISSION_0 0x18085C58u

/*! Register Reset Value */
#define REG0_TMSI_PM_TMSI1_PM_WRITE_PERMISSION_0_RST 0x0000000000000001u

/*! Field BIT_VECTOR - bit_vector */
#define REG0_TMSI_PM_TMSI1_PM_WRITE_PERMISSION_0_BIT_VECTOR_POS 0
/*! Field BIT_VECTOR - bit_vector */
#define REG0_TMSI_PM_TMSI1_PM_WRITE_PERMISSION_0_BIT_VECTOR_MASK 0x3Fu

/*! @} */

/*! \defgroup REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG Register REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG - error_log */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG 0x86020
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG 0x18086020u

/*! Register Reset Value */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_RST 0x0000000000000000u

/*! Field CMD - cmd */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_CMD_POS 0
/*! Field CMD - cmd */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_CMD_MASK 0x7u

/*! Field REGION - region */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_REGION_POS 4
/*! Field REGION - region */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_REGION_MASK 0xF0u

/*! Field INITID - initid */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_INITID_POS 8
/*! Field INITID - initid */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_INITID_MASK 0xFF00u

/*! Field REQ_INFO - req_info */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_REQ_INFO_POS 16
/*! Field REQ_INFO - req_info */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_REQ_INFO_MASK 0x1F0000u

/*! Field CODE - code */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_CODE_POS 24
/*! Field CODE - code */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_CODE_MASK 0x3000000u

/*! Field SECONDARY - secondary */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_SECONDARY_POS 30
/*! Field SECONDARY - secondary */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_SECONDARY_MASK 0x40000000u

/*! Field MULTI - multi */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_MULTI_POS 31
/*! Field MULTI - multi */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_MULTI_MASK 0x80000000u

/*! Field GROUP - group */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_GROUP_POS 32
/*! Field GROUP - group */
#define REG0_TDMAT2_PM_TDMAT2_PM_ERROR_LOG_GROUP_MASK 0x700000000u

/*! @} */

/*! \defgroup REG0_TDMAT2_PM_TDMAT2_PM_CONTROL Register REG0_TDMAT2_PM_TDMAT2_PM_CONTROL - control */
/*! @{ */

/*! Register Offset (relative) */
#define REG0_TDMAT2_PM_TDMAT2_PM_CONTROL 0x86028
/*! Register Offset (absolute) for 1st Instance SSX1 */
#define SSX1_REG0_TDMAT2_PM_TDMAT2_PM_CONTROL 0x18086028u

/*! Register Reset Value */
#define REG0_TDMAT2_PM_TDMAT2_PM_CONTROL_RST 0x0000000000000000u

/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TDMAT2_PM_TDMAT2_PM_CONTROL_ERROR_PRIMARY_REP_POS 24
/*! Field ERROR_PRIMARY_REP - error_primary_rep */
#define REG0_TDMAT2_PM_TDMAT2_PM_CONTROL_ERROR_PRIMARY_REP_MASK 0x1000000u

/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TDMAT2_PM_TDMAT2_PM_CONTROL_ERROR_SECONDARY_REP_POS 25
/*! Field ERROR_SECONDARY_REP - error_secondary_rep */
#define REG0_TDMAT2_PM_TDMAT2_PM_CONTROL_ERROR_SECONDARY_REP_MASK 0x2000000u

/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TDMAT2_PM_TDMAT2_PM_CONTROL_SECONDARY_REP_SHADOW_POS 30
/*! Field SECONDARY_REP_SHADOW - secondary_rep_shadow */
#define REG0_TDMAT2_PM_TDMAT2_PM_C