//-----------------------------------------------------------------------------
//
// DSL DFE Address Definition
//
// Change log:
// Updated to 03-march-2009 release from AWARE
// 23-04-09: gck : Updated to 17-April-2009 release from AWARE
// 15-06-09: gck : Updated to 12-June-2009 release from AWARE
//        delta(masks): D_XDMA0_SA_E, D_XDMA1_SA_E, 
//                      ZT_ILV_PARAMS0, ZT_ILV_PARAMS1
//                      ZR_ILV_PARAMS0, ZR_ILV_PARAMS1
//        new         : Z_PRAM_STATUS, qt_fdqasph(memory def)                     
//                 
//-----------------------------------------------------------------------------

#ifndef __DSL_DFE_ADDRESS_DEFINE__
#define __DSL_DFE_ADDRESS_DEFINE__

#define MEI_OFFSET 0xBE116000 // This is for the MEI Interface
#define DSL_OFFSET 0xBE800000 // This is for the FPI SLAVE to AWARE DFE
#define MEIAD(a) ((a)+MEI_OFFSET)
#define FPIAD(a) ((((a)&0x300000)>>1)+((a)&0xFFFFF)+DSL_OFFSET)

/* AEC Global Address Constants */
#define aec_global_base       (0x20D000)
#define AEC_GLOBAL(r)         (int)(aec_global_base+(r))
#define aec_global_size       (0x0100)

#define AEC_PROG_DLY_CTRL                        AEC_GLOBAL(0x00)
#define AEC_PROG_DLY_CTRL_WMASK                  (0x000000f3)
#define AEC_PROG_DLY_CTRL_MASK                   (0x000000f3)
#define AEC_PROG_DLY_CTRL_DEFAULT                (0x00000001)
#define AEC_PROG_DLY_CTRL_FMASK                  (0x000000f3)
#define AEC_PROG_FIR_CTRL                        AEC_GLOBAL(0x04)
#define AEC_PROG_FIR_CTRL_WMASK                  (0x00003f13)
#define AEC_PROG_FIR_CTRL_MASK                   (0x00003f13)
#define AEC_PROG_FIR_CTRL_DEFAULT                (0x00000001)
#define AEC_PROG_FIR_CTRL_FMASK                  (0x00003f13)
#define AEC_HP_CTRL                              AEC_GLOBAL(0x08)
#define AEC_HP_CTRL_WMASK                        (0x00000f13)
#define AEC_HP_CTRL_MASK                         (0x00000f13)
#define AEC_HP_CTRL_DEFAULT                      (0x00000601)
#define AEC_HP_CTRL_FMASK                        (0x00000f13)
#define AEC_STATUS                               AEC_GLOBAL(0x0C)
#define AEC_STATUS_WMASK                         (0x00010101)
#define AEC_STATUS_MASK                          (0x00010101)
#define AEC_STATUS_DEFAULT                       (0x00000000)
#define AEC_STATUS_FMASK                         (0x00010101)
#define AEC_PROG_FIR_COEFF_3_0                   AEC_GLOBAL(0x10)
#define AEC_PROG_FIR_COEFF_3_0_WMASK             (0xffffffff)
#define AEC_PROG_FIR_COEFF_3_0_MASK              (0xffffffff)
#define AEC_PROG_FIR_COEFF_3_0_DEFAULT           (0x00000000)
#define AEC_PROG_FIR_COEFF_3_0_FMASK             (0xffffffff)
#define AEC_PROG_FIR_COEFF_7_4                   AEC_GLOBAL(0x14)
#define AEC_PROG_FIR_COEFF_7_4_WMASK             (0xffffffff)
#define AEC_PROG_FIR_COEFF_7_4_MASK              (0xffffffff)
#define AEC_PROG_FIR_COEFF_7_4_DEFAULT           (0x00000000)
#define AEC_PROG_FIR_COEFF_7_4_FMASK             (0xffffffff)
#define AEC_PROG_FIR_COEFF_B_8                   AEC_GLOBAL(0x18)
#define AEC_PROG_FIR_COEFF_B_8_WMASK             (0xffffffff)
#define AEC_PROG_FIR_COEFF_B_8_MASK              (0xffffffff)
#define AEC_PROG_FIR_COEFF_B_8_DEFAULT           (0x00000000)
#define AEC_PROG_FIR_COEFF_B_8_FMASK             (0xffffffff)
#define AEC_PROG_FIR_COEFF_F_C                   AEC_GLOBAL(0x1C)
#define AEC_PROG_FIR_COEFF_F_C_WMASK             (0xffffffff)
#define AEC_PROG_FIR_COEFF_F_C_MASK              (0xffffffff)
#define AEC_PROG_FIR_COEFF_F_C_DEFAULT           (0x00000000)
#define AEC_PROG_FIR_COEFF_F_C_FMASK             (0xffffffff)
#define AEC_AFIR_CTRL                            AEC_GLOBAL(0x000024)
#define AEC_AFIR_CTRL_WMASK                      (0x000000ff)
#define AEC_AFIR_CTRL_MASK                       (0x000000ff)
#define AEC_AFIR_CTRL_DEFAULT                    (0x00000000)
#define AEC_AFIR_CTRL_FMASK                      (0x000000ff)
#define AEC_AFIR_CFG                             AEC_GLOBAL(0x000028)
#define AEC_AFIR_CFG_WMASK                       (0x000001ff)
#define AEC_AFIR_CFG_MASK                        (0x000001ff)
#define AEC_AFIR_CFG_DEFAULT                     (0x00000080)
#define AEC_AFIR_CFG_FMASK                       (0x000001ff)
#define AEC_AFIR_CFRD                            AEC_GLOBAL(0x00002C)
#define AEC_AFIR_CFRD_WMASK                      (0x0000ffff)
#define AEC_AFIR_CFRD_MASK                       (0x0000ffff)
#define AEC_AFIR_CFRD_DEFAULT                    (0x00000000)
#define AEC_AFIR_CFRD_FMASK                      (0x0000ffff)
#define AEC_AFIR_CFWR                            AEC_GLOBAL(0x000030)
#define AEC_AFIR_CFWR_WMASK                      (0x0000ffff)
#define AEC_AFIR_CFWR_MASK                       (0x0000ffff)
#define AEC_AFIR_CFWR_DEFAULT                    (0x00000000)
#define AEC_AFIR_CFWR_FMASK                      (0x0000ffff)
#define AEC_AFIR_CFADDR                          AEC_GLOBAL(0x000034)
#define AEC_AFIR_CFADDR_WMASK                    (0x000000ff)
#define AEC_AFIR_CFADDR_MASK                     (0x000000ff)
#define AEC_AFIR_CFADDR_DEFAULT                  (0x00000000)
#define AEC_AFIR_CFADDR_FMASK                    (0x000000ff)
#define AEC_AFIR_MDLLCTL                         AEC_GLOBAL(0x000038)
#define AEC_AFIR_MDLLCTL_WMASK                   (0x0000000f)
#define AEC_AFIR_MDLLCTL_MASK                    (0x0000000f)
#define AEC_AFIR_MDLLCTL_DEFAULT                 (0x00000007)
#define AEC_AFIR_MDLLCTL_FMASK                   (0x0000000f)
#define AEC_AFIR_MDLLSTAT                        AEC_GLOBAL(0x00003C)
#define AEC_AFIR_MDLLSTAT_WMASK                  (0x00000001)
#define AEC_AFIR_MDLLSTAT_MASK                   (0x00000001)
#define AEC_AFIR_MDLLSTAT_DEFAULT                (0x00000000)
#define AEC_AFIR_MDLLSTAT_FMASK                  (0x00000001)
#define AEC_AFIR_CTRL2                           AEC_GLOBAL(0x000040)
#define AEC_AFIR_CTRL2_WMASK                     (0x00000003)
#define AEC_AFIR_CTRL2_MASK                      (0x00000003)
#define AEC_AFIR_CTRL2_DEFAULT                   (0x00000000)
#define AEC_AFIR_CTRL2_FMASK                     (0x00000003)
#define AEC_AFIR_CNT_UPDATE                      AEC_GLOBAL(0x000044)
#define AEC_AFIR_CNT_UPDATE_WMASK                (0x000000ff)
#define AEC_AFIR_CNT_UPDATE_MASK                 (0x000000ff)
#define AEC_AFIR_CNT_UPDATE_DEFAULT              (0x00000000)
#define AEC_AFIR_CNT_UPDATE_FMASK                (0x000000ff)
#define AEC_AFIR_CNT_LEAKY                       AEC_GLOBAL(0x000048)
#define AEC_AFIR_CNT_LEAKY_WMASK                 (0x0000ffff)
#define AEC_AFIR_CNT_LEAKY_MASK                  (0x0000ffff)
#define AEC_AFIR_CNT_LEAKY_DEFAULT               (0x00000000)
#define AEC_AFIR_CNT_LEAKY_FMASK                 (0x0000ffff)
#define AEC_AFIR_CNT_STOP                        AEC_GLOBAL(0x00004C)
#define AEC_AFIR_CNT_STOP_WMASK                  (0x0000ffff)
#define AEC_AFIR_CNT_STOP_MASK                   (0x0000ffff)
#define AEC_AFIR_CNT_STOP_DEFAULT                (0x00000000)
#define AEC_AFIR_CNT_STOP_FMASK                  (0x0000ffff)


/* DREG Global Address Constants */
#define dreg_global_base       (0x20D400)
#define DREG_GLOBAL(r)         (int)(dreg_global_base+(r))
#define dreg_global_size       (0x0400)

#define DREG_AT_CFG0                             DREG_GLOBAL(0x0080)
#define DREG_AT_CFG0_WMASK                       (0x0007ffff)
#define DREG_AT_CFG0_MASK                        (0x0007ffff)
#define DREG_AT_CFG0_DEFAULT                     (0x00000000)
#define DREG_AT_CFG0_FMASK                       (0x0007ffff)
#define DREG_AT_CFG1                             DREG_GLOBAL(0x0084)
#define DREG_AT_CFG1_WMASK                       (0x0007ffff)
#define DREG_AT_CFG1_MASK                        (0x0007ffff)
#define DREG_AT_CFG1_DEFAULT                     (0x00000000)
#define DREG_AT_CFG1_FMASK                       (0x0007ffff)
#define DREG_AT_CELL0                            DREG_GLOBAL(0x0090)
#define DREG_AT_CELL0_WMASK                      (0xffffffff)
#define DREG_AT_CELL0_MASK                       (0xffffffff)
#define DREG_AT_CELL0_DEFAULT                    (0x00000000)
#define DREG_AT_CELL0_FMASK                      (0xffffffff)
#define DREG_AT_CELL1                            DREG_GLOBAL(0x0094)
#define DREG_AT_CELL1_WMASK                      (0xffffffff)
#define DREG_AT_CELL1_MASK                       (0xffffffff)
#define DREG_AT_CELL1_DEFAULT                    (0x00000000)
#define DREG_AT_CELL1_FMASK                      (0xffffffff)
#define DREG_AT_IDLE_CNT0                        DREG_GLOBAL(0x0098)
#define DREG_AT_IDLE_CNT0_WMASK                  (0xffffffff)
#define DREG_AT_IDLE_CNT0_MASK                   (0xffffffff)
#define DREG_AT_IDLE_CNT0_DEFAULT                (0x00000000)
#define DREG_AT_IDLE_CNT0_FMASK                  (0xffffffff)
#define DREG_AT_IDLE_CNT1                        DREG_GLOBAL(0x009c)
#define DREG_AT_IDLE_CNT1_WMASK                  (0xffffffff)
#define DREG_AT_IDLE_CNT1_MASK                   (0xffffffff)
#define DREG_AT_IDLE_CNT1_DEFAULT                (0x00000000)
#define DREG_AT_IDLE_CNT1_FMASK                  (0xffffffff)
#define DREG_AT_IDLE0                            DREG_GLOBAL(0x00a0)
#define DREG_AT_IDLE0_WMASK                      (0x000000ff)
#define DREG_AT_IDLE0_MASK                       (0x000000ff)
#define DREG_AT_IDLE0_DEFAULT                    (0x0000006A)
#define DREG_AT_IDLE0_FMASK                      (0x000000ff)
#define DREG_AT_IDLE1                            DREG_GLOBAL(0x00a4)
#define DREG_AT_IDLE1_WMASK                      (0x000000ff)
#define DREG_AT_IDLE1_MASK                       (0x000000ff)
#define DREG_AT_IDLE1_DEFAULT                    (0x0000006A)
#define DREG_AT_IDLE1_FMASK                      (0x000000ff)
#define DREG_AR_CFG0                             DREG_GLOBAL(0x0180)
#define DREG_AR_CFG0_WMASK                       (0x0007ffff)
#define DREG_AR_CFG0_MASK                        (0x0007ffff)
#define DREG_AR_CFG0_DEFAULT                     (0x00000000)
#define DREG_AR_CFG0_FMASK                       (0x0007ffff)
#define DREG_AR_CFG1                             DREG_GLOBAL(0x0184)
#define DREG_AR_CFG1_WMASK                       (0x0007ffff)
#define DREG_AR_CFG1_MASK                        (0x0007ffff)
#define DREG_AR_CFG1_DEFAULT                     (0x00000000)
#define DREG_AR_CFG1_FMASK                       (0x0007ffff)
#define DREG_AR_STAT0                            DREG_GLOBAL(0x0198)
#define DREG_AR_STAT0_WMASK                      (0x0000003f)
#define DREG_AR_STAT0_MASK                       (0x0000003f)
#define DREG_AR_STAT0_DEFAULT                    (0x00000000)
#define DREG_AR_STAT0_FMASK                      (0x0000003f)
#define DREG_AR_STAT1                            DREG_GLOBAL(0x019c)
#define DREG_AR_STAT1_WMASK                      (0x0000003f)
#define DREG_AR_STAT1_MASK                       (0x0000003f)
#define DREG_AR_STAT1_DEFAULT                    (0x00000000)
#define DREG_AR_STAT1_FMASK                      (0x0000003f)
#define DREG_AR_CELL0                            DREG_GLOBAL(0x01a0)
#define DREG_AR_CELL0_WMASK                      (0xffffffff)
#define DREG_AR_CELL0_MASK                       (0xffffffff)
#define DREG_AR_CELL0_DEFAULT                    (0x00000000)
#define DREG_AR_CELL0_FMASK                      (0xffffffff)
#define DREG_AR_CELL1                            DREG_GLOBAL(0x01a4)
#define DREG_AR_CELL1_WMASK                      (0xffffffff)
#define DREG_AR_CELL1_MASK                       (0xffffffff)
#define DREG_AR_CELL1_DEFAULT                    (0x00000000)
#define DREG_AR_CELL1_FMASK                      (0xffffffff)
#define DREG_AR_IDLE_CNT0                        DREG_GLOBAL(0x01a8)
#define DREG_AR_IDLE_CNT0_WMASK                  (0xffffffff)
#define DREG_AR_IDLE_CNT0_MASK                   (0xffffffff)
#define DREG_AR_IDLE_CNT0_DEFAULT                (0x00000000)
#define DREG_AR_IDLE_CNT0_FMASK                  (0xffffffff)
#define DREG_AR_IDLE_CNT1                        DREG_GLOBAL(0x01ac)
#define DREG_AR_IDLE_CNT1_WMASK                  (0xffffffff)
#define DREG_AR_IDLE_CNT1_MASK                   (0xffffffff)
#define DREG_AR_IDLE_CNT1_DEFAULT                (0x00000000)
#define DREG_AR_IDLE_CNT1_FMASK                  (0xffffffff)
#define DREG_AR_AIIDLE_CNT0                      DREG_GLOBAL(0x01b0)
#define DREG_AR_AIIDLE_CNT0_WMASK                (0xffffffff)
#define DREG_AR_AIIDLE_CNT0_MASK                 (0xffffffff)
#define DREG_AR_AIIDLE_CNT0_DEFAULT              (0x00000000)
#define DREG_AR_AIIDLE_CNT0_FMASK                (0xffffffff)
#define DREG_AR_AIIDLE_CNT1                      DREG_GLOBAL(0x01b4)
#define DREG_AR_AIIDLE_CNT1_WMASK                (0xffffffff)
#define DREG_AR_AIIDLE_CNT1_MASK                 (0xffffffff)
#define DREG_AR_AIIDLE_CNT1_DEFAULT              (0x00000000)
#define DREG_AR_AIIDLE_CNT1_FMASK                (0xffffffff)
#define DREG_AR_BE_CNT0                          DREG_GLOBAL(0x01b8)
#define DREG_AR_BE_CNT0_WMASK                    (0xffffffff)
#define DREG_AR_BE_CNT0_MASK                     (0xffffffff)
#define DREG_AR_BE_CNT0_DEFAULT                  (0x00000000)
#define DREG_AR_BE_CNT0_FMASK                    (0xffffffff)
#define DREG_AR_BE_CNT1                          DREG_GLOBAL(0x01bc)
#define DREG_AR_BE_CNT1_WMASK                    (0xffffffff)
#define DREG_AR_BE_CNT1_MASK                     (0xffffffff)
#define DREG_AR_BE_CNT1_DEFAULT                  (0x00000000)
#define DREG_AR_BE_CNT1_FMASK                    (0xffffffff)
#define DREG_AR_HEC_CNT0                         DREG_GLOBAL(0x01c0)
#define DREG_AR_HEC_CNT0_WMASK                   (0xffffffff)
#define DREG_AR_HEC_CNT0_MASK                    (0xffffffff)
#define DREG_AR_HEC_CNT0_DEFAULT                 (0x00000000)
#define DREG_AR_HEC_CNT0_FMASK                   (0xffffffff)
#define DREG_AR_HEC_CNT1                         DREG_GLOBAL(0x01c4)
#define DREG_AR_HEC_CNT1_WMASK                   (0xffffffff)
#define DREG_AR_HEC_CNT1_MASK                    (0xffffffff)
#define DREG_AR_HEC_CNT1_DEFAULT                 (0x00000000)
#define DREG_AR_HEC_CNT1_FMASK                   (0xffffffff)
#define DREG_AR_CD_CNT0                          DREG_GLOBAL(0x01c8)
#define DREG_AR_CD_CNT0_WMASK                    (0xffffffff)
#define DREG_AR_CD_CNT0_MASK                     (0xffffffff)
#define DREG_AR_CD_CNT0_DEFAULT                  (0x00000000)
#define DREG_AR_CD_CNT0_FMASK                    (0xffffffff)
#define DREG_AR_CD_CNT1                          DREG_GLOBAL(0x01cc)
#define DREG_AR_CD_CNT1_WMASK                    (0xffffffff)
#define DREG_AR_CD_CNT1_MASK                     (0xffffffff)
#define DREG_AR_CD_CNT1_DEFAULT                  (0x00000000)
#define DREG_AR_CD_CNT1_FMASK                    (0xffffffff)
#define DREG_AR_IDLE0                            DREG_GLOBAL(0x01d0)
#define DREG_AR_IDLE0_WMASK                      (0x000000ff)
#define DREG_AR_IDLE0_MASK                       (0x000000ff)
#define DREG_AR_IDLE0_DEFAULT                    (0x0000006A)
#define DREG_AR_IDLE0_FMASK                      (0x000000ff)
#define DREG_AR_IDLE1                            DREG_GLOBAL(0x01d4)
#define DREG_AR_IDLE1_WMASK                      (0x000000ff)
#define DREG_AR_IDLE1_MASK                       (0x000000ff)
#define DREG_AR_IDLE1_DEFAULT                    (0x0000006A)
#define DREG_AR_IDLE1_FMASK                      (0x000000ff)
#define DREG_AR_DELIN0                           DREG_GLOBAL(0x01d8)
#define DREG_AR_DELIN0_WMASK                     (0x000000ff)
#define DREG_AR_DELIN0_MASK                      (0x000000ff)
#define DREG_AR_DELIN0_DEFAULT                   (0x00000011)
#define DREG_AR_DELIN0_FMASK                     (0x000000ff)
#define DREG_AR_DELIN1                           DREG_GLOBAL(0x01dc)
#define DREG_AR_DELIN1_WMASK                     (0x000000ff)
#define DREG_AR_DELIN1_MASK                      (0x000000ff)
#define DREG_AR_DELIN1_DEFAULT                   (0x00000011)
#define DREG_AR_DELIN1_FMASK                     (0x000000ff)
#define DREG_AR_OVDROP_CNT0                      DREG_GLOBAL(0x0260)
#define DREG_AR_OVDROP_CNT0_WMASK                (0xffffffff)
#define DREG_AR_OVDROP_CNT0_MASK                 (0xffffffff)
#define DREG_AR_OVDROP_CNT0_DEFAULT              (0x00000000)
#define DREG_AR_OVDROP_CNT0_FMASK                (0xffffffff)
#define DREG_AR_OVDROP_CNT1                      DREG_GLOBAL(0x0264)
#define DREG_AR_OVDROP_CNT1_WMASK                (0xffffffff)
#define DREG_AR_OVDROP_CNT1_MASK                 (0xffffffff)
#define DREG_AR_OVDROP_CNT1_DEFAULT              (0x00000000)
#define DREG_AR_OVDROP_CNT1_FMASK                (0xffffffff)
#define DREG_AR_CERRN_CNT0                       DREG_GLOBAL(0x0280)
#define DREG_AR_CERRN_CNT0_WMASK                 (0xffffffff)
#define DREG_AR_CERRN_CNT0_MASK                  (0xffffffff)
#define DREG_AR_CERRN_CNT0_DEFAULT               (0x00000000)
#define DREG_AR_CERRN_CNT0_FMASK                 (0xffffffff)
#define DREG_AR_CERRN_CNT1                       DREG_GLOBAL(0x0284)
#define DREG_AR_CERRN_CNT1_WMASK                 (0xffffffff)
#define DREG_AR_CERRN_CNT1_MASK                  (0xffffffff)
#define DREG_AR_CERRN_CNT1_DEFAULT               (0x00000000)
#define DREG_AR_CERRN_CNT1_FMASK                 (0xffffffff)
#define DREG_AR_CERRNP_CNT0                      DREG_GLOBAL(0x0288)
#define DREG_AR_CERRNP_CNT0_WMASK                (0xffffffff)
#define DREG_AR_CERRNP_CNT0_MASK                 (0xffffffff)
#define DREG_AR_CERRNP_CNT0_DEFAULT              (0x00000000)
#define DREG_AR_CERRNP_CNT0_FMASK                (0xffffffff)
#define DREG_AR_CERRNP_CNT1                      DREG_GLOBAL(0x028c)
#define DREG_AR_CERRNP_CNT1_WMASK                (0xffffffff)
#define DREG_AR_CERRNP_CNT1_MASK                 (0xffffffff)
#define DREG_AR_CERRNP_CNT1_DEFAULT              (0x00000000)
#define DREG_AR_CERRNP_CNT1_FMASK                (0xffffffff)
#define DREG_AR_CVN_CNT0                         DREG_GLOBAL(0x0290)
#define DREG_AR_CVN_CNT0_WMASK                   (0xffffffff)
#define DREG_AR_CVN_CNT0_MASK                    (0xffffffff)
#define DREG_AR_CVN_CNT0_DEFAULT                 (0x00000000)
#define DREG_AR_CVN_CNT0_FMASK                   (0xffffffff)
#define DREG_AR_CVN_CNT1                         DREG_GLOBAL(0x0294)
#define DREG_AR_CVN_CNT1_WMASK                   (0xffffffff)
#define DREG_AR_CVN_CNT1_MASK                    (0xffffffff)
#define DREG_AR_CVN_CNT1_DEFAULT                 (0x00000000)
#define DREG_AR_CVN_CNT1_FMASK                   (0xffffffff)
#define DREG_AR_CVNP_CNT0                        DREG_GLOBAL(0x0298)
#define DREG_AR_CVNP_CNT0_WMASK                  (0xffffffff)
#define DREG_AR_CVNP_CNT0_MASK                   (0xffffffff)
#define DREG_AR_CVNP_CNT0_DEFAULT                (0x00000000)
#define DREG_AR_CVNP_CNT0_FMASK                  (0xffffffff)
#define DREG_AR_CVNP_CNT1                        DREG_GLOBAL(0x029c)
#define DREG_AR_CVNP_CNT1_WMASK                  (0xffffffff)
#define DREG_AR_CVNP_CNT1_MASK                   (0xffffffff)
#define DREG_AR_CVNP_CNT1_DEFAULT                (0x00000000)
#define DREG_AR_CVNP_CNT1_FMASK                  (0xffffffff)
#define DREG_B0_LADR                             DREG_GLOBAL(0x02a0)
#define DREG_B0_LADR_WMASK                       (0x00001fff)
#define DREG_B0_LADR_MASK                        (0x00001fff)
#define DREG_B0_LADR_DEFAULT                     (0x00000000)
#define DREG_B0_LADR_FMASK                       (0x00001fff)
#define DREG_B1_LADR                             DREG_GLOBAL(0x02a4)
#define DREG_B1_LADR_WMASK                       (0x00001fff)
#define DREG_B1_LADR_MASK                        (0x00001fff)
#define DREG_B1_LADR_DEFAULT                     (0x00000000)
#define DREG_B1_LADR_FMASK                       (0x00001fff)
#define DREG_MISC_RAM0                           DREG_GLOBAL(0x0300)
#define DREG_MISC_RAM0_WMASK                     (0xffffffff)
#define DREG_MISC_RAM0_MASK                      (0xffffffff)
#define DREG_MISC_RAM0_DEFAULT                   (0x00000000)
#define DREG_MISC_RAM0_FMASK                     (0xffffffff)
#define DREG_MISCRAM1                            DREG_GLOBAL(0x0304)
#define DREG_MISCRAM1_WMASK                      (0xffffffff)
#define DREG_MISCRAM1_MASK                       (0xffffffff)
#define DREG_MISCRAM1_DEFAULT                    (0x00000000)
#define DREG_MISCRAM1_FMASK                      (0xffffffff)
#define DREG_MISCRAM2                            DREG_GLOBAL(0x0308)
#define DREG_MISCRAM2_WMASK                      (0xffffffff)
#define DREG_MISCRAM2_MASK                       (0xffffffff)
#define DREG_MISCRAM2_DEFAULT                    (0x00000000)
#define DREG_MISCRAM2_FMASK                      (0xffffffff)
#define DREG_MISCRAM3                            DREG_GLOBAL(0x030c)
#define DREG_MISCRAM3_WMASK                      (0xffffffff)
#define DREG_MISCRAM3_MASK                       (0xffffffff)
#define DREG_MISCRAM3_DEFAULT                    (0x00000000)
#define DREG_MISCRAM3_FMASK                      (0xffffffff)
#define DREG_MISCRAM4                            DREG_GLOBAL(0x0310)
#define DREG_MISCRAM4_WMASK                      (0xffffffff)
#define DREG_MISCRAM4_MASK                       (0xffffffff)
#define DREG_MISCRAM4_DEFAULT                    (0x00000000)
#define DREG_MISCRAM4_FMASK                      (0xffffffff)
#define DREG_MISCRAM5                            DREG_GLOBAL(0x0314)
#define DREG_MISCRAM5_WMASK                      (0xffffffff)
#define DREG_MISCRAM5_MASK                       (0xffffffff)
#define DREG_MISCRAM5_DEFAULT                    (0x00000000)
#define DREG_MISCRAM5_FMASK                      (0xffffffff)
#define DREG_MISCRAM6                            DREG_GLOBAL(0x0318)
#define DREG_MISCRAM6_WMASK                      (0xffffffff)
#define DREG_MISCRAM6_MASK                       (0xffffffff)
#define DREG_MISCRAM6_DEFAULT                    (0x00000000)
#define DREG_MISCRAM6_FMASK                      (0xffffffff)
#define DREG_MISCRAM7                            DREG_GLOBAL(0x031c)
#define DREG_MISCRAM7_WMASK                      (0xffffffff)
#define DREG_MISCRAM7_MASK                       (0xffffffff)
#define DREG_MISCRAM7_DEFAULT                    (0x00000000)
#define DREG_MISCRAM7_FMASK                      (0xffffffff)
#define DREG_MISCRAM8                            DREG_GLOBAL(0x0320)
#define DREG_MISCRAM8_WMASK                      (0xffffffff)
#define DREG_MISCRAM8_MASK                       (0xffffffff)
#define DREG_MISCRAM8_DEFAULT                    (0x00000000)
#define DREG_MISCRAM8_FMASK                      (0xffffffff)
#define DREG_MISCRAM9                            DREG_GLOBAL(0x0324)
#define DREG_MISCRAM9_WMASK                      (0xffffffff)
#define DREG_MISCRAM9_MASK                       (0xffffffff)
#define DREG_MISCRAM9_DEFAULT                    (0x00000000)
#define DREG_MISCRAM9_FMASK                      (0xffffffff)
#define DREG_MISCRAM10                           DREG_GLOBAL(0x0328)
#define DREG_MISCRAM10_WMASK                     (0xffffffff)
#define DREG_MISCRAM10_MASK                      (0xffffffff)
#define DREG_MISCRAM10_DEFAULT                   (0x00000000)
#define DREG_MISCRAM10_FMASK                     (0xffffffff)
#define DREG_MISCRAM11                           DREG_GLOBAL(0x032c)
#define DREG_MISCRAM11_WMASK                     (0xffffffff)
#define DREG_MISCRAM11_MASK                      (0xffffffff)
#define DREG_MISCRAM11_DEFAULT                   (0x00000000)
#define DREG_MISCRAM11_FMASK                     (0xffffffff)
#define DREG_MISCRAM12                           DREG_GLOBAL(0x0330)
#define DREG_MISCRAM12_WMASK                     (0xffffffff)
#define DREG_MISCRAM12_MASK                      (0xffffffff)
#define DREG_MISCRAM12_DEFAULT                   (0x00000000)
#define DREG_MISCRAM12_FMASK                     (0xffffffff)
#define DREG_MISCRAM13                           DREG_GLOBAL(0x0334)
#define DREG_MISCRAM13_WMASK                     (0xffffffff)
#define DREG_MISCRAM13_MASK                      (0xffffffff)
#define DREG_MISCRAM13_DEFAULT                   (0x00000000)
#define DREG_MISCRAM13_FMASK                     (0xffffffff)
#define DREG_MISCRAM14                           DREG_GLOBAL(0x0338)
#define DREG_MISCRAM14_WMASK                     (0xffffffff)
#define DREG_MISCRAM14_MASK                      (0xffffffff)
#define DREG_MISCRAM14_DEFAULT                   (0x00000000)
#define DREG_MISCRAM14_FMASK                     (0xffffffff)
#define DREG_MISCRAM15                           DREG_GLOBAL(0x033c)
#define DREG_MISCRAM15_WMASK                     (0xffffffff)
#define DREG_MISCRAM15_MASK                      (0xffffffff)
#define DREG_MISCRAM15_DEFAULT                   (0x00000000)
#define DREG_MISCRAM15_FMASK                     (0xffffffff)
#define DREG_MISC_RAM16                          DREG_GLOBAL(0x0340)
#define DREG_MISC_RAM16_WMASK                    (0xffffffff)
#define DREG_MISC_RAM16_MASK                     (0xffffffff)
#define DREG_MISC_RAM16_DEFAULT                  (0x00000000)
#define DREG_MISC_RAM16_FMASK                    (0xffffffff)
#define DREG_MISCRAM17                           DREG_GLOBAL(0x0344)
#define DREG_MISCRAM17_WMASK                     (0xffffffff)
#define DREG_MISCRAM17_MASK                      (0xffffffff)
#define DREG_MISCRAM17_DEFAULT                   (0x00000000)
#define DREG_MISCRAM17_FMASK                     (0xffffffff)
#define DREG_MISCRAM18                           DREG_GLOBAL(0x0348)
#define DREG_MISCRAM18_WMASK                     (0xffffffff)
#define DREG_MISCRAM18_MASK                      (0xffffffff)
#define DREG_MISCRAM18_DEFAULT                   (0x00000000)
#define DREG_MISCRAM18_FMASK                     (0xffffffff)
#define DREG_MISCRAM19                           DREG_GLOBAL(0x034c)
#define DREG_MISCRAM19_WMASK                     (0xffffffff)
#define DREG_MISCRAM19_MASK                      (0xffffffff)
#define DREG_MISCRAM19_DEFAULT                   (0x00000000)
#define DREG_MISCRAM19_FMASK                     (0xffffffff)
#define DREG_MISCRAM20                           DREG_GLOBAL(0x0350)
#define DREG_MISCRAM20_WMASK                     (0xffffffff)
#define DREG_MISCRAM20_MASK                      (0xffffffff)
#define DREG_MISCRAM20_DEFAULT                   (0x00000000)
#define DREG_MISCRAM20_FMASK                     (0xffffffff)
#define DREG_MISCRAM21                           DREG_GLOBAL(0x0354)
#define DREG_MISCRAM21_WMASK                     (0xffffffff)
#define DREG_MISCRAM21_MASK                      (0xffffffff)
#define DREG_MISCRAM21_DEFAULT                   (0x00000000)
#define DREG_MISCRAM21_FMASK                     (0xffffffff)
#define DREG_MISCRAM22                           DREG_GLOBAL(0x0358)
#define DREG_MISCRAM22_WMASK                     (0xffffffff)
#define DREG_MISCRAM22_MASK                      (0xffffffff)
#define DREG_MISCRAM22_DEFAULT                   (0x00000000)
#define DREG_MISCRAM22_FMASK                     (0xffffffff)
#define DREG_MISCRAM23                           DREG_GLOBAL(0x035c)
#define DREG_MISCRAM23_WMASK                     (0xffffffff)
#define DREG_MISCRAM23_MASK                      (0xffffffff)
#define DREG_MISCRAM23_DEFAULT                   (0x00000000)
#define DREG_MISCRAM23_FMASK                     (0xffffffff)
#define DREG_MISCRAM24                           DREG_GLOBAL(0x0360)
#define DREG_MISCRAM24_WMASK                     (0xffffffff)
#define DREG_MISCRAM24_MASK                      (0xffffffff)
#define DREG_MISCRAM24_DEFAULT                   (0x00000000)
#define DREG_MISCRAM24_FMASK                     (0xffffffff)
#define DREG_MISCRAM25                           DREG_GLOBAL(0x0364)
#define DREG_MISCRAM25_WMASK                     (0xffffffff)
#define DREG_MISCRAM25_MASK                      (0xffffffff)
#define DREG_MISCRAM25_DEFAULT                   (0x00000000)
#define DREG_MISCRAM25_FMASK                     (0xffffffff)
#define DREG_MISCRAM26                           DREG_GLOBAL(0x0368)
#define DREG_MISCRAM26_WMASK                     (0xffffffff)
#define DREG_MISCRAM26_MASK                      (0xffffffff)
#define DREG_MISCRAM26_DEFAULT                   (0x00000000)
#define DREG_MISCRAM26_FMASK                     (0xffffffff)
#define DREG_MISCRAM27                           DREG_GLOBAL(0x036c)
#define DREG_MISCRAM27_WMASK                     (0xffffffff)
#define DREG_MISCRAM27_MASK                      (0xffffffff)
#define DREG_MISCRAM27_DEFAULT                   (0x00000000)
#define DREG_MISCRAM27_FMASK                     (0xffffffff)
#define DREG_MISCRAM28                           DREG_GLOBAL(0x0370)
#define DREG_MISCRAM28_WMASK                     (0xffffffff)
#define DREG_MISCRAM28_MASK                      (0xffffffff)
#define DREG_MISCRAM28_DEFAULT                   (0x00000000)
#define DREG_MISCRAM28_FMASK                     (0xffffffff)
#define DREG_MISCRAM29                           DREG_GLOBAL(0x0374)
#define DREG_MISCRAM29_WMASK                     (0xffffffff)
#define DREG_MISCRAM29_MASK                      (0xffffffff)
#define DREG_MISCRAM29_DEFAULT                   (0x00000000)
#define DREG_MISCRAM29_FMASK                     (0xffffffff)
#define DREG_MISCRAM30                           DREG_GLOBAL(0x0378)
#define DREG_MISCRAM30_WMASK                     (0xffffffff)
#define DREG_MISCRAM30_MASK                      (0xffffffff)
#define DREG_MISCRAM30_DEFAULT                   (0x00000000)
#define DREG_MISCRAM30_FMASK                     (0xffffffff)
#define DREG_MISCRAM31                           DREG_GLOBAL(0x037c)
#define DREG_MISCRAM31_WMASK                     (0xffffffff)
#define DREG_MISCRAM31_MASK                      (0xffffffff)
#define DREG_MISCRAM31_DEFAULT                   (0x00000000)
#define DREG_MISCRAM31_FMASK                     (0xffffffff)
#define DREG_MB0_P2D_ISRS                        DREG_GLOBAL(0x0380)
#define DREG_MB0_P2D_ISRS_WMASK                  (0x000000ff)
#define DREG_MB0_P2D_ISRS_MASK                   (0x000000ff)
#define DREG_MB0_P2D_ISRS_DEFAULT                (0x00000000)
#define DREG_MB0_P2D_ISRS_FMASK                  (0x000000ff)
#define DREG_MB0_P2D_ISRC                        DREG_GLOBAL(0x0384)
#define DREG_MB0_P2D_ISRC_WMASK                  (0x000000ff)
#define DREG_MB0_P2D_ISRC_MASK                   (0x000000ff)
#define DREG_MB0_P2D_ISRC_DEFAULT                (0x00000000)
#define DREG_MB0_P2D_ISRC_FMASK                  (0x000000ff)
#define DREG_MB0_P2D_ISR                         DREG_GLOBAL(0x0388)
#define DREG_MB0_P2D_ISR_WMASK                   (0x000000ff)
#define DREG_MB0_P2D_ISR_MASK                    (0x000000ff)
#define DREG_MB0_P2D_ISR_DEFAULT                 (0x00000000)
#define DREG_MB0_P2D_ISR_FMASK                   (0x000000ff)
#define DREG_MB0_P2D_IER                         DREG_GLOBAL(0x038c)
#define DREG_MB0_P2D_IER_WMASK                   (0x000000ff)
#define DREG_MB0_P2D_IER_MASK                    (0x000000ff)
#define DREG_MB0_P2D_IER_DEFAULT                 (0x00000000)
#define DREG_MB0_P2D_IER_FMASK                   (0x000000ff)
#define DREG_MB1_P2D_ISRS                        DREG_GLOBAL(0x03c0)
#define DREG_MB1_P2D_ISRS_WMASK                  (0x000000ff)
#define DREG_MB1_P2D_ISRS_MASK                   (0x000000ff)
#define DREG_MB1_P2D_ISRS_DEFAULT                (0x00000000)
#define DREG_MB1_P2D_ISRS_FMASK                  (0x000000ff)
#define DREG_MB1_P2D_ISRC                        DREG_GLOBAL(0x03c4)
#define DREG_MB1_P2D_ISRC_WMASK                  (0x000000ff)
#define DREG_MB1_P2D_ISRC_MASK                   (0x000000ff)
#define DREG_MB1_P2D_ISRC_DEFAULT                (0x00000000)
#define DREG_MB1_P2D_ISRC_FMASK                  (0x000000ff)
#define DREG_MB1_P2D_ISR                         DREG_GLOBAL(0x03c8)
#define DREG_MB1_P2D_ISR_WMASK                   (0x000000ff)
#define DREG_MB1_P2D_ISR_MASK                    (0x000000ff)
#define DREG_MB1_P2D_ISR_DEFAULT                 (0x00000000)
#define DREG_MB1_P2D_ISR_FMASK                   (0x000000ff)
#define DREG_MB1_P2D_IER                         DREG_GLOBAL(0x03cc)
#define DREG_MB1_P2D_IER_WMASK                   (0x000000ff)
#define DREG_MB1_P2D_IER_MASK                    (0x000000ff)
#define DREG_MB1_P2D_IER_DEFAULT                 (0x00000000)
#define DREG_MB1_P2D_IER_FMASK                   (0x000000ff)
#define DREG_MB2_D2P_ISRS                        DREG_GLOBAL(0x0390)
#define DREG_MB2_D2P_ISRS_WMASK                  (0x000000ff)
#define DREG_MB2_D2P_ISRS_MASK                   (0x000000ff)
#define DREG_MB2_D2P_ISRS_DEFAULT                (0x00000000)
#define DREG_MB2_D2P_ISRS_FMASK                  (0x000000ff)
#define DREG_MB2_D2P_ISRC                        DREG_GLOBAL(0x0394)
#define DREG_MB2_D2P_ISRC_WMASK                  (0x000000ff)
#define DREG_MB2_D2P_ISRC_MASK                   (0x000000ff)
#define DREG_MB2_D2P_ISRC_DEFAULT                (0x00000000)
#define DREG_MB2_D2P_ISRC_FMASK                  (0x000000ff)
#define DREG_MB2_D2P_ISR                         DREG_GLOBAL(0x0398)
#define DREG_MB2_D2P_ISR_WMASK                   (0x000000ff)
#define DREG_MB2_D2P_ISR_MASK                    (0x000000ff)
#define DREG_MB2_D2P_ISR_DEFAULT                 (0x00000000)
#define DREG_MB2_D2P_ISR_FMASK                   (0x000000ff)
#define DREG_MB2_D2P_IER                         DREG_GLOBAL(0x039c)
#define DREG_MB2_D2P_IER_WMASK                   (0x000000ff)
#define DREG_MB2_D2P_IER_MASK                    (0x000000ff)
#define DREG_MB2_D2P_IER_DEFAULT                 (0x00000000)
#define DREG_MB2_D2P_IER_FMASK                   (0x000000ff)
#define DREG_MB3_D2P_ISRS                        DREG_GLOBAL(0x03d0)
#define DREG_MB3_D2P_ISRS_WMASK                  (0x000000ff)
#define DREG_MB3_D2P_ISRS_MASK                   (0x000000ff)
#define DREG_MB3_D2P_ISRS_DEFAULT                (0x00000000)
#define DREG_MB3_D2P_ISRS_FMASK                  (0x000000ff)
#define DREG_MB3_D2P_ISRC                        DREG_GLOBAL(0x03d4)
#define DREG_MB3_D2P_ISRC_WMASK                  (0x000000ff)
#define DREG_MB3_D2P_ISRC_MASK                   (0x000000ff)
#define DREG_MB3_D2P_ISRC_DEFAULT                (0x00000000)
#define DREG_MB3_D2P_ISRC_FMASK                  (0x000000ff)
#define DREG_MB3_D2P_ISR                         DREG_GLOBAL(0x03d8)
#define DREG_MB3_D2P_ISR_WMASK                   (0x000000ff)
#define DREG_MB3_D2P_ISR_MASK                    (0x000000ff)
#define DREG_MB3_D2P_ISR_DEFAULT                 (0x00000000)
#define DREG_MB3_D2P_ISR_FMASK                   (0x000000ff)
#define DREG_MB3_D2P_IER                         DREG_GLOBAL(0x03dc)
#define DREG_MB3_D2P_IER_WMASK                   (0x000000ff)
#define DREG_MB3_D2P_IER_MASK                    (0x000000ff)
#define DREG_MB3_D2P_IER_DEFAULT                 (0x00000000)
#define DREG_MB3_D2P_IER_FMASK                   (0x000000ff)
#define DREG_BIN_SEM0                            DREG_GLOBAL(0x03a0)
#define DREG_BIN_SEM0_WMASK                      (0x00000001)
#define DREG_BIN_SEM0_MASK                       (0x00000001)
#define DREG_BIN_SEM0_DEFAULT                    (0x00000000)
#define DREG_BIN_SEM0_FMASK                      (0x00000001)
#define DREG_BIN_SEM1                            DREG_GLOBAL(0x03e0)
#define DREG_BIN_SEM1_WMASK                      (0x00000001)
#define DREG_BIN_SEM1_MASK                       (0x00000001)
#define DREG_BIN_SEM1_DEFAULT                    (0x00000000)
#define DREG_BIN_SEM1_FMASK                      (0x00000001)

/* GLPTOP Global Address Constants */
#define glptop_global_base       (0x20CE00)
#define GLPTOP_GLOBAL(r)         (int)(glptop_global_base+(r))
#define glptop_global_size       (0x0040)

#define GLP_TOP_CFG                              GLPTOP_GLOBAL(0x00)
#define GLP_TOP_CFG_WMASK                        (0x88331111)
#define GLP_TOP_CFG_MASK                         (0x88331111)
#define GLP_TOP_CFG_DEFAULT                      (0x00330000)
#define GLP_TOP_CFG_FMASK                        (0x88331111)
#define GLP_TOP_STATUS                           GLPTOP_GLOBAL(0x04)
#define GLP_TOP_STATUS_WMASK                     (0x00001111)
#define GLP_TOP_STATUS_MASK                      (0x00001111)
#define GLP_TOP_STATUS_DEFAULT                   (0x00001010)
#define GLP_TOP_STATUS_FMASK                     (0x00001111)
#define GLP_TX0FIFO_CFG                          GLPTOP_GLOBAL(0x10)
#define GLP_TX0FIFO_CFG_WMASK                    (0x901f000f)
#define GLP_TX0FIFO_CFG_MASK                     (0x901f000f)
#define GLP_TX0FIFO_CFG_DEFAULT                  (0x00080000)
#define GLP_TX0FIFO_CFG_FMASK                    (0x901f000f)
#define GLP_RX0FIFO_CFG                          GLPTOP_GLOBAL(0x18)
#define GLP_RX0FIFO_CFG_WMASK                    (0x901f000f)
#define GLP_RX0FIFO_CFG_MASK                     (0x901f000f)
#define GLP_RX0FIFO_CFG_DEFAULT                  (0x00080000)
#define GLP_RX0FIFO_CFG_FMASK                    (0x901f000f)
#define GLP_TX1FIFO_CFG                          GLPTOP_GLOBAL(0x20)
#define GLP_TX1FIFO_CFG_WMASK                    (0x901f000f)
#define GLP_TX1FIFO_CFG_MASK                     (0x901f000f)
#define GLP_TX1FIFO_CFG_DEFAULT                  (0x00080000)
#define GLP_TX1FIFO_CFG_FMASK                    (0x901f000f)
#define GLP_RX1FIFO_CFG                          GLPTOP_GLOBAL(0x28)
#define GLP_RX1FIFO_CFG_WMASK                    (0x901f000f)
#define GLP_RX1FIFO_CFG_MASK                     (0x901f000f)
#define GLP_RX1FIFO_CFG_DEFAULT                  (0x00080000)
#define GLP_RX1FIFO_CFG_FMASK                    (0x901f000f)
#define GLP_MISC                                 GLPTOP_GLOBAL(0x3C)
#define GLP_MISC_WMASK                           (0x000000ff)
#define GLP_MISC_MASK                            (0x000000ff)
#define GLP_MISC_DEFAULT                         (0x00000000)
#define GLP_MISC_FMASK                           (0x000000ff)

/* ERRC Global Address Constants */
#define errc_global_base       (0x20CE40)
#define ERRC_GLOBAL(r)         (int)(errc_global_base+(r))
#define errc_global_size       (0x0080)

#define ERRC_RX1_CTRL                            ERRC_GLOBAL(0x000000)
#define ERRC_RX1_CTRL_WMASK                      (0x00000013)
#define ERRC_RX1_CTRL_MASK                       (0x00000013)
#define ERRC_RX1_CTRL_DEFAULT                    (0x0002)
#define ERRC_RX1_CTRL_FMASK                      (0x00000013)
#define ERRC_RX1_ERRD_CTRL                       ERRC_GLOBAL(0x000004)
#define ERRC_RX1_ERRD_CTRL_WMASK                 (0x00000311)
#define ERRC_RX1_ERRD_CTRL_MASK                  (0x00000311)
#define ERRC_RX1_ERRD_CTRL_DEFAULT               (0x0001)
#define ERRC_RX1_ERRD_CTRL_FMASK                 (0x00000311)
#define ERRC_RX1_STAT                            ERRC_GLOBAL(0x000008)
#define ERRC_RX1_STAT_WMASK                      (0x00000001)
#define ERRC_RX1_STAT_MASK                       (0x00000001)
#define ERRC_RX1_STAT_DEFAULT                    (0x0000)
#define ERRC_RX1_STAT_FMASK                      (0x00000001)
#define ERRC_RX1_SAT_CNT                         ERRC_GLOBAL(0x00000C)
#define ERRC_RX1_SAT_CNT_WMASK                   (0x0000ffff)
#define ERRC_RX1_SAT_CNT_MASK                    (0x0000ffff)
#define ERRC_RX1_SAT_CNT_DEFAULT                 (0x0000)
#define ERRC_RX1_SAT_CNT_FMASK                   (0x0000ffff)
#define ERRC_RX1_ERR_CNT                         ERRC_GLOBAL(0x000010)
#define ERRC_RX1_ERR_CNT_WMASK                   (0x0000ffff)
#define ERRC_RX1_ERR_CNT_MASK                    (0x0000ffff)
#define ERRC_RX1_ERR_CNT_DEFAULT                 (0x0000)
#define ERRC_RX1_ERR_CNT_FMASK                   (0x0000ffff)
#define ERRC_RX2_CTRL                            ERRC_GLOBAL(0x000040)
#define ERRC_RX2_CTRL_WMASK                      (0x00000013)
#define ERRC_RX2_CTRL_MASK                       (0x00000013)
#define ERRC_RX2_CTRL_DEFAULT                    (0x0002)
#define ERRC_RX2_CTRL_FMASK                      (0x00000013)
#define ERRC_RX2_ERRD_CTRL                       ERRC_GLOBAL(0x000044)
#define ERRC_RX2_ERRD_CTRL_WMASK                 (0x00000311)
#define ERRC_RX2_ERRD_CTRL_MASK                  (0x00000311)
#define ERRC_RX2_ERRD_CTRL_DEFAULT               (0x0001)
#define ERRC_RX2_ERRD_CTRL_FMASK                 (0x00000311)
#define ERRC_RX2_STAT                            ERRC_GLOBAL(0x000048)
#define ERRC_RX2_STAT_WMASK                      (0x00000001)
#define ERRC_RX2_STAT_MASK                       (0x00000001)
#define ERRC_RX2_STAT_DEFAULT                    (0x0000)
#define ERRC_RX2_STAT_FMASK                      (0x00000001)
#define ERRC_RX2_SAT_CNT                         ERRC_GLOBAL(0x00004C)
#define ERRC_RX2_SAT_CNT_WMASK                   (0x0000ffff)
#define ERRC_RX2_SAT_CNT_MASK                    (0x0000ffff)
#define ERRC_RX2_SAT_CNT_DEFAULT                 (0x0000)
#define ERRC_RX2_SAT_CNT_FMASK                   (0x0000ffff)
#define ERRC_RX2_ERR_CNT                         ERRC_GLOBAL(0x000050)
#define ERRC_RX2_ERR_CNT_WMASK                   (0x0000ffff)
#define ERRC_RX2_ERR_CNT_MASK                    (0x0000ffff)
#define ERRC_RX2_ERR_CNT_DEFAULT                 (0x0000)
#define ERRC_RX2_ERR_CNT_FMASK                   (0x0000ffff)

/* GLPM Global Address Constants */
#define glpm_global_base       (0x20CC00)
#define GLPM_GLOBAL(r)         (int)(glpm_global_base+(r))
#define glpm_global_size       (0x0200)

#define GLPM_GLP_FR_CTRL_0                       GLPM_GLOBAL(0x000000)
#define GLPM_GLP_FR_CTRL_0_WMASK                 (0x00007f7f)
#define GLPM_GLP_FR_CTRL_0_MASK                  (0x00007f7f)
#define GLPM_GLP_FR_CTRL_0_DEFAULT               (0x0000)
#define GLPM_GLP_FR_CTRL_0_FMASK                 (0x00007f7f)
#define GLPM_GLP_FR_CTRL_1                       GLPM_GLOBAL(0x000004)
#define GLPM_GLP_FR_CTRL_1_WMASK                 (0x00007f7f)
#define GLPM_GLP_FR_CTRL_1_MASK                  (0x00007f7f)
#define GLPM_GLP_FR_CTRL_1_DEFAULT               (0x0000)
#define GLPM_GLP_FR_CTRL_1_FMASK                 (0x00007f7f)
#define GLPM_GLP_FR_STATUS_0                     GLPM_GLOBAL(0x000008)
#define GLPM_GLP_FR_STATUS_0_WMASK               (0x00007fff)
#define GLPM_GLP_FR_STATUS_0_MASK                (0x00007fff)
#define GLPM_GLP_FR_STATUS_0_DEFAULT             (0x0000)
#define GLPM_GLP_FR_STATUS_0_FMASK               (0x00007fff)
#define GLPM_GLP_FR_STATUS_1                     GLPM_GLOBAL(0x00000C)
#define GLPM_GLP_FR_STATUS_1_WMASK               (0x00007fff)
#define GLPM_GLP_FR_STATUS_1_MASK                (0x00007fff)
#define GLPM_GLP_FR_STATUS_1_DEFAULT             (0x0000)
#define GLPM_GLP_FR_STATUS_1_FMASK               (0x00007fff)
#define GLPM_GLP_FR_WD_AL_0                      GLPM_GLOBAL(0x000010)
#define GLPM_GLP_FR_WD_AL_0_WMASK                (0x0000007f)
#define GLPM_GLP_FR_WD_AL_0_MASK                 (0x0000007f)
#define GLPM_GLP_FR_WD_AL_0_DEFAULT              (0x0025)
#define GLPM_GLP_FR_WD_AL_0_FMASK                (0x0000007f)
#define GLPM_GLP_FR_WD_AL_1                      GLPM_GLOBAL(0x000014)
#define GLPM_GLP_FR_WD_AL_1_WMASK                (0x0000007f)
#define GLPM_GLP_FR_WD_AL_1_MASK                 (0x0000007f)
#define GLPM_GLP_FR_WD_AL_1_DEFAULT              (0x0025)
#define GLPM_GLP_FR_WD_AL_1_FMASK                (0x0000007f)
#define GLPM_GLP_FR_MISC_0                       GLPM_GLOBAL(0x000018)
#define GLPM_GLP_FR_MISC_0_WMASK                 (0x00003fff)
#define GLPM_GLP_FR_MISC_0_MASK                  (0x00003fff)
#define GLPM_GLP_FR_MISC_0_DEFAULT               (0x0407)
#define GLPM_GLP_FR_MISC_0_FMASK                 (0x00003fff)
#define GLPM_GLP_FR_MISC_1                       GLPM_GLOBAL(0x00001C)
#define GLPM_GLP_FR_MISC_1_WMASK                 (0x00003fff)
#define GLPM_GLP_FR_MISC_1_MASK                  (0x00003fff)
#define GLPM_GLP_FR_MISC_1_DEFAULT               (0x0407)
#define GLPM_GLP_FR_MISC_1_FMASK                 (0x00003fff)
#define GLPM_GLP_FR_BITLOCK_0                    GLPM_GLOBAL(0x000020)
#define GLPM_GLP_FR_BITLOCK_0_WMASK              (0x000000ff)
#define GLPM_GLP_FR_BITLOCK_0_MASK               (0x000000ff)
#define GLPM_GLP_FR_BITLOCK_0_DEFAULT            (0x000A)
#define GLPM_GLP_FR_BITLOCK_0_FMASK              (0x000000ff)
#define GLPM_GLP_FR_BITLOCK_1                    GLPM_GLOBAL(0x000024)
#define GLPM_GLP_FR_BITLOCK_1_WMASK              (0x000000ff)
#define GLPM_GLP_FR_BITLOCK_1_MASK               (0x000000ff)
#define GLPM_GLP_FR_BITLOCK_1_DEFAULT            (0x000A)
#define GLPM_GLP_FR_BITLOCK_1_FMASK              (0x000000ff)
#define GLPM_GLP_FR_WDG_CFG_0                    GLPM_GLOBAL(0x000028)
#define GLPM_GLP_FR_WDG_CFG_0_WMASK              (0x0000ffff)
#define GLPM_GLP_FR_WDG_CFG_0_MASK               (0x0000ffff)
#define GLPM_GLP_FR_WDG_CFG_0_DEFAULT            (0xFFFF)
#define GLPM_GLP_FR_WDG_CFG_0_FMASK              (0x0000ffff)
#define GLPM_GLP_FR_WDG_CFG_1                    GLPM_GLOBAL(0x00002C)
#define GLPM_GLP_FR_WDG_CFG_1_WMASK              (0x0000ffff)
#define GLPM_GLP_FR_WDG_CFG_1_MASK               (0x0000ffff)
#define GLPM_GLP_FR_WDG_CFG_1_DEFAULT            (0xFFFF)
#define GLPM_GLP_FR_WDG_CFG_1_FMASK              (0x0000ffff)
#define GLPM_GLP_FR_ERR_LIM_0                    GLPM_GLOBAL(0x000030)
#define GLPM_GLP_FR_ERR_LIM_0_WMASK              (0x0000ffff)
#define GLPM_GLP_FR_ERR_LIM_0_MASK               (0x0000ffff)
#define GLPM_GLP_FR_ERR_LIM_0_DEFAULT            (0x0A64)
#define GLPM_GLP_FR_ERR_LIM_0_FMASK              (0x0000ffff)
#define GLPM_GLP_FR_ERR_LIM_1                    GLPM_GLOBAL(0x000034)
#define GLPM_GLP_FR_ERR_LIM_1_WMASK              (0x0000ffff)
#define GLPM_GLP_FR_ERR_LIM_1_MASK               (0x0000ffff)
#define GLPM_GLP_FR_ERR_LIM_1_DEFAULT            (0x0A64)
#define GLPM_GLP_FR_ERR_LIM_1_FMASK              (0x0000ffff)
#define GLPM_GLP_FR_UNIQ_WD_0                    GLPM_GLOBAL(0x000038)
#define GLPM_GLP_FR_UNIQ_WD_0_WMASK              (0x0000ffff)
#define GLPM_GLP_FR_UNIQ_WD_0_MASK               (0x0000ffff)
#define GLPM_GLP_FR_UNIQ_WD_0_DEFAULT            (0x6E78)
#define GLPM_GLP_FR_UNIQ_WD_0_FMASK              (0x0000ffff)
#define GLPM_GLP_FR_UNIQ_WD_1                    GLPM_GLOBAL(0x00003C)
#define GLPM_GLP_FR_UNIQ_WD_1_WMASK              (0x0000ffff)
#define GLPM_GLP_FR_UNIQ_WD_1_MASK               (0x0000ffff)
#define GLPM_GLP_FR_UNIQ_WD_1_DEFAULT            (0x6E78)
#define GLPM_GLP_FR_UNIQ_WD_1_FMASK              (0x0000ffff)
#define GLPM_GLP_FR_RX_UNIQ_WD_0                 GLPM_GLOBAL(0x000040)
#define GLPM_GLP_FR_RX_UNIQ_WD_0_WMASK           (0x0000ffff)
#define GLPM_GLP_FR_RX_UNIQ_WD_0_MASK            (0x0000ffff)
#define GLPM_GLP_FR_RX_UNIQ_WD_0_DEFAULT         (0x0000)
#define GLPM_GLP_FR_RX_UNIQ_WD_0_FMASK           (0x0000ffff)
#define GLPM_GLP_FR_RX_UNIQ_WD_1                 GLPM_GLOBAL(0x000044)
#define GLPM_GLP_FR_RX_UNIQ_WD_1_WMASK           (0x0000ffff)
#define GLPM_GLP_FR_RX_UNIQ_WD_1_MASK            (0x0000ffff)
#define GLPM_GLP_FR_RX_UNIQ_WD_1_DEFAULT         (0x0000)
#define GLPM_GLP_FR_RX_UNIQ_WD_1_FMASK           (0x0000ffff)
#define GLPM_GLP_FR_ERR_0                        GLPM_GLOBAL(0x000048)
#define GLPM_GLP_FR_ERR_0_WMASK                  (0x0000ffff)
#define GLPM_GLP_FR_ERR_0_MASK                   (0x0000ffff)
#define GLPM_GLP_FR_ERR_0_DEFAULT                (0x0000)
#define GLPM_GLP_FR_ERR_0_FMASK                  (0x0000ffff)
#define GLPM_GLP_FR_ERR_1                        GLPM_GLOBAL(0x00004C)
#define GLPM_GLP_FR_ERR_1_WMASK                  (0x0000ffff)
#define GLPM_GLP_FR_ERR_1_MASK                   (0x0000ffff)
#define GLPM_GLP_FR_ERR_1_DEFAULT                (0x0000)
#define GLPM_GLP_FR_ERR_1_FMASK                  (0x0000ffff)
#define GLPM_GLP_BIST_CTRL                       GLPM_GLOBAL(0x000050)
#define GLPM_GLP_BIST_CTRL_WMASK                 (0x0000007f)
#define GLPM_GLP_BIST_CTRL_MASK                  (0x0000007f)
#define GLPM_GLP_BIST_CTRL_DEFAULT               (0x0000)
#define GLPM_GLP_BIST_CTRL_FMASK                 (0x0000007f)
#define GLPM_GLP_BIST_PHLOCK                     GLPM_GLOBAL(0x000054)
#define GLPM_GLP_BIST_PHLOCK_WMASK               (0x000003ff)
#define GLPM_GLP_BIST_PHLOCK_MASK                (0x000003ff)
#define GLPM_GLP_BIST_PHLOCK_DEFAULT             (0x03E8)
#define GLPM_GLP_BIST_PHLOCK_FMASK               (0x000003ff)
#define GLPM_GLP_BIST_END                        GLPM_GLOBAL(0x000058)
#define GLPM_GLP_BIST_END_WMASK                  (0x000003ff)
#define GLPM_GLP_BIST_END_MASK                   (0x000003ff)
#define GLPM_GLP_BIST_END_DEFAULT                (0x03E8)
#define GLPM_GLP_BIST_END_FMASK                  (0x000003ff)
#define GLPM_GLP_BERT_TERM                       GLPM_GLOBAL(0x00005C)
#define GLPM_GLP_BERT_TERM_WMASK                 (0x000003ff)
#define GLPM_GLP_BERT_TERM_MASK                  (0x000003ff)
#define GLPM_GLP_BERT_TERM_DEFAULT               (0x0000)
#define GLPM_GLP_BERT_TERM_FMASK                 (0x000003ff)
#define GLPM_GLP_BERT_ERR                        GLPM_GLOBAL(0x000060)
#define GLPM_GLP_BERT_ERR_WMASK                  (0x000003ff)
#define GLPM_GLP_BERT_ERR_MASK                   (0x000003ff)
#define GLPM_GLP_BERT_ERR_DEFAULT                (0x0000)
#define GLPM_GLP_BERT_ERR_FMASK                  (0x000003ff)
#define GLPM_GLP_BERT_CTRL                       GLPM_GLOBAL(0x000064)
#define GLPM_GLP_BERT_CTRL_WMASK                 (0x000007ff)
#define GLPM_GLP_BERT_CTRL_MASK                  (0x000007ff)
#define GLPM_GLP_BERT_CTRL_DEFAULT               (0x0180)
#define GLPM_GLP_BERT_CTRL_FMASK                 (0x000007ff)
#define GLPM_GLP_GLP_CTRL                        GLPM_GLOBAL(0x000068)
#define GLPM_GLP_GLP_CTRL_WMASK                  (0x0000007f)
#define GLPM_GLP_GLP_CTRL_MASK                   (0x0000007f)
#define GLPM_GLP_GLP_CTRL_DEFAULT                (0x0008)
#define GLPM_GLP_GLP_CTRL_FMASK                  (0x0000007f)
#define GLPM_GLP_GLP_MISC                        GLPM_GLOBAL(0x00006C)
#define GLPM_GLP_GLP_MISC_WMASK                  (0x0000ffff)
#define GLPM_GLP_GLP_MISC_MASK                   (0x0000ffff)
#define GLPM_GLP_GLP_MISC_DEFAULT                (0xC0C0)
#define GLPM_GLP_GLP_MISC_FMASK                  (0x0000ffff)
#define GLPM_PMA_STARTUP_CTRL                    GLPM_GLOBAL(0x000080)
#define GLPM_PMA_STARTUP_CTRL_WMASK              (0x000007ff)
#define GLPM_PMA_STARTUP_CTRL_MASK               (0x000007ff)
#define GLPM_PMA_STARTUP_CTRL_DEFAULT            (0x0400)
#define GLPM_PMA_STARTUP_CTRL_FMASK              (0x000007ff)
#define GLPM_PMA_STATE                           GLPM_GLOBAL(0x000084)
#define GLPM_PMA_STATE_WMASK                     (0x00000007)
#define GLPM_PMA_STATE_MASK                      (0x00000007)
#define GLPM_PMA_STATE_DEFAULT                   (0x0000)
#define GLPM_PMA_STATE_FMASK                     (0x00000007)
#define GLPM_PLL_CTRL1                           GLPM_GLOBAL(0x000088)
#define GLPM_PLL_CTRL1_WMASK                     (0x0000ffff)
#define GLPM_PLL_CTRL1_MASK                      (0x0000ffff)
#define GLPM_PLL_CTRL1_DEFAULT                   (0x8E39)
#define GLPM_PLL_CTRL1_FMASK                     (0x0000ffff)
#define GLPM_PLL_CTRL2                           GLPM_GLOBAL(0x00008C)
#define GLPM_PLL_CTRL2_WMASK                     (0x0000ffff)
#define GLPM_PLL_CTRL2_MASK                      (0x0000ffff)
#define GLPM_PLL_CTRL2_DEFAULT                   (0x0383)
#define GLPM_PLL_CTRL2_FMASK                     (0x0000ffff)
#define GLPM_PLL_CTRL3                           GLPM_GLOBAL(0x000090)
#define GLPM_PLL_CTRL3_WMASK                     (0x00003fff)
#define GLPM_PLL_CTRL3_MASK                      (0x00003fff)
#define GLPM_PLL_CTRL3_DEFAULT                   (0x0000)
#define GLPM_PLL_CTRL3_FMASK                     (0x00003fff)
#define GLPM_PLL_CTRL4                           GLPM_GLOBAL(0x000094)
#define GLPM_PLL_CTRL4_WMASK                     (0x0000ffff)
#define GLPM_PLL_CTRL4_MASK                      (0x0000ffff)
#define GLPM_PLL_CTRL4_DEFAULT                   (0x0000)
#define GLPM_PLL_CTRL4_FMASK                     (0x0000ffff)
#define GLPM_PLL_CTRL5                           GLPM_GLOBAL(0x000098)
#define GLPM_PLL_CTRL5_WMASK                     (0x0000ffff)
#define GLPM_PLL_CTRL5_MASK                      (0x0000ffff)
#define GLPM_PLL_CTRL5_DEFAULT                   (0x0000)
#define GLPM_PLL_CTRL5_FMASK                     (0x0000ffff)
#define GLPM_PLL_CTRL6                           GLPM_GLOBAL(0x00009C)
#define GLPM_PLL_CTRL6_WMASK                     (0x0000ffff)
#define GLPM_PLL_CTRL6_MASK                      (0x0000ffff)
#define GLPM_PLL_CTRL6_DEFAULT                   (0x0000)
#define GLPM_PLL_CTRL6_FMASK                     (0x0000ffff)
#define GLPM_PLL_CTRL7                           GLPM_GLOBAL(0x0000A0)
#define GLPM_PLL_CTRL7_WMASK                     (0x0000ffff)
#define GLPM_PLL_CTRL7_MASK                      (0x0000ffff)
#define GLPM_PLL_CTRL7_DEFAULT                   (0x0000)
#define GLPM_PLL_CTRL7_FMASK                     (0x0000ffff)
#define GLPM_PLL_A_CTRL1                         GLPM_GLOBAL(0x0000A4)
#define GLPM_PLL_A_CTRL1_WMASK                   (0x0000ffff)
#define GLPM_PLL_A_CTRL1_MASK                    (0x0000ffff)
#define GLPM_PLL_A_CTRL1_DEFAULT                 (0x1000)
#define GLPM_PLL_A_CTRL1_FMASK                   (0x0000ffff)
#define GLPM_PLL_A_CTRL2                         GLPM_GLOBAL(0x0000A8)
#define GLPM_PLL_A_CTRL2_WMASK                   (0x00007fff)
#define GLPM_PLL_A_CTRL2_MASK                    (0x00007fff)
#define GLPM_PLL_A_CTRL2_DEFAULT                 (0x1800)
#define GLPM_PLL_A_CTRL2_FMASK                   (0x00007fff)
#define GLPM_PLL_A_CTRL3                         GLPM_GLOBAL(0x0000AC)
#define GLPM_PLL_A_CTRL3_WMASK                   (0x0000ffff)
#define GLPM_PLL_A_CTRL3_MASK                    (0x0000ffff)
#define GLPM_PLL_A_CTRL3_DEFAULT                 (0x0100)
#define GLPM_PLL_A_CTRL3_FMASK                   (0x0000ffff)
#define GLPM_PLL_STATUS                          GLPM_GLOBAL(0x0000B0)
#define GLPM_PLL_STATUS_WMASK                    (0x00000073)
#define GLPM_PLL_STATUS_MASK                     (0x00000073)
#define GLPM_PLL_STATUS_DEFAULT                  (0x0000)
#define GLPM_PLL_STATUS_FMASK                    (0x00000073)
#define GLPM_TX1_CTRL1                           GLPM_GLOBAL(0x0000C0)
#define GLPM_TX1_CTRL1_WMASK                     (0x00003f1f)
#define GLPM_TX1_CTRL1_MASK                      (0x00003f1f)
#define GLPM_TX1_CTRL1_DEFAULT                   (0x0009)
#define GLPM_TX1_CTRL1_FMASK                     (0x00003f1f)
#define GLPM_TX1_CTRL2                           GLPM_GLOBAL(0x0000C4)
#define GLPM_TX1_CTRL2_WMASK                     (0x00003fff)
#define GLPM_TX1_CTRL2_MASK                      (0x00003fff)
#define GLPM_TX1_CTRL2_DEFAULT                   (0x2096)
#define GLPM_TX1_CTRL2_FMASK                     (0x00003fff)
#define GLPM_TX1_CTRL3                           GLPM_GLOBAL(0x0000C8)
#define GLPM_TX1_CTRL3_WMASK                     (0x0000ffff)
#define GLPM_TX1_CTRL3_MASK                      (0x0000ffff)
#define GLPM_TX1_CTRL3_DEFAULT                   (0xFFFF)
#define GLPM_TX1_CTRL3_FMASK                     (0x0000ffff)
#define GLPM_TX1_A_CTRL1                         GLPM_GLOBAL(0x0000CC)
#define GLPM_TX1_A_CTRL1_WMASK                   (0x0000ff1f)
#define GLPM_TX1_A_CTRL1_MASK                    (0x0000ff1f)
#define GLPM_TX1_A_CTRL1_DEFAULT                 (0x0010)
#define GLPM_TX1_A_CTRL1_FMASK                   (0x0000ff1f)
#define GLPM_TX1_A_CTRL2                         GLPM_GLOBAL(0x0000D0)
#define GLPM_TX1_A_CTRL2_WMASK                   (0x0000ffff)
#define GLPM_TX1_A_CTRL2_MASK                    (0x0000ffff)
#define GLPM_TX1_A_CTRL2_DEFAULT                 (0x408F)
#define GLPM_TX1_A_CTRL2_FMASK                   (0x0000ffff)
#define GLPM_TX1_MOD1                            GLPM_GLOBAL(0x0000D4)
#define GLPM_TX1_MOD1_WMASK                      (0x00003fff)
#define GLPM_TX1_MOD1_MASK                       (0x00003fff)
#define GLPM_TX1_MOD1_DEFAULT                    (0x0000)
#define GLPM_TX1_MOD1_FMASK                      (0x00003fff)
#define GLPM_TX1_MOD2                            GLPM_GLOBAL(0x0000D8)
#define GLPM_TX1_MOD2_WMASK                      (0x0000ffff)
#define GLPM_TX1_MOD2_MASK                       (0x0000ffff)
#define GLPM_TX1_MOD2_DEFAULT                    (0x0000)
#define GLPM_TX1_MOD2_FMASK                      (0x0000ffff)
#define GLPM_TX1_MOD3                            GLPM_GLOBAL(0x0000DC)
#define GLPM_TX1_MOD3_WMASK                      (0x000007ff)
#define GLPM_TX1_MOD3_MASK                       (0x000007ff)
#define GLPM_TX1_MOD3_DEFAULT                    (0x0180)
#define GLPM_TX1_MOD3_FMASK                      (0x000007ff)
#define GLPM_TX2_CTRL1                           GLPM_GLOBAL(0x0000E0)
#define GLPM_TX2_CTRL1_WMASK                     (0x00003f1f)
#define GLPM_TX2_CTRL1_MASK                      (0x00003f1f)
#define GLPM_TX2_CTRL1_DEFAULT                   (0x0009)
#define GLPM_TX2_CTRL1_FMASK                     (0x00003f1f)
#define GLPM_TX2_CTRL2                           GLPM_GLOBAL(0x0000E4)
#define GLPM_TX2_CTRL2_WMASK                     (0x00003fff)
#define GLPM_TX2_CTRL2_MASK                      (0x00003fff)
#define GLPM_TX2_CTRL2_DEFAULT                   (0x2096)
#define GLPM_TX2_CTRL2_FMASK                     (0x00003fff)
#define GLPM_TX2_CTRL3                           GLPM_GLOBAL(0x0000E8)
#define GLPM_TX2_CTRL3_WMASK                     (0x0000ffff)
#define GLPM_TX2_CTRL3_MASK                      (0x0000ffff)
#define GLPM_TX2_CTRL3_DEFAULT                   (0xFFFF)
#define GLPM_TX2_CTRL3_FMASK                     (0x0000ffff)
#define GLPM_TX2_A_CTRL1                         GLPM_GLOBAL(0x0000EC)
#define GLPM_TX2_A_CTRL1_WMASK                   (0x0000ff1f)
#define GLPM_TX2_A_CTRL1_MASK                    (0x0000ff1f)
#define GLPM_TX2_A_CTRL1_DEFAULT                 (0x0010)
#define GLPM_TX2_A_CTRL1_FMASK                   (0x0000ff1f)
#define GLPM_TX2_A_CTRL2                         GLPM_GLOBAL(0x0000F0)
#define GLPM_TX2_A_CTRL2_WMASK                   (0x0000ffff)
#define GLPM_TX2_A_CTRL2_MASK                    (0x0000ffff)
#define GLPM_TX2_A_CTRL2_DEFAULT                 (0x408F)
#define GLPM_TX2_A_CTRL2_FMASK                   (0x0000ffff)
#define GLPM_TX2_MOD1                            GLPM_GLOBAL(0x0000F4)
#define GLPM_TX2_MOD1_WMASK                      (0x00003fff)
#define GLPM_TX2_MOD1_MASK                       (0x00003fff)
#define GLPM_TX2_MOD1_DEFAULT                    (0x0000)
#define GLPM_TX2_MOD1_FMASK                      (0x00003fff)
#define GLPM_TX2_MOD2                            GLPM_GLOBAL(0x0000F8)
#define GLPM_TX2_MOD2_WMASK                      (0x0000ffff)
#define GLPM_TX2_MOD2_MASK                       (0x0000ffff)
#define GLPM_TX2_MOD2_DEFAULT                    (0x0000)
#define GLPM_TX2_MOD2_FMASK                      (0x0000ffff)
#define GLPM_TX2_MOD3                            GLPM_GLOBAL(0x0000FC)
#define GLPM_TX2_MOD3_WMASK                      (0x000007ff)
#define GLPM_TX2_MOD3_MASK                       (0x000007ff)
#define GLPM_TX2_MOD3_DEFAULT                    (0x0180)
#define GLPM_TX2_MOD3_FMASK                      (0x000007ff)
#define GLPM_TX3_CTRL1                           GLPM_GLOBAL(0x000100)
#define GLPM_TX3_CTRL1_WMASK                     (0x00003f1f)
#define GLPM_TX3_CTRL1_MASK                      (0x00003f1f)
#define GLPM_TX3_CTRL1_DEFAULT                   (0x0009)
#define GLPM_TX3_CTRL1_FMASK                     (0x00003f1f)
#define GLPM_TX3_CTRL2                           GLPM_GLOBAL(0x000104)
#define GLPM_TX3_CTRL2_WMASK                     (0x00003fff)
#define GLPM_TX3_CTRL2_MASK                      (0x00003fff)
#define GLPM_TX3_CTRL2_DEFAULT                   (0x2096)
#define GLPM_TX3_CTRL2_FMASK                     (0x00003fff)
#define GLPM_TX3_CTRL3                           GLPM_GLOBAL(0x000108)
#define GLPM_TX3_CTRL3_WMASK                     (0x0000ffff)
#define GLPM_TX3_CTRL3_MASK                      (0x0000ffff)
#define GLPM_TX3_CTRL3_DEFAULT                   (0xFFFF)
#define GLPM_TX3_CTRL3_FMASK                     (0x0000ffff)
#define GLPM_TX3_A_CTRL1                         GLPM_GLOBAL(0x00010C)
#define GLPM_TX3_A_CTRL1_WMASK                   (0x0000ff1f)
#define GLPM_TX3_A_CTRL1_MASK                    (0x0000ff1f)
#define GLPM_TX3_A_CTRL1_DEFAULT                 (0x0010)
#define GLPM_TX3_A_CTRL1_FMASK                   (0x0000ff1f)
#define GLPM_TX3_A_CTRL2                         GLPM_GLOBAL(0x000110)
#define GLPM_TX3_A_CTRL2_WMASK                   (0x0000ffff)
#define GLPM_TX3_A_CTRL2_MASK                    (0x0000ffff)
#define GLPM_TX3_A_CTRL2_DEFAULT                 (0x408F)
#define GLPM_TX3_A_CTRL2_FMASK                   (0x0000ffff)
#define GLPM_TX3_MOD1                            GLPM_GLOBAL(0x000114)
#define GLPM_TX3_MOD1_WMASK                      (0x00003fff)
#define GLPM_TX3_MOD1_MASK                       (0x00003fff)
#define GLPM_TX3_MOD1_DEFAULT                    (0x0000)
#define GLPM_TX3_MOD1_FMASK                      (0x00003fff)
#define GLPM_TX3_MOD2                            GLPM_GLOBAL(0x000118)
#define GLPM_TX3_MOD2_WMASK                      (0x0000ffff)
#define GLPM_TX3_MOD2_MASK                       (0x0000ffff)
#define GLPM_TX3_MOD2_DEFAULT                    (0x0000)
#define GLPM_TX3_MOD2_FMASK                      (0x0000ffff)
#define GLPM_TX3_MOD3                            GLPM_GLOBAL(0x00011C)
#define GLPM_TX3_MOD3_WMASK                      (0x000007ff)
#define GLPM_TX3_MOD3_MASK                       (0x000007ff)
#define GLPM_TX3_MOD3_DEFAULT                    (0x0180)
#define GLPM_TX3_MOD3_FMASK                      (0x000007ff)
#define GLPM_TX4_CTRL1                           GLPM_GLOBAL(0x000120)
#define GLPM_TX4_CTRL1_WMASK                     (0x00003f1f)
#define GLPM_TX4_CTRL1_MASK                      (0x00003f1f)
#define GLPM_TX4_CTRL1_DEFAULT                   (0x0009)
#define GLPM_TX4_CTRL1_FMASK                     (0x00003f1f)
#define GLPM_TX4_CTRL2                           GLPM_GLOBAL(0x000124)
#define GLPM_TX4_CTRL2_WMASK                     (0x00003fff)
#define GLPM_TX4_CTRL2_MASK                      (0x00003fff)
#define GLPM_TX4_CTRL2_DEFAULT                   (0x2096)
#define GLPM_TX4_CTRL2_FMASK                     (0x00003fff)
#define GLPM_TX4_CTRL3                           GLPM_GLOBAL(0x000128)
#define GLPM_TX4_CTRL3_WMASK                     (0x0000ffff)
#define GLPM_TX4_CTRL3_MASK                      (0x0000ffff)
#define GLPM_TX4_CTRL3_DEFAULT                   (0xFFFF)
#define GLPM_TX4_CTRL3_FMASK                     (0x0000ffff)
#define GLPM_TX4_A_CTRL1                         GLPM_GLOBAL(0x00012C)
#define GLPM_TX4_A_CTRL1_WMASK                   (0x0000ff1f)
#define GLPM_TX4_A_CTRL1_MASK                    (0x0000ff1f)
#define GLPM_TX4_A_CTRL1_DEFAULT                 (0x0010)
#define GLPM_TX4_A_CTRL1_FMASK                   (0x0000ff1f)
#define GLPM_TX4_A_CTRL2                         GLPM_GLOBAL(0x000130)
#define GLPM_TX4_A_CTRL2_WMASK                   (0x0000ffff)
#define GLPM_TX4_A_CTRL2_MASK                    (0x0000ffff)
#define GLPM_TX4_A_CTRL2_DEFAULT                 (0x408F)
#define GLPM_TX4_A_CTRL2_FMASK                   (0x0000ffff)
#define GLPM_TX4_MOD1                            GLPM_GLOBAL(0x000134)
#define GLPM_TX4_MOD1_WMASK                      (0x00003fff)
#define GLPM_TX4_MOD1_MASK                       (0x00003fff)
#define GLPM_TX4_MOD1_DEFAULT                    (0x0000)
#define GLPM_TX4_MOD1_FMASK                      (0x00003fff)
#define GLPM_TX4_MOD2                            GLPM_GLOBAL(0x000138)
#define GLPM_TX4_MOD2_WMASK                      (0x0000ffff)
#define GLPM_TX4_MOD2_MASK                       (0x0000ffff)
#define GLPM_TX4_MOD2_DEFAULT                    (0x0000)
#define GLPM_TX4_MOD2_FMASK                      (0x0000ffff)
#define GLPM_TX4_MOD3                            GLPM_GLOBAL(0x00013C)
#define GLPM_TX4_MOD3_WMASK                      (0x000007ff)
#define GLPM_TX4_MOD3_MASK                       (0x000007ff)
#define GLPM_TX4_MOD3_DEFAULT                    (0x0180)
#define GLPM_TX4_MOD3_FMASK                      (0x000007ff)
#define GLPM_RX1_CTRL1                           GLPM_GLOBAL(0x000140)
#define GLPM_RX1_CTRL1_WMASK                     (0x00003fff)
#define GLPM_RX1_CTRL1_MASK                      (0x00003fff)
#define GLPM_RX1_CTRL1_DEFAULT                   (0x0005)
#define GLPM_RX1_CTRL1_FMASK                     (0x00003fff)
#define GLPM_RX1_CTRL2                           GLPM_GLOBAL(0x000144)
#define GLPM_RX1_CTRL2_WMASK                     (0x00003fff)
#define GLPM_RX1_CTRL2_MASK                      (0x00003fff)
#define GLPM_RX1_CTRL2_DEFAULT                   (0x2000)
#define GLPM_RX1_CTRL2_FMASK                     (0x00003fff)
#define GLPM_RX1_CDR                             GLPM_GLOBAL(0x000148)
#define GLPM_RX1_CDR_WMASK                       (0x00000377)
#define GLPM_RX1_CDR_MASK                        (0x00000377)
#define GLPM_RX1_CDR_DEFAULT                     (0x0144)
#define GLPM_RX1_CDR_FMASK                       (0x00000377)
#define GLPM_RX1_EI                              GLPM_GLOBAL(0x00014C)
#define GLPM_RX1_EI_WMASK                        (0x0000ffff)
#define GLPM_RX1_EI_MASK                         (0x0000ffff)
#define GLPM_RX1_EI_DEFAULT                      (0xFFFF)
#define GLPM_RX1_EI_FMASK                        (0x0000ffff)
#define GLPM_RX1_CAL                             GLPM_GLOBAL(0x000150)
#define GLPM_RX1_CAL_WMASK                       (0x000003ff)
#define GLPM_RX1_CAL_MASK                        (0x000003ff)
#define GLPM_RX1_CAL_DEFAULT                     (0x00FF)
#define GLPM_RX1_CAL_FMASK                       (0x000003ff)
#define GLPM_RX1_A_CTRL                          GLPM_GLOBAL(0x000154)
#define GLPM_RX1_A_CTRL_WMASK                    (0x00007fff)
#define GLPM_RX1_A_CTRL_MASK                     (0x00007fff)
#define GLPM_RX1_A_CTRL_DEFAULT                  (0x6800)
#define GLPM_RX1_A_CTRL_FMASK                    (0x00007fff)
#define GLPM_RX1_TEST_CTRL                       GLPM_GLOBAL(0x000158)
#define GLPM_RX1_TEST_CTRL_WMASK                 (0x00000003)
#define GLPM_RX1_TEST_CTRL_MASK                  (0x00000003)
#define GLPM_RX1_TEST_CTRL_DEFAULT               (0x0002)
#define GLPM_RX1_TEST_CTRL_FMASK                 (0x00000003)
#define GLPM_RX2_CTRL1                           GLPM_GLOBAL(0x000160)
#define GLPM_RX2_CTRL1_WMASK                     (0x00003fff)
#define GLPM_RX2_CTRL1_MASK                      (0x00003fff)
#define GLPM_RX2_CTRL1_DEFAULT                   (0x0005)
#define GLPM_RX2_CTRL1_FMASK                     (0x00003fff)
#define GLPM_RX2_CTRL2                           GLPM_GLOBAL(0x000164)
#define GLPM_RX2_CTRL2_WMASK                     (0x00003fff)
#define GLPM_RX2_CTRL2_MASK                      (0x00003fff)
#define GLPM_RX2_CTRL2_DEFAULT                   (0x2000)
#define GLPM_RX2_CTRL2_FMASK                     (0x00003fff)
#define GLPM_RX2_CDR                             GLPM_GLOBAL(0x000168)
#define GLPM_RX2_CDR_WMASK                       (0x00000377)
#define GLPM_RX2_CDR_MASK                        (0x00000377)
#define GLPM_RX2_CDR_DEFAULT                     (0x0144)
#define GLPM_RX2_CDR_FMASK                       (0x00000377)
#define GLPM_RX2_EI                              GLPM_GLOBAL(0x00016C)
#define GLPM_RX2_EI_WMASK                        (0x0000ffff)
#define GLPM_RX2_EI_MASK                         (0x0000ffff)
#define GLPM_RX2_EI_DEFAULT                      (0xFFFF)
#define GLPM_RX2_EI_FMASK                        (0x0000ffff)
#define GLPM_RX2_CAL                             GLPM_GLOBAL(0x000170)
#define GLPM_RX2_CAL_WMASK                       (0x000003ff)
#define GLPM_RX2_CAL_MASK                        (0x000003ff)
#define GLPM_RX2_CAL_DEFAULT                     (0x00FF)
#define GLPM_RX2_CAL_FMASK                       (0x000003ff)
#define GLPM_RX2_A_CTRL                          GLPM_GLOBAL(0x000174)
#define GLPM_RX2_A_CTRL_WMASK                    (0x00007fff)
#define GLPM_RX2_A_CTRL_MASK                     (0x00007fff)
#define GLPM_RX2_A_CTRL_DEFAULT                  (0x6800)
#define GLPM_RX2_A_CTRL_FMASK                    (0x00007fff)
#define GLPM_RX2_TEST_CTRL                       GLPM_GLOBAL(0x000178)
#define GLPM_RX2_TEST_CTRL_WMASK                 (0x00000003)
#define GLPM_RX2_TEST_CTRL_MASK                  (0x00000003)
#define GLPM_RX2_TEST_CTRL_DEFAULT               (0x0002)
#define GLPM_RX2_TEST_CTRL_FMASK                 (0x00000003)

/* Cri Memory Address Constants */ 

/* Cri Global Address Constants */ 
#define cri_global_base        (0x20C400)
#define CRI_GLOBAL(r)          (int)(cri_global_base + (r))
#define cri_global_size        (0x0200)

#define CRI_CCR                CRI_GLOBAL(0x0000)
#define CRI_CCR_WMASK          (0x001F)
#define CRI_CCR_MASK           (0x001F)
#define CRI_CCR_DEFAULT        (0x0000)
#define CRI_CCR_FMASK          (0x001F)
#define CRI_RST                CRI_GLOBAL(0x0004)
#define CRI_RST_WMASK          (0x007F)
#define CRI_RST_MASK           (0x007F)
#define CRI_RST_DEFAULT        (0x0000)
#define CRI_RST_FMASK          (0x007F)
#define CRI_PORT_MODE          CRI_GLOBAL(0x0008)
#define CRI_PORT_MODE_WMASK    (0x1555)
#define CRI_PORT_MODE_MASK     (0x1555)
#define CRI_PORT_MODE_DEFAULT  (0x0000)
#define CRI_PORT_MODE_FMASK    (0x1555)
#define CRI_TSC_CTRL           CRI_GLOBAL(0x000C)
#define CRI_TSC_CTRL_WMASK     (0xFFFFFFF)
#define CRI_TSC_CTRL_MASK      (0x8FFFFFFF)
#define CRI_TSC_CTRL_DEFAULT   (0x1FFFE0)
#define CRI_TSC_CTRL_FMASK     (0xFFFFFFF)
#define CRI_TSC_STATUS         CRI_GLOBAL(0x0010)
#define CRI_TSC_STATUS_WMASK   (0x0000)
#define CRI_TSC_STATUS_MASK    (0x3FFFFF)
#define CRI_TSC_STATUS_DEFAULT (0x0000)
#define CRI_TSC_STATUS_FMASK   (0x3FFFFF)
#define CRI_TX_TSLOTC_A        CRI_GLOBAL(0x0014)
#define CRI_TX_TSLOTC_A_WMASK  (0x0000)
#define CRI_TX_TSLOTC_A_MASK   (0x3E0FFFFF)
#define CRI_TX_TSLOTC_A_DEFAULT (0x3E0FFFFF)
#define CRI_TX_TSLOTC_A_FMASK  (0x0000)
#define CRI_TX_TSLOTC_B        CRI_GLOBAL(0x0018)
#define CRI_TX_TSLOTC_B_WMASK  (0x0000)
#define CRI_TX_TSLOTC_B_MASK   (0x3E0FFFFF)
#define CRI_TX_TSLOTC_B_DEFAULT (0x3E0FFFFF)
#define CRI_TX_TSLOTC_B_FMASK  (0x0000)
#define CRI_TX_TSLOT0          CRI_GLOBAL(0x001C)
#define CRI_TX_TSLOT0_WMASK    (0x3E0FFFFF)
#define CRI_TX_TSLOT0_MASK     (0x3E0FFFFF)
#define CRI_TX_TSLOT0_DEFAULT  (0x3E0FFFFF)
#define CRI_TX_TSLOT0_FMASK    (0x3E0FFFFF)
#define CRI_TX_TSLOT1          CRI_GLOBAL(0x0020)
#define CRI_TX_TSLOT1_WMASK    (0x3E0FFFFF)
#define CRI_TX_TSLOT1_MASK     (0x3E0FFFFF)
#define CRI_TX_TSLOT1_DEFAULT  (0x3E0FFFFF)
#define CRI_TX_TSLOT1_FMASK    (0x3E0FFFFF)
#define CRI_RX_TSLOTC_A        CRI_GLOBAL(0x0024)
#define CRI_RX_TSLOTC_A_WMASK  (0x0000)
#define CRI_RX_TSLOTC_A_MASK   (0x3E0FFFFF)
#define CRI_RX_TSLOTC_A_DEFAULT (0x3E0FFFFF)
#define CRI_RX_TSLOTC_A_FMASK  (0x0000)
#define CRI_RX_TSLOTC_B        CRI_GLOBAL(0x0028)
#define CRI_RX_TSLOTC_B_WMASK  (0x0000)
#define CRI_RX_TSLOTC_B_MASK   (0x3E0FFFFF)
#define CRI_RX_TSLOTC_B_DEFAULT (0x3E0FFFFF)
#define CRI_RX_TSLOTC_B_FMASK  (0x0000)
#define CRI_RX_TSLOT0          CRI_GLOBAL(0x002C)
#define CRI_RX_TSLOT0_WMASK    (0x3E0FFFFF)
#define CRI_RX_TSLOT0_MASK     (0x3E0FFFFF)
#define CRI_RX_TSLOT0_DEFAULT  (0x3E0FFFFF)
#define CRI_RX_TSLOT0_FMASK    (0x3E0FFFFF)
#define CRI_RX_TSLOT1          CRI_GLOBAL(0x0030)
#define CRI_RX_TSLOT1_WMASK    (0x3E0FFFFF)
#define CRI_RX_TSLOT1_MASK     (0x3E0FFFFF)
#define CRI_RX_TSLOT1_DEFAULT  (0x3E0FFFFF)
#define CRI_RX_TSLOT1_FMASK    (0x3E0FFFFF)
#define CRI_TX_ATSLOTC_A       CRI_GLOBAL(0x0034)
#define CRI_TX_ATSLOTC_A_WMASK (0x0000)
#define CRI_TX_ATSLOTC_A_MASK  (0x3E000000)
#define CRI_TX_ATSLOTC_A_DEFAULT (0x3E000000)
#define CRI_TX_ATSLOTC_A_FMASK (0x0000)
#define CRI_TX_ATSLOTC_B       CRI_GLOBAL(0x0038)
#define CRI_TX_ATSLOTC_B_WMASK (0x0000)
#define CRI_TX_ATSLOTC_B_MASK  (0x3E000000)
#define CRI_TX_ATSLOTC_B_DEFAULT (0x3E000000)
#define CRI_TX_ATSLOTC_B_FMASK (0x0000)
#define CRI_TX_ATSLOT0         CRI_GLOBAL(0x003C)
#define CRI_TX_ATSLOT0_WMASK   (0x3E000000)
#define CRI_TX_ATSLOT0_MASK    (0x3E000000)
#define CRI_TX_ATSLOT0_DEFAULT (0x3E000000)
#define CRI_TX_ATSLOT0_FMASK   (0x3E000000)
#define CRI_TX_ATSLOT1         CRI_GLOBAL(0x0040)
#define CRI_TX_ATSLOT1_WMASK   (0x3E000000)
#define CRI_TX_ATSLOT1_MASK    (0x3E000000)
#define CRI_TX_ATSLOT1_DEFAULT (0x3E000000)
#define CRI_TX_ATSLOT1_FMASK   (0x3E000000)
#define CRI_RX_ATSLOTC_A       CRI_GLOBAL(0x0044)
#define CRI_RX_ATSLOTC_A_WMASK (0x0000)
#define CRI_RX_ATSLOTC_A_MASK  (0x3E000000)
#define CRI_RX_ATSLOTC_A_DEFAULT (0x3E000000)
#define CRI_RX_ATSLOTC_A_FMASK (0x0000)
#define CRI_RX_ATSLOTC_B       CRI_GLOBAL(0x0048)
#define CRI_RX_ATSLOTC_B_WMASK (0x0000)
#define CRI_RX_ATSLOTC_B_MASK  (0x3E000000)
#define CRI_RX_ATSLOTC_B_DEFAULT (0x3E000000)
#define CRI_RX_ATSLOTC_B_FMASK (0x0000)
#define CRI_RX_ATSLOT0         CRI_GLOBAL(0x004C)
#define CRI_RX_ATSLOT0_WMASK   (0x3E000000)
#define CRI_RX_ATSLOT0_MASK    (0x3E000000)
#define CRI_RX_ATSLOT0_DEFAULT (0x3E000000)
#define CRI_RX_ATSLOT0_FMASK   (0x3E000000)
#define CRI_RX_ATSLOT1         CRI_GLOBAL(0x0050)
#define CRI_RX_ATSLOT1_WMASK   (0x3E000000)
#define CRI_RX_ATSLOT1_MASK    (0x3E000000)
#define CRI_RX_ATSLOT1_DEFAULT (0x3E000000)
#define CRI_RX_ATSLOT1_FMASK   (0x3E000000)
#define CRI_RXGP0_CTL          CRI_GLOBAL(0x0054)
#define CRI_RXGP0_CTL_WMASK    (0x000F)
#define CRI_RXGP0_CTL_MASK     (0x000F)
#define CRI_RXGP0_CTL_DEFAULT  (0x0000)
#define CRI_RXGP0_CTL_FMASK    (0x000F)
#define CRI_RXGP1_CTL          CRI_GLOBAL(0x0058)
#define CRI_RXGP1_CTL_WMASK    (0x000F)
#define CRI_RXGP1_CTL_MASK     (0x000F)
#define CRI_RXGP1_CTL_DEFAULT  (0x0000)
#define CRI_RXGP1_CTL_FMASK    (0x000F)
#define CRI_TXGP0_CTL          CRI_GLOBAL(0x005C)
#define CRI_TXGP0_CTL_WMASK    (0x000F)
#define CRI_TXGP0_CTL_MASK     (0x000F)
#define CRI_TXGP0_CTL_DEFAULT  (0x0000)
#define CRI_TXGP0_CTL_FMASK    (0x000F)
#define CRI_TXGP1_CTL          CRI_GLOBAL(0x0060)
#define CRI_TXGP1_CTL_WMASK    (0x000F)
#define CRI_TXGP1_CTL_MASK     (0x000F)
#define CRI_TXGP1_CTL_DEFAULT  (0x0000)
#define CRI_TXGP1_CTL_FMASK    (0x000F)
#define CRI_RXGP0_VAL          CRI_GLOBAL(0x0064)
#define CRI_RXGP0_VAL_WMASK    (0xFFFFF)
#define CRI_RXGP0_VAL_MASK     (0xFFFFF)
#define CRI_RXGP0_VAL_DEFAULT  (0x0000)
#define CRI_RXGP0_VAL_FMASK    (0xFFFFF)
#define CRI_RXGP1_VAL          CRI_GLOBAL(0x0068)
#define CRI_RXGP1_VAL_WMASK    (0xFFFFF)
#define CRI_RXGP1_VAL_MASK     (0xFFFFF)
#define CRI_RXGP1_VAL_DEFAULT  (0x0000)
#define CRI_RXGP1_VAL_FMASK    (0xFFFFF)
#define CRI_TXGP0_MCNT         CRI_GLOBAL(0x006C)
#define CRI_TXGP0_MCNT_WMASK   (0xFFFFF)
#define CRI_TXGP0_MCNT_MASK    (0xFFFFF)
#define CRI_TXGP0_MCNT_DEFAULT (0x0000)
#define CRI_TXGP0_MCNT_FMASK   (0xFFFFF)
#define CRI_TXGP1_MCNT         CRI_GLOBAL(0x0070)
#define CRI_TXGP1_MCNT_WMASK   (0xFFFFF)
#define CRI_TXGP1_MCNT_MASK    (0xFFFFF)
#define CRI_TXGP1_MCNT_DEFAULT (0x0000)
#define CRI_TXGP1_MCNT_FMASK   (0xFFFFF)
#define CRI_MASK0_TX           CRI_GLOBAL(0x0074)
#define CRI_MASK0_TX_WMASK     (0x37F80050)
#define CRI_MASK0_TX_MASK      (0x37F80050)
#define CRI_MASK0_TX_DEFAULT   (0x0000)
#define CRI_MASK0_TX_FMASK     (0x37F80050)
#define CRI_MASK0_RX           CRI_GLOBAL(0x0078)
#define CRI_MASK0_RX_WMASK     (0xC807FFAF)
#define CRI_MASK0_RX_MASK      (0xC807FFAF)
#define CRI_MASK0_RX_DEFAULT   (0x0000)
#define CRI_MASK0_RX_FMASK     (0xC807FFAF)
#define CRI_MASK1_TX           CRI_GLOBAL(0x007C)
#define CRI_MASK1_TX_WMASK     (0x37F80050)
#define CRI_MASK1_TX_MASK      (0x37F80050)
#define CRI_MASK1_TX_DEFAULT   (0x0000)
#define CRI_MASK1_TX_FMASK     (0x37F80050)
#define CRI_MASK1_RX           CRI_GLOBAL(0x0080)
#define CRI_MASK1_RX_WMASK     (0xC807FFAF)
#define CRI_MASK1_RX_MASK      (0xC807FFAF)
#define CRI_MASK1_RX_DEFAULT   (0x0000)
#define CRI_MASK1_RX_FMASK     (0xC807FFAF)
#define CRI_STATUS0            CRI_GLOBAL(0x0084)
#define CRI_STATUS0_WMASK      (0xFFFFFFFF)
#define CRI_STATUS0_MASK       (0xFFFFFFFF)
#define CRI_STATUS0_DEFAULT    (0x0000)
#define CRI_STATUS0_FMASK      (0x0000)
#define CRI_STATUS1            CRI_GLOBAL(0x0088)
#define CRI_STATUS1_WMASK      (0xFFFFFFFF)
#define CRI_STATUS1_MASK       (0xFFFFFFFF)
#define CRI_STATUS1_DEFAULT    (0x0000)
#define CRI_STATUS1_FMASK      (0x0000)
#define CRI_AMASK0_TX          CRI_GLOBAL(0x008C)
#define CRI_AMASK0_TX_WMASK    (0x0000)
#define CRI_AMASK0_TX_MASK     (0x0000)
#define CRI_AMASK0_TX_DEFAULT  (0x0000)
#define CRI_AMASK0_TX_FMASK    (0x0000)
#define CRI_AMASK0_RX          CRI_GLOBAL(0x0090)
#define CRI_AMASK0_RX_WMASK    (0x0000)
#define CRI_AMASK0_RX_MASK     (0x0000)
#define CRI_AMASK0_RX_DEFAULT  (0x0000)
#define CRI_AMASK0_RX_FMASK    (0x0000)
#define CRI_AMASK1_TX          CRI_GLOBAL(0x0094)
#define CRI_AMASK1_TX_WMASK    (0x0000)
#define CRI_AMASK1_TX_MASK     (0x0000)
#define CRI_AMASK1_TX_DEFAULT  (0x0000)
#define CRI_AMASK1_TX_FMASK    (0x0000)
#define CRI_AMASK1_RX          CRI_GLOBAL(0x0098)
#define CRI_AMASK1_RX_WMASK    (0x0000)
#define CRI_AMASK1_RX_MASK     (0x0000)
#define CRI_AMASK1_RX_DEFAULT  (0x0000)
#define CRI_AMASK1_RX_FMASK    (0x0000)
#define CRI_UPDCTL             CRI_GLOBAL(0x009C)
#define CRI_UPDCTL_WMASK       (0xA000)
#define CRI_UPDCTL_MASK        (0xF1FE)
#define CRI_UPDCTL_DEFAULT     (0x0000)
#define CRI_UPDCTL_FMASK       (0xA000)
#define CRI_EVENT              CRI_GLOBAL(0x00A0)
#define CRI_EVENT_WMASK        (0xFFFFFFFF)
#define CRI_EVENT_MASK         (0xFFFFFFFF)
#define CRI_EVENT_DEFAULT      (0x0000)
#define CRI_EVENT_FMASK        (0x0000)
#define CRI_TX_TIMER           CRI_GLOBAL(0x00A4)
#define CRI_TX_TIMER_WMASK     (0xFFFFF)
#define CRI_TX_TIMER_MASK      (0xFFFFF)
#define CRI_TX_TIMER_DEFAULT   (0x0000)
#define CRI_TX_TIMER_FMASK     (0xFFFFF)
#define CRI_TX_TIMER_CTL       CRI_GLOBAL(0x00A8)
#define CRI_TX_TIMER_CTL_WMASK (0x106FFFFF)
#define CRI_TX_TIMER_CTL_MASK  (0x107FFFFF)
#define CRI_TX_TIMER_CTL_DEFAULT (0x0000)
#define CRI_TX_TIMER_CTL_FMASK (0x106FFFFF)
#define CRI_RX_TIMER           CRI_GLOBAL(0x00AC)
#define CRI_RX_TIMER_WMASK     (0xFFFFF)
#define CRI_RX_TIMER_MASK      (0xFFFFF)
#define CRI_RX_TIMER_DEFAULT   (0x0000)
#define CRI_RX_TIMER_FMASK     (0xFFFFF)
#define CRI_RX_TIMER_CTL       CRI_GLOBAL(0x00B0)
#define CRI_RX_TIMER_CTL_WMASK (0x106FFFFF)
#define CRI_RX_TIMER_CTL_MASK  (0x107FFFFF)
#define CRI_RX_TIMER_CTL_DEFAULT (0x0000)
#define CRI_RX_TIMER_CTL_FMASK (0x106FFFFF)
#define CRI_TX_PMS_CTL         CRI_GLOBAL(0x00B4)
#define CRI_TX_PMS_CTL_WMASK   (0x7FFFFF)
#define CRI_TX_PMS_CTL_MASK    (0xFFFFFF)
#define CRI_TX_PMS_CTL_DEFAULT (0x0000)
#define CRI_TX_PMS_CTL_FMASK   (0x7FFFFF)
#define CRI_TX_QTP_CTL         CRI_GLOBAL(0x00B8)
#define CRI_TX_QTP_CTL_WMASK   (0x7FFFFF)
#define CRI_TX_QTP_CTL_MASK    (0xFFFFFF)
#define CRI_TX_QTP_CTL_DEFAULT (0x0000)
#define CRI_TX_QTP_CTL_FMASK   (0x7FFFFF)
#define CRI_TX_QT_CTL          CRI_GLOBAL(0x00BC)
#define CRI_TX_QT_CTL_WMASK    (0x7FFFFF)
#define CRI_TX_QT_CTL_MASK     (0xFFFFFF)
#define CRI_TX_QT_CTL_DEFAULT  (0x0000)
#define CRI_TX_QT_CTL_FMASK    (0x7FFFFF)
#define CRI_TX_IFFT_CTL        CRI_GLOBAL(0x00C0)
#define CRI_TX_IFFT_CTL_WMASK  (0x7FFFFF)
#define CRI_TX_IFFT_CTL_MASK   (0xFFFFFF)
#define CRI_TX_IFFT_CTL_DEFAULT (0x0000)
#define CRI_TX_IFFT_CTL_FMASK  (0x7FFFFF)
#define CRI_RX_FFT_CTL         CRI_GLOBAL(0x00C4)
#define CRI_RX_FFT_CTL_WMASK   (0x7FFFFF)
#define CRI_RX_FFT_CTL_MASK    (0xFFFFFF)
#define CRI_RX_FFT_CTL_DEFAULT (0x0000)
#define CRI_RX_FFT_CTL_FMASK   (0x7FFFFF)
#define CRI_RX_QT_CTL          CRI_GLOBAL(0x00C8)
#define CRI_RX_QT_CTL_WMASK    (0x7FFFFF)
#define CRI_RX_QT_CTL_MASK     (0xFFFFFF)
#define CRI_RX_QT_CTL_DEFAULT  (0x0000)
#define CRI_RX_QT_CTL_FMASK    (0x7FFFFF)
#define CRI_RX_QTP_CTL         CRI_GLOBAL(0x00CC)
#define CRI_RX_QTP_CTL_WMASK   (0x7FFFFF)
#define CRI_RX_QTP_CTL_MASK    (0xFFFFFF)
#define CRI_RX_QTP_CTL_DEFAULT (0x0000)
#define CRI_RX_QTP_CTL_FMASK   (0x7FFFFF)
#define CRI_RX_PMS_CTL         CRI_GLOBAL(0x00D0)
#define CRI_RX_PMS_CTL_WMASK   (0x7FFFFF)
#define CRI_RX_PMS_CTL_MASK    (0xFFFFFF)
#define CRI_RX_PMS_CTL_DEFAULT (0x0000)
#define CRI_RX_PMS_CTL_FMASK   (0x7FFFFF)
#define CRI_TX_QT_STALL        CRI_GLOBAL(0x00D4)
#define CRI_TX_QT_STALL_WMASK  (0x3FFFF)
#define CRI_TX_QT_STALL_MASK   (0xFFFFF)
#define CRI_TX_QT_STALL_DEFAULT (0x40000)
#define CRI_TX_QT_STALL_FMASK  (0x1FFFF)
#define CRI_RX_QT_STALL        CRI_GLOBAL(0x00D8)
#define CRI_RX_QT_STALL_WMASK  (0x3FFFF)
#define CRI_RX_QT_STALL_MASK   (0xFFFFF)
#define CRI_RX_QT_STALL_DEFAULT (0x40000)
#define CRI_RX_QT_STALL_FMASK  (0x1FFFF)
#define CRI_RX_FFT_STALL_CTL   CRI_GLOBAL(0x00DC)
#define CRI_RX_FFT_STALL_CTL_WMASK (0x3FFFFF)
#define CRI_RX_FFT_STALL_CTL_MASK (0xBFFFFF)
#define CRI_RX_FFT_STALL_CTL_DEFAULT (0x0000)
#define CRI_RX_FFT_STALL_CTL_FMASK (0x3FFFFF)
#define CRI_NTR_CPE_CTRL       CRI_GLOBAL(0x00E0)
#define CRI_NTR_CPE_CTRL_WMASK (0x7FFFF)
#define CRI_NTR_CPE_CTRL_MASK  (0x8007FFFF)
#define CRI_NTR_CPE_CTRL_DEFAULT (0x8A00)
#define CRI_NTR_CPE_CTRL_FMASK (0x7FFFF)
#define CRI_NTRSRCFR           CRI_GLOBAL(0x00E4)
#define CRI_NTRSRCFR_WMASK     (0xFFFFF)
#define CRI_NTRSRCFR_MASK      (0xFFFFF)
#define CRI_NTRSRCFR_DEFAULT   (0x137A7)
#define CRI_NTRSRCFR_FMASK     (0xFFFFF)
#define CRI_NTRPHASE           CRI_GLOBAL(0x00E8)
#define CRI_NTRPHASE_WMASK     (0x0000)
#define CRI_NTRPHASE_MASK      (0x1FFFF)
#define CRI_NTRPHASE_DEFAULT   (0x0000)
#define CRI_NTRPHASE_FMASK     (0x1FFFF)
#define CRI_NTR_CO_CTRL        CRI_GLOBAL(0x00EC)
#define CRI_NTR_CO_CTRL_WMASK  (0x3FFFC000)
#define CRI_NTR_CO_CTRL_MASK   (0xBFFFC3FF)
#define CRI_NTR_CO_CTRL_DEFAULT (0x0000)
#define CRI_NTR_CO_CTRL_FMASK  (0x3FFFC2FF)
#define CRI_NTR_CO_PERP_NUM    CRI_GLOBAL(0x00F0)
#define CRI_NTR_CO_PERP_NUM_WMASK (0xFFFFFFFF)
#define CRI_NTR_CO_PERP_NUM_MASK (0xFFFFFFFF)
#define CRI_NTR_CO_PERP_NUM_DEFAULT (0x0000)
#define CRI_NTR_CO_PERP_NUM_FMASK (0xFFFFFFFF)
#define CRI_NTR_CO_PERP_DENOM  CRI_GLOBAL(0x00F4)
#define CRI_NTR_CO_PERP_DENOM_WMASK (0xFFFFFFFF)
#define CRI_NTR_CO_PERP_DENOM_MASK (0xFFFFFFFF)
#define CRI_NTR_CO_PERP_DENOM_DEFAULT (0x0000)
#define CRI_NTR_CO_PERP_DENOM_FMASK (0xFFFFFFFF)
#define CRI_FCIMASK2_TX        CRI_GLOBAL(0x00F8)
#define CRI_FCIMASK2_TX_WMASK  (0x37F80050)
#define CRI_FCIMASK2_TX_MASK   (0x37F80050)
#define CRI_FCIMASK2_TX_DEFAULT (0x0000)
#define CRI_FCIMASK2_TX_FMASK  (0x37F80050)
#define CRI_FCIMASK2_RX        CRI_GLOBAL(0x00FC)
#define CRI_FCIMASK2_RX_WMASK  (0xC807FFAF)
#define CRI_FCIMASK2_RX_MASK   (0xC807FFAF)
#define CRI_FCIMASK2_RX_DEFAULT (0x0000)
#define CRI_FCIMASK2_RX_FMASK  (0xC807FFAF)
#define CRI_FCIMASK3_TX        CRI_GLOBAL(0x0100)
#define CRI_FCIMASK3_TX_WMASK  (0x37F80050)
#define CRI_FCIMASK3_TX_MASK   (0x37F80050)
#define CRI_FCIMASK3_TX_DEFAULT (0x0000)
#define CRI_FCIMASK3_TX_FMASK  (0x37F80050)
#define CRI_FCIMASK3_RX        CRI_GLOBAL(0x0104)
#define CRI_FCIMASK3_RX_WMASK  (0xC807FFAF)
#define CRI_FCIMASK3_RX_MASK   (0xC807FFAF)
#define CRI_FCIMASK3_RX_DEFAULT (0x0000)
#define CRI_FCIMASK3_RX_FMASK  (0xC807FFAF)
#define CRI_FCISTATUS2         CRI_GLOBAL(0x0108)
#define CRI_FCISTATUS2_WMASK   (0xFFFFFFFF)
#define CRI_FCISTATUS2_MASK    (0xFFFFFFFF)
#define CRI_FCISTATUS2_DEFAULT (0x0000)
#define CRI_FCISTATUS2_FMASK   (0x0000)
#define CRI_FCISTATUS3         CRI_GLOBAL(0x010C)
#define CRI_FCISTATUS3_WMASK   (0xFFFFFFFF)
#define CRI_FCISTATUS3_MASK    (0xFFFFFFFF)
#define CRI_FCISTATUS3_DEFAULT (0x0000)
#define CRI_FCISTATUS3_FMASK   (0x0000)

/* Dsp Memory Address Constants */ 
#define dsp_iram_base          (0x0000)
#define dsp_iram_mask          (0xFFFFFFFF)
#define dsp_iram_size          (0x9800)
#define dsp_iram_default       (0x0000)
#define dsp_dccm_base          (0x10000)
#define dsp_dccm_mask          (0xFFFFFFFF)
#define dsp_dccm_size          (0x4000)
#define dsp_dccm_default       (0x0000)
#define dsp_ldstreg_base       (0x20000)
#define dsp_ldstreg_mask       (0xFFFFFFFF)
#define dsp_ldstreg_size       (0x0200)
#define dsp_ldstreg_default    (0x0000)
#define dsp_xram_base          (0x30000)
#define dsp_xram_mask          (0xFFFFFFFF)
#define dsp_xram_size          (0x1000)
#define dsp_xram_default       (0x0000)
#define dsp_yram_base          (0x34000)
#define dsp_yram_mask          (0xFFFFFFFF)
#define dsp_yram_size          (0x1000)
#define dsp_yram_default       (0x0000)
#define dsp_iibram_base        (0x40000)
#define dsp_iibram_mask        (0xFFFFFFFF)
#define dsp_iibram_size        (0x2A000)
#define dsp_iibram_default     (0x0000)
#define dsp_sdram_base         (0x80000)
#define dsp_sdram_mask         (0xFFFFFFFF)
#define dsp_sdram_size         (0x180000)
#define dsp_sdram_default      (0x0000)

/* Dsp Mgmt Address Constants */ 
#define dsp_mgmt_reg_base      (0x0000)
#define DSP_MGMT_REG(r)        (int)(dsp_mgmt_reg_base + (r))
#define dsp_mgmt_reg_size      (0x0080)

#define ME_VERSION             DSP_MGMT_REG(0x0000)
#define ME_VERSION_WMASK       (0x0000)
#define ME_VERSION_MASK        (0x0FFF)
#define ME_VERSION_DEFAULT     (0x0230)
#define ME_VERSION_FMASK       (0x0FFF)
#define ME_ARC2ME_STAT         DSP_MGMT_REG(0x0004)
#define ME_ARC2ME_STAT_WMASK   (0x0037)
#define ME_ARC2ME_STAT_MASK    (0x0037)
#define ME_ARC2ME_STAT_DEFAULT (0x0000)
#define ME_ARC2ME_STAT_FMASK   (0x0000)
#define ME_ARC2ME_MASK         DSP_MGMT_REG(0x0008)
#define ME_ARC2ME_MASK_WMASK   (0x0037)
#define ME_ARC2ME_MASK_MASK    (0x0037)
#define ME_ARC2ME_MASK_DEFAULT (0x0000)
#define ME_ARC2ME_MASK_FMASK   (0x0037)
#define ME_ME2ARC_INT          DSP_MGMT_REG(0x000C)
#define ME_ME2ARC_INT_WMASK    (0x0007)
#define ME_ME2ARC_INT_MASK     (0x0007)
#define ME_ME2ARC_INT_DEFAULT  (0x0000)
#define ME_ME2ARC_INT_FMASK    (0x0007)
#define ME_ME2ARC_STAT         DSP_MGMT_REG(0x0010)
#define ME_ME2ARC_STAT_WMASK   (0x0000)
#define ME_ME2ARC_STAT_MASK    (0x0007)
#define ME_ME2ARC_STAT_DEFAULT (0x0000)
#define ME_ME2ARC_STAT_FMASK   (0x0007)
#define ME_CLK_CTRL            DSP_MGMT_REG(0x0014)
#define ME_CLK_CTRL_WMASK      (0x0001)
#define ME_CLK_CTRL_MASK       (0x0001)
#define ME_CLK_CTRL_DEFAULT    (0x0001)
#define ME_CLK_CTRL_FMASK      (0x0001)
#define ME_RST_CTRL            DSP_MGMT_REG(0x0018)
#define ME_RST_CTRL_WMASK      (0x0007)
#define ME_RST_CTRL_MASK       (0x0007)
#define ME_RST_CTRL_DEFAULT    (0x0000)
#define ME_RST_CTRL_FMASK      (0x0007)
#define ME_CHIP_CONFIG         DSP_MGMT_REG(0x001C)
#define ME_CHIP_CONFIG_WMASK   (0x0001)
#define ME_CHIP_CONFIG_MASK    (0x0001)
#define ME_CHIP_CONFIG_DEFAULT (0x0000)
#define ME_CHIP_CONFIG_FMASK   (0x0001)
#define ME_DBG_MASTER          DSP_MGMT_REG(0x0020)
#define ME_DBG_MASTER_WMASK    (0x0001)
#define ME_DBG_MASTER_MASK     (0x0001)
#define ME_DBG_MASTER_DEFAULT  (0x0000)
#define ME_DBG_MASTER_FMASK    (0x0001)
#define ME_DBG_DECODE          DSP_MGMT_REG(0x0024)
#define ME_DBG_DECODE_WMASK    (0x0003)
#define ME_DBG_DECODE_MASK     (0x0003)
#define ME_DBG_DECODE_DEFAULT  (0x0000)
#define ME_DBG_DECODE_FMASK    (0x0003)
#define ME_DBG_PORT_SEL        DSP_MGMT_REG(0x0028)
#define ME_DBG_PORT_SEL_WMASK  (0x0001)
#define ME_DBG_PORT_SEL_MASK   (0x0001)
#define ME_DBG_PORT_SEL_DEFAULT (0x0000)
#define ME_DBG_PORT_SEL_FMASK  (0x0001)
#define ME_DBG_RD_AD           DSP_MGMT_REG(0x002C)
#define ME_DBG_RD_AD_WMASK     (0x3FFFFF)
#define ME_DBG_RD_AD_MASK      (0x3FFFFF)
#define ME_DBG_RD_AD_DEFAULT   (0x0000)
#define ME_DBG_RD_AD_FMASK     (0x3FFFFF)
#define ME_DBG_WR_AD           DSP_MGMT_REG(0x0030)
#define ME_DBG_WR_AD_WMASK     (0x3FFFFF)
#define ME_DBG_WR_AD_MASK      (0x3FFFFF)
#define ME_DBG_WR_AD_DEFAULT   (0x0000)
#define ME_DBG_WR_AD_FMASK     (0x3FFFFF)
#define ME_DBG_DATA            DSP_MGMT_REG(0x0034)
#define ME_DBG_DATA_WMASK      (0xFFFFFFFF)
#define ME_DBG_DATA_MASK       (0xFFFFFFFF)
#define ME_DBG_DATA_DEFAULT    (0x0000)
#define ME_DBG_DATA_FMASK      (0xFFFFFFFF)
#define ME_DX_PORT_SEL         DSP_MGMT_REG(0x0038)
#define ME_DX_PORT_SEL_WMASK   (0x0001)
#define ME_DX_PORT_SEL_MASK    (0x0001)
#define ME_DX_PORT_SEL_DEFAULT (0x0000)
#define ME_DX_PORT_SEL_FMASK   (0x0001)
#define ME_DX_AD               DSP_MGMT_REG(0x003C)
#define ME_DX_AD_WMASK         (0x3FFFFC)
#define ME_DX_AD_MASK          (0x3FFFFF)
#define ME_DX_AD_DEFAULT       (0x0000)
#define ME_DX_AD_FMASK         (0x3FFFFF)
#define ME_DX_DATA             DSP_MGMT_REG(0x0040)
#define ME_DX_DATA_WMASK       (0xFFFFFFFF)
#define ME_DX_DATA_MASK        (0xFFFFFFFF)
#define ME_DX_DATA_DEFAULT     (0x0000)
#define ME_DX_DATA_FMASK       (0xFFFFFFFF)
#define ME_DX_STAT             DSP_MGMT_REG(0x0044)
#define ME_DX_STAT_WMASK       (0x0003)
#define ME_DX_STAT_MASK        (0x0003)
#define ME_DX_STAT_DEFAULT     (0x0000)
#define ME_DX_STAT_FMASK       (0x0000)
#define ME_DX_MWS              DSP_MGMT_REG(0x0048)
#define ME_DX_MWS_WMASK        (0x000F)
#define ME_DX_MWS_MASK         (0x000F)
#define ME_DX_MWS_DEFAULT      (0x0003)
#define ME_DX_MWS_FMASK        (0x000F)
#define ME_ARC_GP_STAT         DSP_MGMT_REG(0x004C)
#define ME_ARC_GP_STAT_WMASK   (0x0000)
#define ME_ARC_GP_STAT_MASK    (0xFFFFFFFF)
#define ME_ARC_GP_STAT_DEFAULT (0x0000)
#define ME_ARC_GP_STAT_FMASK   (0xFFFFFFFF)
#define ME_XDATA_BASE_SH       DSP_MGMT_REG(0x0050)
#define ME_XDATA_BASE_SH_WMASK (0x1FFFFFE0)
#define ME_XDATA_BASE_SH_MASK  (0x1FFFFFE0)
#define ME_XDATA_BASE_SH_DEFAULT (0x1FFFFFE0)
#define ME_XDATA_BASE_SH_FMASK (0x1FFFFFE0)
#define ME_XDATA_BASE          DSP_MGMT_REG(0x0054)
#define ME_XDATA_BASE_WMASK    (0x0000)
#define ME_XDATA_BASE_MASK     (0x1FFFFFE0)
#define ME_XDATA_BASE_DEFAULT  (0x1FFFFFE0)
#define ME_XDATA_BASE_FMASK    (0x1FFFFFE0)
#define ME_XMEM_BAR0           DSP_MGMT_REG(0x0058)
#define ME_XMEM_BAR0_WMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR0_MASK      (0x1FFFFFE0)
#define ME_XMEM_BAR0_DEFAULT   (0x1FFFFFE0)
#define ME_XMEM_BAR0_FMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR1           DSP_MGMT_REG(0x005C)
#define ME_XMEM_BAR1_WMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR1_MASK      (0x1FFFFFE0)
#define ME_XMEM_BAR1_DEFAULT   (0x1FFFFFE0)
#define ME_XMEM_BAR1_FMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR2           DSP_MGMT_REG(0x0060)
#define ME_XMEM_BAR2_WMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR2_MASK      (0x1FFFFFE0)
#define ME_XMEM_BAR2_DEFAULT   (0x1FFFFFE0)
#define ME_XMEM_BAR2_FMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR3           DSP_MGMT_REG(0x0064)
#define ME_XMEM_BAR3_WMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR3_MASK      (0x1FFFFFE0)
#define ME_XMEM_BAR3_DEFAULT   (0x1FFFFFE0)
#define ME_XMEM_BAR3_FMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR4           DSP_MGMT_REG(0x0068)
#define ME_XMEM_BAR4_WMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR4_MASK      (0x1FFFFFE0)
#define ME_XMEM_BAR4_DEFAULT   (0x1FFFFFE0)
#define ME_XMEM_BAR4_FMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR5           DSP_MGMT_REG(0x006C)
#define ME_XMEM_BAR5_WMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR5_MASK      (0x1FFFFFE0)
#define ME_XMEM_BAR5_DEFAULT   (0x1FFFFFE0)
#define ME_XMEM_BAR5_FMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR6           DSP_MGMT_REG(0x0070)
#define ME_XMEM_BAR6_WMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR6_MASK      (0x1FFFFFE0)
#define ME_XMEM_BAR6_DEFAULT   (0x1FFFFFE0)
#define ME_XMEM_BAR6_FMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR7           DSP_MGMT_REG(0x0074)
#define ME_XMEM_BAR7_WMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR7_MASK      (0x1FFFFFE0)
#define ME_XMEM_BAR7_DEFAULT   (0x1FFFFFE0)
#define ME_XMEM_BAR7_FMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR8           DSP_MGMT_REG(0x0078)
#define ME_XMEM_BAR8_WMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR8_MASK      (0x1FFFFFE0)
#define ME_XMEM_BAR8_DEFAULT   (0x1FFFFFE0)
#define ME_XMEM_BAR8_FMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR9           DSP_MGMT_REG(0x007C)
#define ME_XMEM_BAR9_WMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR9_MASK      (0x1FFFFFE0)
#define ME_XMEM_BAR9_DEFAULT   (0x1FFFFFE0)
#define ME_XMEM_BAR9_FMASK     (0x1FFFFFE0)
#define ME_XMEM_BAR10          DSP_MGMT_REG(0x0080)
#define ME_XMEM_BAR10_WMASK    (0x1FFFFFE0)
#define ME_XMEM_BAR10_MASK     (0x1FFFFFE0)
#define ME_XMEM_BAR10_DEFAULT  (0x1FFFFFE0)
#define ME_XMEM_BAR10_FMASK    (0x1FFFFFE0)
#define ME_XMEM_BAR11          DSP_MGMT_REG(0x0084)
#define ME_XMEM_BAR11_WMASK    (0x1FFFFFE0)
#define ME_XMEM_BAR11_MASK     (0x1FFFFFE0)
#define ME_XMEM_BAR11_DEFAULT  (0x1FFFFFE0)
#define ME_XMEM_BAR11_FMASK    (0x1FFFFFE0)
#define ME_XMEM_BAR12          DSP_MGMT_REG(0x0088)
#define ME_XMEM_BAR12_WMASK    (0x1FFFFFE0)
#define ME_XMEM_BAR12_MASK     (0x1FFFFFE0)
#define ME_XMEM_BAR12_DEFAULT  (0x1FFFFFE0)
#define ME_XMEM_BAR12_FMASK    (0x1FFFFFE0)
#define ME_XMEM_BAR13          DSP_MGMT_REG(0x008C)
#define ME_XMEM_BAR13_WMASK    (0x1FFFFFE0)
#define ME_XMEM_BAR13_MASK     (0x1FFFFFE0)
#define ME_XMEM_BAR13_DEFAULT  (0x1FFFFFE0)
#define ME_XMEM_BAR13_FMASK    (0x1FFFFFE0)
#define ME_XMEM_BAR14          DSP_MGMT_REG(0x0090)
#define ME_XMEM_BAR14_WMASK    (0x1FFFFFE0)
#define ME_XMEM_BAR14_MASK     (0x1FFFFFE0)
#define ME_XMEM_BAR14_DEFAULT  (0x1FFFFFE0)
#define ME_XMEM_BAR14_FMASK    (0x1FFFFFE0)
#define ME_XMEM_BAR15          DSP_MGMT_REG(0x0094)
#define ME_XMEM_BAR15_WMASK    (0x1FFFFFE0)
#define ME_XMEM_BAR15_MASK     (0x1FFFFFE0)
#define ME_XMEM_BAR15_DEFAULT  (0x1FFFFFE0)
#define ME_XMEM_BAR15_FMASK    (0x1FFFFFE0)
#define ME_XMEM_BAR16          DSP_MGMT_REG(0x0098)
#define ME_XMEM_BAR16_WMASK    (0x1FFFFFE0)
#define ME_XMEM_BAR16_MASK     (0x1FFFFFE0)
#define ME_XMEM_BAR16_DEFAULT  (0x1FFFFFE0)
#define ME_XMEM_BAR16_FMASK    (0x1FFFFFE0)
#define ME_XMEM_ARB_MISC       DSP_MGMT_REG(0x009C)
#define ME_XMEM_ARB_MISC_WMASK (0x0000)
#define ME_XMEM_ARB_MISC_MASK  (0x000F)
#define ME_XMEM_ARB_MISC_DEFAULT (0x0000)
#define ME_XMEM_ARB_MISC_FMASK (0x000F)

/* Dsp Ldstreg Address Constants */ 
#define dsp_ldstreg_reg_base   (0x20000)
#define DSP_LDSTREG_REG(r)     (int)(dsp_ldstreg_reg_base + (r))
#define dsp_ldstreg_reg_size   (0x0080)

#define D_VERSION              DSP_LDSTREG_REG(0x0000)
#define D_VERSION_WMASK        (0x0000)
#define D_VERSION_MASK         (0x0FFF)
#define D_VERSION_DEFAULT      (0x0230)
#define D_VERSION_FMASK        (0x0FFF)
#define D_PORT_SEL             DSP_LDSTREG_REG(0x0004)
#define D_PORT_SEL_WMASK       (0x1113311)
#define D_PORT_SEL_MASK        (0x1113311)
#define D_PORT_SEL_DEFAULT     (0x0000)
#define D_PORT_SEL_FMASK       (0x1113311)
#define D_INT_STAT             DSP_LDSTREG_REG(0x0008)
#define D_INT_STAT_WMASK       (0x3333371)
#define D_INT_STAT_MASK        (0x3333371)
#define D_INT_STAT_DEFAULT     (0x0000)
#define D_INT_STAT_FMASK       (0x0000)
#define D_INT_MASK             DSP_LDSTREG_REG(0x000C)
#define D_INT_MASK_WMASK       (0x3333371)
#define D_INT_MASK_MASK        (0x3333371)
#define D_INT_MASK_DEFAULT     (0x0000)
#define D_INT_MASK_FMASK       (0x3333371)
#define D_MEMEX_SRC            DSP_LDSTREG_REG(0x0010)
#define D_MEMEX_SRC_WMASK      (0x000F)
#define D_MEMEX_SRC_MASK       (0x000F)
#define D_MEMEX_SRC_DEFAULT    (0x0000)
#define D_MEMEX_SRC_FMASK      (0x000F)
#define D_ARC2ME_INT           DSP_LDSTREG_REG(0x0014)
#define D_ARC2ME_INT_WMASK     (0x0007)
#define D_ARC2ME_INT_MASK      (0x0007)
#define D_ARC2ME_INT_DEFAULT   (0x0000)
#define D_ARC2ME_INT_FMASK     (0x0007)
#define D_ARC2ME_STAT          DSP_LDSTREG_REG(0x0018)
#define D_ARC2ME_STAT_WMASK    (0x0000)
#define D_ARC2ME_STAT_MASK     (0x0007)
#define D_ARC2ME_STAT_DEFAULT  (0x0000)
#define D_ARC2ME_STAT_FMASK    (0x0007)
#define D_GP_STAT              DSP_LDSTREG_REG(0x001C)
#define D_GP_STAT_WMASK        (0xFFFFFFFF)
#define D_GP_STAT_MASK         (0xFFFFFFFF)
#define D_GP_STAT_DEFAULT      (0x0000)
#define D_GP_STAT_FMASK        (0xFFFFFFFF)
#define D_ME_CONFIG            DSP_LDSTREG_REG(0x0020)
#define D_ME_CONFIG_WMASK      (0x0000)
#define D_ME_CONFIG_MASK       (0x0001)
#define D_ME_CONFIG_DEFAULT    (0x0000)
#define D_ME_CONFIG_FMASK      (0x0001)
#define D_MEMEXT_SEL           DSP_LDSTREG_REG(0x0024)
#define D_MEMEXT_SEL_WMASK     (0x0000)
#define D_MEMEXT_SEL_MASK      (0x0007)
#define D_MEMEXT_SEL_DEFAULT   (0x0000)
#define D_MEMEXT_SEL_FMASK     (0x0007)
#define D_ADMA0_CTRL           DSP_LDSTREG_REG(0x0028)
#define D_ADMA0_CTRL_WMASK     (0x0003)
#define D_ADMA0_CTRL_MASK      (0x0003)
#define D_ADMA0_CTRL_DEFAULT   (0x0000)
#define D_ADMA0_CTRL_FMASK     (0x0003)
#define D_ADMA0_STAT           DSP_LDSTREG_REG(0x002C)
#define D_ADMA0_STAT_WMASK     (0x0000)
#define D_ADMA0_STAT_MASK      (0x0007)
#define D_ADMA0_STAT_DEFAULT   (0x0000)
#define D_ADMA0_STAT_FMASK     (0x0007)
#define D_ADMA0_SA_S           DSP_LDSTREG_REG(0x0030)
#define D_ADMA0_SA_S_WMASK     (0x3FFFFE)
#define D_ADMA0_SA_S_MASK      (0x3FFFFF)
#define D_ADMA0_SA_S_DEFAULT   (0x0000)
#define D_ADMA0_SA_S_FMASK     (0x3FFFFF)
#define D_ADMA0_SA_E           DSP_LDSTREG_REG(0x0034)
#define D_ADMA0_SA_E_WMASK     (0x3FFFFE)
#define D_ADMA0_SA_E_MASK      (0x3FFFFF)
#define D_ADMA0_SA_E_DEFAULT   (0x0000)
#define D_ADMA0_SA_E_FMASK     (0x3FFFFF)
#define D_ADMA0_DA_S           DSP_LDSTREG_REG(0x0038)
#define D_ADMA0_DA_S_WMASK     (0x3FFFFE)
#define D_ADMA0_DA_S_MASK      (0x3FFFFF)
#define D_ADMA0_DA_S_DEFAULT   (0x0000)
#define D_ADMA0_DA_S_FMASK     (0x3FFFFF)
#define D_ADMA0_FILL_VAL       DSP_LDSTREG_REG(0x003C)
#define D_ADMA0_FILL_VAL_WMASK (0xFFFFFFFF)
#define D_ADMA0_FILL_VAL_MASK  (0xFFFFFFFF)
#define D_ADMA0_FILL_VAL_DEFAULT (0x0000)
#define D_ADMA0_FILL_VAL_FMASK (0xFFFFFFFF)
#define D_ADMA1_CTRL           DSP_LDSTREG_REG(0x0040)
#define D_ADMA1_CTRL_WMASK     (0x0003)
#define D_ADMA1_CTRL_MASK      (0x0003)
#define D_ADMA1_CTRL_DEFAULT   (0x0000)
#define D_ADMA1_CTRL_FMASK     (0x0003)
#define D_ADMA1_STAT           DSP_LDSTREG_REG(0x0044)
#define D_ADMA1_STAT_WMASK     (0x0000)
#define D_ADMA1_STAT_MASK      (0x0007)
#define D_ADMA1_STAT_DEFAULT   (0x0000)
#define D_ADMA1_STAT_FMASK     (0x0007)
#define D_ADMA1_SA_S           DSP_LDSTREG_REG(0x0048)
#define D_ADMA1_SA_S_WMASK     (0x3FFFFE)
#define D_ADMA1_SA_S_MASK      (0x3FFFFF)
#define D_ADMA1_SA_S_DEFAULT   (0x0000)
#define D_ADMA1_SA_S_FMASK     (0x3FFFFF)
#define D_ADMA1_SA_E           DSP_LDSTREG_REG(0x004C)
#define D_ADMA1_SA_E_WMASK     (0x3FFFFE)
#define D_ADMA1_SA_E_MASK      (0x3FFFFF)
#define D_ADMA1_SA_E_DEFAULT   (0x0000)
#define D_ADMA1_SA_E_FMASK     (0x3FFFFF)
#define D_ADMA1_DA_S           DSP_LDSTREG_REG(0x0050)
#define D_ADMA1_DA_S_WMASK     (0x3FFFFE)
#define D_ADMA1_DA_S_MASK      (0x3FFFFF)
#define D_ADMA1_DA_S_DEFAULT   (0x0000)
#define D_ADMA1_DA_S_FMASK     (0x3FFFFF)
#define D_ADMA1_FILL_VAL       DSP_LDSTREG_REG(0x0054)
#define D_ADMA1_FILL_VAL_WMASK (0xFFFFFFFF)
#define D_ADMA1_FILL_VAL_MASK  (0xFFFFFFFF)
#define D_ADMA1_FILL_VAL_DEFAULT (0x0000)
#define D_ADMA1_FILL_VAL_FMASK (0xFFFFFFFF)
#define D_XDMA0_CTRL           DSP_LDSTREG_REG(0x0058)
#define D_XDMA0_CTRL_WMASK     (0x0007)
#define D_XDMA0_CTRL_MASK      (0x0007)
#define D_XDMA0_CTRL_DEFAULT   (0x0000)
#define D_XDMA0_CTRL_FMASK     (0x0007)
#define D_XDMA0_STAT           DSP_LDSTREG_REG(0x005C)
#define D_XDMA0_STAT_WMASK     (0x0000)
#define D_XDMA0_STAT_MASK      (0x000F)
#define D_XDMA0_STAT_DEFAULT   (0x0000)
#define D_XDMA0_STAT_FMASK     (0x000F)
#define D_XDMA0_SA_S           DSP_LDSTREG_REG(0x0060)
#define D_XDMA0_SA_S_WMASK     (0x3FFFFFFE)
#define D_XDMA0_SA_S_MASK      (0x3FFFFFFF)
#define D_XDMA0_SA_S_DEFAULT   (0x0000)
#define D_XDMA0_SA_S_FMASK     (0x3FFFFFFF)
#define D_XDMA0_SA_E           DSP_LDSTREG_REG(0x0064)
#define D_XDMA0_SA_E_WMASK     (0x3FFFFFFE)
#define D_XDMA0_SA_E_MASK      (0x3FFFFFFF)
#define D_XDMA0_SA_E_DEFAULT   (0x0000)
#define D_XDMA0_SA_E_FMASK     (0x3FFFFFFF)
#define D_XDMA0_DA_S           DSP_LDSTREG_REG(0x0068)
#define D_XDMA0_DA_S_WMASK     (0x3FFFFFFE)
#define D_XDMA0_DA_S_MASK      (0x3FFFFFFF)
#define D_XDMA0_DA_S_DEFAULT   (0x0000)
#define D_XDMA0_DA_S_FMASK     (0x3FFFFFFF)
#define D_XDMA1_CTRL           DSP_LDSTREG_REG(0x006C)
#define D_XDMA1_CTRL_WMASK     (0x0007)
#define D_XDMA1_CTRL_MASK      (0x0007)
#define D_XDMA1_CTRL_DEFAULT   (0x0000)
#define D_XDMA1_CTRL_FMASK     (0x0007)
#define D_XDMA1_STAT           DSP_LDSTREG_REG(0x0070)
#define D_XDMA1_STAT_WMASK     (0x0000)
#define D_XDMA1_STAT_MASK      (0x000F)
#define D_XDMA1_STAT_DEFAULT   (0x0000)
#define D_XDMA1_STAT_FMASK     (0x000F)
#define D_XDMA1_SA_S           DSP_LDSTREG_REG(0x0074)
#define D_XDMA1_SA_S_WMASK     (0x3FFFFFFE)
#define D_XDMA1_SA_S_MASK      (0x3FFFFFFF)
#define D_XDMA1_SA_S_DEFAULT   (0x0000)
#define D_XDMA1_SA_S_FMASK     (0x3FFFFFFF)
#define D_XDMA1_SA_E           DSP_LDSTREG_REG(0x0078)
#define D_XDMA1_SA_E_WMASK     (0x3FFFFFFE)
#define D_XDMA1_SA_E_MASK      (0x3FFFFFFF)
#define D_XDMA1_SA_E_DEFAULT   (0x0000)
#define D_XDMA1_SA_E_FMASK     (0x3FFFFFFF)
#define D_XDMA1_DA_S           DSP_LDSTREG_REG(0x007C)
#define D_XDMA1_DA_S_WMASK     (0x3FFFFFFE)
#define D_XDMA1_DA_S_MASK      (0x3FFFFFFF)
#define D_XDMA1_DA_S_DEFAULT   (0x0000)
#define D_XDMA1_DA_S_FMASK     (0x3FFFFFFF)
#define D_XDMA_GAP             DSP_LDSTREG_REG(0x0080)
#define D_XDMA_GAP_WMASK       (0xFFFF)
#define D_XDMA_GAP_MASK        (0xFFFF)
#define D_XDMA_GAP_DEFAULT     (0x0000)
#define D_XDMA_GAP_FMASK       (0xFFFF)
#define D_XDATA_BASE_SH        DSP_LDSTREG_REG(0x0084)
#define D_XDATA_BASE_SH_WMASK  (0x0000)
#define D_XDATA_BASE_SH_MASK   (0x1FFFFFE0)
#define D_XDATA_BASE_SH_DEFAULT (0x1FFFFFE0)
#define D_XDATA_BASE_SH_FMASK  (0x1FFFFFE0)
#define D_XDATA_BASE           DSP_LDSTREG_REG(0x0088)
#define D_XDATA_BASE_WMASK     (0x0000)
#define D_XDATA_BASE_MASK      (0x1FFFFFE0)
#define D_XDATA_BASE_DEFAULT   (0x1FFFFFE0)
#define D_XDATA_BASE_FMASK     (0x1FFFFFE0)
#define D_XMEM_BAR0            DSP_LDSTREG_REG(0x008C)
#define D_XMEM_BAR0_WMASK      (0x0000)
#define D_XMEM_BAR0_MASK       (0x1FFFFFE0)
#define D_XMEM_BAR0_DEFAULT    (0x1FFFFFE0)
#define D_XMEM_BAR0_FMASK      (0x1FFFFFE0)
#define D_XMEM_BAR1            DSP_LDSTREG_REG(0x0090)
#define D_XMEM_BAR1_WMASK      (0x0000)
#define D_XMEM_BAR1_MASK       (0x1FFFFFE0)
#define D_XMEM_BAR1_DEFAULT    (0x1FFFFFE0)
#define D_XMEM_BAR1_FMASK      (0x1FFFFFE0)
#define D_XMEM_BAR2            DSP_LDSTREG_REG(0x0094)
#define D_XMEM_BAR2_WMASK      (0x0000)
#define D_XMEM_BAR2_MASK       (0x1FFFFFE0)
#define D_XMEM_BAR2_DEFAULT    (0x1FFFFFE0)
#define D_XMEM_BAR2_FMASK      (0x1FFFFFE0)
#define D_XMEM_BAR3            DSP_LDSTREG_REG(0x0098)
#define D_XMEM_BAR3_WMASK      (0x0000)
#define D_XMEM_BAR3_MASK       (0x1FFFFFE0)
#define D_XMEM_BAR3_DEFAULT    (0x1FFFFFE0)
#define D_XMEM_BAR3_FMASK      (0x1FFFFFE0)
#define D_XMEM_BAR4            DSP_LDSTREG_REG(0x009C)
#define D_XMEM_BAR4_WMASK      (0x0000)
#define D_XMEM_BAR4_MASK       (0x1FFFFFE0)
#define D_XMEM_BAR4_DEFAULT    (0x1FFFFFE0)
#define D_XMEM_BAR4_FMASK      (0x1FFFFFE0)
#define D_XMEM_BAR5            DSP_LDSTREG_REG(0x00A0)
#define D_XMEM_BAR5_WMASK      (0x0000)
#define D_XMEM_BAR5_MASK       (0x1FFFFFE0)
#define D_XMEM_BAR5_DEFAULT    (0x1FFFFFE0)
#define D_XMEM_BAR5_FMASK      (0x1FFFFFE0)
#define D_XMEM_BAR6            DSP_LDSTREG_REG(0x00A4)
#define D_XMEM_BAR6_WMASK      (0x0000)
#define D_XMEM_BAR6_MASK       (0x1FFFFFE0)
#define D_XMEM_BAR6_DEFAULT    (0x1FFFFFE0)
#define D_XMEM_BAR6_FMASK      (0x1FFFFFE0)
#define D_XMEM_BAR7            DSP_LDSTREG_REG(0x00A8)
#define D_XMEM_BAR7_WMASK      (0x0000)
#define D_XMEM_BAR7_MASK       (0x1FFFFFE0)
#define D_XMEM_BAR7_DEFAULT    (0x1FFFFFE0)
#define D_XMEM_BAR7_FMASK      (0x1FFFFFE0)
#define D_XMEM_BAR8            DSP_LDSTREG_REG(0x00AC)
#define D_XMEM_BAR8_WMASK      (0x0000)
#define D_XMEM_BAR8_MASK       (0x1FFFFFE0)
#define D_XMEM_BAR8_DEFAULT    (0x1FFFFFE0)
#define D_XMEM_BAR8_FMASK      (0x1FFFFFE0)
#define D_XMEM_BAR9            DSP_LDSTREG_REG(0x00B0)
#define D_XMEM_BAR9_WMASK      (0x0000)
#define D_XMEM_BAR9_MASK       (0x1FFFFFE0)
#define D_XMEM_BAR9_DEFAULT    (0x1FFFFFE0)
#define D_XMEM_BAR9_FMASK      (0x1FFFFFE0)
#define D_XMEM_BAR10           DSP_LDSTREG_REG(0x00B4)
#define D_XMEM_BAR10_WMASK     (0x0000)
#define D_XMEM_BAR10_MASK      (0x1FFFFFE0)
#define D_XMEM_BAR10_DEFAULT   (0x1FFFFFE0)
#define D_XMEM_BAR10_FMASK     (0x1FFFFFE0)
#define D_XMEM_BAR11           DSP_LDSTREG_REG(0x00B8)
#define D_XMEM_BAR11_WMASK     (0x0000)
#define D_XMEM_BAR11_MASK      (0x1FFFFFE0)
#define D_XMEM_BAR11_DEFAULT   (0x1FFFFFE0)
#define D_XMEM_BAR11_FMASK     (0x1FFFFFE0)
#define D_XMEM_BAR12           DSP_LDSTREG_REG(0x00BC)
#define D_XMEM_BAR12_WMASK     (0x0000)
#define D_XMEM_BAR12_MASK      (0x1FFFFFE0)
#define D_XMEM_BAR12_DEFAULT   (0x1FFFFFE0)
#define D_XMEM_BAR12_FMASK     (0x1FFFFFE0)
#define D_XMEM_BAR13           DSP_LDSTREG_REG(0x00C0)
#define D_XMEM_BAR13_WMASK     (0x0000)
#define D_XMEM_BAR13_MASK      (0x1FFFFFE0)
#define D_XMEM_BAR13_DEFAULT   (0x1FFFFFE0)
#define D_XMEM_BAR13_FMASK     (0x1FFFFFE0)
#define D_XMEM_BAR14           DSP_LDSTREG_REG(0x00C4)
#define D_XMEM_BAR14_WMASK     (0x0000)
#define D_XMEM_BAR14_MASK      (0x1FFFFFE0)
#define D_XMEM_BAR14_DEFAULT   (0x1FFFFFE0)
#define D_XMEM_BAR14_FMASK     (0x1FFFFFE0)
#define D_XMEM_BAR15           DSP_LDSTREG_REG(0x00C8)
#define D_XMEM_BAR15_WMASK     (0x0000)
#define D_XMEM_BAR15_MASK      (0x1FFFFFE0)
#define D_XMEM_BAR15_DEFAULT   (0x1FFFFFE0)
#define D_XMEM_BAR15_FMASK     (0x1FFFFFE0)
#define D_XMEM_BAR16           DSP_LDSTREG_REG(0x00CC)
#define D_XMEM_BAR16_WMASK     (0x0000)
#define D_XMEM_BAR16_MASK      (0x1FFFFFE0)
#define D_XMEM_BAR16_DEFAULT   (0x1FFFFFE0)
#define D_XMEM_BAR16_FMASK     (0x1FFFFFE0)
#define D_GPIO_CTRL            DSP_LDSTREG_REG(0x00D0)
#define D_GPIO_CTRL_WMASK      (0x3FFFF)
#define D_GPIO_CTRL_MASK       (0x3FFFF)
#define D_GPIO_CTRL_DEFAULT    (0x0000)
#define D_GPIO_CTRL_FMASK      (0x3FFFF)
#define D_GPIO_PW_CTRL         DSP_LDSTREG_REG(0x00D4)
#define D_GPIO_PW_CTRL_WMASK   (0x000F)
#define D_GPIO_PW_CTRL_MASK    (0x000F)
#define D_GPIO_PW_CTRL_DEFAULT (0x0000)
#define D_GPIO_PW_CTRL_FMASK   (0x000F)
#define D_GPIO_DATA            DSP_LDSTREG_REG(0x00D8)
#define D_GPIO_DATA_WMASK      (0xFFFF)
#define D_GPIO_DATA_MASK       (0xFFFF)
#define D_GPIO_DATA_DEFAULT    (0x0000)
#define D_GPIO_DATA_FMASK      (0xFFFF)
#define D_XMEM_LAT             DSP_LDSTREG_REG(0x00DC)
#define D_XMEM_LAT_WMASK       (0x0FF1)
#define D_XMEM_LAT_MASK        (0x0FF1)
#define D_XMEM_LAT_DEFAULT     (0x0000)
#define D_XMEM_LAT_FMASK       (0x0FF1)
#define D_IC_MISSES            DSP_LDSTREG_REG(0x00E0)
#define D_IC_MISSES_WMASK      (0x7FFFFFF)
#define D_IC_MISSES_MASK       (0x7FFFFFF)
#define D_IC_MISSES_DEFAULT    (0x0000)
#define D_IC_MISSES_FMASK      (0x7FFFFFF)
#define D_IC_MISS_LAT          DSP_LDSTREG_REG(0x00E4)
#define D_IC_MISS_LAT_WMASK    (0xFFFFFFFF)
#define D_IC_MISS_LAT_MASK     (0xFFFFFFFF)
#define D_IC_MISS_LAT_DEFAULT  (0x0000)
#define D_IC_MISS_LAT_FMASK    (0xFFFFFFFF)
#define D_PER_IC_MISS_LAT      DSP_LDSTREG_REG(0x00E8)
#define D_PER_IC_MISS_LAT_WMASK (0xFFFF)
#define D_PER_IC_MISS_LAT_MASK (0xFFFF)
#define D_PER_IC_MISS_LAT_DEFAULT (0x0000)
#define D_PER_IC_MISS_LAT_FMASK (0xFFFF)
#define D_XMEM_DATA_ACCS       DSP_LDSTREG_REG(0x00EC)
#define D_XMEM_DATA_ACCS_WMASK (0xFFFFFFFF)
#define D_XMEM_DATA_ACCS_MASK  (0xFFFFFFFF)
#define D_XMEM_DATA_ACCS_DEFAULT (0xC0000000)
#define D_XMEM_DATA_ACCS_FMASK (0xFFFFFFFF)
#define D_XMEM_DATA_CLKS       DSP_LDSTREG_REG(0x00F0)
#define D_XMEM_DATA_CLKS_WMASK (0xFFFFFFFF)
#define D_XMEM_DATA_CLKS_MASK  (0xFFFFFFFF)
#define D_XMEM_DATA_CLKS_DEFAULT (0x0000)
#define D_XMEM_DATA_CLKS_FMASK (0xFFFFFFFF)

/* Fc Memory Address Constants */ 
#define fc_cwram_base          (0x20C000)
#define fc_cwram_mask          (0xFFFF)
#define fc_cwram_size          (0x0400)
#define fc_cwram_default       (0x0000)

/* Fci Memory Address Constants */ 
#define fci_glbtx_base         (0x20D800)
#define fci_glbtx_mask         (0xFFFFFFFF)
#define fci_glbtx_size         (0x0400)
#define fci_glbtx_default      (0x0000)
#define fci_glbrx_base         (0x20DC00)
#define fci_glbrx_mask         (0xFFFFFFFF)
#define fci_glbrx_size         (0x0400)
#define fci_glbrx_default      (0x0000)

/* Fci Glbtx Address Constants */ 
#define fci_glbtx_reg_base     (0x20D800)
#define FCI_GLBTX_REG(r)       (int)(fci_glbtx_reg_base + (r))
#define fci_glbtx_reg_size     (0x0001)

#define ZT_R0                  FCI_GLBTX_REG(0x0000)
#define ZT_R0_WMASK            (0xFFFFFFFF)
#define ZT_R0_MASK             (0xFFFFFFFF)
#define ZT_R0_DEFAULT          (0x0000)
#define ZT_R0_FMASK            (0xFFFFFFFF)
#define ZT_R4                  FCI_GLBTX_REG(0x0004)
#define ZT_R4_WMASK            (0xFFFFFFFF)
#define ZT_R4_MASK             (0xFFFFFFFF)
#define ZT_R4_DEFAULT          (0x0000)
#define ZT_R4_FMASK            (0xFFFFFFFF)
#define ZT_R8                  FCI_GLBTX_REG(0x0008)
#define ZT_R8_WMASK            (0xFFFFFFFF)
#define ZT_R8_MASK             (0xFFFFFFFF)
#define ZT_R8_DEFAULT          (0x0000)
#define ZT_R8_FMASK            (0xFFFFFFFF)
#define ZT_R12                 FCI_GLBTX_REG(0x000C)
#define ZT_R12_WMASK           (0xFFFFFFFF)
#define ZT_R12_MASK            (0xFFFFFFFF)
#define ZT_R12_DEFAULT         (0x0000)
#define ZT_R12_FMASK           (0xFFFFFFFF)
#define ZT_CODEWORD            FCI_GLBTX_REG(0x0010)
#define ZT_CODEWORD_WMASK      (0xFFFFFFFF)
#define ZT_CODEWORD_MASK       (0xFFFFFFFF)
#define ZT_CODEWORD_DEFAULT    (0x0000)
#define ZT_CODEWORD_FMASK      (0xFFFFFFFF)
#define ZT_VBC_SIZE            FCI_GLBTX_REG(0x0014)
#define ZT_VBC_SIZE_WMASK      (0xFFFFFFFF)
#define ZT_VBC_SIZE_MASK       (0xFFFFFFFF)
#define ZT_VBC_SIZE_DEFAULT    (0x0000)
#define ZT_VBC_SIZE_FMASK      (0xFFFFFFFF)
#define ZT_FRAMING             FCI_GLBTX_REG(0x0018)
#define ZT_FRAMING_WMASK       (0xFFFFFFFF)
#define ZT_FRAMING_MASK        (0xFFFFFFFF)
#define ZT_FRAMING_DEFAULT     (0x0000)
#define ZT_FRAMING_FMASK       (0xFFFFFFFF)
#define ZT_OHRATE              FCI_GLBTX_REG(0x001C)
#define ZT_OHRATE_WMASK        (0xFFFFFFFF)
#define ZT_OHRATE_MASK         (0xFFFFFFFF)
#define ZT_OHRATE_DEFAULT      (0x0000)
#define ZT_OHRATE_FMASK        (0xFFFFFFFF)
#define ZT_FLAG_CTRL0          FCI_GLBTX_REG(0x0020)
#define ZT_FLAG_CTRL0_WMASK    (0x77777777)
#define ZT_FLAG_CTRL0_MASK     (0x77777777)
#define ZT_FLAG_CTRL0_DEFAULT  (0x0000)
#define ZT_FLAG_CTRL0_FMASK    (0x77777777)
#define ZT_FLAG_CTRL1          FCI_GLBTX_REG(0x0024)
#define ZT_FLAG_CTRL1_WMASK    (0x7777077)
#define ZT_FLAG_CTRL1_MASK     (0x7777077)
#define ZT_FLAG_CTRL1_DEFAULT  (0x0000)
#define ZT_FLAG_CTRL1_FMASK    (0x7777077)
#define ZT_CRC0                FCI_GLBTX_REG(0x0028)
#define ZT_CRC0_WMASK          (0xFFFFFFFF)
#define ZT_CRC0_MASK           (0xFFFFFFFF)
#define ZT_CRC0_DEFAULT        (0x0000)
#define ZT_CRC0_FMASK          (0xFFFFFFFF)
#define ZT_CRC_POLY0           FCI_GLBTX_REG(0x002C)
#define ZT_CRC_POLY0_WMASK     (0xFFFFFFFF)
#define ZT_CRC_POLY0_MASK      (0xFFFFFFFF)
#define ZT_CRC_POLY0_DEFAULT   (0x0000)
#define ZT_CRC_POLY0_FMASK     (0xFFFFFFFF)
#define ZT_CRC_CTRL0           FCI_GLBTX_REG(0x0030)
#define ZT_CRC_CTRL0_WMASK     (0xFFFF0103)
#define ZT_CRC_CTRL0_MASK      (0xFFFF0103)
#define ZT_CRC_CTRL0_DEFAULT   (0x0000)
#define ZT_CRC_CTRL0_FMASK     (0xFFFF0103)
#define ZT_CRC1                FCI_GLBTX_REG(0x0034)
#define ZT_CRC1_WMASK          (0xFFFFFFFF)
#define ZT_CRC1_MASK           (0xFFFFFFFF)
#define ZT_CRC1_DEFAULT        (0x0000)
#define ZT_CRC1_FMASK          (0xFFFFFFFF)
#define ZT_CRC_POLY1           FCI_GLBTX_REG(0x0038)
#define ZT_CRC_POLY1_WMASK     (0xFFFFFFFF)
#define ZT_CRC_POLY1_MASK      (0xFFFFFFFF)
#define ZT_CRC_POLY1_DEFAULT   (0x0000)
#define ZT_CRC_POLY1_FMASK     (0xFFFFFFFF)
#define ZT_CRC_CTRL1           FCI_GLBTX_REG(0x003C)
#define ZT_CRC_CTRL1_WMASK     (0xFFFF0103)
#define ZT_CRC_CTRL1_MASK      (0xFFFF0103)
#define ZT_CRC_CTRL1_DEFAULT   (0x0000)
#define ZT_CRC_CTRL1_FMASK     (0xFFFF0103)
#define ZT_SCR                 FCI_GLBTX_REG(0x0040)
#define ZT_SCR_WMASK           (0xFFFFFFFF)
#define ZT_SCR_MASK            (0xFFFFFFFF)
#define ZT_SCR_DEFAULT         (0x0000)
#define ZT_SCR_FMASK           (0xFFFFFFFF)
#define ZT_SCR_POLY            FCI_GLBTX_REG(0x0044)
#define ZT_SCR_POLY_WMASK      (0xFFFFFFFF)
#define ZT_SCR_POLY_MASK       (0xFFFFFFFF)
#define ZT_SCR_POLY_DEFAULT    (0x0000)
#define ZT_SCR_POLY_FMASK      (0xFFFFFFFF)
#define ZT_SCR_CTRL            FCI_GLBTX_REG(0x0048)
#define ZT_SCR_CTRL_WMASK      (0x001F)
#define ZT_SCR_CTRL_MASK       (0x001F)
#define ZT_SCR_CTRL_DEFAULT    (0x0000)
#define ZT_SCR_CTRL_FMASK      (0x001F)
#define ZT_SCR_STATE           FCI_GLBTX_REG(0x004C)
#define ZT_SCR_STATE_WMASK     (0x3FFFFFF)
#define ZT_SCR_STATE_MASK      (0x3FFFFFF)
#define ZT_SCR_STATE_DEFAULT   (0x0000)
#define ZT_SCR_STATE_FMASK     (0x3FFFFFF)
#define ZT_DTB_CTRL            FCI_GLBTX_REG(0x0050)
#define ZT_DTB_CTRL_WMASK      (0x1FFF0FFF)
#define ZT_DTB_CTRL_MASK       (0x1FFF0FFF)
#define ZT_DTB_CTRL_DEFAULT    (0x0000)
#define ZT_DTB_CTRL_FMASK      (0x1FFF0FFF)
#define ZT_DTB_PTRS            FCI_GLBTX_REG(0x0054)
#define ZT_DTB_PTRS_WMASK      (0xFFFFFFFF)
#define ZT_DTB_PTRS_MASK       (0xFFFFFFFF)
#define ZT_DTB_PTRS_DEFAULT    (0x0000)
#define ZT_DTB_PTRS_FMASK      (0xFFFFFFFF)
#define ZT_ILVB_WRAD           FCI_GLBTX_REG(0x0058)
#define ZT_ILVB_WRAD_WMASK     (0xFFFFFFFF)
#define ZT_ILVB_WRAD_MASK      (0xFFFFFFFF)
#define ZT_ILVB_WRAD_DEFAULT   (0x0000)
#define ZT_ILVB_WRAD_FMASK     (0xFFFFFFFF)
#define ZT_ILVB_RDAD           FCI_GLBTX_REG(0x005C)
#define ZT_ILVB_RDAD_WMASK     (0xFFFFFFFF)
#define ZT_ILVB_RDAD_MASK      (0xFFFFFFFF)
#define ZT_ILVB_RDAD_DEFAULT   (0x0000)
#define ZT_ILVB_RDAD_FMASK     (0xFFFFFFFF)
#define ZT_ILVB_WRPTR          FCI_GLBTX_REG(0x0060)
#define ZT_ILVB_WRPTR_WMASK    (0xFFFFFFFF)
#define ZT_ILVB_WRPTR_MASK     (0xFFFFFFFF)
#define ZT_ILVB_WRPTR_DEFAULT  (0x0000)
#define ZT_ILVB_WRPTR_FMASK    (0xFFFFFFFF)
#define ZT_ILVB_RDPTR          FCI_GLBTX_REG(0x0064)
#define ZT_ILVB_RDPTR_WMASK    (0xFFFFFFFF)
#define ZT_ILVB_RDPTR_MASK     (0xFFFFFFFF)
#define ZT_ILVB_RDPTR_DEFAULT  (0x0000)
#define ZT_ILVB_RDPTR_FMASK    (0xFFFFFFFF)
#define ZT_FIFO_BASE0          FCI_GLBTX_REG(0x0068)
#define ZT_FIFO_BASE0_WMASK    (0x3FFFFFF)
#define ZT_FIFO_BASE0_MASK     (0x3FFFFFF)
#define ZT_FIFO_BASE0_DEFAULT  (0x0000)
#define ZT_FIFO_BASE0_FMASK    (0x3FFFFFF)
#define ZT_FIFO_PTRS0          FCI_GLBTX_REG(0x006C)
#define ZT_FIFO_PTRS0_WMASK    (0xC0FF00FF)
#define ZT_FIFO_PTRS0_MASK     (0xC0FF00FF)
#define ZT_FIFO_PTRS0_DEFAULT  (0x0000)
#define ZT_FIFO_PTRS0_FMASK    (0xC0FF00FF)
#define ZT_FIFO_CNST0          FCI_GLBTX_REG(0x0070)
#define ZT_FIFO_CNST0_WMASK    (0xFFFFFF)
#define ZT_FIFO_CNST0_MASK     (0xFFFFFF)
#define ZT_FIFO_CNST0_DEFAULT  (0x0000)
#define ZT_FIFO_CNST0_FMASK    (0xFFFFFF)
#define ZT_FIFO_BASE1          FCI_GLBTX_REG(0x0074)
#define ZT_FIFO_BASE1_WMASK    (0x3FFFFFF)
#define ZT_FIFO_BASE1_MASK     (0x3FFFFFF)
#define ZT_FIFO_BASE1_DEFAULT  (0x0000)
#define ZT_FIFO_BASE1_FMASK    (0x3FFFFFF)
#define ZT_FIFO_PTRS1          FCI_GLBTX_REG(0x0078)
#define ZT_FIFO_PTRS1_WMASK    (0xC0FF00FF)
#define ZT_FIFO_PTRS1_MASK     (0xC0FF00FF)
#define ZT_FIFO_PTRS1_DEFAULT  (0x0000)
#define ZT_FIFO_PTRS1_FMASK    (0xC0FF00FF)
#define ZT_FIFO_CNST1          FCI_GLBTX_REG(0x007C)
#define ZT_FIFO_CNST1_WMASK    (0xFFFFFF)
#define ZT_FIFO_CNST1_MASK     (0xFFFFFF)
#define ZT_FIFO_CNST1_DEFAULT  (0x0000)
#define ZT_FIFO_CNST1_FMASK    (0xFFFFFF)
#define ZT_FIFO_BASE2          FCI_GLBTX_REG(0x0080)
#define ZT_FIFO_BASE2_WMASK    (0x3FFFFFF)
#define ZT_FIFO_BASE2_MASK     (0x3FFFFFF)
#define ZT_FIFO_BASE2_DEFAULT  (0x0000)
#define ZT_FIFO_BASE2_FMASK    (0x3FFFFFF)
#define ZT_FIFO_PTRS2          FCI_GLBTX_REG(0x0084)
#define ZT_FIFO_PTRS2_WMASK    (0xC0FF00FF)
#define ZT_FIFO_PTRS2_MASK     (0xC0FF00FF)
#define ZT_FIFO_PTRS2_DEFAULT  (0x0000)
#define ZT_FIFO_PTRS2_FMASK    (0xC0FF00FF)
#define ZT_FIFO_CNST2          FCI_GLBTX_REG(0x0088)
#define ZT_FIFO_CNST2_WMASK    (0xFFFFFF)
#define ZT_FIFO_CNST2_MASK     (0xFFFFFF)
#define ZT_FIFO_CNST2_DEFAULT  (0x0000)
#define ZT_FIFO_CNST2_FMASK    (0xFFFFFF)
#define ZT_FIFO_BASE3          FCI_GLBTX_REG(0x008C)
#define ZT_FIFO_BASE3_WMASK    (0x3FFFFFFF)
#define ZT_FIFO_BASE3_MASK     (0x3FFFFFFF)
#define ZT_FIFO_BASE3_DEFAULT  (0x0000)
#define ZT_FIFO_BASE3_FMASK    (0x3FFFFFFF)
#define ZT_FIFO_PTRS3          FCI_GLBTX_REG(0x0090)
#define ZT_FIFO_PTRS3_WMASK    (0xCFFF0FFF)
#define ZT_FIFO_PTRS3_MASK     (0xCFFF0FFF)
#define ZT_FIFO_PTRS3_DEFAULT  (0x0000)
#define ZT_FIFO_PTRS3_FMASK    (0xCFFF0FFF)
#define ZT_FIFO_CNST3          FCI_GLBTX_REG(0x0094)
#define ZT_FIFO_CNST3_WMASK    (0x1FFFFFF)
#define ZT_FIFO_CNST3_MASK     (0x1FFFFFF)
#define ZT_FIFO_CNST3_DEFAULT  (0x0000)
#define ZT_FIFO_CNST3_FMASK    (0x1FFFFFF)
#define ZT_DEPTH               FCI_GLBTX_REG(0x0098)
#define ZT_DEPTH_WMASK         (0xFFFFFFFF)
#define ZT_DEPTH_MASK          (0xFFFFFFFF)
#define ZT_DEPTH_DEFAULT       (0x0000)
#define ZT_DEPTH_FMASK         (0xFFFFFFFF)
#define ZT_ILV_PARAMS0         FCI_GLBTX_REG(0x009C)
#define ZT_ILV_PARAMS0_WMASK   (0xFFFFFF07)
#define ZT_ILV_PARAMS0_MASK    (0xFFFFFF17)
#define ZT_ILV_PARAMS0_DEFAULT (0x0000)
#define ZT_ILV_PARAMS0_FMASK   (0xFFFFFF07)
#define ZT_ILV_BASE0           FCI_GLBTX_REG(0x00A0)
#define ZT_ILV_BASE0_WMASK     (0x3FFFF)
#define ZT_ILV_BASE0_MASK      (0x3FFFF)
#define ZT_ILV_BASE0_DEFAULT   (0x0000)
#define ZT_ILV_BASE0_FMASK     (0x3FFFF)
#define ZT_ILV_SIZE0           FCI_GLBTX_REG(0x00A4)
#define ZT_ILV_SIZE0_WMASK     (0xFFFFFF)
#define ZT_ILV_SIZE0_MASK      (0xFFFFFF)
#define ZT_ILV_SIZE0_DEFAULT   (0x0000)
#define ZT_ILV_SIZE0_FMASK     (0xFFFFFF)
#define ZT_ILV_MAX_FULLNESS0   FCI_GLBTX_REG(0x00A8)
#define ZT_ILV_MAX_FULLNESS0_WMASK (0x3FFFF)
#define ZT_ILV_MAX_FULLNESS0_MASK (0x3FFFF)
#define ZT_ILV_MAX_FULLNESS0_DEFAULT (0x0000)
#define ZT_ILV_MAX_FULLNESS0_FMASK (0x3FFFF)
#define ZT_ILV_MIN_FULLNESS0   FCI_GLBTX_REG(0x00AC)
#define ZT_ILV_MIN_FULLNESS0_WMASK (0x3FFFF)
#define ZT_ILV_MIN_FULLNESS0_MASK (0x3FFFF)
#define ZT_ILV_MIN_FULLNESS0_DEFAULT (0x0000)
#define ZT_ILV_MIN_FULLNESS0_FMASK (0x3FFFF)
#define ZT_ILV_FULLNESS0       FCI_GLBTX_REG(0x00B0)
#define ZT_ILV_FULLNESS0_WMASK (0x3FFFF)
#define ZT_ILV_FULLNESS0_MASK  (0x3FFFF)
#define ZT_ILV_FULLNESS0_DEFAULT (0x0000)
#define ZT_ILV_FULLNESS0_FMASK (0x3FFFF)
#define ZT_ILV_CNTRS0          FCI_GLBTX_REG(0x00B4)
#define ZT_ILV_CNTRS0_WMASK    (0xFFFF0000)
#define ZT_ILV_CNTRS0_MASK     (0xFFFF0000)
#define ZT_ILV_CNTRS0_DEFAULT  (0x0000)
#define ZT_ILV_CNTRS0_FMASK    (0xFFFF0000)
#define ZT_ILV_PMS_CNTRS0      FCI_GLBTX_REG(0x00B8)
#define ZT_ILV_PMS_CNTRS0_WMASK (0xFFFFFFFF)
#define ZT_ILV_PMS_CNTRS0_MASK (0xFFFFFFFF)
#define ZT_ILV_PMS_CNTRS0_DEFAULT (0x0000)
#define ZT_ILV_PMS_CNTRS0_FMASK (0xFFFFFFFF)
#define ZT_ILV_PMD_CNTRS0      FCI_GLBTX_REG(0x00BC)
#define ZT_ILV_PMD_CNTRS0_WMASK (0xFFFFFFFF)
#define ZT_ILV_PMD_CNTRS0_MASK (0xFFFFFFFF)
#define ZT_ILV_PMD_CNTRS0_DEFAULT (0x0000)
#define ZT_ILV_PMD_CNTRS0_FMASK (0xFFFFFFFF)
#define ZT_ILV_PARAMS1         FCI_GLBTX_REG(0x00C0)
#define ZT_ILV_PARAMS1_WMASK   (0xFFFFFF07)
#define ZT_ILV_PARAMS1_MASK    (0xFFFFFF17)
#define ZT_ILV_PARAMS1_DEFAULT (0x0000)
#define ZT_ILV_PARAMS1_FMASK   (0xFFFFFF07)
#define ZT_ILV_BASE1           FCI_GLBTX_REG(0x00C4)
#define ZT_ILV_BASE1_WMASK     (0x3FFFF)
#define ZT_ILV_BASE1_MASK      (0x3FFFF)
#define ZT_ILV_BASE1_DEFAULT   (0x0000)
#define ZT_ILV_BASE1_FMASK     (0x3FFFF)
#define ZT_ILV_SIZE1           FCI_GLBTX_REG(0x00C8)
#define ZT_ILV_SIZE1_WMASK     (0xFFFFFF)
#define ZT_ILV_SIZE1_MASK      (0xFFFFFF)
#define ZT_ILV_SIZE1_DEFAULT   (0x0000)
#define ZT_ILV_SIZE1_FMASK     (0xFFFFFF)
#define ZT_ILV_MAX_FULLNESS1   FCI_GLBTX_REG(0x00CC)
#define ZT_ILV_MAX_FULLNESS1_WMASK (0x3FFFF)
#define ZT_ILV_MAX_FULLNESS1_MASK (0x3FFFF)
#define ZT_ILV_MAX_FULLNESS1_DEFAULT (0x0000)
#define ZT_ILV_MAX_FULLNESS1_FMASK (0x3FFFF)
#define ZT_ILV_MIN_FULLNESS1   FCI_GLBTX_REG(0x00D0)
#define ZT_ILV_MIN_FULLNESS1_WMASK (0x3FFFF)
#define ZT_ILV_MIN_FULLNESS1_MASK (0x3FFFF)
#define ZT_ILV_MIN_FULLNESS1_DEFAULT (0x0000)
#define ZT_ILV_MIN_FULLNESS1_FMASK (0x3FFFF)
#define ZT_ILV_FULLNESS1       FCI_GLBTX_REG(0x00D4)
#define ZT_ILV_FULLNESS1_WMASK (0x3FFFF)
#define ZT_ILV_FULLNESS1_MASK  (0x3FFFF)
#define ZT_ILV_FULLNESS1_DEFAULT (0x0000)
#define ZT_ILV_FULLNESS1_FMASK (0x3FFFF)
#define ZT_ILV_CNTRS1          FCI_GLBTX_REG(0x00D8)
#define ZT_ILV_CNTRS1_WMASK    (0xFFFF0000)
#define ZT_ILV_CNTRS1_MASK     (0xFFFF0000)
#define ZT_ILV_CNTRS1_DEFAULT  (0x0000)
#define ZT_ILV_CNTRS1_FMASK    (0xFFFF0000)
#define ZT_ILV_PMS_CNTRS1      FCI_GLBTX_REG(0x00DC)
#define ZT_ILV_PMS_CNTRS1_WMASK (0xFFFFFFFF)
#define ZT_ILV_PMS_CNTRS1_MASK (0xFFFFFFFF)
#define ZT_ILV_PMS_CNTRS1_DEFAULT (0x0000)
#define ZT_ILV_PMS_CNTRS1_FMASK (0xFFFFFFFF)
#define ZT_ILV_PMD_CNTRS1      FCI_GLBTX_REG(0x00E0)
#define ZT_ILV_PMD_CNTRS1_WMASK (0xFFFFFFFF)
#define ZT_ILV_PMD_CNTRS1_MASK (0xFFFFFFFF)
#define ZT_ILV_PMD_CNTRS1_DEFAULT (0x0000)
#define ZT_ILV_PMD_CNTRS1_FMASK (0xFFFFFFFF)
#define ZT_CHECKBYTE0          FCI_GLBTX_REG(0x00E4)
#define ZT_CHECKBYTE0_WMASK    (0xFFFFFFFF)
#define ZT_CHECKBYTE0_MASK     (0xFFFFFFFF)
#define ZT_CHECKBYTE0_DEFAULT  (0x0000)
#define ZT_CHECKBYTE0_FMASK    (0xFFFFFFFF)
#define ZT_CHECKBYTE1          FCI_GLBTX_REG(0x00E8)
#define ZT_CHECKBYTE1_WMASK    (0xFFFFFFFF)
#define ZT_CHECKBYTE1_MASK     (0xFFFFFFFF)
#define ZT_CHECKBYTE1_DEFAULT  (0x0000)
#define ZT_CHECKBYTE1_FMASK    (0xFFFFFFFF)
#define ZT_CHECKBYTE2          FCI_GLBTX_REG(0x00EC)
#define ZT_CHECKBYTE2_WMASK    (0xFFFFFFFF)
#define ZT_CHECKBYTE2_MASK     (0xFFFFFFFF)
#define ZT_CHECKBYTE2_DEFAULT  (0x0000)
#define ZT_CHECKBYTE2_FMASK    (0xFFFFFFFF)
#define ZT_CHECKBYTE3          FCI_GLBTX_REG(0x00F0)
#define ZT_CHECKBYTE3_WMASK    (0xFFFFFFFF)
#define ZT_CHECKBYTE3_MASK     (0xFFFFFFFF)
#define ZT_CHECKBYTE3_DEFAULT  (0x0000)
#define ZT_CHECKBYTE3_FMASK    (0xFFFFFFFF)
#define ZT_TCSRC_STATE         FCI_GLBTX_REG(0x00F4)
#define ZT_TCSRC_STATE_WMASK   (0xFFFFFF)
#define ZT_TCSRC_STATE_MASK    (0xFFFFFF)
#define ZT_TCSRC_STATE_DEFAULT (0x0000)
#define ZT_TCSRC_STATE_FMASK   (0xFFFFFF)
#define ZT_UPROC_ENA           FCI_GLBTX_REG(0x00F8)
#define ZT_UPROC_ENA_WMASK     (0x03FF)
#define ZT_UPROC_ENA_MASK      (0x03FF)
#define ZT_UPROC_ENA_DEFAULT   (0x0000)
#define ZT_UPROC_ENA_FMASK     (0x03FF)
#define ZT_UPROC01_BASE        FCI_GLBTX_REG(0x00FC)
#define ZT_UPROC01_BASE_WMASK  (0xFFFFFFFF)
#define ZT_UPROC01_BASE_MASK   (0xFFFFFFFF)
#define ZT_UPROC01_BASE_DEFAULT (0x0000)
#define ZT_UPROC01_BASE_FMASK  (0xFFFFFFFF)
#define ZT_UPROC23_BASE        FCI_GLBTX_REG(0x0100)
#define ZT_UPROC23_BASE_WMASK  (0xFFFFFFFF)
#define ZT_UPROC23_BASE_MASK   (0xFFFFFFFF)
#define ZT_UPROC23_BASE_DEFAULT (0x0000)
#define ZT_UPROC23_BASE_FMASK  (0xFFFFFFFF)
#define ZT_UPROC45_BASE        FCI_GLBTX_REG(0x0104)
#define ZT_UPROC45_BASE_WMASK  (0xFFFFFFFF)
#define ZT_UPROC45_BASE_MASK   (0xFFFFFFFF)
#define ZT_UPROC45_BASE_DEFAULT (0x0000)
#define ZT_UPROC45_BASE_FMASK  (0xFFFFFFFF)
#define ZT_UPROC67_BASE        FCI_GLBTX_REG(0x0108)
#define ZT_UPROC67_BASE_WMASK  (0xFFFFFFFF)
#define ZT_UPROC67_BASE_MASK   (0xFFFFFFFF)
#define ZT_UPROC67_BASE_DEFAULT (0x0000)
#define ZT_UPROC67_BASE_FMASK  (0xFFFFFFFF)
#define ZT_UPROC89_BASE        FCI_GLBTX_REG(0x010C)
#define ZT_UPROC89_BASE_WMASK  (0xFFFFFFFF)
#define ZT_UPROC89_BASE_MASK   (0xFFFFFFFF)
#define ZT_UPROC89_BASE_DEFAULT (0x0000)
#define ZT_UPROC89_BASE_FMASK  (0xFFFFFFFF)
#define ZT_UPROC_INT           FCI_GLBTX_REG(0x0110)
#define ZT_UPROC_INT_WMASK     (0x03FF)
#define ZT_UPROC_INT_MASK      (0x03FF)
#define ZT_UPROC_INT_DEFAULT   (0x0000)
#define ZT_UPROC_INT_FMASK     (0x03FF)
#define ZT_UPROC0_STATE0       FCI_GLBTX_REG(0x0114)
#define ZT_UPROC0_STATE0_WMASK (0xFFFFFF00)
#define ZT_UPROC0_STATE0_MASK  (0xFFFFFFFF)
#define ZT_UPROC0_STATE0_DEFAULT (0x0000)
#define ZT_UPROC0_STATE0_FMASK (0xFFFFFFFF)
#define ZT_UPROC0_STATE1       FCI_GLBTX_REG(0x0118)
#define ZT_UPROC0_STATE1_WMASK (0xFFFFFFFF)
#define ZT_UPROC0_STATE1_MASK  (0xFFFFFFFF)
#define ZT_UPROC0_STATE1_DEFAULT (0x0000)
#define ZT_UPROC0_STATE1_FMASK (0xFFFFFFFF)
#define ZT_UPROC0_STATE2       FCI_GLBTX_REG(0x011C)
#define ZT_UPROC0_STATE2_WMASK (0xFFFFFFFF)
#define ZT_UPROC0_STATE2_MASK  (0xFFFFFFFF)
#define ZT_UPROC0_STATE2_DEFAULT (0x0000)
#define ZT_UPROC0_STATE2_FMASK (0xFFFFFFFF)
#define ZT_UPROC0_STATE3       FCI_GLBTX_REG(0x0120)
#define ZT_UPROC0_STATE3_WMASK (0xFFFFFFFF)
#define ZT_UPROC0_STATE3_MASK  (0xFFFFFFFF)
#define ZT_UPROC0_STATE3_DEFAULT (0x0000)
#define ZT_UPROC0_STATE3_FMASK (0xFFFFFFFF)
#define ZT_UPROC0_STATE4       FCI_GLBTX_REG(0x0124)
#define ZT_UPROC0_STATE4_WMASK (0xFFFFFFFF)
#define ZT_UPROC0_STATE4_MASK  (0xFFFFFFFF)
#define ZT_UPROC0_STATE4_DEFAULT (0x0000)
#define ZT_UPROC0_STATE4_FMASK (0xFFFFFFFF)
#define ZT_UPROC1_STATE0       FCI_GLBTX_REG(0x0128)
#define ZT_UPROC1_STATE0_WMASK (0xFFFFFF00)
#define ZT_UPROC1_STATE0_MASK  (0xFFFFFFFF)
#define ZT_UPROC1_STATE0_DEFAULT (0x0000)
#define ZT_UPROC1_STATE0_FMASK (0xFFFFFFFF)
#define ZT_UPROC1_STATE1       FCI_GLBTX_REG(0x012C)
#define ZT_UPROC1_STATE1_WMASK (0xFFFFFFFF)
#define ZT_UPROC1_STATE1_MASK  (0xFFFFFFFF)
#define ZT_UPROC1_STATE1_DEFAULT (0x0000)
#define ZT_UPROC1_STATE1_FMASK (0xFFFFFFFF)
#define ZT_UPROC1_STATE2       FCI_GLBTX_REG(0x0130)
#define ZT_UPROC1_STATE2_WMASK (0xFFFFFFFF)
#define ZT_UPROC1_STATE2_MASK  (0xFFFFFFFF)
#define ZT_UPROC1_STATE2_DEFAULT (0x0000)
#define ZT_UPROC1_STATE2_FMASK (0xFFFFFFFF)
#define ZT_UPROC1_STATE3       FCI_GLBTX_REG(0x0134)
#define ZT_UPROC1_STATE3_WMASK (0xFFFFFFFF)
#define ZT_UPROC1_STATE3_MASK  (0xFFFFFFFF)
#define ZT_UPROC1_STATE3_DEFAULT (0x0000)
#define ZT_UPROC1_STATE3_FMASK (0xFFFFFFFF)
#define ZT_UPROC1_STATE4       FCI_GLBTX_REG(0x0138)
#define ZT_UPROC1_STATE4_WMASK (0xFFFFFFFF)
#define ZT_UPROC1_STATE4_MASK  (0xFFFFFFFF)
#define ZT_UPROC1_STATE4_DEFAULT (0x0000)
#define ZT_UPROC1_STATE4_FMASK (0xFFFFFFFF)
#define ZT_UPROC2_STATE0       FCI_GLBTX_REG(0x013C)
#define ZT_UPROC2_STATE0_WMASK (0xFFFFFF00)
#define ZT_UPROC2_STATE0_MASK  (0xFFFFFFFF)
#define ZT_UPROC2_STATE0_DEFAULT (0x0000)
#define ZT_UPROC2_STATE0_FMASK (0xFFFFFFFF)
#define ZT_UPROC2_STATE1       FCI_GLBTX_REG(0x0140)
#define ZT_UPROC2_STATE1_WMASK (0xFFFFFFFF)
#define ZT_UPROC2_STATE1_MASK  (0xFFFFFFFF)
#define ZT_UPROC2_STATE1_DEFAULT (0x0000)
#define ZT_UPROC2_STATE1_FMASK (0xFFFFFFFF)
#define ZT_UPROC2_STATE2       FCI_GLBTX_REG(0x0144)
#define ZT_UPROC2_STATE2_WMASK (0xFFFFFFFF)
#define ZT_UPROC2_STATE2_MASK  (0xFFFFFFFF)
#define ZT_UPROC2_STATE2_DEFAULT (0x0000)
#define ZT_UPROC2_STATE2_FMASK (0xFFFFFFFF)
#define ZT_UPROC2_STATE3       FCI_GLBTX_REG(0x0148)
#define ZT_UPROC2_STATE3_WMASK (0xFFFFFFFF)
#define ZT_UPROC2_STATE3_MASK  (0xFFFFFFFF)
#define ZT_UPROC2_STATE3_DEFAULT (0x0000)
#define ZT_UPROC2_STATE3_FMASK (0xFFFFFFFF)
#define ZT_UPROC2_STATE4       FCI_GLBTX_REG(0x014C)
#define ZT_UPROC2_STATE4_WMASK (0xFFFFFFFF)
#define ZT_UPROC2_STATE4_MASK  (0xFFFFFFFF)
#define ZT_UPROC2_STATE4_DEFAULT (0x0000)
#define ZT_UPROC2_STATE4_FMASK (0xFFFFFFFF)
#define ZT_UPROC3_STATE0       FCI_GLBTX_REG(0x0150)
#define ZT_UPROC3_STATE0_WMASK (0xFFFFFF00)
#define ZT_UPROC3_STATE0_MASK  (0xFFFFFFFF)
#define ZT_UPROC3_STATE0_DEFAULT (0x0000)
#define ZT_UPROC3_STATE0_FMASK (0xFFFFFFFF)
#define ZT_UPROC3_STATE1       FCI_GLBTX_REG(0x0154)
#define ZT_UPROC3_STATE1_WMASK (0xFFFFFFFF)
#define ZT_UPROC3_STATE1_MASK  (0xFFFFFFFF)
#define ZT_UPROC3_STATE1_DEFAULT (0x0000)
#define ZT_UPROC3_STATE1_FMASK (0xFFFFFFFF)
#define ZT_UPROC3_STATE2       FCI_GLBTX_REG(0x0158)
#define ZT_UPROC3_STATE2_WMASK (0xFFFFFFFF)
#define ZT_UPROC3_STATE2_MASK  (0xFFFFFFFF)
#define ZT_UPROC3_STATE2_DEFAULT (0x0000)
#define ZT_UPROC3_STATE2_FMASK (0xFFFFFFFF)
#define ZT_UPROC3_STATE3       FCI_GLBTX_REG(0x015C)
#define ZT_UPROC3_STATE3_WMASK (0xFFFFFFFF)
#define ZT_UPROC3_STATE3_MASK  (0xFFFFFFFF)
#define ZT_UPROC3_STATE3_DEFAULT (0x0000)
#define ZT_UPROC3_STATE3_FMASK (0xFFFFFFFF)
#define ZT_UPROC3_STATE4       FCI_GLBTX_REG(0x0160)
#define ZT_UPROC3_STATE4_WMASK (0xFFFFFFFF)
#define ZT_UPROC3_STATE4_MASK  (0xFFFFFFFF)
#define ZT_UPROC3_STATE4_DEFAULT (0x0000)
#define ZT_UPROC3_STATE4_FMASK (0xFFFFFFFF)
#define ZT_UPROC4_STATE0       FCI_GLBTX_REG(0x0164)
#define ZT_UPROC4_STATE0_WMASK (0xFFFFFF00)
#define ZT_UPROC4_STATE0_MASK  (0xFFFFFFFF)
#define ZT_UPROC4_STATE0_DEFAULT (0x0000)
#define ZT_UPROC4_STATE0_FMASK (0xFFFFFFFF)
#define ZT_UPROC4_STATE1       FCI_GLBTX_REG(0x0168)
#define ZT_UPROC4_STATE1_WMASK (0xFFFFFFFF)
#define ZT_UPROC4_STATE1_MASK  (0xFFFFFFFF)
#define ZT_UPROC4_STATE1_DEFAULT (0x0000)
#define ZT_UPROC4_STATE1_FMASK (0xFFFFFFFF)
#define ZT_UPROC4_STATE2       FCI_GLBTX_REG(0x016C)
#define ZT_UPROC4_STATE2_WMASK (0xFFFFFFFF)
#define ZT_UPROC4_STATE2_MASK  (0xFFFFFFFF)
#define ZT_UPROC4_STATE2_DEFAULT (0x0000)
#define ZT_UPROC4_STATE2_FMASK (0xFFFFFFFF)
#define ZT_UPROC4_STATE3       FCI_GLBTX_REG(0x0170)
#define ZT_UPROC4_STATE3_WMASK (0xFFFFFFFF)
#define ZT_UPROC4_STATE3_MASK  (0xFFFFFFFF)
#define ZT_UPROC4_STATE3_DEFAULT (0x0000)
#define ZT_UPROC4_STATE3_FMASK (0xFFFFFFFF)
#define ZT_UPROC4_STATE4       FCI_GLBTX_REG(0x0174)
#define ZT_UPROC4_STATE4_WMASK (0xFFFFFFFF)
#define ZT_UPROC4_STATE4_MASK  (0xFFFFFFFF)
#define ZT_UPROC4_STATE4_DEFAULT (0x0000)
#define ZT_UPROC4_STATE4_FMASK (0xFFFFFFFF)
#define ZT_UPROC5_STATE0       FCI_GLBTX_REG(0x0178)
#define ZT_UPROC5_STATE0_WMASK (0xFFFFFF00)
#define ZT_UPROC5_STATE0_MASK  (0xFFFFFFFF)
#define ZT_UPROC5_STATE0_DEFAULT (0x0000)
#define ZT_UPROC5_STATE0_FMASK (0xFFFFFFFF)
#define ZT_UPROC5_STATE1       FCI_GLBTX_REG(0x017C)
#define ZT_UPROC5_STATE1_WMASK (0xFFFFFFFF)
#define ZT_UPROC5_STATE1_MASK  (0xFFFFFFFF)
#define ZT_UPROC5_STATE1_DEFAULT (0x0000)
#define ZT_UPROC5_STATE1_FMASK (0xFFFFFFFF)
#define ZT_UPROC5_STATE2       FCI_GLBTX_REG(0x0180)
#define ZT_UPROC5_STATE2_WMASK (0xFFFFFFFF)
#define ZT_UPROC5_STATE2_MASK  (0xFFFFFFFF)
#define ZT_UPROC5_STATE2_DEFAULT (0x0000)
#define ZT_UPROC5_STATE2_FMASK (0xFFFFFFFF)
#define ZT_UPROC5_STATE3       FCI_GLBTX_REG(0x0184)
#define ZT_UPROC5_STATE3_WMASK (0xFFFFFFFF)
#define ZT_UPROC5_STATE3_MASK  (0xFFFFFFFF)
#define ZT_UPROC5_STATE3_DEFAULT (0x0000)
#define ZT_UPROC5_STATE3_FMASK (0xFFFFFFFF)
#define ZT_UPROC5_STATE4       FCI_GLBTX_REG(0x0188)
#define ZT_UPROC5_STATE4_WMASK (0xFFFFFFFF)
#define ZT_UPROC5_STATE4_MASK  (0xFFFFFFFF)
#define ZT_UPROC5_STATE4_DEFAULT (0x0000)
#define ZT_UPROC5_STATE4_FMASK (0xFFFFFFFF)
#define ZT_UPROC6_STATE0       FCI_GLBTX_REG(0x018C)
#define ZT_UPROC6_STATE0_WMASK (0xFFFFFF00)
#define ZT_UPROC6_STATE0_MASK  (0xFFFFFFFF)
#define ZT_UPROC6_STATE0_DEFAULT (0x0000)
#define ZT_UPROC6_STATE0_FMASK (0xFFFFFFFF)
#define ZT_UPROC6_STATE1       FCI_GLBTX_REG(0x0190)
#define ZT_UPROC6_STATE1_WMASK (0xFFFFFFFF)
#define ZT_UPROC6_STATE1_MASK  (0xFFFFFFFF)
#define ZT_UPROC6_STATE1_DEFAULT (0x0000)
#define ZT_UPROC6_STATE1_FMASK (0xFFFFFFFF)
#define ZT_UPROC6_STATE2       FCI_GLBTX_REG(0x0194)
#define ZT_UPROC6_STATE2_WMASK (0xFFFFFFFF)
#define ZT_UPROC6_STATE2_MASK  (0xFFFFFFFF)
#define ZT_UPROC6_STATE2_DEFAULT (0x0000)
#define ZT_UPROC6_STATE2_FMASK (0xFFFFFFFF)
#define ZT_UPROC6_STATE3       FCI_GLBTX_REG(0x0198)
#define ZT_UPROC6_STATE3_WMASK (0xFFFFFFFF)
#define ZT_UPROC6_STATE3_MASK  (0xFFFFFFFF)
#define ZT_UPROC6_STATE3_DEFAULT (0x0000)
#define ZT_UPROC6_STATE3_FMASK (0xFFFFFFFF)
#define ZT_UPROC6_STATE4       FCI_GLBTX_REG(0x019C)
#define ZT_UPROC6_STATE4_WMASK (0xFFFFFFFF)
#define ZT_UPROC6_STATE4_MASK  (0xFFFFFFFF)
#define ZT_UPROC6_STATE4_DEFAULT (0x0000)
#define ZT_UPROC6_STATE4_FMASK (0xFFFFFFFF)
#define ZT_UPROC7_STATE0       FCI_GLBTX_REG(0x01A0)
#define ZT_UPROC7_STATE0_WMASK (0xFFFFFF00)
#define ZT_UPROC7_STATE0_MASK  (0xFFFFFFFF)
#define ZT_UPROC7_STATE0_DEFAULT (0x0000)
#define ZT_UPROC7_STATE0_FMASK (0xFFFFFFFF)
#define ZT_UPROC7_STATE1       FCI_GLBTX_REG(0x01A4)
#define ZT_UPROC7_STATE1_WMASK (0xFFFFFFFF)
#define ZT_UPROC7_STATE1_MASK  (0xFFFFFFFF)
#define ZT_UPROC7_STATE1_DEFAULT (0x0000)
#define ZT_UPROC7_STATE1_FMASK (0xFFFFFFFF)
#define ZT_UPROC7_STATE2       FCI_GLBTX_REG(0x01A8)
#define ZT_UPROC7_STATE2_WMASK (0xFFFFFFFF)
#define ZT_UPROC7_STATE2_MASK  (0xFFFFFFFF)
#define ZT_UPROC7_STATE2_DEFAULT (0x0000)
#define ZT_UPROC7_STATE2_FMASK (0xFFFFFFFF)
#define ZT_UPROC7_STATE3       FCI_GLBTX_REG(0x01AC)
#define ZT_UPROC7_STATE3_WMASK (0xFFFFFFFF)
#define ZT_UPROC7_STATE3_MASK  (0xFFFFFFFF)
#define ZT_UPROC7_STATE3_DEFAULT (0x0000)
#define ZT_UPROC7_STATE3_FMASK (0xFFFFFFFF)
#define ZT_UPROC7_STATE4       FCI_GLBTX_REG(0x01B0)
#define ZT_UPROC7_STATE4_WMASK (0xFFFFFFFF)
#define ZT_UPROC7_STATE4_MASK  (0xFFFFFFFF)
#define ZT_UPROC7_STATE4_DEFAULT (0x0000)
#define ZT_UPROC7_STATE4_FMASK (0xFFFFFFFF)
#define ZT_UPROC8_STATE0       FCI_GLBTX_REG(0x01B4)
#define ZT_UPROC8_STATE0_WMASK (0xFFFFFF00)
#define ZT_UPROC8_STATE0_MASK  (0xFFFFFFFF)
#define ZT_UPROC8_STATE0_DEFAULT (0x0000)
#define ZT_UPROC8_STATE0_FMASK (0xFFFFFFFF)
#define ZT_UPROC8_STATE1       FCI_GLBTX_REG(0x01B8)
#define ZT_UPROC8_STATE1_WMASK (0xFFFFFFFF)
#define ZT_UPROC8_STATE1_MASK  (0xFFFFFFFF)
#define ZT_UPROC8_STATE1_DEFAULT (0x0000)
#define ZT_UPROC8_STATE1_FMASK (0xFFFFFFFF)
#define ZT_UPROC8_STATE2       FCI_GLBTX_REG(0x01BC)
#define ZT_UPROC8_STATE2_WMASK (0xFFFFFFFF)
#define ZT_UPROC8_STATE2_MASK  (0xFFFFFFFF)
#define ZT_UPROC8_STATE2_DEFAULT (0x0000)
#define ZT_UPROC8_STATE2_FMASK (0xFFFFFFFF)
#define ZT_UPROC8_STATE3       FCI_GLBTX_REG(0x01C0)
#define ZT_UPROC8_STATE3_WMASK (0xFFFFFFFF)
#define ZT_UPROC8_STATE3_MASK  (0xFFFFFFFF)
#define ZT_UPROC8_STATE3_DEFAULT (0x0000)
#define ZT_UPROC8_STATE3_FMASK (0xFFFFFFFF)
#define ZT_UPROC8_STATE4       FCI_GLBTX_REG(0x01C4)
#define ZT_UPROC8_STATE4_WMASK (0xFFFFFFFF)
#define ZT_UPROC8_STATE4_MASK  (0xFFFFFFFF)
#define ZT_UPROC8_STATE4_DEFAULT (0x0000)
#define ZT_UPROC8_STATE4_FMASK (0xFFFFFFFF)
#define ZT_UPROC9_STATE0       FCI_GLBTX_REG(0x01C8)
#define ZT_UPROC9_STATE0_WMASK (0xFFFFFF00)
#define ZT_UPROC9_STATE0_MASK  (0xFFFFFFFF)
#define ZT_UPROC9_STATE0_DEFAULT (0x0000)
#define ZT_UPROC9_STATE0_FMASK (0xFFFFFFFF)
#define ZT_UPROC9_STATE1       FCI_GLBTX_REG(0x01CC)
#define ZT_UPROC9_STATE1_WMASK (0xFFFFFFFF)
#define ZT_UPROC9_STATE1_MASK  (0xFFFFFFFF)
#define ZT_UPROC9_STATE1_DEFAULT (0x0000)
#define ZT_UPROC9_STATE1_FMASK (0xFFFFFFFF)
#define ZT_UPROC9_STATE2       FCI_GLBTX_REG(0x01D0)
#define ZT_UPROC9_STATE2_WMASK (0xFFFFFFFF)
#define ZT_UPROC9_STATE2_MASK  (0xFFFFFFFF)
#define ZT_UPROC9_STATE2_DEFAULT (0x0000)
#define ZT_UPROC9_STATE2_FMASK (0xFFFFFFFF)
#define ZT_UPROC9_STATE3       FCI_GLBTX_REG(0x01D4)
#define ZT_UPROC9_STATE3_WMASK (0xFFFFFFFF)
#define ZT_UPROC9_STATE3_MASK  (0xFFFFFFFF)
#define ZT_UPROC9_STATE3_DEFAULT (0x0000)
#define ZT_UPROC9_STATE3_FMASK (0xFFFFFFFF)
#define ZT_UPROC9_STATE4       FCI_GLBTX_REG(0x01D8)
#define ZT_UPROC9_STATE4_WMASK (0xFFFFFFFF)
#define ZT_UPROC9_STATE4_MASK  (0xFFFFFFFF)
#define ZT_UPROC9_STATE4_DEFAULT (0x0000)
#define ZT_UPROC9_STATE4_FMASK (0xFFFFFFFF)
#define ZT_UPROC_STATE5        FCI_GLBTX_REG(0x01DC)
#define ZT_UPROC_STATE5_WMASK  (0xFFFFF)
#define ZT_UPROC_STATE5_MASK   (0xFFFFF)
#define ZT_UPROC_STATE5_DEFAULT (0x0000)
#define ZT_UPROC_STATE5_FMASK  (0xFFFFF)
#define ZT_ALU_STATE           FCI_GLBTX_REG(0x01E0)
#define ZT_ALU_STATE_WMASK     (0x3FFFFFFF)
#define ZT_ALU_STATE_MASK      (0x3FFFFFFF)
#define ZT_ALU_STATE_DEFAULT   (0x0000)
#define ZT_ALU_STATE_FMASK     (0x3FFFFFFF)
#define ZT_ALU_CLI_REQ         FCI_GLBTX_REG(0x01E4)
#define ZT_ALU_CLI_REQ_WMASK   (0x03FF)
#define ZT_ALU_CLI_REQ_MASK    (0x03FF)
#define ZT_ALU_CLI_REQ_DEFAULT (0x0000)
#define ZT_ALU_CLI_REQ_FMASK   (0x03FF)
#define Z_VERSION              FCI_GLBTX_REG(0x01E8)
#define Z_VERSION_WMASK        (0x0000)
#define Z_VERSION_MASK         (0x00FF)
#define Z_VERSION_DEFAULT      (0x0050)
#define Z_VERSION_FMASK        (0x00FF)
#define Z_MBOX_ACCESS          FCI_GLBTX_REG(0x01EC)
#define Z_MBOX_ACCESS_WMASK    (0x0001)
#define Z_MBOX_ACCESS_MASK     (0x0001)
#define Z_MBOX_ACCESS_DEFAULT  (0x0000)
#define Z_MBOX_ACCESS_FMASK    (0x0001)
#define ZT_FIFO_ACCESS         FCI_GLBTX_REG(0x01F0)
#define ZT_FIFO_ACCESS_WMASK   (0xBFFFF7FF)
#define ZT_FIFO_ACCESS_MASK    (0xBFFFFFFF)
#define ZT_FIFO_ACCESS_DEFAULT (0x0800)
#define ZT_FIFO_ACCESS_FMASK   (0xBFFFFFFF)
#define ZT_CONFIG              FCI_GLBTX_REG(0x01F4)
#define ZT_CONFIG_WMASK        (0xFFFF)
#define ZT_CONFIG_MASK         (0xFFFF)
#define ZT_CONFIG_DEFAULT      (0x0000)
#define ZT_CONFIG_FMASK        (0xFFFF)
#define ZT_PMS_SIZE            FCI_GLBTX_REG(0x01F8)
#define ZT_PMS_SIZE_WMASK      (0xFFFFFFFF)
#define ZT_PMS_SIZE_MASK       (0xFFFFFFFF)
#define ZT_PMS_SIZE_DEFAULT    (0x0000)
#define ZT_PMS_SIZE_FMASK      (0xFFFFFFFF)
#define ZT_DT_SIZE             FCI_GLBTX_REG(0x01FC)
#define ZT_DT_SIZE_WMASK       (0xFFFFFFFF)
#define ZT_DT_SIZE_MASK        (0xFFFFFFFF)
#define ZT_DT_SIZE_DEFAULT     (0x0000)
#define ZT_DT_SIZE_FMASK       (0xFFFFFFFF)
#define ZT_QTDTB_CONFIG_LP0    FCI_GLBTX_REG(0x0200)
#define ZT_QTDTB_CONFIG_LP0_WMASK (0xCFFF0FFF)
#define ZT_QTDTB_CONFIG_LP0_MASK (0xCFFF0FFF)
#define ZT_QTDTB_CONFIG_LP0_DEFAULT (0x0000)
#define ZT_QTDTB_CONFIG_LP0_FMASK (0xCFFF0FFF)
#define ZT_QTDTB_CONFIG_LP1    FCI_GLBTX_REG(0x0204)
#define ZT_QTDTB_CONFIG_LP1_WMASK (0xCFFF0FFF)
#define ZT_QTDTB_CONFIG_LP1_MASK (0xCFFF0FFF)
#define ZT_QTDTB_CONFIG_LP1_DEFAULT (0x0000)
#define ZT_QTDTB_CONFIG_LP1_FMASK (0xCFFF0FFF)
#define ZT_QTDTB_CONFIG_LP2    FCI_GLBTX_REG(0x0208)
#define ZT_QTDTB_CONFIG_LP2_WMASK (0xFFF0FFF)
#define ZT_QTDTB_CONFIG_LP2_MASK (0xFFF0FFF)
#define ZT_QTDTB_CONFIG_LP2_DEFAULT (0x0000)
#define ZT_QTDTB_CONFIG_LP2_FMASK (0xFFF0FFF)
#define ZT_QTDTB_ADDR_LP01     FCI_GLBTX_REG(0x020C)
#define ZT_QTDTB_ADDR_LP01_WMASK (0xFFF0FFF)
#define ZT_QTDTB_ADDR_LP01_MASK (0xFFF0FFF)
#define ZT_QTDTB_ADDR_LP01_DEFAULT (0x0000)
#define ZT_QTDTB_ADDR_LP01_FMASK (0xFFF0FFF)
#define ZT_QTDTB_ADDR_LP2      FCI_GLBTX_REG(0x0210)
#define ZT_QTDTB_ADDR_LP2_WMASK (0x0FFF)
#define ZT_QTDTB_ADDR_LP2_MASK (0x0FFF)
#define ZT_QTDTB_ADDR_LP2_DEFAULT (0x0000)
#define ZT_QTDTB_ADDR_LP2_FMASK (0x0FFF)
#define ZT_DTB_OFFSET          FCI_GLBTX_REG(0x0214)
#define ZT_DTB_OFFSET_WMASK    (0x0FFF)
#define ZT_DTB_OFFSET_MASK     (0x0FFF)
#define ZT_DTB_OFFSET_DEFAULT  (0x0000)
#define ZT_DTB_OFFSET_FMASK    (0x0FFF)
#define ZT_STAT_CTRL           FCI_GLBTX_REG(0x0218)
#define ZT_STAT_CTRL_WMASK     (0x0101)
#define ZT_STAT_CTRL_MASK      (0x0101)
#define ZT_STAT_CTRL_DEFAULT   (0x0000)
#define ZT_STAT_CTRL_FMASK     (0x0100)
#define ZT_ALU_CLI_REQ_ALIAS0  FCI_GLBTX_REG(0x021C)
#define ZT_ALU_CLI_REQ_ALIAS0_WMASK (0x0000)
#define ZT_ALU_CLI_REQ_ALIAS0_MASK (0x1010101)
#define ZT_ALU_CLI_REQ_ALIAS0_DEFAULT (0x0000)
#define ZT_ALU_CLI_REQ_ALIAS0_FMASK (0x0000)
#define ZT_ALU_CLI_REQ_ALIAS1  FCI_GLBTX_REG(0x0220)
#define ZT_ALU_CLI_REQ_ALIAS1_WMASK (0x0000)
#define ZT_ALU_CLI_REQ_ALIAS1_MASK (0x1010101)
#define ZT_ALU_CLI_REQ_ALIAS1_DEFAULT (0x0000)
#define ZT_ALU_CLI_REQ_ALIAS1_FMASK (0x0000)
#define ZT_ALU_CLI_REQ_ALIAS2  FCI_GLBTX_REG(0x0224)
#define ZT_ALU_CLI_REQ_ALIAS2_WMASK (0x0000)
#define ZT_ALU_CLI_REQ_ALIAS2_MASK (0x0101)
#define ZT_ALU_CLI_REQ_ALIAS2_DEFAULT (0x0000)
#define ZT_ALU_CLI_REQ_ALIAS2_FMASK (0x0000)
#define Z_PRAM_STATUS          FCI_GLBTX_REG(0x0228)
#define Z_PRAM_STATUS_WMASK    (0x0000)
#define Z_PRAM_STATUS_MASK     (0x0003)
#define Z_PRAM_STATUS_DEFAULT  (0x0000)
#define Z_PRAM_STATUS_FMASK    (0x0003)

/* Fci Glbrx Address Constants */ 
#define fci_glbrx_reg_base     (0x20DC00)
#define FCI_GLBRX_REG(r)       (int)(fci_glbrx_reg_base + (r))
#define fci_glbrx_reg_size     (0x0001)

#define ZR_R0                  FCI_GLBRX_REG(0x0000)
#define ZR_R0_WMASK            (0xFFFFFFFF)
#define ZR_R0_MASK             (0xFFFFFFFF)
#define ZR_R0_DEFAULT          (0x0000)
#define ZR_R0_FMASK            (0xFFFFFFFF)
#define ZR_R4                  FCI_GLBRX_REG(0x0004)
#define ZR_R4_WMASK            (0xFFFFFFFF)
#define ZR_R4_MASK             (0xFFFFFFFF)
#define ZR_R4_DEFAULT          (0x0000)
#define ZR_R4_FMASK            (0xFFFFFFFF)
#define ZR_R8                  FCI_GLBRX_REG(0x0008)
#define ZR_R8_WMASK            (0xFFFFFFFF)
#define ZR_R8_MASK             (0xFFFFFFFF)
#define ZR_R8_DEFAULT          (0x0000)
#define ZR_R8_FMASK            (0xFFFFFFFF)
#define ZR_R12                 FCI_GLBRX_REG(0x000C)
#define ZR_R12_WMASK           (0xFFFFFFFF)
#define ZR_R12_MASK            (0xFFFFFFFF)
#define ZR_R12_DEFAULT         (0x0000)
#define ZR_R12_FMASK           (0xFFFFFFFF)
#define ZR_CODEWORD            FCI_GLBRX_REG(0x0010)
#define ZR_CODEWORD_WMASK      (0xFFFFFFFF)
#define ZR_CODEWORD_MASK       (0xFFFFFFFF)
#define ZR_CODEWORD_DEFAULT    (0x0000)
#define ZR_CODEWORD_FMASK      (0xFFFFFFFF)
#define ZR_VBC_SIZE            FCI_GLBRX_REG(0x0014)
#define ZR_VBC_SIZE_WMASK      (0xFFFFFFFF)
#define ZR_VBC_SIZE_MASK       (0xFFFFFFFF)
#define ZR_VBC_SIZE_DEFAULT    (0x0000)
#define ZR_VBC_SIZE_FMASK      (0xFFFFFFFF)
#define ZR_FRAMING             FCI_GLBRX_REG(0x0018)
#define ZR_FRAMING_WMASK       (0xFFFFFFFF)
#define ZR_FRAMING_MASK        (0xFFFFFFFF)
#define ZR_FRAMING_DEFAULT     (0x0000)
#define ZR_FRAMING_FMASK       (0xFFFFFFFF)
#define ZR_OHRATE              FCI_GLBRX_REG(0x001C)
#define ZR_OHRATE_WMASK        (0xFFFFFFFF)
#define ZR_OHRATE_MASK         (0xFFFFFFFF)
#define ZR_OHRATE_DEFAULT      (0x0000)
#define ZR_OHRATE_FMASK        (0xFFFFFFFF)
#define ZR_FLAG_CTRL0          FCI_GLBRX_REG(0x0020)
#define ZR_FLAG_CTRL0_WMASK    (0x77777777)
#define ZR_FLAG_CTRL0_MASK     (0x77777777)
#define ZR_FLAG_CTRL0_DEFAULT  (0x0000)
#define ZR_FLAG_CTRL0_FMASK    (0x77777777)
#define ZR_FLAG_CTRL1          FCI_GLBRX_REG(0x0024)
#define ZR_FLAG_CTRL1_WMASK    (0x7777777)
#define ZR_FLAG_CTRL1_MASK     (0x7777777)
#define ZR_FLAG_CTRL1_DEFAULT  (0x0000)
#define ZR_FLAG_CTRL1_FMASK    (0x7777777)
#define ZR_CRC0                FCI_GLBRX_REG(0x0028)
#define ZR_CRC0_WMASK          (0xFFFFFFFF)
#define ZR_CRC0_MASK           (0xFFFFFFFF)
#define ZR_CRC0_DEFAULT        (0x0000)
#define ZR_CRC0_FMASK          (0xFFFFFFFF)
#define ZR_CRC_POLY0           FCI_GLBRX_REG(0x002C)
#define ZR_CRC_POLY0_WMASK     (0xFFFFFFFF)
#define ZR_CRC_POLY0_MASK      (0xFFFFFFFF)
#define ZR_CRC_POLY0_DEFAULT   (0x0000)
#define ZR_CRC_POLY0_FMASK     (0xFFFFFFFF)
#define ZR_CRC_CTRL0           FCI_GLBRX_REG(0x0030)
#define ZR_CRC_CTRL0_WMASK     (0xFFFF0103)
#define ZR_CRC_CTRL0_MASK      (0xFFFF0103)
#define ZR_CRC_CTRL0_DEFAULT   (0x0000)
#define ZR_CRC_CTRL0_FMASK     (0xFFFF0103)
#define ZR_CRC1                FCI_GLBRX_REG(0x0034)
#define ZR_CRC1_WMASK          (0xFFFFFFFF)
#define ZR_CRC1_MASK           (0xFFFFFFFF)
#define ZR_CRC1_DEFAULT        (0x0000)
#define ZR_CRC1_FMASK          (0xFFFFFFFF)
#define ZR_CRC_POLY1           FCI_GLBRX_REG(0x0038)
#define ZR_CRC_POLY1_WMASK     (0xFFFFFFFF)
#define ZR_CRC_POLY1_MASK      (0xFFFFFFFF)
#define ZR_CRC_POLY1_DEFAULT   (0x0000)
#define ZR_CRC_POLY1_FMASK     (0xFFFFFFFF)
#define ZR_CRC_CTRL1           FCI_GLBRX_REG(0x003C)
#define ZR_CRC_CTRL1_WMASK     (0xFFFF0103)
#define ZR_CRC_CTRL1_MASK      (0xFFFF0103)
#define ZR_CRC_CTRL1_DEFAULT   (0x0000)
#define ZR_CRC_CTRL1_FMASK     (0xFFFF0103)
#define ZR_SCR                 FCI_GLBRX_REG(0x0040)
#define ZR_SCR_WMASK           (0xFFFFFFFF)
#define ZR_SCR_MASK            (0xFFFFFFFF)
#define ZR_SCR_DEFAULT         (0x0000)
#define ZR_SCR_FMASK           (0xFFFFFFFF)
#define ZR_SCR_POLY            FCI_GLBRX_REG(0x0044)
#define ZR_SCR_POLY_WMASK      (0xFFFFFFFF)
#define ZR_SCR_POLY_MASK       (0xFFFFFFFF)
#define ZR_SCR_POLY_DEFAULT    (0x0000)
#define ZR_SCR_POLY_FMASK      (0xFFFFFFFF)
#define ZR_SCR_CTRL            FCI_GLBRX_REG(0x0048)
#define ZR_SCR_CTRL_WMASK      (0x001F)
#define ZR_SCR_CTRL_MASK       (0x001F)
#define ZR_SCR_CTRL_DEFAULT    (0x0000)
#define ZR_SCR_CTRL_FMASK      (0x001F)
#define ZR_SCR_STATE           FCI_GLBRX_REG(0x004C)
#define ZR_SCR_STATE_WMASK     (0x3FFFFFF)
#define ZR_SCR_STATE_MASK      (0x3FFFFFF)
#define ZR_SCR_STATE_DEFAULT   (0x0000)
#define ZR_SCR_STATE_FMASK     (0x3FFFFFF)
#define ZR_DTB_CTRL            FCI_GLBRX_REG(0x0050)
#define ZR_DTB_CTRL_WMASK      (0x1FFF0FFF)
#define ZR_DTB_CTRL_MASK       (0x1FFF0FFF)
#define ZR_DTB_CTRL_DEFAULT    (0x0000)
#define ZR_DTB_CTRL_FMASK      (0x1FFF0FFF)
#define ZR_DTB_PTRS            FCI_GLBRX_REG(0x0054)
#define ZR_DTB_PTRS_WMASK      (0xFFFFFFFF)
#define ZR_DTB_PTRS_MASK       (0xFFFFFFFF)
#define ZR_DTB_PTRS_DEFAULT    (0x0000)
#define ZR_DTB_PTRS_FMASK      (0xFFFFFFFF)
#define ZR_ILVB_WRAD           FCI_GLBRX_REG(0x0058)
#define ZR_ILVB_WRAD_WMASK     (0xFFFFFFFF)
#define ZR_ILVB_WRAD_MASK      (0xFFFFFFFF)
#define ZR_ILVB_WRAD_DEFAULT   (0x0000)
#define ZR_ILVB_WRAD_FMASK     (0xFFFFFFFF)
#define ZR_ILVB_RDAD           FCI_GLBRX_REG(0x005C)
#define ZR_ILVB_RDAD_WMASK     (0xFFFFFFFF)
#define ZR_ILVB_RDAD_MASK      (0xFFFFFFFF)
#define ZR_ILVB_RDAD_DEFAULT   (0x0000)
#define ZR_ILVB_RDAD_FMASK     (0xFFFFFFFF)
#define ZR_ILVB_WRPTR          FCI_GLBRX_REG(0x0060)
#define ZR_ILVB_WRPTR_WMASK    (0xFFFFFFFF)
#define ZR_ILVB_WRPTR_MASK     (0xFFFFFFFF)
#define ZR_ILVB_WRPTR_DEFAULT  (0x0000)
#define ZR_ILVB_WRPTR_FMASK    (0xFFFFFFFF)
#define ZR_ILVB_RDPTR          FCI_GLBRX_REG(0x0064)
#define ZR_ILVB_RDPTR_WMASK    (0xFFFFFFFF)
#define ZR_ILVB_RDPTR_MASK     (0xFFFFFFFF)
#define ZR_ILVB_RDPTR_DEFAULT  (0x0000)
#define ZR_ILVB_RDPTR_FMASK    (0xFFFFFFFF)
#define ZR_FIFO_BASE0          FCI_GLBRX_REG(0x0068)
#define ZR_FIFO_BASE0_WMASK    (0x3FFFFFF)
#define ZR_FIFO_BASE0_MASK     (0x3FFFFFF)
#define ZR_FIFO_BASE0_DEFAULT  (0x0000)
#define ZR_FIFO_BASE0_FMASK    (0x3FFFFFF)
#define ZR_FIFO_PTRS0          FCI_GLBRX_REG(0x006C)
#define ZR_FIFO_PTRS0_WMASK    (0xC0FF00FF)
#define ZR_FIFO_PTRS0_MASK     (0xC0FF00FF)
#define ZR_FIFO_PTRS0_DEFAULT  (0x0000)
#define ZR_FIFO_PTRS0_FMASK    (0xC0FF00FF)
#define ZR_FIFO_CNST0          FCI_GLBRX_REG(0x0070)
#define ZR_FIFO_CNST0_WMASK    (0xFFFFFF)
#define ZR_FIFO_CNST0_MASK     (0xFFFFFF)
#define ZR_FIFO_CNST0_DEFAULT  (0x0000)
#define ZR_FIFO_CNST0_FMASK    (0xFFFFFF)
#define ZR_FIFO_BASE1          FCI_GLBRX_REG(0x0074)
#define ZR_FIFO_BASE1_WMASK    (0x3FFFFFF)
#define ZR_FIFO_BASE1_MASK     (0x3FFFFFF)
#define ZR_FIFO_BASE1_DEFAULT  (0x0000)
#define ZR_FIFO_BASE1_FMASK    (0x3FFFFFF)
#define ZR_FIFO_PTRS1          FCI_GLBRX_REG(0x0078)
#define ZR_FIFO_PTRS1_WMASK    (0xC0FF00FF)
#define ZR_FIFO_PTRS1_MASK     (0xC0FF00FF)
#define ZR_FIFO_PTRS1_DEFAULT  (0x0000)
#define ZR_FIFO_PTRS1_FMASK    (0xC0FF00FF)
#define ZR_FIFO_CNST1          FCI_GLBRX_REG(0x007C)
#define ZR_FIFO_CNST1_WMASK    (0xFFFFFF)
#define ZR_FIFO_CNST1_MASK     (0xFFFFFF)
#define ZR_FIFO_CNST1_DEFAULT  (0x0000)
#define ZR_FIFO_CNST1_FMASK    (0xFFFFFF)
#define ZR_FIFO_BASE2          FCI_GLBRX_REG(0x0080)
#define ZR_FIFO_BASE2_WMASK    (0x3FFFFFF)
#define ZR_FIFO_BASE2_MASK     (0x3FFFFFF)
#define ZR_FIFO_BASE2_DEFAULT  (0x0000)
#define ZR_FIFO_BASE2_FMASK    (0x3FFFFFF)
#define ZR_FIFO_PTRS2          FCI_GLBRX_REG(0x0084)
#define ZR_FIFO_PTRS2_WMASK    (0xC0FF00FF)
#define ZR_FIFO_PTRS2_MASK     (0xC0FF00FF)
#define ZR_FIFO_PTRS2_DEFAULT  (0x0000)
#define ZR_FIFO_PTRS2_FMASK    (0xC0FF00FF)
#define ZR_FIFO_CNST2          FCI_GLBRX_REG(0x0088)
#define ZR_FIFO_CNST2_WMASK    (0xFFFFFF)
#define ZR_FIFO_CNST2_MASK     (0xFFFFFF)
#define ZR_FIFO_CNST2_DEFAULT  (0x0000)
#define ZR_FIFO_CNST2_FMASK    (0xFFFFFF)
#define ZR_FIFO_BASE3          FCI_GLBRX_REG(0x008C)
#define ZR_FIFO_BASE3_WMASK    (0x3FFFFFFF)
#define ZR_FIFO_BASE3_MASK     (0x3FFFFFFF)
#define ZR_FIFO_BASE3_DEFAULT  (0x0000)
#define ZR_FIFO_BASE3_FMASK    (0x3FFFFFFF)
#define ZR_FIFO_PTRS3          FCI_GLBRX_REG(0x0090)
#define ZR_FIFO_PTRS3_WMASK    (0xCFFF0FFF)
#define ZR_FIFO_PTRS3_MASK     (0xCFFF0FFF)
#define ZR_FIFO_PTRS3_DEFAULT  (0x0000)
#define ZR_FIFO_PTRS3_FMASK    (0xCFFF0FFF)
#define ZR_FIFO_CNST3          FCI_GLBRX_REG(0x0094)
#define ZR_FIFO_CNST3_WMASK    (0x1FFFFFF)
#define ZR_FIFO_CNST3_MASK     (0x1FFFFFF)
#define ZR_FIFO_CNST3_DEFAULT  (0x0000)
#define ZR_FIFO_CNST3_FMASK    (0x1FFFFFF)
#define ZR_DEPTH               FCI_GLBRX_REG(0x0098)
#define ZR_DEPTH_WMASK         (0xFFFFFFFF)
#define ZR_DEPTH_MASK          (0xFFFFFFFF)
#define ZR_DEPTH_DEFAULT       (0x0000)
#define ZR_DEPTH_FMASK         (0xFFFFFFFF)
#define ZR_ILV_PARAMS0         FCI_GLBRX_REG(0x009C)
#define ZR_ILV_PARAMS0_WMASK   (0xFFFFFF07)
#define ZR_ILV_PARAMS0_MASK    (0xFFFFFF17)
#define ZR_ILV_PARAMS0_DEFAULT (0x0000)
#define ZR_ILV_PARAMS0_FMASK   (0xFFFFFF07)
#define ZR_ILV_BASE0           FCI_GLBRX_REG(0x00A0)
#define ZR_ILV_BASE0_WMASK     (0x3FFFF)
#define ZR_ILV_BASE0_MASK      (0x3FFFF)
#define ZR_ILV_BASE0_DEFAULT   (0x0000)
#define ZR_ILV_BASE0_FMASK     (0x3FFFF)
#define ZR_ILV_SIZE0           FCI_GLBRX_REG(0x00A4)
#define ZR_ILV_SIZE0_WMASK     (0xFFFFFF)
#define ZR_ILV_SIZE0_MASK      (0xFFFFFF)
#define ZR_ILV_SIZE0_DEFAULT   (0x0000)
#define ZR_ILV_SIZE0_FMASK     (0xFFFFFF)
#define ZR_ILV_MAX_FULLNESS0   FCI_GLBRX_REG(0x00A8)
#define ZR_ILV_MAX_FULLNESS0_WMASK (0x3FFFF)
#define ZR_ILV_MAX_FULLNESS0_MASK (0x3FFFF)
#define ZR_ILV_MAX_FULLNESS0_DEFAULT (0x0000)
#define ZR_ILV_MAX_FULLNESS0_FMASK (0x3FFFF)
#define ZR_ILV_MIN_FULLNESS0   FCI_GLBRX_REG(0x00AC)
#define ZR_ILV_MIN_FULLNESS0_WMASK (0x3FFFF)
#define ZR_ILV_MIN_FULLNESS0_MASK (0x3FFFF)
#define ZR_ILV_MIN_FULLNESS0_DEFAULT (0x0000)
#define ZR_ILV_MIN_FULLNESS0_FMASK (0x3FFFF)
#define ZR_ILV_FULLNESS0       FCI_GLBRX_REG(0x00B0)
#define ZR_ILV_FULLNESS0_WMASK (0x3FFFF)
#define ZR_ILV_FULLNESS0_MASK  (0x3FFFF)
#define ZR_ILV_FULLNESS0_DEFAULT (0x0000)
#define ZR_ILV_FULLNESS0_FMASK (0x3FFFF)
#define ZR_ILV_CNTRS0          FCI_GLBRX_REG(0x00B4)
#define ZR_ILV_CNTRS0_WMASK    (0xFFFF0000)
#define ZR_ILV_CNTRS0_MASK     (0xFFFF0000)
#define ZR_ILV_CNTRS0_DEFAULT  (0x0000)
#define ZR_ILV_CNTRS0_FMASK    (0xFFFF0000)
#define ZR_ILV_PMS_CNTRS0      FCI_GLBRX_REG(0x00B8)
#define ZR_ILV_PMS_CNTRS0_WMASK (0xFFFFFFFF)
#define ZR_ILV_PMS_CNTRS0_MASK (0xFFFFFFFF)
#define ZR_ILV_PMS_CNTRS0_DEFAULT (0x0000)
#define ZR_ILV_PMS_CNTRS0_FMASK (0xFFFFFFFF)
#define ZR_ILV_PMD_CNTRS0      FCI_GLBRX_REG(0x00BC)
#define ZR_ILV_PMD_CNTRS0_WMASK (0xFFFFFFFF)
#define ZR_ILV_PMD_CNTRS0_MASK (0xFFFFFFFF)
#define ZR_ILV_PMD_CNTRS0_DEFAULT (0x0000)
#define ZR_ILV_PMD_CNTRS0_FMASK (0xFFFFFFFF)
#define ZR_ILV_PARAMS1         FCI_GLBRX_REG(0x00C0)
#define ZR_ILV_PARAMS1_WMASK   (0xFFFFFF07)
#define ZR_ILV_PARAMS1_MASK    (0xFFFFFF17)
#define ZR_ILV_PARAMS1_DEFAULT (0x0000)
#define ZR_ILV_PARAMS1_FMASK   (0xFFFFFF07)
#define ZR_ILV_BASE1           FCI_GLBRX_REG(0x00C4)
#define ZR_ILV_BASE1_WMASK     (0x3FFFF)
#define ZR_ILV_BASE1_MASK      (0x3FFFF)
#define ZR_ILV_BASE1_DEFAULT   (0x0000)
#define ZR_ILV_BASE1_FMASK     (0x3FFFF)
#define ZR_ILV_SIZE1           FCI_GLBRX_REG(0x00C8)
#define ZR_ILV_SIZE1_WMASK     (0xFFFFFF)
#define ZR_ILV_SIZE1_MASK      (0xFFFFFF)
#define ZR_ILV_SIZE1_DEFAULT   (0x0000)
#define ZR_ILV_SIZE1_FMASK     (0xFFFFFF)
#define ZR_ILV_MAX_FULLNESS1   FCI_GLBRX_REG(0x00CC)
#define ZR_ILV_MAX_FULLNESS1_WMASK (0x3FFFF)
#define ZR_ILV_MAX_FULLNESS1_MASK (0x3FFFF)
#define ZR_ILV_MAX_FULLNESS1_DEFAULT (0x0000)
#define ZR_ILV_MAX_FULLNESS1_FMASK (0x3FFFF)
#define ZR_ILV_MIN_FULLNESS1   FCI_GLBRX_REG(0x00D0)
#define ZR_ILV_MIN_FULLNESS1_WMASK (0x3FFFF)
#define ZR_ILV_MIN_FULLNESS1_MASK (0x3FFFF)
#define ZR_ILV_MIN_FULLNESS1_DEFAULT (0x0000)
#define ZR_ILV_MIN_FULLNESS1_FMASK (0x3FFFF)
#define ZR_ILV_FULLNESS1       FCI_GLBRX_REG(0x00D4)
#define ZR_ILV_FULLNESS1_WMASK (0x3FFFF)
#define ZR_ILV_FULLNESS1_MASK  (0x3FFFF)
#define ZR_ILV_FULLNESS1_DEFAULT (0x0000)
#define ZR_ILV_FULLNESS1_FMASK (0x3FFFF)
#define ZR_ILV_CNTRS1          FCI_GLBRX_REG(0x00D8)
#define ZR_ILV_CNTRS1_WMASK    (0xFFFF0000)
#define ZR_ILV_CNTRS1_MASK     (0xFFFF0000)
#define ZR_ILV_CNTRS1_DEFAULT  (0x0000)
#define ZR_ILV_CNTRS1_FMASK    (0xFFFF0000)
#define ZR_ILV_PMS_CNTRS1      FCI_GLBRX_REG(0x00DC)
#define ZR_ILV_PMS_CNTRS1_WMASK (0xFFFFFFFF)
#define ZR_ILV_PMS_CNTRS1_MASK (0xFFFFFFFF)
#define ZR_ILV_PMS_CNTRS1_DEFAULT (0x0000)
#define ZR_ILV_PMS_CNTRS1_FMASK (0xFFFFFFFF)
#define ZR_ILV_PMD_CNTRS1      FCI_GLBRX_REG(0x00E0)
#define ZR_ILV_PMD_CNTRS1_WMASK (0xFFFFFFFF)
#define ZR_ILV_PMD_CNTRS1_MASK (0xFFFFFFFF)
#define ZR_ILV_PMD_CNTRS1_DEFAULT (0x0000)
#define ZR_ILV_PMD_CNTRS1_FMASK (0xFFFFFFFF)
#define ZIR_DL_REL0            FCI_GLBRX_REG(0x00E4)
#define ZIR_DL_REL0_WMASK      (0x3FFFFFF)
#define ZIR_DL_REL0_MASK       (0x3FFFFFF)
#define ZIR_DL_REL0_DEFAULT    (0x0000)
#define ZIR_DL_REL0_FMASK      (0x3FFFFFF)
#define ZIR_NL_REL0            FCI_GLBRX_REG(0x00E8)
#define ZIR_NL_REL0_WMASK      (0x3FF07FF)
#define ZIR_NL_REL0_MASK       (0x3FF07FF)
#define ZIR_NL_REL0_DEFAULT    (0x0000)
#define ZIR_NL_REL0_FMASK      (0x3FF07FF)
#define ZIR_DMETRIC0           FCI_GLBRX_REG(0x00EC)
#define ZIR_DMETRIC0_WMASK     (0x3FFFFFF)
#define ZIR_DMETRIC0_MASK      (0x3FFFFFF)
#define ZIR_DMETRIC0_DEFAULT   (0x0000)
#define ZIR_DMETRIC0_FMASK     (0x3FFFFFF)
#define ZIR_DMETRIC_CTRL       FCI_GLBRX_REG(0x00F0)
#define ZIR_DMETRIC_CTRL_WMASK (0xFF1300FF)
#define ZIR_DMETRIC_CTRL_MASK  (0xFF1300FF)
#define ZIR_DMETRIC_CTRL_DEFAULT (0x0000)
#define ZIR_DMETRIC_CTRL_FMASK (0xFF1300FF)
#define ZIR_LPBITS             FCI_GLBRX_REG(0x00F4)
#define ZIR_LPBITS_WMASK       (0xFFFF)
#define ZIR_LPBITS_MASK        (0xFFFF)
#define ZIR_LPBITS_DEFAULT     (0x0000)
#define ZIR_LPBITS_FMASK       (0xFFFF)
#define ZR_CW_COUNT            FCI_GLBRX_REG(0x00F8)
#define ZR_CW_COUNT_WMASK      (0xFFFF)
#define ZR_CW_COUNT_MASK       (0xFFFF)
#define ZR_CW_COUNT_DEFAULT    (0x0000)
#define ZR_CW_COUNT_FMASK      (0xFFFF)
#define ZR_FEC_CNT             FCI_GLBRX_REG(0x00FC)
#define ZR_FEC_CNT_WMASK       (0xFFFFFFFF)
#define ZR_FEC_CNT_MASK        (0xFFFFFFFF)
#define ZR_FEC_CNT_DEFAULT     (0x0000)
#define ZR_FEC_CNT_FMASK       (0xFFFFFFFF)
#define ZR_UNCORR_CW0          FCI_GLBRX_REG(0x0100)
#define ZR_UNCORR_CW0_WMASK    (0xFFFFFFFF)
#define ZR_UNCORR_CW0_MASK     (0xFFFFFFFF)
#define ZR_UNCORR_CW0_DEFAULT  (0x0000)
#define ZR_UNCORR_CW0_FMASK    (0xFFFFFFFF)
#define ZR_UNCORR_CW1          FCI_GLBRX_REG(0x0104)
#define ZR_UNCORR_CW1_WMASK    (0xFFFFFFFF)
#define ZR_UNCORR_CW1_MASK     (0xFFFFFFFF)
#define ZR_UNCORR_CW1_DEFAULT  (0x0000)
#define ZR_UNCORR_CW1_FMASK    (0xFFFFFFFF)
#define ZR_WB_SCORE_CTL        FCI_GLBRX_REG(0x0108)
#define ZR_WB_SCORE_CTL_WMASK  (0xFF7F5FFF)
#define ZR_WB_SCORE_CTL_MASK   (0xFF7F5FFF)
#define ZR_WB_SCORE_CTL_DEFAULT (0x0000)
#define ZR_WB_SCORE_CTL_FMASK  (0xFF7F5FFF)
#define ZR_WB_SCORE2           FCI_GLBRX_REG(0x010C)
#define ZR_WB_SCORE2_WMASK     (0xFFFF)
#define ZR_WB_SCORE2_MASK      (0xFFFF)
#define ZR_WB_SCORE2_DEFAULT   (0x0000)
#define ZR_WB_SCORE2_FMASK     (0xFFFF)
#define ZR_UPROC_ENA           FCI_GLBRX_REG(0x0110)
#define ZR_UPROC_ENA_WMASK     (0x03FF)
#define ZR_UPROC_ENA_MASK      (0x03FF)
#define ZR_UPROC_ENA_DEFAULT   (0x0000)
#define ZR_UPROC_ENA_FMASK     (0x03FF)
#define ZR_UPROC01_BASE        FCI_GLBRX_REG(0x0114)
#define ZR_UPROC01_BASE_WMASK  (0xFFFFFFFF)
#define ZR_UPROC01_BASE_MASK   (0xFFFFFFFF)
#define ZR_UPROC01_BASE_DEFAULT (0x0000)
#define ZR_UPROC01_BASE_FMASK  (0xFFFFFFFF)
#define ZR_UPROC23_BASE        FCI_GLBRX_REG(0x0118)
#define ZR_UPROC23_BASE_WMASK  (0xFFFFFFFF)
#define ZR_UPROC23_BASE_MASK   (0xFFFFFFFF)
#define ZR_UPROC23_BASE_DEFAULT (0x0000)
#define ZR_UPROC23_BASE_FMASK  (0xFFFFFFFF)
#define ZR_UPROC45_BASE        FCI_GLBRX_REG(0x011C)
#define ZR_UPROC45_BASE_WMASK  (0xFFFFFFFF)
#define ZR_UPROC45_BASE_MASK   (0xFFFFFFFF)
#define ZR_UPROC45_BASE_DEFAULT (0x0000)
#define ZR_UPROC45_BASE_FMASK  (0xFFFFFFFF)
#define ZR_UPROC67_BASE        FCI_GLBRX_REG(0x0120)
#define ZR_UPROC67_BASE_WMASK  (0xFFFFFFFF)
#define ZR_UPROC67_BASE_MASK   (0xFFFFFFFF)
#define ZR_UPROC67_BASE_DEFAULT (0x0000)
#define ZR_UPROC67_BASE_FMASK  (0xFFFFFFFF)
#define ZR_UPROC89_BASE        FCI_GLBRX_REG(0x0124)
#define ZR_UPROC89_BASE_WMASK  (0xFFFFFFFF)
#define ZR_UPROC89_BASE_MASK   (0xFFFFFFFF)
#define ZR_UPROC89_BASE_DEFAULT (0x0000)
#define ZR_UPROC89_BASE_FMASK  (0xFFFFFFFF)
#define ZR_UPROC_INT           FCI_GLBRX_REG(0x0128)
#define ZR_UPROC_INT_WMASK     (0x03FF)
#define ZR_UPROC_INT_MASK      (0x03FF)
#define ZR_UPROC_INT_DEFAULT   (0x0000)
#define ZR_UPROC_INT_FMASK     (0x03FF)
#define ZR_UPROC0_STATE0       FCI_GLBRX_REG(0x012C)
#define ZR_UPROC0_STATE0_WMASK (0xFFFFFF00)
#define ZR_UPROC0_STATE0_MASK  (0xFFFFFFFF)
#define ZR_UPROC0_STATE0_DEFAULT (0x0000)
#define ZR_UPROC0_STATE0_FMASK (0xFFFFFFFF)
#define ZR_UPROC0_STATE1       FCI_GLBRX_REG(0x0130)
#define ZR_UPROC0_STATE1_WMASK (0xFFFFFFFF)
#define ZR_UPROC0_STATE1_MASK  (0xFFFFFFFF)
#define ZR_UPROC0_STATE1_DEFAULT (0x0000)
#define ZR_UPROC0_STATE1_FMASK (0xFFFFFFFF)
#define ZR_UPROC0_STATE2       FCI_GLBRX_REG(0x0134)
#define ZR_UPROC0_STATE2_WMASK (0xFFFFFFFF)
#define ZR_UPROC0_STATE2_MASK  (0xFFFFFFFF)
#define ZR_UPROC0_STATE2_DEFAULT (0x0000)
#define ZR_UPROC0_STATE2_FMASK (0xFFFFFFFF)
#define ZR_UPROC0_STATE3       FCI_GLBRX_REG(0x0138)
#define ZR_UPROC0_STATE3_WMASK (0xFFFFFFFF)
#define ZR_UPROC0_STATE3_MASK  (0xFFFFFFFF)
#define ZR_UPROC0_STATE3_DEFAULT (0x0000)
#define ZR_UPROC0_STATE3_FMASK (0xFFFFFFFF)
#define ZR_UPROC0_STATE4       FCI_GLBRX_REG(0x013C)
#define ZR_UPROC0_STATE4_WMASK (0xFFFFFFFF)
#define ZR_UPROC0_STATE4_MASK  (0xFFFFFFFF)
#define ZR_UPROC0_STATE4_DEFAULT (0x0000)
#define ZR_UPROC0_STATE4_FMASK (0xFFFFFFFF)
#define ZR_UPROC1_STATE0       FCI_GLBRX_REG(0x0140)
#define ZR_UPROC1_STATE0_WMASK (0xFFFFFF00)
#define ZR_UPROC1_STATE0_MASK  (0xFFFFFFFF)
#define ZR_UPROC1_STATE0_DEFAULT (0x0000)
#define ZR_UPROC1_STATE0_FMASK (0xFFFFFFFF)
#define ZR_UPROC1_STATE1       FCI_GLBRX_REG(0x0144)
#define ZR_UPROC1_STATE1_WMASK (0xFFFFFFFF)
#define ZR_UPROC1_STATE1_MASK  (0xFFFFFFFF)
#define ZR_UPROC1_STATE1_DEFAULT (0x0000)
#define ZR_UPROC1_STATE1_FMASK (0xFFFFFFFF)
#define ZR_UPROC1_STATE2       FCI_GLBRX_REG(0x0148)
#define ZR_UPROC1_STATE2_WMASK (0xFFFFFFFF)
#define ZR_UPROC1_STATE2_MASK  (0xFFFFFFFF)
#define ZR_UPROC1_STATE2_DEFAULT (0x0000)
#define ZR_UPROC1_STATE2_FMASK (0xFFFFFFFF)
#define ZR_UPROC1_STATE3       FCI_GLBRX_REG(0x014C)
#define ZR_UPROC1_STATE3_WMASK (0xFFFFFFFF)
#define ZR_UPROC1_STATE3_MASK  (0xFFFFFFFF)
#define ZR_UPROC1_STATE3_DEFAULT (0x0000)
#define ZR_UPROC1_STATE3_FMASK (0xFFFFFFFF)
#define ZR_UPROC1_STATE4       FCI_GLBRX_REG(0x0150)
#define ZR_UPROC1_STATE4_WMASK (0xFFFFFFFF)
#define ZR_UPROC1_STATE4_MASK  (0xFFFFFFFF)
#define ZR_UPROC1_STATE4_DEFAULT (0x0000)
#define ZR_UPROC1_STATE4_FMASK (0xFFFFFFFF)
#define ZR_UPROC2_STATE0       FCI_GLBRX_REG(0x0154)
#define ZR_UPROC2_STATE0_WMASK (0xFFFFFF00)
#define ZR_UPROC2_STATE0_MASK  (0xFFFFFFFF)
#define ZR_UPROC2_STATE0_DEFAULT (0x0000)
#define ZR_UPROC2_STATE0_FMASK (0xFFFFFFFF)
#define ZR_UPROC2_STATE1       FCI_GLBRX_REG(0x0158)
#define ZR_UPROC2_STATE1_WMASK (0xFFFFFFFF)
#define ZR_UPROC2_STATE1_MASK  (0xFFFFFFFF)
#define ZR_UPROC2_STATE1_DEFAULT (0x0000)
#define ZR_UPROC2_STATE1_FMASK (0xFFFFFFFF)
#define ZR_UPROC2_STATE2       FCI_GLBRX_REG(0x015C)
#define ZR_UPROC2_STATE2_WMASK (0xFFFFFFFF)
#define ZR_UPROC2_STATE2_MASK  (0xFFFFFFFF)
#define ZR_UPROC2_STATE2_DEFAULT (0x0000)
#define ZR_UPROC2_STATE2_FMASK (0xFFFFFFFF)
#define ZR_UPROC2_STATE3       FCI_GLBRX_REG(0x0160)
#define ZR_UPROC2_STATE3_WMASK (0xFFFFFFFF)
#define ZR_UPROC2_STATE3_MASK  (0xFFFFFFFF)
#define ZR_UPROC2_STATE3_DEFAULT (0x0000)
#define ZR_UPROC2_STATE3_FMASK (0xFFFFFFFF)
#define ZR_UPROC2_STATE4       FCI_GLBRX_REG(0x0164)
#define ZR_UPROC2_STATE4_WMASK (0xFFFFFFFF)
#define ZR_UPROC2_STATE4_MASK  (0xFFFFFFFF)
#define ZR_UPROC2_STATE4_DEFAULT (0x0000)
#define ZR_UPROC2_STATE4_FMASK (0xFFFFFFFF)
#define ZR_UPROC3_STATE0       FCI_GLBRX_REG(0x0168)
#define ZR_UPROC3_STATE0_WMASK (0xFFFFFF00)
#define ZR_UPROC3_STATE0_MASK  (0xFFFFFFFF)
#define ZR_UPROC3_STATE0_DEFAULT (0x0000)
#define ZR_UPROC3_STATE0_FMASK (0xFFFFFFFF)
#define ZR_UPROC3_STATE1       FCI_GLBRX_REG(0x016C)
#define ZR_UPROC3_STATE1_WMASK (0xFFFFFFFF)
#define ZR_UPROC3_STATE1_MASK  (0xFFFFFFFF)
#define ZR_UPROC3_STATE1_DEFAULT (0x0000)
#define ZR_UPROC3_STATE1_FMASK (0xFFFFFFFF)
#define ZR_UPROC3_STATE2       FCI_GLBRX_REG(0x0170)
#define ZR_UPROC3_STATE2_WMASK (0xFFFFFFFF)
#define ZR_UPROC3_STATE2_MASK  (0xFFFFFFFF)
#define ZR_UPROC3_STATE2_DEFAULT (0x0000)
#define ZR_UPROC3_STATE2_FMASK (0xFFFFFFFF)
#define ZR_UPROC3_STATE3       FCI_GLBRX_REG(0x0174)
#define ZR_UPROC3_STATE3_WMASK (0xFFFFFFFF)
#define ZR_UPROC3_STATE3_MASK  (0xFFFFFFFF)
#define ZR_UPROC3_STATE3_DEFAULT (0x0000)
#define ZR_UPROC3_STATE3_FMASK (0xFFFFFFFF)
#define ZR_UPROC3_STATE4       FCI_GLBRX_REG(0x0178)
#define ZR_UPROC3_STATE4_WMASK (0xFFFFFFFF)
#define ZR_UPROC3_STATE4_MASK  (0xFFFFFFFF)
#define ZR_UPROC3_STATE4_DEFAULT (0x0000)
#define ZR_UPROC3_STATE4_FMASK (0xFFFFFFFF)
#define ZR_UPROC4_STATE0       FCI_GLBRX_REG(0x017C)
#define ZR_UPROC4_STATE0_WMASK (0xFFFFFF00)
#define ZR_UPROC4_STATE0_MASK  (0xFFFFFFFF)
#define ZR_UPROC4_STATE0_DEFAULT (0x0000)
#define ZR_UPROC4_STATE0_FMASK (0xFFFFFFFF)
#define ZR_UPROC4_STATE1       FCI_GLBRX_REG(0x0180)
#define ZR_UPROC4_STATE1_WMASK (0xFFFFFFFF)
#define ZR_UPROC4_STATE1_MASK  (0xFFFFFFFF)
#define ZR_UPROC4_STATE1_DEFAULT (0x0000)
#define ZR_UPROC4_STATE1_FMASK (0xFFFFFFFF)
#define ZR_UPROC4_STATE2       FCI_GLBRX_REG(0x0184)
#define ZR_UPROC4_STATE2_WMASK (0xFFFFFFFF)
#define ZR_UPROC4_STATE2_MASK  (0xFFFFFFFF)
#define ZR_UPROC4_STATE2_DEFAULT (0x0000)
#define ZR_UPROC4_STATE2_FMASK (0xFFFFFFFF)
#define ZR_UPROC4_STATE3       FCI_GLBRX_REG(0x0188)
#define ZR_UPROC4_STATE3_WMASK (0xFFFFFFFF)
#define ZR_UPROC4_STATE3_MASK  (0xFFFFFFFF)
#define ZR_UPROC4_STATE3_DEFAULT (0x0000)
#define ZR_UPROC4_STATE3_FMASK (0xFFFFFFFF)
#define ZR_UPROC4_STATE4       FCI_GLBRX_REG(0x018C)
#define ZR_UPROC4_STATE4_WMASK (0xFFFFFFFF)
#define ZR_UPROC4_STATE4_MASK  (0xFFFFFFFF)
#define ZR_UPROC4_STATE4_DEFAULT (0x0000)
#define ZR_UPROC4_STATE4_FMASK (0xFFFFFFFF)
#define ZR_UPROC5_STATE0       FCI_GLBRX_REG(0x0190)
#define ZR_UPROC5_STATE0_WMASK (0xFFFFFF00)
#define ZR_UPROC5_STATE0_MASK  (0xFFFFFFFF)
#define ZR_UPROC5_STATE0_DEFAULT (0x0000)
#define ZR_UPROC5_STATE0_FMASK (0xFFFFFFFF)
#define ZR_UPROC5_STATE1       FCI_GLBRX_REG(0x0194)
#define ZR_UPROC5_STATE1_WMASK (0xFFFFFFFF)
#define ZR_UPROC5_STATE1_MASK  (0xFFFFFFFF)
#define ZR_UPROC5_STATE1_DEFAULT (0x0000)
#define ZR_UPROC5_STATE1_FMASK (0xFFFFFFFF)
#define ZR_UPROC5_STATE2       FCI_GLBRX_REG(0x0198)
#define ZR_UPROC5_STATE2_WMASK (0xFFFFFFFF)
#define ZR_UPROC5_STATE2_MASK  (0xFFFFFFFF)
#define ZR_UPROC5_STATE2_DEFAULT (0x0000)
#define ZR_UPROC5_STATE2_FMASK (0xFFFFFFFF)
#define ZR_UPROC5_STATE3       FCI_GLBRX_REG(0x019C)
#define ZR_UPROC5_STATE3_WMASK (0xFFFFFFFF)
#define ZR_UPROC5_STATE3_MASK  (0xFFFFFFFF)
#define ZR_UPROC5_STATE3_DEFAULT (0x0000)
#define ZR_UPROC5_STATE3_FMASK (0xFFFFFFFF)
#define ZR_UPROC5_STATE4       FCI_GLBRX_REG(0x01A0)
#define ZR_UPROC5_STATE4_WMASK (0xFFFFFFFF)
#define ZR_UPROC5_STATE4_MASK  (0xFFFFFFFF)
#define ZR_UPROC5_STATE4_DEFAULT (0x0000)
#define ZR_UPROC5_STATE4_FMASK (0xFFFFFFFF)
#define ZR_UPROC6_STATE0       FCI_GLBRX_REG(0x01A4)
#define ZR_UPROC6_STATE0_WMASK (0xFFFFFF00)
#define ZR_UPROC6_STATE0_MASK  (0xFFFFFFFF)
#define ZR_UPROC6_STATE0_DEFAULT (0x0000)
#define ZR_UPROC6_STATE0_FMASK (0xFFFFFFFF)
#define ZR_UPROC6_STATE1       FCI_GLBRX_REG(0x01A8)
#define ZR_UPROC6_STATE1_WMASK (0xFFFFFFFF)
#define ZR_UPROC6_STATE1_MASK  (0xFFFFFFFF)
#define ZR_UPROC6_STATE1_DEFAULT (0x0000)
#define ZR_UPROC6_STATE1_FMASK (0xFFFFFFFF)
#define ZR_UPROC6_STATE2       FCI_GLBRX_REG(0x01AC)
#define ZR_UPROC6_STATE2_WMASK (0xFFFFFFFF)
#define ZR_UPROC6_STATE2_MASK  (0xFFFFFFFF)
#define ZR_UPROC6_STATE2_DEFAULT (0x0000)
#define ZR_UPROC6_STATE2_FMASK (0xFFFFFFFF)
#define ZR_UPROC6_STATE3       FCI_GLBRX_REG(0x01B0)
#define ZR_UPROC6_STATE3_WMASK (0xFFFFFFFF)
#define ZR_UPROC6_STATE3_MASK  (0xFFFFFFFF)
#define ZR_UPROC6_STATE3_DEFAULT (0x0000)
#define ZR_UPROC6_STATE3_FMASK (0xFFFFFFFF)
#define ZR_UPROC6_STATE4       FCI_GLBRX_REG(0x01B4)
#define ZR_UPROC6_STATE4_WMASK (0xFFFFFFFF)
#define ZR_UPROC6_STATE4_MASK  (0xFFFFFFFF)
#define ZR_UPROC6_STATE4_DEFAULT (0x0000)
#define ZR_UPROC6_STATE4_FMASK (0xFFFFFFFF)
#define ZR_UPROC7_STATE0       FCI_GLBRX_REG(0x01B8)
#define ZR_UPROC7_STATE0_WMASK (0xFFFFFF00)
#define ZR_UPROC7_STATE0_MASK  (0xFFFFFFFF)
#define ZR_UPROC7_STATE0_DEFAULT (0x0000)
#define ZR_UPROC7_STATE0_FMASK (0xFFFFFFFF)
#define ZR_UPROC7_STATE1       FCI_GLBRX_REG(0x01BC)
#define ZR_UPROC7_STATE1_WMASK (0xFFFFFFFF)
#define ZR_UPROC7_STATE1_MASK  (0xFFFFFFFF)
#define ZR_UPROC7_STATE1_DEFAULT (0x0000)
#define ZR_UPROC7_STATE1_FMASK (0xFFFFFFFF)
#define ZR_UPROC7_STATE2       FCI_GLBRX_REG(0x01C0)
#define ZR_UPROC7_STATE2_WMASK (0xFFFFFFFF)
#define ZR_UPROC7_STATE2_MASK  (0xFFFFFFFF)
#define ZR_UPROC7_STATE2_DEFAULT (0x0000)
#define ZR_UPROC7_STATE2_FMASK (0xFFFFFFFF)
#define ZR_UPROC7_STATE3       FCI_GLBRX_REG(0x01C4)
#define ZR_UPROC7_STATE3_WMASK (0xFFFFFFFF)
#define ZR_UPROC7_STATE3_MASK  (0xFFFFFFFF)
#define ZR_UPROC7_STATE3_DEFAULT (0x0000)
#define ZR_UPROC7_STATE3_FMASK (0xFFFFFFFF)
#define ZR_UPROC7_STATE4       FCI_GLBRX_REG(0x01C8)
#define ZR_UPROC7_STATE4_WMASK (0xFFFFFFFF)
#define ZR_UPROC7_STATE4_MASK  (0xFFFFFFFF)
#define ZR_UPROC7_STATE4_DEFAULT (0x0000)
#define ZR_UPROC7_STATE4_FMASK (0xFFFFFFFF)
#define ZR_UPROC8_STATE0       FCI_GLBRX_REG(0x01CC)
#define ZR_UPROC8_STATE0_WMASK (0xFFFFFF00)
#define ZR_UPROC8_STATE0_MASK  (0xFFFFFFFF)
#define ZR_UPROC8_STATE0_DEFAULT (0x0000)
#define ZR_UPROC8_STATE0_FMASK (0xFFFFFFFF)
#define ZR_UPROC8_STATE1       FCI_GLBRX_REG(0x01D0)
#define ZR_UPROC8_STATE1_WMASK (0xFFFFFFFF)
#define ZR_UPROC8_STATE1_MASK  (0xFFFFFFFF)
#define ZR_UPROC8_STATE1_DEFAULT (0x0000)
#define ZR_UPROC8_STATE1_FMASK (0xFFFFFFFF)
#define ZR_UPROC8_STATE2       FCI_GLBRX_REG(0x01D4)
#define ZR_UPROC8_STATE2_WMASK (0xFFFFFFFF)
#define ZR_UPROC8_STATE2_MASK  (0xFFFFFFFF)
#define ZR_UPROC8_STATE2_DEFAULT (0x0000)
#define ZR_UPROC8_STATE2_FMASK (0xFFFFFFFF)
#define ZR_UPROC8_STATE3       FCI_GLBRX_REG(0x01D8)
#define ZR_UPROC8_STATE3_WMASK (0xFFFFFFFF)
#define ZR_UPROC8_STATE3_MASK  (0xFFFFFFFF)
#define ZR_UPROC8_STATE3_DEFAULT (0x0000)
#define ZR_UPROC8_STATE3_FMASK (0xFFFFFFFF)
#define ZR_UPROC8_STATE4       FCI_GLBRX_REG(0x01DC)
#define ZR_UPROC8_STATE4_WMASK (0xFFFFFFFF)
#define ZR_UPROC8_STATE4_MASK  (0xFFFFFFFF)
#define ZR_UPROC8_STATE4_DEFAULT (0x0000)
#define ZR_UPROC8_STATE4_FMASK (0xFFFFFFFF)
#define ZR_UPROC9_STATE0       FCI_GLBRX_REG(0x01E0)
#define ZR_UPROC9_STATE0_WMASK (0xFFFFFF00)
#define ZR_UPROC9_STATE0_MASK  (0xFFFFFFFF)
#define ZR_UPROC9_STATE0_DEFAULT (0x0000)
#define ZR_UPROC9_STATE0_FMASK (0xFFFFFFFF)
#define ZR_UPROC9_STATE1       FCI_GLBRX_REG(0x01E4)
#define ZR_UPROC9_STATE1_WMASK (0xFFFFFFFF)
#define ZR_UPROC9_STATE1_MASK  (0xFFFFFFFF)
#define ZR_UPROC9_STATE1_DEFAULT (0x0000)
#define ZR_UPROC9_STATE1_FMASK (0xFFFFFFFF)
#define ZR_UPROC9_STATE2       FCI_GLBRX_REG(0x01E8)
#define ZR_UPROC9_STATE2_WMASK (0xFFFFFFFF)
#define ZR_UPROC9_STATE2_MASK  (0xFFFFFFFF)
#define ZR_UPROC9_STATE2_DEFAULT (0x0000)
#define ZR_UPROC9_STATE2_FMASK (0xFFFFFFFF)
#define ZR_UPROC9_STATE3       FCI_GLBRX_REG(0x01EC)
#define ZR_UPROC9_STATE3_WMASK (0xFFFFFFFF)
#define ZR_UPROC9_STATE3_MASK  (0xFFFFFFFF)
#define ZR_UPROC9_STATE3_DEFAULT (0x0000)
#define ZR_UPROC9_STATE3_FMASK (0xFFFFFFFF)
#define ZR_UPROC9_STATE4       FCI_GLBRX_REG(0x01F0)
#define ZR_UPROC9_STATE4_WMASK (0xFFFFFFFF)
#define ZR_UPROC9_STATE4_MASK  (0xFFFFFFFF)
#define ZR_UPROC9_STATE4_DEFAULT (0x0000)
#define ZR_UPROC9_STATE4_FMASK (0xFFFFFFFF)
#define ZR_UPROC_STATE5        FCI_GLBRX_REG(0x01F4)
#define ZR_UPROC_STATE5_WMASK  (0xFFFFF)
#define ZR_UPROC_STATE5_MASK   (0xFFFFF)
#define ZR_UPROC_STATE5_DEFAULT (0x0000)
#define ZR_UPROC_STATE5_FMASK  (0xFFFFF)
#define ZR_ALU_STATE           FCI_GLBRX_REG(0x01F8)
#define ZR_ALU_STATE_WMASK     (0x3FFFFFFF)
#define ZR_ALU_STATE_MASK      (0x3FFFFFFF)
#define ZR_ALU_STATE_DEFAULT   (0x0000)
#define ZR_ALU_STATE_FMASK     (0x3FFFFFFF)
#define ZR_ALU_CLI_REQ         FCI_GLBRX_REG(0x01FC)
#define ZR_ALU_CLI_REQ_WMASK   (0x03FF)
#define ZR_ALU_CLI_REQ_MASK    (0x03FF)
#define ZR_ALU_CLI_REQ_DEFAULT (0x0000)
#define ZR_ALU_CLI_REQ_FMASK   (0x03FF)
#define ZR_WB_DBG              FCI_GLBRX_REG(0x0200)
#define ZR_WB_DBG_WMASK        (0x0000)
#define ZR_WB_DBG_MASK         (0x01FF)
#define ZR_WB_DBG_DEFAULT      (0x0000)
#define ZR_WB_DBG_FMASK        (0x01FF)
#define ZR_WB_RCHK0            FCI_GLBRX_REG(0x0204)
#define ZR_WB_RCHK0_WMASK      (0x0000)
#define ZR_WB_RCHK0_MASK       (0xFFFFFFFF)
#define ZR_WB_RCHK0_DEFAULT    (0x0000)
#define ZR_WB_RCHK0_FMASK      (0xFFFFFFFF)
#define ZR_WB_RCHK1            FCI_GLBRX_REG(0x0208)
#define ZR_WB_RCHK1_WMASK      (0x0000)
#define ZR_WB_RCHK1_MASK       (0xFFFFFFFF)
#define ZR_WB_RCHK1_DEFAULT    (0x0000)
#define ZR_WB_RCHK1_FMASK      (0xFFFFFFFF)
#define ZR_WB_RCHK2            FCI_GLBRX_REG(0x020C)
#define ZR_WB_RCHK2_WMASK      (0x0000)
#define ZR_WB_RCHK2_MASK       (0xFFFFFFFF)
#define ZR_WB_RCHK2_DEFAULT    (0x0000)
#define ZR_WB_RCHK2_FMASK      (0xFFFFFFFF)
#define ZR_WB_RCHK3            FCI_GLBRX_REG(0x0210)
#define ZR_WB_RCHK3_WMASK      (0x0000)
#define ZR_WB_RCHK3_MASK       (0xFFFFFFFF)
#define ZR_WB_RCHK3_DEFAULT    (0x0000)
#define ZR_WB_RCHK3_FMASK      (0xFFFFFFFF)
#define ZR_WB_RSYND0           FCI_GLBRX_REG(0x0214)
#define ZR_WB_RSYND0_WMASK     (0x0000)
#define ZR_WB_RSYND0_MASK      (0xFFFFFFFF)
#define ZR_WB_RSYND0_DEFAULT   (0x0000)
#define ZR_WB_RSYND0_FMASK     (0xFFFFFFFF)
#define ZR_WB_RSYND1           FCI_GLBRX_REG(0x0218)
#define ZR_WB_RSYND1_WMASK     (0x0000)
#define ZR_WB_RSYND1_MASK      (0xFFFFFFFF)
#define ZR_WB_RSYND1_DEFAULT   (0x0000)
#define ZR_WB_RSYND1_FMASK     (0xFFFFFFFF)
#define ZR_WB_RSYND2           FCI_GLBRX_REG(0x021C)
#define ZR_WB_RSYND2_WMASK     (0x0000)
#define ZR_WB_RSYND2_MASK      (0xFFFFFFFF)
#define ZR_WB_RSYND2_DEFAULT   (0x0000)
#define ZR_WB_RSYND2_FMASK     (0xFFFFFFFF)
#define ZR_WB_RSYND3           FCI_GLBRX_REG(0x0220)
#define ZR_WB_RSYND3_WMASK     (0x0000)
#define ZR_WB_RSYND3_MASK      (0xFFFFFFFF)
#define ZR_WB_RSYND3_DEFAULT   (0x0000)
#define ZR_WB_RSYND3_FMASK     (0xFFFFFFFF)
#define ZR_WB_AJ0              FCI_GLBRX_REG(0x0224)
#define ZR_WB_AJ0_WMASK        (0x0000)
#define ZR_WB_AJ0_MASK         (0xFFFFFFFF)
#define ZR_WB_AJ0_DEFAULT      (0x0000)
#define ZR_WB_AJ0_FMASK        (0xFFFFFFFF)
#define ZR_WB_AJ1              FCI_GLBRX_REG(0x0228)
#define ZR_WB_AJ1_WMASK        (0x0000)
#define ZR_WB_AJ1_MASK         (0xFFFFFFFF)
#define ZR_WB_AJ1_DEFAULT      (0x0000)
#define ZR_WB_AJ1_FMASK        (0xFFFFFFFF)
#define ZR_WB_AJ2              FCI_GLBRX_REG(0x022C)
#define ZR_WB_AJ2_WMASK        (0x0000)
#define ZR_WB_AJ2_MASK         (0xFFFFFFFF)
#define ZR_WB_AJ2_DEFAULT      (0x0000)
#define ZR_WB_AJ2_FMASK        (0xFFFFFFFF)
#define ZR_WB_AJ3              FCI_GLBRX_REG(0x0230)
#define ZR_WB_AJ3_WMASK        (0x0000)
#define ZR_WB_AJ3_MASK         (0xFFFFFFFF)
#define ZR_WB_AJ3_DEFAULT      (0x0000)
#define ZR_WB_AJ3_FMASK        (0xFFFFFFFF)
#define ZR_FIFO_ACCESS         FCI_GLBRX_REG(0x0234)
#define ZR_FIFO_ACCESS_WMASK   (0xBFFFF7FF)
#define ZR_FIFO_ACCESS_MASK    (0xBFFFFFFF)
#define ZR_FIFO_ACCESS_DEFAULT (0x0800)
#define ZR_FIFO_ACCESS_FMASK   (0xBFFFFFFF)
#define ZR_CONFIG              FCI_GLBRX_REG(0x0238)
#define ZR_CONFIG_WMASK        (0xFFFF)
#define ZR_CONFIG_MASK         (0xFFFF)
#define ZR_CONFIG_DEFAULT      (0x0000)
#define ZR_CONFIG_FMASK        (0xFFFF)
#define ZR_PMS_SIZE            FCI_GLBRX_REG(0x023C)
#define ZR_PMS_SIZE_WMASK      (0xFFFFFFFF)
#define ZR_PMS_SIZE_MASK       (0xFFFFFFFF)
#define ZR_PMS_SIZE_DEFAULT    (0x0000)
#define ZR_PMS_SIZE_FMASK      (0xFFFFFFFF)
#define ZR_DT_SIZE             FCI_GLBRX_REG(0x0240)
#define ZR_DT_SIZE_WMASK       (0xFFFFFFFF)
#define ZR_DT_SIZE_MASK        (0xFFFFFFFF)
#define ZR_DT_SIZE_DEFAULT     (0x0000)
#define ZR_DT_SIZE_FMASK       (0xFFFFFFFF)
#define ZR_QTDTB_CONFIG_LP0    FCI_GLBRX_REG(0x0244)
#define ZR_QTDTB_CONFIG_LP0_WMASK (0xCFFF0FFF)
#define ZR_QTDTB_CONFIG_LP0_MASK (0xCFFF0FFF)
#define ZR_QTDTB_CONFIG_LP0_DEFAULT (0x0000)
#define ZR_QTDTB_CONFIG_LP0_FMASK (0xCFFF0FFF)
#define ZR_QTDTB_CONFIG_LP1    FCI_GLBRX_REG(0x0248)
#define ZR_QTDTB_CONFIG_LP1_WMASK (0xCFFF0FFF)
#define ZR_QTDTB_CONFIG_LP1_MASK (0xCFFF0FFF)
#define ZR_QTDTB_CONFIG_LP1_DEFAULT (0x0000)
#define ZR_QTDTB_CONFIG_LP1_FMASK (0xCFFF0FFF)
#define ZR_QTDTB_CONFIG_LP2    FCI_GLBRX_REG(0x024C)
#define ZR_QTDTB_CONFIG_LP2_WMASK (0xFFF0FFF)
#define ZR_QTDTB_CONFIG_LP2_MASK (0xFFF0FFF)
#define ZR_QTDTB_CONFIG_LP2_DEFAULT (0x0000)
#define ZR_QTDTB_CONFIG_LP2_FMASK (0xFFF0FFF)
#define ZR_QTDTB_ADDR_LP01     FCI_GLBRX_REG(0x0250)
#define ZR_QTDTB_ADDR_LP01_WMASK (0xFFF0FFF)
#define ZR_QTDTB_ADDR_LP01_MASK (0xFFF0FFF)
#define ZR_QTDTB_ADDR_LP01_DEFAULT (0x0000)
#define ZR_QTDTB_ADDR_LP01_FMASK (0xFFF0FFF)
#define ZR_QTDTB_ADDR_LP2      FCI_GLBRX_REG(0x0254)
#define ZR_QTDTB_ADDR_LP2_WMASK (0x0FFF)
#define ZR_QTDTB_ADDR_LP2_MASK (0x0FFF)
#define ZR_QTDTB_ADDR_LP2_DEFAULT (0x0000)
#define ZR_QTDTB_ADDR_LP2_FMASK (0x0FFF)
#define ZR_DTB_OFFSET          FCI_GLBRX_REG(0x0258)
#define ZR_DTB_OFFSET_WMASK    (0x0FFF)
#define ZR_DTB_OFFSET_MASK     (0x0FFF)
#define ZR_DTB_OFFSET_DEFAULT  (0x0000)
#define ZR_DTB_OFFSET_FMASK    (0x0FFF)
#define ZR_QTSCORE             FCI_GLBRX_REG(0x025C)
#define ZR_QTSCORE_WMASK       (0x3FF00FF)
#define ZR_QTSCORE_MASK        (0x3FF00FF)
#define ZR_QTSCORE_DEFAULT     (0x0000)
#define ZR_QTSCORE_FMASK       (0x3FF00FF)
#define ZR_STAT_CTRL           FCI_GLBRX_REG(0x0260)
#define ZR_STAT_CTRL_WMASK     (0x0101)
#define ZR_STAT_CTRL_MASK      (0x0101)
#define ZR_STAT_CTRL_DEFAULT   (0x0000)
#define ZR_STAT_CTRL_FMASK     (0x0100)
#define ZR_ALU_CLI_REQ_ALIAS0  FCI_GLBRX_REG(0x0264)
#define ZR_ALU_CLI_REQ_ALIAS0_WMASK (0x0000)
#define ZR_ALU_CLI_REQ_ALIAS0_MASK (0x1010101)
#define ZR_ALU_CLI_REQ_ALIAS0_DEFAULT (0x0000)
#define ZR_ALU_CLI_REQ_ALIAS0_FMASK (0x0000)
#define ZR_ALU_CLI_REQ_ALIAS1  FCI_GLBRX_REG(0x0268)
#define ZR_ALU_CLI_REQ_ALIAS1_WMASK (0x0000)
#define ZR_ALU_CLI_REQ_ALIAS1_MASK (0x1010101)
#define ZR_ALU_CLI_REQ_ALIAS1_DEFAULT (0x0000)
#define ZR_ALU_CLI_REQ_ALIAS1_FMASK (0x0000)
#define ZR_ALU_CLI_REQ_ALIAS2  FCI_GLBRX_REG(0x026C)
#define ZR_ALU_CLI_REQ_ALIAS2_WMASK (0x0000)
#define ZR_ALU_CLI_REQ_ALIAS2_MASK (0x0101)
#define ZR_ALU_CLI_REQ_ALIAS2_DEFAULT (0x0000)
#define ZR_ALU_CLI_REQ_ALIAS2_FMASK (0x0000)

/* Ft Memory Address Constants */ 

/* Ft Global Address Constants */ 
#define ft_global_base         (0x20C800)
#define FT_GLOBAL(r)           (int)(ft_global_base + (r))
#define ft_global_size         (0x0200)

#define FT_RX_CTRL             FT_GLOBAL(0x0000)
#define FT_RX_CTRL_WMASK       (0x0003)
#define FT_RX_CTRL_MASK        (0x0003)
#define FT_RX_CTRL_DEFAULT     (0x0000)
#define FT_RX_CTRL_FMASK       (0x0003)
#define FT_RX_CTRL_A           FT_GLOBAL(0x0004)
#define FT_RX_CTRL_A_WMASK     (0x0003)
#define FT_RX_CTRL_A_MASK      (0x001F)
#define FT_RX_CTRL_A_DEFAULT   (0x0000)
#define FT_RX_CTRL_A_FMASK     (0x0003)
#define FT_TX_CTRL             FT_GLOBAL(0x0008)
#define FT_TX_CTRL_WMASK       (0x0003)
#define FT_TX_CTRL_MASK        (0x003B)
#define FT_TX_CTRL_DEFAULT     (0x0010)
#define FT_TX_CTRL_FMASK       (0x0003)
#define FT_TX_CTRL_A           FT_GLOBAL(0x000C)
#define FT_TX_CTRL_A_WMASK     (0x0003)
#define FT_TX_CTRL_A_MASK      (0x003B)
#define FT_TX_CTRL_A_DEFAULT   (0x0010)
#define FT_TX_CTRL_A_FMASK     (0x0003)
#define FT_STATUS              FT_GLOBAL(0x0010)
#define FT_STATUS_WMASK        (0x000A)
#define FT_STATUS_MASK         (0x000F)
#define FT_STATUS_DEFAULT      (0x0000)
#define FT_STATUS_FMASK        (0x0005)
#define FT_RX_SCALE            FT_GLOBAL(0x0014)
#define FT_RX_SCALE_WMASK      (0x3FFF)
#define FT_RX_SCALE_MASK       (0x3FFF)
#define FT_RX_SCALE_DEFAULT    (0x0000)
#define FT_RX_SCALE_FMASK      (0x3FFF)
#define FT_TX_SCALE            FT_GLOBAL(0x0018)
#define FT_TX_SCALE_WMASK      (0x3FFF)
#define FT_TX_SCALE_MASK       (0x3FFF)
#define FT_TX_SCALE_DEFAULT    (0x0000)
#define FT_TX_SCALE_FMASK      (0x3FFF)

/* Ftb Memory Address Constants */ 
#define ftb_iffta_base         (0x210000)
#define ftb_iffta_mask         (0xFFFFFFFF)
#define ftb_iffta_size         (0x4000)
#define ftb_iffta_default      (0x0000)
#define ftb_ifftb_base         (0x214000)
#define ftb_ifftb_mask         (0xFFFFFFFF)
#define ftb_ifftb_size         (0x4000)
#define ftb_ifftb_default      (0x0000)
#define ftb_ifftc_base         (0x218000)
#define ftb_ifftc_mask         (0xFFFFFFFF)
#define ftb_ifftc_size         (0x4000)
#define ftb_ifftc_default      (0x0000)
#define ftb_ffta_base          (0x21C000)
#define ftb_ffta_mask          (0xFFFFFFFF)
#define ftb_ffta_size          (0x4000)
#define ftb_ffta_default       (0x0000)
#define ftb_fftb_base          (0x220000)
#define ftb_fftb_mask          (0xFFFFFFFF)
#define ftb_fftb_size          (0x4000)
#define ftb_fftb_default       (0x0000)
#define ftb_fftc_base          (0x224000)
#define ftb_fftc_mask          (0xFFFFFFFF)
#define ftb_fftc_size          (0x4000)
#define ftb_fftc_default       (0x0000)

/* Ftb Global Address Constants */ 
#define ftb_global_base        (0x20D200)
#define FTB_GLOBAL(r)          (int)(ftb_global_base + (r))
#define ftb_global_size        (0x0200)

#define FTB_CTRL               FTB_GLOBAL(0x0000)
#define FTB_CTRL_WMASK         (0x38FFF)
#define FTB_CTRL_MASK          (0x38FFF)
#define FTB_CTRL_DEFAULT       (0x0000)
#define FTB_CTRL_FMASK         (0x38FFF)
#define FTB_IFFT_TSIZE         FTB_GLOBAL(0x0004)
#define FTB_IFFT_TSIZE_WMASK   (0x7777)
#define FTB_IFFT_TSIZE_MASK    (0x7777)
#define FTB_IFFT_TSIZE_DEFAULT (0x2222)
#define FTB_IFFT_TSIZE_FMASK   (0x7777)
#define FTB_RX_STATUS          FTB_GLOBAL(0x0008)
#define FTB_RX_STATUS_WMASK    (0x0000)
#define FTB_RX_STATUS_MASK     (0x01FF)
#define FTB_RX_STATUS_DEFAULT  (0x0080)
#define FTB_RX_STATUS_FMASK    (0x0000)
#define FTB_TX_STATUS          FTB_GLOBAL(0x000C)
#define FTB_TX_STATUS_WMASK    (0x0000)
#define FTB_TX_STATUS_MASK     (0x01FF)
#define FTB_TX_STATUS_DEFAULT  (0x0081)
#define FTB_TX_STATUS_FMASK    (0x0000)

/* Ilv Memory Address Constants */ 
#define ilv_dtb_base           (0x254000)
#define ilv_dtb_mask           (0xFFFFFFFF)
#define ilv_dtb_size           (0x2C00)
#define ilv_dtb_default        (0x0000)
#define ilv_dmetric_base       (0x257000)
#define ilv_dmetric_mask       (0xFFFFFFFF)
#define ilv_dmetric_size       (0x0800)
#define ilv_dmetric_default    (0x0000)


/* Qt Memory Address Constants */ 
#define qt_abgtn_base          (0x230000)
#define qt_abgtn_mask          (0xFFFFFFFF)
#define qt_abgtn_size          (0x4400)
#define qt_abgtn_default       (0x0000)
#define qt_txaegt_base         (0x238000)
#define qt_txaegt_mask         (0x70007)
#define qt_txaegt_size         (0x2200)
#define qt_txaegt_default      (0x0000)
#define qt_rxfdqm_base         (0x23C000)
#define qt_rxfdqm_mask         (0xFFFFFFFF)
#define qt_rxfdqm_size         (0x4000)
#define qt_rxfdqm_default      (0x0000)
#define qt_rxfdqe_base         (0x240000)
#define qt_rxfdqe_mask         (0x000F)
#define qt_rxfdqe_size         (0x4000)
#define qt_rxfdqe_default      (0x0000)
#define qt_mco_ma_base         (0x24E000)
#define qt_mco_ma_mask         (0xFFFFFFFF)
#define qt_mco_ma_size         (0x0100)
#define qt_mco_ma_default      (0x0000)
#define qt_mco_ff_base         (0x24E100)
#define qt_mco_ff_mask         (0xFFFFFFFF)
#define qt_mco_ff_size         (0x0100)
#define qt_mco_ff_default      (0x0000)
#define qt_mco_ex_base         (0x24E200)
#define qt_mco_ex_mask         (0x000F)
#define qt_mco_ex_size         (0x0100)
#define qt_mco_ex_default      (0x0000)
#define qt_xyt_base            (0x24E800)
#define qt_xyt_mask            (0xFFFFFFFF)
#define qt_xyt_size            (0x0500)
#define qt_xyt_default         (0x0000)
#define qt_spm_base            (0x24F000)
#define qt_spm_mask            (0x0000)
#define qt_spm_size            (0x0180)
#define qt_spm_default         (0x0000)
#define qt_npsp_base           (0x24F200)
#define qt_npsp_mask           (0x3FFFF)
#define qt_npsp_size           (0x0180)
#define qt_npsp_default        (0x0000)
#define qt_vdt_base            (0x24F400)
#define qt_vdt_mask            (0xFFFF)
#define qt_vdt_size            (0x00C0)
#define qt_vdt_default         (0x0000)
#define qt_fdqasph_base        (0x24F500)
#define qt_fdqasph_mask        (0x007F)
#define qt_fdqasph_size        (0x0060)
#define qt_fdqasph_default     (0x0000)
#define qt_fdqaspl_base        (0x24F800)
#define qt_fdqaspl_mask        (0xFFFFFFFF)
#define qt_fdqaspl_size        (0x0300)
#define qt_fdqaspl_default     (0x0000)
#define qt_noiseaccl_base      (0x250000)
#define qt_noiseaccl_mask      (0xFFFFFFFF)
#define qt_noiseaccl_size      (0x1000)
#define qt_noiseaccl_default   (0x0000)
#define qt_noiseacch_base      (0x251000)
#define qt_noiseacch_mask      (0xFFFF)
#define qt_noiseacch_size      (0x1000)
#define qt_noiseacch_default   (0x0000)
#define qt_qtxpram_base        (0x252000)
#define qt_qtxpram_mask        (0xFFFFFFFF)
#define qt_qtxpram_size        (0x0100)
#define qt_qtxpram_default     (0x0000)
#define qt_qrxpram_base        (0x252400)
#define qt_qrxpram_mask        (0xFFFFFFFF)
#define qt_qrxpram_size        (0x0100)
#define qt_qrxpram_default     (0x0000)
#define qt_rxfbt_base          (0x252500)
#define qt_rxfbt_mask          (0xFFFFFFFF)
#define qt_rxfbt_size          (0x0100)
#define qt_rxfbt_default       (0x0000)
#define qt_rxfdt_base          (0x252600)
#define qt_rxfdt_mask          (0xFF00FF00)
#define qt_rxfdt_size          (0x0200)
#define qt_rxfdt_default       (0x0000)

/* Qt Global Address Constants */ 
#define qt_global_base         (0x20CA00)
#define QT_GLOBAL(r)           (int)(qt_global_base + (r))
#define qt_global_size         (0x0100)

#define IT_ENABLE              QT_GLOBAL(0x0000)
#define IT_ENABLE_WMASK        (0x0001)
#define IT_ENABLE_MASK         (0x0001)
#define IT_ENABLE_DEFAULT      (0x0000)
#define IT_ENABLE_FMASK        (0x0001)
#define IR_ENABLE              QT_GLOBAL(0x0004)
#define IR_ENABLE_WMASK        (0x0001)
#define IR_ENABLE_MASK         (0x0001)
#define IR_ENABLE_DEFAULT      (0x0000)
#define IR_ENABLE_FMASK        (0x0001)
#define IR_NSC                 QT_GLOBAL(0x0008)
#define IR_NSC_WMASK           (0x0007)
#define IR_NSC_MASK            (0x0007)
#define IR_NSC_DEFAULT         (0x0000)
#define IR_NSC_FMASK           (0x0007)
#define IR_PRBS_CTRL           QT_GLOBAL(0x000C)
#define IR_PRBS_CTRL_WMASK     (0x0003)
#define IR_PRBS_CTRL_MASK      (0x0003)
#define IR_PRBS_CTRL_DEFAULT   (0x0000)
#define IR_PRBS_CTRL_FMASK     (0x0003)
#define IR_PRBS0               QT_GLOBAL(0x0010)
#define IR_PRBS0_WMASK         (0xFFFFFFFF)
#define IR_PRBS0_MASK          (0xFFFFFFFF)
#define IR_PRBS0_DEFAULT       (0x0000)
#define IR_PRBS0_FMASK         (0xFFFFFFFF)
#define IR_PRBS1               QT_GLOBAL(0x0014)
#define IR_PRBS1_WMASK         (0xFFFFFFFF)
#define IR_PRBS1_MASK          (0xFFFFFFFF)
#define IR_PRBS1_DEFAULT       (0x0000)
#define IR_PRBS1_FMASK         (0xFFFFFFFF)
#define I_ABGT_OFFSET          QT_GLOBAL(0x0018)
#define I_ABGT_OFFSET_WMASK    (0x1FFF1FFF)
#define I_ABGT_OFFSET_MASK     (0x1FFF1FFF)
#define I_ABGT_OFFSET_DEFAULT  (0x0000)
#define I_ABGT_OFFSET_FMASK    (0x1FFF1FFF)

/* Qt Qtxpram Address Constants */ 
#define qt_qtxpram_reg_base    (0x252000)
#define QT_QTXPRAM_REG(r)      (int)(qt_qtxpram_reg_base + (r))
#define qt_qtxpram_reg_size    (0x0100)

#define IT_CONFIG              QT_QTXPRAM_REG(0x0000)
#define IT_CONFIG_WMASK        (0x0077)
#define IT_CONFIG_MASK         (0x0077)
#define IT_CONFIG_DEFAULT      (0x0000)
#define IT_CONFIG_FMASK        (0x0077)
#define IT_TCM_CTRL            QT_QTXPRAM_REG(0x0004)
#define IT_TCM_CTRL_WMASK      (0x17FFFFF)
#define IT_TCM_CTRL_MASK       (0x17FFFFF)
#define IT_TCM_CTRL_DEFAULT    (0x0000)
#define IT_TCM_CTRL_FMASK      (0x17FFFFF)
#define IT_MISC                QT_QTXPRAM_REG(0x0008)
#define IT_MISC_WMASK          (0xFFFFF0)
#define IT_MISC_MASK           (0xFFFFF0)
#define IT_MISC_DEFAULT        (0x0000)
#define IT_MISC_FMASK          (0xFFFFF0)
#define IT_ACT_ADDR            QT_QTXPRAM_REG(0x000C)
#define IT_ACT_ADDR_WMASK      (0xFFF0FFF)
#define IT_ACT_ADDR_MASK       (0xFFF0FFF)
#define IT_ACT_ADDR_DEFAULT    (0x0000)
#define IT_ACT_ADDR_FMASK      (0xFFF0FFF)
#define IT_LP0_BITS            QT_QTXPRAM_REG(0x0010)
#define IT_LP0_BITS_WMASK      (0xFFFF)
#define IT_LP0_BITS_MASK       (0xFFFF)
#define IT_LP0_BITS_DEFAULT    (0x0000)
#define IT_LP0_BITS_FMASK      (0xFFFF)
#define IT_LP1_BITS            QT_QTXPRAM_REG(0x0014)
#define IT_LP1_BITS_WMASK      (0xFFFF)
#define IT_LP1_BITS_MASK       (0xFFFF)
#define IT_LP1_BITS_DEFAULT    (0x0000)
#define IT_LP1_BITS_FMASK      (0xFFFF)
#define IT_LP2_BITS            QT_QTXPRAM_REG(0x0018)
#define IT_LP2_BITS_WMASK      (0xFFFF)
#define IT_LP2_BITS_MASK       (0xFFFF)
#define IT_LP2_BITS_DEFAULT    (0x0000)
#define IT_LP2_BITS_FMASK      (0xFFFF)
#define IT_DUMMY               QT_QTXPRAM_REG(0x001C)
#define IT_DUMMY_WMASK         (0xFFFF)
#define IT_DUMMY_MASK          (0xFFFF)
#define IT_DUMMY_DEFAULT       (0x0000)
#define IT_DUMMY_FMASK         (0xFFFF)
#define IT_LP0_BIT_FIFO        QT_QTXPRAM_REG(0x0020)
#define IT_LP0_BIT_FIFO_WMASK  (0x07FF)
#define IT_LP0_BIT_FIFO_MASK   (0x07FF)
#define IT_LP0_BIT_FIFO_DEFAULT (0x0000)
#define IT_LP0_BIT_FIFO_FMASK  (0x07FF)
#define IT_LP1_BIT_FIFO        QT_QTXPRAM_REG(0x0024)
#define IT_LP1_BIT_FIFO_WMASK  (0x07FF)
#define IT_LP1_BIT_FIFO_MASK   (0x07FF)
#define IT_LP1_BIT_FIFO_DEFAULT (0x0000)
#define IT_LP1_BIT_FIFO_FMASK  (0x07FF)
#define IT_LP2_BIT_FIFO        QT_QTXPRAM_REG(0x0028)
#define IT_LP2_BIT_FIFO_WMASK  (0x07FF)
#define IT_LP2_BIT_FIFO_MASK   (0x07FF)
#define IT_LP2_BIT_FIFO_DEFAULT (0x0000)
#define IT_LP2_BIT_FIFO_FMASK  (0x07FF)
#define IT_PILOT               QT_QTXPRAM_REG(0x002C)
#define IT_PILOT_WMASK         (0xFFFFFFFF)
#define IT_PILOT_MASK          (0xFFFFFFFF)
#define IT_PILOT_DEFAULT       (0x0000)
#define IT_PILOT_FMASK         (0xFFFFFFFF)
#define IT_PTINDEX             QT_QTXPRAM_REG(0x0030)
#define IT_PTINDEX_WMASK       (0x7FFF)
#define IT_PTINDEX_MASK        (0x7FFF)
#define IT_PTINDEX_DEFAULT     (0x0000)
#define IT_PTINDEX_FMASK       (0x7FFF)
#define IT_PRBS                QT_QTXPRAM_REG(0x0034)
#define IT_PRBS_WMASK          (0xFFFFFFFF)
#define IT_PRBS_MASK           (0xFFFFFFFF)
#define IT_PRBS_DEFAULT        (0x0000)
#define IT_PRBS_FMASK          (0xFFFFFFFF)
#define IT_PRBS_MISC           QT_QTXPRAM_REG(0x0038)
#define IT_PRBS_MISC_WMASK     (0xFFFFFFF8)
#define IT_PRBS_MISC_MASK      (0xFFFFFFF8)
#define IT_PRBS_MISC_DEFAULT   (0x0000)
#define IT_PRBS_MISC_FMASK     (0xFFFFFFF8)
#define IT_PRBS_POLY           QT_QTXPRAM_REG(0x003C)
#define IT_PRBS_POLY_WMASK     (0xFFFFFFFF)
#define IT_PRBS_POLY_MASK      (0xFFFFFFFF)
#define IT_PRBS_POLY_DEFAULT   (0x0000)
#define IT_PRBS_POLY_FMASK     (0xFFFFFFFF)
#define IT_PRBS_DATA0          QT_QTXPRAM_REG(0x0040)
#define IT_PRBS_DATA0_WMASK    (0xFFFFFFFF)
#define IT_PRBS_DATA0_MASK     (0xFFFFFFFF)
#define IT_PRBS_DATA0_DEFAULT  (0x0000)
#define IT_PRBS_DATA0_FMASK    (0xFFFFFFFF)
#define IT_PRBS_DATA1          QT_QTXPRAM_REG(0x0044)
#define IT_PRBS_DATA1_WMASK    (0xFFFFFFFF)
#define IT_PRBS_DATA1_MASK     (0xFFFFFFFF)
#define IT_PRBS_DATA1_DEFAULT  (0x0000)
#define IT_PRBS_DATA1_FMASK    (0xFFFFFFFF)
#define IT_PRBS_DATA2          QT_QTXPRAM_REG(0x0048)
#define IT_PRBS_DATA2_WMASK    (0xFFFFFFFF)
#define IT_PRBS_DATA2_MASK     (0xFFFFFFFF)
#define IT_PRBS_DATA2_DEFAULT  (0x0000)
#define IT_PRBS_DATA2_FMASK    (0xFFFFFFFF)
#define IT_PRBS_DATA3          QT_QTXPRAM_REG(0x004C)
#define IT_PRBS_DATA3_WMASK    (0xFFFFFFFF)
#define IT_PRBS_DATA3_MASK     (0xFFFFFFFF)
#define IT_PRBS_DATA3_DEFAULT  (0x0000)
#define IT_PRBS_DATA3_FMASK    (0xFFFFFFFF)
#define IT_PRBS_DATA4          QT_QTXPRAM_REG(0x0050)
#define IT_PRBS_DATA4_WMASK    (0xFFFFFFFF)
#define IT_PRBS_DATA4_MASK     (0xFFFFFFFF)
#define IT_PRBS_DATA4_DEFAULT  (0x0000)
#define IT_PRBS_DATA4_FMASK    (0xFFFFFFFF)
#define IT_PRBS_DATA5          QT_QTXPRAM_REG(0x0054)
#define IT_PRBS_DATA5_WMASK    (0xFFFFFFFF)
#define IT_PRBS_DATA5_MASK     (0xFFFFFFFF)
#define IT_PRBS_DATA5_DEFAULT  (0x0000)
#define IT_PRBS_DATA5_FMASK    (0xFFFFFFFF)
#define IT_PRBS_DATA6          QT_QTXPRAM_REG(0x0058)
#define IT_PRBS_DATA6_WMASK    (0xFFFFFFFF)
#define IT_PRBS_DATA6_MASK     (0xFFFFFFFF)
#define IT_PRBS_DATA6_DEFAULT  (0x0000)
#define IT_PRBS_DATA6_FMASK    (0xFFFFFFFF)
#define IT_PRBS_DATA7          QT_QTXPRAM_REG(0x005C)
#define IT_PRBS_DATA7_WMASK    (0xFFFFFFFF)
#define IT_PRBS_DATA7_MASK     (0xFFFFFFFF)
#define IT_PRBS_DATA7_DEFAULT  (0x0000)
#define IT_PRBS_DATA7_FMASK    (0xFFFFFFFF)
#define IT_REF_GAIN            QT_QTXPRAM_REG(0x0060)
#define IT_REF_GAIN_WMASK      (0x7FFF)
#define IT_REF_GAIN_MASK       (0x7FFF)
#define IT_REF_GAIN_DEFAULT    (0x0000)
#define IT_REF_GAIN_FMASK      (0x7FFF)
#define IT_NYQ_TONE_DATA       QT_QTXPRAM_REG(0x0064)
#define IT_NYQ_TONE_DATA_WMASK (0xFFFFFFFF)
#define IT_NYQ_TONE_DATA_MASK  (0xFFFFFFFF)
#define IT_NYQ_TONE_DATA_DEFAULT (0x0000)
#define IT_NYQ_TONE_DATA_FMASK (0xFFFFFFFF)
#define IT_TXCG_0              QT_QTXPRAM_REG(0x0068)
#define IT_TXCG_0_WMASK        (0x7FFFF)
#define IT_TXCG_0_MASK         (0x7FFFF)
#define IT_TXCG_0_DEFAULT      (0x0000)
#define IT_TXCG_0_FMASK        (0x7FFFF)
#define IT_TXCG_1              QT_QTXPRAM_REG(0x006C)
#define IT_TXCG_1_WMASK        (0x7FFFF)
#define IT_TXCG_1_MASK         (0x7FFFF)
#define IT_TXCG_1_DEFAULT      (0x0000)
#define IT_TXCG_1_FMASK        (0x7FFFF)
#define IT_TXCG_2              QT_QTXPRAM_REG(0x0070)
#define IT_TXCG_2_WMASK        (0x7FFFF)
#define IT_TXCG_2_MASK         (0x7FFFF)
#define IT_TXCG_2_DEFAULT      (0x0000)
#define IT_TXCG_2_FMASK        (0x7FFFF)
#define IT_TXCG_3              QT_QTXPRAM_REG(0x0074)
#define IT_TXCG_3_WMASK        (0x7FFFF)
#define IT_TXCG_3_MASK         (0x7FFFF)
#define IT_TXCG_3_DEFAULT      (0x0000)
#define IT_TXCG_3_FMASK        (0x7FFFF)
#define IT_TXCG_4              QT_QTXPRAM_REG(0x0078)
#define IT_TXCG_4_WMASK        (0x7FFFF)
#define IT_TXCG_4_MASK         (0x7FFFF)
#define IT_TXCG_4_DEFAULT      (0x0000)
#define IT_TXCG_4_FMASK        (0x7FFFF)
#define IT_TXCG_5              QT_QTXPRAM_REG(0x007C)
#define IT_TXCG_5_WMASK        (0x7FFFF)
#define IT_TXCG_5_MASK         (0x7FFFF)
#define IT_TXCG_5_DEFAULT      (0x0000)
#define IT_TXCG_5_FMASK        (0x7FFFF)
#define IT_TXCG_6              QT_QTXPRAM_REG(0x0080)
#define IT_TXCG_6_WMASK        (0x7FFFF)
#define IT_TXCG_6_MASK         (0x7FFFF)
#define IT_TXCG_6_DEFAULT      (0x0000)
#define IT_TXCG_6_FMASK        (0x7FFFF)
#define IT_TXCG_7              QT_QTXPRAM_REG(0x0084)
#define IT_TXCG_7_WMASK        (0x7FFFF)
#define IT_TXCG_7_MASK         (0x7FFFF)
#define IT_TXCG_7_DEFAULT      (0x0000)
#define IT_TXCG_7_FMASK        (0x7FFFF)
#define IT_TXCG_8              QT_QTXPRAM_REG(0x0088)
#define IT_TXCG_8_WMASK        (0x7FFFF)
#define IT_TXCG_8_MASK         (0x7FFFF)
#define IT_TXCG_8_DEFAULT      (0x0000)
#define IT_TXCG_8_FMASK        (0x7FFFF)
#define IT_TXCG_9              QT_QTXPRAM_REG(0x008C)
#define IT_TXCG_9_WMASK        (0x7FFFF)
#define IT_TXCG_9_MASK         (0x7FFFF)
#define IT_TXCG_9_DEFAULT      (0x0000)
#define IT_TXCG_9_FMASK        (0x7FFFF)
#define IT_TXCG_10             QT_QTXPRAM_REG(0x0090)
#define IT_TXCG_10_WMASK       (0x7FFFF)
#define IT_TXCG_10_MASK        (0x7FFFF)
#define IT_TXCG_10_DEFAULT     (0x0000)
#define IT_TXCG_10_FMASK       (0x7FFFF)
#define IT_TXCG_11             QT_QTXPRAM_REG(0x0094)
#define IT_TXCG_11_WMASK       (0x7FFFF)
#define IT_TXCG_11_MASK        (0x7FFFF)
#define IT_TXCG_11_DEFAULT     (0x0000)
#define IT_TXCG_11_FMASK       (0x7FFFF)
#define IT_TXCG_12             QT_QTXPRAM_REG(0x0098)
#define IT_TXCG_12_WMASK       (0x7FFFF)
#define IT_TXCG_12_MASK        (0x7FFFF)
#define IT_TXCG_12_DEFAULT     (0x0000)
#define IT_TXCG_12_FMASK       (0x7FFFF)
#define IT_TXCG_13             QT_QTXPRAM_REG(0x009C)
#define IT_TXCG_13_WMASK       (0x7FFFF)
#define IT_TXCG_13_MASK        (0x7FFFF)
#define IT_TXCG_13_DEFAULT     (0x0000)
#define IT_TXCG_13_FMASK       (0x7FFFF)
#define IT_TXCG_14             QT_QTXPRAM_REG(0x00A0)
#define IT_TXCG_14_WMASK       (0x7FFFF)
#define IT_TXCG_14_MASK        (0x7FFFF)
#define IT_TXCG_14_DEFAULT     (0x0000)
#define IT_TXCG_14_FMASK       (0x7FFFF)
#define IT_TXCG_15             QT_QTXPRAM_REG(0x00A4)
#define IT_TXCG_15_WMASK       (0x7FFFF)
#define IT_TXCG_15_MASK        (0x7FFFF)
#define IT_TXCG_15_DEFAULT     (0x0000)
#define IT_TXCG_15_FMASK       (0x7FFFF)
#define IT_IFFTZ_RNG0          QT_QTXPRAM_REG(0x00A8)
#define IT_IFFTZ_RNG0_WMASK    (0x1FFFFFF)
#define IT_IFFTZ_RNG0_MASK     (0x1FFFFFF)
#define IT_IFFTZ_RNG0_DEFAULT  (0x0000)
#define IT_IFFTZ_RNG0_FMASK    (0x1FFFFFF)
#define IT_IFFTZ_RNG1          QT_QTXPRAM_REG(0x00AC)
#define IT_IFFTZ_RNG1_WMASK    (0x1FFFFFF)
#define IT_IFFTZ_RNG1_MASK     (0x1FFFFFF)
#define IT_IFFTZ_RNG1_DEFAULT  (0x0000)
#define IT_IFFTZ_RNG1_FMASK    (0x1FFFFFF)
#define IT_IFFTZ_RNG2          QT_QTXPRAM_REG(0x00B0)
#define IT_IFFTZ_RNG2_WMASK    (0x1FFFFFF)
#define IT_IFFTZ_RNG2_MASK     (0x1FFFFFF)
#define IT_IFFTZ_RNG2_DEFAULT  (0x0000)
#define IT_IFFTZ_RNG2_FMASK    (0x1FFFFFF)
#define IT_IFFTZ_RNG3          QT_QTXPRAM_REG(0x00B4)
#define IT_IFFTZ_RNG3_WMASK    (0x1FFFFFF)
#define IT_IFFTZ_RNG3_MASK     (0x1FFFFFF)
#define IT_IFFTZ_RNG3_DEFAULT  (0x0000)
#define IT_IFFTZ_RNG3_FMASK    (0x1FFFFFF)
#define IT_IFFTZ_RNG4          QT_QTXPRAM_REG(0x00B8)
#define IT_IFFTZ_RNG4_WMASK    (0x1FFFFFF)
#define IT_IFFTZ_RNG4_MASK     (0x1FFFFFF)
#define IT_IFFTZ_RNG4_DEFAULT  (0x0000)
#define IT_IFFTZ_RNG4_FMASK    (0x1FFFFFF)
#define IT_IFFTZ_RNG5          QT_QTXPRAM_REG(0x00BC)
#define IT_IFFTZ_RNG5_WMASK    (0x1FFFFFF)
#define IT_IFFTZ_RNG5_MASK     (0x1FFFFFF)
#define IT_IFFTZ_RNG5_DEFAULT  (0x0000)
#define IT_IFFTZ_RNG5_FMASK    (0x1FFFFFF)
#define IT_TONE0_DATA          QT_QTXPRAM_REG(0x00C0)
#define IT_TONE0_DATA_WMASK    (0xFFFFFFFF)
#define IT_TONE0_DATA_MASK     (0xFFFFFFFF)
#define IT_TONE0_DATA_DEFAULT  (0x0000)
#define IT_TONE0_DATA_FMASK    (0xFFFFFFFF)
#define IT_DCI_CTRL            QT_QTXPRAM_REG(0x00C4)
#define IT_DCI_CTRL_WMASK      (0x1FFFFFF)
#define IT_DCI_CTRL_MASK       (0x1FFFFFF)
#define IT_DCI_CTRL_DEFAULT    (0x0000)
#define IT_DCI_CTRL_FMASK      (0x1FFFFFF)

/* Qt Qrxpram Address Constants */ 
#define qt_qrxpram_reg_base    (0x252400)
#define QT_QRXPRAM_REG(r)      (int)(qt_qrxpram_reg_base + (r))
#define qt_qrxpram_reg_size    (0x0100)

#define IR_CONFIG              QT_QRXPRAM_REG(0x0000)
#define IR_CONFIG_WMASK        (0x0FFF)
#define IR_CONFIG_MASK         (0x0FFF)
#define IR_CONFIG_DEFAULT      (0x0000)
#define IR_CONFIG_FMASK        (0x0FFF)
#define IR_TCM_CTRL            QT_QRXPRAM_REG(0x0004)
#define IR_TCM_CTRL_WMASK      (0x17FFFFF)
#define IR_TCM_CTRL_MASK       (0x17FFFFF)
#define IR_TCM_CTRL_DEFAULT    (0x0000)
#define IR_TCM_CTRL_FMASK      (0x17FFFFF)
#define IR_MISC                QT_QRXPRAM_REG(0x0008)
#define IR_MISC_WMASK          (0x7FEFFFE0)
#define IR_MISC_MASK           (0x7FEFFFE0)
#define IR_MISC_DEFAULT        (0x0000)
#define IR_MISC_FMASK          (0x7FEFFFE0)
#define IR_ACT_ADDR            QT_QRXPRAM_REG(0x000C)
#define IR_ACT_ADDR_WMASK      (0xFFF0FFF)
#define IR_ACT_ADDR_MASK       (0xFFF0FFF)
#define IR_ACT_ADDR_DEFAULT    (0x0000)
#define IR_ACT_ADDR_FMASK      (0xFFF0FFF)
#define IR_LP0_BITS            QT_QRXPRAM_REG(0x0010)
#define IR_LP0_BITS_WMASK      (0xFFFF)
#define IR_LP0_BITS_MASK       (0xFFFF)
#define IR_LP0_BITS_DEFAULT    (0x0000)
#define IR_LP0_BITS_FMASK      (0xFFFF)
#define IR_LP1_BITS            QT_QRXPRAM_REG(0x0014)
#define IR_LP1_BITS_WMASK      (0xFFFF)
#define IR_LP1_BITS_MASK       (0xFFFF)
#define IR_LP1_BITS_DEFAULT    (0x0000)
#define IR_LP1_BITS_FMASK      (0xFFFF)
#define IR_LP2_BITS            QT_QRXPRAM_REG(0x0018)
#define IR_LP2_BITS_WMASK      (0xFFFF)
#define IR_LP2_BITS_MASK       (0xFFFF)
#define IR_LP2_BITS_DEFAULT    (0x0000)
#define IR_LP2_BITS_FMASK      (0xFFFF)
#define IR_DUMMY               QT_QRXPRAM_REG(0x001C)
#define IR_DUMMY_WMASK         (0xFFFF)
#define IR_DUMMY_MASK          (0xFFFF)
#define IR_DUMMY_DEFAULT       (0x0000)
#define IR_DUMMY_FMASK         (0xFFFF)
#define IR_LP0_BIT_FIFO        QT_QRXPRAM_REG(0x0020)
#define IR_LP0_BIT_FIFO_WMASK  (0x07FF)
#define IR_LP0_BIT_FIFO_MASK   (0x07FF)
#define IR_LP0_BIT_FIFO_DEFAULT (0x0000)
#define IR_LP0_BIT_FIFO_FMASK  (0x07FF)
#define IR_LP1_BIT_FIFO        QT_QRXPRAM_REG(0x0024)
#define IR_LP1_BIT_FIFO_WMASK  (0x07FF)
#define IR_LP1_BIT_FIFO_MASK   (0x07FF)
#define IR_LP1_BIT_FIFO_DEFAULT (0x0000)
#define IR_LP1_BIT_FIFO_FMASK  (0x07FF)
#define IR_LP2_BIT_FIFO        QT_QRXPRAM_REG(0x0028)
#define IR_LP2_BIT_FIFO_WMASK  (0x07FF)
#define IR_LP2_BIT_FIFO_MASK   (0x07FF)
#define IR_LP2_BIT_FIFO_DEFAULT (0x0000)
#define IR_LP2_BIT_FIFO_FMASK  (0x07FF)
#define IR_DEROT_MISC          QT_QRXPRAM_REG(0x002C)
#define IR_DEROT_MISC_WMASK    (0x7FFF)
#define IR_DEROT_MISC_MASK     (0x7FFF)
#define IR_DEROT_MISC_DEFAULT  (0x0000)
#define IR_DEROT_MISC_FMASK    (0x7FFF)
#define IR_DEROT_POLY          QT_QRXPRAM_REG(0x0030)
#define IR_DEROT_POLY_WMASK    (0xFFFFFFFF)
#define IR_DEROT_POLY_MASK     (0xFFFFFFFF)
#define IR_DEROT_POLY_DEFAULT  (0x0000)
#define IR_DEROT_POLY_FMASK    (0xFFFFFFFF)
#define IR_FD_RNG0             QT_QRXPRAM_REG(0x0034)
#define IR_FD_RNG0_WMASK       (0xBFFFFFFF)
#define IR_FD_RNG0_MASK        (0xBFFFFFFF)
#define IR_FD_RNG0_DEFAULT     (0x0000)
#define IR_FD_RNG0_FMASK       (0xBFFFFFFF)
#define IR_FD_RNG1             QT_QRXPRAM_REG(0x0038)
#define IR_FD_RNG1_WMASK       (0xBFFFFFFF)
#define IR_FD_RNG1_MASK        (0xBFFFFFFF)
#define IR_FD_RNG1_DEFAULT     (0x0000)
#define IR_FD_RNG1_FMASK       (0xBFFFFFFF)
#define IR_FD_RNG1_BASE        QT_QRXPRAM_REG(0x003C)
#define IR_FD_RNG1_BASE_WMASK  (0x0FFF)
#define IR_FD_RNG1_BASE_MASK   (0x0FFF)
#define IR_FD_RNG1_BASE_DEFAULT (0x0000)
#define IR_FD_RNG1_BASE_FMASK  (0x0FFF)
#define IR_NPR_IIBRAM          QT_QRXPRAM_REG(0x0040)
#define IR_NPR_IIBRAM_WMASK    (0x8000FFFF)
#define IR_NPR_IIBRAM_MASK     (0x8000FFFF)
#define IR_NPR_IIBRAM_DEFAULT  (0x0000)
#define IR_NPR_IIBRAM_FMASK    (0x8000FFFF)
#define IR_QUAD0               QT_QRXPRAM_REG(0x0044)
#define IR_QUAD0_WMASK         (0xFFFFFFFF)
#define IR_QUAD0_MASK          (0xFFFFFFFF)
#define IR_QUAD0_DEFAULT       (0x0000)
#define IR_QUAD0_FMASK         (0xFFFFFFFF)
#define IR_QUAD1               QT_QRXPRAM_REG(0x0048)
#define IR_QUAD1_WMASK         (0xFFFFFFFF)
#define IR_QUAD1_MASK          (0xFFFFFFFF)
#define IR_QUAD1_DEFAULT       (0x0000)
#define IR_QUAD1_FMASK         (0xFFFFFFFF)
#define IR_SLOWDOWN            QT_QRXPRAM_REG(0x004C)
#define IR_SLOWDOWN_WMASK      (0x00FF)
#define IR_SLOWDOWN_MASK       (0x00FF)
#define IR_SLOWDOWN_DEFAULT    (0x0000)
#define IR_SLOWDOWN_FMASK      (0x00FF)
#define IR_PTINDEX             QT_QRXPRAM_REG(0x0050)
#define IR_PTINDEX_WMASK       (0x1FFF)
#define IR_PTINDEX_MASK        (0x1FFF)
#define IR_PTINDEX_DEFAULT     (0x0000)
#define IR_PTINDEX_FMASK       (0x1FFF)
#define IR_PILOT               QT_QRXPRAM_REG(0x0054)
#define IR_PILOT_WMASK         (0xFFFFFFFF)
#define IR_PILOT_MASK          (0xFFFFFFFF)
#define IR_PILOT_DEFAULT       (0x0000)
#define IR_PILOT_FMASK         (0xFFFFFFFF)
#define IR_FDQADAPT            QT_QRXPRAM_REG(0x0058)
#define IR_FDQADAPT_WMASK      (0x73FF)
#define IR_FDQADAPT_MASK       (0x73FF)
#define IR_FDQADAPT_DEFAULT    (0x0000)
#define IR_FDQADAPT_FMASK      (0x73FF)
#define IR_VECPOW_L            QT_QRXPRAM_REG(0x005C)
#define IR_VECPOW_L_WMASK      (0xFFFFFFFF)
#define IR_VECPOW_L_MASK       (0xFFFFFFFF)
#define IR_VECPOW_L_DEFAULT    (0x0000)
#define IR_VECPOW_L_FMASK      (0xFFFFFFFF)
#define IR_VECPOW_H            QT_QRXPRAM_REG(0x0060)
#define IR_VECPOW_H_WMASK      (0x03FF)
#define IR_VECPOW_H_MASK       (0x03FF)
#define IR_VECPOW_H_DEFAULT    (0x0000)
#define IR_VECPOW_H_FMASK      (0x03FF)
#define IR_RMETRIC_CTL         QT_QRXPRAM_REG(0x0064)
#define IR_RMETRIC_CTL_WMASK   (0x001F)
#define IR_RMETRIC_CTL_MASK    (0x001F)
#define IR_RMETRIC_CTL_DEFAULT (0x0000)
#define IR_RMETRIC_CTL_FMASK   (0x001F)
#define IR_RMETRIC_VAL         QT_QRXPRAM_REG(0x0068)
#define IR_RMETRIC_VAL_WMASK   (0x00FF)
#define IR_RMETRIC_VAL_MASK    (0x00FF)
#define IR_RMETRIC_VAL_DEFAULT (0x0000)
#define IR_RMETRIC_VAL_FMASK   (0x00FF)
#define IR_RXCG_0              QT_QRXPRAM_REG(0x006C)
#define IR_RXCG_0_WMASK        (0x7FFFF)
#define IR_RXCG_0_MASK         (0x7FFFF)
#define IR_RXCG_0_DEFAULT      (0x0000)
#define IR_RXCG_0_FMASK        (0x7FFFF)
#define IR_RXCG_1              QT_QRXPRAM_REG(0x0070)
#define IR_RXCG_1_WMASK        (0x7FFFF)
#define IR_RXCG_1_MASK         (0x7FFFF)
#define IR_RXCG_1_DEFAULT      (0x0000)
#define IR_RXCG_1_FMASK        (0x7FFFF)
#define IR_RXCG_2              QT_QRXPRAM_REG(0x0074)
#define IR_RXCG_2_WMASK        (0x7FFFF)
#define IR_RXCG_2_MASK         (0x7FFFF)
#define IR_RXCG_2_DEFAULT      (0x0000)
#define IR_RXCG_2_FMASK        (0x7FFFF)
#define IR_RXCG_3              QT_QRXPRAM_REG(0x0078)
#define IR_RXCG_3_WMASK        (0x7FFFF)
#define IR_RXCG_3_MASK         (0x7FFFF)
#define IR_RXCG_3_DEFAULT      (0x0000)
#define IR_RXCG_3_FMASK        (0x7FFFF)
#define IR_RXCG_4              QT_QRXPRAM_REG(0x007C)
#define IR_RXCG_4_WMASK        (0x7FFFF)
#define IR_RXCG_4_MASK         (0x7FFFF)
#define IR_RXCG_4_DEFAULT      (0x0000)
#define IR_RXCG_4_FMASK        (0x7FFFF)
#define IR_RXCG_5              QT_QRXPRAM_REG(0x0080)
#define IR_RXCG_5_WMASK        (0x7FFFF)
#define IR_RXCG_5_MASK         (0x7FFFF)
#define IR_RXCG_5_DEFAULT      (0x0000)
#define IR_RXCG_5_FMASK        (0x7FFFF)
#define IR_RXCG_6              QT_QRXPRAM_REG(0x0084)
#define IR_RXCG_6_WMASK        (0x7FFFF)
#define IR_RXCG_6_MASK         (0x7FFFF)
#define IR_RXCG_6_DEFAULT      (0x0000)
#define IR_RXCG_6_FMASK        (0x7FFFF)
#define IR_RXCG_7              QT_QRXPRAM_REG(0x0088)
#define IR_RXCG_7_WMASK        (0x7FFFF)
#define IR_RXCG_7_MASK         (0x7FFFF)
#define IR_RXCG_7_DEFAULT      (0x0000)
#define IR_RXCG_7_FMASK        (0x7FFFF)
#define IR_RXCG_8              QT_QRXPRAM_REG(0x008C)
#define IR_RXCG_8_WMASK        (0x7FFFF)
#define IR_RXCG_8_MASK         (0x7FFFF)
#define IR_RXCG_8_DEFAULT      (0x0000)
#define IR_RXCG_8_FMASK        (0x7FFFF)
#define IR_RXCG_9              QT_QRXPRAM_REG(0x0090)
#define IR_RXCG_9_WMASK        (0x7FFFF)
#define IR_RXCG_9_MASK         (0x7FFFF)
#define IR_RXCG_9_DEFAULT      (0x0000)
#define IR_RXCG_9_FMASK        (0x7FFFF)
#define IR_RXCG_10             QT_QRXPRAM_REG(0x0094)
#define IR_RXCG_10_WMASK       (0x7FFFF)
#define IR_RXCG_10_MASK        (0x7FFFF)
#define IR_RXCG_10_DEFAULT     (0x0000)
#define IR_RXCG_10_FMASK       (0x7FFFF)
#define IR_RXCG_11             QT_QRXPRAM_REG(0x0098)
#define IR_RXCG_11_WMASK       (0x7FFFF)
#define IR_RXCG_11_MASK        (0x7FFFF)
#define IR_RXCG_11_DEFAULT     (0x0000)
#define IR_RXCG_11_FMASK       (0x7FFFF)
#define IR_RXCG_12             QT_QRXPRAM_REG(0x009C)
#define IR_RXCG_12_WMASK       (0x7FFFF)
#define IR_RXCG_12_MASK        (0x7FFFF)
#define IR_RXCG_12_DEFAULT     (0x0000)
#define IR_RXCG_12_FMASK       (0x7FFFF)
#define IR_RXCG_13             QT_QRXPRAM_REG(0x00A0)
#define IR_RXCG_13_WMASK       (0x7FFFF)
#define IR_RXCG_13_MASK        (0x7FFFF)
#define IR_RXCG_13_DEFAULT     (0x0000)
#define IR_RXCG_13_FMASK       (0x7FFFF)
#define IR_RXCG_14             QT_QRXPRAM_REG(0x00A4)
#define IR_RXCG_14_WMASK       (0x7FFFF)
#define IR_RXCG_14_MASK        (0x7FFFF)
#define IR_RXCG_14_DEFAULT     (0x0000)
#define IR_RXCG_14_FMASK       (0x7FFFF)
#define IR_RXCG_15             QT_QRXPRAM_REG(0x00A8)
#define IR_RXCG_15_WMASK       (0x7FFFF)
#define IR_RXCG_15_MASK        (0x7FFFF)
#define IR_RXCG_15_DEFAULT     (0x0000)
#define IR_RXCG_15_FMASK       (0x7FFFF)

/* Qtp Memory Address Constants */ 
#define qtp_ibat_base          (0x244000)
#define qtp_ibat_mask          (0xF0F0F0F)
#define qtp_ibat_size          (0x1000)
#define qtp_ibat_default       (0x0000)
#define qtp_igst_base          (0x246000)
#define qtp_igst_mask          (0xFFFFFFFF)
#define qtp_igst_size          (0x2000)
#define qtp_igst_default       (0x0000)
#define qtp_iegt_base          (0x248000)
#define qtp_iegt_mask          (0xF0F0F0F)
#define qtp_iegt_size          (0x1000)
#define qtp_iegt_default       (0x0000)
#define qtp_itot_base          (0x24A000)
#define qtp_itot_mask          (0xFFF0FFF)
#define qtp_itot_size          (0x2000)
#define qtp_itot_default       (0x0000)
#define qtp_ifbt_base          (0x24C000)
#define qtp_ifbt_mask          (0xFFF0FFF)
#define qtp_ifbt_size          (0x0080)
#define qtp_ifbt_default       (0x0000)
#define qtp_txpram_base        (0x252800)
#define qtp_txpram_mask        (0xFFFFFFFF)
#define qtp_txpram_size        (0x0040)
#define qtp_txpram_default     (0x0000)
#define qtp_rxpram_base        (0x252840)
#define qtp_rxpram_mask        (0xFFFFFFFF)
#define qtp_rxpram_size        (0x0040)
#define qtp_rxpram_default     (0x0000)

/* Qtp Global Address Constants */ 
#define qtp_global_base        (0x20CB00)
#define QTP_GLOBAL(r)          (int)(qtp_global_base + (r))
#define qtp_global_size        (0x0100)

#define QTP_CONFIG             QTP_GLOBAL(0x0000)
#define QTP_CONFIG_WMASK       (0x0007)
#define QTP_CONFIG_MASK        (0x0007)
#define QTP_CONFIG_DEFAULT     (0x0000)
#define QTP_CONFIG_FMASK       (0x0007)
#define QTP_STATUS             QTP_GLOBAL(0x0004)
#define QTP_STATUS_WMASK       (0x0003)
#define QTP_STATUS_MASK        (0x0003)
#define QTP_STATUS_DEFAULT     (0x0000)
#define QTP_STATUS_FMASK       (0x0000)
#define QTP_TX_PRBS_DATA0      QTP_GLOBAL(0x0008)
#define QTP_TX_PRBS_DATA0_WMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA0_MASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA0_DEFAULT (0x0000)
#define QTP_TX_PRBS_DATA0_FMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA1      QTP_GLOBAL(0x000C)
#define QTP_TX_PRBS_DATA1_WMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA1_MASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA1_DEFAULT (0x0000)
#define QTP_TX_PRBS_DATA1_FMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA2      QTP_GLOBAL(0x0010)
#define QTP_TX_PRBS_DATA2_WMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA2_MASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA2_DEFAULT (0x0000)
#define QTP_TX_PRBS_DATA2_FMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA3      QTP_GLOBAL(0x0014)
#define QTP_TX_PRBS_DATA3_WMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA3_MASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA3_DEFAULT (0x0000)
#define QTP_TX_PRBS_DATA3_FMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA4      QTP_GLOBAL(0x0018)
#define QTP_TX_PRBS_DATA4_WMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA4_MASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA4_DEFAULT (0x0000)
#define QTP_TX_PRBS_DATA4_FMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA5      QTP_GLOBAL(0x001C)
#define QTP_TX_PRBS_DATA5_WMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA5_MASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA5_DEFAULT (0x0000)
#define QTP_TX_PRBS_DATA5_FMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA6      QTP_GLOBAL(0x0020)
#define QTP_TX_PRBS_DATA6_WMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA6_MASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA6_DEFAULT (0x0000)
#define QTP_TX_PRBS_DATA6_FMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA7      QTP_GLOBAL(0x0024)
#define QTP_TX_PRBS_DATA7_WMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA7_MASK (0xFFFFFFFF)
#define QTP_TX_PRBS_DATA7_DEFAULT (0x0000)
#define QTP_TX_PRBS_DATA7_FMASK (0xFFFFFFFF)

/* Qtp Txpram Address Constants */ 
#define qtp_txpram_reg_base    (0x252800)
#define QTP_TXPRAM_REG(r)      (int)(qtp_txpram_reg_base + (r))
#define qtp_txpram_reg_size    (0x0100)

#define QTP_TX_CTRL            QTP_TXPRAM_REG(0x0000)
#define QTP_TX_CTRL_WMASK      (0x3FFF)
#define QTP_TX_CTRL_MASK       (0x3FFF)
#define QTP_TX_CTRL_DEFAULT    (0x0000)
#define QTP_TX_CTRL_FMASK      (0x3FFF)
#define QTP_TXTC_CTRL          QTP_TXPRAM_REG(0x0004)
#define QTP_TXTC_CTRL_WMASK    (0x3FFFFFFF)
#define QTP_TXTC_CTRL_MASK     (0x3FFFFFFF)
#define QTP_TXTC_CTRL_DEFAULT  (0x0000)
#define QTP_TXTC_CTRL_FMASK    (0x3FFFFFFF)
#define QTP_TXTC_TOT_AD        QTP_TXPRAM_REG(0x0008)
#define QTP_TXTC_TOT_AD_WMASK  (0xFFFFFF)
#define QTP_TXTC_TOT_AD_MASK   (0xFFFFFF)
#define QTP_TXTC_TOT_AD_DEFAULT (0x0000)
#define QTP_TXTC_TOT_AD_FMASK  (0xFFFFFF)
#define QTP_TXTC_ACT_AD        QTP_TXPRAM_REG(0x000C)
#define QTP_TXTC_ACT_AD_WMASK  (0xFFFFFF)
#define QTP_TXTC_ACT_AD_MASK   (0xFFFFFF)
#define QTP_TXTC_ACT_AD_DEFAULT (0x0000)
#define QTP_TXTC_ACT_AD_FMASK  (0xFFFFFF)
#define QTP_TX_PRBS            QTP_TXPRAM_REG(0x0010)
#define QTP_TX_PRBS_WMASK      (0xFFFFFFFF)
#define QTP_TX_PRBS_MASK       (0xFFFFFFFF)
#define QTP_TX_PRBS_DEFAULT    (0x0000)
#define QTP_TX_PRBS_FMASK      (0xFFFFFFFF)
#define QTP_TX_PRBS_MISC       QTP_TXPRAM_REG(0x0014)
#define QTP_TX_PRBS_MISC_WMASK (0xFFFFFDF0)
#define QTP_TX_PRBS_MISC_MASK  (0xFFFFFDF0)
#define QTP_TX_PRBS_MISC_DEFAULT (0x0000)
#define QTP_TX_PRBS_MISC_FMASK (0xFFFFFDF0)
#define QTP_TX_PRBS_POLY       QTP_TXPRAM_REG(0x0018)
#define QTP_TX_PRBS_POLY_WMASK (0xFFFFFFFF)
#define QTP_TX_PRBS_POLY_MASK  (0xFFFFFFFF)
#define QTP_TX_PRBS_POLY_DEFAULT (0x0000)
#define QTP_TX_PRBS_POLY_FMASK (0xFFFFFFFF)

/* Qtp Rxpram Address Constants */ 
#define qtp_rxpram_reg_base    (0x252840)
#define QTP_RXPRAM_REG(r)      (int)(qtp_rxpram_reg_base + (r))
#define qtp_rxpram_reg_size    (0x0100)

#define QTP_RX_CTRL            QTP_RXPRAM_REG(0x0000)
#define QTP_RX_CTRL_WMASK      (0x3FFF)
#define QTP_RX_CTRL_MASK       (0x3FFF)
#define QTP_RX_CTRL_DEFAULT    (0x0000)
#define QTP_RX_CTRL_FMASK      (0x3FFF)
#define QTP_RXTC_CTRL          QTP_RXPRAM_REG(0x0004)
#define QTP_RXTC_CTRL_WMASK    (0x3FFFFFFF)
#define QTP_RXTC_CTRL_MASK     (0x3FFFFFFF)
#define QTP_RXTC_CTRL_DEFAULT  (0x0000)
#define QTP_RXTC_CTRL_FMASK    (0x3FFFFFFF)
#define QTP_RXTC_TOT_AD        QTP_RXPRAM_REG(0x0008)
#define QTP_RXTC_TOT_AD_WMASK  (0xFFFFFF)
#define QTP_RXTC_TOT_AD_MASK   (0xFFFFFF)
#define QTP_RXTC_TOT_AD_DEFAULT (0x0000)
#define QTP_RXTC_TOT_AD_FMASK  (0xFFFFFF)
#define QTP_RXTC_ACT_AD        QTP_RXPRAM_REG(0x000C)
#define QTP_RXTC_ACT_AD_WMASK  (0xFFFFFF)
#define QTP_RXTC_ACT_AD_MASK   (0xFFFFFF)
#define QTP_RXTC_ACT_AD_DEFAULT (0x0000)
#define QTP_RXTC_ACT_AD_FMASK  (0xFFFFFF)
#define QTP_RX_PRBS            QTP_RXPRAM_REG(0x0010)
#define QTP_RX_PRBS_WMASK      (0xFFFFFFFF)
#define QTP_RX_PRBS_MASK       (0xFFFFFFFF)
#define QTP_RX_PRBS_DEFAULT    (0x0000)
#define QTP_RX_PRBS_FMASK      (0xFFFFFFFF)
#define QTP_RX_PRBS_MISC       QTP_RXPRAM_REG(0x0014)
#define QTP_RX_PRBS_MISC_WMASK (0x7DF0)
#define QTP_RX_PRBS_MISC_MASK  (0x7DF0)
#define QTP_RX_PRBS_MISC_DEFAULT (0x0000)
#define QTP_RX_PRBS_MISC_FMASK (0x7DF0)
#define QTP_RX_PRBS_POLY       QTP_RXPRAM_REG(0x0018)
#define QTP_RX_PRBS_POLY_WMASK (0xFFFFFFFF)
#define QTP_RX_PRBS_POLY_MASK  (0xFFFFFFFF)
#define QTP_RX_PRBS_POLY_DEFAULT (0x0000)
#define QTP_RX_PRBS_POLY_FMASK (0xFFFFFFFF)
#define QTP_RX_PRBS_OFFSET     QTP_RXPRAM_REG(0x001C)
#define QTP_RX_PRBS_OFFSET_WMASK (0xFFF0FFF)
#define QTP_RX_PRBS_OFFSET_MASK (0xFFF0FFF)
#define QTP_RX_PRBS_OFFSET_DEFAULT (0x0000)
#define QTP_RX_PRBS_OFFSET_FMASK (0xFFF0FFF)

/* Vfdf Memory Address Constants */ 
#define vfdf_decimco_base      (0x200000)
#define vfdf_decimco_mask      (0xFFFFFFFF)
#define vfdf_decimco_size      (0x0120)
#define vfdf_decimco_default   (0x0000)
#define vfdf_decimps_base      (0x200800)
#define vfdf_decimps_mask      (0xFFFFFFFF)
#define vfdf_decimps_size      (0x0220)
#define vfdf_decimps_default   (0x0000)
#define vfdf_rxwincops_base    (0x201000)
#define vfdf_rxwincops_mask    (0xFFFFFFFF)
#define vfdf_rxwincops_size    (0x0300)
#define vfdf_rxwincops_default (0x0000)
#define vfdf_txwincops_base    (0x201800)
#define vfdf_txwincops_mask    (0xFFFFFFFF)
#define vfdf_txwincops_size    (0x0480)
#define vfdf_txwincops_default (0x0000)
#define vfdf_dectdqps_base     (0x202000)
#define vfdf_dectdqps_mask     (0xFFFFFFFF)
#define vfdf_dectdqps_size     (0x0800)
#define vfdf_dectdqps_default  (0x0000)
#define vfdf_dectdqco_base     (0x202800)
#define vfdf_dectdqco_mask     (0xFFFFFFFF)
#define vfdf_dectdqco_size     (0x0600)
#define vfdf_dectdqco_default  (0x0000)
#define vfdf_txiir_co_base     (0x204000)
#define vfdf_txiir_co_mask     (0x3FFFFF)
#define vfdf_txiir_co_size     (0x007C)
#define vfdf_txiir_co_default  (0x0000)
#define vfdf_rxiir_co_base     (0x204100)
#define vfdf_rxiir_co_mask     (0x3FFFF)
#define vfdf_rxiir_co_size     (0x007C)
#define vfdf_rxiir_co_default  (0x0000)
#define vfdf_interpco_base     (0x204400)
#define vfdf_interpco_mask     (0xFFFFFFFF)
#define vfdf_interpco_size     (0x0200)
#define vfdf_interpco_default  (0x0000)
#define vfdf_decadapt_base     (0x204800)
#define vfdf_decadapt_mask     (0xFFFFFFFF)
#define vfdf_decadapt_size     (0x0800)
#define vfdf_decadapt_default  (0x0000)
#define vfdf_srcco_b00_rx_base (0x205000)
#define vfdf_srcco_b00_rx_mask (0x1FFF0FF)
#define vfdf_srcco_b00_rx_size (0x0800)
#define vfdf_srcco_b00_rx_default (0x0000)
#define vfdf_srcco_b01_rx_base (0x205800)
#define vfdf_srcco_b01_rx_mask (0x3FFF1FF)
#define vfdf_srcco_b01_rx_size (0x0800)
#define vfdf_srcco_b01_rx_default (0x0000)
#define vfdf_srcco_b02_rx_base (0x206000)
#define vfdf_srcco_b02_rx_mask (0x1FFFF7FF)
#define vfdf_srcco_b02_rx_size (0x0800)
#define vfdf_srcco_b02_rx_default (0x0000)
#define vfdf_srcco_b12_rx_base (0x206800)
#define vfdf_srcco_b12_rx_mask (0x1FFFF7FF)
#define vfdf_srcco_b12_rx_size (0x0800)
#define vfdf_srcco_b12_rx_default (0x0000)
#define vfdf_srcco_b11_rx_base (0x207000)
#define vfdf_srcco_b11_rx_mask (0x3FFF1FF)
#define vfdf_srcco_b11_rx_size (0x0800)
#define vfdf_srcco_b11_rx_default (0x0000)
#define vfdf_srcco_b10_rx_base (0x207800)
#define vfdf_srcco_b10_rx_mask (0x1FFF0FF)
#define vfdf_srcco_b10_rx_size (0x0800)
#define vfdf_srcco_b10_rx_default (0x0000)
#define vfdf_srcco_b00_tx_base (0x208000)
#define vfdf_srcco_b00_tx_mask (0x1FFF0FF)
#define vfdf_srcco_b00_tx_size (0x0800)
#define vfdf_srcco_b00_tx_default (0x0000)
#define vfdf_srcco_b01_tx_base (0x208800)
#define vfdf_srcco_b01_tx_mask (0x3FFF1FF)
#define vfdf_srcco_b01_tx_size (0x0800)
#define vfdf_srcco_b01_tx_default (0x0000)
#define vfdf_srcco_b02_tx_base (0x209000)
#define vfdf_srcco_b02_tx_mask (0x1FFFF7FF)
#define vfdf_srcco_b02_tx_size (0x0800)
#define vfdf_srcco_b02_tx_default (0x0000)
#define vfdf_srcco_b12_tx_base (0x209800)
#define vfdf_srcco_b12_tx_mask (0x1FFFF7FF)
#define vfdf_srcco_b12_tx_size (0x0800)
#define vfdf_srcco_b12_tx_default (0x0000)
#define vfdf_srcco_b11_tx_base (0x20A000)
#define vfdf_srcco_b11_tx_mask (0x3FFF1FF)
#define vfdf_srcco_b11_tx_size (0x0800)
#define vfdf_srcco_b11_tx_default (0x0000)
#define vfdf_srcco_b10_tx_base (0x20A800)
#define vfdf_srcco_b10_tx_mask (0x1FFF0FF)
#define vfdf_srcco_b10_tx_size (0x0800)
#define vfdf_srcco_b10_tx_default (0x0000)

/* Vfdf Global Address Constants */ 
#define vfdf_global_base       (0x20C600)
#define VFDF_GLOBAL(r)         (int)(vfdf_global_base + (r))
#define vfdf_global_size       (0x0200)

#define V_CONTROL              VFDF_GLOBAL(0x0000)
#define V_CONTROL_WMASK        (0xDFFFC802)
#define V_CONTROL_MASK         (0xDFFFCA02)
#define V_CONTROL_DEFAULT      (0x50000000)
#define V_CONTROL_FMASK        (0xDFFFC802)
#define V_BLOCK_RSTN           VFDF_GLOBAL(0x0004)
#define V_BLOCK_RSTN_WMASK     (0x0077)
#define V_BLOCK_RSTN_MASK      (0x0077)
#define V_BLOCK_RSTN_DEFAULT   (0x0077)
#define V_BLOCK_RSTN_FMASK     (0x0077)
#define V_OVERFLOW             VFDF_GLOBAL(0x0008)
#define V_OVERFLOW_WMASK       (0x1FEBF)
#define V_OVERFLOW_MASK        (0x1FEBF)
#define V_OVERFLOW_DEFAULT     (0x0000)
#define V_OVERFLOW_FMASK       (0x0000)
#define V_TXIIR1_CFG           VFDF_GLOBAL(0x000C)
#define V_TXIIR1_CFG_WMASK     (0x1F7FFFF)
#define V_TXIIR1_CFG_MASK      (0x1F7FFFF)
#define V_TXIIR1_CFG_DEFAULT   (0x0000)
#define V_TXIIR1_CFG_FMASK     (0x1F7FFFF)
#define V_TXIIR2_CFG           VFDF_GLOBAL(0x0010)
#define V_TXIIR2_CFG_WMASK     (0xF00FF)
#define V_TXIIR2_CFG_MASK      (0xF00FF)
#define V_TXIIR2_CFG_DEFAULT   (0x0000)
#define V_TXIIR2_CFG_FMASK     (0xF00FF)
#define V_RXIIR1_CFG           VFDF_GLOBAL(0x0014)
#define V_RXIIR1_CFG_WMASK     (0x1F7FFFF)
#define V_RXIIR1_CFG_MASK      (0x1F7FFFF)
#define V_RXIIR1_CFG_DEFAULT   (0x0000)
#define V_RXIIR1_CFG_FMASK     (0x1F7FFFF)
#define V_RXIIR2_CFG           VFDF_GLOBAL(0x0018)
#define V_RXIIR2_CFG_WMASK     (0xF00FF)
#define V_RXIIR2_CFG_MASK      (0xF00FF)
#define V_RXIIR2_CFG_DEFAULT   (0x0000)
#define V_RXIIR2_CFG_FMASK     (0xF00FF)
#define V_INTERP_CFG           VFDF_GLOBAL(0x001C)
#define V_INTERP_CFG_WMASK     (0xF0F21F07)
#define V_INTERP_CFG_MASK      (0xF0F21F07)
#define V_INTERP_CFG_DEFAULT   (0x80020000)
#define V_INTERP_CFG_FMASK     (0xF0F21F07)
#define V_DECIM_CFG            VFDF_GLOBAL(0x0020)
#define V_DECIM_CFG_WMASK      (0xFFF13F1F)
#define V_DECIM_CFG_MASK       (0xFFF13F1F)
#define V_DECIM_CFG_DEFAULT    (0x80000000)
#define V_DECIM_CFG_FMASK      (0xFFF13F1F)
#define V_DEC_CFG              VFDF_GLOBAL(0x0024)
#define V_DEC_CFG_WMASK        (0xFF3F7F7F)
#define V_DEC_CFG_MASK         (0xFF3F7F7F)
#define V_DEC_CFG_DEFAULT      (0x0000)
#define V_DEC_CFG_FMASK        (0xFF3F7F7F)
#define V_TDQ_CFG              VFDF_GLOBAL(0x0028)
#define V_TDQ_CFG_WMASK        (0x2FE001E0)
#define V_TDQ_CFG_MASK         (0x2FE001E0)
#define V_TDQ_CFG_DEFAULT      (0x0000)
#define V_TDQ_CFG_FMASK        (0x2FE001E0)
#define V_DEC_CAPTURE          VFDF_GLOBAL(0x002C)
#define V_DEC_CAPTURE_WMASK    (0x700007FE)
#define V_DEC_CAPTURE_MASK     (0x7FFFFFFE)
#define V_DEC_CAPTURE_DEFAULT  (0x1800)
#define V_DEC_CAPTURE_FMASK    (0x7FFFFFFE)
#define V_ADAPT_CTRL           VFDF_GLOBAL(0x0030)
#define V_ADAPT_CTRL_WMASK     (0x0EE6)
#define V_ADAPT_CTRL_MASK      (0x0EEF)
#define V_ADAPT_CTRL_DEFAULT   (0x0000)
#define V_ADAPT_CTRL_FMASK     (0x0EEE)
#define V_TX_VARGAIN           VFDF_GLOBAL(0x0034)
#define V_TX_VARGAIN_WMASK     (0xFFFFF)
#define V_TX_VARGAIN_MASK      (0xFFFFF)
#define V_TX_VARGAIN_DEFAULT   (0x0000)
#define V_TX_VARGAIN_FMASK     (0xFFFFF)
#define V_TX_AVARGAIN          VFDF_GLOBAL(0x0038)
#define V_TX_AVARGAIN_WMASK    (0xFFFFF)
#define V_TX_AVARGAIN_MASK     (0xFFFFF)
#define V_TX_AVARGAIN_DEFAULT  (0x0000)
#define V_TX_AVARGAIN_FMASK    (0xFFFFF)
#define V_RX_VARGAIN           VFDF_GLOBAL(0x003C)
#define V_RX_VARGAIN_WMASK     (0x7FFFF)
#define V_RX_VARGAIN_MASK      (0x7FFFF)
#define V_RX_VARGAIN_DEFAULT   (0x0000)
#define V_RX_VARGAIN_FMASK     (0x7FFFF)
#define V_RX_AVARGAIN          VFDF_GLOBAL(0x0040)
#define V_RX_AVARGAIN_WMASK    (0x7FFFF)
#define V_RX_AVARGAIN_MASK     (0x7FFFF)
#define V_RX_AVARGAIN_DEFAULT  (0x0000)
#define V_RX_AVARGAIN_FMASK    (0x7FFFF)
#define V_ADC_ADJUST           VFDF_GLOBAL(0x0044)
#define V_ADC_ADJUST_WMASK     (0xFFFFF)
#define V_ADC_ADJUST_MASK      (0xFFFFF)
#define V_ADC_ADJUST_DEFAULT   (0x0000)
#define V_ADC_ADJUST_FMASK     (0xFFFFF)
#define V_FRAME_SKEW           VFDF_GLOBAL(0x0048)
#define V_FRAME_SKEW_WMASK     (0x1000000)
#define V_FRAME_SKEW_MASK      (0x100FFFF)
#define V_FRAME_SKEW_DEFAULT   (0x0000)
#define V_FRAME_SKEW_FMASK     (0xFFFF)
#define V_TX_EXTEN             VFDF_GLOBAL(0x004C)
#define V_TX_EXTEN_WMASK       (0x17FFFFFF)
#define V_TX_EXTEN_MASK        (0x17FFFFFF)
#define V_TX_EXTEN_DEFAULT     (0x0000)
#define V_TX_EXTEN_FMASK       (0x17FFFFFF)
#define V_TX_EXTEN_A           VFDF_GLOBAL(0x0050)
#define V_TX_EXTEN_A_WMASK     (0x17FFFFFF)
#define V_TX_EXTEN_A_MASK      (0x17FFFFFF)
#define V_TX_EXTEN_A_DEFAULT   (0x0000)
#define V_TX_EXTEN_A_FMASK     (0x17FFFFFF)
#define V_TX_BETA              VFDF_GLOBAL(0x0054)
#define V_TX_BETA_WMASK        (0x01FF)
#define V_TX_BETA_MASK         (0x01FF)
#define V_TX_BETA_DEFAULT      (0x0000)
#define V_TX_BETA_FMASK        (0x01FF)
#define V_TX_BETA_A            VFDF_GLOBAL(0x0058)
#define V_TX_BETA_A_WMASK      (0x01FF)
#define V_TX_BETA_A_MASK       (0x01FF)
#define V_TX_BETA_A_DEFAULT    (0x0000)
#define V_TX_BETA_A_FMASK      (0x01FF)
#define V_TX_FSIZE             VFDF_GLOBAL(0x005C)
#define V_TX_FSIZE_WMASK       (0xF3FFF)
#define V_TX_FSIZE_MASK        (0xF3FFF)
#define V_TX_FSIZE_DEFAULT     (0x0000)
#define V_TX_FSIZE_FMASK       (0xF3FFF)
#define V_TX_FSIZE_A           VFDF_GLOBAL(0x0060)
#define V_TX_FSIZE_A_WMASK     (0xF3FFF)
#define V_TX_FSIZE_A_MASK      (0xF3FFF)
#define V_TX_FSIZE_A_DEFAULT   (0x0000)
#define V_TX_FSIZE_A_FMASK     (0xF3FFF)
#define V_FSOFFSET_IN          VFDF_GLOBAL(0x0064)
#define V_FSOFFSET_IN_WMASK    (0x3FFF)
#define V_FSOFFSET_IN_MASK     (0x3FFF)
#define V_FSOFFSET_IN_DEFAULT  (0x0000)
#define V_FSOFFSET_IN_FMASK    (0x3FFF)
#define V_FSOFFSET_ER          VFDF_GLOBAL(0x0068)
#define V_FSOFFSET_ER_WMASK    (0x3FFF)
#define V_FSOFFSET_ER_MASK     (0x3FFF)
#define V_FSOFFSET_ER_DEFAULT  (0x0000)
#define V_FSOFFSET_ER_FMASK    (0x3FFF)
#define V_RX_EXTEN             VFDF_GLOBAL(0x006C)
#define V_RX_EXTEN_WMASK       (0x1FFFFFFF)
#define V_RX_EXTEN_MASK        (0x1FFFFFFF)
#define V_RX_EXTEN_DEFAULT     (0x0000)
#define V_RX_EXTEN_FMASK       (0x1FFFFFFF)
#define V_RX_EXTEN_A           VFDF_GLOBAL(0x0070)
#define V_RX_EXTEN_A_WMASK     (0x1FFFFFFF)
#define V_RX_EXTEN_A_MASK      (0x1FFFFFFF)
#define V_RX_EXTEN_A_DEFAULT   (0x0000)
#define V_RX_EXTEN_A_FMASK     (0x1FFFFFFF)
#define V_RX_WSIZE             VFDF_GLOBAL(0x0074)
#define V_RX_WSIZE_WMASK       (0x01FF)
#define V_RX_WSIZE_MASK        (0x01FF)
#define V_RX_WSIZE_DEFAULT     (0x0000)
#define V_RX_WSIZE_FMASK       (0x01FF)
#define V_RX_WSIZE_A           VFDF_GLOBAL(0x0078)
#define V_RX_WSIZE_A_WMASK     (0x01FF)
#define V_RX_WSIZE_A_MASK      (0x01FF)
#define V_RX_WSIZE_A_DEFAULT   (0x0000)
#define V_RX_WSIZE_A_FMASK     (0x01FF)
#define V_RX_FSIZE             VFDF_GLOBAL(0x007C)
#define V_RX_FSIZE_WMASK       (0xF3FFF)
#define V_RX_FSIZE_MASK        (0xF3FFF)
#define V_RX_FSIZE_DEFAULT     (0x0000)
#define V_RX_FSIZE_FMASK       (0xF3FFF)
#define V_RX_FSIZE_A           VFDF_GLOBAL(0x0080)
#define V_RX_FSIZE_A_WMASK     (0xF3FFF)
#define V_RX_FSIZE_A_MASK      (0xF3FFF)
#define V_RX_FSIZE_A_DEFAULT   (0x0000)
#define V_RX_FSIZE_A_FMASK     (0xF3FFF)
#define V_SERDES_XBAR          VFDF_GLOBAL(0x0084)
#define V_SERDES_XBAR_WMASK    (0x0301)
#define V_SERDES_XBAR_MASK     (0x0301)
#define V_SERDES_XBAR_DEFAULT  (0x0000)
#define V_SERDES_XBAR_FMASK    (0x0301)
#define V_SRCFR                VFDF_GLOBAL(0x0088)
#define V_SRCFR_WMASK          (0xFFFFF)
#define V_SRCFR_MASK           (0xFFFFF)
#define V_SRCFR_DEFAULT        (0x0000)
#define V_SRCFR_FMASK          (0xFFFFF)
#define V_SRCCTL               VFDF_GLOBAL(0x008C)
#define V_SRCCTL_WMASK         (0xFFFFFF)
#define V_SRCCTL_MASK          (0xFFFFFF)
#define V_SRCCTL_DEFAULT       (0x0000)
#define V_SRCCTL_FMASK         (0xFFFFFF)
#define V_SRC_CFG              VFDF_GLOBAL(0x0090)
#define V_SRC_CFG_WMASK        (0xC0F3007F)
#define V_SRC_CFG_MASK         (0xC0F3007F)
#define V_SRC_CFG_DEFAULT      (0x0000)
#define V_SRC_CFG_FMASK        (0xC0F3007F)
#define V_HBFILT_CFG           VFDF_GLOBAL(0x0094)
#define V_HBFILT_CFG_WMASK     (0xF0F10000)
#define V_HBFILT_CFG_MASK      (0xF0F10000)
#define V_HBFILT_CFG_DEFAULT   (0x0000)
#define V_HBFILT_CFG_FMASK     (0xF0F10000)
#define V_AFE_SERIAL_CFG       VFDF_GLOBAL(0x0098)
#define V_AFE_SERIAL_CFG_WMASK (0x800FFFFF)
#define V_AFE_SERIAL_CFG_MASK  (0xC00FFFFF)
#define V_AFE_SERIAL_CFG_DEFAULT (0x0010)
#define V_AFE_SERIAL_CFG_FMASK (0x400FFFFF)
#define V_AFE_SERIAL_ADDR      VFDF_GLOBAL(0x009C)
#define V_AFE_SERIAL_ADDR_WMASK (0x3FFF)
#define V_AFE_SERIAL_ADDR_MASK (0x3FFF)
#define V_AFE_SERIAL_ADDR_DEFAULT (0x0000)
#define V_AFE_SERIAL_ADDR_FMASK (0x3FFF)
#define V_AFE_SERIAL_WDATA     VFDF_GLOBAL(0x00A0)
#define V_AFE_SERIAL_WDATA_WMASK (0xFFFF)
#define V_AFE_SERIAL_WDATA_MASK (0xFFFF)
#define V_AFE_SERIAL_WDATA_DEFAULT (0x0000)
#define V_AFE_SERIAL_WDATA_FMASK (0xFFFF)
#define V_AFE_SERIAL_RDATA     VFDF_GLOBAL(0x00A4)
#define V_AFE_SERIAL_RDATA_WMASK (0x0000)
#define V_AFE_SERIAL_RDATA_MASK (0xFFFF)
#define V_AFE_SERIAL_RDATA_DEFAULT (0x0000)
#define V_AFE_SERIAL_RDATA_FMASK (0xFFFF)

#endif

