/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * Copyright (c) 2013 Qualcomm Atheros, Inc.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <alphaver.h>
// #include <asm/arch-qca-common/gpio.h>
#include <common.h>
#include <command.h>
#include <console.h>
#include <image.h>
#include <u-boot/md5.h>
#include <net.h>
#include <u-boot/seama.h>
#include <spi_flash.h>
#include <telnetd.h>


#include <autoboot.h>
#include <bootretry.h>
#include <cli.h>
#include <fdtdec.h>
#include <menu.h>
#include <post.h>
#include <u-boot/sha256.h>

#ifdef CONFIG_I2C_EXPANDER_SUPPORT
extern int i2c_set_gpio_value(int command_byte, int data, int data2);
#endif

extern int escape (void);
extern int ipq_mdio_read(int mii_id, int regnum, ushort *data);
extern int ipq_mdio_write(int mii_id, int regnum, u16 value);

// #define TP_AGING
// #define TP_BTN
// #define TP_CKSUM
#define TP_GET
//#define TP_HELP
// #define TP_LINK
#define TP_POST
// #define TP_PULSE
//#define TP_RESET
#define TP_RAM
//#define TP_SW
#define TP_TIME
#define TP_VERSION
#define TP_SET
//#define TP_HTTPD
// #define TP_LED

#ifdef CONFIG_LPBK
#	define TP_LPBK
#endif


#ifdef CONFIG_CMD_TELNETD
extern void TelnetdRun(int run);
#endif

static int telnetd_run = 0;

enum{
	TEST_RESULT_FAIL = 0,
	TEST_RESULT_SUCCESS = 1,
};

//This is used to set up the error case for verifying the error message
enum{
	ERROR_CASE_NONE = 0,
	ERROR_CASE_CHECKSUM = 1,
	ERROR_CASE_SDRAM = 2,
	ERROR_CASE_TIMER = 3,
	ERROR_CASE_LPBK = 4,
};

unsigned int errorCaseTest = ERROR_CASE_NONE;
unsigned int errorOccurTurn = 0;
unsigned int tmp_aging_turn=0;
unsigned int aging_total_turn=0;
unsigned int errorCount[6] = {0, 0, 0, 0, 0, 0};

int tp_printf(const char *fmt, ...)
{
	va_list args;
	char buf[128];
	int len;
	
	va_start(args, fmt);
	len = vsprintf(buf, fmt, args);
	va_end(args);

	if (telnetd_run == 1 && tmp_aging_turn == 0)
		telnet_printf("%s",buf);
	else
		printf("%s\n",buf);
	return len;
}

#ifdef TP_HELP
void tp_help(void)
{
	tp_printf("support commands ...");
#ifdef  TP_LED
	tp_printf("led        LED Test");
#endif
#ifdef  TP_PULSE
	tp_printf("pulse      Ethernet Pulse Test");
#endif
#ifdef  TP_LINK
	tp_printf("link       Ethernet Link Status");
#endif
#ifdef  TP_RESET
	tp_printf("reset      RESET Test");
#endif
#ifdef  TP_RAM
	tp_printf("test sdram        SDRAM Test");
#endif
#ifdef  TP_TIME
	tp_printf("test timer       TIMER Test");
#endif
#ifdef  TP_LPBK
	tp_printf("lan        LAN Test <<ex. lan [?] >>");
	tp_printf("wan        WAN Test");
#endif
#ifdef  TP_CKSUM
	tp_printf("test checksum      CHECK SUM Test");
#endif
#ifdef  TP_POST
	tp_printf("test post       Power On Self Test");
#endif
#ifdef  TP_GET
	tp_printf("get        GET env <<ex. stop_boot, telnetd, tftpd, nonart, link>>");
#endif
#ifdef  TP_SET
	tp_printf("set        SET env <<ex. stop_boot, telnetd, tftpd, nonart, link>>");
#endif
#ifdef  TP_BTN
	tp_printf("btn        Button Test [reset | wps]");
#endif
#ifdef  TP_AGING
	tp_printf("aging     Aging Test");
	tp_printf("err        ERR DISPLAY");
#endif
#ifdef  TP_SW
	tp_printf("test sw         Switch confirm Test");
#endif
#ifdef  TP_ERRCASE
	tp_printf("errcase    ERR CASE Test");
#endif
}
#endif

#ifdef TP_LED
/* those GPIO pins should be define in \u-boot-2016\arch\arm\dts\ipq807x-soc.dtsi first*/
#define LED_STATUS	46
#define LED_NET		47
#define LED_2G		54
#define LED_5G		55
#define LED_USB		56
void tp_led(int argc, char *argv[])
{
	gpio_set_value(LED_STATUS, GPIO_OUT_HIGH);
	gpio_set_value(LED_NET, GPIO_OUT_HIGH);
	gpio_set_value(LED_2G, GPIO_OUT_HIGH);
	gpio_set_value(LED_5G, GPIO_OUT_HIGH);
	gpio_set_value(LED_USB, GPIO_OUT_HIGH);
	
	mdelay(2000);
	
	gpio_set_value(LED_STATUS, GPIO_OUT_LOW);
	gpio_set_value(LED_NET, GPIO_OUT_LOW);
	gpio_set_value(LED_2G, GPIO_OUT_LOW);
	gpio_set_value(LED_5G, GPIO_OUT_LOW);
	gpio_set_value(LED_USB, GPIO_OUT_LOW);
	tp_printf("LED Test ..... End");
}
#endif

#ifdef TP_PULSE
enum {
	/* for 10M */
	ALL1_10M = 0,
	RANDOM_10M,
	NORMAL_LINK_10M,
	FIVE_MHZ_WAVE_10M,
	/* for 100M */
	DUTY_CYCLE_DISTORTION_100M = 4,
	OVERSHOOT_100M,
	OVERSHOOT_14BIT_TIMES_100M,
	JITTER_100M,
	/* for 1G */
	TRANS_WAVEFORM_1G,	
	MASTER_TRANS_JITTER_1G,
	SLAVE_TRANS_JITTER_1G,
	TRANS_DISTORTION_1G,
	/* for 2.5G */
	NORMAL_2G,
	MASTER_SLAVE_JITTER_2G,
	MASTER_TRANS_JITTER_2G,
	SLAVE_TRANS_JITTER_2G,
	TRANS_DISTORTION_TONE1_2G,
	TRANS_DISTORTION_TONE2_2G,
	TRANS_DISTORTION_TONE3_2G,
	TRANS_DISTORTION_TONE4_2G,
	TRANS_DISTORTION_TONE5_2G,
	PSD_POWER_LEVEL_2G,
	TRANS_DROOP_2G,
	RANDOM_FOR_BER_2G,
	/* for 5G */
	NORMAL_5G,
	MASTER_SLAVE_JITTER_5G,
	MASTER_TRANS_JITTER_5G,
	SLAVE_TRANS_JITTER_5G,
	TRANS_DISTORTION_TONE1_5G,
	TRANS_DISTORTION_TONE2_5G,
	TRANS_DISTORTION_TONE3_5G,
	TRANS_DISTORTION_TONE4_5G,
	TRANS_DISTORTION_TONE5_5G,
	PSD_POWER_LEVEL_5G,
	TRANS_DROOP_5G,
	RANDOM_FOR_BER_5G,
	/* for 10G */
	NORMAL_10G,
	MASTER_SLAVE_JITTER_10G,
	MASTER_TRANS_JITTER_10G,
	SLAVE_TRANS_JITTER_10G,
	TRANS_DISTORTION_TONE1_10G,
	TRANS_DISTORTION_TONE2_10G,
	TRANS_DISTORTION_TONE3_10G,
	TRANS_DISTORTION_TONE4_10G,
	TRANS_DISTORTION_TONE5_10G,
	PSD_POWER_LEVEL_10G,
	TRANS_DROOP_10G,
	RANDOM_FOR_BER_10G,
};

void tp_pulse_help(void)
{
	tp_printf("- tp pulse [port] [mode]\n");
	tp_printf("[port] = 0, 1, 2, 3, 7 in Ax04\n");
	tp_printf("[mode] = %d  : 10M 10MHz sine wave with all-1 packet\n", ALL1_10M);
	tp_printf("[mode] = %d  : 10M Pseudo random\n", RANDOM_10M);
	tp_printf("[mode] = %d  : 10M Normal link pulse\n", NORMAL_LINK_10M);
	tp_printf("[mode] = %d  : 10M 5MHz sin wave\n", FIVE_MHZ_WAVE_10M);
	tp_printf("[mode] = %d  : 100M Duty cycle distortion test\n", DUTY_CYCLE_DISTORTION_100M);
	tp_printf("[mode] = %d  : 100M Overshoot test normal\n", OVERSHOOT_100M);
	tp_printf("[mode] = %d  : 100M Overshoot test, 14 bit times\n", OVERSHOOT_14BIT_TIMES_100M);
	tp_printf("[mode] = %d  : 100M Jitter test\n", JITTER_100M);
	tp_printf("[mode] = %d  : 1G Trans waveform\n", TRANS_WAVEFORM_1G);
	tp_printf("[mode] = %d  : 1G master trans jitter\n", MASTER_TRANS_JITTER_1G);
	tp_printf("[mode] = %d : 1G slave trans jitter\n", SLAVE_TRANS_JITTER_1G);
	tp_printf("[mode] = %d : 1G trans distortion\n", TRANS_DISTORTION_1G);
	tp_printf("[mode] = %d : 2.5G NORMAL\n", NORMAL_2G);
	tp_printf("[mode] = %d : 2.5G Master source for slave mode jitter test\n", MASTER_SLAVE_JITTER_2G);
	tp_printf("[mode] = %d : 2.5G Master mode jitter test\n", MASTER_TRANS_JITTER_2G);
	tp_printf("[mode] = %d : 2.5G Slave mode jitter test\n", SLAVE_TRANS_JITTER_2G);
	tp_printf("[mode] = %d : 2.5G Transmitter distortion test, tone1\n", TRANS_DISTORTION_TONE1_2G);
	tp_printf("[mode] = %d : 2.5G Transmitter distortion test, tone2\n", TRANS_DISTORTION_TONE2_2G);
	tp_printf("[mode] = %d : 2.5G Transmitter distortion test, tone3\n", TRANS_DISTORTION_TONE3_2G);
	tp_printf("[mode] = %d : 2.5G Transmitter distortion test, tone4\n", TRANS_DISTORTION_TONE4_2G);
	tp_printf("[mode] = %d : 2.5G Transmitter distortion test, tone5\n", TRANS_DISTORTION_TONE5_2G);
	tp_printf("[mode] = %d : 2.5G PSD and power level test\n", PSD_POWER_LEVEL_2G);
	tp_printf("[mode] = %d : 2.5G Transmitter Droop test\n", TRANS_DROOP_2G);
	tp_printf("[mode] = %d : 2.5G Pseudo random test mode for BER Monitor\n", RANDOM_FOR_BER_2G);
	tp_printf("[mode] = %d : 5G NORMAL\n", NORMAL_5G);
	tp_printf("[mode] = %d : 5G Master source for slave mode jitter test\n", MASTER_SLAVE_JITTER_5G);
	tp_printf("[mode] = %d : 5G Master mode jitter test\n", MASTER_TRANS_JITTER_5G);
	tp_printf("[mode] = %d : 5G Slave mode jitter test\n", SLAVE_TRANS_JITTER_5G);
	tp_printf("[mode] = %d : 5G Transmitter distortion test, tone1\n", TRANS_DISTORTION_TONE1_5G);
	tp_printf("[mode] = %d : 5G Transmitter distortion test, tone2\n", TRANS_DISTORTION_TONE2_5G);
	tp_printf("[mode] = %d : 5G Transmitter distortion test, tone3\n", TRANS_DISTORTION_TONE3_5G);
	tp_printf("[mode] = %d : 5G Transmitter distortion test, tone4\n", TRANS_DISTORTION_TONE4_5G);
	tp_printf("[mode] = %d : 5G Transmitter distortion test, tone5\n", TRANS_DISTORTION_TONE5_5G);
	tp_printf("[mode] = %d : 5G PSD and power level test\n", PSD_POWER_LEVEL_5G);
	tp_printf("[mode] = %d : 5G Transmitter Droop test\n", TRANS_DROOP_5G);
	tp_printf("[mode] = %d : 5G  Pseudo random test mode for BER Monitor\n", RANDOM_FOR_BER_5G);
	tp_printf("[mode] = %d : 10G NORMAL\n", NORMAL_10G);
	tp_printf("[mode] = %d : 10G Master source for slave mode jitter test\n", MASTER_SLAVE_JITTER_10G);
	tp_printf("[mode] = %d : 10G Master mode jitter test\n", MASTER_TRANS_JITTER_10G);
	tp_printf("[mode] = %d : 10G Slave mode jitter test\n", SLAVE_TRANS_JITTER_10G);
	tp_printf("[mode] = %d : 10G Transmitter distortion test, tone1\n", TRANS_DISTORTION_TONE1_10G);
	tp_printf("[mode] = %d : 10G Transmitter distortion test, tone2\n", TRANS_DISTORTION_TONE2_10G);
	tp_printf("[mode] = %d : 10G Transmitter distortion test, tone3\n", TRANS_DISTORTION_TONE3_10G);
	tp_printf("[mode] = %d : 10G Transmitter distortion test, tone4\n", TRANS_DISTORTION_TONE4_10G);
	tp_printf("[mode] = %d : 10G Transmitter distortion test, tone5\n", TRANS_DISTORTION_TONE5_10G);
	tp_printf("[mode] = %d : 10G PSD and power level test\n", PSD_POWER_LEVEL_10G);
	tp_printf("[mode] = %d : 10G Transmitter Droop test\n", TRANS_DROOP_10G);
	tp_printf("[mode] = %d : 10G  Pseudo random test mode for BER Monitor\n", RANDOM_FOR_BER_10G);

}

/*
 * you can refer spec : 80-y9112-2_c_qca8075_five-port_10_100_1000_mbps_ethernet_transceiver_hardware_programming_reference.pdf
 * chapter 3.2.2 to get how to access QCA8075 rebug register.
 * And chapter 17.3 tp know how to set pulse test reg.
 */
#define QCA8075_DEBUG_PORT_ADDR_OFFSET_REG	0x1d
#define QCA8075_DEBUG_PORT_DATA_REG			0x1e
#define QCA8075_DEBUG_COPPER_HIBERNATION_REG 	0xb
#define QCA8075_DEBUG_100BASE_TEST_REG			0x10
#define QCA8075_DEBUG_10BASE_TEST_REG			0x12

#define QCA8075_FUNCTION_CTRL_REG		0x10
#define QCA8075_CTRL_REG				0x0
#define QCA8075_1G_CTRL_REG				0x9
void qca8075_pulse_test(int port, int mode)
{
	if(mode > TRANS_DISTORTION_1G || mode < ALL1_10M) {
		tp_printf("QCA8075 port not support this mode\n");
		return;
	}
	switch(mode) {
	/* for 10M */
		case ALL1_10M:
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_COPPER_HIBERNATION_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x3c80);			//disable hibernation (QCA8075 spec 17.3.1)
			ipq_mdio_write(port, QCA8075_FUNCTION_CTRL_REG, 0x6800); 	//fix MDI and polarity reversal (QCA8075 spec 17.2.22)
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x9000); 			//reset port (QCA8075 spec 17.2.1)
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x100); 				//fix 10M
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_10BASE_TEST_REG); 
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x4c05); 	//start 10M test mode by setting debug registers address 0x12 (QCA8075 spec 17.3.4)
			break;
		case RANDOM_10M:
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_COPPER_HIBERNATION_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x3c80);			
			ipq_mdio_write(port, QCA8075_FUNCTION_CTRL_REG, 0x6800); 	
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x9000); 			
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x100); 				
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_10BASE_TEST_REG); 
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x4c06);
			break;
		case NORMAL_LINK_10M:
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_COPPER_HIBERNATION_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x3c80);			
			ipq_mdio_write(port, QCA8075_FUNCTION_CTRL_REG, 0x6800); 	
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x9000); 			
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x100); 				
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_10BASE_TEST_REG); 
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x4c07);
			break;
		case FIVE_MHZ_WAVE_10M:
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_COPPER_HIBERNATION_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x3c80);			
			ipq_mdio_write(port, QCA8075_FUNCTION_CTRL_REG, 0x6800); 	
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x9000); 			
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x100); 				
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_10BASE_TEST_REG); 
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x4c24);
			break;
	/* for 100M */
		case DUTY_CYCLE_DISTORTION_100M:
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_COPPER_HIBERNATION_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x3c80);	
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_100BASE_TEST_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x4020);	//refer QCA8075 spec 17.3.2		
			break;
		case OVERSHOOT_100M:
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_COPPER_HIBERNATION_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x3c80);	
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_100BASE_TEST_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x4040);
			break;
		case OVERSHOOT_14BIT_TIMES_100M:
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_COPPER_HIBERNATION_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x3c80);	
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_100BASE_TEST_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x4060);
			break;
		case JITTER_100M:
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_COPPER_HIBERNATION_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x3c80);	
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_100BASE_TEST_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x4080);
			break;
	/* for 1G */
		case TRANS_WAVEFORM_1G:
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_COPPER_HIBERNATION_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x3c80);
			ipq_mdio_write(port, QCA8075_FUNCTION_CTRL_REG, 0x6800); 	
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x9000); 			
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x0140); 	//for fix 1G
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x40);
			ipq_mdio_write(port, QCA8075_1G_CTRL_REG, 0x2200);
			break;
		case MASTER_TRANS_JITTER_1G:
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_COPPER_HIBERNATION_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x3c80);
			ipq_mdio_write(port, QCA8075_FUNCTION_CTRL_REG, 0x6800); 	
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x9000); 			
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x0140); 	//for fix 1G
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x40);
			ipq_mdio_write(port, QCA8075_1G_CTRL_REG, 0x4200);
			break;
		case SLAVE_TRANS_JITTER_1G:
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_COPPER_HIBERNATION_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x3c80);
			ipq_mdio_write(port, QCA8075_FUNCTION_CTRL_REG, 0x6800); 	
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x9000); 			
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x0140); 	//for fix 1G
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x40);
			ipq_mdio_write(port, QCA8075_1G_CTRL_REG, 0x6200);
			break;
		case TRANS_DISTORTION_1G:
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_ADDR_OFFSET_REG, QCA8075_DEBUG_COPPER_HIBERNATION_REG);
			ipq_mdio_write(port, QCA8075_DEBUG_PORT_DATA_REG, 0x3c80);
			ipq_mdio_write(port, QCA8075_FUNCTION_CTRL_REG, 0x6800); 	
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x9000); 			
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x0140); 	//for fix 1G
			ipq_mdio_write(port, QCA8075_CTRL_REG, 0x40);
			ipq_mdio_write(port, QCA8075_1G_CTRL_REG, 0x8200);
			break;
		default:
			tp_printf("QCA8075 port not support this mode\n");
	}
}

/*
 * you can refer spec :DS-N2101_AQR107-109_DataSheet_v0 6.pdf
 * chapter 6.6.329  PMA Transmit Reserved Vendor Provisioning 0
 * chapter 6.10.100  GbE Reserved Provisioning 2
 * chapter 6.6.23  PMA 10GBASE-T Test Modes
 */
#define AQUANTIA_PMA_TRANS_RES_REG	0x4001c412
#define AQUANTIA_PMA_GBE_RES_REG	0x401dc501
#define AQUANTIA_PMA_TEST_MODE_REG	0x40010084
void aquantia_107_pulse_test(int port, int mode)
{
	if(mode > RANDOM_FOR_BER_10G || mode < DUTY_CYCLE_DISTORTION_100M) {
		tp_printf("Aquantia AQR107 port not support this mode\n");
		return;
	}
	switch(mode) {
	/* for 100M */
		case DUTY_CYCLE_DISTORTION_100M:
			ipq_mdio_write(port, AQUANTIA_PMA_GBE_RES_REG, 0x3);
			break;
		case OVERSHOOT_100M:
			ipq_mdio_write(port, AQUANTIA_PMA_GBE_RES_REG, 0x2);
			break;
		case OVERSHOOT_14BIT_TIMES_100M:
			tp_printf("Aquantia AQR107 port not support this mode\n");
			break;
		case JITTER_100M:
			ipq_mdio_write(port, AQUANTIA_PMA_GBE_RES_REG, 0x1);
			break;
	/* for 1G */
		case TRANS_WAVEFORM_1G:
			ipq_mdio_write(port, AQUANTIA_PMA_GBE_RES_REG, 0x2000);
			break;
		case MASTER_TRANS_JITTER_1G:
			ipq_mdio_write(port, AQUANTIA_PMA_GBE_RES_REG, 0x4000);
			break;
		case SLAVE_TRANS_JITTER_1G:
			ipq_mdio_write(port, AQUANTIA_PMA_GBE_RES_REG, 0x6000);
			break;
		case TRANS_DISTORTION_1G:
			ipq_mdio_write(port, AQUANTIA_PMA_GBE_RES_REG, 0x8000);
			break;
	/* for 2.5G */
		case NORMAL_2G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x8000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x0);
			break;
		case MASTER_SLAVE_JITTER_2G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x8000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x2000);
			break;
		case MASTER_TRANS_JITTER_2G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x8000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x4000);
			break;
		case SLAVE_TRANS_JITTER_2G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x8000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x6000);
			break;
		case TRANS_DISTORTION_TONE1_2G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x8000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x8400);
			break;
		case TRANS_DISTORTION_TONE2_2G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x8000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x8800);
			break;
		case TRANS_DISTORTION_TONE3_2G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x8000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x9000);
			break;
		case TRANS_DISTORTION_TONE4_2G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x8000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x9400);
			break;
		case TRANS_DISTORTION_TONE5_2G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x8000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x9800);
			break;
		case PSD_POWER_LEVEL_2G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x8000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0xa000);
			break;
		case TRANS_DROOP_2G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x8000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0xc000);
			break;
		case RANDOM_FOR_BER_2G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x8000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0xe000);
			break;
	/* for 5G */
		case NORMAL_5G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x4000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x0000);
			break;
		case MASTER_SLAVE_JITTER_5G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x4000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x2000);
			break;
		case MASTER_TRANS_JITTER_5G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x4000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x4000);
			break;
		case SLAVE_TRANS_JITTER_5G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x4000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x6000);
			break;
		case TRANS_DISTORTION_TONE1_5G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x4000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x8400);
			break;
		case TRANS_DISTORTION_TONE2_5G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x4000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x8800);
			break;
		case TRANS_DISTORTION_TONE3_5G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x4000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x9000);
			break;
		case TRANS_DISTORTION_TONE4_5G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x4000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x9400);
			break;
		case TRANS_DISTORTION_TONE5_5G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x4000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x9800);
			break;
		case PSD_POWER_LEVEL_5G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x4000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0xa000);
			break;
		case TRANS_DROOP_5G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x4000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0xc000);
			break;
		case RANDOM_FOR_BER_5G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x4000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0xe000);
			break;
	/* for 10G */
		case NORMAL_10G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x0000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x0000);
			break;
		case MASTER_SLAVE_JITTER_10G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x0000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x2000);
			break;
		case MASTER_TRANS_JITTER_10G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x0000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x4000);
			break;
		case SLAVE_TRANS_JITTER_10G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x0000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x6000);
			break;
		case TRANS_DISTORTION_TONE1_10G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x0000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x8400);
			break;
		case TRANS_DISTORTION_TONE2_10G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x0000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x8800);
			break;
		case TRANS_DISTORTION_TONE3_10G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x0000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x9000);
			break;
		case TRANS_DISTORTION_TONE4_10G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x0000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x9400);
			break;
		case TRANS_DISTORTION_TONE5_10G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x0000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0x9800);
			break;
		case PSD_POWER_LEVEL_10G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x0000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0xa000);
			break;
		case TRANS_DROOP_10G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x0000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0xc000);
			break;
		case RANDOM_FOR_BER_10G:
			ipq_mdio_write(port, AQUANTIA_PMA_TRANS_RES_REG, 0x0000);
			ipq_mdio_write(port, AQUANTIA_PMA_TEST_MODE_REG, 0xe000);
			break;
		default:
			tp_printf("Aquantia AQR107 port not support this mode\n");
	}
}

void tp_pulse(int argc, char *argv[])
{
	int port;
	int mode;
	
	if(argc != 4) {
		tp_pulse_help();
		return;
	}
	
	port = (int)simple_strtol(argv[2], NULL, 10);
	mode = (int)simple_strtol(argv[3], NULL, 10);
	//tp_printf("set port [%d] mode [%d]",port,mode);
	switch(port) {
		/* port 0~3 is qca8075 port in Ax04*/
		case 0:
		case 1:
		case 2:
		case 3:
			qca8075_pulse_test(port,mode);
			break;
		/* port 7 is aquantia AQR107 port in Ax04*/
		case 7:
			aquantia_107_pulse_test(port,mode);
			break;
		default:
			tp_printf("There are no port [%d] in Ax04\n",port);
	}
}
#endif

#ifdef TP_LINK
void tp_link(void)
{
	/* function implement in ipq807x_edma.c */
	eth_status_dump(eth_get_dev());
}
#endif

#ifdef TP_RESET
void tp_reset(int argc, char *argv[])
{
	if(argc > 2)
	{
		if (strncmp(argv[2], "l2sw", 4) == 0){
#if !defined(CONFIG_ATH_NAND_BR)
			ath_reg_rmw_set(RST_RESET_ADDRESS,  RST_RESET_ETH_SGMII_ARESET_SET(1));
			udelay(1000 * 100);
			ath_reg_rmw_clear(RST_RESET_ADDRESS, RST_RESET_ETH_SGMII_ARESET_SET(1));
			udelay(100);
#endif
			ath_reg_rmw_set(RST_RESET_ADDRESS, RST_RESET_ETH_SGMII_RESET_SET(1) | RST_RESET_EXTERNAL_RESET_SET(1));
			udelay(1000 * 100);
			ath_reg_rmw_clear(RST_RESET_ADDRESS, RST_RESET_ETH_SGMII_RESET_SET(1) | RST_RESET_EXTERNAL_RESET_SET(1));
			udelay(1000 * 100);
		}
		else if (strncmp(argv[2], "wdt", 3) == 0){
			//tp_printf("WatchDogTimer RESET Test ...");
			//tp_printf("Please confirm watchdog timer reset hangs!");
			ath_reg_wr(RST_RESET_ADDRESS, RST_RESET_FULL_CHIP_RESET_SET(1));
		}
		else
		{
			tp_printf("(blank) L2-Switch ResetTest (console mode only)");
			tp_printf("l2sw    L2-Switch ResetTest (console mode only)");
			tp_printf("wdt     WatchDogTimer ResetTest");
		}
	}
	else
	{
		if(argc == 2){
			tp_printf("WatchDogTimer RESET Test ...");
			tp_printf("Please confirm watchdog timer reset hangs!");
			ath_reg_wr(RST_WATCHDOG_TIMER, RST_BOOTSTRAP_REF_CLK*7);
			udelay(1000 * 100);
			ath_reg_wr(RST_WATCHDOG_TIMER_CONTROL, RST_WATCHDOG_TIMER_CONTROL_FULL_CHIP_RESET);
		}else{
#if !defined(CONFIG_ATH_NAND_BR)
			ath_reg_rmw_set(RST_RESET_ADDRESS,  RST_RESET_ETH_SGMII_ARESET_SET(1));
			udelay(1000 * 100);
			ath_reg_rmw_clear(RST_RESET_ADDRESS, RST_RESET_ETH_SGMII_ARESET_SET(1));
			udelay(100);
#endif
			ath_reg_rmw_set(RST_RESET_ADDRESS, RST_RESET_ETH_SGMII_RESET_SET(1) | RST_RESET_EXTERNAL_RESET_SET(1));
			udelay(1000 * 100);
			ath_reg_rmw_clear(RST_RESET_ADDRESS, RST_RESET_ETH_SGMII_RESET_SET(1) | RST_RESET_EXTERNAL_RESET_SET(1));
			udelay(1000 * 100);
		}
	}
}
#endif

#ifdef TP_RAM
#define READ_MEM32(addr)         (*(volatile unsigned int *) (addr))
int ram_test(int i, int agingTest)
{
	unsigned int Test_Size;
	unsigned short test_pattern_mode;
	unsigned int test_cnt=0;
	unsigned int DRAM_Start_Test_ADR; 
	unsigned int DRAM_pattern[6] = {0x00000000, 0x55555555, 0x5A5A5A5A, 0xA5A5A5A5, 0xAAAAAAAA, 0xFFFFFFFF};
	unsigned int TEST_block[6] = {0x00000004, 0x00000010, 0x00000100, 0x00001000, 0x00010000, 0x00100000};

	DRAM_Start_Test_ADR = CONFIG_SYS_LOAD_ADDR;
	Test_Size = sizeof(int) * 0x100000;

	for(test_pattern_mode=0 ; test_pattern_mode<6 ; test_pattern_mode++)
	{
		for (test_cnt=0; test_cnt < Test_Size; test_cnt+=TEST_block[test_pattern_mode])
		{
			memset((unsigned int *) (DRAM_Start_Test_ADR+ test_cnt),DRAM_pattern[test_pattern_mode],(unsigned int)TEST_block[test_pattern_mode] );
		}

		//Just for debug if the error message is displayed well
		if((errorCaseTest==ERROR_CASE_SDRAM)&&(i==errorOccurTurn))
		{
			memset((unsigned int *) (DRAM_Start_Test_ADR+ 0x00100000),0x11111111,(unsigned int)0x00100000 );
		}
		
		for(test_cnt=0; test_cnt < Test_Size; test_cnt+=4)
		{
			if(READ_MEM32(DRAM_Start_Test_ADR+test_cnt) != DRAM_pattern[test_pattern_mode])//Compare FAIL
			{
				if (agingTest == 1)
					tp_printf("DRAM Test ..... FAIL at addr:0x%x at round %d!!!", (DRAM_Start_Test_ADR + test_cnt), i);
				else
					tp_printf("DRAM Test ..... FAIL at addr:0x%x!!!", (DRAM_Start_Test_ADR+test_cnt));
				return TEST_RESULT_FAIL;
			}
		}//end of test_cnt
	}//end of test_pattern_mode
	return TEST_RESULT_SUCCESS;
}

void tp_ram(int argc, char *argv[])
{
	int loop = 1;
	int i;
   
	if(argc > 4)
		return;
	for(i = 0; i < argc; i++)
		if(strlen(argv[i]) > 2)
			if((argv[i][0]=='c') && (argv[i][1]=='='))//check c=?
				loop = simple_strtoul(argv[i]+2, NULL, 16);//skip 'c='
		
	while(loop){
		if(ram_test(1, 0)==TEST_RESULT_SUCCESS){
			tp_printf("RAM test ... PASS\n");
		}else{
			errorCount[ERROR_CASE_SDRAM]++;
		}
		loop--;
		
		mdelay (100);
		if (ctrlc()) {
			tp_printf("ABORT\n");
			break;
		}
	}   
}
#endif

#ifdef TP_TIME
int check_timer(int i, int agingTest)
{
	ulong time1;
	ulong time2;
	ulong interval;
	unsigned int loop=1000000;
	
	time1 = get_timer(0);
	//printf("time1=%lu\n", time1);

	while(loop>0)
	{
		loop--;
		__asm__ __volatile__ ("nop");
	}


	time2 = get_timer(0);
	//printf("time2=%lu\n", time2);
	interval = time2 - time1;
	//printf("interval %ul\n",interval);
	
	if((errorCaseTest == ERROR_CASE_TIMER)&&(i==errorOccurTurn))
	{
		interval = 0;
	}
	
	if(interval != 0)
	{//correct
		return TEST_RESULT_SUCCESS;
	}
	else
	{//error
		if (agingTest == 1)
			tp_printf("Timer test .... FAIL time1=%lu, time2=%lu at round %d!!!", time1, time2, i);
		else
			tp_printf("Timer test .... FAIL time1=%lu, time2=%lu",time1,time2);

		return TEST_RESULT_FAIL;
	}
}

void tp_time(void)
{
	if(check_timer(1, 0)==TEST_RESULT_SUCCESS)
		tp_printf("Timer test ... PASS\n");
	else
		errorCount[ERROR_CASE_TIMER]++;
}
#endif

#ifdef TP_LPBK
extern void LPBKRun(int run);
extern int NetSetPulseEther(volatile uchar * xet, const uchar * addr, const uchar * addr2, uint prot);
extern void NetSendPulseFinish(void);

# define PHY_LOOPBACK		(0x1 << 14)  
# define PHY_AUTO_NEGO_EN 	(0x1 << 12)  

int perform_lpbk(int port)
{
	int result = 0;
	
	unsigned char	addr, reg;
	unsigned short	data;
	const char	*devname;
	
	devname = miiphy_get_current_dev(); 
	addr = 0x00 + (unsigned char)port;
	reg = 0x00;
	
	/* turn off telnetd*/
	if (telnetd_run == 1)
		TelnetdRun(0);
	LPBKRun(1);
	
	/*set loopback mode on, and turn off auto negotiation*/
	data = 0xffff;
	miiphy_read(devname, addr, reg, &data);
	miiphy_write (devname, addr, reg, (data | PHY_LOOPBACK) & (~PHY_AUTO_NEGO_EN));
	mdelay(1000);
	
	/* send packet and wait*/
	if (net_loop(LPBK_ALL0) < 0) {
		if (net_loop(LPBK_ALL1) < 0) 
			result = TEST_RESULT_FAIL;
		else
			result = TEST_RESULT_SUCCESS;
	} else
		result = TEST_RESULT_SUCCESS;

	data = 0xffff;
	miiphy_read(devname, addr, reg, &data);
	miiphy_write (devname, addr, reg, (data & (~PHY_LOOPBACK)) | PHY_AUTO_NEGO_EN);
	
	/* lpbk end, reset eth*/
	LPBKRun(0);
	NetSendPulseFinish();
	
	return result;
}

void tp_lpbk(int argc, char *argv[])
{
	int portnum = -1;
	
	if(argc != 3 ) {
		printf("parameter error\n");
		return;
	}
	
	portnum = simple_strtoul(argv[2], NULL, 16);
	switch(portnum) {
		case 2: case 3: case 4: case 5:
			break;
		default :
			printf("port error, try 2,3,4,5\n");
			return;
	}
	
	if(perform_lpbk(portnum)==TEST_RESULT_SUCCESS)
		tp_printf("LPBK test ... PASS");
	else
		errorCount[ERROR_CASE_LPBK]++;
	
}
#endif

#ifdef TP_PULSE
void lan_pulse(int argc, char *argv[])
{
	// not implement yet
}
#endif

#if 0
void tp_lan(int argc, char *argv[])
{

#ifdef TP_PULSE
	if (strncmp(argv[2], "m=p", 3) == 0)
		lan_pulse(argc, argv);
#endif
#ifdef TP_LPBK
	if (strncmp(argv[2], "m=t", 3) == 0)
	{
		if (strncmp(argv[3], "int", 3) == 0)
			lan_turn_int(1, argc, argv);
		//else
			//lan_turn_ext(argc, argv);
	}
	else
	{

		if (strncmp(argv[1], "lan", 3) == 0){
			tp_printf("tp lan m=t    turn test");
			tp_printf(" [#ext | int]                   ... ext:external, int:phy");
			tp_printf(" [#p=4]                         ... lan port number");
			tp_printf(" [#pn9 | all0 | all1]           ... data pattern");
			tp_printf("tp lan m=p    pulse test");
			tp_printf(" [#p=4]                         ... lan port number");
		}
		else if (strncmp(argv[1], "wan", 3) == 0){
			tp_printf("tp wan m=t    turn test");
			tp_printf(" [#ext | int]                   ... ext:external, int:phy");
			tp_printf(" [#pn9 | all0 | all1]           ... data pattern");
			tp_printf("tp wan m=p    pulse test");
		}
		tp_printf(" [sp={#auto | 100 | 10}]        ... speed");
		tp_printf(" [#full | half]                 ... duplex");
		tp_printf(" [#pn9 | all0 | all1]           ... data pattern");
		if (telnetd_run != 1)
		  tp_printf(" [con]                          ... ctrlc support for console");
		tp_printf("(# is default value.)");
		tp_printf("(send packet continually and telnet will disconnect)");
		tp_printf("(ctrlc support for console to stop send packet)");
	}
#endif
}
#endif

#ifdef TP_CKSUM
int perform_checksum(int i, int agingTest)
{
	uchar *csum, *data;
	seamahdr_t * hdr;
	uchar digest[16];
	uchar buf[64] = {0};
	
	/* copy seama to RAM, copy runtime code to RAM */
	spi_flash_read(spi_get_flash_local(), CONFIG_RUNTIME_START_ADDR, sizeof(buf), buf);
	spi_flash_read(spi_get_flash_local(), ALPHA_KERNEL_START_ADDR, CONFIG_RUNTIME_SIZE, (void *)CONFIG_SYS_LOAD_ADDR);
		
	hdr = (seamahdr_t *)buf;	//point to seama in RAM
	csum = (uchar *)(buf + sizeof(seamahdr_t)); //checksum value in seama
	data = (uchar *)CONFIG_SYS_LOAD_ADDR;	//point to runtime code in RAM

	printf("Verifying Checksum ...\n");
	md5(data,(ulong)ntohl(hdr->size),digest);
	
	if (memcmp(csum, digest, 16) == 0)
		return TEST_RESULT_SUCCESS;
	else{
		if (agingTest == 1)
			tp_printf("FLASH CHKSUM .... FAIL at round %d!!!", i);
		else
			tp_printf("FLASH CHKSUM .... FAIL");
		return TEST_RESULT_FAIL;
	}
	return 0;
}

void tp_cksum(void)
{
	if(perform_checksum(1, 0)==TEST_RESULT_SUCCESS)
		tp_printf("Checksum test ... PASS");
	else
		errorCount[ERROR_CASE_CHECKSUM]++;
}
#endif

#ifdef TP_POST
void tp_post(void)
{
	//int num = 4;
	//char *cmd[6] = {"tp", "lan", "m=t", "int", "p=1", "pn9"};
	//char *cmd[6] = {"tp", "wan", "m=t", "int", "pn9"}; //Remove all lan ports, only retain wan port.
#if 0
	unsigned int rddata;
	
	rddata = ath_reg_rd(ETH_XMII_ADDRESS);
	if(rddata == 0)
		tp_printf("17 PHY TX RX Calibration FAIL");
#endif

#ifdef TP_RAM
	if(ram_test(1, 0)==TEST_RESULT_SUCCESS)
		tp_printf("RAM test ... PASS");
#endif
#ifdef TP_TIME
	if(check_timer(1, 0)==TEST_RESULT_SUCCESS)
		tp_printf("Timer test ... PASS");
#endif
#ifdef TP_CKSUM
	if(perform_checksum(1, 0)==TEST_RESULT_SUCCESS)
		tp_printf("Checksum test ... PASS");
#endif
#ifdef TP_LPBK
	if(	perform_lpbk(0) == TEST_RESULT_SUCCESS &&
			perform_lpbk(1) == TEST_RESULT_SUCCESS &&
			perform_lpbk(2) == TEST_RESULT_SUCCESS &&
			perform_lpbk(3) == TEST_RESULT_SUCCESS &&
			perform_lpbk(4) == TEST_RESULT_SUCCESS &&
			perform_lpbk(7) == TEST_RESULT_SUCCESS ) {
				
			tp_printf("loopback test PASS\n");
	}
#endif
}
#endif

#ifdef TP_GET
void tp_get(int argc, char *argv[])
{
	char *str;
	int env_value;

	if (strcmp(argv[2], "stop_boot") == 0)
	{
		str = getenv ("stop_boot");
		env_value= str ? (int)simple_strtol(str, NULL, 10) : 0;
		if(env_value)
			tp_printf("stop_boot on\n");
		else
			tp_printf("stop_boot off\n");
	}
	else if (strcmp(argv[2], "telnetd") == 0)
	{
		str = getenv ("telnetd");
		env_value= str ? (int)simple_strtol(str, NULL, 10) : 0;
		if(env_value)
			tp_printf("telnetd enable\n");
		else
			tp_printf("telnetd disable\n");
	}
	else if (strcmp(argv[2], "mfcmode") == 0)
	{
		str = getenv ("mfcmode");
		env_value= str ? (int)simple_strtol(str, NULL, 10) : 0;
		if(env_value)
			tp_printf("mfcmode enable\n");
		else
			tp_printf("mfcmode disable\n");
	}
	else if (strcmp(argv[2], "calmode") == 0)
	{
		str = getenv ("calmode");
		env_value= str ? (int)simple_strtol(str, NULL, 10) : 0;
		if(env_value)
			tp_printf("calmode enable\n");
		else
			tp_printf("calmode disable\n");
	}
#ifdef TP_LINK
	else if (strcmp(argv[2], "link") == 0)
	{
		tp_link();
	}
#endif
	else if (strcmp(argv[2], "atelnetd") == 0)
	{
		str = getenv ("atelnetd");
		env_value= str ? (int)simple_strtol(str, NULL, 10) : 0;
		if(env_value)
			tp_printf("ATelnetd enable\n");
		else
			tp_printf("ATelnetd disable\n");
	}
	/*else if (strcmp(argv[2], "tftpd") == 0)
	{
		str = getenv ("tftpd");
		env_value= str ? (int)simple_strtol(str, NULL, 10) : 0;
		tp_printf("tftpd=%d",env_value);
	}
	else if (strcmp(argv[2], "nonart") == 0)
	{
		str = getenv ("nonart");
		env_value= str ? (int)simple_strtol(str, NULL, 10) : 0;
		tp_printf("nonart=%d",env_value);
	}
	else if (strcmp(argv[2], "tftpd_mode") == 0)
	{
		str = getenv ("tftpd_mode");
		env_value= str ? (int)simple_strtol(str, NULL, 10) : 0;
		tp_printf("tftpd_mode=%d",env_value);
	}*/
#ifdef  TP_VERSION
	else if (strcmp(argv[2], "version") == 0)
	{
		tp_printf("Bootcode SVN Revision = %d",ALPHAVER);   
	}
#endif
	/*else if (strcmp(argv[2], "flashcheck") == 0)
	{
		str = getenv ("flashcheck");
		env_value= str ? (int)simple_strtol(str, NULL, 10) : 0;
		tp_printf("flashcheck=%d",env_value);
	}*/
	else
	{
		tp_printf("tp get fail. Unknown name.");
#ifdef TP_HELP
		tp_printf("  tp get stop_boot");
		tp_printf("  tp get telnetd");
		tp_printf("  tp get mfcmode");
		tp_printf("  tp get calmode");
		//tp_printf("  tp get tftpd");
		//tp_printf("  tp get nonart");
		tp_printf("  tp get atelnetd");
		//tp_printf("  tp get tftpd_mode");
# ifdef  TP_VERSION
		tp_printf("  tp get version");
# endif
		tp_printf("tp get flashcheck");
#endif
	}
}
#endif

#ifdef TP_SET
void tp_set(int argc, char *argv[])
{
	//char *str;
	//int env_value;
	int error=0;
	if (strcmp(argv[2], "stop_boot") == 0)
	{
		if (strcmp(argv[3], "on") == 0)
		{
			setenv("stop_boot", "1");
			saveenv();
			tp_printf("stop boot on!\n");
		}
		else if (strcmp(argv[3], "off") == 0)
		{ 
			setenv("stop_boot", "0");
			saveenv();
			tp_printf("stop boot off!\n");
		}
		else
			error=1;
	}else if (strcmp(argv[2], "telnetd") == 0)
	{
		if (strcmp(argv[3], "enable") == 0)
		{
			setenv("telnetd", "1");
			saveenv();
			tp_printf("telnetd enable!\n");
		}
		else if (strcmp(argv[3], "disable") == 0)
		{
			setenv("telnetd", "0");
			saveenv();
			tp_printf("telnetd disable!\n");
		}
		else
			error=1;
	}else if (strcmp(argv[2], "mfcmode") == 0)
	{
		if (strcmp(argv[3], "enable") == 0)
		{
			setenv("mfcmode", "1");
			saveenv();
			tp_printf("mfcmode enable!\n");
		}
		else if (strcmp(argv[3], "disable") == 0)
		{
			setenv("mfcmode", "0");
			saveenv();
			tp_printf("mfcmode disable!\n");
		}
		else
			error=1;
	}else if (strcmp(argv[2], "calmode") == 0)
	{
		if (strcmp(argv[3], "enable") == 0)
		{
			setenv("calmode", "1");
			saveenv();
			tp_printf("calmode enable!\n");
		}
		else if (strcmp(argv[3], "disable") == 0)
		{
			setenv("calmode", "0");
			saveenv();
			tp_printf("calmode disable!\n");
		}
		else
			error=1;
	}else if (strcmp(argv[2], "atelnetd") == 0)
	{
		if (strcmp(argv[3], "enable") == 0)
		{
			setenv("atelnetd", "1");
			saveenv();
			tp_printf("ATelnetd is enabled!");
		}
		else if (strcmp(argv[3], "disable") == 0)
		{
			setenv("atelnetd", "0");
			saveenv();
			tp_printf("ATelnetd is disabled!");
		}
		else
			error=1;
	}/*else if (strcmp(argv[2], "tftpd") == 0)
	{
		if (strcmp(argv[3], "enable") == 0)
		{
			setenv("tftpd", "1");
			saveenv();
			tp_printf("tftpd is enabled!");
		}
		else if (strcmp(argv[3], "disable") == 0)
		{
			setenv("tftpd", "0");
			saveenv();
			tp_printf("tftpd is disabled!");
		}
		else
			error=1;
	}else if (strcmp(argv[2], "nonart") == 0)
	{
		if (strcmp(argv[3], "on") == 0)
		{
			setenv("nonart", "1");
			saveenv();
			tp_printf("nonart is ON!");
		}
		else if (strcmp(argv[3], "off") == 0)
		{
			setenv("nonart", "0");
			saveenv();
			tp_printf("nonart is OFF!");
		}
		else
			error=1;
	}else if (strcmp(argv[2], "tftpd_mode") == 0)
	{
		if (strcmp(argv[3], "3") == 0)
		{
			setenv("tftpd_mode", "3");
			saveenv();
			tp_printf("tftpd_mode is 3 !");
		}
		else if (strcmp(argv[3], "2") == 0)
		{
			setenv("tftpd_mode", "2");
			saveenv();
			tp_printf("tftpd_mode is 2 !");
		}
		else if (strcmp(argv[3], "1") == 0)
		{
			setenv("tftpd_mode", "1");
			saveenv();
			tp_printf("tftpd_mode is 1 !");
		}
		else if (strcmp(argv[3], "0") == 0)
		{
			setenv("tftpd_mode", "0");
			saveenv();
			tp_printf("tftpd_mode is 0 !");
		}
		else
			error=1;
	}
	else if (strcmp(argv[2], "product") == 0)
	{
		setenv("nonart", "0");
		setenv("tftpd", "0");
		setenv("stop_boot", "0");
		setenv("telnetd", "1");
		saveenv();
		tp_printf("Set Product default!");
		
		str = getenv ("nonart");
		env_value= str ? (int)simple_strtol(str, NULL, 10) : 0;
		tp_printf("nonart=%d",env_value);
		str = getenv ("tftpd");
		env_value= str ? (int)simple_strtol(str, NULL, 10) : 0;
		tp_printf("tftpd=%d",env_value);
		str = getenv ("stop_boot");
		env_value= str ? (int)simple_strtol(str, NULL, 10) : 0;
		tp_printf("stop_boot=%d",env_value);
		str = getenv ("telnetd");
		env_value= str ? (int)simple_strtol(str, NULL, 10) : 0;
		tp_printf("telnetd=%d",env_value);
	}
	else if (strcmp(argv[2], "flashcheck") == 0)
	{
		if (strcmp(argv[3], "on") == 0)
		{
			setenv("flashcheck", "1");
			saveenv();
			tp_printf("FLASH CHECK is ON!");
		}
		else if (strcmp(argv[3], "off") == 0)
		{
			setenv("flashcheck", "0");
			saveenv();
			tp_printf("FLASH CHECK is OFF!");
		}
		else
			error=1;
	}*/
	else
		error=1;
	
	if (error == 1)
	{
		tp_printf("tp set fail. Unknown name.");
#ifdef TP_HELP
		tp_printf("  tp set stop_boot [on | off]");
		tp_printf("  tp set telnetd [enable | disable]");
		tp_printf("  tp set mfcmode [enable | disable]");
		tp_printf("  tp set calmode [enable | disable]");
		//tp_printf("tp set tftpd [enable | disable]");
		//tp_printf("tp set nonart enableon | disable]");
		//tp_printf("  tp set atelnetd [enable | disable]");
		//tp_printf("tp set tftpd_mode [0 | 1 | 2 | 3]");
		//tp_printf("tp set product");
#endif
	}
}
#endif

#ifdef TP_BTN
/* those GPIO pins should be define in \u-boot-2016\arch\arm\dts\ipq807x-soc.dtsi first*/
#define BTN_WPS		57
void tp_btn(int argc, char *argv[])
{
	if(argc < 3 )
		return;
	if (strncmp(argv[2], "wps", 3) == 0)
	{
		if(!gpio_get_value(BTN_WPS))
			tp_printf("wps button pressed\n");
		else
			tp_printf("wps button released\n");
	}
}
#endif

#ifdef TP_SW
void tp_sw()
{
	unsigned int gpio_in = (*(volatile u32 *)(ATH_GPIO_BASE + 0x4));
	//tp_printf("gpio_in %x\n", gpio_in);
	
	if(!(gpio_in & (0x1 << 7)) && (gpio_in & (0x1 << 8))) {
		tp_printf("operation mode is Bridge mode");
	} else if((gpio_in & (0x1 << 7)) && !(gpio_in & (0x1 << 8))) {
		tp_printf("operation mode is converter mode");
	} else if((gpio_in & (0x1 << 7)) && (gpio_in & (0x1 << 8))) {
		tp_printf("operation mode is Router mode");
	} else {
		tp_printf("operation mode unknown");
	}
}
#endif

#ifdef TP_AGING
void tp_aging(int argc, char *argv[])
{
	int round = 1;
	tp_printf("==========================Aging Test (Start)==========================\n");
	while(1){
#ifdef  TP_RAM
		tp_printf("ram testing....\n");
		if(ram_test(round, 1) != TEST_RESULT_SUCCESS) {
			errorCount[ERROR_CASE_SDRAM]++;
			break;
		} else 
			tp_printf("ram test PASS\n");
#endif
#ifdef  TP_CKSUM
		tp_printf("timer testing....\n");
		mdelay(2*1000); //balance excute timer
		if(check_timer(round, 1) != TEST_RESULT_SUCCESS) {
			errorCount[ERROR_CASE_TIMER]++;
			break;
		} else 
			tp_printf("timer test PASS\n");
#endif
#ifdef  TP_TIME
		tp_printf("checksum testing....\n");
		if(perform_checksum(round, 1) != TEST_RESULT_SUCCESS) {
			errorCount[ERROR_CASE_CHECKSUM]++;
			break;
		} else 
			tp_printf("checksum test PASS\n");
#endif
#ifdef TP_LPBK
		tp_printf("loopback testing....\n");
		if(	perform_lpbk(0) != TEST_RESULT_SUCCESS ||
			perform_lpbk(1) != TEST_RESULT_SUCCESS ||
			perform_lpbk(2) != TEST_RESULT_SUCCESS ||
			perform_lpbk(3) != TEST_RESULT_SUCCESS ||
			perform_lpbk(4) != TEST_RESULT_SUCCESS ||
			perform_lpbk(7) != TEST_RESULT_SUCCESS ) {
				
			tp_printf("loopback test FAIL\n");
			break;
		} else 
			tp_printf("loopback test PASS\n");
#endif
		round++;
		
		mdelay (1000);
		if (ctrlc()) {
			tp_printf("ABORT\n");
			break;
		}
	}
	
	aging_total_turn = round;
	tp_printf("==========================Aging Test (End)==========================\n");
}

void tp_err(void)
{
	tp_printf("TOTAL Count %d", aging_total_turn);
	tp_printf(" CKSUM Err Count %d", errorCount[ERROR_CASE_CHECKSUM]);
	tp_printf(" DRAM  Err Count %d", errorCount[ERROR_CASE_SDRAM]);
	tp_printf(" TIME  Err Count %d", errorCount[ERROR_CASE_TIMER]);
	tp_printf(" LPBK  Err Count %d", errorCount[ERROR_CASE_LPBK]);
}
#endif

#ifdef TP_VERSION
void tp_version(void)
{
	tp_printf("Bootcode SVN Revision = %d",ALPHAVER);
}
#endif

#ifdef TP_HTTPD
void tp_httpd()
{
		/* turn off telnetd and wait 2sec for eth halt*/
		TelnetdRun(0);
		eth_halt();
		udelay(2000000);
		
		/* turn on httpd*/
		run_webserver();
}
#endif	

int do_tp (cmd_tbl_t *cmdtp, int flag, int argc, char * argv[])
{
	extern int CheckTelnetd(void);
	telnetd_run = CheckTelnetd();
	if(argc < 2 )
		return 0;
#ifdef TP_HELP    
	if ((strncmp(argv[1], "help", 4) == 0) ||
			 (strncmp(argv[1], "?", 1) == 0)){
		tp_help();
		return 0;
	}
#endif
#ifdef TP_LED
	if (strncmp(argv[1], "led", 3) == 0){
		tp_led(argc, argv);
		return 0;
	}
#endif
#ifdef TP_PULSE
	if (strncmp(argv[1], "pulse", 5) == 0){
		tp_pulse(argc, argv);
		return 0;
	}
#endif  
#ifdef TP_LINK
	if (strncmp(argv[1], "link", 4) == 0){
		tp_link();
		return 0;
	}
#endif
#ifdef TP_RESET
	if (strncmp(argv[1], "reset", 5) == 0){
		tp_reset(argc, argv);
		return 0;
	}
#endif
#ifdef TP_LPBK
	if (strncmp(argv[1], "lpbk", 4) == 0){
		tp_lpbk(argc, argv);
		return 0;
	}
#endif
#ifdef TP_GET
	if (strncmp(argv[1], "get", 3) == 0){
		tp_get(argc, argv);
		return 0;
	}
#endif
#ifdef TP_SET
	if (strncmp(argv[1], "set", 3) == 0){
		tp_set(argc, argv);
		return 0;
	}
#endif
#ifdef TP_BTN
	if (strncmp(argv[1], "btn", 3) == 0){
		tp_btn(argc, argv);
		return 0;
	}
#endif
	if (strncmp(argv[1], "test", 4) == 0){
#ifdef TP_RAM
		if (strncmp(argv[2], "sdram", 5) == 0){
			tp_ram(argc,argv);
			return 0;
		}
#endif
#ifdef TP_TIME
		if (strncmp(argv[2], "timer", 5) == 0){
			tp_time();
			return 0;
		}
#endif
#ifdef TP_CKSUM
		if (strncmp(argv[2], "checksum", 8) == 0){
			tp_cksum();
			return 0;
		}
#endif
#ifdef TP_POST
		if (strncmp(argv[2], "post", 4) == 0){
			tp_post();
			return 0;
		}
#endif
#ifdef TP_SW
		if (strncmp(argv[2], "sw", 2) == 0){
			tp_sw();
			return 0;
		}
#endif
#ifdef TP_AGING
		if (strncmp(argv[2], "aging", 5) == 0){
			tp_aging(argc, argv);
			return 0;
		}
#endif
		if (argv[2] == NULL)
		{
			tp_printf("tp: few parameter");
			return 0;
		}
	}
#ifdef TP_AGING
	if (strncmp(argv[1], "err", 3) == 0){
		tp_err();
		return 0;
	}
#endif
#ifdef TP_ERRCASE
	if (strncmp(argv[1], "errcase", 7) == 0){
		tp_errcase(argc, argv);
		return 0;
	}
#endif
#ifdef TP_VERSION
	if (strncmp(argv[1], "version", 7) == 0){
		tp_version();
		return 0;
	}
#endif
#ifdef TP_HTTPD
	if (strcmp(argv[1], "httpd") == 0)
	{
		tp_httpd();
	}
#endif	
	if (argv[1] == NULL)
	{
		tp_printf("tp: few parameter");
		return 0;
	}
	tp_printf("%s: Command not found.", argv[1]);
	return 1;
}

U_BOOT_CMD(
	tp,		8,		1,		do_tp,
	"test program", 
	""
);
