/*-
 * Copyright 2013 Broadcom Corporation
 *
 * Copyright (c) 2009-2010 Micron Technology, Inc.
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Henry Pan <hspan@micron.com>
 *
 * based on nand.h
 */
#ifndef __LINUX_MTD_SPI_NAND_H
#define __LINUX_MTD_SPI_NAND_H
#include <common.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/nand.h>
/* cmd */
#define CMD_READ_PAGE_TO_CACHE   	0x13
#define CMD_READ_FROM_CACHE			0x03
#define CMD_READ_FROM_CACHE_QUAD	0x6B
#define CMD_PROG_LOAD_TO_CACHE 		0x02
#define CMD_PROG_LOAD_TO_CACHE_QUAD	0x32
#define CMD_PROG_LOAD_TO_CACHE_RANDOM 	0x84
#define CMD_PROG_LOAD_TO_CACHE_RANDOM_QUAD 	0x34
#define CMD_PROG_PAGE_EXC		0x10
#define CMD_ERASE_BLK			0xd8
#define CMD_WR_ENABLE			0x06
#define CMD_WR_DISABLE			0x04
#define CMD_READ_ID				0x9f
#define CMD_RESET				0xff
#define CMD_GET_FEATURE			0x0f
#define CMD_SET_FEATURE			0x1f

/* feature/ status reg */
#define REG_BLOCK_LOCK			0xa0
#define REG_OTP					0xb0
#define REG_STATUS				0xc0/* timing */

/* status */
#define STATUS_OIP_MASK			0x01
#define STATUS_READY			(0 << 0)
#define STATUS_BUSY				(1 << 0)

#define STATUS_E_FAIL_MASK		0x04
#define STATUS_E_FAIL			(1 << 2)

#define STATUS_P_FAIL_MASK		0x08
#define STATUS_P_FAIL			(1 << 3)

#define STATUS_ECC_MASK			0x30
#define STATUS_ECC_1BIT_CORRECTED	(1 << 4)
#define STATUS_ECC_ERROR		(2 << 4)
#define STATUS_ECC_RESERVED		(3 << 4)

/*ECC enable defines*/
#define OTP_ECC_MASK			0x10
#define OTP_ECC_OFF			0
#define OTP_ECC_ON			1
#define OTP_QE				1
/* Windbond read mode */
#define READ_MODE_MASK			0x8
#define SPI_NAND_ECC_MASK		0x70
#define SPI_NAND_ECC_SHFT		4

#define ECC_DISABLED
#define ECC_IN_NAND
#define ECC_SOFT

/* block lock */
#define BL_ALL_LOCKED      0x38
#define BL_1_2_LOCKED      0x30
#define BL_1_4_LOCKED      0x28
#define BL_1_8_LOCKED      0x20
#define BL_1_16_LOCKED     0x18
#define BL_1_32_LOCKED     0x10
#define BL_1_64_LOCKED     0x08
#define BL_ALL_UNLOCKED    0

#define GIGADEVICE_DUMMY_TYPE 0x1
#define SPINAND_NEED_PLANE_SELECT 0x2 
#define CADENCE_QSPI_CTRLER	  0x4
#define SPI_NAND_QUAD_MODE	  0x8
#define SPI_NAND_NO_QUAD_ENABLE	0x10
#define SPI_NAND_READ_MODE	0x20

struct spinand_info {
	struct nand_ecclayout *ecclayout;
	struct spi_slave *spi;
	int options;
	void *priv;
};

struct spinand_state {
	uint32_t col;
	uint32_t row;
	int buf_ptr;
	u8 *buf;
};

struct spinand_cmd {
	u8 cmd;
	u32 n_addr;		/* Number of address */
	u8 addr[3];	/* Reg Offset */
	u32 n_dummy;	/* Dummy use */
	u32 n_tx;		/* Number of tx bytes */
	u8 *tx_buf;	/* Tx buf */
	u32 n_rx;		/* Number of rx bytes */
	u8 *rx_buf;	/* Rx buf */
};

#endif /* __LINUX_MTD_SPI_NAND_H */
