
//==========================================================================
//
//      net/httpd.c
//
//      Stand-alone HTTPD support for RedBoot
//
//==========================================================================
//==========================================================================
//#####DESCRIPTIONBEGIN####
// Author(s):    Sam Huang
// Date:         2005-10-16
// Purpose:
//         Perform httpd service in RedBoot.
// Description:
//         This code httpd application and only running for RedBoot.
//
//#####DESCRIPTIONEND####
//==========================================================================

#include <common.h>
#include <command.h>
#include "netif.h"
#include <malloc.h>
#include <alphaver.h>
#include <u-boot/seama.h>

#if 0
#define httpd_debug
#endif

#define false -1
#define true 0

#define ISO_nl       0x0a
#define ISO_cr       0x0d
#define PAGE_SIZE    1024

#define HTTP_NOGET   0
#define HTTP_FILE    1
#define HTTP_TEXT    2
#define HTTP_FUNC    3
#define HTTP_END     4
#define HTTP_UPLOAD  5

static tcp_socket_t httpd_sock;
static int        httpd_state;
static int        httpd_rxlen = 0;
//static unsigned char httpd_rxbuf[2048];
static char httpd_rxbuf[4096];
static char httpd_txbuf[PAGE_SIZE];
static int  httpd_txlen = 0;

/* for file upload */
struct httpd_hs
{
	unsigned char  state;
	unsigned short count;
	char *dataptr;
};
struct httpd_hs http_stat;
struct httpd_hs *hs=&http_stat;

static char ul_boundary[64];
static int ul_len;
static int ul_cnt;
static int ul_offset;

static unsigned int DstAddr;
static unsigned int DstOffset;

static unsigned char bUploadIsOK = 0;
static unsigned char Uboot_bUploadIsOK = 0, write_file_to_flash = 0; /* support bootcode upgrade. 2011.09.21, Daniel Chen */

#define CFG_UBOOT_START_ADDR        0x0
#define CFG_UBOOT_END_ADDR           0x100000
#define CFG_SYSTEM_SW_START_ADDR     0x3c0000
#define CFG_SYSTEM_SW_END_ADDR       0x7fc0000

#define FLASH_IMAGE_ADDR  CFG_SYSTEM_SW_START_ADDR
#define FREE_MEM_ADDR  0x80800000

// for image header check
#define IMG_MAX_DEVNAME 32
#define MAX_SIGNATURE   32
#define DBYTES(data, size)

extern void *flash_start,*flash_end;

#define BOOT_WAIT_PAGE   "<html><head>\n"\
"<META HTTP-EQUIV=Content-Type CONTENT='no-cache'>\n"\
"<META HTTP-EQUIV=Content-Type CONTENT='text/html; charset=iso-8859-1'>\n"\
"</head><script>var countdown=5;function nev(){countdown--;document.formWaitInfo.WaitInfo.value=countdown;\n"\
"if(countdown < 1) self.location.href='ALPHA_OK.html'; else setTimeout('nev()',1000);}</script>\n"\
"<body onload='nev()'><form name='formWaitInfo'><center><br><br><h2>Updating File </h2><hr><br><br><FONT SIZE=4>\n"\
"<font color=red>Don't Power Down.</font><br><br> Please wait for <input type='Text' readonly name='WaitInfo' size='3' style='border-width:0; background-color=#FFFFFF; color:#FF0000; text-align:center'> seconds...</center>\n"\
"</form></body></html>\n"

#define WAIT_PAGE   "<html><head>\n"\
"<META HTTP-EQUIV=Content-Type CONTENT='no-cache'>\n"\
"<META HTTP-EQUIV=Content-Type CONTENT='text/html; charset=iso-8859-1'>\n"\
"</head><script>var countdown=180;function nev(){countdown--;document.formWaitInfo.WaitInfo.value=countdown;\n"\
"if(countdown < 1) self.location.href='http:\\/\\/192.168.1.1'; else setTimeout('nev()',1000);}</script>\n"\
"<body onload='nev()'><form name='formWaitInfo'><center><br><br><h2>Updating File </h2><hr><br><br><FONT SIZE=4>\n"\
"<font color=red>Don't Power Down.</font><br><br> Please wait for <input type='Text' readonly name='WaitInfo' size='3' style='border-width:0; background-color=#FFFFFF; color:#FF0000; text-align:center'> seconds...</center>\n"\
"</form></body></html>\n"

#define PROBLEM_PAGE "<html><body><br><br>\n"\
"<center><h2><font color=red>Some problem happens!!</font></h2><hr><br><br><FONT SIZE=4>Please update again!!</center>\n"\
"</body></html>\n"

#define OK_PAGE "<html><body><br><br>\n"\
"<center><h2>Update File Successfully</h2><hr><br><br><FONT SIZE=4>Please restart device...</center>\n"\
"</body></html>\n"

#define FAIL_PAGE	"<html>\n" \
	"<head><title>FAILED</title></head>\n" \
	"<body><center>\n" \
	"<h1>FAILED TO UPLOAD IMAGE</h1>\n" \
	"<p>Unable to upload the image, \n" \
	"please make sure the uploaded file is the correct image.</p>\n" \
	"</center></body>\n" \
	"</html>\n"

#define diag_printf   printf
#define diag_sprintf  sprintf

static char INDEX_PAGE[] =
    "<html>"
    "<head><title>Emergency Room-rev:"ALPHAVER_STRING"</title></head>"
    "<body><center>"
    "<h1>UPDATING FIRMWARE</h1>"
    "<p>This page can be used to update the firmware of this device.</p>"
    "<form action=up.htm method=post encType=multipart/form-data>"
    "File <input type=file size=35 name=files> <input type=submit value=Upload></form><br>"
    "</center></body></html>";

static void httpd_init_hs(void)
{
	//memset(hs, 0, sizeof(*hs));
	memset(&http_stat, 0, sizeof(http_stat));
}

static void httpd_printf(char *m)
{
	char c;
	if(httpd_txlen > (PAGE_SIZE-32)) return ;
	while((c=*m++))
	{
		httpd_txbuf[httpd_txlen++]=c;
		if(c=='\r')
			httpd_txbuf[httpd_txlen++]='\r';
	}
}

static void httpd_page_init(void)
{
	httpd_txlen=diag_sprintf(httpd_txbuf,"<HTML><BODY>\n");
}

static void httpd_page_end(int rc,int f)
{
	httpd_txlen+=diag_sprintf(httpd_txbuf+httpd_txlen, "\n<!-- rc=%d -->%s</BODY></HTML>\n", rc, f? "<a href=index.htm>Back</a>" : "");
}

static int power(int base, int power)
{
	int sum = base;

	if(power == 1)
		return sum;
	else if(power == 0)
		return 1;

	for(; power>1; power--)
	{
		sum *= base;
	}
	return sum;
}

static void httpd_scanf(char *s,int *len)
{
	char *tmp;
	int i,j,k;

	*len=i=j=0;
	tmp = s;
	for(j=0 ; /*((*tmp != 0x0d)&&(*(tmp+1)!=0x0a)) ||*/ *tmp!=0x0 ; j++)
	{
		if(*tmp < 0x30 || *tmp > 0x39)
		{
			return;
		}
		tmp++;
	}

	if(j == 0) return;

	k = j;
	tmp = s;
	while(i < j)
	{
		k--;
		*len += (tmp[i]-0x30)* power(10,k);
		i++;
	}
}

void httpd_file_write_to_flash(void) /* 2011.09.26 Daniel Chen */
{
	unsigned long addr = 0, addr_end = 0;//check_image_and_runtime_space
	unsigned long boot_addr = 0, boot_addr_end = 0;
	int image_size_too_large = 0, image_size_too_small = 0, image_other_error = 0;

	/* support bootcode upgrade. 2011.09.21, Daniel Chen */
	if(Uboot_bUploadIsOK)
	{
		addr = CFG_UBOOT_START_ADDR;
		addr_end = CFG_UBOOT_END_ADDR;	
		
		if ((addr_end-addr) < DstOffset)
			image_size_too_large=1;
	}
	else if(bUploadIsOK)
	{
		boot_addr = CFG_UBOOT_START_ADDR;
		boot_addr_end = CFG_UBOOT_END_ADDR;

		addr = CFG_SYSTEM_SW_START_ADDR;
		addr_end = CFG_SYSTEM_SW_END_ADDR;

		if (((addr_end-addr)/2) < DstOffset)
			image_size_too_large=1;
			
		if ((boot_addr_end-boot_addr) >= DstOffset)
			image_size_too_small=1;
	}
	else
	{
		image_other_error=1;
	}

	if(image_size_too_large)
	{
		diag_printf("ERROR!! %s Image is too large( space:0x%lx, image:0x%x). Can't write image into flash...\n", Uboot_bUploadIsOK ? "Bootcode":"Runtime", (addr_end-addr), DstOffset);
		httpd_txlen = 0;
		httpd_printf(FAIL_PAGE);
		bUploadIsOK = 0;
		Uboot_bUploadIsOK = 0;
	}
	else if(image_size_too_small)
	{
		diag_printf("ERROR!! Runtime image is too small(image size :0x%x < 0x%lx )!\n", DstOffset, (boot_addr_end-boot_addr));
		httpd_txlen = 0;
		httpd_printf(FAIL_PAGE);
		bUploadIsOK = 0;
		Uboot_bUploadIsOK = 0;
	}
	else if(image_other_error)
	{
		diag_printf("Your image may have a few problems following:\n");
		diag_printf("1.The filename of bootcode image is error!! The prefix of filename must be %s.\n", ALPHAMODEL);
		diag_printf("2.The runtime image is not a SEAMA_HEADER_FILE.\n");
		diag_printf("3.The runtime image is incomplete.\n");
		httpd_txlen = 0;
		httpd_printf(FAIL_PAGE);
		bUploadIsOK = 0;
		Uboot_bUploadIsOK = 0;
	}
	else  // jack, only copy image from RAM to Flash if image size is smaller than runtime space size. check_image_and_runtime_space
	{
		httpd_txlen = 0;
		if(Uboot_bUploadIsOK)
		{
			httpd_printf(BOOT_WAIT_PAGE);
		}
		else
		{
			httpd_printf(WAIT_PAGE);
		}
		write_file_to_flash=1;
	}

}

static int httpd_fileupload(void)
{
	char buf[256];
	char *line,*end;
	int j;

	unsigned int load_addr = FREE_MEM_ADDR;

	/* Support bootcode upgrade. Check file name in here avort multipart's packet. 2011.09.21, Daniel Chen */
	if(strstr(&httpd_rxbuf[0],"filename=") && strstr(&httpd_rxbuf[0],ALPHA_MODEL_PREFIX) && strstr(&httpd_rxbuf[0],"u-boot-nand.bin"))
		Uboot_bUploadIsOK=1;

#ifdef httpd_debug
	printf("Loading file in memory(0x%x).\n", load_addr);
	printf("[%s:%d]\n\t http_stat.count=%d \n", __FUNCTION__, __LINE__, http_stat.count);
#endif
	if(http_stat.count < 4)
	{
		line=end=httpd_rxbuf;

		// found content-length , content-type, and data
		while(end < (httpd_rxbuf+httpd_rxlen) && http_stat.count<5)
		{
			if(!(*end == ISO_cr && *(end+1) == ISO_nl))
			{
				end++;
				continue;
			}
			*end='\0';
			// state 3
			if(http_stat.count == 3)
			{
				// search for data
				if(line==end)  //hs->count data
				{
					end+=2;
					ul_offset=((unsigned int)httpd_rxbuf+httpd_rxlen)-(unsigned int)end;
					memcpy((char *)load_addr,(char *)end, ul_offset);
#ifdef httpd_debug
					diag_printf("count %d data %d\n", http_stat.count, ul_offset) ;
#endif
					http_stat.count++;
					break;
				}
			}
			else
				// state 2
				if(http_stat.count == 2)
				{
					// search for boundary
					for(j=0; j<60; j++)
						if(line[j]!='-') break;

					if(!strncmp(line+j,ul_boundary,strlen(ul_boundary)))
					{
#ifdef httpd_debug
						diag_printf("count %d boundary ", http_stat.count);
#endif
						http_stat.count++;
						ul_cnt=((unsigned int)httpd_rxbuf+httpd_rxlen)-(unsigned int)line ;
#ifdef httpd_debug
						diag_printf("httpd_rxlen=%d ul_cnt=%d\n", httpd_rxlen, ul_cnt) ;
#endif
					}
				}
				else if(http_stat.count <= 1)
				{
					// state 0,1
					if(http_stat.count == 1)
						httpd_printf("<pre>");

					for(j=0; (line+j)<end; j++)
						buf[j]=line[j]|0x20;

					buf[j]='\0';

					if(!strncmp("content-length",buf,14))
					{
						//int flash_size;
#ifdef httpd_debug
						diag_printf("before scanf..%s\n",buf+16);
						diag_printf("buf[16]=0x%x,buf[17]=0x%x,buf[18]=0x%x,buf[19]=0x%x,buf[20]=0x%x,buf[21]=0x%x,buf[22]=0x%x\n",*(buf+16),*(buf+17),*(buf+18),*(buf+19),*(buf+20),*(buf+21),*(buf+22));
#endif
						httpd_scanf(buf+16,&ul_len);
#ifdef httpd_debug
						diag_printf("count %d content-length=%d\n", http_stat.count, ul_len);
#endif
						//samh TODO:
#if 0
						// check image type according to flash size.
						flash_size = (int)(flash_end - flash_start + 0x10000 + 1);
						if(ul_len > flash_size)
						{
							diag_printf("wrong image..\n");
							httpd_printf("</pre>");
							httpd_printf("<FONT SIZE=4>Wrong image! Back to select again...<HR>");
							httpd_page_end(0,1);
							return 0;
						}
#endif
						http_stat.count++;
					}
					else if(!strncmp("content-type",buf,12))
					{

#ifdef httpd_debug
						diag_printf("content-type: count=%d\n", http_stat.count);
#endif
						for(j=48; j<80; j++)
						{
							if(line[j]!='-')
							{
#ifdef httpd_debug
								diag_printf("count %d content-type boundary=%s\n", http_stat.count, line+j);
#endif
								strcpy(ul_boundary, line+j);
								http_stat.count++;
								break;
							}
						}
					}
				}
			end+=2;
			line=end;
		} //while
		return 1;
	}
	else if(http_stat.count == 4)
	{
		if((ul_cnt+httpd_rxlen) >= ul_len)
		{
#ifdef httpd_debug
			diag_printf("count %d total rx=%d\n", http_stat.count, ul_cnt+httpd_rxlen);
#endif
			int bl=strlen(ul_boundary);
			j = httpd_rxlen - bl - 6;
			for(; j > httpd_rxlen - bl - 40 ; j--)
			{
				if(httpd_rxbuf[j]!='-')
				{
					j--;
					if(httpd_rxbuf[j]!='\x0d' || httpd_rxbuf[j+1]!='\x0a') break;
					httpd_rxlen=j; // only copy those effective data
					break;
				}
			}
			http_stat.count++;
		}
		memcpy((char *)(load_addr+ul_offset),(char *) httpd_rxbuf, httpd_rxlen);
		ul_cnt+=httpd_rxlen ;
		ul_offset+= httpd_rxlen ;

		if(http_stat.count == 5)
		{
			//httpd_printf("</pre>");
			//httpd_printf("<FONT SIZE=4>Update file successfully! Please restart device...<HR>");
			//httpd_page_end(0,1);
#ifdef httpd_debug
			diag_printf("rx len=%d (0x%x)\n",ul_offset, ul_offset);
#endif

			DstAddr = load_addr;
			DstOffset = ul_offset;

			/* 2011.09.21, Daniel Chen */
			verify_seama((uchar *)DstAddr,DstOffset);
			if(SEAMA_valid == 1)
			{
				if(SEAMA_noheader)
				{
					DstAddr = (ulong)SEAMA_rawimage;
					DstOffset = ntohl(SEAMA_image->size);
				}
				else
				{
					DstAddr = (ulong)SEAMA_image;
					DstOffset = SEAMA_size;
				}
				/* check runtime firmware's board name
				if(strncasecmp(SEAMA_signature, ALPHA_SIGNATURE, strlen(ALPHA_SIGNATURE))) // board name is different
				{
					//printf("different SEAMA_signature=%s ALPHA_SIGNATURE=%s strlen(ALPHA_SIGNATURE)=%d \n",SEAMA_signature,ALPHA_SIGNATURE,strlen(ALPHA_SIGNATURE));
					DstAddr = 0;
					DstOffset = 0;
					bUploadIsOK = 0;
					diag_printf("httpd-%s():%d Board Name Error..\n", __FUNCTION__, __LINE__);
					httpd_printf("</pre>");
					httpd_printf("<FONT SIZE=4>Board Name Error! Back to select again...<HR>");
					httpd_page_end(0,1);
					return 0;
				}
				*/
				bUploadIsOK = 1;
			}

//#ifdef httpd_debug
			diag_printf("DstAddr=0x%x ,DstOffset=0x%x\n",DstAddr,DstOffset);
//#endif
			//write image into flash
			//httpd_flash_write(DstAddr, FLASH_IMAGE_ADDR, DstOffset);
			httpd_file_write_to_flash();
			
			return 0;
		}
	}
	return 1;
}

/*
 * Handle incoming HTTP packets.
 */
static int httpd_handler(void)
{
	int rc;

	//int len;
	//httpd_scanf("257807\r\n",&len);
	//diag_printf("len=%d\n",len);

	httpd_rxlen = __tcp_read(&httpd_sock, httpd_rxbuf, sizeof(httpd_rxbuf));
#ifdef httpd_debug
	printf("[%s:%d]\n\t httpd_rxlen=%d, http_stat.state=0x%x \n", __FUNCTION__, __LINE__, httpd_rxlen, http_stat.state);
#endif

	//if((httpd_rxlen > 0) && hs->state == HTTP_NOGET )
	if((httpd_rxlen > 0) && http_stat.state == HTTP_NOGET)
	{
#ifdef httpd_debug
		printf("============== Receive Packet Contain ==============\n");
		printf("httpd_rxlen=%d http_stat.state=%d \n",httpd_rxlen,http_stat.state);
		if(strstr(&httpd_rxbuf[0],"Content-Disposition"))
		{
			/* avoid kernel crash when length of httpd_rxbuf is too long. */
			unsigned char show_temp[210];
			int i=0;
			for(i=0; i<800; i+=100)
			{
				memset(&show_temp[0], 0x00, sizeof(show_temp));
				memcpy((unsigned char *)(show_temp),(unsigned char *) httpd_rxbuf+i, 100);
				printf("%s",show_temp);
			}
			//printf("%s",strstr(&httpd_rxbuf[0],"Content-Disposition"));
		}
		else
			printf("%s",httpd_rxbuf);
		printf("============== ====================== ==============\n");
#endif

		/* Check for POST */
		if(!strncmp("POST ", &httpd_rxbuf[0], 5))
		{
			//POST
			if(!strncmp("up",&httpd_rxbuf[6],2))
			{
				diag_printf("Post up.htm\n");
				//hs->state=HTTP_UPLOAD ;
				http_stat.state = HTTP_UPLOAD;

				//httpd_page_init();
				goto DO_UPLOAD;
			}
			goto GET_PAGE;
		}

		/* Check for GET */
		if(strncmp("GET ",&httpd_rxbuf[0],4))
		{
			/* If it isn't a GET, we abort the connection. */
			diag_printf("isn't GET,return -1\n");
			return -1;
		}

		/* Check for GET OK page */ //"GET /ALPHA_OKOK.html****"
		if(!strncmp("ALPHA_OK", &httpd_rxbuf[5], strlen("ALPHA_OK")))
		{
//GET_OK_PAGE:
			//diag_printf("get OK page.\n");
			httpd_txlen = 0;
			httpd_printf(OK_PAGE);
			return 0;
		}

GET_PAGE:
#ifdef httpd_debug
		diag_printf("Client requests index page\n");
#endif
		httpd_page_init();
		httpd_printf(INDEX_PAGE);
		httpd_page_end(0,0);
		return 0;
	}
	else if(httpd_rxlen <= 0)
	{
		// !!! for 5VT board,Don't remove "printf()" below
#ifdef httpd_debug
		diag_printf("httpd: rx=%d\r\b",httpd_rxlen);
#endif
		return 1;
	}

DO_UPLOAD:
	//httpd_page_init();

#ifdef httpd_debug
	printf("upload: rx=%d\r\b",httpd_rxlen);
#endif
	rc = httpd_fileupload();

	return rc;
}


static int
httpd_read_resp_nonblock(void)
{
	int rc;

	__tcp_poll();
	if(httpd_sock.state == _CLOSE_WAIT)
	{
		// This connection is breaking
		if(httpd_sock.data_bytes == 0 && httpd_sock.rxcnt == 0)
		{
			diag_printf("databytes&rxcnt = 0\n");
			__tcp_close(&httpd_sock);
			return false;
		}
	}
	if(httpd_sock.state == _CLOSED)
	{
		// The connection is gone
		diag_printf("The connection is gone\n");
		return true;
	}

	if((rc = httpd_handler()) >= 0)
	{
		/* TODO: temperarily use this method
		 */
		if(rc == 0)
		{
			/* Normally response get request from http client */
#ifdef httpd_debug
			diag_printf("Send close..\n");
#endif
			__tcp_write(&httpd_sock,httpd_txbuf,httpd_txlen);
			__tcp_close(&httpd_sock);
		}
		else
		{
#ifdef httpd_debug
			printf("[%s:%d]\n\t got data.. send ack : rc(%d)\n", __FUNCTION__, __LINE__, rc);
#endif
			/* PS: No need to send TCP_ACK by myself,
			 *		  TCP session will do this...
			 */
			//__tcp_send_ack(&httpd_sock);
		}
		return true;
	}
	else
	{
		/* TODO: I think there could another better way to close connection,
		 *	   temperarily use regular method.
		 */
#ifdef httpd_debug
		diag_printf("httpd_handler() returns false\n");
#endif
		__tcp_close(&httpd_sock);
		return false;
	}
}

void httpd_init(void)
{
#ifdef httpd_debug
	diag_printf("%s: httpd init...\n", __FUNCTION__);
#endif
	__tcp_listen(&httpd_sock,80);
	httpd_state = httpd_sock.state;
}

void httpd_accept(int is_idle)
{
	if(!is_idle) {};
	//if(!is_idle) return;  // Only care about idle case
	//if(!have_net) return;
	__tcp_poll();

	if(httpd_state != httpd_sock.state)
	{
#ifdef httpd_debug
		printf("[%s:%d]\n\t httpd_state=%d,http_sock.state=%d \n", __FUNCTION__, __LINE__, httpd_state, httpd_sock.state);
#endif
		// Something has changed
		if(httpd_sock.state == _ESTABLISHED)
		{
			httpd_init_hs();
			// A new connection has arrived
			if(!httpd_read_resp_nonblock())
			{
#ifdef httpd_debug
				printf("[%s:%d]\n\t httpd_sock.state == established: fail to httpd_read_resp_nonblock \n", __FUNCTION__, __LINE__);
#endif
			}
		}
		if(httpd_sock.state == _TIME_WAIT)
		{
#ifdef httpd_debug
			diag_printf("tcp reset\n");
#endif
			__tcp_reset(&httpd_sock);
		}
		if(httpd_sock.state == _CLOSED)
		{
			// Get ready for another connection
#ifdef httpd_debug
			diag_printf("httpd re-init\n");
#endif
			httpd_init();
		}
#ifdef httpd_debug
		printf("[%s:%d]\n\t httpd_state=%d,http_sock.state=%d \n", __FUNCTION__, __LINE__, httpd_state, httpd_sock.state);
#endif
	}
	else if(httpd_state == _ESTABLISHED && httpd_sock.state == _ESTABLISHED)
	{
		if(!httpd_read_resp_nonblock())
		{
#ifdef httpd_debug
			printf("[%s:%d]\n\t httpd_state == established: fail to httpd_read_resp_nonblock \n", __FUNCTION__, __LINE__);
#endif
		}
	}
	
	if(write_file_to_flash == 1)
	{

		/* Be careful to use global variables in nonblock mode.  2011.09.26 Daniel Chen*/
		unsigned long addr = 0, addr_end = 0;//check_image_and_runtime_space
		char runcmd[256];
		
		if(Uboot_bUploadIsOK)
		{
			addr = CFG_UBOOT_START_ADDR;
			addr_end = CFG_UBOOT_END_ADDR;
		}	
		else if(bUploadIsOK)
		{
			addr = CFG_SYSTEM_SW_START_ADDR;
			addr_end = CFG_SYSTEM_SW_END_ADDR;
		}
		else
		{
			addr = CFG_SYSTEM_SW_START_ADDR;
			addr_end = CFG_SYSTEM_SW_END_ADDR;
		}

		printf("begin addr=0x%x,end=0x%x\n", addr, addr_end);

		if(Uboot_bUploadIsOK)
		{
			snprintf(runcmd, sizeof(runcmd),
				"nand erase 0x%08x 0x%08x;" \
				"nand write.partial 0x%08x 0x%08x 0x%08x",
				addr, (addr_end-addr),
				DstAddr, addr, DstOffset);
			printf(runcmd);
			printf("\n");
		}
		else if(bUploadIsOK)
		{
			snprintf(runcmd, sizeof(runcmd),
				"ubi part system_sw;" \
				"run switchbankA;" \
				"upgrade 0x%08x 0x%08x;" \
				"run switchbankB;" \
				"upgrade 0x%08x 0x%08x",
				DstAddr, DstOffset,
				DstAddr, DstOffset);
			printf(runcmd);
			printf("\n");
		}

		if (run_command(runcmd, 0) != CMD_RET_SUCCESS) {
			printf("upgrade failed!!!\n");
		}
		else {
			diag_printf("\nWrite %s image form addr=0x%x into flash...OK,dest addr=0x%x\n", Uboot_bUploadIsOK ? "bootcode":"runtime", DstAddr, addr);
			diag_printf("Upload file OK!\n");
		}

		if(bUploadIsOK || Uboot_bUploadIsOK)
		{
			do_reset(NULL , 0 , 0 ,NULL);
		}

		write_file_to_flash=0;
		Uboot_bUploadIsOK=0;
		bUploadIsOK=0;
	}

	httpd_state = httpd_sock.state;
}
