/*
 * Copyright (c) 2015 MediaTek Inc.
 * Author: Biao Huang <biao.huang@mediatek.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __DTS_MT2701_PINFUNC_H
#define __DTS_MT2701_PINFUNC_H

#include <dt-bindings/pinctrl/mt65xx.h>

#define MT2701_PIN_0_PWRAP_SPI0_MI__FUNC_GPIO0 (MTK_PIN_NO(0) | 0)
#define MT2701_PIN_0_PWRAP_SPI0_MI__FUNC_PWRAP_SPIDO (MTK_PIN_NO(0) | 1)
#define MT2701_PIN_0_PWRAP_SPI0_MI__FUNC_PWRAP_SPIDI (MTK_PIN_NO(0) | 2)

#define MT2701_PIN_1_PWRAP_SPI0_MO__FUNC_GPIO1 (MTK_PIN_NO(1) | 0)
#define MT2701_PIN_1_PWRAP_SPI0_MO__FUNC_PWRAP_SPIDI (MTK_PIN_NO(1) | 1)
#define MT2701_PIN_1_PWRAP_SPI0_MO__FUNC_PWRAP_SPIDO (MTK_PIN_NO(1) | 2)

#define MT2701_PIN_2_PWRAP_INT__FUNC_GPIO2 (MTK_PIN_NO(2) | 0)
#define MT2701_PIN_2_PWRAP_INT__FUNC_PWRAP_INT (MTK_PIN_NO(2) | 1)

#define MT2701_PIN_3_PWRAP_SPI0_CK__FUNC_GPIO3 (MTK_PIN_NO(3) | 0)
#define MT2701_PIN_3_PWRAP_SPI0_CK__FUNC_PWRAP_SPICK_I (MTK_PIN_NO(3) | 1)

#define MT2701_PIN_4_PWRAP_SPI0_CSN__FUNC_GPIO4 (MTK_PIN_NO(4) | 0)
#define MT2701_PIN_4_PWRAP_SPI0_CSN__FUNC_PWRAP_SPICS_B_I (MTK_PIN_NO(4) | 1)

#define MT2701_PIN_5_PWRAP_SPI0_CK2__FUNC_GPIO5 (MTK_PIN_NO(5) | 0)
#define MT2701_PIN_5_PWRAP_SPI0_CK2__FUNC_PWRAP_SPICK2_I (MTK_PIN_NO(5) | 1)
#define MT2701_PIN_5_PWRAP_SPI0_CK2__FUNC_ANT_SEL1 (MTK_PIN_NO(5) | 5)

#define MT2701_PIN_6_PWRAP_SPI0_CSN2__FUNC_GPIO6 (MTK_PIN_NO(6) | 0)
#define MT2701_PIN_6_PWRAP_SPI0_CSN2__FUNC_PWRAP_SPICS2_B_I (MTK_PIN_NO(6) | 1)
#define MT2701_PIN_6_PWRAP_SPI0_CSN2__FUNC_ANT_SEL0 (MTK_PIN_NO(6) | 5)
#define MT2701_PIN_6_PWRAP_SPI0_CSN2__FUNC_DBG_MON_A_0 (MTK_PIN_NO(6) | 7)

#define MT2701_PIN_7_SPI1_CSN__FUNC_GPIO7 (MTK_PIN_NO(7) | 0)
#define MT2701_PIN_7_SPI1_CSN__FUNC_SPI1_CS (MTK_PIN_NO(7) | 1)
#define MT2701_PIN_7_SPI1_CSN__FUNC_KCOL0 (MTK_PIN_NO(7) | 4)
#define MT2701_PIN_7_SPI1_CSN__FUNC_DBG_MON_B_12 (MTK_PIN_NO(7) | 7)

#define MT2701_PIN_8_SPI1_MI__FUNC_GPIO8 (MTK_PIN_NO(8) | 0)
#define MT2701_PIN_8_SPI1_MI__FUNC_SPI1_MI (MTK_PIN_NO(8) | 1)
#define MT2701_PIN_8_SPI1_MI__FUNC_SPI1_MO (MTK_PIN_NO(8) | 2)
#define MT2701_PIN_8_SPI1_MI__FUNC_KCOL1 (MTK_PIN_NO(8) | 4)
#define MT2701_PIN_8_SPI1_MI__FUNC_DBG_MON_B_13 (MTK_PIN_NO(8) | 7)

#define MT2701_PIN_9_SPI1_MO__FUNC_GPIO9 (MTK_PIN_NO(9) | 0)
#define MT2701_PIN_9_SPI1_MO__FUNC_SPI1_MO (MTK_PIN_NO(9) | 1)
#define MT2701_PIN_9_SPI1_MO__FUNC_SPI1_MI (MTK_PIN_NO(9) | 2)
#define MT2701_PIN_9_SPI1_MO__FUNC_EXT_FRAME_SYNC (MTK_PIN_NO(9) | 3)
#define MT2701_PIN_9_SPI1_MO__FUNC_KCOL2 (MTK_PIN_NO(9) | 4)
#define MT2701_PIN_9_SPI1_MO__FUNC_DBG_MON_B_14 (MTK_PIN_NO(9) | 7)

#define MT2701_PIN_10_RTC32K_CK__FUNC_GPIO10 (MTK_PIN_NO(10) | 0)
#define MT2701_PIN_10_RTC32K_CK__FUNC_RTC32K_CK (MTK_PIN_NO(10) | 1)

#define MT2701_PIN_11_WATCHDOG__FUNC_GPIO11 (MTK_PIN_NO(11) | 0)
#define MT2701_PIN_11_WATCHDOG__FUNC_WATCHDOG (MTK_PIN_NO(11) | 1)

#define MT2701_PIN_12_SRCLKENA__FUNC_GPIO12 (MTK_PIN_NO(12) | 0)
#define MT2701_PIN_12_SRCLKENA__FUNC_SRCLKENA (MTK_PIN_NO(12) | 1)

#define MT2701_PIN_13_SRCLKENAI__FUNC_GPIO13 (MTK_PIN_NO(13) | 0)
#define MT2701_PIN_13_SRCLKENAI__FUNC_SRCLKENAI (MTK_PIN_NO(13) | 1)

#define MT2701_PIN_14_URXD2__FUNC_GPIO14 (MTK_PIN_NO(14) | 0)
#define MT2701_PIN_14_URXD2__FUNC_URXD2 (MTK_PIN_NO(14) | 1)
#define MT2701_PIN_14_URXD2__FUNC_UTXD2 (MTK_PIN_NO(14) | 2)
#define MT2701_PIN_14_URXD2__FUNC_SRCCLKENAI2 (MTK_PIN_NO(14) | 5)
#define MT2701_PIN_14_URXD2__FUNC_DBG_MON_B_30 (MTK_PIN_NO(14) | 7)

#define MT2701_PIN_15_UTXD2__FUNC_GPIO15 (MTK_PIN_NO(15) | 0)
#define MT2701_PIN_15_UTXD2__FUNC_UTXD2 (MTK_PIN_NO(15) | 1)
#define MT2701_PIN_15_UTXD2__FUNC_URXD2 (MTK_PIN_NO(15) | 2)
#define MT2701_PIN_15_UTXD2__FUNC_DBG_MON_B_31 (MTK_PIN_NO(15) | 7)

#define MT2701_PIN_16_I2S5_DATA_IN__FUNC_GPIO16 (MTK_PIN_NO(16) | 0)
#define MT2701_PIN_16_I2S5_DATA_IN__FUNC_I2S5_DATA_IN (MTK_PIN_NO(16) | 1)
#define MT2701_PIN_16_I2S5_DATA_IN__FUNC_PCM_RX (MTK_PIN_NO(16) | 3)
#define MT2701_PIN_16_I2S5_DATA_IN__FUNC_ANT_SEL4 (MTK_PIN_NO(16) | 4)

#define MT2701_PIN_17_I2S5_BCK__FUNC_GPIO17 (MTK_PIN_NO(17) | 0)
#define MT2701_PIN_17_I2S5_BCK__FUNC_I2S5_BCK (MTK_PIN_NO(17) | 1)
#define MT2701_PIN_17_I2S5_BCK__FUNC_PCM_CLK0 (MTK_PIN_NO(17) | 3)
#define MT2701_PIN_17_I2S5_BCK__FUNC_ANT_SEL2 (MTK_PIN_NO(17) | 4)

#define MT2701_PIN_18_PCM_CLK__FUNC_GPIO18 (MTK_PIN_NO(18) | 0)
#define MT2701_PIN_18_PCM_CLK__FUNC_PCM_CLK0 (MTK_PIN_NO(18) | 1)
#define MT2701_PIN_18_PCM_CLK__FUNC_MRG_CLK (MTK_PIN_NO(18) | 2)
#define MT2701_PIN_18_PCM_CLK__FUNC_MM_TEST_CK (MTK_PIN_NO(18) | 4)
#define MT2701_PIN_18_PCM_CLK__FUNC_CONN_DSP_JCK (MTK_PIN_NO(18) | 5)
#define MT2701_PIN_18_PCM_CLK__FUNC_WCN_PCM_CLKO (MTK_PIN_NO(18) | 6)
#define MT2701_PIN_18_PCM_CLK__FUNC_DBG_MON_A_3 (MTK_PIN_NO(18) | 7)

#define MT2701_PIN_19_PCM_SYNC__FUNC_GPIO19 (MTK_PIN_NO(19) | 0)
#define MT2701_PIN_19_PCM_SYNC__FUNC_PCM_SYNC (MTK_PIN_NO(19) | 1)
#define MT2701_PIN_19_PCM_SYNC__FUNC_MRG_SYNC (MTK_PIN_NO(19) | 2)
#define MT2701_PIN_19_PCM_SYNC__FUNC_CONN_DSP_JINTP (MTK_PIN_NO(19) | 5)
#define MT2701_PIN_19_PCM_SYNC__FUNC_WCN_PCM_SYNC (MTK_PIN_NO(19) | 6)
#define MT2701_PIN_19_PCM_SYNC__FUNC_DBG_MON_A_5 (MTK_PIN_NO(19) | 7)

#define MT2701_PIN_20_PCM_RX__FUNC_GPIO20 (MTK_PIN_NO(20) | 0)
#define MT2701_PIN_20_PCM_RX__FUNC_PCM_RX (MTK_PIN_NO(20) | 1)
#define MT2701_PIN_20_PCM_RX__FUNC_MRG_RX (MTK_PIN_NO(20) | 2)
#define MT2701_PIN_20_PCM_RX__FUNC_MRG_TX (MTK_PIN_NO(20) | 3)
#define MT2701_PIN_20_PCM_RX__FUNC_PCM_TX (MTK_PIN_NO(20) | 4)
#define MT2701_PIN_20_PCM_RX__FUNC_CONN_DSP_JDI (MTK_PIN_NO(20) | 5)
#define MT2701_PIN_20_PCM_RX__FUNC_WCN_PCM_RX (MTK_PIN_NO(20) | 6)
#define MT2701_PIN_20_PCM_RX__FUNC_DBG_MON_A_4 (MTK_PIN_NO(20) | 7)

#define MT2701_PIN_21_PCM_TX__FUNC_GPIO21 (MTK_PIN_NO(21) | 0)
#define MT2701_PIN_21_PCM_TX__FUNC_PCM_TX (MTK_PIN_NO(21) | 1)
#define MT2701_PIN_21_PCM_TX__FUNC_MRG_TX (MTK_PIN_NO(21) | 2)
#define MT2701_PIN_21_PCM_TX__FUNC_MRG_RX (MTK_PIN_NO(21) | 3)
#define MT2701_PIN_21_PCM_TX__FUNC_PCM_RX (MTK_PIN_NO(21) | 4)
#define MT2701_PIN_21_PCM_TX__FUNC_CONN_DSP_JMS (MTK_PIN_NO(21) | 5)
#define MT2701_PIN_21_PCM_TX__FUNC_WCN_PCM_TX (MTK_PIN_NO(21) | 6)
#define MT2701_PIN_21_PCM_TX__FUNC_DBG_MON_A_2 (MTK_PIN_NO(21) | 7)

#define MT2701_PIN_22_EINT0__FUNC_GPIO22 (MTK_PIN_NO(22) | 0)
#define MT2701_PIN_22_EINT0__FUNC_UCTS0 (MTK_PIN_NO(22) | 1)
#define MT2701_PIN_22_EINT0__FUNC_KCOL3 (MTK_PIN_NO(22) | 3)
#define MT2701_PIN_22_EINT0__FUNC_CONN_DSP_JDO (MTK_PIN_NO(22) | 4)
#define MT2701_PIN_22_EINT0__FUNC_EXT_FRAME_SYNC (MTK_PIN_NO(22) | 5)
#define MT2701_PIN_22_EINT0__FUNC_DBG_MON_A_30 (MTK_PIN_NO(22) | 7)
#define MT2701_PIN_22_EINT0__FUNC_PCIE0_PERST_N (MTK_PIN_NO(22) | 10)

#define MT2701_PIN_23_EINT1__FUNC_GPIO23 (MTK_PIN_NO(23) | 0)
#define MT2701_PIN_23_EINT1__FUNC_URTS0 (MTK_PIN_NO(23) | 1)
#define MT2701_PIN_23_EINT1__FUNC_KCOL2 (MTK_PIN_NO(23) | 3)
#define MT2701_PIN_23_EINT1__FUNC_CONN_MCU_TDO (MTK_PIN_NO(23) | 4)
#define MT2701_PIN_23_EINT1__FUNC_EXT_FRAME_SYNC (MTK_PIN_NO(23) | 5)
#define MT2701_PIN_23_EINT1__FUNC_DBG_MON_A_29 (MTK_PIN_NO(23) | 7)
#define MT2701_PIN_23_EINT1__FUNC_PCIE1_PERST_N (MTK_PIN_NO(23) | 10)

#define MT2701_PIN_24_EINT2__FUNC_GPIO24 (MTK_PIN_NO(24) | 0)
#define MT2701_PIN_24_EINT2__FUNC_UCTS1 (MTK_PIN_NO(24) | 1)
#define MT2701_PIN_24_EINT2__FUNC_KCOL1 (MTK_PIN_NO(24) | 3)
#define MT2701_PIN_24_EINT2__FUNC_CONN_MCU_DBGACK_N (MTK_PIN_NO(24) | 4)
#define MT2701_PIN_24_EINT2__FUNC_DBG_MON_A_28 (MTK_PIN_NO(24) | 7)
#define MT2701_PIN_24_EINT2__FUNC_PCIE2_PERST_N (MTK_PIN_NO(24) | 10)

#define MT2701_PIN_25_EINT3__FUNC_GPIO25 (MTK_PIN_NO(25) | 0)
#define MT2701_PIN_25_EINT3__FUNC_URTS1 (MTK_PIN_NO(25) | 1)
#define MT2701_PIN_25_EINT3__FUNC_KCOL0 (MTK_PIN_NO(25) | 3)
#define MT2701_PIN_25_EINT3__FUNC_CONN_MCU_DBGI_N (MTK_PIN_NO(25) | 4)
#define MT2701_PIN_25_EINT3__FUNC_DBG_MON_A_27 (MTK_PIN_NO(25) | 7)

#define MT2701_PIN_26_EINT4__FUNC_GPIO26 (MTK_PIN_NO(26) | 0)
#define MT2701_PIN_26_EINT4__FUNC_UCTS3 (MTK_PIN_NO(26) | 1)
#define MT2701_PIN_26_EINT4__FUNC_DRV_VBUS_P1 (MTK_PIN_NO(26) | 2)
#define MT2701_PIN_26_EINT4__FUNC_KROW3 (MTK_PIN_NO(26) | 3)
#define MT2701_PIN_26_EINT4__FUNC_CONN_MCU_TCK0 (MTK_PIN_NO(26) | 4)
#define MT2701_PIN_26_EINT4__FUNC_CONN_MCU_AICE_JCKC (MTK_PIN_NO(26) | 5)
#define MT2701_PIN_26_EINT4__FUNC_PCIE2_WAKE_N (MTK_PIN_NO(26) | 6)
#define MT2701_PIN_26_EINT4__FUNC_DBG_MON_A_26 (MTK_PIN_NO(26) | 7)

#define MT2701_PIN_27_EINT5__FUNC_GPIO27 (MTK_PIN_NO(27) | 0)
#define MT2701_PIN_27_EINT5__FUNC_URTS3 (MTK_PIN_NO(27) | 1)
#define MT2701_PIN_27_EINT5__FUNC_IDDIG_P1 (MTK_PIN_NO(27) | 2)
#define MT2701_PIN_27_EINT5__FUNC_KROW2 (MTK_PIN_NO(27) | 3)
#define MT2701_PIN_27_EINT5__FUNC_CONN_MCU_TDI (MTK_PIN_NO(27) | 4)
#define MT2701_PIN_27_EINT5__FUNC_PCIE1_WAKE_N (MTK_PIN_NO(27) | 6)
#define MT2701_PIN_27_EINT5__FUNC_DBG_MON_A_25 (MTK_PIN_NO(27) | 7)

#define MT2701_PIN_28_EINT6__FUNC_GPIO28 (MTK_PIN_NO(28) | 0)
#define MT2701_PIN_28_EINT6__FUNC_DRV_VBUS (MTK_PIN_NO(28) | 1)
#define MT2701_PIN_28_EINT6__FUNC_KROW1 (MTK_PIN_NO(28) | 3)
#define MT2701_PIN_28_EINT6__FUNC_CONN_MCU_TRST_B (MTK_PIN_NO(28) | 4)
#define MT2701_PIN_28_EINT6__FUNC_PCIE0_WAKE_N (MTK_PIN_NO(28) | 6)
#define MT2701_PIN_28_EINT6__FUNC_DBG_MON_A_24 (MTK_PIN_NO(28) | 7)

#define MT2701_PIN_29_EINT7__FUNC_GPIO29 (MTK_PIN_NO(29) | 0)
#define MT2701_PIN_29_EINT7__FUNC_IDDIG (MTK_PIN_NO(29) | 1)
#define MT2701_PIN_29_EINT7__FUNC_MSDC1_WP (MTK_PIN_NO(29) | 2)
#define MT2701_PIN_29_EINT7__FUNC_KROW0 (MTK_PIN_NO(29) | 3)
#define MT2701_PIN_29_EINT7__FUNC_CONN_MCU_TMS (MTK_PIN_NO(29) | 4)
#define MT2701_PIN_29_EINT7__FUNC_CONN_MCU_AICE_JMSC (MTK_PIN_NO(29) | 5)
#define MT2701_PIN_29_EINT7__FUNC_DBG_MON_A_23 (MTK_PIN_NO(29) | 7)
#define MT2701_PIN_29_EINT7__FUNC_PCIE2_PERST_N (MTK_PIN_NO(29) | 14)

#define MT2701_PIN_30_I2S5_LRCK__FUNC_GPIO30 (MTK_PIN_NO(30) | 0)
#define MT2701_PIN_30_I2S5_LRCK__FUNC_I2S5_LRCK (MTK_PIN_NO(30) | 1)
#define MT2701_PIN_30_I2S5_LRCK__FUNC_PCM_SYNC (MTK_PIN_NO(30) | 3)
#define MT2701_PIN_30_I2S5_LRCK__FUNC_ANT_SEL1 (MTK_PIN_NO(30) | 4)

#define MT2701_PIN_31_I2S5_MCLK__FUNC_GPIO31 (MTK_PIN_NO(31) | 0)
#define MT2701_PIN_31_I2S5_MCLK__FUNC_I2S5_MCLK (MTK_PIN_NO(31) | 1)
#define MT2701_PIN_31_I2S5_MCLK__FUNC_ANT_SEL0 (MTK_PIN_NO(31) | 4)

#define MT2701_PIN_32_I2S5_DATA__FUNC_GPIO32 (MTK_PIN_NO(32) | 0)
#define MT2701_PIN_32_I2S5_DATA__FUNC_I2S5_DATA (MTK_PIN_NO(32) | 1)
#define MT2701_PIN_32_I2S5_DATA__FUNC_I2S5_DATA_BYPS (MTK_PIN_NO(32) | 2)
#define MT2701_PIN_32_I2S5_DATA__FUNC_PCM_TX (MTK_PIN_NO(32) | 3)
#define MT2701_PIN_32_I2S5_DATA__FUNC_ANT_SEL3 (MTK_PIN_NO(32) | 4)

#define MT2701_PIN_33_I2S1_DATA__FUNC_GPIO33 (MTK_PIN_NO(33) | 0)
#define MT2701_PIN_33_I2S1_DATA__FUNC_I2S1_DATA (MTK_PIN_NO(33) | 1)
#define MT2701_PIN_33_I2S1_DATA__FUNC_I2S1_DATA_BYPS (MTK_PIN_NO(33) | 2)
#define MT2701_PIN_33_I2S1_DATA__FUNC_PCM_TX (MTK_PIN_NO(33) | 3)
#define MT2701_PIN_33_I2S1_DATA__FUNC_IMG_TEST_CK (MTK_PIN_NO(33) | 4)
#define MT2701_PIN_33_I2S1_DATA__FUNC_G1_RXD0 (MTK_PIN_NO(33) | 5)
#define MT2701_PIN_33_I2S1_DATA__FUNC_WCN_PCM_TX (MTK_PIN_NO(33) | 6)
#define MT2701_PIN_33_I2S1_DATA__FUNC_DBG_MON_B_8 (MTK_PIN_NO(33) | 7)

#define MT2701_PIN_34_I2S1_DATA_IN__FUNC_GPIO34 (MTK_PIN_NO(34) | 0)
#define MT2701_PIN_34_I2S1_DATA_IN__FUNC_I2S1_DATA_IN (MTK_PIN_NO(34) | 1)
#define MT2701_PIN_34_I2S1_DATA_IN__FUNC_PCM_RX (MTK_PIN_NO(34) | 3)
#define MT2701_PIN_34_I2S1_DATA_IN__FUNC_VDEC_TEST_CK (MTK_PIN_NO(34) | 4)
#define MT2701_PIN_34_I2S1_DATA_IN__FUNC_G1_RXD1 (MTK_PIN_NO(34) | 5)
#define MT2701_PIN_34_I2S1_DATA_IN__FUNC_WCN_PCM_RX (MTK_PIN_NO(34) | 6)
#define MT2701_PIN_34_I2S1_DATA_IN__FUNC_DBG_MON_B_7 (MTK_PIN_NO(34) | 7)

#define MT2701_PIN_35_I2S1_BCK__FUNC_GPIO35 (MTK_PIN_NO(35) | 0)
#define MT2701_PIN_35_I2S1_BCK__FUNC_I2S1_BCK (MTK_PIN_NO(35) | 1)
#define MT2701_PIN_35_I2S1_BCK__FUNC_PCM_CLK0 (MTK_PIN_NO(35) | 3)
#define MT2701_PIN_35_I2S1_BCK__FUNC_G1_RXD2 (MTK_PIN_NO(35) | 5)
#define MT2701_PIN_35_I2S1_BCK__FUNC_WCN_PCM_CLKO (MTK_PIN_NO(35) | 6)
#define MT2701_PIN_35_I2S1_BCK__FUNC_DBG_MON_B_9 (MTK_PIN_NO(35) | 7)

#define MT2701_PIN_36_I2S1_LRCK__FUNC_GPIO36 (MTK_PIN_NO(36) | 0)
#define MT2701_PIN_36_I2S1_LRCK__FUNC_I2S1_LRCK (MTK_PIN_NO(36) | 1)
#define MT2701_PIN_36_I2S1_LRCK__FUNC_PCM_SYNC (MTK_PIN_NO(36) | 3)
#define MT2701_PIN_36_I2S1_LRCK__FUNC_G1_RXD3 (MTK_PIN_NO(36) | 5)
#define MT2701_PIN_36_I2S1_LRCK__FUNC_WCN_PCM_SYNC (MTK_PIN_NO(36) | 6)
#define MT2701_PIN_36_I2S1_LRCK__FUNC_DBG_MON_B_10 (MTK_PIN_NO(36) | 7)

#define MT2701_PIN_37_I2S1_MCLK__FUNC_GPIO37 (MTK_PIN_NO(37) | 0)
#define MT2701_PIN_37_I2S1_MCLK__FUNC_I2S1_MCLK (MTK_PIN_NO(37) | 1)
#define MT2701_PIN_37_I2S1_MCLK__FUNC_G1_RXDV (MTK_PIN_NO(37) | 5)
#define MT2701_PIN_37_I2S1_MCLK__FUNC_DBG_MON_B_11 (MTK_PIN_NO(37) | 7)

#define MT2701_PIN_38_I2S2_DATA__FUNC_GPIO38 (MTK_PIN_NO(38) | 0)
#define MT2701_PIN_38_I2S2_DATA__FUNC_I2S2_DATA_BYPS (MTK_PIN_NO(38) | 2)
#define MT2701_PIN_38_I2S2_DATA__FUNC_PCM_TX (MTK_PIN_NO(38) | 3)
#define MT2701_PIN_38_I2S2_DATA__FUNC_DMIC_DAT0 (MTK_PIN_NO(38) | 4)

#define MT2701_PIN_39_JTMS__FUNC_GPIO39 (MTK_PIN_NO(39) | 0)
#define MT2701_PIN_39_JTMS__FUNC_JTMS (MTK_PIN_NO(39) | 1)
#define MT2701_PIN_39_JTMS__FUNC_CONN_MCU_TMS (MTK_PIN_NO(39) | 2)
#define MT2701_PIN_39_JTMS__FUNC_CONN_MCU_AICE_JMSC (MTK_PIN_NO(39) | 3)
#define MT2701_PIN_39_JTMS__FUNC_DFD_TMS_XI (MTK_PIN_NO(39) | 4)

#define MT2701_PIN_40_JTCK__FUNC_GPIO40 (MTK_PIN_NO(40) | 0)
#define MT2701_PIN_40_JTCK__FUNC_JTCK (MTK_PIN_NO(40) | 1)
#define MT2701_PIN_40_JTCK__FUNC_CONN_MCU_TCK1 (MTK_PIN_NO(40) | 2)
#define MT2701_PIN_40_JTCK__FUNC_CONN_MCU_AICE_JCKC (MTK_PIN_NO(40) | 3)
#define MT2701_PIN_40_JTCK__FUNC_DFD_TCK_XI (MTK_PIN_NO(40) | 4)

#define MT2701_PIN_41_JTDI__FUNC_GPIO41 (MTK_PIN_NO(41) | 0)
#define MT2701_PIN_41_JTDI__FUNC_JTDI (MTK_PIN_NO(41) | 1)
#define MT2701_PIN_41_JTDI__FUNC_CONN_MCU_TDI (MTK_PIN_NO(41) | 2)
#define MT2701_PIN_41_JTDI__FUNC_DFD_TDI_XI (MTK_PIN_NO(41) | 4)

#define MT2701_PIN_42_JTDO__FUNC_GPIO42 (MTK_PIN_NO(42) | 0)
#define MT2701_PIN_42_JTDO__FUNC_JTDO (MTK_PIN_NO(42) | 1)
#define MT2701_PIN_42_JTDO__FUNC_CONN_MCU_TDO (MTK_PIN_NO(42) | 2)
#define MT2701_PIN_42_JTDO__FUNC_DFD_TDO (MTK_PIN_NO(42) | 4)

#define MT2701_PIN_43_NCLE__FUNC_GPIO43 (MTK_PIN_NO(43) | 0)
#define MT2701_PIN_43_NCLE__FUNC_NCLE (MTK_PIN_NO(43) | 1)
#define MT2701_PIN_43_NCLE__FUNC_EXT_XCS2 (MTK_PIN_NO(43) | 2)

#define MT2701_PIN_44_NCEB1__FUNC_GPIO44 (MTK_PIN_NO(44) | 0)
#define MT2701_PIN_44_NCEB1__FUNC_NCEB1 (MTK_PIN_NO(44) | 1)
#define MT2701_PIN_44_NCEB1__FUNC_IDDIG (MTK_PIN_NO(44) | 2)

#define MT2701_PIN_45_NCEB0__FUNC_GPIO45 (MTK_PIN_NO(45) | 0)
#define MT2701_PIN_45_NCEB0__FUNC_NCEB0 (MTK_PIN_NO(45) | 1)
#define MT2701_PIN_45_NCEB0__FUNC_DRV_VBUS (MTK_PIN_NO(45) | 2)

#define MT2701_PIN_46_IR__FUNC_GPIO46 (MTK_PIN_NO(46) | 0)
#define MT2701_PIN_46_IR__FUNC_IR (MTK_PIN_NO(46) | 1)

#define MT2701_PIN_47_NREB__FUNC_GPIO47 (MTK_PIN_NO(47) | 0)
#define MT2701_PIN_47_NREB__FUNC_NREB (MTK_PIN_NO(47) | 1)
#define MT2701_PIN_47_NREB__FUNC_IDDIG_P1 (MTK_PIN_NO(47) | 2)

#define MT2701_PIN_48_NRNB__FUNC_GPIO48 (MTK_PIN_NO(48) | 0)
#define MT2701_PIN_48_NRNB__FUNC_NRNB (MTK_PIN_NO(48) | 1)
#define MT2701_PIN_48_NRNB__FUNC_DRV_VBUS_P1 (MTK_PIN_NO(48) | 2)

#define MT2701_PIN_49_I2S0_DATA__FUNC_GPIO49 (MTK_PIN_NO(49) | 0)
#define MT2701_PIN_49_I2S0_DATA__FUNC_I2S0_DATA (MTK_PIN_NO(49) | 1)
#define MT2701_PIN_49_I2S0_DATA__FUNC_I2S0_DATA_BYPS (MTK_PIN_NO(49) | 2)
#define MT2701_PIN_49_I2S0_DATA__FUNC_PCM_TX (MTK_PIN_NO(49) | 3)
#define MT2701_PIN_49_I2S0_DATA__FUNC_WCN_I2S_DO (MTK_PIN_NO(49) | 6)
#define MT2701_PIN_49_I2S0_DATA__FUNC_DBG_MON_B_3 (MTK_PIN_NO(49) | 7)

#define MT2701_PIN_50_I2S2_BCK__FUNC_GPIO50 (MTK_PIN_NO(50) | 0)
#define MT2701_PIN_50_I2S2_BCK__FUNC_I2S2_BCK (MTK_PIN_NO(50) | 1)
#define MT2701_PIN_50_I2S2_BCK__FUNC_PCM_CLK0 (MTK_PIN_NO(50) | 3)
#define MT2701_PIN_50_I2S2_BCK__FUNC_DMIC_SCK1 (MTK_PIN_NO(50) | 4)

#define MT2701_PIN_51_I2S2_DATA_IN__FUNC_GPIO51 (MTK_PIN_NO(51) | 0)
#define MT2701_PIN_51_I2S2_DATA_IN__FUNC_I2S2_DATA_IN (MTK_PIN_NO(51) | 1)
#define MT2701_PIN_51_I2S2_DATA_IN__FUNC_PCM_RX (MTK_PIN_NO(51) | 3)
#define MT2701_PIN_51_I2S2_DATA_IN__FUNC_DMIC_SCK0 (MTK_PIN_NO(51) | 4)

#define MT2701_PIN_52_I2S2_LRCK__FUNC_GPIO52 (MTK_PIN_NO(52) | 0)
#define MT2701_PIN_52_I2S2_LRCK__FUNC_I2S2_LRCK (MTK_PIN_NO(52) | 1)
#define MT2701_PIN_52_I2S2_LRCK__FUNC_PCM_SYNC (MTK_PIN_NO(52) | 3)
#define MT2701_PIN_52_I2S2_LRCK__FUNC_DMIC_DAT1 (MTK_PIN_NO(52) | 4)

#define MT2701_PIN_53_SPI0_CSN__FUNC_GPIO53 (MTK_PIN_NO(53) | 0)
#define MT2701_PIN_53_SPI0_CSN__FUNC_SPI0_CS (MTK_PIN_NO(53) | 1)
#define MT2701_PIN_53_SPI0_CSN__FUNC_SPDIF (MTK_PIN_NO(53) | 3)
#define MT2701_PIN_53_SPI0_CSN__FUNC_ADC_CK (MTK_PIN_NO(53) | 4)
#define MT2701_PIN_53_SPI0_CSN__FUNC_PWM1 (MTK_PIN_NO(53) | 5)
#define MT2701_PIN_53_SPI0_CSN__FUNC_DBG_MON_A_7 (MTK_PIN_NO(53) | 7)

#define MT2701_PIN_54_SPI0_CK__FUNC_GPIO54 (MTK_PIN_NO(54) | 0)
#define MT2701_PIN_54_SPI0_CK__FUNC_SPI0_CK (MTK_PIN_NO(54) | 1)
#define MT2701_PIN_54_SPI0_CK__FUNC_SPDIF_IN1 (MTK_PIN_NO(54) | 3)
#define MT2701_PIN_54_SPI0_CK__FUNC_ADC_DAT_IN (MTK_PIN_NO(54) | 4)
#define MT2701_PIN_54_SPI0_CK__FUNC_DBG_MON_A_10 (MTK_PIN_NO(54) | 7)

#define MT2701_PIN_55_SPI0_MI__FUNC_GPIO55 (MTK_PIN_NO(55) | 0)
#define MT2701_PIN_55_SPI0_MI__FUNC_SPI0_MI (MTK_PIN_NO(55) | 1)
#define MT2701_PIN_55_SPI0_MI__FUNC_SPI0_MO (MTK_PIN_NO(55) | 2)
#define MT2701_PIN_55_SPI0_MI__FUNC_MSDC1_WP (MTK_PIN_NO(55) | 3)
#define MT2701_PIN_55_SPI0_MI__FUNC_ADC_WS (MTK_PIN_NO(55) | 4)
#define MT2701_PIN_55_SPI0_MI__FUNC_PWM2 (MTK_PIN_NO(55) | 5)
#define MT2701_PIN_55_SPI0_MI__FUNC_DBG_MON_A_8 (MTK_PIN_NO(55) | 7)

#define MT2701_PIN_56_SPI0_MO__FUNC_GPIO56 (MTK_PIN_NO(56) | 0)
#define MT2701_PIN_56_SPI0_MO__FUNC_SPI0_MO (MTK_PIN_NO(56) | 1)
#define MT2701_PIN_56_SPI0_MO__FUNC_SPI0_MI (MTK_PIN_NO(56) | 2)
#define MT2701_PIN_56_SPI0_MO__FUNC_SPDIF_IN0 (MTK_PIN_NO(56) | 3)
#define MT2701_PIN_56_SPI0_MO__FUNC_DBG_MON_A_9 (MTK_PIN_NO(56) | 7)

#define MT2701_PIN_57_SDA1__FUNC_GPIO57 (MTK_PIN_NO(57) | 0)
#define MT2701_PIN_57_SDA1__FUNC_SDA1 (MTK_PIN_NO(57) | 1)

#define MT2701_PIN_58_SCL1__FUNC_GPIO58 (MTK_PIN_NO(58) | 0)
#define MT2701_PIN_58_SCL1__FUNC_SCL1 (MTK_PIN_NO(58) | 1)

#define MT2701_PIN_59_RAMBUF_I_CLK__FUNC_GPIO59 (MTK_PIN_NO(59) | 0)
#define MT2701_PIN_59_RAMBUF_I_CLK__FUNC_RAMBUF_I_CLK (MTK_PIN_NO(59) | 1)

#define MT2701_PIN_60_WB_RSTB__FUNC_GPIO60 (MTK_PIN_NO(60) | 0)
#define MT2701_PIN_60_WB_RSTB__FUNC_WB_RSTB (MTK_PIN_NO(60) | 1)
#define MT2701_PIN_60_WB_RSTB__FUNC_DBG_MON_A_11 (MTK_PIN_NO(60) | 7)

#define MT2701_PIN_61_F2W_DATA__FUNC_GPIO61 (MTK_PIN_NO(61) | 0)
#define MT2701_PIN_61_F2W_DATA__FUNC_F2W_DATA (MTK_PIN_NO(61) | 1)
#define MT2701_PIN_61_F2W_DATA__FUNC_DBG_MON_A_16 (MTK_PIN_NO(61) | 7)

#define MT2701_PIN_62_F2W_CLK__FUNC_GPIO62 (MTK_PIN_NO(62) | 0)
#define MT2701_PIN_62_F2W_CLK__FUNC_F2W_CK (MTK_PIN_NO(62) | 1)
#define MT2701_PIN_62_F2W_CLK__FUNC_DBG_MON_A_15 (MTK_PIN_NO(62) | 7)

#define MT2701_PIN_63_WB_SCLK__FUNC_GPIO63 (MTK_PIN_NO(63) | 0)
#define MT2701_PIN_63_WB_SCLK__FUNC_WB_SCLK (MTK_PIN_NO(63) | 1)
#define MT2701_PIN_63_WB_SCLK__FUNC_DBG_MON_A_13 (MTK_PIN_NO(63) | 7)

#define MT2701_PIN_64_WB_SDATA__FUNC_GPIO64 (MTK_PIN_NO(64) | 0)
#define MT2701_PIN_64_WB_SDATA__FUNC_WB_SDATA (MTK_PIN_NO(64) | 1)
#define MT2701_PIN_64_WB_SDATA__FUNC_DBG_MON_A_12 (MTK_PIN_NO(64) | 7)

#define MT2701_PIN_65_WB_SEN__FUNC_GPIO65 (MTK_PIN_NO(65) | 0)
#define MT2701_PIN_65_WB_SEN__FUNC_WB_SEN (MTK_PIN_NO(65) | 1)
#define MT2701_PIN_65_WB_SEN__FUNC_DBG_MON_A_14 (MTK_PIN_NO(65) | 7)

#define MT2701_PIN_66_WB_CRTL0__FUNC_GPIO66 (MTK_PIN_NO(66) | 0)
#define MT2701_PIN_66_WB_CRTL0__FUNC_WB_CRTL0 (MTK_PIN_NO(66) | 1)
#define MT2701_PIN_66_WB_CRTL0__FUNC_DFD_NTRST_XI (MTK_PIN_NO(66) | 5)
#define MT2701_PIN_66_WB_CRTL0__FUNC_DBG_MON_A_17 (MTK_PIN_NO(66) | 7)

#define MT2701_PIN_67_WB_CRTL1__FUNC_GPIO67 (MTK_PIN_NO(67) | 0)
#define MT2701_PIN_67_WB_CRTL1__FUNC_WB_CRTL1 (MTK_PIN_NO(67) | 1)
#define MT2701_PIN_67_WB_CRTL1__FUNC_DFD_TMS_XI (MTK_PIN_NO(67) | 5)
#define MT2701_PIN_67_WB_CRTL1__FUNC_DBG_MON_A_18 (MTK_PIN_NO(67) | 7)

#define MT2701_PIN_68_WB_CRTL2__FUNC_GPIO68 (MTK_PIN_NO(68) | 0)
#define MT2701_PIN_68_WB_CRTL2__FUNC_WB_CRTL2 (MTK_PIN_NO(68) | 1)
#define MT2701_PIN_68_WB_CRTL2__FUNC_DFD_TCK_XI (MTK_PIN_NO(68) | 5)
#define MT2701_PIN_68_WB_CRTL2__FUNC_DBG_MON_A_19 (MTK_PIN_NO(68) | 7)

#define MT2701_PIN_69_WB_CRTL3__FUNC_GPIO69 (MTK_PIN_NO(69) | 0)
#define MT2701_PIN_69_WB_CRTL3__FUNC_WB_CRTL3 (MTK_PIN_NO(69) | 1)
#define MT2701_PIN_69_WB_CRTL3__FUNC_DFD_TDI_XI (MTK_PIN_NO(69) | 5)
#define MT2701_PIN_69_WB_CRTL3__FUNC_DBG_MON_A_20 (MTK_PIN_NO(69) | 7)

#define MT2701_PIN_70_WB_CRTL4__FUNC_GPIO70 (MTK_PIN_NO(70) | 0)
#define MT2701_PIN_70_WB_CRTL4__FUNC_WB_CRTL4 (MTK_PIN_NO(70) | 1)
#define MT2701_PIN_70_WB_CRTL4__FUNC_DFD_TDO (MTK_PIN_NO(70) | 5)
#define MT2701_PIN_70_WB_CRTL4__FUNC_DBG_MON_A_21 (MTK_PIN_NO(70) | 7)

#define MT2701_PIN_71_WB_CRTL5__FUNC_GPIO71 (MTK_PIN_NO(71) | 0)
#define MT2701_PIN_71_WB_CRTL5__FUNC_WB_CRTL5 (MTK_PIN_NO(71) | 1)
#define MT2701_PIN_71_WB_CRTL5__FUNC_DBG_MON_A_22 (MTK_PIN_NO(71) | 7)

#define MT2701_PIN_72_I2S0_DATA_IN__FUNC_GPIO72 (MTK_PIN_NO(72) | 0)
#define MT2701_PIN_72_I2S0_DATA_IN__FUNC_I2S0_DATA_IN (MTK_PIN_NO(72) | 1)
#define MT2701_PIN_72_I2S0_DATA_IN__FUNC_PCM_RX (MTK_PIN_NO(72) | 3)
#define MT2701_PIN_72_I2S0_DATA_IN__FUNC_PWM0 (MTK_PIN_NO(72) | 4)
#define MT2701_PIN_72_I2S0_DATA_IN__FUNC_DISP_PWM (MTK_PIN_NO(72) | 5)
#define MT2701_PIN_72_I2S0_DATA_IN__FUNC_WCN_I2S_DI (MTK_PIN_NO(72) | 6)
#define MT2701_PIN_72_I2S0_DATA_IN__FUNC_DBG_MON_B_2 (MTK_PIN_NO(72) | 7)

#define MT2701_PIN_73_I2S0_LRCK__FUNC_GPIO73 (MTK_PIN_NO(73) | 0)
#define MT2701_PIN_73_I2S0_LRCK__FUNC_I2S0_LRCK (MTK_PIN_NO(73) | 1)
#define MT2701_PIN_73_I2S0_LRCK__FUNC_PCM_SYNC (MTK_PIN_NO(73) | 3)
#define MT2701_PIN_73_I2S0_LRCK__FUNC_WCN_I2S_LRCK (MTK_PIN_NO(73) | 6)
#define MT2701_PIN_73_I2S0_LRCK__FUNC_DBG_MON_B_5 (MTK_PIN_NO(73) | 7)

#define MT2701_PIN_74_I2S0_BCK__FUNC_GPIO74 (MTK_PIN_NO(74) | 0)
#define MT2701_PIN_74_I2S0_BCK__FUNC_I2S0_BCK (MTK_PIN_NO(74) | 1)
#define MT2701_PIN_74_I2S0_BCK__FUNC_PCM_CLK0 (MTK_PIN_NO(74) | 3)
#define MT2701_PIN_74_I2S0_BCK__FUNC_WCN_I2S_BCK (MTK_PIN_NO(74) | 6)
#define MT2701_PIN_74_I2S0_BCK__FUNC_DBG_MON_B_4 (MTK_PIN_NO(74) | 7)

#define MT2701_PIN_75_SDA0__FUNC_GPIO75 (MTK_PIN_NO(75) | 0)
#define MT2701_PIN_75_SDA0__FUNC_SDA0 (MTK_PIN_NO(75) | 1)

#define MT2701_PIN_76_SCL0__FUNC_GPIO76 (MTK_PIN_NO(76) | 0)
#define MT2701_PIN_76_SCL0__FUNC_SCL0 (MTK_PIN_NO(76) | 1)

#define MT2701_PIN_77_SDA2__FUNC_GPIO77 (MTK_PIN_NO(77) | 0)
#define MT2701_PIN_77_SDA2__FUNC_SDA2 (MTK_PIN_NO(77) | 1)

#define MT2701_PIN_78_SCL2__FUNC_GPIO78 (MTK_PIN_NO(78) | 0)
#define MT2701_PIN_78_SCL2__FUNC_SCL2 (MTK_PIN_NO(78) | 1)

#define MT2701_PIN_79_URXD0__FUNC_GPIO79 (MTK_PIN_NO(79) | 0)
#define MT2701_PIN_79_URXD0__FUNC_URXD0 (MTK_PIN_NO(79) | 1)
#define MT2701_PIN_79_URXD0__FUNC_UTXD0 (MTK_PIN_NO(79) | 2)
#define MT2701_PIN_79_URXD0__FUNC_ (MTK_PIN_NO(79) | 5)

#define MT2701_PIN_80_UTXD0__FUNC_GPIO80 (MTK_PIN_NO(80) | 0)
#define MT2701_PIN_80_UTXD0__FUNC_UTXD0 (MTK_PIN_NO(80) | 1)
#define MT2701_PIN_80_UTXD0__FUNC_URXD0 (MTK_PIN_NO(80) | 2)

#define MT2701_PIN_81_URXD1__FUNC_GPIO81 (MTK_PIN_NO(81) | 0)
#define MT2701_PIN_81_URXD1__FUNC_URXD1 (MTK_PIN_NO(81) | 1)
#define MT2701_PIN_81_URXD1__FUNC_UTXD1 (MTK_PIN_NO(81) | 2)

#define MT2701_PIN_82_UTXD1__FUNC_GPIO82 (MTK_PIN_NO(82) | 0)
#define MT2701_PIN_82_UTXD1__FUNC_UTXD1 (MTK_PIN_NO(82) | 1)
#define MT2701_PIN_82_UTXD1__FUNC_URXD1 (MTK_PIN_NO(82) | 2)

#define MT2701_PIN_83_LCM_RST__FUNC_GPIO83 (MTK_PIN_NO(83) | 0)
#define MT2701_PIN_83_LCM_RST__FUNC_LCM_RST (MTK_PIN_NO(83) | 1)
#define MT2701_PIN_83_LCM_RST__FUNC_VDAC_CK_XI (MTK_PIN_NO(83) | 2)
#define MT2701_PIN_83_LCM_RST__FUNC_DBG_MON_B_1 (MTK_PIN_NO(83) | 7)

#define MT2701_PIN_84_DSI_TE__FUNC_GPIO84 (MTK_PIN_NO(84) | 0)
#define MT2701_PIN_84_DSI_TE__FUNC_DSI_TE (MTK_PIN_NO(84) | 1)
#define MT2701_PIN_84_DSI_TE__FUNC_DBG_MON_B_0 (MTK_PIN_NO(84) | 7)

#define MT2701_PIN_85_MSDC2_CMD__FUNC_GPIO85 (MTK_PIN_NO(85) | 0)
#define MT2701_PIN_85_MSDC2_CMD__FUNC_MSDC2_CMD (MTK_PIN_NO(85) | 1)
#define MT2701_PIN_85_MSDC2_CMD__FUNC_ANT_SEL0 (MTK_PIN_NO(85) | 2)
#define MT2701_PIN_85_MSDC2_CMD__FUNC_SDA1 (MTK_PIN_NO(85) | 3)
#define MT2701_PIN_85_MSDC2_CMD__FUNC_I2SOUT_BCK (MTK_PIN_NO(85) | 6)

#define MT2701_PIN_86_MSDC2_CLK__FUNC_GPIO86 (MTK_PIN_NO(86) | 0)
#define MT2701_PIN_86_MSDC2_CLK__FUNC_MSDC2_CLK (MTK_PIN_NO(86) | 1)
#define MT2701_PIN_86_MSDC2_CLK__FUNC_ANT_SEL1 (MTK_PIN_NO(86) | 2)
#define MT2701_PIN_86_MSDC2_CLK__FUNC_SCL1 (MTK_PIN_NO(86) | 3)
#define MT2701_PIN_86_MSDC2_CLK__FUNC_I2SOUT_LRCK (MTK_PIN_NO(86) | 6)

#define MT2701_PIN_87_MSDC2_DAT0__FUNC_GPIO87 (MTK_PIN_NO(87) | 0)
#define MT2701_PIN_87_MSDC2_DAT0__FUNC_MSDC2_DAT0 (MTK_PIN_NO(87) | 1)
#define MT2701_PIN_87_MSDC2_DAT0__FUNC_ANT_SEL2 (MTK_PIN_NO(87) | 2)
#define MT2701_PIN_87_MSDC2_DAT0__FUNC_UTXD0 (MTK_PIN_NO(87) | 5)
#define MT2701_PIN_87_MSDC2_DAT0__FUNC_I2SOUT_DATA_OUT (MTK_PIN_NO(87) | 6)

#define MT2701_PIN_88_MSDC2_DAT1__FUNC_GPIO88 (MTK_PIN_NO(88) | 0)
#define MT2701_PIN_88_MSDC2_DAT1__FUNC_MSDC2_DAT1 (MTK_PIN_NO(88) | 1)
#define MT2701_PIN_88_MSDC2_DAT1__FUNC_ANT_SEL3 (MTK_PIN_NO(88) | 2)
#define MT2701_PIN_88_MSDC2_DAT1__FUNC_PWM0 (MTK_PIN_NO(88) | 3)
#define MT2701_PIN_88_MSDC2_DAT1__FUNC_URXD0 (MTK_PIN_NO(88) | 5)
#define MT2701_PIN_88_MSDC2_DAT1__FUNC_PWM1 (MTK_PIN_NO(88) | 6)

#define MT2701_PIN_89_MSDC2_DAT2__FUNC_GPIO89 (MTK_PIN_NO(89) | 0)
#define MT2701_PIN_89_MSDC2_DAT2__FUNC_MSDC2_DAT2 (MTK_PIN_NO(89) | 1)
#define MT2701_PIN_89_MSDC2_DAT2__FUNC_ANT_SEL4 (MTK_PIN_NO(89) | 2)
#define MT2701_PIN_89_MSDC2_DAT2__FUNC_SDA2 (MTK_PIN_NO(89) | 3)
#define MT2701_PIN_89_MSDC2_DAT2__FUNC_UTXD1 (MTK_PIN_NO(89) | 5)
#define MT2701_PIN_89_MSDC2_DAT2__FUNC_PWM2 (MTK_PIN_NO(89) | 6)

#define MT2701_PIN_90_MSDC2_DAT3__FUNC_GPIO90 (MTK_PIN_NO(90) | 0)
#define MT2701_PIN_90_MSDC2_DAT3__FUNC_MSDC2_DAT3 (MTK_PIN_NO(90) | 1)
#define MT2701_PIN_90_MSDC2_DAT3__FUNC_ANT_SEL5 (MTK_PIN_NO(90) | 2)
#define MT2701_PIN_90_MSDC2_DAT3__FUNC_SCL2 (MTK_PIN_NO(90) | 3)
#define MT2701_PIN_90_MSDC2_DAT3__FUNC_EXT_FRAME_SYNC (MTK_PIN_NO(90) | 4)
#define MT2701_PIN_90_MSDC2_DAT3__FUNC_URXD1 (MTK_PIN_NO(90) | 5)
#define MT2701_PIN_90_MSDC2_DAT3__FUNC_PWM3 (MTK_PIN_NO(90) | 6)

#define MT2701_PIN_91_TDN3__FUNC_GPI91 (MTK_PIN_NO(91) | 0)
#define MT2701_PIN_91_TDN3__FUNC_TDN3 (MTK_PIN_NO(91) | 1)

#define MT2701_PIN_92_TDP3__FUNC_GPI92 (MTK_PIN_NO(92) | 0)
#define MT2701_PIN_92_TDP3__FUNC_TDP3 (MTK_PIN_NO(92) | 1)

#define MT2701_PIN_93_TDN2__FUNC_GPI93 (MTK_PIN_NO(93) | 0)
#define MT2701_PIN_93_TDN2__FUNC_TDN2 (MTK_PIN_NO(93) | 1)

#define MT2701_PIN_94_TDP2__FUNC_GPI94 (MTK_PIN_NO(94) | 0)
#define MT2701_PIN_94_TDP2__FUNC_TDP2 (MTK_PIN_NO(94) | 1)

#define MT2701_PIN_95_TCN__FUNC_GPI95 (MTK_PIN_NO(95) | 0)
#define MT2701_PIN_95_TCN__FUNC_TCN (MTK_PIN_NO(95) | 1)

#define MT2701_PIN_96_TCP__FUNC_GPI96 (MTK_PIN_NO(96) | 0)
#define MT2701_PIN_96_TCP__FUNC_TCP (MTK_PIN_NO(96) | 1)

#define MT2701_PIN_97_TDN1__FUNC_GPI97 (MTK_PIN_NO(97) | 0)
#define MT2701_PIN_97_TDN1__FUNC_TDN1 (MTK_PIN_NO(97) | 1)

#define MT2701_PIN_98_TDP1__FUNC_GPI98 (MTK_PIN_NO(98) | 0)
#define MT2701_PIN_98_TDP1__FUNC_TDP1 (MTK_PIN_NO(98) | 1)

#define MT2701_PIN_99_TDN0__FUNC_GPI99 (MTK_PIN_NO(99) | 0)
#define MT2701_PIN_99_TDN0__FUNC_TDN0 (MTK_PIN_NO(99) | 1)

#define MT2701_PIN_100_TDP0__FUNC_GPI100 (MTK_PIN_NO(100) | 0)
#define MT2701_PIN_100_TDP0__FUNC_TDP0 (MTK_PIN_NO(100) | 1)

#define MT2701_PIN_101_SPI2_CSN__FUNC_GPIO101 (MTK_PIN_NO(101) | 0)
#define MT2701_PIN_101_SPI2_CSN__FUNC_SPI2_CS (MTK_PIN_NO(101) | 1)
#define MT2701_PIN_101_SPI2_CSN__FUNC_SCL3 (MTK_PIN_NO(101) | 3)
#define MT2701_PIN_101_SPI2_CSN__FUNC_KROW0 (MTK_PIN_NO(101) | 4)

#define MT2701_PIN_102_SPI2_MI__FUNC_GPIO102 (MTK_PIN_NO(102) | 0)
#define MT2701_PIN_102_SPI2_MI__FUNC_SPI2_MI (MTK_PIN_NO(102) | 1)
#define MT2701_PIN_102_SPI2_MI__FUNC_SPI2_MO (MTK_PIN_NO(102) | 2)
#define MT2701_PIN_102_SPI2_MI__FUNC_SDA3 (MTK_PIN_NO(102) | 3)
#define MT2701_PIN_102_SPI2_MI__FUNC_KROW1 (MTK_PIN_NO(102) | 4)

#define MT2701_PIN_103_SPI2_MO__FUNC_GPIO103 (MTK_PIN_NO(103) | 0)
#define MT2701_PIN_103_SPI2_MO__FUNC_SPI2_MO (MTK_PIN_NO(103) | 1)
#define MT2701_PIN_103_SPI2_MO__FUNC_SPI2_MI (MTK_PIN_NO(103) | 2)
#define MT2701_PIN_103_SPI2_MO__FUNC_SCL3 (MTK_PIN_NO(103) | 3)
#define MT2701_PIN_103_SPI2_MO__FUNC_KROW2 (MTK_PIN_NO(103) | 4)

#define MT2701_PIN_104_SPI2_CLK__FUNC_GPIO104 (MTK_PIN_NO(104) | 0)
#define MT2701_PIN_104_SPI2_CLK__FUNC_SPI2_CK (MTK_PIN_NO(104) | 1)
#define MT2701_PIN_104_SPI2_CLK__FUNC_SDA3 (MTK_PIN_NO(104) | 3)
#define MT2701_PIN_104_SPI2_CLK__FUNC_KROW3 (MTK_PIN_NO(104) | 4)

#define MT2701_PIN_105_MSDC1_CMD__FUNC_GPIO105 (MTK_PIN_NO(105) | 0)
#define MT2701_PIN_105_MSDC1_CMD__FUNC_MSDC1_CMD (MTK_PIN_NO(105) | 1)
#define MT2701_PIN_105_MSDC1_CMD__FUNC_ANT_SEL0 (MTK_PIN_NO(105) | 2)
#define MT2701_PIN_105_MSDC1_CMD__FUNC_SDA1 (MTK_PIN_NO(105) | 3)
#define MT2701_PIN_105_MSDC1_CMD__FUNC_I2SOUT_BCK (MTK_PIN_NO(105) | 6)
#define MT2701_PIN_105_MSDC1_CMD__FUNC_DBG_MON_B_27 (MTK_PIN_NO(105) | 7)

#define MT2701_PIN_106_MSDC1_CLK__FUNC_GPIO106 (MTK_PIN_NO(106) | 0)
#define MT2701_PIN_106_MSDC1_CLK__FUNC_MSDC1_CLK (MTK_PIN_NO(106) | 1)
#define MT2701_PIN_106_MSDC1_CLK__FUNC_ANT_SEL1 (MTK_PIN_NO(106) | 2)
#define MT2701_PIN_106_MSDC1_CLK__FUNC_SCL1 (MTK_PIN_NO(106) | 3)
#define MT2701_PIN_106_MSDC1_CLK__FUNC_I2SOUT_LRCK (MTK_PIN_NO(106) | 6)
#define MT2701_PIN_106_MSDC1_CLK__FUNC_DBG_MON_B_28 (MTK_PIN_NO(106) | 7)

#define MT2701_PIN_107_MSDC1_DAT0__FUNC_GPIO107 (MTK_PIN_NO(107) | 0)
#define MT2701_PIN_107_MSDC1_DAT0__FUNC_MSDC1_DAT0 (MTK_PIN_NO(107) | 1)
#define MT2701_PIN_107_MSDC1_DAT0__FUNC_ANT_SEL2 (MTK_PIN_NO(107) | 2)
#define MT2701_PIN_107_MSDC1_DAT0__FUNC_UTXD0 (MTK_PIN_NO(107) | 5)
#define MT2701_PIN_107_MSDC1_DAT0__FUNC_I2SOUT_DATA_OUT (MTK_PIN_NO(107) | 6)
#define MT2701_PIN_107_MSDC1_DAT0__FUNC_DBG_MON_B_26 (MTK_PIN_NO(107) | 7)

#define MT2701_PIN_108_MSDC1_DAT1__FUNC_GPIO108 (MTK_PIN_NO(108) | 0)
#define MT2701_PIN_108_MSDC1_DAT1__FUNC_MSDC1_DAT1 (MTK_PIN_NO(108) | 1)
#define MT2701_PIN_108_MSDC1_DAT1__FUNC_ANT_SEL3 (MTK_PIN_NO(108) | 2)
#define MT2701_PIN_108_MSDC1_DAT1__FUNC_PWM0 (MTK_PIN_NO(108) | 3)
#define MT2701_PIN_108_MSDC1_DAT1__FUNC_URXD0 (MTK_PIN_NO(108) | 5)
#define MT2701_PIN_108_MSDC1_DAT1__FUNC_PWM1 (MTK_PIN_NO(108) | 6)
#define MT2701_PIN_108_MSDC1_DAT1__FUNC_DBG_MON_B_25 (MTK_PIN_NO(108) | 7)

#define MT2701_PIN_109_MSDC1_DAT2__FUNC_GPIO109 (MTK_PIN_NO(109) | 0)
#define MT2701_PIN_109_MSDC1_DAT2__FUNC_MSDC1_DAT2 (MTK_PIN_NO(109) | 1)
#define MT2701_PIN_109_MSDC1_DAT2__FUNC_ANT_SEL4 (MTK_PIN_NO(109) | 2)
#define MT2701_PIN_109_MSDC1_DAT2__FUNC_SDA2 (MTK_PIN_NO(109) | 3)
#define MT2701_PIN_109_MSDC1_DAT2__FUNC_UTXD1 (MTK_PIN_NO(109) | 5)
#define MT2701_PIN_109_MSDC1_DAT2__FUNC_PWM2 (MTK_PIN_NO(109) | 6)
#define MT2701_PIN_109_MSDC1_DAT2__FUNC_DBG_MON_B_24 (MTK_PIN_NO(109) | 7)

#define MT2701_PIN_110_MSDC1_DAT3__FUNC_GPIO110 (MTK_PIN_NO(110) | 0)
#define MT2701_PIN_110_MSDC1_DAT3__FUNC_MSDC1_DAT3 (MTK_PIN_NO(110) | 1)
#define MT2701_PIN_110_MSDC1_DAT3__FUNC_ANT_SEL5 (MTK_PIN_NO(110) | 2)
#define MT2701_PIN_110_MSDC1_DAT3__FUNC_SCL2 (MTK_PIN_NO(110) | 3)
#define MT2701_PIN_110_MSDC1_DAT3__FUNC_EXT_FRAME_SYNC (MTK_PIN_NO(110) | 4)
#define MT2701_PIN_110_MSDC1_DAT3__FUNC_URXD1 (MTK_PIN_NO(110) | 5)
#define MT2701_PIN_110_MSDC1_DAT3__FUNC_PWM3 (MTK_PIN_NO(110) | 6)
#define MT2701_PIN_110_MSDC1_DAT3__FUNC_DBG_MON_B_23 (MTK_PIN_NO(110) | 7)

#define MT2701_PIN_111_MSDC0_DAT7__FUNC_GPIO111 (MTK_PIN_NO(111) | 0)
#define MT2701_PIN_111_MSDC0_DAT7__FUNC_MSDC0_DAT7 (MTK_PIN_NO(111) | 1)
#define MT2701_PIN_111_MSDC0_DAT7__FUNC_NLD7 (MTK_PIN_NO(111) | 4)

#define MT2701_PIN_112_MSDC0_DAT6__FUNC_GPIO112 (MTK_PIN_NO(112) | 0)
#define MT2701_PIN_112_MSDC0_DAT6__FUNC_MSDC0_DAT6 (MTK_PIN_NO(112) | 1)
#define MT2701_PIN_112_MSDC0_DAT6__FUNC_NLD6 (MTK_PIN_NO(112) | 4)

#define MT2701_PIN_113_MSDC0_DAT5__FUNC_GPIO113 (MTK_PIN_NO(113) | 0)
#define MT2701_PIN_113_MSDC0_DAT5__FUNC_MSDC0_DAT5 (MTK_PIN_NO(113) | 1)
#define MT2701_PIN_113_MSDC0_DAT5__FUNC_NLD5 (MTK_PIN_NO(113) | 4)

#define MT2701_PIN_114_MSDC0_DAT4__FUNC_GPIO114 (MTK_PIN_NO(114) | 0)
#define MT2701_PIN_114_MSDC0_DAT4__FUNC_MSDC0_DAT4 (MTK_PIN_NO(114) | 1)
#define MT2701_PIN_114_MSDC0_DAT4__FUNC_NLD4 (MTK_PIN_NO(114) | 4)

#define MT2701_PIN_115_MSDC0_RSTB__FUNC_GPIO115 (MTK_PIN_NO(115) | 0)
#define MT2701_PIN_115_MSDC0_RSTB__FUNC_MSDC0_RSTB (MTK_PIN_NO(115) | 1)
#define MT2701_PIN_115_MSDC0_RSTB__FUNC_NLD8 (MTK_PIN_NO(115) | 4)

#define MT2701_PIN_116_MSDC0_CMD__FUNC_GPIO116 (MTK_PIN_NO(116) | 0)
#define MT2701_PIN_116_MSDC0_CMD__FUNC_MSDC0_CMD (MTK_PIN_NO(116) | 1)
#define MT2701_PIN_116_MSDC0_CMD__FUNC_NALE (MTK_PIN_NO(116) | 4)

#define MT2701_PIN_117_MSDC0_CLK__FUNC_GPIO117 (MTK_PIN_NO(117) | 0)
#define MT2701_PIN_117_MSDC0_CLK__FUNC_MSDC0_CLK (MTK_PIN_NO(117) | 1)
#define MT2701_PIN_117_MSDC0_CLK__FUNC_NWEB (MTK_PIN_NO(117) | 4)

#define MT2701_PIN_118_MSDC0_DAT3__FUNC_GPIO118 (MTK_PIN_NO(118) | 0)
#define MT2701_PIN_118_MSDC0_DAT3__FUNC_MSDC0_DAT3 (MTK_PIN_NO(118) | 1)
#define MT2701_PIN_118_MSDC0_DAT3__FUNC_NLD3 (MTK_PIN_NO(118) | 4)

#define MT2701_PIN_119_MSDC0_DAT2__FUNC_GPIO119 (MTK_PIN_NO(119) | 0)
#define MT2701_PIN_119_MSDC0_DAT2__FUNC_MSDC0_DAT2 (MTK_PIN_NO(119) | 1)
#define MT2701_PIN_119_MSDC0_DAT2__FUNC_NLD2 (MTK_PIN_NO(119) | 4)

#define MT2701_PIN_120_MSDC0_DAT1__FUNC_GPIO120 (MTK_PIN_NO(120) | 0)
#define MT2701_PIN_120_MSDC0_DAT1__FUNC_MSDC0_DAT1 (MTK_PIN_NO(120) | 1)
#define MT2701_PIN_120_MSDC0_DAT1__FUNC_NLD1 (MTK_PIN_NO(120) | 4)

#define MT2701_PIN_121_MSDC0_DAT0__FUNC_GPIO121 (MTK_PIN_NO(121) | 0)
#define MT2701_PIN_121_MSDC0_DAT0__FUNC_MSDC0_DAT0 (MTK_PIN_NO(121) | 1)
#define MT2701_PIN_121_MSDC0_DAT0__FUNC_NLD0 (MTK_PIN_NO(121) | 4)
#define MT2701_PIN_121_MSDC0_DAT0__FUNC_WATCHDOG (MTK_PIN_NO(121) | 5)

#define MT2701_PIN_122_CEC__FUNC_GPIO122 (MTK_PIN_NO(122) | 0)
#define MT2701_PIN_122_CEC__FUNC_CEC (MTK_PIN_NO(122) | 1)
#define MT2701_PIN_122_CEC__FUNC_SDA2 (MTK_PIN_NO(122) | 4)
#define MT2701_PIN_122_CEC__FUNC_URXD0 (MTK_PIN_NO(122) | 5)

#define MT2701_PIN_123_HTPLG__FUNC_GPIO123 (MTK_PIN_NO(123) | 0)
#define MT2701_PIN_123_HTPLG__FUNC_HTPLG (MTK_PIN_NO(123) | 1)
#define MT2701_PIN_123_HTPLG__FUNC_SCL2 (MTK_PIN_NO(123) | 4)
#define MT2701_PIN_123_HTPLG__FUNC_UTXD0 (MTK_PIN_NO(123) | 5)

#define MT2701_PIN_124_HDMISCK__FUNC_GPIO124 (MTK_PIN_NO(124) | 0)
#define MT2701_PIN_124_HDMISCK__FUNC_HDMISCK (MTK_PIN_NO(124) | 1)
#define MT2701_PIN_124_HDMISCK__FUNC_SDA1 (MTK_PIN_NO(124) | 4)
#define MT2701_PIN_124_HDMISCK__FUNC_PWM3 (MTK_PIN_NO(124) | 5)

#define MT2701_PIN_125_HDMISD__FUNC_GPIO125 (MTK_PIN_NO(125) | 0)
#define MT2701_PIN_125_HDMISD__FUNC_HDMISD (MTK_PIN_NO(125) | 1)
#define MT2701_PIN_125_HDMISD__FUNC_SCL1 (MTK_PIN_NO(125) | 4)
#define MT2701_PIN_125_HDMISD__FUNC_PWM4 (MTK_PIN_NO(125) | 5)

#define MT2701_PIN_126_I2S0_MCLK__FUNC_GPIO126 (MTK_PIN_NO(126) | 0)
#define MT2701_PIN_126_I2S0_MCLK__FUNC_I2S0_MCLK (MTK_PIN_NO(126) | 1)
#define MT2701_PIN_126_I2S0_MCLK__FUNC_WCN_I2S_MCLK (MTK_PIN_NO(126) | 6)
#define MT2701_PIN_126_I2S0_MCLK__FUNC_DBG_MON_B_6 (MTK_PIN_NO(126) | 7)

#define MT2701_PIN_127_RAMBUF_IDATA0__FUNC_GPIO127 (MTK_PIN_NO(127) | 0)
#define MT2701_PIN_127_RAMBUF_IDATA0__FUNC_RAMBUF_IDATA0 (MTK_PIN_NO(127) | 1)

#define MT2701_PIN_128_RAMBUF_IDATA1__FUNC_GPIO128 (MTK_PIN_NO(128) | 0)
#define MT2701_PIN_128_RAMBUF_IDATA1__FUNC_RAMBUF_IDATA1 (MTK_PIN_NO(128) | 1)

#define MT2701_PIN_129_RAMBUF_IDATA2__FUNC_GPIO129 (MTK_PIN_NO(129) | 0)
#define MT2701_PIN_129_RAMBUF_IDATA2__FUNC_RAMBUF_IDATA2 (MTK_PIN_NO(129) | 1)

#define MT2701_PIN_130_RAMBUF_IDATA3__FUNC_GPIO130 (MTK_PIN_NO(130) | 0)
#define MT2701_PIN_130_RAMBUF_IDATA3__FUNC_RAMBUF_IDATA3 (MTK_PIN_NO(130) | 1)

#define MT2701_PIN_131_RAMBUF_IDATA4__FUNC_GPIO131 (MTK_PIN_NO(131) | 0)
#define MT2701_PIN_131_RAMBUF_IDATA4__FUNC_RAMBUF_IDATA4 (MTK_PIN_NO(131) | 1)

#define MT2701_PIN_132_RAMBUF_IDATA5__FUNC_GPIO132 (MTK_PIN_NO(132) | 0)
#define MT2701_PIN_132_RAMBUF_IDATA5__FUNC_RAMBUF_IDATA5 (MTK_PIN_NO(132) | 1)

#define MT2701_PIN_133_RAMBUF_IDATA6__FUNC_GPIO133 (MTK_PIN_NO(133) | 0)
#define MT2701_PIN_133_RAMBUF_IDATA6__FUNC_RAMBUF_IDATA6 (MTK_PIN_NO(133) | 1)

#define MT2701_PIN_134_RAMBUF_IDATA7__FUNC_GPIO134 (MTK_PIN_NO(134) | 0)
#define MT2701_PIN_134_RAMBUF_IDATA7__FUNC_RAMBUF_IDATA7 (MTK_PIN_NO(134) | 1)

#define MT2701_PIN_135_RAMBUF_IDATA8__FUNC_GPIO135 (MTK_PIN_NO(135) | 0)
#define MT2701_PIN_135_RAMBUF_IDATA8__FUNC_RAMBUF_IDATA8 (MTK_PIN_NO(135) | 1)

#define MT2701_PIN_136_RAMBUF_IDATA9__FUNC_GPIO136 (MTK_PIN_NO(136) | 0)
#define MT2701_PIN_136_RAMBUF_IDATA9__FUNC_RAMBUF_IDATA9 (MTK_PIN_NO(136) | 1)

#define MT2701_PIN_137_RAMBUF_IDATA10__FUNC_GPIO137 (MTK_PIN_NO(137) | 0)
#define MT2701_PIN_137_RAMBUF_IDATA10__FUNC_RAMBUF_IDATA10 (MTK_PIN_NO(137) | 1)

#define MT2701_PIN_138_RAMBUF_IDATA11__FUNC_GPIO138 (MTK_PIN_NO(138) | 0)
#define MT2701_PIN_138_RAMBUF_IDATA11__FUNC_RAMBUF_IDATA11 (MTK_PIN_NO(138) | 1)

#define MT2701_PIN_139_RAMBUF_IDATA12__FUNC_GPIO139 (MTK_PIN_NO(139) | 0)
#define MT2701_PIN_139_RAMBUF_IDATA12__FUNC_RAMBUF_IDATA12 (MTK_PIN_NO(139) | 1)

#define MT2701_PIN_140_RAMBUF_IDATA13__FUNC_GPIO140 (MTK_PIN_NO(140) | 0)
#define MT2701_PIN_140_RAMBUF_IDATA13__FUNC_RAMBUF_IDATA13 (MTK_PIN_NO(140) | 1)

#define MT2701_PIN_141_RAMBUF_IDATA14__FUNC_GPIO141 (MTK_PIN_NO(141) | 0)
#define MT2701_PIN_141_RAMBUF_IDATA14__FUNC_RAMBUF_IDATA14 (MTK_PIN_NO(141) | 1)

#define MT2701_PIN_142_RAMBUF_IDATA15__FUNC_GPIO142 (MTK_PIN_NO(142) | 0)
#define MT2701_PIN_142_RAMBUF_IDATA15__FUNC_RAMBUF_IDATA15 (MTK_PIN_NO(142) | 1)

#define MT2701_PIN_143_RAMBUF_ODATA0__FUNC_GPIO143 (MTK_PIN_NO(143) | 0)
#define MT2701_PIN_143_RAMBUF_ODATA0__FUNC_RAMBUF_ODATA0 (MTK_PIN_NO(143) | 1)

#define MT2701_PIN_144_RAMBUF_ODATA1__FUNC_GPIO144 (MTK_PIN_NO(144) | 0)
#define MT2701_PIN_144_RAMBUF_ODATA1__FUNC_RAMBUF_ODATA1 (MTK_PIN_NO(144) | 1)

#define MT2701_PIN_145_RAMBUF_ODATA2__FUNC_GPIO145 (MTK_PIN_NO(145) | 0)
#define MT2701_PIN_145_RAMBUF_ODATA2__FUNC_RAMBUF_ODATA2 (MTK_PIN_NO(145) | 1)

#define MT2701_PIN_146_RAMBUF_ODATA3__FUNC_GPIO146 (MTK_PIN_NO(146) | 0)
#define MT2701_PIN_146_RAMBUF_ODATA3__FUNC_RAMBUF_ODATA3 (MTK_PIN_NO(146) | 1)

#define MT2701_PIN_147_RAMBUF_ODATA4__FUNC_GPIO147 (MTK_PIN_NO(147) | 0)
#define MT2701_PIN_147_RAMBUF_ODATA4__FUNC_RAMBUF_ODATA4 (MTK_PIN_NO(147) | 1)

#define MT2701_PIN_148_RAMBUF_ODATA5__FUNC_GPIO148 (MTK_PIN_NO(148) | 0)
#define MT2701_PIN_148_RAMBUF_ODATA5__FUNC_RAMBUF_ODATA5 (MTK_PIN_NO(148) | 1)

#define MT2701_PIN_149_RAMBUF_ODATA6__FUNC_GPIO149 (MTK_PIN_NO(149) | 0)
#define MT2701_PIN_149_RAMBUF_ODATA6__FUNC_RAMBUF_ODATA6 (MTK_PIN_NO(149) | 1)

#define MT2701_PIN_150_RAMBUF_ODATA7__FUNC_GPIO150 (MTK_PIN_NO(150) | 0)
#define MT2701_PIN_150_RAMBUF_ODATA7__FUNC_RAMBUF_ODATA7 (MTK_PIN_NO(150) | 1)

#define MT2701_PIN_151_RAMBUF_ODATA8__FUNC_GPIO151 (MTK_PIN_NO(151) | 0)
#define MT2701_PIN_151_RAMBUF_ODATA8__FUNC_RAMBUF_ODATA8 (MTK_PIN_NO(151) | 1)

#define MT2701_PIN_152_RAMBUF_ODATA9__FUNC_GPIO152 (MTK_PIN_NO(152) | 0)
#define MT2701_PIN_152_RAMBUF_ODATA9__FUNC_RAMBUF_ODATA9 (MTK_PIN_NO(152) | 1)

#define MT2701_PIN_153_RAMBUF_ODATA10__FUNC_GPIO153 (MTK_PIN_NO(153) | 0)
#define MT2701_PIN_153_RAMBUF_ODATA10__FUNC_RAMBUF_ODATA10 (MTK_PIN_NO(153) | 1)

#define MT2701_PIN_154_RAMBUF_ODATA11__FUNC_GPIO154 (MTK_PIN_NO(154) | 0)
#define MT2701_PIN_154_RAMBUF_ODATA11__FUNC_RAMBUF_ODATA11 (MTK_PIN_NO(154) | 1)

#define MT2701_PIN_155_RAMBUF_ODATA12__FUNC_GPIO155 (MTK_PIN_NO(155) | 0)
#define MT2701_PIN_155_RAMBUF_ODATA12__FUNC_RAMBUF_ODATA12 (MTK_PIN_NO(155) | 1)

#define MT2701_PIN_156_RAMBUF_ODATA13__FUNC_GPIO156 (MTK_PIN_NO(156) | 0)
#define MT2701_PIN_156_RAMBUF_ODATA13__FUNC_RAMBUF_ODATA13 (MTK_PIN_NO(156) | 1)

#define MT2701_PIN_157_RAMBUF_ODATA14__FUNC_GPIO157 (MTK_PIN_NO(157) | 0)
#define MT2701_PIN_157_RAMBUF_ODATA14__FUNC_RAMBUF_ODATA14 (MTK_PIN_NO(157) | 1)

#define MT2701_PIN_158_RAMBUF_ODATA15__FUNC_GPIO158 (MTK_PIN_NO(158) | 0)
#define MT2701_PIN_158_RAMBUF_ODATA15__FUNC_RAMBUF_ODATA15 (MTK_PIN_NO(158) | 1)

#define MT2701_PIN_159_RAMBUF_BE0__FUNC_GPIO159 (MTK_PIN_NO(159) | 0)
#define MT2701_PIN_159_RAMBUF_BE0__FUNC_RAMBUF_BE0 (MTK_PIN_NO(159) | 1)

#define MT2701_PIN_160_RAMBUF_BE1__FUNC_GPIO160 (MTK_PIN_NO(160) | 0)
#define MT2701_PIN_160_RAMBUF_BE1__FUNC_RAMBUF_BE1 (MTK_PIN_NO(160) | 1)

#define MT2701_PIN_161_AP2PT_INT__FUNC_GPIO161 (MTK_PIN_NO(161) | 0)
#define MT2701_PIN_161_AP2PT_INT__FUNC_AP2PT_INT (MTK_PIN_NO(161) | 1)

#define MT2701_PIN_162_AP2PT_INT_CLR__FUNC_GPIO162 (MTK_PIN_NO(162) | 0)
#define MT2701_PIN_162_AP2PT_INT_CLR__FUNC_AP2PT_INT_CLR (MTK_PIN_NO(162) | 1)

#define MT2701_PIN_163_PT2AP_INT__FUNC_GPIO163 (MTK_PIN_NO(163) | 0)
#define MT2701_PIN_163_PT2AP_INT__FUNC_PT2AP_INT (MTK_PIN_NO(163) | 1)

#define MT2701_PIN_164_PT2AP_INT_CLR__FUNC_GPIO164 (MTK_PIN_NO(164) | 0)
#define MT2701_PIN_164_PT2AP_INT_CLR__FUNC_PT2AP_INT_CLR (MTK_PIN_NO(164) | 1)

#define MT2701_PIN_165_AP2UP_INT__FUNC_GPIO165 (MTK_PIN_NO(165) | 0)
#define MT2701_PIN_165_AP2UP_INT__FUNC_AP2UP_INT (MTK_PIN_NO(165) | 1)

#define MT2701_PIN_166_AP2UP_INT_CLR__FUNC_GPIO166 (MTK_PIN_NO(166) | 0)
#define MT2701_PIN_166_AP2UP_INT_CLR__FUNC_AP2UP_INT_CLR (MTK_PIN_NO(166) | 1)

#define MT2701_PIN_167_UP2AP_INT__FUNC_GPIO167 (MTK_PIN_NO(167) | 0)
#define MT2701_PIN_167_UP2AP_INT__FUNC_UP2AP_INT (MTK_PIN_NO(167) | 1)

#define MT2701_PIN_168_UP2AP_INT_CLR__FUNC_GPIO168 (MTK_PIN_NO(168) | 0)
#define MT2701_PIN_168_UP2AP_INT_CLR__FUNC_UP2AP_INT_CLR (MTK_PIN_NO(168) | 1)

#define MT2701_PIN_169_RAMBUF_ADDR0__FUNC_GPIO169 (MTK_PIN_NO(169) | 0)
#define MT2701_PIN_169_RAMBUF_ADDR0__FUNC_RAMBUF_ADDR0 (MTK_PIN_NO(169) | 1)

#define MT2701_PIN_170_RAMBUF_ADDR1__FUNC_GPIO170 (MTK_PIN_NO(170) | 0)
#define MT2701_PIN_170_RAMBUF_ADDR1__FUNC_RAMBUF_ADDR1 (MTK_PIN_NO(170) | 1)

#define MT2701_PIN_171_RAMBUF_ADDR2__FUNC_GPIO171 (MTK_PIN_NO(171) | 0)
#define MT2701_PIN_171_RAMBUF_ADDR2__FUNC_RAMBUF_ADDR2 (MTK_PIN_NO(171) | 1)

#define MT2701_PIN_172_RAMBUF_ADDR3__FUNC_GPIO172 (MTK_PIN_NO(172) | 0)
#define MT2701_PIN_172_RAMBUF_ADDR3__FUNC_RAMBUF_ADDR3 (MTK_PIN_NO(172) | 1)

#define MT2701_PIN_173_RAMBUF_ADDR4__FUNC_GPIO173 (MTK_PIN_NO(173) | 0)
#define MT2701_PIN_173_RAMBUF_ADDR4__FUNC_RAMBUF_ADDR4 (MTK_PIN_NO(173) | 1)

#define MT2701_PIN_174_RAMBUF_ADDR5__FUNC_GPIO174 (MTK_PIN_NO(174) | 0)
#define MT2701_PIN_174_RAMBUF_ADDR5__FUNC_RAMBUF_ADDR5 (MTK_PIN_NO(174) | 1)

#define MT2701_PIN_175_RAMBUF_ADDR6__FUNC_GPIO175 (MTK_PIN_NO(175) | 0)
#define MT2701_PIN_175_RAMBUF_ADDR6__FUNC_RAMBUF_ADDR6 (MTK_PIN_NO(175) | 1)

#define MT2701_PIN_176_RAMBUF_ADDR7__FUNC_GPIO176 (MTK_PIN_NO(176) | 0)
#define MT2701_PIN_176_RAMBUF_ADDR7__FUNC_RAMBUF_ADDR7 (MTK_PIN_NO(176) | 1)

#define MT2701_PIN_177_RAMBUF_ADDR8__FUNC_GPIO177 (MTK_PIN_NO(177) | 0)
#define MT2701_PIN_177_RAMBUF_ADDR8__FUNC_RAMBUF_ADDR8 (MTK_PIN_NO(177) | 1)

#define MT2701_PIN_178_RAMBUF_ADDR9__FUNC_GPIO178 (MTK_PIN_NO(178) | 0)
#define MT2701_PIN_178_RAMBUF_ADDR9__FUNC_RAMBUF_ADDR9 (MTK_PIN_NO(178) | 1)

#define MT2701_PIN_179_RAMBUF_ADDR10__FUNC_GPIO179 (MTK_PIN_NO(179) | 0)
#define MT2701_PIN_179_RAMBUF_ADDR10__FUNC_RAMBUF_ADDR10 (MTK_PIN_NO(179) | 1)

#define MT2701_PIN_180_RAMBUF_RW__FUNC_GPIO180 (MTK_PIN_NO(180) | 0)
#define MT2701_PIN_180_RAMBUF_RW__FUNC_RAMBUF_RW (MTK_PIN_NO(180) | 1)

#define MT2701_PIN_181_RAMBUF_LAST__FUNC_GPIO181 (MTK_PIN_NO(181) | 0)
#define MT2701_PIN_181_RAMBUF_LAST__FUNC_RAMBUF_LAST (MTK_PIN_NO(181) | 1)

#define MT2701_PIN_182_RAMBUF_HP__FUNC_GPIO182 (MTK_PIN_NO(182) | 0)
#define MT2701_PIN_182_RAMBUF_HP__FUNC_RAMBUF_HP (MTK_PIN_NO(182) | 1)

#define MT2701_PIN_183_RAMBUF_REQ__FUNC_GPIO183 (MTK_PIN_NO(183) | 0)
#define MT2701_PIN_183_RAMBUF_REQ__FUNC_RAMBUF_REQ (MTK_PIN_NO(183) | 1)

#define MT2701_PIN_184_RAMBUF_ALE__FUNC_GPIO184 (MTK_PIN_NO(184) | 0)
#define MT2701_PIN_184_RAMBUF_ALE__FUNC_RAMBUF_ALE (MTK_PIN_NO(184) | 1)

#define MT2701_PIN_185_RAMBUF_DLE__FUNC_GPIO185 (MTK_PIN_NO(185) | 0)
#define MT2701_PIN_185_RAMBUF_DLE__FUNC_RAMBUF_DLE (MTK_PIN_NO(185) | 1)

#define MT2701_PIN_186_RAMBUF_WDLE__FUNC_GPIO186 (MTK_PIN_NO(186) | 0)
#define MT2701_PIN_186_RAMBUF_WDLE__FUNC_RAMBUF_WDLE (MTK_PIN_NO(186) | 1)

#define MT2701_PIN_187_RAMBUF_O_CLK__FUNC_GPIO187 (MTK_PIN_NO(187) | 0)
#define MT2701_PIN_187_RAMBUF_O_CLK__FUNC_RAMBUF_O_CLK (MTK_PIN_NO(187) | 1)

#define MT2701_PIN_188_I2S2_MCLK__FUNC_GPIO188 (MTK_PIN_NO(188) | 0)
#define MT2701_PIN_188_I2S2_MCLK__FUNC_I2S2_MCLK (MTK_PIN_NO(188) | 1)

#define MT2701_PIN_189_I2S3_DATA__FUNC_GPIO189 (MTK_PIN_NO(189) | 0)
#define MT2701_PIN_189_I2S3_DATA__FUNC_I2S3_DATA_BYPS (MTK_PIN_NO(189) | 2)
#define MT2701_PIN_189_I2S3_DATA__FUNC_PCM_TX (MTK_PIN_NO(189) | 3)

#define MT2701_PIN_190_I2S3_DATA_IN__FUNC_GPIO190 (MTK_PIN_NO(190) | 0)
#define MT2701_PIN_190_I2S3_DATA_IN__FUNC_I2S3_DATA_IN (MTK_PIN_NO(190) | 1)
#define MT2701_PIN_190_I2S3_DATA_IN__FUNC_PCM_RX (MTK_PIN_NO(190) | 3)

#define MT2701_PIN_191_I2S3_BCK__FUNC_GPIO191 (MTK_PIN_NO(191) | 0)
#define MT2701_PIN_191_I2S3_BCK__FUNC_I2S3_BCK (MTK_PIN_NO(191) | 1)
#define MT2701_PIN_191_I2S3_BCK__FUNC_PCM_CLK0 (MTK_PIN_NO(191) | 3)

#define MT2701_PIN_192_I2S3_LRCK__FUNC_GPIO192 (MTK_PIN_NO(192) | 0)
#define MT2701_PIN_192_I2S3_LRCK__FUNC_I2S3_LRCK (MTK_PIN_NO(192) | 1)
#define MT2701_PIN_192_I2S3_LRCK__FUNC_PCM_SYNC (MTK_PIN_NO(192) | 3)

#define MT2701_PIN_193_I2S3_MCLK__FUNC_GPIO193 (MTK_PIN_NO(193) | 0)
#define MT2701_PIN_193_I2S3_MCLK__FUNC_I2S3_MCLK (MTK_PIN_NO(193) | 1)

#define MT2701_PIN_194_I2S4_DATA__FUNC_GPIO194 (MTK_PIN_NO(194) | 0)
#define MT2701_PIN_194_I2S4_DATA__FUNC_I2S4_DATA (MTK_PIN_NO(194) | 1)
#define MT2701_PIN_194_I2S4_DATA__FUNC_I2S4_DATA_BYPS (MTK_PIN_NO(194) | 2)
#define MT2701_PIN_194_I2S4_DATA__FUNC_PCM_TX (MTK_PIN_NO(194) | 3)

#define MT2701_PIN_195_I2S4_DATA_IN__FUNC_GPIO195 (MTK_PIN_NO(195) | 0)
#define MT2701_PIN_195_I2S4_DATA_IN__FUNC_I2S4_DATA_IN (MTK_PIN_NO(195) | 1)
#define MT2701_PIN_195_I2S4_DATA_IN__FUNC_PCM_RX (MTK_PIN_NO(195) | 3)

#define MT2701_PIN_196_I2S4_BCK__FUNC_GPIO196 (MTK_PIN_NO(196) | 0)
#define MT2701_PIN_196_I2S4_BCK__FUNC_I2S4_BCK (MTK_PIN_NO(196) | 1)
#define MT2701_PIN_196_I2S4_BCK__FUNC_PCM_CLK0 (MTK_PIN_NO(196) | 3)

#define MT2701_PIN_197_I2S4_LRCK__FUNC_GPIO197 (MTK_PIN_NO(197) | 0)
#define MT2701_PIN_197_I2S4_LRCK__FUNC_I2S4_LRCK (MTK_PIN_NO(197) | 1)
#define MT2701_PIN_197_I2S4_LRCK__FUNC_PCM_SYNC (MTK_PIN_NO(197) | 3)

#define MT2701_PIN_198_I2S4_MCLK__FUNC_GPIO198 (MTK_PIN_NO(198) | 0)
#define MT2701_PIN_198_I2S4_MCLK__FUNC_I2S4_MCLK (MTK_PIN_NO(198) | 1)

#define MT2701_PIN_199_SPI1_CLK__FUNC_GPIO199 (MTK_PIN_NO(199) | 0)
#define MT2701_PIN_199_SPI1_CLK__FUNC_SPI1_CK (MTK_PIN_NO(199) | 1)
#define MT2701_PIN_199_SPI1_CLK__FUNC_EXT_FRAME_SYNC (MTK_PIN_NO(199) | 3)
#define MT2701_PIN_199_SPI1_CLK__FUNC_KCOL3 (MTK_PIN_NO(199) | 4)
#define MT2701_PIN_199_SPI1_CLK__FUNC_DBG_MON_B_15 (MTK_PIN_NO(199) | 7)

#define MT2701_PIN_200_SPDIF_OUT__FUNC_GPIO200 (MTK_PIN_NO(200) | 0)
#define MT2701_PIN_200_SPDIF_OUT__FUNC_SPDIF_OUT (MTK_PIN_NO(200) | 1)
#define MT2701_PIN_200_SPDIF_OUT__FUNC_G1_TXD3 (MTK_PIN_NO(200) | 5)
#define MT2701_PIN_200_SPDIF_OUT__FUNC_URXD2 (MTK_PIN_NO(200) | 6)
#define MT2701_PIN_200_SPDIF_OUT__FUNC_DBG_MON_B_16 (MTK_PIN_NO(200) | 7)

#define MT2701_PIN_201_SPDIF_IN0__FUNC_GPIO201 (MTK_PIN_NO(201) | 0)
#define MT2701_PIN_201_SPDIF_IN0__FUNC_SPDIF_IN0 (MTK_PIN_NO(201) | 1)
#define MT2701_PIN_201_SPDIF_IN0__FUNC_G1_TXEN (MTK_PIN_NO(201) | 5)
#define MT2701_PIN_201_SPDIF_IN0__FUNC_UTXD2 (MTK_PIN_NO(201) | 6)
#define MT2701_PIN_201_SPDIF_IN0__FUNC_DBG_MON_B_17 (MTK_PIN_NO(201) | 7)

#define MT2701_PIN_202_SPDIF_IN1__FUNC_GPIO202 (MTK_PIN_NO(202) | 0)
#define MT2701_PIN_202_SPDIF_IN1__FUNC_SPDIF_IN1 (MTK_PIN_NO(202) | 1)

#define MT2701_PIN_203_PWM0__FUNC_GPIO203 (MTK_PIN_NO(203) | 0)
#define MT2701_PIN_203_PWM0__FUNC_PWM0 (MTK_PIN_NO(203) | 1)
#define MT2701_PIN_203_PWM0__FUNC_DISP_PWM (MTK_PIN_NO(203) | 2)
#define MT2701_PIN_203_PWM0__FUNC_G1_TXD2 (MTK_PIN_NO(203) | 5)
#define MT2701_PIN_203_PWM0__FUNC_DBG_MON_B_18 (MTK_PIN_NO(203) | 7)
#define MT2701_PIN_203_PWM0__FUNC_I2S2_DATA (MTK_PIN_NO(203) | 9)

#define MT2701_PIN_204_PWM1__FUNC_GPIO204 (MTK_PIN_NO(204) | 0)
#define MT2701_PIN_204_PWM1__FUNC_PWM1 (MTK_PIN_NO(204) | 1)
#define MT2701_PIN_204_PWM1__FUNC_CLKM3 (MTK_PIN_NO(204) | 2)
#define MT2701_PIN_204_PWM1__FUNC_G1_TXD1 (MTK_PIN_NO(204) | 5)
#define MT2701_PIN_204_PWM1__FUNC_DBG_MON_B_19 (MTK_PIN_NO(204) | 7)
#define MT2701_PIN_204_PWM1__FUNC_I2S3_DATA (MTK_PIN_NO(204) | 9)

#define MT2701_PIN_205_PWM2__FUNC_GPIO205 (MTK_PIN_NO(205) | 0)
#define MT2701_PIN_205_PWM2__FUNC_PWM2 (MTK_PIN_NO(205) | 1)
#define MT2701_PIN_205_PWM2__FUNC_CLKM2 (MTK_PIN_NO(205) | 2)
#define MT2701_PIN_205_PWM2__FUNC_G1_TXD0 (MTK_PIN_NO(205) | 5)
#define MT2701_PIN_205_PWM2__FUNC_DBG_MON_B_20 (MTK_PIN_NO(205) | 7)

#define MT2701_PIN_206_PWM3__FUNC_GPIO206 (MTK_PIN_NO(206) | 0)
#define MT2701_PIN_206_PWM3__FUNC_PWM3 (MTK_PIN_NO(206) | 1)
#define MT2701_PIN_206_PWM3__FUNC_CLKM1 (MTK_PIN_NO(206) | 2)
#define MT2701_PIN_206_PWM3__FUNC_EXT_FRAME_SYNC (MTK_PIN_NO(206) | 3)
#define MT2701_PIN_206_PWM3__FUNC_G1_TXC (MTK_PIN_NO(206) | 5)
#define MT2701_PIN_206_PWM3__FUNC_DBG_MON_B_21 (MTK_PIN_NO(206) | 7)

#define MT2701_PIN_207_PWM4__FUNC_GPIO207 (MTK_PIN_NO(207) | 0)
#define MT2701_PIN_207_PWM4__FUNC_PWM4 (MTK_PIN_NO(207) | 1)
#define MT2701_PIN_207_PWM4__FUNC_CLKM0 (MTK_PIN_NO(207) | 2)
#define MT2701_PIN_207_PWM4__FUNC_EXT_FRAME_SYNC (MTK_PIN_NO(207) | 3)
#define MT2701_PIN_207_PWM4__FUNC_G1_RXC (MTK_PIN_NO(207) | 5)
#define MT2701_PIN_207_PWM4__FUNC_DBG_MON_B_22 (MTK_PIN_NO(207) | 7)

#define MT2701_PIN_208_AUD_EXT_CK1__FUNC_GPIO208 (MTK_PIN_NO(208) | 0)
#define MT2701_PIN_208_AUD_EXT_CK1__FUNC_AUD_EXT_CK1 (MTK_PIN_NO(208) | 1)
#define MT2701_PIN_208_AUD_EXT_CK1__FUNC_PWM0 (MTK_PIN_NO(208) | 2)
#define MT2701_PIN_208_AUD_EXT_CK1__FUNC_ANT_SEL5 (MTK_PIN_NO(208) | 4)
#define MT2701_PIN_208_AUD_EXT_CK1__FUNC_DISP_PWM (MTK_PIN_NO(208) | 5)
#define MT2701_PIN_208_AUD_EXT_CK1__FUNC_DBG_MON_A_31 (MTK_PIN_NO(208) | 7)
#define MT2701_PIN_208_AUD_EXT_CK1__FUNC_PCIE0_PERST_N (MTK_PIN_NO(208) | 11)

#define MT2701_PIN_209_AUD_EXT_CK2__FUNC_GPIO209 (MTK_PIN_NO(209) | 0)
#define MT2701_PIN_209_AUD_EXT_CK2__FUNC_AUD_EXT_CK2 (MTK_PIN_NO(209) | 1)
#define MT2701_PIN_209_AUD_EXT_CK2__FUNC_MSDC1_WP (MTK_PIN_NO(209) | 2)
#define MT2701_PIN_209_AUD_EXT_CK2__FUNC_PWM1 (MTK_PIN_NO(209) | 5)
#define MT2701_PIN_209_AUD_EXT_CK2__FUNC_DBG_MON_A_32 (MTK_PIN_NO(209) | 7)
#define MT2701_PIN_209_AUD_EXT_CK2__FUNC_PCIE1_PERST_N (MTK_PIN_NO(209) | 11)

#define MT2701_PIN_210_AUD_CLOCK__FUNC_GPIO210 (MTK_PIN_NO(210) | 0)
#define MT2701_PIN_210_AUD_CLOCK__FUNC_AUD_CLOCK (MTK_PIN_NO(210) | 1)

#define MT2701_PIN_211_DVP_RESET__FUNC_GPIO211 (MTK_PIN_NO(211) | 0)
#define MT2701_PIN_211_DVP_RESET__FUNC_DVP_RESET (MTK_PIN_NO(211) | 1)

#define MT2701_PIN_212_DVP_CLOCK__FUNC_GPIO212 (MTK_PIN_NO(212) | 0)
#define MT2701_PIN_212_DVP_CLOCK__FUNC_DVP_CLOCK (MTK_PIN_NO(212) | 1)

#define MT2701_PIN_213_DVP_CS__FUNC_GPIO213 (MTK_PIN_NO(213) | 0)
#define MT2701_PIN_213_DVP_CS__FUNC_DVP_CS (MTK_PIN_NO(213) | 1)

#define MT2701_PIN_214_DVP_CK__FUNC_GPIO214 (MTK_PIN_NO(214) | 0)
#define MT2701_PIN_214_DVP_CK__FUNC_DVP_CK (MTK_PIN_NO(214) | 1)

#define MT2701_PIN_215_DVP_DI__FUNC_GPIO215 (MTK_PIN_NO(215) | 0)
#define MT2701_PIN_215_DVP_DI__FUNC_DVP_DI (MTK_PIN_NO(215) | 1)

#define MT2701_PIN_216_DVP_DO__FUNC_GPIO216 (MTK_PIN_NO(216) | 0)
#define MT2701_PIN_216_DVP_DO__FUNC_DVP_DO (MTK_PIN_NO(216) | 1)

#define MT2701_PIN_217_AP_CS__FUNC_GPIO217 (MTK_PIN_NO(217) | 0)
#define MT2701_PIN_217_AP_CS__FUNC_AP_CS (MTK_PIN_NO(217) | 1)

#define MT2701_PIN_218_AP_CK__FUNC_GPIO218 (MTK_PIN_NO(218) | 0)
#define MT2701_PIN_218_AP_CK__FUNC_AP_CK (MTK_PIN_NO(218) | 1)

#define MT2701_PIN_219_AP_DI__FUNC_GPIO219 (MTK_PIN_NO(219) | 0)
#define MT2701_PIN_219_AP_DI__FUNC_AP_DI (MTK_PIN_NO(219) | 1)

#define MT2701_PIN_220_AP_DO__FUNC_GPIO220 (MTK_PIN_NO(220) | 0)
#define MT2701_PIN_220_AP_DO__FUNC_AP_DO (MTK_PIN_NO(220) | 1)

#define MT2701_PIN_221_DVD_BCLK__FUNC_GPIO221 (MTK_PIN_NO(221) | 0)
#define MT2701_PIN_221_DVD_BCLK__FUNC_DVD_BCLK (MTK_PIN_NO(221) | 1)

#define MT2701_PIN_222_T8032_CLK__FUNC_GPIO222 (MTK_PIN_NO(222) | 0)
#define MT2701_PIN_222_T8032_CLK__FUNC_T8032_CLK (MTK_PIN_NO(222) | 1)

#define MT2701_PIN_223_AP_BCLK__FUNC_GPIO223 (MTK_PIN_NO(223) | 0)
#define MT2701_PIN_223_AP_BCLK__FUNC_AP_BCLK (MTK_PIN_NO(223) | 1)

#define MT2701_PIN_224_HOST_CS__FUNC_GPIO224 (MTK_PIN_NO(224) | 0)
#define MT2701_PIN_224_HOST_CS__FUNC_HOST_CS (MTK_PIN_NO(224) | 1)

#define MT2701_PIN_225_HOST_CK__FUNC_GPIO225 (MTK_PIN_NO(225) | 0)
#define MT2701_PIN_225_HOST_CK__FUNC_HOST_CK (MTK_PIN_NO(225) | 1)

#define MT2701_PIN_226_HOST_DO0__FUNC_GPIO226 (MTK_PIN_NO(226) | 0)
#define MT2701_PIN_226_HOST_DO0__FUNC_HOST_DO0 (MTK_PIN_NO(226) | 1)

#define MT2701_PIN_227_HOST_DO1__FUNC_GPIO227 (MTK_PIN_NO(227) | 0)
#define MT2701_PIN_227_HOST_DO1__FUNC_HOST_DO1 (MTK_PIN_NO(227) | 1)

#define MT2701_PIN_228_SLV_CS__FUNC_GPIO228 (MTK_PIN_NO(228) | 0)
#define MT2701_PIN_228_SLV_CS__FUNC_SLV_CS (MTK_PIN_NO(228) | 1)

#define MT2701_PIN_229_SLV_CK__FUNC_GPIO229 (MTK_PIN_NO(229) | 0)
#define MT2701_PIN_229_SLV_CK__FUNC_SLV_CK (MTK_PIN_NO(229) | 1)

#define MT2701_PIN_230_SLV_DI0__FUNC_GPIO230 (MTK_PIN_NO(230) | 0)
#define MT2701_PIN_230_SLV_DI0__FUNC_SLV_DI0 (MTK_PIN_NO(230) | 1)

#define MT2701_PIN_231_SLV_DI1__FUNC_GPIO231 (MTK_PIN_NO(231) | 0)
#define MT2701_PIN_231_SLV_DI1__FUNC_SLV_DI1 (MTK_PIN_NO(231) | 1)

#define MT2701_PIN_232_AP2DSP_INT__FUNC_GPIO232 (MTK_PIN_NO(232) | 0)
#define MT2701_PIN_232_AP2DSP_INT__FUNC_AP2DSP_INT (MTK_PIN_NO(232) | 1)

#define MT2701_PIN_233_AP2DSP_INT_CLR__FUNC_GPIO233 (MTK_PIN_NO(233) | 0)
#define MT2701_PIN_233_AP2DSP_INT_CLR__FUNC_AP2DSP_INT_CLR (MTK_PIN_NO(233) | 1)

#define MT2701_PIN_234_DSP2AP_INT__FUNC_GPIO234 (MTK_PIN_NO(234) | 0)
#define MT2701_PIN_234_DSP2AP_INT__FUNC_DSP2AP_INT (MTK_PIN_NO(234) | 1)

#define MT2701_PIN_235_DSP2AP_INT_CLR__FUNC_GPIO235 (MTK_PIN_NO(235) | 0)
#define MT2701_PIN_235_DSP2AP_INT_CLR__FUNC_DSP2AP_INT_CLR (MTK_PIN_NO(235) | 1)

#define MT2701_PIN_236_EXT_SDIO3__FUNC_GPIO236 (MTK_PIN_NO(236) | 0)
#define MT2701_PIN_236_EXT_SDIO3__FUNC_EXT_SDIO3 (MTK_PIN_NO(236) | 1)
#define MT2701_PIN_236_EXT_SDIO3__FUNC_IDDIG (MTK_PIN_NO(236) | 2)
#define MT2701_PIN_236_EXT_SDIO3__FUNC_DBG_MON_A_1 (MTK_PIN_NO(236) | 7)

#define MT2701_PIN_237_EXT_SDIO2__FUNC_GPIO237 (MTK_PIN_NO(237) | 0)
#define MT2701_PIN_237_EXT_SDIO2__FUNC_EXT_SDIO2 (MTK_PIN_NO(237) | 1)
#define MT2701_PIN_237_EXT_SDIO2__FUNC_DRV_VBUS (MTK_PIN_NO(237) | 2)

#define MT2701_PIN_238_EXT_SDIO1__FUNC_GPIO238 (MTK_PIN_NO(238) | 0)
#define MT2701_PIN_238_EXT_SDIO1__FUNC_EXT_SDIO1 (MTK_PIN_NO(238) | 1)
#define MT2701_PIN_238_EXT_SDIO1__FUNC_IDDIG_P1 (MTK_PIN_NO(238) | 2)

#define MT2701_PIN_239_EXT_SDIO0__FUNC_GPIO239 (MTK_PIN_NO(239) | 0)
#define MT2701_PIN_239_EXT_SDIO0__FUNC_EXT_SDIO0 (MTK_PIN_NO(239) | 1)
#define MT2701_PIN_239_EXT_SDIO0__FUNC_DRV_VBUS_P1 (MTK_PIN_NO(239) | 2)

#define MT2701_PIN_240_EXT_XCS__FUNC_GPIO240 (MTK_PIN_NO(240) | 0)
#define MT2701_PIN_240_EXT_XCS__FUNC_EXT_XCS (MTK_PIN_NO(240) | 1)

#define MT2701_PIN_241_EXT_SCK__FUNC_GPIO241 (MTK_PIN_NO(241) | 0)
#define MT2701_PIN_241_EXT_SCK__FUNC_EXT_SCK (MTK_PIN_NO(241) | 1)

#define MT2701_PIN_242_URTS2__FUNC_GPIO242 (MTK_PIN_NO(242) | 0)
#define MT2701_PIN_242_URTS2__FUNC_URTS2 (MTK_PIN_NO(242) | 1)
#define MT2701_PIN_242_URTS2__FUNC_UTXD3 (MTK_PIN_NO(242) | 2)
#define MT2701_PIN_242_URTS2__FUNC_URXD3 (MTK_PIN_NO(242) | 3)
#define MT2701_PIN_242_URTS2__FUNC_SCL1 (MTK_PIN_NO(242) | 4)
#define MT2701_PIN_242_URTS2__FUNC_DBG_MON_B_32 (MTK_PIN_NO(242) | 7)

#define MT2701_PIN_243_UCTS2__FUNC_GPIO243 (MTK_PIN_NO(243) | 0)
#define MT2701_PIN_243_UCTS2__FUNC_UCTS2 (MTK_PIN_NO(243) | 1)
#define MT2701_PIN_243_UCTS2__FUNC_URXD3 (MTK_PIN_NO(243) | 2)
#define MT2701_PIN_243_UCTS2__FUNC_UTXD3 (MTK_PIN_NO(243) | 3)
#define MT2701_PIN_243_UCTS2__FUNC_SDA1 (MTK_PIN_NO(243) | 4)
#define MT2701_PIN_243_UCTS2__FUNC_DBG_MON_A_6 (MTK_PIN_NO(243) | 7)

#define MT2701_PIN_244_HDMI_SDA_RX__FUNC_GPIO244 (MTK_PIN_NO(244) | 0)
#define MT2701_PIN_244_HDMI_SDA_RX__FUNC_HDMI_SDA_RX (MTK_PIN_NO(244) | 1)

#define MT2701_PIN_245_HDMI_SCL_RX__FUNC_GPIO245 (MTK_PIN_NO(245) | 0)
#define MT2701_PIN_245_HDMI_SCL_RX__FUNC_HDMI_SCL_RX (MTK_PIN_NO(245) | 1)

#define MT2701_PIN_246_MHL_SENCE__FUNC_GPIO246 (MTK_PIN_NO(246) | 0)

#define MT2701_PIN_247_HDMI_HPD_CBUS_RX__FUNC_GPIO247 (MTK_PIN_NO(247) | 0)
#define MT2701_PIN_247_HDMI_HPD_CBUS_RX__FUNC_HDMI_HPD_RX (MTK_PIN_NO(247) | 1)

#define MT2701_PIN_248_HDMI_TESTOUTP_RX__FUNC_GPIO248 (MTK_PIN_NO(248) | 0)
#define MT2701_PIN_248_HDMI_TESTOUTP_RX__FUNC_HDMI_TESTOUTP_RX (MTK_PIN_NO(248) | 1)

#define MT2701_PIN_249_MSDC0E_RSTB__FUNC_MSDC0E_RSTB (MTK_PIN_NO(249) | 9)

#define MT2701_PIN_250_MSDC0E_DAT7__FUNC_MSDC3_DAT7 (MTK_PIN_NO(250) | 9)
#define MT2701_PIN_250_MSDC0E_DAT7__FUNC_PCIE0_CLKREQ_N (MTK_PIN_NO(250) | 14)

#define MT2701_PIN_251_MSDC0E_DAT6__FUNC_MSDC3_DAT6 (MTK_PIN_NO(251) | 9)
#define MT2701_PIN_251_MSDC0E_DAT6__FUNC_PCIE0_WAKE_N (MTK_PIN_NO(251) | 14)

#define MT2701_PIN_252_MSDC0E_DAT5__FUNC_GPIO252 (MTK_PIN_NO(252) | 8)
#define MT2701_PIN_252_MSDC0E_DAT5__FUNC_MSDC3_DAT5 (MTK_PIN_NO(252) | 9)
#define MT2701_PIN_252_MSDC0E_DAT5__FUNC_PCIE1_CLKREQ_N (MTK_PIN_NO(252) | 14)

#define MT2701_PIN_253_MSDC0E_DAT4__FUNC_MSDC3_DAT4 (MTK_PIN_NO(253) | 9)
#define MT2701_PIN_253_MSDC0E_DAT4__FUNC_PCIE1_WAKE_N (MTK_PIN_NO(253) | 14)

#define MT2701_PIN_254_MSDC0E_DAT3__FUNC_MSDC3_DAT3 (MTK_PIN_NO(254) | 9)
#define MT2701_PIN_254_MSDC0E_DAT3__FUNC_PCIE2_CLKREQ_N (MTK_PIN_NO(254) | 14)

#define MT2701_PIN_255_MSDC0E_DAT2__FUNC_GPIO255 (MTK_PIN_NO(255) | 8)
#define MT2701_PIN_255_MSDC0E_DAT2__FUNC_MSDC3_DAT2 (MTK_PIN_NO(255) | 9)
#define MT2701_PIN_255_MSDC0E_DAT2__FUNC_PCIE2_WAKE_N (MTK_PIN_NO(255) | 14)

#define MT2701_PIN_256_MSDC0E_DAT1__FUNC_MSDC3_DAT1 (MTK_PIN_NO(256) | 9)

#define MT2701_PIN_257_MSDC0E_DAT0__FUNC_MSDC3_DAT0 (MTK_PIN_NO(257) | 9)

#define MT2701_PIN_258_MSDC0E_CMD__FUNC_MSDC3_CMD (MTK_PIN_NO(258) | 9)

#define MT2701_PIN_259_MSDC0E_CLK__FUNC_MSDC3_CLK (MTK_PIN_NO(259) | 9)

#define MT2701_PIN_260_MSDC0E_DSL__FUNC_MSDC3_DSL (MTK_PIN_NO(260) | 9)

#define MT2701_PIN_261_MSDC1_INS__FUNC_GPIO261 (MTK_PIN_NO(261) | 0)
#define MT2701_PIN_261_MSDC1_INS__FUNC_MSDC1_INS (MTK_PIN_NO(261) | 1)
#define MT2701_PIN_261_MSDC1_INS__FUNC_DBG_MON_B_29 (MTK_PIN_NO(261) | 7)

#define MT2701_PIN_262_G2_TXEN__FUNC_GPIO262 (MTK_PIN_NO(262) | 0)
#define MT2701_PIN_262_G2_TXEN__FUNC_G2_TXEN (MTK_PIN_NO(262) | 1)

#define MT2701_PIN_263_G2_TXD3__FUNC_GPIO263 (MTK_PIN_NO(263) | 0)
#define MT2701_PIN_263_G2_TXD3__FUNC_G2_TXD3 (MTK_PIN_NO(263) | 1)
#define MT2701_PIN_263_G2_TXD3__FUNC_ANT_SEL5 (MTK_PIN_NO(263) | 6)

#define MT2701_PIN_264_G2_TXD2__FUNC_GPIO264 (MTK_PIN_NO(264) | 0)
#define MT2701_PIN_264_G2_TXD2__FUNC_G2_TXD2 (MTK_PIN_NO(264) | 1)
#define MT2701_PIN_264_G2_TXD2__FUNC_ANT_SEL4 (MTK_PIN_NO(264) | 6)

#define MT2701_PIN_265_G2_TXD1__FUNC_GPIO265 (MTK_PIN_NO(265) | 0)
#define MT2701_PIN_265_G2_TXD1__FUNC_G2_TXD1 (MTK_PIN_NO(265) | 1)
#define MT2701_PIN_265_G2_TXD1__FUNC_ANT_SEL3 (MTK_PIN_NO(265) | 6)

#define MT2701_PIN_266_G2_TXD0__FUNC_GPIO266 (MTK_PIN_NO(266) | 0)
#define MT2701_PIN_266_G2_TXD0__FUNC_G2_TXD0 (MTK_PIN_NO(266) | 1)
#define MT2701_PIN_266_G2_TXD0__FUNC_ANT_SEL2 (MTK_PIN_NO(266) | 6)

#define MT2701_PIN_267_G2_TXC__FUNC_GPIO267 (MTK_PIN_NO(267) | 0)
#define MT2701_PIN_267_G2_TXC__FUNC_G2_TXC (MTK_PIN_NO(267) | 1)

#define MT2701_PIN_268_G2_RXC__FUNC_GPIO268 (MTK_PIN_NO(268) | 0)
#define MT2701_PIN_268_G2_RXC__FUNC_G2_RXC (MTK_PIN_NO(268) | 1)

#define MT2701_PIN_269_G2_RXD0__FUNC_GPIO269 (MTK_PIN_NO(269) | 0)
#define MT2701_PIN_269_G2_RXD0__FUNC_G2_RXD0 (MTK_PIN_NO(269) | 1)

#define MT2701_PIN_270_G2_RXD1__FUNC_GPIO270 (MTK_PIN_NO(270) | 0)
#define MT2701_PIN_270_G2_RXD1__FUNC_G2_RXD1 (MTK_PIN_NO(270) | 1)

#define MT2701_PIN_271_G2_RXD2__FUNC_GPIO271 (MTK_PIN_NO(271) | 0)
#define MT2701_PIN_271_G2_RXD2__FUNC_G2_RXD2 (MTK_PIN_NO(271) | 1)

#define MT2701_PIN_272_G2_RXD3__FUNC_GPIO272 (MTK_PIN_NO(272) | 0)
#define MT2701_PIN_272_G2_RXD3__FUNC_G2_RXD3 (MTK_PIN_NO(272) | 1)

#define MT2701_PIN_273_ESW_INT__FUNC_GPIO273 (MTK_PIN_NO(273) | 0)
#define MT2701_PIN_273_ESW_INT__FUNC_ESW_INT (MTK_PIN_NO(273) | 1)

#define MT2701_PIN_274_G2_RXDV__FUNC_GPIO274 (MTK_PIN_NO(274) | 0)
#define MT2701_PIN_274_G2_RXDV__FUNC_G2_RXDV (MTK_PIN_NO(274) | 1)

#define MT2701_PIN_275_MDC__FUNC_GPIO275 (MTK_PIN_NO(275) | 0)
#define MT2701_PIN_275_MDC__FUNC_MDC (MTK_PIN_NO(275) | 1)
#define MT2701_PIN_275_MDC__FUNC_ANT_SEL0 (MTK_PIN_NO(275) | 6)

#define MT2701_PIN_276_MDIO__FUNC_GPIO276 (MTK_PIN_NO(276) | 0)
#define MT2701_PIN_276_MDIO__FUNC_MDIO (MTK_PIN_NO(276) | 1)
#define MT2701_PIN_276_MDIO__FUNC_ANT_SEL1 (MTK_PIN_NO(276) | 6)

#define MT2701_PIN_277_ESW_RST__FUNC_GPIO277 (MTK_PIN_NO(277) | 0)
#define MT2701_PIN_277_ESW_RST__FUNC_ESW_RST (MTK_PIN_NO(277) | 1)

#define MT2701_PIN_278_JTAG_RESET__FUNC_GPIO278 (MTK_PIN_NO(278) | 0)
#define MT2701_PIN_278_JTAG_RESET__FUNC_JTAG_RESET (MTK_PIN_NO(278) | 1)

#define MT2701_PIN_279_USB3_RES_BOND__FUNC_GPIO279 (MTK_PIN_NO(279) | 0)
#define MT2701_PIN_279_USB3_RES_BOND__FUNC_USB3_RES_BOND (MTK_PIN_NO(279) | 1)

#endif /* __DTS_MT2701_PINFUNC_H */
