 /*
  * Copyright (C) 2016 MediaTek Inc.
  *
  * This program is free software: you can redistribute it and/or modify
  * it under the terms of the GNU General Public License version 2 as
  * published by the Free Software Foundation.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  * GNU General Public License for more details.
  */

#include <linux/types.h>
#include "mtk_spm_internal.h"

static const u32 suspend_binary[] = {
	0x81f58407, 0x81f68407, 0x1800001f, 0x17cf0f3f, 0x1b80001f, 0x20000000,
	0x1800001f, 0x17cf0f16, 0xa1d28407, 0x81f20407, 0xe8208000, 0x10006b04,
	0x20000000, 0x81459801, 0xd80002e5, 0x17c07c1f, 0x81409801, 0xd80002e5,
	0x17c07c1f, 0x18c0001f, 0x10006234, 0xc0c01ee0, 0x1200041f, 0x18c0001f,
	0x10006b18, 0x1910001f, 0x10006b18, 0x813f8404, 0xe0c00004, 0x80310400,
	0x1b80001f, 0x2000000a, 0xa0110400, 0xe8208000, 0x10006b04, 0x40000000,
	0x81f00407, 0xa1dd0407, 0x81451801, 0xd80005a5, 0x17c07c1f, 0x18c0001f,
	0x100062d8, 0xc0c021a0, 0x1200041f, 0x1b80001f, 0x20000068, 0x81fd0407,
	0xe8208000, 0x10006b04, 0x00000000, 0xc2802aa0, 0x1290041f, 0x1b00001f,
	0x6f7cf7ff, 0xf0000000, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff, 0x1b80001f,
	0x20000004, 0xd8000d4c, 0x17c07c1f, 0x1880001f, 0x10006320, 0xc0c02480,
	0xe080000f, 0xd8200923, 0x17c07c1f, 0x1b00001f, 0x6f7cf7ff, 0xd0000d40,
	0x17c07c1f, 0xe080001f, 0x81409801, 0xd8000a25, 0x17c07c1f, 0x18c0001f,
	0x10006234, 0xc0c020c0, 0x17c07c1f, 0x81451801, 0xd8000b05, 0x17c07c1f,
	0x18c0001f, 0x100062d8, 0xc0c022c0, 0x17c07c1f, 0xe8208000, 0x10006b04,
	0x10000000, 0xc2802aa0, 0x1290841f, 0xc2802aa0, 0x129f841f, 0xa1d20407,
	0x81f28407, 0xa1d68407, 0x1800001f, 0x17cf0f3f, 0x1800001f, 0x17ff0f3f,
	0x19c0001f, 0x001c2397, 0x1b00001f, 0x2f7cefff, 0xf0000000, 0x17c07c1f,
	0x81411801, 0xd8000ea5, 0x17c07c1f, 0x18c0001f, 0x10006240, 0xe0e00016,
	0xe0e0001e, 0xe0e0000e, 0xe0e0000f, 0x803e0400, 0x1b80001f, 0x20000222,
	0x80380400, 0x1b80001f, 0x20000280, 0x803b0400, 0x1b80001f, 0x2000001a,
	0x803d0400, 0x1b80001f, 0x20000208, 0x80340400, 0x80310400, 0xe8208000,
	0x10210044, 0x00000100, 0x1b80001f, 0x20000068, 0x1b80001f, 0x20000100,
	0x18c0001f, 0x10006240, 0xe0e0000d, 0xd8001525, 0x17c07c1f, 0x1b80001f,
	0x20000020, 0x18c0001f, 0x1000f0f0, 0x1910001f, 0x1000f0f0, 0xa9000004,
	0x10000000, 0xe0c00004, 0x1b80001f, 0x2000000a, 0x89000004, 0xefffffff,
	0xe0c00004, 0x18c0001f, 0x102140f4, 0x1910001f, 0x102140f4, 0xa9000004,
	0x02000000, 0xe0c00004, 0x1b80001f, 0x2000000a, 0x89000004, 0xfdffffff,
	0xe0c00004, 0x1b80001f, 0x20000100, 0x81fa0407, 0x81f08407, 0xe8208000,
	0x10006354, 0x00dffb23, 0xa1d80407, 0xa1de8407, 0xa1df0407, 0xc2802aa0,
	0x1291041f, 0x1b00001f, 0xaf7ce7ff, 0xf0000000, 0x17c07c1f, 0x1b80001f,
	0x20000fdf, 0x1a50001f, 0x10006608, 0x80c9a401, 0x810ba401, 0x10920c1f,
	0xa0979002, 0x80ca2401, 0xa0938c02, 0x8080080d, 0xd8201a02, 0x17c07c1f,
	0x1b00001f, 0x2f7ce7ff, 0x1b80001f, 0x20000004, 0xd8001eac, 0x17c07c1f,
	0x1b00001f, 0xaf7ce7ff, 0xd8001eac, 0x17c07c1f, 0x81f80407, 0x81fe8407,
	0x81ff0407, 0x1880001f, 0x10006320, 0xc0c02360, 0xe080000f, 0xd8001ea3,
	0x17c07c1f, 0xe080001f, 0xa1da0407, 0xe8208000, 0x10210048, 0x00000100,
	0x1b80001f, 0x20000068, 0xa0110400, 0xa0140400, 0xa0180400, 0xa01b0400,
	0xa01d0400, 0x1b80001f, 0x20000068, 0xa01e0400, 0x1b80001f, 0x20000104,
	0x81411801, 0xd8001e25, 0x17c07c1f, 0x18c0001f, 0x10006240, 0xc0c022c0,
	0x17c07c1f, 0xc2802aa0, 0x1291841f, 0x1b00001f, 0x6f7cf7ff, 0xf0000000,
	0x17c07c1f, 0xe0f07f16, 0x1380201f, 0xe0f07f1e, 0x1380201f, 0xe0f07f0e,
	0x1b80001f, 0x20000100, 0xe0f07f0c, 0xe0f07f0d, 0xe0f07e0d, 0xe0f07c0d,
	0xe0f0780d, 0xe0f0700d, 0xf0000000, 0x17c07c1f, 0xe0f07f0d, 0xe0f07f1d,
	0xe0f07f1f, 0xe0f07f1e, 0xe0f07f12, 0xf0000000, 0x17c07c1f, 0xe0e00016,
	0x1380201f, 0xe0e0001e, 0x1380201f, 0xe0e0000e, 0xe0e0000c, 0xe0e0000d,
	0xf0000000, 0x17c07c1f, 0xe0e0000f, 0xe0e0001e, 0xe0e00012, 0xf0000000,
	0x17c07c1f, 0xa1d08407, 0x1b80001f, 0x2000000a, 0x80eab401, 0x1a00001f,
	0x10006814, 0xe2000003, 0xf0000000, 0x17c07c1f, 0xa1d00407, 0x1b80001f,
	0x20000100, 0x80ea3401, 0x1a00001f, 0x10006814, 0xe2000003, 0xf0000000,
	0x17c07c1f, 0xd800266a, 0x17c07c1f, 0xe2e00036, 0xe2e0003e, 0x1380201f,
	0xe2e0003c, 0xd82027aa, 0x17c07c1f, 0x1b80001f, 0x20000018, 0xe2e0007c,
	0x1b80001f, 0x20000003, 0xe2e0005c, 0xe2e0004c, 0xe2e0004d, 0xf0000000,
	0x17c07c1f, 0xa1d10407, 0x1b80001f, 0x20000020, 0xf0000000, 0x17c07c1f,
	0xa1d40407, 0x1391841f, 0xa1d90407, 0xf0000000, 0x17c07c1f, 0xd80029ca,
	0x17c07c1f, 0xe2e0004f, 0xe2e0006f, 0xe2e0002f, 0xd8202a6a, 0x17c07c1f,
	0xe2e0002e, 0xe2e0003e, 0xe2e00032, 0xf0000000, 0x17c07c1f, 0x18c0001f,
	0x10006b18, 0x1910001f, 0x10006b18, 0xa1002804, 0xe0c00004, 0xf0000000,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0xe8208000, 0x10006b18, 0x00000000, 0x1b00001f, 0x2f7ce7ff,
	0x1b80001f, 0xd00f0000, 0x8880000c, 0x2f7ce7ff, 0xd8005862, 0x17c07c1f,
	0xe8208000, 0x10006354, 0x00dffb23, 0xc0c027e0, 0x81401801, 0x18c0001f,
	0x10000338, 0x1910001f, 0x10000338, 0x81308404, 0xe0c00004, 0xd80047e5,
	0x17c07c1f, 0x81f60407, 0x18c0001f, 0x10006200, 0xc0c02920, 0x12807c1f,
	0xe8208000, 0x1000625c, 0x00000001, 0x1b80001f, 0x20000080, 0xc0c02920,
	0x1280041f, 0x18c0001f, 0x10006208, 0xc0c02920, 0x12807c1f, 0xe8208000,
	0x10006244, 0x00000001, 0x1b80001f, 0x20000080, 0xc0c02920, 0x1280041f,
	0x18c0001f, 0x10006290, 0xc0c02920, 0x12807c1f, 0xc0c02920, 0x1280041f,
	0x18c0001f, 0x100062dc, 0xe0c00001, 0xc2802aa0, 0x1292041f, 0xc0c02880,
	0x17c07c1f, 0xe8208000, 0x10006294, 0x0030ffff, 0xe8208000, 0x10006294,
	0x00300fff, 0xe8208000, 0x10006294, 0x003000ff, 0x81449801, 0xd80049a5,
	0x17c07c1f, 0xa1d38407, 0xa1d98407, 0xa0108400, 0xa0120400, 0xa0148400,
	0xa0150400, 0xa0158400, 0xa01b8400, 0xa01c0400, 0xa01c8400, 0xa0188400,
	0xa0190400, 0xa0198400, 0xe8208000, 0x10006310, 0x0b1600f8, 0x1b00001f,
	0xaf7ce7ff, 0x1b80001f, 0x90100000, 0x80c00001, 0xc8c00003, 0x17c07c1f,
	0x80c10001, 0xc8c00d83, 0x17c07c1f, 0x1b00001f, 0x2ffde7ff, 0x18c0001f,
	0x10006294, 0xe8208000, 0x10006294, 0x003001fe, 0xe8208000, 0x10006294,
	0x003003fc, 0xe8208000, 0x10006294, 0x003007f8, 0xe8208000, 0x10006294,
	0x00300ff0, 0xe8208000, 0x10006294, 0x00200ff0, 0xe8208000, 0x10006294,
	0x00000ff0, 0x1b80001f, 0x20000020, 0xe0f07ff0, 0xe0f07f00, 0x81449801,
	0xd8005085, 0x17c07c1f, 0x80388400, 0x80390400, 0x80398400, 0x1b80001f,
	0x20000300, 0x803b8400, 0x803c0400, 0x803c8400, 0x1b80001f, 0x20000300,
	0x80348400, 0x80350400, 0x80358400, 0x1b80001f, 0x20000104, 0x10007c1f,
	0x81f38407, 0x81f98407, 0x81f90407, 0x81f40407, 0x81401801, 0xd80057a5,
	0x17c07c1f, 0x18c0001f, 0x100062dc, 0xe0c0001f, 0x18c0001f, 0x10006290,
	0x1212841f, 0xc0c025a0, 0x12807c1f, 0xc0c025a0, 0x1280041f, 0x18c0001f,
	0x10006208, 0x1212841f, 0xc0c025a0, 0x12807c1f, 0xe8208000, 0x10006244,
	0x00000000, 0x1b80001f, 0x20000080, 0xc0c025a0, 0x1280041f, 0x18c0001f,
	0x10006200, 0x1212841f, 0xc0c025a0, 0x12807c1f, 0xe8208000, 0x1000625c,
	0x00000000, 0x1b80001f, 0x20000080, 0xc0c025a0, 0x1280041f, 0x18c0001f,
	0x10000338, 0x1910001f, 0x10000338, 0xa1108404, 0xe0c00004, 0x19c0001f,
	0x60415820, 0x18c0001f, 0x10006b14, 0x1910001f, 0x10006b14, 0x09000004,
	0x00000001, 0xe0c00004, 0xc2802aa0, 0x1293841f, 0x1ac0001f, 0x55aa55aa,
	0x10007c1f, 0xf0000000
};
struct pcm_desc suspend_pcm = {
	.version	= "pcm_suspend_c1",
	.base		= suspend_binary,
	.size		= 722,
	.sess		= 2,
	.replace	= 0,
	.vec0		= EVENT_VEC(11, 1, 0, 0),	/* FUNC_26M_WAKEUP */
	.vec1		= EVENT_VEC(12, 1, 0, 57),	/* FUNC_26M_SLEEP */
	.vec2		= EVENT_VEC(30, 1, 0, 108),	/* FUNC_APSRC_WAKEUP */
	.vec3		= EVENT_VEC(31, 1, 0, 185),	/* FUNC_APSRC_SLEEP */
};

static const u32 deepidle_c1_binary[] = {
	0x80328400, 0x80318400, 0x18c0001f, 0x10006b18, 0x1910001f, 0x10006b18,
	0x813f0404, 0xe0c00004, 0xc28020e0, 0x1290041f, 0x1b00001f, 0x6f7cf7ff,
	0xf0000000, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff, 0x1b80001f, 0x20000004,
	0xd800038c, 0x17c07c1f, 0xa0118400, 0xa0128400, 0xc28020e0, 0x1290841f,
	0xc28020e0, 0x129f041f, 0x1b00001f, 0x2f7cefff, 0xf0000000, 0x17c07c1f,
	0x81411801, 0xd80004e5, 0x17c07c1f, 0x18c0001f, 0x10006240, 0xe0e00016,
	0xe0e0001e, 0xe0e0000e, 0xe0e0000f, 0x803e0400, 0x1b80001f, 0x20000222,
	0x80380400, 0x1b80001f, 0x20000280, 0x803b0400, 0x1b80001f, 0x2000001a,
	0x803d0400, 0x1b80001f, 0x20000208, 0x80340400, 0x80310400, 0xe8208000,
	0x10210044, 0x00000100, 0x1b80001f, 0x20000068, 0x1b80001f, 0x20000100,
	0x18c0001f, 0x10006240, 0xe0e0000d, 0xd8000b65, 0x17c07c1f, 0x1b80001f,
	0x20000020, 0x18c0001f, 0x1000f0f0, 0x1910001f, 0x1000f0f0, 0xa9000004,
	0x10000000, 0xe0c00004, 0x1b80001f, 0x2000000a, 0x89000004, 0xefffffff,
	0xe0c00004, 0x18c0001f, 0x102140f4, 0x1910001f, 0x102140f4, 0xa9000004,
	0x02000000, 0xe0c00004, 0x1b80001f, 0x2000000a, 0x89000004, 0xfdffffff,
	0xe0c00004, 0x1b80001f, 0x20000100, 0x81fa0407, 0x81f08407, 0xe8208000,
	0x10006354, 0x00dffb23, 0xa1d80407, 0xa1de8407, 0xa1df0407, 0xc28020e0,
	0x1291041f, 0x1b00001f, 0xaf7ce7ff, 0xf0000000, 0x17c07c1f, 0x1b80001f,
	0x20000fdf, 0x1a50001f, 0x10006608, 0x80c9a401, 0x810ba401, 0x10920c1f,
	0xa0979002, 0x80ca2401, 0xa0938c02, 0x8080080d, 0xd8201042, 0x17c07c1f,
	0x1b00001f, 0x2f7ce7ff, 0x1b80001f, 0x20000004, 0xd80014ec, 0x17c07c1f,
	0x1b00001f, 0xaf7ce7ff, 0xd80014ec, 0x17c07c1f, 0x81f80407, 0x81fe8407,
	0x81ff0407, 0x1880001f, 0x10006320, 0xc0c019a0, 0xe080000f, 0xd80014e3,
	0x17c07c1f, 0xe080001f, 0xa1da0407, 0xe8208000, 0x10210048, 0x00000100,
	0x1b80001f, 0x20000068, 0xa0110400, 0xa0140400, 0xa0180400, 0xa01b0400,
	0xa01d0400, 0x1b80001f, 0x20000068, 0xa01e0400, 0x1b80001f, 0x20000104,
	0x81411801, 0xd8001465, 0x17c07c1f, 0x18c0001f, 0x10006240, 0xc0c01900,
	0x17c07c1f, 0xc28020e0, 0x1291841f, 0x1b00001f, 0x6f7cf7ff, 0xf0000000,
	0x17c07c1f, 0xe0f07f16, 0x1380201f, 0xe0f07f1e, 0x1380201f, 0xe0f07f0e,
	0x1b80001f, 0x20000100, 0xe0f07f0c, 0xe0f07f0d, 0xe0f07e0d, 0xe0f07c0d,
	0xe0f0780d, 0xe0f0700d, 0xf0000000, 0x17c07c1f, 0xe0f07f0d, 0xe0f07f1d,
	0xe0f07f1f, 0xe0f07f1e, 0xe0f07f12, 0xf0000000, 0x17c07c1f, 0xe0e00016,
	0x1380201f, 0xe0e0001e, 0x1380201f, 0xe0e0000e, 0xe0e0000c, 0xe0e0000d,
	0xf0000000, 0x17c07c1f, 0xe0e0000f, 0xe0e0001e, 0xe0e00012, 0xf0000000,
	0x17c07c1f, 0xa1d08407, 0x1b80001f, 0x2000000a, 0x80eab401, 0x1a00001f,
	0x10006814, 0xe2000003, 0xf0000000, 0x17c07c1f, 0xa1d00407, 0x1b80001f,
	0x20000100, 0x80ea3401, 0x1a00001f, 0x10006814, 0xe2000003, 0xf0000000,
	0x17c07c1f, 0xd8001caa, 0x17c07c1f, 0xe2e00036, 0xe2e0003e, 0x1380201f,
	0xe2e0003c, 0xd8201dea, 0x17c07c1f, 0x1b80001f, 0x20000018, 0xe2e0007c,
	0x1b80001f, 0x20000003, 0xe2e0005c, 0xe2e0004c, 0xe2e0004d, 0xf0000000,
	0x17c07c1f, 0xa1d10407, 0x1b80001f, 0x20000020, 0xf0000000, 0x17c07c1f,
	0xa1d40407, 0x1391841f, 0xa1d90407, 0xf0000000, 0x17c07c1f, 0xd800200a,
	0x17c07c1f, 0xe2e0004f, 0xe2e0006f, 0xe2e0002f, 0xd82020aa, 0x17c07c1f,
	0xe2e0002e, 0xe2e0003e, 0xe2e00032, 0xf0000000, 0x17c07c1f, 0x18c0001f,
	0x10006b18, 0x1910001f, 0x10006b18, 0xa1002804, 0xe0c00004, 0xf0000000,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0xe8208000, 0x10006b18, 0x00000000, 0x1b00001f, 0x2f7ce7ff,
	0x1b80001f, 0xd00f0000, 0x8880000c, 0x2f7ce7ff, 0xd8005862, 0x17c07c1f,
	0xe8208000, 0x10006354, 0x00dffb23, 0xc0c01e20, 0x81401801, 0x18c0001f,
	0x10000338, 0x1910001f, 0x10000338, 0x81308404, 0xe0c00004, 0xd80047e5,
	0x17c07c1f, 0x81f60407, 0x18c0001f, 0x10006200, 0xc0c01f60, 0x12807c1f,
	0xe8208000, 0x1000625c, 0x00000001, 0x1b80001f, 0x20000080, 0xc0c01f60,
	0x1280041f, 0x18c0001f, 0x10006208, 0xc0c01f60, 0x12807c1f, 0xe8208000,
	0x10006244, 0x00000001, 0x1b80001f, 0x20000080, 0xc0c01f60, 0x1280041f,
	0x18c0001f, 0x10006290, 0xc0c01f60, 0x12807c1f, 0xc0c01f60, 0x1280041f,
	0x18c0001f, 0x100062dc, 0xe0c00001, 0xc28020e0, 0x1292041f, 0xc0c01ec0,
	0x17c07c1f, 0xe8208000, 0x10006294, 0x0030ffff, 0xe8208000, 0x10006294,
	0x00300fff, 0xe8208000, 0x10006294, 0x003000ff, 0x81449801, 0xd80049a5,
	0x17c07c1f, 0xa1d38407, 0xa1d98407, 0xa0108400, 0xa0120400, 0xa0148400,
	0xa0150400, 0xa0158400, 0xa01b8400, 0xa01c0400, 0xa01c8400, 0xa0188400,
	0xa0190400, 0xa0198400, 0xe8208000, 0x10006310, 0x0b1600f8, 0x1b00001f,
	0xaf7ce7ff, 0x1b80001f, 0x90100000, 0x80c00001, 0xc8c00003, 0x17c07c1f,
	0x80c10001, 0xc8c003c3, 0x17c07c1f, 0x1b00001f, 0x2ffde7ff, 0x18c0001f,
	0x10006294, 0xe8208000, 0x10006294, 0x003001fe, 0xe8208000, 0x10006294,
	0x003003fc, 0xe8208000, 0x10006294, 0x003007f8, 0xe8208000, 0x10006294,
	0x00300ff0, 0xe8208000, 0x10006294, 0x00200ff0, 0xe8208000, 0x10006294,
	0x00000ff0, 0x1b80001f, 0x20000020, 0xe0f07ff0, 0xe0f07f00, 0x81449801,
	0xd8005085, 0x17c07c1f, 0x80388400, 0x80390400, 0x80398400, 0x1b80001f,
	0x20000300, 0x803b8400, 0x803c0400, 0x803c8400, 0x1b80001f, 0x20000300,
	0x80348400, 0x80350400, 0x80358400, 0x1b80001f, 0x20000104, 0x10007c1f,
	0x81f38407, 0x81f98407, 0x81f90407, 0x81f40407, 0x81401801, 0xd80057a5,
	0x17c07c1f, 0x18c0001f, 0x100062dc, 0xe0c0001f, 0x18c0001f, 0x10006290,
	0x1212841f, 0xc0c01be0, 0x12807c1f, 0xc0c01be0, 0x1280041f, 0x18c0001f,
	0x10006208, 0x1212841f, 0xc0c01be0, 0x12807c1f, 0xe8208000, 0x10006244,
	0x00000000, 0x1b80001f, 0x20000080, 0xc0c01be0, 0x1280041f, 0x18c0001f,
	0x10006200, 0x1212841f, 0xc0c01be0, 0x12807c1f, 0xe8208000, 0x1000625c,
	0x00000000, 0x1b80001f, 0x20000080, 0xc0c01be0, 0x1280041f, 0x18c0001f,
	0x10000338, 0x1910001f, 0x10000338, 0xa1108404, 0xe0c00004, 0x19c0001f,
	0x60415820, 0x18c0001f, 0x10006b14, 0x1910001f, 0x10006b14, 0x09000004,
	0x00000001, 0xe0c00004, 0xc28020e0, 0x1293841f, 0x1ac0001f, 0x55aa55aa,
	0x10007c1f, 0xf0000000
};
struct pcm_desc dpidle_pcm = {
	.version	= "pcm_deepidle_c1",
	.base		= deepidle_c1_binary,
	.size		= 722,
	.sess		= 2,
	.replace	= 0,
	.vec0		= EVENT_VEC(11, 1, 0, 0),	/* FUNC_26M_WAKEUP */
	.vec1		= EVENT_VEC(12, 1, 0, 14),	/* FUNC_26M_SLEEP */
	.vec2		= EVENT_VEC(30, 1, 0, 30),	/* FUNC_APSRC_WAKEUP */
	.vec3		= EVENT_VEC(31, 1, 0, 107),	/* FUNC_APSRC_SLEEP */
};
