/*
 * (C) Copyright 2020~2021
 * Implement for NEC Soleil projects
 * David@D4R130,WNC.
 
 */

#include <common.h>
#include <command.h>
#include <version.h>
#include <wnc_config.h>

#define MAX_COMMAND_LEN    			16
#define MAX_INPUT_LEN				128
#define mysleep(a)					udelay(a*1000)

unsigned char token[MAX_INPUT_LEN];
unsigned char input_buf[MAX_INPUT_LEN];
unsigned char* input_string;

typedef struct _clicmd {
	char 			name[MAX_COMMAND_LEN];
	void     		(*function)(struct _clicmd *);
	struct  _clicmd *next_cmd_table;
} CLICMD;


void parse_next_cmd(CLICMD *ptable);
void get_user_input(unsigned char *, unsigned int flag);
int look_up(unsigned char *, CLICMD *ptable);
int isspace(unsigned char c);
int isalpha(unsigned char c);
int isdigit_wnc(unsigned char c);
unsigned int isdelim(unsigned char c);
unsigned char* get_token(void);

void do_mfg_btn(CLICMD *ptable);
void do_mfg_ddr(CLICMD *ptable);
void do_mfg_help(CLICMD *ptable);
void do_mfg_info(CLICMD *ptable);
void do_mfg_led(CLICMD *ptable);
void do_mfg_nandinfo(CLICMD *ptable);
void do_mfg_nandbad(CLICMD *ptable);
void do_mfg_pkgid(CLICMD *ptable);
void do_mfg_slideswitch(CLICMD *ptable);

CLICMD nandcmdtable[] = {
	{"info",			do_mfg_nandinfo, 			NULL},
	{"bad",				do_mfg_nandbad, 			NULL},
	{"",				NULL,						NULL},
};

CLICMD clicmds[] = {
	{"btn",			do_mfg_btn,				NULL},
	{"ddr",			do_mfg_ddr,				NULL},
	{"help",		do_mfg_help,			NULL},
	{"info", 		do_mfg_info, 			NULL},
	{"led", 		do_mfg_led, 			NULL},
	{"nand",		parse_next_cmd,			nandcmdtable},
	{"pkgid", 		do_mfg_pkgid, 			NULL},
	{"slideswitch", do_mfg_slideswitch, 	NULL},
	{"",			NULL,					NULL},
};

#define INT_MAX		((int)(~0U>>1))
extern const unsigned char _ctype[];
#define _D	0x04
#define _X	0x40
#define __ismask(x) (_ctype[(int)(unsigned char)(x)])
#define isdigit(c)	((__ismask(c)&(_D)) != 0)
#define isxdigit(c)	((__ismask(c)&(_D|_X)) != 0)
#define is_digit(c)	((c) >= '0' && (c) <= '9')

int atoi(char *string)
{
    register int result = 0;
    register unsigned int digit;
    int sign;

    while (isspace(*string))
	{
		string += 1;
    }

    if (*string == '-') {
		sign = 1;
		string += 1;
    } else {
		sign = 0;
		if (*string == '+') {
	    	string += 1;
		}
    }

    for ( ; ; string += 1) 
	{
		digit = *string - '0';
		if (digit > 9)
		{
	    	break;
		}
		result = (10*result) + digit;
    }

    if (sign)
	{
		return -result;
    }
    return result;
}

static int skip_atoi(const char **s)
{
	int i=0;

	while (is_digit(**s))
		i = i*10 + *((*s)++) - '0';
	return i;
}

int vsscanf(const char * buf, const char * fmt, va_list args)
{
	const char *str = buf;
	char *next;
	char digit;
	int num = 0;
	int qualifier;
	int base;
	int field_width;
	int is_sign = 0;

	while(*fmt && *str) {
		if (isspace(*fmt)) {
			while (isspace(*fmt))
				++fmt;
			while (isspace(*str))
				++str;
		}

		if (*fmt != '%' && *fmt) {
			if (*fmt++ != *str++)
				break;
			continue;
		}

		if (!*fmt)
			break;
		++fmt;

		if (*fmt == '*') {
			while (!isspace(*fmt) && *fmt)
				fmt++;
			while (!isspace(*str) && *str)
				str++;
			continue;
		}

		field_width = -1;
		if (isdigit(*fmt))
			field_width = skip_atoi(&fmt);

		qualifier = -1;
		if (*fmt == 'h' || *fmt == 'l' || *fmt == 'L' ||
		    *fmt == 'Z' || *fmt == 'z') {
			qualifier = *fmt++;
			if (unlikely(qualifier == *fmt)) {
				if (qualifier == 'h') {
					qualifier = 'H';
					fmt++;
				} else if (qualifier == 'l') {
					qualifier = 'L';
					fmt++;
				}
			}
		}
		base = 10;
		is_sign = 0;

		if (!*fmt || !*str)
			break;

		switch(*fmt++) {
		case 'c':
		{
			char *s = (char *) va_arg(args,char*);
			if (field_width == -1)
				field_width = 1;
			do {
				*s++ = *str++;
			} while (--field_width > 0 && *str);
			num++;
		}
		continue;
		case 's':
		{
			char *s = (char *) va_arg(args, char *);
			if(field_width == -1)
				field_width = INT_MAX;
			while (isspace(*str))
				str++;

			while (*str && !isspace(*str) && field_width--) {
				*s++ = *str++;
			}
			*s = '\0';
			num++;
		}
		continue;
		case 'n':
		{
			int *i = (int *)va_arg(args,int*);
			*i = str - buf;
		}
		continue;
		case 'o':
			base = 8;
			break;
		case 'x':
		case 'X':
			base = 16;
			break;
		case 'i':
                        base = 0;
		case 'd':
			is_sign = 1;
		case 'u':
			break;
		case '%':
			if (*str++ != '%') 
				return num;
			continue;
		default:
			return num;
		}

		while (isspace(*str))
			str++;

		digit = *str;
		if (is_sign && digit == '-')
			digit = *(str + 1);

		if (!digit
                    || (base == 16 && !isxdigit(digit))
                    || (base == 10 && !isdigit(digit))
                    || (base == 8 && (!isdigit(digit) || digit > '7'))
                    || (base == 0 && !isdigit(digit)))
				break;

		switch(qualifier) {
		case 'H':
			if (is_sign) {
				signed char *s = (signed char *) va_arg(args,signed char *);
				*s = (signed char) simple_strtol(str,&next,base);
			} else {
				unsigned char *s = (unsigned char *) va_arg(args, unsigned char *);
				*s = (unsigned char) simple_strtoul(str, &next, base);
			}
			break;
		case 'h':
			if (is_sign) {
				short *s = (short *) va_arg(args,short *);
				*s = (short) simple_strtol(str,&next,base);
			} else {
				unsigned short *s = (unsigned short *) va_arg(args, unsigned short *);
				*s = (unsigned short) simple_strtoul(str, &next, base);
			}
			break;
		case 'l':
			if (is_sign) {
				long *l = (long *) va_arg(args,long *);
				*l = simple_strtol(str,&next,base);
			} else {
				unsigned long *l = (unsigned long*) va_arg(args,unsigned long*);
				*l = simple_strtoul(str,&next,base);
			}
			break;
#ifdef CFG_64BIT_STRTOUL			
		case 'L':
			if (is_sign) {
				long long *l = (long long*) va_arg(args,long long *);
				*l = simple_strtoll(str,&next,base);
			} else {		
				unsigned long long *l = (unsigned long long*) va_arg(args,unsigned long long*);
				*l = simple_strtoull(str,&next,base);
			}
			break;
#endif			
		case 'Z':
		case 'z':
		{
			size_t *s = (size_t*) va_arg(args,size_t*);
			*s = (size_t) simple_strtoul(str,&next,base);
		}
		break;
		default:
			if (is_sign) {
				int *i = (int *) va_arg(args, int*);
				*i = (int) simple_strtol(str,&next,base);
			} else {
				unsigned int *i = (unsigned int*) va_arg(args, unsigned int*);
				*i = (unsigned int) simple_strtoul(str,&next,base);
			}
			break;
		}
		num++;

		if (!next)
			break;
		str = next;
	}

	if (*fmt == '%' && *(fmt + 1) == 'n') {
		int *p = (int *)va_arg(args, int *);
		*p = str - buf;
	}

	return num;
}

int sscanf(const char * buf, const char * fmt, ...)
{
	va_list args;
	int i;

	va_start(args,fmt);
	i = vsscanf(buf,fmt,args);
	va_end(args);
	return i;
}

int isspace(unsigned char c)
{
	return ((c >= 0x09 && c <= 0x0D) || (c == 0x20));
}

int isalpha(unsigned char c)
{
	return ((c >='a' && c <='z') || (c >='A' && c <='Z'));
}

int isdigit_wnc(unsigned char c)
{
	return (c >='0' && c <='9');
}

unsigned int isdelim(unsigned char c)
{
	if (c=='0x20' ||  c=='\n' || c==' ')
		return 1;
	else
		return 0;
}

void get_user_input (unsigned char *p, unsigned int flag)
{
	int i = 0;
	memset(p, 0, MAX_INPUT_LEN);
	wncdebug("%s() 1",__func__);
	do {
		p[i] = getc();
		if (p[0] == 0x0D )
			continue;
		if ( flag == 1 )
			putc('*');
		i++;
	} while (p[i-1] != 0x0A);
	wncdebug("%s() 2",__func__);
	if (p[i-2] == 0x0D && p[i-1] == 0x0A) {
		p[i-2] = 0x0A;
		p[i-1] = '\0';
	}
	else
		p[strlen((char *)p)] = '\0';

	input_string = p;
	return;
}

unsigned char* get_token()
{
	char *temp = token;
	memset(token,0,MAX_INPUT_LEN);
	while(isspace(*input_string)) 
		++input_string;
	if(isalpha(*input_string) || isdigit_wnc(*input_string))
	{
		while (!isdelim(*input_string)) 
			*temp++ = *input_string++;
	}
	*temp = '\0';
	return token;
}

int look_up(unsigned char *input_string, CLICMD *ptable)
{
	unsigned int i;
	CLICMD *pcommand;
	
	for (i = 0, pcommand = ptable; pcommand->function; pcommand++, i++) {
		if (!strcmp(pcommand->name, (char *)input_string))
			return i;
	}
	return -1;
}

void parse_next_cmd(CLICMD *ptable)
{
	int clicmd_id = 0;
	unsigned char *param = NULL;

	param = get_token();
	if (ptable) {
		clicmd_id = look_up(param, ptable);
		if (clicmd_id >= 0)
			ptable[clicmd_id].function(ptable[clicmd_id].next_cmd_table);
		else
			puts("Type \"help\" for usage !\n");
	}
	return;
}


int check_if_btn_pressed(int gpio)
{
	unsigned int reg_data=0;
	
	reg_data=(((*(volatile unsigned int *)gpio_input_reg(gpio))>>(gpio%32)) & 0x1);

	wncdebug("reg=0x%08x, mask=%d(decimal), result=0x%01x\n", (*(volatile unsigned int *)gpio_input_reg(gpio)), (gpio%32),  reg_data);
	
	return reg_data;
}

void do_mfg_btn(CLICMD *ptable)
{
	unsigned char *param = NULL;
	int pressed=FALSE_VALUE, gpio=-1;

	param = get_token();
	wncdebug("%s(): %s\n", __func__, param);
	if(strcmp((char*)param, BUTTON_MAINTENANCE_SW) == 0)
	{
		gpio = GPIO_MAINTAIN_SW;
		printf("Button %s(GPIO_%d) is ", BUTTON_MAINTENANCE_SW, GPIO_MAINTAIN_SW);
	}else if(strcmp((char*)param, BUTTON_RESET_SW) == 0)
	{
		gpio = GPIO_RESET_SW;
		printf("Button %s(GPIO_%d) is ", BUTTON_RESET_SW, GPIO_RESET_SW);
	}else if(strcmp((char*)param, BUTTON_MODE_SW_1) == 0)
	{
		gpio = GPIO_MODE_SW_1;
		printf("Button %s(GPIO_%d) is ", BUTTON_MODE_SW_1, GPIO_MODE_SW_1);
	}else if(strcmp((char*)param, BUTTON_MODE_SW_2) == 0)
	{
		gpio = GPIO_MODE_SW_2;
		printf("Button %s(GPIO_%d) is ", BUTTON_MODE_SW_2, GPIO_MODE_SW_2);
	}else if(strcmp((char*)param, BUTTON_WIRELESS_SW) == 0)
	{
		gpio = GPIO_WF_SW;
		printf("Button %s(GPIO_%d) is ", BUTTON_WIRELESS_SW, GPIO_WF_SW);
	}else
	{
		printf("Wrong Parameter! <Usage> mfg btn [mainten | reset | modesw1 | modesw2 | wifisw]\n");
		return;
	}
	wncdebug("GPIO=%d, ", gpio);
	setGPIODir(gpio, GPIO_DIR_INPUT);
	wncdebug("Dir=0x%08x, ", (*(volatile unsigned int *)gpio_dir_reg(gpio)));
	pressed=check_if_btn_pressed(gpio);
	if(pressed)
	{
		printf(" Released.\n");
	}
	else
	{
		printf(" Pressed.\n");
	}
	return;
}


void do_mfg_slideswitch(CLICMD *ptable)
{
	int gpio=-1, mode_sw_1=-1, mode_sw_2=-1;

	wncdebug("%s(): \n", __func__);

	gpio = GPIO_MODE_SW_1;
	wncdebug("GPIO=%d, ", gpio);
	wncdebug("Dir=0x%08x, ", (*(volatile unsigned int *)gpio_dir_reg(gpio)));
	mode_sw_1=check_if_btn_pressed(gpio);
	gpio = GPIO_MODE_SW_2;
	wncdebug("GPIO=%d, ", gpio);
	wncdebug("Dir=0x%08x, ", (*(volatile unsigned int *)gpio_dir_reg(gpio)));
	mode_sw_2=check_if_btn_pressed(gpio);
	
	wncdebug("mode_sw_1,mode_sw_2=%d%d\n", mode_sw_1, mode_sw_2);

	if(mode_sw_2==1 && mode_sw_1==1)
	{
		printf("Mode is: Router.\n");
	}else if(mode_sw_2==1 && mode_sw_1==0)
	{
		printf("Mode is: Bridge.\n");
	}else if (mode_sw_2==0 && mode_sw_1==1)
	{
		printf("Mode is: Converter.\n");
	}else
	{
		printf("Mode is: undefined! Error!\n");
	}

	return;
}

void do_mfg_pkgid(CLICMD *ptable)
{
	int gpio=-1, pkgid0=-1, pkgid1=-1, pkgid2=-1;

	wncdebug("%s(): \n", __func__);
	gpio = GPIO_PKGID_0;
	wncdebug("GPIO=%d, ", gpio);
	setGPIODir(gpio, GPIO_DIR_INPUT);
	wncdebug("Dir=0x%08x, ", (*(volatile unsigned int *)gpio_dir_reg(gpio)));
	pkgid0=check_if_btn_pressed(gpio);
	gpio = GPIO_PKGID_1;
	wncdebug("GPIO=%d, ", gpio);
	setGPIODir(gpio, GPIO_DIR_INPUT);
	wncdebug("Dir=0x%08x, ", (*(volatile unsigned int *)gpio_dir_reg(gpio)));
	pkgid1=check_if_btn_pressed(gpio);
	gpio = GPIO_PKGID_2;
	wncdebug("GPIO=%d, ", gpio);
	setGPIODir(gpio, GPIO_DIR_INPUT);
	wncdebug("Dir=0x%08x, ", (*(volatile unsigned int *)gpio_dir_reg(gpio)));
	pkgid2=check_if_btn_pressed(gpio);
	printf("pkgid2,pkgid1,pkgid0=%d%d%d\n", pkgid2, pkgid1, pkgid0);
	return;
}

void do_mfg_ddr(CLICMD *ptable)
{
	printf("Function %s is NOT ready!\n", __func__);
}


void do_mfg_help(CLICMD *ptable)
{
	printf("======MFG test program for %s (%s): %s.%s======\n", PROJECT_ID, PROJECT_NAME, WNC_UBOOT_VERSION, MFG_SUBVERSION);
	printf("Note: GPIO definition is based on %s.\n\n", SOLEIL_GPIO_DEFINITION_DOC);
	printf("Usage & Description: \n");
	printf("mfg btn [mainten | reset | wifisw] - buttons test. \n");
	printf("mfg info - Display MFG program revision history. \n");
	printf("mfg led [powerg | powerr | actg | actr | 2gg | 2gr | 5gg | 5gr | tvg | tvr | cnvg | cnvr | wanlan | off] - LED test. \n");
	printf("mfg pkgid - Show the values of pkgid0,pkdid1,pkgid2. \n");
	printf("mfg slideswitch - Show it's Router, Bridge, or Converter mode.\n");
	printf("=============================================================================\n");
	return;
}

void do_mfg_info(CLICMD *ptable)
{
	printf("Project_NAME: %s\n", PROJECT_NAME);
	printf("WNC Uboot Version: %s\n", WNC_UBOOT_VERSION);
	printf("MFG Version: %s\n", MFG_SUBVERSION);
	printf("GPIO definition Doc.: %s\n", SOLEIL_GPIO_DEFINITION_DOC);
	return;
}

void close_all_leds(void)
{
	unsigned int reg_addr=0;
#if defined(GPIO_V2) || defined(GPIO_V3)
	reg_addr = GPIO_OUT_1;
	(*(volatile unsigned int *)reg_addr) |= GPIO_MASK_OUT_HIGH_31;
	reg_addr = GPIO_OUT_2;
	(*(volatile unsigned int *)reg_addr) |= GPIO_MASK_OUT_HIGH_32TO36;
	reg_addr = GPIO_OUT_3;
	(*(volatile unsigned int *)reg_addr) |= GPIO_MASK_OUT_HIGH_86_91TO94;
	reg_addr = GPIO_OUT_4;
	(*(volatile unsigned int *)reg_addr) |= GPIO_MASK_OUT_HIGH_99TO100;
#else
	run_command("mw 0x10211300 0x00101200", 0);
	wncdebug("0x%08x=0x%08x, 0x%08x=0x%08x,", GPIO_OUT_1, (*(volatile unsigned int *)GPIO_OUT_1), GPIO_OUT_2, (*(volatile unsigned int *)GPIO_OUT_2));
	reg_addr = GPIO_OUT_1;
	(*(volatile unsigned int *)reg_addr) |= GPIO_DIR_25TO31_MASK;
	reg_addr = GPIO_OUT_2;
	(*(volatile unsigned int *)reg_addr) |= GPIO_DIR_32TO36N44_MASK;
	wncdebug("0x%08x=0x%08x, 0x%08x=0x%08x,", GPIO_OUT_1, (*(volatile unsigned int *)GPIO_OUT_1), GPIO_OUT_2, (*(volatile unsigned int *)GPIO_OUT_2));
	wncdebug("0x%08x=0x%08x, 0x%08x=0x%08x,", GPIO_DIR_1, (*(volatile unsigned int *)GPIO_DIR_1), GPIO_DIR_2, (*(volatile unsigned int *)GPIO_DIR_2));
	reg_addr = GPIO_DIR_1;
	(*(volatile unsigned int *)reg_addr) |= GPIO_DIR_25TO31_MASK;
	reg_addr = GPIO_DIR_2;
	(*(volatile unsigned int *)reg_addr) |= GPIO_DIR_32TO36N44_MASK;
	wncdebug("0x%08x=0x%08x, 0x%08x=0x%08x,", GPIO_DIR_1, (*(volatile unsigned int *)GPIO_DIR_1), GPIO_DIR_2, (*(volatile unsigned int *)GPIO_DIR_2));
#endif
	return;
}

void do_mfg_led(CLICMD *ptable)
{
	unsigned char *param = NULL;
	int gpio=-1;

	param = get_token();
	wncdebug("%s(): %s\n", __func__, param);
	if (strcmp((char*)param, LED_POWER_G) == 0)
	{
		close_all_leds();
		gpio=GPIO_LED_POWER_G;
		printf("%s should be ON.\n", LED_POWER_G);
	}
	else if (strcmp((char*)param, LED_POWER_R) == 0)
	{
		close_all_leds();
		gpio=GPIO_LED_POWER_R;
		printf("%s should be ON.\n", LED_POWER_R);
	}
	else if (strcmp((char*)param, LED_ACT_G) == 0)
	{
		close_all_leds();
		gpio=GPIO_LED_ACT_G;
		printf("%s should be ON.\n", LED_ACT_G);
	}
	else if (strcmp((char*)param, LED_ACT_R) == 0)
	{
		close_all_leds();
		gpio=GPIO_LED_ACT_R;
		printf("%s should be ON.\n", LED_ACT_R);
	}
	else if (strcmp((char*)param, LED_5G_G) == 0)
	{
		close_all_leds();
		gpio=GPIO_LED_5G_G;
		printf("%s should be ON.\n", LED_5G_G);
	}
	else if (strcmp((char*)param, LED_5G_R) == 0)
	{
		close_all_leds();
		gpio=GPIO_LED_5G_R;
		printf("%s should be ON.\n", LED_5G_R);
	}
	else if (strcmp((char*)param, LED_2G_G) == 0)
	{
		close_all_leds();
		gpio=GPIO_LED_2G_G;
		printf("%s should be ON.\n", LED_2G_G);
	}
	else if (strcmp((char*)param, LED_2G_R) == 0)
	{
		close_all_leds();
		gpio=GPIO_LED_2G_R;
		printf("%s should be ON.\n", LED_2G_R);
	}
	else if (strcmp((char*)param, LED_TV_G) == 0)
	{
		close_all_leds();
		gpio=GPIO_LED_TV_G;
		printf("%s should be ON.\n", LED_TV_G);
	}
	else if (strcmp((char*)param, LED_TV_R) == 0)
	{
		close_all_leds();
		gpio=GPIO_LED_TV_R;
		printf("%s should be ON.\n", LED_TV_R);
	}
	else if (strcmp((char*)param, LED_CNV_G) == 0)
	{
		close_all_leds();
		gpio=GPIO_LED_CNV_G;
		printf("%s should be ON.\n", LED_CNV_G);
	}
	else if (strcmp((char*)param, LED_CNV_R) == 0)
	{
		close_all_leds();
		gpio=GPIO_LED_CNV_R;
		printf("%s should be ON.\n", LED_CNV_R);
	}
	else if (strcmp((char*)param, LED_WANLAN) == 0)
	{
		close_all_leds();
		gpio=GPIO_LED_WAN_LAN;
		printf("%s should be ON.\n", LED_WANLAN);
	}
	else if (strcmp((char*)param, LED_OFF) == 0)
	{
		close_all_leds();
		printf("All LEDs should be OFF!\n");
		return;
	}else
	{
		printf("Wrong Parameter! <Usage> mfg led [powerg | powerr | actg | actr | 5gg | 5gr | 2gg | 2gr | tvg | tvr | cnvg | cnvr | wanlan]\n");
		return;
	}
	wncdebug("gpio=%d(decimal), ", gpio);
#if defined(GPIO_V2) || defined(GPIO_V3)
	setGPIOOutput(gpio, GPIO_VALUE_LOW);
	wncdebug("Output=0x%08x\n", (*(volatile unsigned int *)gpio_output_reg(gpio)));
#else
	setGPIODir(gpio, GPIO_DIR_OUTPUT);
	wncdebug("Dir=0x%08x, ", (*(volatile unsigned int *)gpio_dir_reg(gpio)));
	setGPIOOutput(gpio, GPIO_VALUE_LOW);
	wncdebug("Output=0x%08x\n", (*(volatile unsigned int *)gpio_output_reg(gpio)));
#endif
	return;
}


void do_mfg_nandinfo(CLICMD *ptable)
{
	run_command("nand info", 0);
}


void do_mfg_nandbad(CLICMD *ptable)
{
	run_command("nand bad", 0);
}

void do_mfg_version(CLICMD *ptable)
{
	printf(" Model   : %s (%s)\n Version : %s\n Date    : (%s-%s)\n",PROJECT_ID,PROJECT_NAME,WNC_UBOOT_VERSION,U_BOOT_DATE,U_BOOT_TIME);
	return;
}

int do_mfg (cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	int clicmd_id = 0, i;
	memset(input_buf, 0, MAX_INPUT_LEN);
	input_string=input_buf;
	unsigned char char_space[1];
	char_space[0]=0x20;

	for(i=1;i<argc;i++)
	{
		strcat(input_string, argv[i]);
		#if 1
		strncat(input_string, char_space, 1);
		#else
		strcat(input_string, char_space);
		#endif
	}
	wncdebug("command: %s\n", input_string);
	get_token();
	
	clicmd_id = look_up(token, clicmds);
	if (clicmd_id >= 0)
		clicmds[clicmd_id].function(clicmds[clicmd_id].next_cmd_table);
	else
		printf("Type \"help\" for usage !\n");
	return 0;
}

U_BOOT_CMD(
	mfg,	6,	1,	do_mfg,
	"mfg    - mfg verification commands utility\n",
	"please type help to display the usage!"
);
