/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Configuration for MediaTek MT7629 SoC
 *
 * Copyright (C) 2019 MediaTek Inc.
 * Author: Sam Shih <sam.shih@mediatek.com>
 */

#ifndef __MT7622_H
#define __MT7622_H

#include <linux/sizes.h>

/* SPI Nand */
#if defined(CONFIG_MTK_SPI_NAND)

#define ENV_BOOT_CMD \
	"mtkbootmenu=mtkautoboot\0"

#define ENV_BOOT_MENU \
	"mtkautoboot_type=sb_snand\0"

#define ENV_BOOT_DELAY \
	"bootdelay=0\0"

#define CONFIG_EXTRA_ENV_SETTINGS \
	ENV_BOOT_DELAY \
	ENV_BOOT_MENU \
	ENV_BOOT_CMD \
	"bootcmd=run mtkbootmenu;\0"

#endif

#define CONFIG_SYS_MAXARGS		32
#define CONFIG_SYS_BOOTM_LEN		SZ_64M
#define CONFIG_SYS_CBSIZE		SZ_1K
#define CONFIG_SYS_PBSIZE		(CONFIG_SYS_CBSIZE +	\
					sizeof(CONFIG_SYS_PROMPT) + 16)
/* Size of malloc() pool */
#define CONFIG_SYS_MALLOC_LEN		SZ_4M
#define CONFIG_SYS_NONCACHED_MEMORY	SZ_1M

/* Allow to overwrite serial and ethaddr */
#define CONFIG_ENV_OVERWRITE

#define CONFIG_SYS_MMC_ENV_DEV 0

/* Uboot definition */
#define CONFIG_SYS_UBOOT_BASE                   CONFIG_SYS_TEXT_BASE

/* SPL -> Uboot */
#define CONFIG_SYS_UBOOT_START		CONFIG_SYS_TEXT_BASE
#define CONFIG_SYS_INIT_SP_ADDR		(CONFIG_SYS_TEXT_BASE + SZ_2M - \
					 GENERATED_GBL_DATA_SIZE)
/* UBoot -> Kernel */
#define CONFIG_LOADADDR		        0x4007ff28
#define CONFIG_SYS_LOAD_ADDR		CONFIG_LOADADDR

/* DRAM */
#define CONFIG_SYS_SDRAM_BASE		0x40000000

/* Ethernet */
#define CONFIG_IPADDR			192.168.1.1
#define CONFIG_SERVERIP			192.168.1.254
#define CONFIG_HAS_ETH0
#endif
