/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2020 MediaTek Inc. All Rights Reserved.
 *
 * Author: Weijie Gao <weijie.gao@mediatek.com>
 */

#ifndef _MTK_ECC_H_
#define _MTK_ECC_H_

#include <linux/types.h>

int mtk_ecc_config(struct udevice *dev, u32 writesize, u32 oobsize);
int mtk_ecc_decode_page(struct udevice *dev, void *data, bool ecc_on);
int mtk_ecc_encode_page(struct udevice *dev, void *data, bool ecc_on);

int mtk_ecc_ooblayout_free(struct udevice *dev, int section, uint32_t *offset,
			   uint32_t *length);
int mtk_ecc_ooblayout_ecc(struct udevice *dev, int section, uint32_t *offset,
			  uint32_t *length);

#endif /* _MTK_ECC_H_ */
