/* 
* (C) Copyright 2020~2021
* Implement for NEC Soleil(RVRM-NH1)
* David@D4R130.WNC
* version: 
*/

#ifndef _WNC_CONFIG_H
#define _WNC_CONFIG_H
#define GPIO_V3//for ES2 on 20201015
//#define GPIO_V2//for rework after ES1-1
//#define WNC_DEBUG_FLAG
#ifdef WNC_DEBUG_FLAG
#define wncdebug(fmt, args...)	printf("[WNC]"fmt, ##args)
#else
#define wncdebug(fmt, args...)
#endif
#define PROJECT_ID						"RVRM-NH1"
#define PROJECT_NAME					"Soleil"
#define WNC_UBOOT_VERSION				"v0.3"//v0.1 for ES1, v0.2 for ES2, v0.3 for ES3
/*WNC uboot version: 
v0.1.0, 20200721, cmd_mem, cmd_mfg prototype, partition layout, bootmenu changed for preburn for ES1-1
v0.1, 20200803, add btn,led,pkgid, slide_switch test based on Soleil_GPIO_Rev1.0.xlsx for for ES1-1 build
v0.2, 20201015, for ES2 build, GPIO flag is GPIO_V3.
v0.3, 20201104, for ES3 build.
*/
#ifdef GPIO_V3
#define MFG_SUBVERSION					"03"
#define SOLEIL_GPIO_DEFINITION_DOC		"(NOT_PROVIDED_YET)"
#else
//#ifdef GPIO_V2
#define MFG_SUBVERSION					"02"
#define SOLEIL_GPIO_DEFINITION_DOC		"Soleil_GPIO_Rev2.0_0720.xlsx"
//#elseif //GPIO_V1
#define MFG_SUBVERSION					"01"
#define SOLEIL_GPIO_DEFINITION_DOC		"Soleil_GPIO_Rev1.0.xlsx"
#endif
/* cmd_mfg version: 
01, 20200803, implemeted led, btn, slide switch, pkgid check based on Soleil_GPIO_Rev1.0.xlsx for ES1-1 build
                    but this is an emergent version to support HW verify in ES1-1 build. 
                    We will implement it in kernel phase in the later phase.
02, 20200815, add GPIO initialization and update mfg cmds based on Soleil_GPIO_Rev2.0_0720.xlsx
03, 20201016, change the GPIO based on ES2 & ES3 design change
*/

/*Memory test*/
/* The Memory used in Soleil is W634GU6NB 32M * 8Banks * 16 width = 512MB
|-----------------------------------------------------------------------|
| Name				|	Start Address	|	Size (MBytes)						|
|-----------------------------------------------------------------------|
| EMI (Legacy mode)	| 0x40000000		| 	256								|
|					| 0x50000000		| 	256								|
|					| 0x60000000		| 	256								|
|					| 0x70000000		|	256								|
| EMI (2GB mode)		| 0x80000000		| 	256								|
| 					| 0x90000000		|	256								|
| 					| 0xA0000000		| 	256								|
| 					| 0xB0000000		| 	256                                               |
|-----------------------------------------------------------------------|
*/
#define READ_MEM32(addr)         		(*(volatile unsigned int *) (addr))
#define MEM_TEST_DEFAULT_ADDR			0x41000000
#define MEM_BASE_ADDR					0x40000000
#define MEM_HALF_ADDR					0x50000000
#define MEM_END_ADDR					0x5FFFFFFF
#define MEM_TEST_DEFAULT_SIZE			0x60000		// 384 KB ==> test in 3 seconds
#define MEM_TOTAL_SIZE					0x20000000	// 2 GB

enum {
	MEM_TEST_PATTERN0=0x00000000UL,
	MEM_TEST_PATTERN1=0xffffffffUL,
	MEM_TEST_PATTERN2=0x55555555UL,
	MEM_TEST_PATTERN3=0xaaaaaaaaUL,
	MEM_TEST_PATTERN4=0x33333333UL,
	MEM_TEST_PATTERN5=0xccccccccUL,
	MEM_TEST_PATTERN6=0x0f0f0f0fUL,
	MEM_TEST_PATTERN7=0xf0f0f0f0UL,
	MEM_TEST_PATTERN8=0xff00ff00UL,
	MEM_TEST_PATTERN9=0x00ff00ffUL,
	MEM_TEST_PATTERN_MAX=10,
};

enum{
	MEM_TEST_SIZE_4M=0,//4M
	MEM_TEST_SIZE64M=1,//64M
	MEM_TEST_SIZE128M=2,//128M
	MEM_TEST_SIZE256M=3,//256M
};

enum{
	FALSE_VALUE=0,
	TRUE_VALUE=1,
};

/*GPIO related things*/
//Input signal for Model Name identification
#define INPUT_PKGID_0				"pkgid0"//40
#define INPUT_PKGID_1				"pkgid1"//41
#define INPUT_PKGID_2				"pkgid2"//42
//Buttons
#define BUTTON_MAINTENANCE_SW		"mainten"//95
#define BUTTON_RESET_SW				"reset"//96
#define BUTTON_MODE_SW_1			"modesw1"//97
#define BUTTON_MODE_SW_2			"modesw2"//98
#define BUTTON_WIRELESS_SW			"wifisw"//102
//LEDs
#define LED_POWER_G					"powerg"//25
#define LED_POWER_R					"powerr"//26
#define LED_ACT_G					"actg"//27
#define LED_ACT_R					"actr"//28
#define LED_5G_G					"5gg"//29
#define LED_5G_R					"5gr"//30
#define LED_2G_G					"2gg"//31
#define LED_2G_R					"2gr"//32
#define LED_TV_G					"tvg"//33
#define LED_TV_R					"tvr"//34
#define LED_CNV_G					"cnvg"//35
#define LED_CNV_R					"cnvr"//36
#define LED_WANLAN					"wanlan"//44
#define LED_OFF						"off"

#define PARTITION_OFFSET_FACTORY	0x1c0000
#define PARTITION_LENGTH_FACTORY	0x040000
#define CMD_PARTITION_ERASE 		"nand erase 0x%x 0x%x"//nand erase 0x1c0000 0x040000
#define GPIO_TOTAL_NO				103//MT7622 GPIOs: 0~102
#define GPIO_NO_MIN					0
#define GPIO_NO_MAX					(GPIO_TOTAL_NO - 1)


/* GPIO related definition */
enum GPIO_value
{
	GPIO_VALUE_LOW=0,
	GPIO_VALUE_HIGH=1,
};
enum GPIO_direction
{
	GPIO_DIR_INPUT=0,
	GPIO_DIR_OUTPUT=1,
};

//GPIO bits mask
#ifdef GPIO_V3
#define GPIO_INT_N_211_RTL8221				22//to RTL8221 INTB pin, as Interrupt from RTL8221 to MT7622, so this is INPUT to CPU
#define GPIO_MDC							23
#define GPIO_MDIO							24
#define GPIO_LED_ACT_G						91//25//G2_TXD0
#define GPIO_LED_POWER_G					92//27//G2_TXD2
#define GPIO_LED_POWER_R					93//26//G2_TXD1
#define GPIO_LED_ACT_R						99//28//G2_TXD3
#define GPIO_LED_5G_G						31//100//29//G2_TXEN
#define GPIO_LED_5G_R						32//86//30//G2_TXC
#define GPIO_LED_2G_G						100//31//G2_RXD0
#define GPIO_LED_2G_R						86//32//G2_RXD1
#define GPIO_LED_TV_G						33//G2_RXD2
#define GPIO_LED_TV_R						34//G2_RXD3
#define GPIO_LED_CNV_G						35//G2_RXDV
#define GPIO_LED_CNV_R						94//36//G2_RXC
#define GPIO_PKGID_0						40//NDL4
#define GPIO_PKGID_1						41//NDL5
#define GPIO_PKGID_2						42//NDL6
#define GPIO_LED_WAN_LAN					36//44//NRB
#define GPIO_WATCHDOG						78//WATCHDOG
#define GPIO_MAINTAIN_SW					95//PWM1
#define GPIO_RESET_SW						96//PWM2
#define GPIO_MODE_SW_1						97//PWM3
#define GPIO_MODE_SW_2						98//PWM4
#define GPIO_WF_SW							102//GPIO_E
#define GPIO_MASK_OUT_HIGH_99TO100			0x00000018//mw 0x10211130 0x00000018, GPIO_OUT_4, LEDs 99,100 Off
#define GPIO_MASK_OUT_HIGH_86_91TO94		0x78400000//mw 0x10211120 0x78400000, GPIO_DIR_3, LEDs 86,91~94 Off
#define GPIO_MASK_OUT_HIGH_86_919394		0x68400000//mw 0x10211120 0x78400000, GPIO_OUT_3, LEDs 86,91,93,94 Off but keep POWER_G On
#define GPIO_MASK_OUT_HIGH_32TO36			0x0000001f//mw 0x10211110 0x0000001f, GPIO_OUT_2, LEDs 32~36 Off
#define GPIO_MASK_OUT_HIGH_31				0x80000000//mw 0x10211100 0x80000000, GPIO_OUT_1, LEDs 31 Off
#define GPIO_MASK_DIR_OUT_99TO100			0x00000018//mw 0x10211030 0x00000018, GPIO_DIR_4, LEDs 99,100 Output
#define GPIO_MASK_DIR_OUT_86_91TO_94		0x78400000//mw 0x10211020 0x78403800, GPIO_DIR_3, LEDs 86,91~94 Output
#define GPIO_MASK_DIR_OUT_32TO36			0x0000001f//mw 0x10211010 0x0000001f, GPIO_DIR_2, LED 32~36 Output
#define GPIO_MASK_DIR_OUT_31				0x80000000//mw 0x10211000 0x80000000, GPIO_DIR_1, LED 31 Output
#define GPIO_CMD_MODE_91TO94_98TO100		"mw 0x10211390 0x11117111"
#define GPIO_CMD_MODE_31TO36_40TO_42		"mw 0x10211300 0x00101200"
#define GPIO_CMD_MODE_95TO97				"mw 0x10211380 0x11130000"
#define GPIO_CMD_MODE_86_102				"mw 0x10211360 0x00000101"
#define GPIO_MASK_DIR_IN_40TO42				0x00000700//mw 0x10211010 0x00000700 => [8:10] bits must be 0
#define GPIO_MASK_DIR_IN_95					0x80000000//mw 0x10211020 0x80000000 => [31] bit must be 0
#define GPIO_MASK_DIR_IN_96TO98_102			0x00000047//mw 0x10211030 0x00000007 => [0:2, 6] bits must be 0
#else
//#ifdef GPIO_V2//GPIO definition -- according to Soleil_GPIO_Rev2.0_0720.xlsx on 0804
#define GPIO_MDC							23
#define GPIO_MDIO							24
#define GPIO_LED_POWER_G					91//25//G2_TXD0
#define GPIO_LED_POWER_R					93//26//G2_TXD1
#define GPIO_LED_ACT_G						92//27//G2_TXD2
#define GPIO_LED_ACT_R						99//28//G2_TXD3
#define GPIO_LED_5G_G						100//29//G2_TXEN
#define GPIO_LED_5G_R						86//30//G2_TXC
#define GPIO_LED_2G_G						31//G2_RXD0
#define GPIO_LED_2G_R						32//G2_RXD1
#define GPIO_LED_TV_G						33//G2_RXD2
#define GPIO_LED_TV_R						34//G2_RXD3
#define GPIO_LED_CNV_G						35//G2_RXDV
#define GPIO_LED_CNV_R						94//36//G2_RXC
#define GPIO_PKGID_0						40//NDL4
#define GPIO_PKGID_1						41//NDL5
#define GPIO_PKGID_2						42//NDL6
#define GPIO_LED_WAN_LAN					36//44//NRB
#define GPIO_WATCHDOG						78//WATCHDOG
#define GPIO_MAINTAIN_SW					95//PWM1
#define GPIO_RESET_SW						96//PWM2
#define GPIO_MODE_SW_1						97//PWM3
#define GPIO_MODE_SW_2						98//PWM4
#define GPIO_WF_SW							102//GPIO_E
#define GPIO_MASK_OUT_HIGH_99TO100			0x00000018//mw 0x10211130 0x00000018, GPIO_DIR_4, LEDs 99,100 Off
#define GPIO_MASK_OUT_HIGH_86_91TO94		0x78400000//mw 0x10211120 0x78400000, GPIO_DIR_3, LEDs 86,91~94 Off
#define GPIO_MASK_OUT_HIGH_32TO36			0x0000001f//mw 0x10211110 0x0000001f, GPIO_DIR_2, LEDs 32~36 Off
#define GPIO_MASK_OUT_HIGH_31				0x80000000//mw 0x10211100 0x80000000, GPIO_DIR_1, LEDs 31 Off
#define GPIO_MASK_DIR_OUT_99TO100			0x00000018//mw 0x10211030 0x00000018, GPIO_OUT_4, LEDs 99,100 Output
#define GPIO_MASK_DIR_OUT_86_91TO_94		0x78400000//mw 0x10211020 0x78403800, GPIO_OUT_3, LEDs 86,91~94 Output
#define GPIO_MASK_DIR_OUT_32TO36			0x0000001f//mw 0x10211010 0x0000001f, GPIO_OUT_2, LED 32~36 Output
#define GPIO_MASK_DIR_OUT_31				0x80000000//mw 0x10211000 0x80000000, GPIO_OUT_1, LED 31 Output
#define GPIO_CMD_MODE_91TO94_98TO100		"mw 0x10211390 0x11117111"
#define GPIO_CMD_MODE_31TO36_40TO_42		"mw 0x10211300 0x00101200"
#define GPIO_CMD_MODE_95TO97				"mw 0x10211380 0x11130000"
#define GPIO_CMD_MODE_86_102				"mw 0x10211360 0x00000101"
#define GPIO_MASK_DIR_IN_40TO42				0x00000700//mw 0x10211010 0x00000700 => [8:10] bits must be 0
#define GPIO_MASK_DIR_IN_95					0x80000000//mw 0x10211020 0x80000000 => [31] bit must be 0
#define GPIO_MASK_DIR_IN_96TO98_102			0x00000047//mw 0x10211030 0x00000007 => [0:2, 6] bits must be 0
//#else//GPIO definition -- according to Soleil_GPIO_Rev1.0.xlsx, 20200616
#define GPIO_MDC							23
#define GPIO_MDIO							24
#define GPIO_LED_POWER_G					25//G2_TXD0
#define GPIO_LED_POWER_R					26//G2_TXD1
#define GPIO_LED_ACT_G						27//G2_TXD2
#define GPIO_LED_ACT_R						28//G2_TXD3
#define GPIO_LED_5G_G						29//G2_TXEN
#define GPIO_LED_5G_R						30//G2_TXC
#define GPIO_LED_2G_G						31//G2_RXD0
#define GPIO_LED_2G_R						32//G2_RXD1
#define GPIO_LED_TV_G						33//G2_RXD2
#define GPIO_LED_TV_R						34//G2_RXD3
#define GPIO_LED_CNV_G						35//G2_RXDV
#define GPIO_LED_CNV_R						36//G2_RXC
#define GPIO_PKGID_0						40//NDL4
#define GPIO_PKGID_1						41//NDL5
#define GPIO_PKGID_2						42//NDL6
#define GPIO_LED_WAN_LAN					44//NRB
#define GPIO_WATCHDOG						78//WATCHDOG
#define GPIO_MAINTAIN_SW					95//PWM1
#define GPIO_RESET_SW						96//PWM2
#define GPIO_MODE_SW_1						97//PWM3
#define GPIO_MODE_SW_2						98//PWM4
#define GPIO_WF_SW							102//GPIO_E
#define GPIO_DIR_25TO31_MASK				0xFE000000//same to Output Register as LED OFF
#define GPIO_DIR_32TO36N44_MASK				0x0000101F//same to Output Register as LED OFF
#endif

//GPIO base addresses -- Please refer to ch6.7.4 in MT7622 Reference Manual.pdf 
//PS1: The naming of these pins in MT7622 design is too terrible ...
//PS2: Can't find the setting to be used as normal GPIO for GPIO 14,15,83,84 in mode registers ?
#define GPIO_DIR_1							0x10211000//[0:31] GPIO_0 ~ GPIO_31. 0: Input, 1: output
#define GPIO_DIR_2							0x10211010//[0:31] GPIO_32 ~ GPIO_63. 0: Input, 1: output
#define GPIO_DIR_3							0x10211020//[0:31] GPIO_64 ~ GPIO_95. 0: Input, 1: output
#define GPIO_DIR_4							0x10211030//[0:31] GPIO_96 ~ GPIO_127. 0: Input, 1: output
#define GPIO_REG_BASE_DIR					GPIO_DIR_1
#define GPIO_OUT_1							0x10211100//[0:31] GPIO_0 ~ GPIO_31
#define GPIO_OUT_2							0x10211110//[0:31] GPIO_32 ~ GPIO_63
#define GPIO_OUT_3							0x10211120//[0:31] GPIO_64 ~ GPIO_95
#define GPIO_OUT_4							0x10211130//[0:31] GPIO_96 ~ GPIO_127
#define GPIO_REG_BASE_OUT					GPIO_OUT_1
#define GPIO_IN_1							0x10211200//[0:31] GPIO_0 ~ GPIO_31
#define GPIO_IN_2							0x10211210//[0:31] GPIO_32 ~ GPIO_63
#define GPIO_IN_3							0x10211220//[0:31] GPIO_64 ~ GPIO_95
#define GPIO_IN_4							0x10211230//[0:31] GPIO_96 ~ GPIO_127
#define GPIO_REG_BASE_IN					GPIO_IN_1
#define GPIO_MODE_0							0x10211300
/* GPIO_MODE_0: GPIO Mode Control Register 0
[00:03] RSV0,		Reserved.
[04:07] UARTo,	0: UART, 		1: GPIO 6~7, 		2~7: Reserved.
[08:11] SPI,		0: SPI NOR Flash, 	1: GPIO 10~13, 	2: SPI NAND Flash,	3~7: Reserved.
[12:15] RGMII,	0: RGMII(GMAC2), 	1: GPIO 25~36, 	2: SDXC, 		3~7: Reserved.
[16:19] PMIC,		0: PMIC I2C, 		1: GPIO 71~72, 	2~7: Reserved.
[20:23] NAND, 	0: ParaNAND flash,	1: GPIO 37~50,	2: EMMC,			3~7: Reserved.
[24:27] MDIO,		0: MDIO,			1: GPIO 23~24, 	2~7: Reserved.
[28:31] RSV1,		Reserved.
*/
#define GPIO_MODE_1							0x10211310
/* GPIO_MODE_1: GPIO Mode Control Register 1
[00:03] GPIO73,	0: SPIC1_CLK,		1: GPIO 73,		2: UART_TXD1, 	3: I2C1_SCL,	4: PWM_CH1, 5: ANTSEL[12], 6: Reserved, 	7: DBG_UTIF[0]
[04:07] GPIO74,	0: SPIC1_MOSI,	1: GPIO 74,		2: UART_RXD1, 	3: I2C1_SDA,	4: PWM_CH2, 5: ANTSEL[13], 6: Reserved, 	7: DBG_UTIF[1]
[08:11] GPIO75,	0: SPIC1_MISO,	1: GPIO 75,		2: UART_RTS1, 	3: I2C2_SCL,	4: PWM_CH3, 5: ANTSEL[14], 6: Reserved, 	7: DBG_UTIF[2]
[12:15] GPIO76,	0: SPIC1_CS,		1: GPIO 76,		2: UART_CTS1, 	3: I2C2_SDA,	4: PWM_CH4, 5: ANTSEL[15], 6: Reserved, 	7: DBG_UTIF[3]
[16:19] GPIO18,	0: I2S4_IN,		1: GPIO 18,		2: SD_D1, 		3: Reserved,	4: Reserved, 	5: ANTSEL[26], 6: BT_ERX_EN, 	7: DBG_UTIF[12]
[20:23] GPIO19,	0: I2S2_OUT,		1: GPIO 19,		2: SD_D0,	 	3: Reserved,	4: Reserved, 	5: ANTSEL[27], 6: BT_IPATH_EN,	7: DBG_UTIF[13]
[24:27] GPIO20,	0: I2S3_OUT,		1: GPIO 20,		2: SD_CLK, 		3: Reserved,	4: Reserved, 	5: ANTSEL[28], 6: BT_SPXT_C1, 	7: DBG_UTIF[14]
[28:31] GPIO21,	0: I2S4_OUT,		1: GPIO 21,		2: SD_CMD, 		3: Reserved,	4: Reserved, 	5: ANTSEL[29], 6: BT_SPXT_C0, 	7: DBG_UTIF[15]
*/
#define GPIO_MODE_2							0x10211320
/* GPIO_MODE_2: GPIO Mode Control Register 2
[00:03] GPIO5,	0: I2S_MCLK,		1: GPIO 5, 		2~6: Reserved, 7: DBG_UTIF[17]
[04:07] GPIO34,	0: I2C0_SDA,		1: GPIO 34, 		2: PCIE0_PAD_WAKE, 	3: PCIE1_PAD_WAKE, 	4: Reserved, 5: ANTSEL[22], 6: Reserved, 7: EXT_BGCK
[08:11] GPIO35,	0: I2C0_SCL,		1: GPIO 35, 		2: PCIE0_PAD_CLKREQ, 3: PCIE2_PAD_CLKREQ, 	4: Reserved, 5: ANTSEL[23], 6: Reserved, 7: Reserved
[12:15] GPIO78, 	0: WATCHDOG,	1: GPIO 78,		2: Reserved, 		3: Reserved,	4: PWM_CH6,	5: Reserved, 	  6: Reserved, 	7: DBG_UTIF[5]
[16:19] GPIO0,	0: GPIO_A,		1: GPIO 0,		2~7: Reserved.
[20:23] GPIO16,	0: I2S2_IN,		1: GPIO 16,		2: SD_D3, 		3: Reserved, 	4: IR_T,		5: ANTSEL[24], 6: BT_EPA_EN, 	7: DBG_UTIF[10]
[24:27] GPIO17,	0: I2S3_IN,		1: GPIO 17,		2: SD_D2,		3: Reserved, 	4: IR_R,		5: ANTSEL[25], 6: BT_ELNA_EN,	7: DBG_UTIF[11]
[28:31] GPIO77,	0: GPIO_D,		1: GPIO 77,		2: Reserved, 		3: Reserved,	4: PWM_CH5,	5: ANTSEL[16], 6: Reserved,	7: DBG_UTIF[4]
*/
#define GPIO_MODE_3							0x10211330
/* GPIO_MODE_3: GPIO Mode Control Register 3
[00:03] GPIO84,	0: PCIE1_PAD_PERST,	1: GPIO 84, 	2~7: Reserved
[04:07] GPIO51,	0: UART_TXD2,	1: GPIO 51,		2: Reserved, 		3: PWM_CH1,			4~7: Reserved
[08:11] GPIO52, 	0: UART_RXD2,	1: GPIO 52,		2: Reserved, 		3: PWM_CH2,			4~7: Reserved
[12:15] GPIO53,	0: UART_RTS2,	1: GPIO 53, 		2: Reserved, 		3: PWM_CH3,			4~7: Reserved
[16:19] GPIO54,	0: UART_CTS2,	1: GPIO 54, 		2: Reserved, 		3: PWM_CH4,			4~7: Reserved
[20:23] GPIO55,	0: I2C1_SCL,		1: GPIO 55, 		2: UART_TXD1, 	3: TDM_OUT_DATA,	4~7: Reserved
[24:27] GPIO56,	0: I2C1_SDA,		1: GPIO 56, 		2: UART_RXD1, 	3: TDM_IN_DATA,		4~7: Reserved
[28:31] GPIO57,	0: I2C2_SCL,		1: GPIO 57, 		2: UART_RTS1, 	3: TDM_OUT_MCLK,	4~7: Reserved
*/
#define GPIO_MODE_4							0x10211340
/* GPIO_MODE_4: GPIO Mode Control Register 4
[00:03] GPIO58,	0: I2C2_SDA,		1: GPIO 58, 		2: UART_CTS1, 	3: TDM_OUT_BCLK,	4~7: Reserved
[04:07] GPIO59,	0: ESW_TXD0,	1: GPIO 59, 		2: G1_TXD0, 		3: TDM_OUT_WS,		4: UART_TXD2, 	5: IR_T,			6~7: Reserved
[08:11] GPIO60,	0: ESW_TXD1,	1: GPIO 60, 		2: G1_TXD1, 		3: TDM_IN_MCLK,		4: UART_RXD2, 	5: IR_R,			6~7: Reserved
[12:15] GPIO61,	0: ESW_TXD2,	1: GPIO 61, 		2: G1_TXD2, 		3: TDM_IN_BCLK,		4: UART_RTS2_N, 	5: UART_TXD4,	6~7: Reserved
[16:19] GPIO62,	0: ESW_TXD3,	1: GPIO 62, 		2: G1_TXD3, 		3: TDM_IN_WS,		4: UART_CTS2_N, 	5: UART_RXD4,	6~7: Reserved
[20:23] GPIO63,	0: ESW_TXEN,	1: GPIO 63, 		2: G1_TXEN, 		3: Reserved,			4: SPIC0_CLK, 	5~7: Reserved
[24:27] GPIO64,	0: ESW_TXC,		1: GPIO 64, 		2: G1_TXC, 		3: Reserved,			4: SPIC0_MOSI, 	5~7: Reserved
[28:31] GPIO65,	0: ESW_RXD0,	1: GPIO 65, 		2: G1_RXD0, 		3: Reserved,			4: SPIC0_MISO, 	5~7: Reserved
*/
#define GPIO_MODE_5							0x10211350
/* GPIO_MODE_5: GPIO Mode Control Register 5
[00:03] GPIO66,	0: ESW_RXD1,	1: GPIO 66, 		2: G1_RXD1,		3: Reserved,			4: SPIC0_CS,		5~7: Reserved
[04:07] GPIO67,	0: ESW_RXD2,	1: GPIO 67, 		2: G1_RXD2,		3: PWM_CH4,			4: SPIC1_CLK,		5~7: Reserved
[08:11] GPIO68,	0: ESW_RXD3,	1: GPIO 68, 		2: G1_RXD3,		3: PWM_CH5,			4: SPIC1_MOSI,	5~7: Reserved
[12:15] GPIO69,	0: ESW_RXDV,	1: GPIO 69, 		2: G1_RXDV,		3: PWM_CH6,			4: SPIC1_MISO,	5~7: Reserved
[16:19] GPIO70,	0: ESW_RXC,		1: GPIO 70, 		2: G1_RXCV,		3: PWM_CH7,			4: SPIC1_CS,		5~7: Reserved
[20:23] GPIO8,	0: SPI_WP,		1: GPIO 8, 		2: SNFI_WP,		3: TDM_OUT_MCLK,	4~5: Reserved,	6: FPC_DAT_STS,	7: Reserved
[24:27] GPIO9,	0: SPI_HOLD,		1: GPIO 9, 		2: SNFI_HOLD,	3: TDM_OUT_BCLK,	4~5: Reserved,	6: FPC_DL_STS,	7: Reserved
[28:31] GPIO83,	0: pCIE0_PAD_PERST,	1: GPIO 83, 		2~7: Reserved
*/
#define GPIO_MODE_6							0x10211360
/* GPIO_MODE_6: GPIO Mode Control Register 6
[00:03] GPIO102,	0: GPIO_E,		1: GPIO 102,		2~5: Reserved,	6: ANTSEL11,			7: FPC_DATA7
[04:07] GPIO85,	0: WLED_N,		1: GPIO 85,		2~7: Reserved
[08:11] GPIO86,	0: EPHY_LED0_N,	1: GPIO 86,		2~3: Reserved,	4: CPUM_HW_SEL,		5: Reserved, 		6: FPC_CTL0,		7: JTRST_N
[12:15] GPIO87,	0: I2C1_SCL,		1: GPIO 87,		2~7: Reserved
[16:19] GPIO88,	0: I2C1_SDA,		1: GPIO 88,		2~7: Reserved
[20:23] GPIO89,	0: I2C2_SCL,		1: GPIO 89,		2~7: Reserved,
[24:27] GPIO90,	0: I2C2_SDA,		1: GPIO 90,		2~7: Reserved,
[28:31] RESV,		Reserved
*/
#define GPIO_MODE_7							0x10211370
/* GPIO_MODE_7: GPIO Mode Control Register 7
[00:03] RESV,		Reserved
[04:07] RESV,		Reserved
[08:11] RESV,		Reserved
[12:15] RESV,		Reserved
[16:19] RESV,		Reserved
[20:23] RESV,		Reserved
[24:27] RESV,		Reserved
[28:31] RESV,		Reserved
*/
#define GPIO_MODE_8							0x10211380
/* GPIO_MODE_8: GPIO Mode Control Register 8
[00:03] RESV,		Reserved
[04:07] RESV,		Reserved
[08:11] RESV,		Reserved
[12:15] RESV,		Reserved
[16:19] GPIO22,	0: GPIO_B,		1: GPIO 22,		2: Reserved, 		3: TSF_INTR,			4: Reserved, 		5: Reserved,		6: ANTSEL17,		7: DBG_UTIF16
[20:23] GPIO95,	0: PWM_CH1,		1: GPIO 95, 		2: UART_RTS4,	3: UART_TXD2, 		4: CPUM3,		5: ANTSEL4,		6: FPC_DATA0,	7: W_DBGIN
[24:27] GPIO96,	0: PWM_CH2,		1: GPIO 96,		2: UART_CTS4,	3: UART_RXD2,		4: CPUM_CK_XI,	5: ANTSEL5,		6: FPC_DATA1, 	7: W_DBGACK
[28:31] GPIO97,	0: PWM_CH3,		1: GPIO 97,		2: UART_TXD4,	3: Reserved,			4: AICE_TCKC,	5: ANTSEL6,		6: FPC_DATA2,	7: W_JTCLK
*/
#define GPIO_MODE_9							0x10211390
/* GPIO_MODE_9: GPIO Mode Control Register 9
[00:03] GPIO98,	0: PWM_CH4,		1: GPIO 98,		2: UART_RXD4,	3: Reserved,			4: Reserved,		5: ANTSEL7,		6:FPC_DATA3,	7: W_JTDI
[04:07] GPIO99,	0: PWM_CH5,		1: GPIO 99,		2: Reserved,		3: IR_T,				4: AICE_TMSC,	5: ANTSEL8,		6:FPC_DATA4,	7: W_JTMS
[08:11] GPIO100,	0: PWM_CH6,		1: GPIO 100,		2: Reserved,		3: IR_R,				4: Reserved,		5: ANTSEL9,		6:FPC_DATA5,	7: W_JTRST_N
[12:15] GPIO101,	0: PWM_CH7,		1: GPIO 101,		2: Reserved,		3: Reserved,			4: Reserved,		5: ANTSEL10,		6:FPC_DATA6,	7: DBG_UART_TXD
[16:19] GPIO91,	0: UART_TXD4,	1: GPIO 91,		2: EPHY_LED1_N,	3: DFD_TDI,			4: CPUM_2B_SEL,	5: ANTSEL0,		6:FPC_CK_XI,		7: JTDI
[20:23] GPIO92,	0: UART_RXD4,	1: GPIO 92,		2: EPHY_LED2_N,	3: DFD_TDO,			4: CPUM0,		5: ANTSEL1,		6:FPC_CLT1,		7: W_JTDO
[24:27] GPIO93,	0: UART_RTS4,	1: GPIO 93,		2: EPHY_LED3_N,	3: DFD_TCK,			4: CPUM1,		5: ANTSEL2,		6:FPC_CTL2,		7: JTCLK
[28:31] GPIO94,	0: UART_CTS4,	1: GPIO 94,		2: EPHY_LED4_N,	3: DFD_TMS,			4: CPUM1,		5: ANTSEL2,		6:FPC_CTL2,		7: JTCLK
*/
#define GPIO_MODE_10						0x102113A0
/* GPIO_MODE_10: GPIO Mode Control Register 10
[00:03] GPIO79,	0: UART_RTS3,	1: GPIO 79,		2: Reserved,		3: SPIC0_MISO,	4: PCIE0_PAD_WAKE,	5: ANTSEL18,		6: Reserved, 		7: DBG_UTIF6
[04:07] GPIO80,	0: UART_CTS3,	1: GPIO 80,		2: Reserved,		3: SPIC0_CS,		4: PCIE0_PAD_CLKREQ,	5: ANTSEL19,		6: Reserved, 		7: DBG_UTIF7
[08:11] GPIO81,	0: UART_TXD3,	1: GPIO 81,		2: SPDIF_T,		3: SPIC0_CLK,		4: PWM_CH6,			5: ANTSEL20,		6: Reserved, 		7: DBG_UTIF8
[12:15] GPIO82,	0: UART_RXD3,	1: GPIO 82,		2: SPDIF_R,		3: SPIC0_MOSI,	4: PWM_CH7,			5: ANTSEL21,		6: Reserved, 		7: DBG_UTIF9
[16:19] GPIO1,	0: I2S1_IN,		1: GPIO 1,		2: UART_RTS2_N,	3~7: Reserved
[20:23] GPIO2,	0: I2S1_OUT,		1: GPIO 2,		2: UART_CTS2_N,	3~7: Reserved
[24:27] GPIO3,	0: I2S_BCLK_OUT,	1: GPIO 3,		2: I2S_BCLK_IN,	3: I2S_BCLK_IN,	4~7: Reserved
[28:31] GPIO4,	0: I2S_WS_OUT,	1: GPIO 4,		2: UART_RXD2,	3: I2S_WS_IN,	4~7: Reserved
*/
#define gpio_dir_reg(a)					(GPIO_REG_BASE_DIR+(0x10*(a/32)))
#define gpio_output_reg(a)				(GPIO_REG_BASE_OUT+(0x10*(a/32)))
#define gpio_input_reg(a)				(GPIO_REG_BASE_IN+(0x10*(a/32)))
#define readGPIODir(gpio)						\
	do {										\
		printf("0x%01x", (((*(volatile unsigned int *)gpio_dir_reg(gpio))>>(gpio%32)) & 0x1));	\
	}while(0)
#define setGPIODir(gpio, direction)											\
	do {																			\
		if(direction == GPIO_DIR_INPUT)												\
		{																			\
			(*(volatile unsigned int *)gpio_dir_reg(gpio)) &= (~(0x1 << ((gpio%32))));	\
		}else if(direction == GPIO_DIR_OUTPUT)										\
		{																			\
			(*(volatile unsigned int *)gpio_dir_reg(gpio)) |= (0x1 << ((gpio%32)));	\
		}																			\
	}while(0)
#define readGPIOOutput(gpio)						\
	do {										\
		printf("0x%01x", (((*(volatile unsigned int *)gpio_output_reg(gpio))>>(gpio%32)) & 0x1));	\
	}while(0)
#define setGPIOOutput(gpio, value)																		\
	do {																								\
		if(value == GPIO_VALUE_LOW) 																	\
		{																								\
			(*(volatile unsigned int *)gpio_output_reg(gpio)) &= (~(0x1 << ((gpio%32))));	\
		}else if(value == GPIO_VALUE_HIGH)																\
		{																								\
			(*(volatile unsigned int *)gpio_output_reg(gpio)) |= (0x1 << ((gpio%32)));	\
		}																								\
	}while(0)
#define readGPIOInput(gpio)											\		\
	do {																\
		printf("0x%01x", (((*(volatile unsigned int *)gpio_input_reg(gpio))>>(gpio%32)) & 0x1));	\
	}while(0)
//Since there is no common rule among the mode registers, we directly modify it in the functions.
#endif  /* _WNC_CONFIG_H */
