/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2021 MediaTek Inc. All Rights Reserved.
 *
 * Author: Weijie Gao <weijie.gao@mediatek.com>
 *
 * OpenWrt UBI image upgrading & booting helper
 */

#ifndef _UBI_HELPER_H_
#define _UBI_HELPER_H_

void ubi_probe_mtd_devices(void);
#ifdef CONFIG_DUAL_IMAGE
int ubi_upgrade_image(const void *data, size_t size, int bank);
#else
int ubi_upgrade_image(const void *data, size_t size);
#endif
#ifdef CONFIG_DUAL_IMAGE
int ubi_boot_image(int bank);
#else
int ubi_boot_image(void);
#endif
int write_part(const char *partname, const void *data, size_t size, bool verify);

#endif /* _UBI_HELPER_H_ */
