/*
 * Copyright (c) 2021, ARM Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef APUPWR_CLKCTL_DEF_H
#define APUPWR_CLKCTL_DEF_H

#include <lib/mmio.h>

enum dvfs_voltage_domain {
	V_VPU0			= 0,
	V_VPU1			= 1,
	V_MDLA0			= 2,
	V_MDLA1			= 3,
	V_APU_CONN		= 4,
	V_TOP_IOMMU		= 5,
	V_VCORE			= 6,
	APUSYS_BUCK_DOMAIN_NUM	= 7,
};

enum dvfs_freq {
	DVFS_FREQ_NOT_SUPPORT	= 0,
	DVFS_FREQ_ACC_26M	= 1,
	DVFS_FREQ_ACC_PARKING	= 2,
	DVFS_FREQ_ACC_SOC	= 3,
	DVFS_FREQ_ACC_APUPLL	= 4,
	DVFS_FREQ_00_026000_F	= 26000,
	DVFS_FREQ_00_208000_F	= 208000,
	DVFS_FREQ_00_238000_F	= 238000,
	DVFS_FREQ_00_273000_F	= 273000,
	DVFS_FREQ_00_312000_F	= 312000,
	DVFS_FREQ_00_358000_F	= 358000,
	DVFS_FREQ_00_385000_F	= 385000,
	DVFS_FREQ_00_499200_F	= 499200,
	DVFS_FREQ_00_500000_F	= 500000,
	DVFS_FREQ_00_525000_F	= 525000,
	DVFS_FREQ_00_546000_F	= 546000,
	DVFS_FREQ_00_594000_F	= 594000,
	DVFS_FREQ_00_624000_F	= 624000,
	DVFS_FREQ_00_688000_F	= 688000,
	DVFS_FREQ_00_687500_F	= 687500,
	DVFS_FREQ_00_728000_F	= 728000,
	DVFS_FREQ_00_800000_F	= 800000,
	DVFS_FREQ_00_832000_F	= 832000,
	DVFS_FREQ_00_960000_F	= 960000,
	DVFS_FREQ_00_1100000_F	= 1100000,
};
#define DVFS_FREQ_MAX (DVFS_FREQ_00_1100000_F)

enum pll_set_rate_mode {
	CON0_PCW		= 0,
	FHCTL_SW		= 1,
	FHCTL_HW		= 2,
	PLL_SET_RATE_MODE_MAX	= 3,
};

enum apupll {
	APUPLL		= 0,
	NPUPLL		= 1,
	APUPLL1		= 2,
	APUPLL2		= 3,
	APUPLL_MAX	= 4,
};

#define BUCK_VVPU_DOMAIN_DEFAULT_FREQ	(DVFS_FREQ_00_273000_F)
#define BUCK_VMDLA_DOMAIN_DEFAULT_FREQ	(DVFS_FREQ_00_312000_F)
#define BUCK_VCONN_DOMAIN_DEFAULT_FREQ	(DVFS_FREQ_00_208000_F)

#define apupwr_writel(VAL, REG)		mmio_write_32((uintptr_t)REG, VAL)
#define apupwr_writel_relax(VAL, REG)	mmio_write_32_relax((uintptr_t)REG, VAL)
#define apupwr_readl(REG)		mmio_read_32((uintptr_t)REG)
#define apupwr_clrbits(VAL, REG)	mmio_clrbits_32((uintptr_t)REG, VAL)
#define apupwr_setbits(VAL, REG)	mmio_setbits_32((uintptr_t)REG, VAL)
#define apupwr_clrsetbits(CLR_VAL, SET_VAL, REG)	\
			  mmio_clrsetbits_32((uintptr_t)REG, CLR_VAL, SET_VAL)

/* PLL and related register */
#define APU_PLL_BASE		(APUSYS_APU_PLL_BASE)
#define APU_PLL4H_PLL1_CON0	(APU_PLL_BASE + 0x008)
#define APU_PLL4H_PLL1_CON1	(APU_PLL_BASE + 0x00C)
#define APU_PLL4H_PLL1_CON3	(APU_PLL_BASE + 0x014)

#define APU_PLL4H_PLL2_CON0	(APU_PLL_BASE + 0x018)
#define APU_PLL4H_PLL2_CON1	(APU_PLL_BASE + 0x01C)
#define APU_PLL4H_PLL2_CON3	(APU_PLL_BASE + 0x024)

#define APU_PLL4H_PLL3_CON0	(APU_PLL_BASE + 0x028)
#define APU_PLL4H_PLL3_CON1	(APU_PLL_BASE + 0x02C)
#define APU_PLL4H_PLL3_CON3	(APU_PLL_BASE + 0x034)

#define APU_PLL4H_PLL4_CON0	(APU_PLL_BASE + 0x038)
#define APU_PLL4H_PLL4_CON1	(APU_PLL_BASE + 0x03C)
#define APU_PLL4H_PLL4_CON3	(APU_PLL_BASE + 0x044)

#define APU_PLL4H_FHCTL_HP_EN		(APU_PLL_BASE + 0x0E00)
#define APU_PLL4H_FHCTL_UNITSLOPE_EN	(APU_PLL_BASE + 0x0E04)
#define APU_PLL4H_FHCTL_CLK_CON		(APU_PLL_BASE + 0x0E08)
#define APU_PLL4H_FHCTL_RST_CON		(APU_PLL_BASE + 0x0E0C)
#define APU_PLL4H_FHCTL_SLOPE0		(APU_PLL_BASE + 0x0E10)
#define APU_PLL4H_FHCTL_SLOPE1		(APU_PLL_BASE + 0x0E14)
#define APU_PLL4H_FHCTL_DSSC_CFG	(APU_PLL_BASE + 0x0E18)
#define APU_PLL4H_FHCTL_DSSC0_CON	(APU_PLL_BASE + 0x0E1C)
#define APU_PLL4H_FHCTL_DSSC1_CON	(APU_PLL_BASE + 0x0E20)
#define APU_PLL4H_FHCTL_DSSC2_CON	(APU_PLL_BASE + 0x0E24)
#define APU_PLL4H_FHCTL_DSSC3_CON	(APU_PLL_BASE + 0x0E28)
#define APU_PLL4H_FHCTL_DSSC4_CON	(APU_PLL_BASE + 0x0E2C)
#define APU_PLL4H_FHCTL_DSSC5_CON	(APU_PLL_BASE + 0x0E30)
#define APU_PLL4H_FHCTL_DSSC6_CON	(APU_PLL_BASE + 0x0E34)
#define APU_PLL4H_FHCTL_DSSC7_CON	(APU_PLL_BASE + 0x0E38)
#define APU_PLL4H_FHCTL0_CFG		(APU_PLL_BASE + 0x0E3C)
#define APU_PLL4H_FHCTL0_UPDNLMT	(APU_PLL_BASE + 0x0E40)
#define APU_PLL4H_FHCTL0_DDS		(APU_PLL_BASE + 0x0E44)
#define APU_PLL4H_FHCTL0_DVFS		(APU_PLL_BASE + 0x0E48)
#define APU_PLL4H_FHCTL0_MON		(APU_PLL_BASE + 0x0E4C)
#define APU_PLL4H_FHCTL1_CFG		(APU_PLL_BASE + 0x0E50)
#define APU_PLL4H_FHCTL1_UPDNLMT	(APU_PLL_BASE + 0x0E54)
#define APU_PLL4H_FHCTL1_DDS		(APU_PLL_BASE + 0x0E58)
#define APU_PLL4H_FHCTL1_DVFS		(APU_PLL_BASE + 0x0E5C)
#define APU_PLL4H_FHCTL1_MON		(APU_PLL_BASE + 0x0E60)
#define APU_PLL4H_FHCTL2_CFG		(APU_PLL_BASE + 0x0E64)
#define APU_PLL4H_FHCTL2_UPDNLMT	(APU_PLL_BASE + 0x0E68)
#define APU_PLL4H_FHCTL2_DDS		(APU_PLL_BASE + 0x0E6C)
#define APU_PLL4H_FHCTL2_DVFS		(APU_PLL_BASE + 0x0E70)
#define APU_PLL4H_FHCTL2_MON		(APU_PLL_BASE + 0x0E74)
#define APU_PLL4H_FHCTL3_CFG		(APU_PLL_BASE + 0x0E78)
#define APU_PLL4H_FHCTL3_UPDNLMT	(APU_PLL_BASE + 0x0E7C)
#define APU_PLL4H_FHCTL3_DDS		(APU_PLL_BASE + 0x0E80)
#define APU_PLL4H_FHCTL3_DVFS		(APU_PLL_BASE + 0x0E84)
#define APU_PLL4H_FHCTL3_MON		(APU_PLL_BASE + 0x0E88)

/* PLL4H_PLLx_CON0 */
#define RG_PLL_EN		BIT(0)

/* PLL4H_PLLx_CON1 */
#define RG_PLL_SDM_PCW_CHG	BIT(31)
#define POSDIV_SHIFT		(24U)
#define POSDIV_MASK		(0x7)

/* PLL4H_PLLx_CON3 */
#define DA_PLL_SDM_PWR_ON	BIT(0)
#define DA_PLL_SDM_ISO_EN	BIT(1)

/* FHCTLx_DDS */
#define DDS_MASK		GENMASK_32(21, 0)
#define PCW_FRACTIONAL_SHIFT	14U
#define PLL_TGL_ORG		BIT(31)

#define PLL_READY_TIME_20US	(20U)
#define PLL_CMD_READY_TIME_1US	(1U)

#define FREQ_VCO_MIN		(1500U) /* 1500MHz*/
#define FREQ_FIN		(26U)	/* 26M*/

/* ACC and related register */
#define APU_ACC_BASE		(APUSYS_APU_ACC_BASE)
#define APU_ACC_CONFG_SET0	(APU_ACC_BASE + 0x000)
#define APU_ACC_CONFG_SET1	(APU_ACC_BASE + 0x004)
#define APU_ACC_CONFG_SET2	(APU_ACC_BASE + 0x008)
#define APU_ACC_CONFG_SET4	(APU_ACC_BASE + 0x010)
#define APU_ACC_CONFG_SET5	(APU_ACC_BASE + 0x014)
#define APU_ACC_CONFG_SET7	(APU_ACC_BASE + 0x01C)

#define APU_ACC_CONFG_CLR0	(APU_ACC_BASE + 0x040)
#define APU_ACC_CONFG_CLR1	(APU_ACC_BASE + 0x044)
#define APU_ACC_CONFG_CLR2	(APU_ACC_BASE + 0x048)
#define APU_ACC_CONFG_CLR4	(APU_ACC_BASE + 0x050)
#define APU_ACC_CONFG_CLR5	(APU_ACC_BASE + 0x054)
#define APU_ACC_CONFG_CLR7	(APU_ACC_BASE + 0x05C)

#define APU_ACC_FM_CONFG_SET	(APU_ACC_BASE + 0x0C0)
#define APU_ACC_FM_CONFG_CLR	(APU_ACC_BASE + 0x0C4)
#define APU_ACC_FM_SEL		(APU_ACC_BASE + 0x0C8)
#define APU_ACC_FM_CNT		(APU_ACC_BASE + 0x0CC)

/* APU AO control */
#define APU_AO_CTRL_BASE	(APUSYS_APU_S_S_4_BASE)
#define APU_CSR_DUMMY_0		(APU_AO_CTRL_BASE + 0x24)

#define AO_MD32_MNOC_MASK	(BIT(1) | BIT(0))

#define BIT_CGEN_F26M		(0)
#define BIT_CGEN_PARK		(1)
#define BIT_CGEN_SOC		(2)
#define BIT_CGEN_APU		(3)
#define BIT_CGEN_OUT		(4)
#define BIT_SEL_PARK		(8)
#define BIT_SEL_F26M		(9)
#define BIT_SEL_APU_DIV2	(10)
#define BIT_SEL_APU		(11)
#define BIT_SEL_PARK_SRC_OUT	(12)
#define BIT_INVEN_OUT		(15)

#endif /* APUPWR_CLKCTL_DEF_H*/
