#!/bin/sh
export ALPHA_MODEL=WRGAX26
export ALPHA_SIGNATURE=wrgax26_
export SVNREV=`svn info | grep Revision: | cut -f2 -d " "`

MBEDTLSDIR=mbedtls-2.28.1
UBOOTDIR=Uboot-upstream-20220630
ATFDIR=atf-20220512-89fa1e525

echo "#define ALPHAVER $SVNREV" > $UBOOTDIR/include/alphaver.h
echo "#define ALPHAVER_STRING \"$SVNREV\"" >> $UBOOTDIR/include/alphaver.h
echo "#define ALPHAMODEL \"$ALPHA_MODEL\"" >> $UBOOTDIR/include/alphaver.h
echo "#define ALPHA_MODEL_PREFIX \"$ALPHA_MODEL""_\"" >> $UBOOTDIR/include/alphaver.h
echo "#define ALPHA_SIGNATURE \"$ALPHA_SIGNATURE\"" >> $UBOOTDIR/include/alphaver.h

#Build Uboot
cd $UBOOTDIR
export CROSS_COMPILE=/usr/bin/aarch64-linux-gnu-
make clean
make mt7986_spim_nand_rfb_defconfig
cp ../Uboot.config ./.config
make V=s FIT_KEY=./../keys/fit_key.crt
cd ..

#Build ATF
cd $ATFDIR
make distclean
export CROSS_COMPILE=/usr/bin/aarch64-linux-gnu-
make PLAT="mt7986" TRUSTED_BOARD_BOOT=1 GENERATE_COT=1 ROT_KEY="../keys/fip_private_key.pem" BROM_SIGN_KEY="../keys/bl2_private_key.pem" MBEDTLS_DIR="../tools/$MBEDTLSDIR/" BOOT_DEVICE="spim-nand" NMBM=1 NAND_TYPE="spim:2k+64" DRAM_USE_DDR4=0 LOG_LEVEL=40 BL33="./../$UBOOTDIR/u-boot.bin" all fip
cd ..

rm -f ./$ALPHA_MODEL"_svn"$SVNREV".bl2.img"
cp $ATFDIR/build/mt7986/release/bl2.img ./$ALPHA_MODEL"_svn"$SVNREV".bl2.img"

rm -f ./$ALPHA_MODEL"_svn"$SVNREV".fip.bin"
cp $ATFDIR/build/mt7986/release/fip.bin ./$ALPHA_MODEL"_svn"$SVNREV".fip.bin"

rm -f ./$ALPHA_MODEL"_svn"$SVNREV".bl2.img.signkeyhash"
cp $ATFDIR/build/mt7986/release/bl2.img.signkeyhash ./$ALPHA_MODEL"_svn"$SVNREV".bl2.img.signkeyhash"
