#!/bin/sh
export ALPHA_MODEL=WRGAX26
export ALPHA_SIGNATURE=wrgax26_
export SVNREV=`svn info | grep Revision: | cut -f2 -d " "`

UBOOTDIR=Uboot-upstream
ATFDIR=atf-20220512-89fa1e525

echo "#define ALPHAVER $SVNREV" > $UBOOTDIR/include/alphaver.h
echo "#define ALPHAVER_STRING \"$SVNREV\"" >> $UBOOTDIR/include/alphaver.h
echo "#define ALPHAMODEL \"$ALPHA_MODEL\"" >> $UBOOTDIR/include/alphaver.h
echo "#define ALPHA_MODEL_PREFIX \"$ALPHA_MODEL""_\"" >> $UBOOTDIR/include/alphaver.h
echo "#define ALPHA_SIGNATURE \"$ALPHA_SIGNATURE\"" >> $UBOOTDIR/include/alphaver.h

#Build Uboot
cd $UBOOTDIR
make CROSS_COMPILE=/usr/bin/aarch64-linux-gnu- clean
make mt7986_spim_nand_rfb_defconfig
make CROSS_COMPILE=/usr/bin/aarch64-linux-gnu-
cd ..

#Build ATF
cd $ATFDIR
make clean
cd ..
cp -rf atf.config $ATFDIR/.config
cd $ATFDIR
make
cd ..

rm -f ./$ALPHA_MODEL"_svn"$SVNREV".bl2.img"
cp $ATFDIR/build/mt7986/release/bl2.img ./$ALPHA_MODEL"_svn"$SVNREV".bl2.img"

rm -f ./$ALPHA_MODEL"_svn"$SVNREV".fip.bin"
cp $ATFDIR/build/mt7986/release/fip.bin ./$ALPHA_MODEL"_svn"$SVNREV".fip.bin"

