/*
 * Copyright (c) 2015, The Linux Foundation. All rights reserved.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* touch coordinate range */
#define TP_WIDTH		480
#define TP_LENGTH		800

/* coordinate direction */
#define TP_DIREC		1

/* touch threshold */
#define MAI_TRSD		200
#define SUB_TRSD		40
#define SUM_TRSD		(MAI_TRSD + SUB_TRSD + 20)

/* touch tigger condition */
#define TRIG_MOD		1
#define VOLT_LEV		0
/* touch sensitivity */
#define TP_DACG			0x00100010

#define GSL_PAGE_REG		0xf0
#define GSL_CLOCK_REG		0xe4
#define GSL_START_REG		0xe0
#define GSL_CLOCK_REG		0xe4
#define POWE_FAIL_REG		0xbc
#define TOUCH_INFO_REG		0x80

#define DIS_MIN_X		0
#define DIS_MAX_X		TP_WIDTH
#define DIS_MIN_Y		0
#define DIS_MAX_Y		TP_LENGTH

#define MIN_TOUCH		0
#define MAX_TOUCH		1
#define MIN_WIDTH		0
#define MAX_WIDTH		1
#define MIN_TRCKID		0
#define MAX_TRCKID		5

/* the data format of one point */
union gsl_point_data {
	struct {
		u16 y;
		u16 x:12;
		u16 id:4;
	};
	u8 all[4];
};

/* the 24-byte data of read once */
union gsl_touch_info {
	struct {
		u32 finger_num:8;
		u32: 0;
		union gsl_point_data point[5];
	};
	u8 all[24];
};

struct gsl_ts_data {
	union gsl_touch_info *ti;
	struct i2c_client *client;
	struct input_dev *idev;
	struct workqueue_struct *wq;
	struct work_struct work;
	unsigned int irq;
};

struct gsl_avoid_jit {
	union gsl_point_data pre;
	union gsl_point_data base;
	u32 delta;
};

/* Fixme mem Alig */
struct fw_data {
	u32 offset:8;
	u32: 0;
	u32 val;
};

static const struct fw_data GSL1680_D0_FW[] = {
{0xf0, 0x3},
{0x00, 0xa5a5ffc0},
{0x04, 0x00000000},
{0x08, 0xe810c4e1},
{0x0c, 0xd3dd7f4d},
{0x10, 0xd7c56634},
{0x14, 0xe3505a2a},
{0x18, 0x514d494f},
{0x1c, 0xafebf471},
{0x20, 0x00000000},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000000},
{0x30, 0x00001000},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x00000001},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x01020304},
{0x58, 0x05060708},
{0x5c, 0x090a0b0c},
{0x60, 0x0d0e0e0f},
{0x64, 0x10111213},
{0x68, 0x14151617},
{0x6c, 0x18191a1b},
{0x70, 0x1b1c1e1f},
{0x74, 0x00000000},
{0x78, 0x00010000},
{0x7c, 0x8c846af3},
{0xf0, 0x4},
{0x00, 0x00000000},
{0x04, 0x00000000},
{0x08, 0x00000000},
{0x0c, 0x00000000},
{0x10, 0xffffff38},
{0x14, 0x00000000},
{0x18, 0x00000000},
{0x1c, 0x00000000},
{0x20, 0x00000000},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000000},
{0x30, 0x00002400},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00010203},
{0x58, 0x03040506},
{0x5c, 0x06070808},
{0x60, 0x090a0b0c},
{0x64, 0x0d0e0f10},
{0x68, 0x10111314},
{0x6c, 0x15161819},
{0x70, 0x1a1b1d1f},
{0x74, 0x00000000},
{0x78, 0x8080a680},
{0x7c, 0x8c846af3},
{0xf0, 0x5},
{0x00, 0xf3b18989},
{0x04, 0x00000005},
{0x08, 0x0000012c},
{0x0c, 0x80808080},
{0x10, 0x00000000},
{0x14, 0x00000000},
{0x18, 0x00010fff},
{0x1c, 0x10000000},
{0x20, 0x10000000},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000400},
{0x30, 0x00808080},
{0x34, 0x80808080},
{0x38, 0x80808080},
{0x3c, 0x80808080},
{0x40, 0x80808080},
{0x44, 0x80808080},
{0x48, 0x80808080},
{0x4c, 0x80808080},
{0x50, 0x00000000},
{0x54, 0x00010202},
{0x58, 0x03040505},
{0x5c, 0x06070808},
{0x60, 0x090a0b0c},
{0x64, 0x0d0e0f10},
{0x68, 0x11121314},
{0x6c, 0x15161819},
{0x70, 0x1a1b1d1e},
{0x74, 0x00000001},
{0x78, 0x0000000f},
{0x7c, 0x0000000a},
{0xf0, 0x6},
{0x00, 0x0000000f},
{0x04, 0x00000000},
{0x08, 0x0000000a},
{0x0c, 0x00000000},
{0x10, 0x00000032},
{0x14, 0x00000014},
{0x18, 0x00000000},
{0x1c, 0x00000001},
{0x20, 0x00002904},
{0x24, 0x000001e0},
{0x28, 0x00000320},
{0x2c, 0xf8010009},
{0x30, 0xf8010009},
{0x34, 0x00000004},
{0x38, 0x00000003},
{0x3c, 0x00010fff},
{0x40, 0x80000000},
{0x44, 0x00160016},
{0x48, 0x00000fff},
{0x4c, 0x00000003},
{0x50, 0x00020001},
{0x54, 0x00000064},
{0x58, 0x00001000},
{0x5c, 0x09249248},
{0x60, 0x00000000},
{0x64, 0x000007d0},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x000001c2},
{0x78, 0x00000064},
{0x7c, 0x00000000},
{0xf0, 0x7},
{0x00, 0x04010700},
{0x04, 0x06030902},
{0x08, 0x0805040a},
{0x0c, 0x07110610},
{0x10, 0x09130812},
{0x14, 0x00543216},
{0x18, 0x007890ab},
{0x1c, 0x00321094},
{0x20, 0x005678ab},
{0x24, 0xff080010},
{0x28, 0xff080120},
{0x2c, 0xff080140},
{0x30, 0xff080160},
{0x34, 0x000000fa},
{0x38, 0x000000d8},
{0x3c, 0x000000b7},
{0x40, 0x00000014},
{0x44, 0x00000100},
{0x48, 0x00000000},
{0x4c, 0x00000004},
{0x50, 0x00000000},
{0x54, 0x00000001},
{0x58, 0x000e0000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x00080002},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00432105},
{0x7c, 0x006789ab},
{0xf0, 0x8},
{0x00, 0x026f028f},
{0x04, 0x02af02cf},
{0x08, 0x02ef030f},
{0x0c, 0x032f034f},
{0x10, 0x01f301f4},
{0x14, 0x01f501f6},
{0x18, 0x01f701f8},
{0x1c, 0x11f901fa},
{0x20, 0x022f024f},
{0x24, 0x036f01f0},
{0x28, 0x01f101f2},
{0x2c, 0x020f0000},
{0x30, 0x00000000},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x000043ef},
{0x40, 0x02040608},
{0x44, 0x0a000000},
{0x48, 0x00000000},
{0x4c, 0x01030507},
{0x50, 0x09000000},
{0x54, 0x00000000},
{0x58, 0x00c800aa},
{0x5c, 0x00000008},
{0x60, 0x00000118},
{0x64, 0x00000201},
{0x68, 0x00000804},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x0000000a},
{0xf0, 0x9},
{0x00, 0xff080094},
{0x04, 0x00070011},
{0x08, 0xff080090},
{0x0c, 0x00040000},
{0x10, 0xfffffff0},
{0x14, 0x00000000},
{0x18, 0xfffffff0},
{0x1c, 0x00000000},
{0x20, 0xfffffff0},
{0x24, 0x00000000},
{0x28, 0xfffffff0},
{0x2c, 0x00000000},
{0x30, 0xfffffff0},
{0x34, 0x00000000},
{0x38, 0xfffffff0},
{0x3c, 0x00000000},
{0x40, 0xfffffff0},
{0x44, 0x00000000},
{0x48, 0xfffffff0},
{0x4c, 0x00000000},
{0x50, 0xfffffff0},
{0x54, 0x00000000},
{0x58, 0xfffffff0},
{0x5c, 0x00000000},
{0x60, 0xfffffff0},
{0x64, 0x00000000},
{0x68, 0xfffffff0},
{0x6c, 0x00000000},
{0x70, 0xfffffff0},
{0x74, 0x00000000},
{0x78, 0xfffffff0},
{0x7c, 0x00000000},

{0xf0, 0xe0},
{0x00, 0x006e002b},
{0x04, 0x00000075},
{0x08, 0x005c0088},
{0x0c, 0x009a0011},
{0x10, 0x00ad0007},
{0x14, 0x0024000c},
{0x18, 0x001500e9},
{0x1c, 0x003f0084},
{0x20, 0x00bc0021},
{0x24, 0x003c0079},
{0x28, 0x007d0064},
{0x2c, 0x006200b6},
{0x30, 0x00d30001},
{0x34, 0x0000011e},
{0x38, 0x0135003c},
{0x3c, 0x00730086},
{0x40, 0x006401f4},
{0x44, 0x00640064},
{0x48, 0x01900064},
{0x4c, 0x00500190},
{0x50, 0x00500050},
{0x54, 0x012c0050},
{0x58, 0x012c012c},
{0x5c, 0x0032012c},
{0x60, 0x00640000},
{0x64, 0x00640064},
{0x68, 0x00000032},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
{0xf0, 0xe1},
{0x00, 0x00810028},
{0x04, 0x00000068},
{0x08, 0x00590071},
{0x0c, 0x00a80014},
{0x10, 0x00aa0000},
{0x14, 0x0029000a},
{0x18, 0x002000bc},
{0x1c, 0x003e0079},
{0x20, 0x00a70025},
{0x24, 0x00330071},
{0x28, 0x00720062},
{0x2c, 0x008300ae},
{0x30, 0x00b50000},
{0x34, 0x00000110},
{0x38, 0x012c0034},
{0x3c, 0x005d0090},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},

{0xf0, 0x0},
{0x00, 0x01000000},
{0x04, 0x01000000},
{0x08, 0x01000000},
{0x0c, 0x233fc0c0},
{0x10, 0xa2146004},
{0x14, 0xa4102000},
{0x18, 0xe4244000},
{0x1c, 0x233fc0c0},
{0x20, 0xa2146010},
{0x24, 0x2500003f},
{0x28, 0xa414a3ff},
{0x2c, 0xe4244000},
{0x30, 0x01000000},
{0x34, 0x821020e0},
{0x38, 0x81880001},
{0x3c, 0x01000000},
{0x40, 0x01000000},
{0x44, 0x01000000},
{0x48, 0x270010c0},
{0x4c, 0xa614e00f},
{0x50, 0xe6a00040},
{0x54, 0x01000000},
{0x58, 0xa410200f},
{0x5c, 0xe4a00040},
{0x60, 0x01000000},
{0x64, 0xa0100000},
{0x68, 0xa2100000},
{0x6c, 0xa4100000},
{0x70, 0xa6100000},
{0x74, 0xa8100000},
{0x78, 0xaa100000},
{0x7c, 0xac100000},
{0xf0, 0x1},
{0x00, 0xae100000},
{0x04, 0x90100000},
{0x08, 0x92100000},
{0x0c, 0x94100000},
{0x10, 0x96100000},
{0x14, 0x98100000},
{0x18, 0x9a100000},
{0x1c, 0x9c100000},
{0x20, 0x9e100000},
{0x24, 0x84100000},
{0x28, 0x86100000},
{0x2c, 0x88100000},
{0x30, 0x8a100000},
{0x34, 0x8c100000},
{0x38, 0x8e100000},
{0x3c, 0x01000000},
{0x40, 0x01000000},
{0x44, 0x01000000},
{0x48, 0x82100000},
{0x4c, 0x81900001},
{0x50, 0x82100000},
{0x54, 0x81980001},
{0x58, 0x81800000},
{0x5c, 0x01000000},
{0x60, 0x01000000},
{0x64, 0x01000000},
{0x68, 0xbc102cf8},
{0x6c, 0x9c102c78},
{0x70, 0x01000000},
{0x74, 0x01000000},
{0x78, 0x01000000},
{0x7c, 0x01000000},
{0xf0, 0x2},
{0x00, 0x270010c0},
{0x04, 0xa614e00f},
{0x08, 0xe6a00040},
{0x0c, 0x01000000},
{0x10, 0x40000451},
{0x14, 0x01000000},
{0x18, 0x01000000},
{0x1c, 0x10bfffff},
{0x20, 0x01000000},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000000},
{0x30, 0x00000000},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
{0xf0, 0x1a},
{0x00, 0x0000000e},
{0x04, 0xfffffe65},
{0x08, 0x000003fc},
{0x0c, 0x00000af6},
{0x10, 0x000003d4},
{0x14, 0xfffffe64},
{0x18, 0x00000008},
{0x1c, 0xfffffe66},
{0x20, 0x00000425},
{0x24, 0x00000af5},
{0x28, 0x000003ac},
{0x2c, 0xfffffe65},
{0x30, 0x00000003},
{0x34, 0xfffffe67},
{0x38, 0x0000044e},
{0x3c, 0x00000af3},
{0x40, 0x00000384},
{0x44, 0xfffffe65},
{0x48, 0xfffffffd},
{0x4c, 0xfffffe69},
{0x50, 0x00000476},
{0x54, 0x00000aef},
{0x58, 0x0000035c},
{0x5c, 0xfffffe67},
{0x60, 0xfffffff7},
{0x64, 0xfffffe6c},
{0x68, 0x0000049f},
{0x6c, 0x00000aea},
{0x70, 0x00000335},
{0x74, 0xfffffe68},
{0x78, 0xfffffff1},
{0x7c, 0xfffffe6f},
{0xf0, 0x1b},
{0x00, 0x000004c9},
{0x04, 0x00000ae5},
{0x08, 0x0000030e},
{0x0c, 0xfffffe6a},
{0x10, 0xffffffeb},
{0x14, 0xfffffe73},
{0x18, 0x000004f2},
{0x1c, 0x00000ade},
{0x20, 0x000002e7},
{0x24, 0xfffffe6d},
{0x28, 0xffffffe4},
{0x2c, 0xfffffe78},
{0x30, 0x0000051b},
{0x34, 0x00000ad5},
{0x38, 0x000002c1},
{0x3c, 0xfffffe70},
{0x40, 0xffffffde},
{0x44, 0xfffffe7d},
{0x48, 0x00000544},
{0x4c, 0x00000acc},
{0x50, 0x0000029c},
{0x54, 0xfffffe74},
{0x58, 0xffffffd7},
{0x5c, 0xfffffe83},
{0x60, 0x0000056d},
{0x64, 0x00000ac2},
{0x68, 0x00000276},
{0x6c, 0xfffffe78},
{0x70, 0xffffffd0},
{0x74, 0xfffffe89},
{0x78, 0x00000597},
{0x7c, 0x00000ab6},
{0xf0, 0x1c},
{0x00, 0x00000251},
{0x04, 0xfffffe7c},
{0x08, 0xffffffc8},
{0x0c, 0xfffffe91},
{0x10, 0x000005c0},
{0x14, 0x00000aa9},
{0x18, 0x0000022d},
{0x1c, 0xfffffe81},
{0x20, 0xffffffc1},
{0x24, 0xfffffe99},
{0x28, 0x000005e9},
{0x2c, 0x00000a9b},
{0x30, 0x00000209},
{0x34, 0xfffffe86},
{0x38, 0xffffffb9},
{0x3c, 0xfffffea1},
{0x40, 0x00000611},
{0x44, 0x00000a8d},
{0x48, 0x000001e5},
{0x4c, 0xfffffe8b},
{0x50, 0xffffffb2},
{0x54, 0xfffffeab},
{0x58, 0x0000063a},
{0x5c, 0x00000a7d},
{0x60, 0x000001c3},
{0x64, 0xfffffe91},
{0x68, 0xffffffaa},
{0x6c, 0xfffffeb5},
{0x70, 0x00000663},
{0x74, 0x00000a6b},
{0x78, 0x000001a0},
{0x7c, 0xfffffe97},
{0xf0, 0x1d},
{0x00, 0xffffffa2},
{0x04, 0xfffffebf},
{0x08, 0x0000068b},
{0x0c, 0x00000a59},
{0x10, 0x0000017e},
{0x14, 0xfffffe9d},
{0x18, 0xffffff9a},
{0x1c, 0xfffffecb},
{0x20, 0x000006b3},
{0x24, 0x00000a46},
{0x28, 0x0000015d},
{0x2c, 0xfffffea4},
{0x30, 0xffffff91},
{0x34, 0xfffffed7},
{0x38, 0x000006da},
{0x3c, 0x00000a32},
{0x40, 0x0000013d},
{0x44, 0xfffffeab},
{0x48, 0xffffff89},
{0x4c, 0xfffffee4},
{0x50, 0x00000702},
{0x54, 0x00000a1d},
{0x58, 0x0000011d},
{0x5c, 0xfffffeb2},
{0x60, 0xffffff80},
{0x64, 0xfffffef2},
{0x68, 0x00000729},
{0x6c, 0x00000a06},
{0x70, 0x000000fd},
{0x74, 0xfffffeba},
{0x78, 0xffffff78},
{0x7c, 0xffffff00},
{0xf0, 0x1e},
{0x00, 0x0000074f},
{0x04, 0x000009ef},
{0x08, 0x000000df},
{0x0c, 0xfffffec1},
{0x10, 0xffffff6f},
{0x14, 0xffffff10},
{0x18, 0x00000776},
{0x1c, 0x000009d7},
{0x20, 0x000000c1},
{0x24, 0xfffffec9},
{0x28, 0xffffff66},
{0x2c, 0xffffff20},
{0x30, 0x0000079b},
{0x34, 0x000009be},
{0x38, 0x000000a3},
{0x3c, 0xfffffed1},
{0x40, 0xffffff5e},
{0x44, 0xffffff30},
{0x48, 0x000007c1},
{0x4c, 0x000009a4},
{0x50, 0x00000087},
{0x54, 0xfffffed9},
{0x58, 0xffffff55},
{0x5c, 0xffffff42},
{0x60, 0x000007e5},
{0x64, 0x00000989},
{0x68, 0x0000006b},
{0x6c, 0xfffffee2},
{0x70, 0xffffff4c},
{0x74, 0xffffff54},
{0x78, 0x0000080a},
{0x7c, 0x0000096d},
{0xf0, 0x1f},
{0x00, 0x0000004f},
{0x04, 0xfffffeea},
{0x08, 0xffffff43},
{0x0c, 0xffffff67},
{0x10, 0x0000082d},
{0x14, 0x00000951},
{0x18, 0x00000035},
{0x1c, 0xfffffef3},
{0x20, 0xffffff3a},
{0x24, 0xffffff7b},
{0x28, 0x00000850},
{0x2c, 0x00000933},
{0x30, 0x0000001b},
{0x34, 0xfffffefb},
{0x38, 0xffffff31},
{0x3c, 0xffffff90},
{0x40, 0x00000873},
{0x44, 0x00000915},
{0x48, 0x00000002},
{0x4c, 0xffffff04},
{0x50, 0xffffff28},
{0x54, 0xffffffa5},
{0x58, 0x00000895},
{0x5c, 0x000008f6},
{0x60, 0xffffffea},
{0x64, 0xffffff0d},
{0x68, 0xffffff1f},
{0x6c, 0xffffffbb},
{0x70, 0x000008b6},
{0x74, 0x000008d6},
{0x78, 0xffffffd2},
{0x7c, 0xffffff16},
{0xf0, 0x20},
{0x00, 0x83580000},
{0x04, 0x82086ff0},
{0x08, 0x83306004},
{0x0c, 0x80a06005},
{0x10, 0x02800024},
{0x14, 0x01000000},
{0x18, 0x80a06006},
{0x1c, 0x02800039},
{0x20, 0x01000000},
{0x24, 0x80a06015},
{0x28, 0x02800051},
{0x2c, 0x01000000},
{0x30, 0x80a0602a},
{0x34, 0x02800085},
{0x38, 0x01000000},
{0x3c, 0x073fc180},
{0x40, 0x8610e03c},
{0x44, 0x05169680},
{0x48, 0x84004002},
{0x4c, 0xc420c000},
{0x50, 0x073fc000},
{0x54, 0x8610e020},
{0x58, 0x84102001},
{0x5c, 0xc420c000},
{0x60, 0x0500000c},
{0x64, 0x01000000},
{0x68, 0x01000000},
{0x6c, 0x8480bfff},
{0x70, 0x12bffffe},
{0x74, 0x01000000},
{0x78, 0x01000000},
{0x7c, 0x073fc000},
{0xf0, 0x21},
{0x00, 0x8610e020},
{0x04, 0x84102000},
{0x08, 0xc420c000},
{0x0c, 0x01000000},
{0x10, 0x01000000},
{0x14, 0x81c44000},
{0x18, 0x81cc8000},
{0x1c, 0x01000000},
{0x20, 0xa7500000},
{0x24, 0xa92ce002},
{0x28, 0xa734e001},
{0x2c, 0xa614c014},
{0x30, 0xa60ce007},
{0x34, 0x81900000},
{0x38, 0x01000000},
{0x3c, 0x01000000},
{0x40, 0x81e00000},
{0x44, 0xe03ba000},
{0x48, 0xe43ba008},
{0x4c, 0xe83ba010},
{0x50, 0xec3ba018},
{0x54, 0xf03ba020},
{0x58, 0xf43ba028},
{0x5c, 0xf83ba030},
{0x60, 0xfc3ba038},
{0x64, 0x81e80000},
{0x68, 0x8194c000},
{0x6c, 0x01000000},
{0x70, 0x01000000},
{0x74, 0x81c44000},
{0x78, 0x81cc8000},
{0x7c, 0x01000000},
{0xf0, 0x22},
{0x00, 0xa7500000},
{0x04, 0xa934e002},
{0x08, 0xa72ce001},
{0x0c, 0xa614c014},
{0x10, 0xa60ce007},
{0x14, 0x81900000},
{0x18, 0x01000000},
{0x1c, 0x01000000},
{0x20, 0x81e80000},
{0x24, 0x81e80000},
{0x28, 0xe01ba000},
{0x2c, 0xe41ba008},
{0x30, 0xe81ba010},
{0x34, 0xec1ba018},
{0x38, 0xf01ba020},
{0x3c, 0xf41ba028},
{0x40, 0xf81ba030},
{0x44, 0xfc1ba038},
{0x48, 0x81e00000},
{0x4c, 0x81e00000},
{0x50, 0x8194c000},
{0x54, 0x01000000},
{0x58, 0x01000000},
{0x5c, 0x81c44000},
{0x60, 0x81cc8000},
{0x64, 0x01000000},
{0x68, 0x01000000},
{0x6c, 0x82102010},
{0x70, 0x273fc0c0},
{0x74, 0xa614e010},
{0x78, 0xc224c000},
{0x7c, 0x01000000},
{0xf0, 0x23},
{0x00, 0x033fc0c0},
{0x04, 0x82106004},
{0x08, 0xa6102000},
{0x0c, 0xe6204000},
{0x10, 0x01000000},
{0x14, 0x01000000},
{0x18, 0x01000000},
{0x1c, 0xa6102020},
{0x20, 0x83480000},
{0x24, 0x82104013},
{0x28, 0x81884000},
{0x2c, 0x01000000},
{0x30, 0x400011a1},
{0x34, 0x01000000},
{0x38, 0x01000000},
{0x3c, 0x01000000},
{0x40, 0xa7500000},
{0x44, 0xa934e002},
{0x48, 0xa72ce001},
{0x4c, 0xa614c014},
{0x50, 0xa60ce007},
{0x54, 0x81900000},
{0x58, 0x01000000},
{0x5c, 0x81e80000},
{0x60, 0xe01ba000},
{0x64, 0xe41ba008},
{0x68, 0xe81ba010},
{0x6c, 0xec1ba018},
{0x70, 0xf01ba020},
{0x74, 0xf41ba028},
{0x78, 0xf81ba030},
{0x7c, 0xfc1ba038},
{0xf0, 0x24},
{0x00, 0x81e00000},
{0x04, 0x8194c000},
{0x08, 0x01000000},
{0x0c, 0xa6102020},
{0x10, 0x83480000},
{0x14, 0x82284013},
{0x18, 0x81884000},
{0x1c, 0x01000000},
{0x20, 0x033fc0c0},
{0x24, 0x82106004},
{0x28, 0xa6103fff},
{0x2c, 0xe6204000},
{0x30, 0x01000000},
{0x34, 0x01000000},
{0x38, 0x01000000},
{0x3c, 0x81c44000},
{0x40, 0x81cc8000},
{0x44, 0x01000000},
{0x48, 0x81c48000},
{0x4c, 0x81cca004},
{0x50, 0x01000000},
{0x54, 0x9de3bf98},
{0x58, 0x4000001b},
{0x5c, 0x01000000},
{0x60, 0x40000012},
{0x64, 0x01000000},
{0x68, 0x400000ee},
{0x6c, 0x01000000},
{0x70, 0x40000040},
{0x74, 0x01000000},
{0x78, 0x400000a4},
{0x7c, 0x01000000},
{0xf0, 0x25},
{0x00, 0x30bffffe},
{0x04, 0x80a22000},
{0x08, 0x02800006},
{0x0c, 0x01000000},
{0x10, 0x01000000},
{0x14, 0x90823fff},
{0x18, 0x12bffffe},
{0x1c, 0x01000000},
{0x20, 0x81c3e008},
{0x24, 0x01000000},
{0x28, 0x82102001},
{0x2c, 0x81904000},
{0x30, 0x01000000},
{0x34, 0x01000000},
{0x38, 0x01000000},
{0x3c, 0x81c3e008},
{0x40, 0x01000000},
{0x44, 0x03000008},
{0x48, 0x82106342},
{0x4c, 0xa3804000},
{0x50, 0x03000004},
{0x54, 0x82106000},
{0x58, 0x81984000},
{0x5c, 0x01000000},
{0x60, 0x01000000},
{0x64, 0x01000000},
{0x68, 0x81c3e008},
{0x6c, 0x01000000},
{0x70, 0x98102000},
{0x74, 0x832b2002},
{0x78, 0xda006480},
{0x7c, 0x80a37ff0},
{0xf0, 0x26},
{0x00, 0x02800006},
{0x04, 0x98032002},
{0x08, 0xc2006484},
{0x0c, 0x80a3201f},
{0x10, 0x04bffff9},
{0x14, 0xc2234000},
{0x18, 0x81c3e008},
{0x1c, 0x01000000},
{0x20, 0x03004040},
{0x24, 0x94106101},
{0x28, 0x98102000},
{0x2c, 0x832b2002},
{0x30, 0xd60063a4},
{0x34, 0x9a102000},
{0x38, 0x832b6002},
{0x3c, 0x9a036001},
{0x40, 0x80a36004},
{0x44, 0x04bffffd},
{0x48, 0xd422c001},
{0x4c, 0x98032001},
{0x50, 0x80a32003},
{0x54, 0x04bffff7},
{0x58, 0x832b2002},
{0x5c, 0x033fc200},
{0x60, 0xda002330},
{0x64, 0x82106074},
{0x68, 0x81c3e008},
{0x6c, 0xda204000},
{0x70, 0x9de3bf98},
{0x74, 0x40000f98},
{0x78, 0x90102000},
{0x7c, 0x213fc140},
{0xf0, 0x27},
{0x00, 0xda00247c},
{0x04, 0x98142040},
{0x08, 0xea030000},
{0x0c, 0xc20022f8},
{0x10, 0x9b336001},
{0x14, 0x825b4001},
{0x18, 0xaa0d7c00},
{0x1c, 0xaa154001},
{0x20, 0xea230000},
{0x24, 0x82142004},
{0x28, 0xea004000},
{0x2c, 0xaa0d7ff0},
{0x30, 0xaa15400d},
{0x34, 0xea204000},
{0x38, 0x2d3fc200},
{0x3c, 0x8215a080},
{0x40, 0xea004000},
{0x44, 0xaa0d7ff0},
{0x48, 0xaa15400d},
{0x4c, 0xea204000},
{0x50, 0xc200233c},
{0x54, 0x9a15a070},
{0x58, 0xc2234000},
{0x5c, 0x19000016},
{0x60, 0x033fc000},
{0x64, 0xda002338},
{0x68, 0xa21323a8},
{0x6c, 0x82106030},
{0x70, 0xda204000},
{0x74, 0x98132180},
{0x78, 0x96142088},
{0x7c, 0xd822c000},
{0xf0, 0x28},
{0x00, 0x9414208c},
{0x04, 0x0300003f},
{0x08, 0xe2228000},
{0x0c, 0x92142058},
{0x10, 0x821063ff},
{0x14, 0xc2224000},
{0x18, 0xc20023f8},
{0x1c, 0x9015a00c},
{0x20, 0xc2220000},
{0x24, 0xc20023fc},
{0x28, 0x9e15a008},
{0x2c, 0xc223c000},
{0x30, 0xa6142080},
{0x34, 0xd824c000},
{0x38, 0xa8142084},
{0x3c, 0xa414205c},
{0x40, 0xe2250000},
{0x44, 0x7fffffb7},
{0x48, 0xc0248000},
{0x4c, 0x400001fb},
{0x50, 0xa415a030},
{0x54, 0x9a15a07c},
{0x58, 0xea034000},
{0x5c, 0x033ff000},
{0x60, 0xd8002374},
{0x64, 0xaa2d4001},
{0x68, 0xea234000},
{0x6c, 0x033fc1c0},
{0x70, 0xda002340},
{0x74, 0x82106064},
{0x78, 0xda204000},
{0x7c, 0x0300007f},
{0xf0, 0x29},
{0x00, 0x92142010},
{0x04, 0x821063ff},
{0x08, 0x1507ffc0},
{0x0c, 0xc2224000},
{0x10, 0x9e142030},
{0x14, 0x96032001},
{0x18, 0xd423c000},
{0x1c, 0x972ae010},
{0x20, 0xa0142014},
{0x24, 0x9602c00c},
{0x28, 0xa32b2010},
{0x2c, 0x912b2004},
{0x30, 0xd4240000},
{0x34, 0x80a32000},
{0x38, 0x82044008},
{0x3c, 0x9602e002},
{0x40, 0x9a15a084},
{0x44, 0x9815a088},
{0x48, 0x02800005},
{0x4c, 0x9415a08c},
{0x50, 0xc2234000},
{0x54, 0xe2230000},
{0x58, 0xd6228000},
{0x5c, 0xc2002344},
{0x60, 0xc2248000},
{0x64, 0x033fc0c0},
{0x68, 0x82106004},
{0x6c, 0x9a103fff},
{0x70, 0x7fffff80},
{0x74, 0xda204000},
{0x78, 0x03200040},
{0x7c, 0xc2258000},
{0xf0, 0x2a},
{0x00, 0x81c7e008},
{0x04, 0x81e80000},
{0x08, 0x01000000},
{0x0c, 0x01000000},
{0x10, 0x01000000},
{0x14, 0xa7800000},
{0x18, 0x01000000},
{0x1c, 0x01000000},
{0x20, 0x01000000},
{0x24, 0x81c3e008},
{0x28, 0x01000000},
{0x2c, 0x9de3bf98},
{0x30, 0xb6102000},
{0x34, 0xb0102000},
{0x38, 0xb8102000},
{0x3c, 0xc2070000},
{0x40, 0xb8072004},
{0x44, 0x80a724ff},
{0x48, 0x08bffffd},
{0x4c, 0xb606c001},
{0x50, 0x03000016},
{0x54, 0x821061e0},
{0x58, 0x82087f80},
{0x5c, 0xb8102d00},
{0x60, 0x80a70001},
{0x64, 0x3a80001e},
{0x68, 0xfa002180},
{0x6c, 0xb4100001},
{0x70, 0x9a102001},
{0x74, 0x9e100001},
{0x78, 0xc2070000},
{0x7c, 0xb8072004},
{0xf0, 0x2b},
{0x00, 0xb21f001a},
{0x04, 0xbb37200c},
{0x08, 0x808f2fff},
{0x0c, 0x02800005},
{0x10, 0xb606c001},
{0x14, 0x80a7001a},
{0x18, 0x1280000e},
{0x1c, 0x80a7000f},
{0x20, 0x80a00019},
{0x24, 0xba677fff},
{0x28, 0x832f6002},
{0x2c, 0xc2006180},
{0x30, 0xb606c001},
{0x34, 0xba077fff},
{0x38, 0x80a6e000},
{0x3c, 0x832b401d},
{0x40, 0x12800003},
{0x44, 0xb6102000},
{0x48, 0xb0160001},
{0x4c, 0x80a7000f},
{0x50, 0x2abfffeb},
{0x54, 0xc2070000},
{0x58, 0xfa002180},
{0x5c, 0xb816001d},
{0x60, 0x821e001d},
{0x64, 0x80a70001},
{0x68, 0x32800009},
{0x6c, 0xba16001d},
{0x70, 0x0329697f},
{0x74, 0x821063ff},
{0x78, 0x80a70001},
{0x7c, 0x32800004},
{0xf0, 0x2c},
{0x00, 0xba16001d},
{0x04, 0x3b169696},
{0x08, 0xba17625a},
{0x0c, 0x033fc180},
{0x10, 0x82106030},
{0x14, 0xfa204000},
{0x18, 0x81c7e008},
{0x1c, 0x91e82001},
{0x20, 0x033fc180},
{0x24, 0xc0204000},
{0x28, 0x82102500},
{0x2c, 0xc0204000},
{0x30, 0x82006004},
{0x34, 0x80a0687c},
{0x38, 0x28bffffe},
{0x3c, 0xc0204000},
{0x40, 0x033fc200},
{0x44, 0x82106030},
{0x48, 0xda004000},
{0x4c, 0x82102010},
{0x50, 0xc2202574},
{0x54, 0x82102001},
{0x58, 0xc2202540},
{0x5c, 0x8210200f},
{0x60, 0xc2202548},
{0x64, 0x81c3e008},
{0x68, 0xda20257c},
{0x6c, 0x9de3bf98},
{0x70, 0x82102000},
{0x74, 0x80a04019},
{0x78, 0x16800015},
{0x7c, 0x9e100019},
{0xf0, 0x2d},
{0x00, 0xb6006001},
{0x04, 0x80a6c00f},
{0x08, 0x1680000f},
{0x0c, 0xba10001b},
{0x10, 0xb3286002},
{0x14, 0xb52f6002},
{0x18, 0xf8060019},
{0x1c, 0xc206001a},
{0x20, 0x80a70001},
{0x24, 0x04800004},
{0x28, 0xba076001},
{0x2c, 0xc2260019},
{0x30, 0xf826001a},
{0x34, 0x80a7400f},
{0x38, 0x06bffff8},
{0x3c, 0xb52f6002},
{0x40, 0x80a6c00f},
{0x44, 0x06bfffef},
{0x48, 0x8210001b},
{0x4c, 0x81c7e008},
{0x50, 0x81e80000},
{0x54, 0x033fc140},
{0x58, 0x82106048},
{0x5c, 0xda004000},
{0x60, 0x03000040},
{0x64, 0x808b4001},
{0x68, 0x03000016},
{0x6c, 0x12800003},
{0x70, 0x90106180},
{0x74, 0x901063a8},
{0x78, 0x81c3e008},
{0x7c, 0x01000000},
{0xf0, 0x2e},
{0x00, 0x9de3bf38},
{0x04, 0xa12e2002},
{0x08, 0x1b00003f},
{0x0c, 0xc20423d8},
{0x10, 0x9a1363ff},
{0x14, 0xb008400d},
{0x18, 0x97306010},
{0x1c, 0xc200247c},
{0x20, 0x9a22c018},
{0x24, 0x825e0001},
{0x28, 0x92836001},
{0x2c, 0x0280000c},
{0x30, 0xb0004019},
{0x34, 0x9a100009},
{0x38, 0x9807bf98},
{0x3c, 0x82060018},
{0x40, 0xc2168001},
{0x44, 0xc2230000},
{0x48, 0xc200247c},
{0x4c, 0xb0060001},
{0x50, 0x9a837fff},
{0x54, 0x12bffffa},
{0x58, 0x98032004},
{0x5c, 0x7fffffc4},
{0x60, 0x9007bf98},
{0x64, 0x0300003f},
{0x68, 0xda0423e8},
{0x6c, 0x821063ff},
{0x70, 0xb00b4001},
{0x74, 0x97336010},
{0x78, 0x80a6000b},
{0x7c, 0x92102000},
{0xf0, 0x2f},
{0x00, 0x1880000b},
{0x04, 0x9a100018},
{0x08, 0x832e2002},
{0x0c, 0x8200401e},
{0x10, 0x98007f98},
{0x14, 0xc2030000},
{0x18, 0x9a036001},
{0x1c, 0x92024001},
{0x20, 0x80a3400b},
{0x24, 0x08bffffc},
{0x28, 0x98032004},
{0x2c, 0xb022c018},
{0x30, 0xb0062001},
{0x34, 0x81800000},
{0x38, 0x01000000},
{0x3c, 0x01000000},
{0x40, 0x01000000},
{0x44, 0xb0724018},
{0x48, 0x81c7e008},
{0x4c, 0x81e80000},
{0x50, 0x832a2002},
{0x54, 0x82004008},
{0x58, 0x9b326002},
{0x5c, 0x8200400d},
{0x60, 0x83286002},
{0x64, 0x920a6003},
{0x68, 0x932a6003},
{0x6c, 0xd00065b0},
{0x70, 0x91320009},
{0x74, 0x81c3e008},
{0x78, 0x900a20ff},
{0x7c, 0x972a2002},
{0xf0, 0x30},
{0x00, 0x99326002},
{0x04, 0x9002c008},
{0x08, 0x9002000c},
{0x0c, 0x920a6003},
{0x10, 0x932a6003},
{0x14, 0x912a2002},
{0x18, 0x821020ff},
{0x1c, 0xda0225b0},
{0x20, 0x83284009},
{0x24, 0x822b4001},
{0x28, 0x952a8009},
{0x2c, 0x8210400a},
{0x30, 0xc22225b0},
{0x34, 0xda02e3a4},
{0x38, 0x992b2002},
{0x3c, 0x81c3e008},
{0x40, 0xc223400c},
{0x44, 0x9de3bf98},
{0x48, 0xda002310},
{0x4c, 0x80a36000},
{0x50, 0x02800049},
{0x54, 0xb0102000},
{0x58, 0xc2002594},
{0x5c, 0x82006001},
{0x60, 0x80a0400d},
{0x64, 0x0a800044},
{0x68, 0xc2202594},
{0x6c, 0xa4102000},
{0x70, 0xc20023d4},
{0x74, 0x80a48001},
{0x78, 0xc0202594},
{0x7c, 0xa2102000},
{0xf0, 0x31},
{0x00, 0x1a800028},
{0x04, 0xa72c6002},
{0x08, 0xc204e364},
{0x0c, 0x80a06000},
{0x10, 0x02800020},
{0x14, 0xa0102000},
{0x18, 0xc20022fc},
{0x1c, 0x80a40001},
{0x20, 0x1a80001c},
{0x24, 0x15000017},
{0x28, 0xc200255c},
{0x2c, 0xf00c2380},
{0x30, 0x9412a1d0},
{0x34, 0x90100011},
{0x38, 0x80a06000},
{0x3c, 0x02800007},
{0x40, 0x920e20ff},
{0x44, 0x7fffff84},
{0x48, 0x01000000},
{0x4c, 0x94100008},
{0x50, 0x90100011},
{0x54, 0x920e20ff},
{0x58, 0x7fffff8a},
{0x5c, 0xa0042001},
{0x60, 0xc204e364},
{0x64, 0xda002348},
{0x68, 0x98020001},
{0x6c, 0x82034001},
{0x70, 0x80a20001},
{0x74, 0x38bfffe9},
{0x78, 0xa404a001},
{0x7c, 0x80a3000d},
{0xf0, 0x32},
{0x00, 0x3abfffe7},
{0x04, 0xc20022fc},
{0x08, 0x10bfffe4},
{0x0c, 0xa404a001},
{0x10, 0xa2046001},
{0x14, 0xc20023d4},
{0x18, 0x10bfffda},
{0x1c, 0x80a44001},
{0x20, 0xd800258c},
{0x24, 0x80a0000c},
{0x28, 0x9a603fff},
{0x2c, 0x80a00012},
{0x30, 0x82603fff},
{0x34, 0x808b4001},
{0x38, 0x02800007},
{0x3c, 0x80a4a000},
{0x40, 0xc200255c},
{0x44, 0x80a00001},
{0x48, 0x82603fff},
{0x4c, 0xc220255c},
{0x50, 0x80a4a000},
{0x54, 0x12800004},
{0x58, 0x82032001},
{0x5c, 0x10800003},
{0x60, 0xc020258c},
{0x64, 0xc220258c},
{0x68, 0xc200258c},
{0x6c, 0x80a06003},
{0x70, 0xb0603fff},
{0x74, 0x81c7e008},
{0x78, 0x81e80000},
{0x7c, 0x9de3bf98},
{0xf0, 0x33},
{0x00, 0xc2002540},
{0x04, 0x80a06000},
{0x08, 0x0280002a},
{0x0c, 0xb0102000},
{0x10, 0xda002210},
{0x14, 0x80a36000},
{0x18, 0x02800026},
{0x1c, 0xb4102001},
{0x20, 0xde0022f8},
{0x24, 0x80a6800f},
{0x28, 0x18800018},
{0x2c, 0x03000018},
{0x30, 0x98106220},
{0x34, 0xf20022fc},
{0x38, 0xb6102007},
{0x3c, 0xb8102001},
{0x40, 0x80a70019},
{0x44, 0x1880000d},
{0x48, 0x832ee003},
{0x4c, 0x8200400c},
{0x50, 0xba006004},
{0x54, 0xc2074000},
{0x58, 0xb8072001},
{0x5c, 0x80a0400d},
{0x60, 0x14800003},
{0x64, 0xba076004},
{0x68, 0xb0062001},
{0x6c, 0x80a70019},
{0x70, 0x28bffffa},
{0x74, 0xc2074000},
{0x78, 0xb406a001},
{0x7c, 0x80a6800f},
{0xf0, 0x34},
{0x00, 0x08bfffef},
{0x04, 0xb606e007},
{0x08, 0xc21023ce},
{0x0c, 0x80a60001},
{0x10, 0x24800007},
{0x14, 0xc0202598},
{0x18, 0xc2002598},
{0x1c, 0x82006001},
{0x20, 0xc2202598},
{0x24, 0x10800003},
{0x28, 0xb0102001},
{0x2c, 0xb0102000},
{0x30, 0x81c7e008},
{0x34, 0x81e80000},
{0x38, 0x9a102005},
{0x3c, 0x8210200b},
{0x40, 0x9a234008},
{0x44, 0x82204008},
{0x48, 0x9b2b6002},
{0x4c, 0x80a22005},
{0x50, 0x14800007},
{0x54, 0x99286002},
{0x58, 0x033fc200},
{0x5c, 0x8210600c},
{0x60, 0xc2004000},
{0x64, 0x10800006},
{0x68, 0x8330400d},
{0x6c, 0x033fc200},
{0x70, 0x82106008},
{0x74, 0xc2004000},
{0x78, 0x8330400c},
{0x7c, 0x81c3e008},
{0xf0, 0x35},
{0x00, 0x9008600f},
{0x04, 0x9de3bf98},
{0x08, 0xc200247c},
{0x0c, 0x83306001},
{0x10, 0x80a60001},
{0x14, 0x1a800006},
{0x18, 0x90100018},
{0x1c, 0x7fffffe7},
{0x20, 0x01000000},
{0x24, 0x10800006},
{0x28, 0xb0020008},
{0x2c, 0x7fffffe3},
{0x30, 0x90260001},
{0x34, 0x90020008},
{0x38, 0xb0022001},
{0x3c, 0x81c7e008},
{0x40, 0x81e80000},
{0x44, 0x9de3bf98},
{0x48, 0xa8102000},
{0x4c, 0xc20023d4},
{0x50, 0x80a50001},
{0x54, 0x1a800057},
{0x58, 0xe2002348},
{0x5c, 0xa4102000},
{0x60, 0xc200247c},
{0x64, 0x80a48001},
{0x68, 0x3a80004e},
{0x6c, 0xa8052001},
{0x70, 0x7fffffe5},
{0x74, 0x90100012},
{0x78, 0x92100008},
{0x7c, 0x7fffff35},
{0xf0, 0x36},
{0x00, 0x90100014},
{0x04, 0x80a62000},
{0x08, 0x12800004},
{0x0c, 0xa0100008},
{0x10, 0x10800016},
{0x14, 0xa0102000},
{0x18, 0x80a62008},
{0x1c, 0x18800011},
{0x20, 0x80a62007},
{0x24, 0x7ffffeec},
{0x28, 0x01000000},
{0x2c, 0x94100008},
{0x30, 0x90100014},
{0x34, 0x7ffffef3},
{0x38, 0x921ca001},
{0x3c, 0x80a20011},
{0x40, 0x04800007},
{0x44, 0xa6100008},
{0x48, 0x9a102008},
{0x4c, 0x9a234018},
{0x50, 0x82102001},
{0x54, 0x8328400d},
{0x58, 0xa02c0001},
{0x5c, 0x80a62007},
{0x60, 0x18800008},
{0x64, 0x80a62008},
{0x68, 0x9a102007},
{0x6c, 0x9a234018},
{0x70, 0x82102001},
{0x74, 0x8328400d},
{0x78, 0x10800022},
{0x7c, 0xa0140001},
{0xf0, 0x37},
{0x00, 0x1280000a},
{0x04, 0x821e2009},
{0x08, 0x80a420fe},
{0x0c, 0x24800002},
{0x10, 0xa0042001},
{0x14, 0x03000018},
{0x18, 0x9b2ca002},
{0x1c, 0x82106220},
{0x20, 0x10800018},
{0x24, 0xe6234001},
{0x28, 0x80a00001},
{0x2c, 0x9a603fff},
{0x30, 0x80a420fe},
{0x34, 0x04800003},
{0x38, 0x82102001},
{0x3c, 0x82102000},
{0x40, 0x808b4001},
{0x44, 0x0280000f},
{0x48, 0x03000018},
{0x4c, 0x9b2ca002},
{0x50, 0x82106220},
{0x54, 0xc2034001},
{0x58, 0x80a04011},
{0x5c, 0x18800003},
{0x60, 0x9a204011},
{0x64, 0x9a244001},
{0x68, 0x80a4c011},
{0x6c, 0x14800003},
{0x70, 0x8224c011},
{0x74, 0x82244013},
{0x78, 0x80a34001},
{0x7c, 0xa0642000},
{0xf0, 0x38},
{0x00, 0x7fffffa1},
{0x04, 0x90100012},
{0x08, 0x92100008},
{0x0c, 0x90100014},
{0x10, 0x7ffffefb},
{0x14, 0x94100010},
{0x18, 0x10bfffb2},
{0x1c, 0xa404a001},
{0x20, 0xc20023d4},
{0x24, 0x80a50001},
{0x28, 0x0abfffae},
{0x2c, 0xa4102000},
{0x30, 0x81c7e008},
{0x34, 0x81e80000},
{0x38, 0x033fc200},
{0x3c, 0x961060a0},
{0x40, 0x98102000},
{0x44, 0x832b2002},
{0x48, 0x9a03000c},
{0x4c, 0xda136400},
{0x50, 0x98032001},
{0x54, 0x80a32016},
{0x58, 0x04bffffb},
{0x5c, 0xda20400b},
{0x60, 0x81c3e008},
{0x64, 0x01000000},
{0x68, 0x9de3bf98},
{0x6c, 0xc2002544},
{0x70, 0x82006001},
{0x74, 0xc2202544},
{0x78, 0x03000017},
{0x7c, 0xb41063f8},
{0xf0, 0x39},
{0x00, 0x9e100018},
{0x04, 0x031fffdf},
{0x08, 0xb01063ff},
{0x0c, 0xba102000},
{0x10, 0xb72f6002},
{0x14, 0xc2002544},
{0x18, 0x80a06009},
{0x1c, 0xb2076001},
{0x20, 0x12800007},
{0x24, 0xb810001b},
{0x28, 0xc206c01a},
{0x2c, 0x83306001},
{0x30, 0x82084018},
{0x34, 0xc226c01a},
{0x38, 0xc2002544},
{0x3c, 0x80a06008},
{0x40, 0x08800006},
{0x44, 0xc207001a},
{0x48, 0xfa03c01c},
{0x4c, 0xbb376001},
{0x50, 0x10800003},
{0x54, 0xba0f4018},
{0x58, 0xfa03c01c},
{0x5c, 0x8200401d},
{0x60, 0xc227001a},
{0x64, 0x80a66089},
{0x68, 0x08bfffea},
{0x6c, 0xba100019},
{0x70, 0x81c7e008},
{0x74, 0x81e80000},
{0x78, 0x9de3bf98},
{0x7c, 0x9e102001},
{0xf0, 0x3a},
{0x00, 0xc20022fc},
{0x04, 0x80a3c001},
{0x08, 0x1880002a},
{0x0c, 0x03000018},
{0x10, 0x82106220},
{0x14, 0x9a006004},
{0x18, 0x19000017},
{0x1c, 0xc20022f8},
{0x20, 0xb6102001},
{0x24, 0x80a6c001},
{0x28, 0xb21323f8},
{0x2c, 0xb41321d0},
{0x30, 0x1880001b},
{0x34, 0xc20be37f},
{0x38, 0xb0004001},
{0x3c, 0xb8036038},
{0x40, 0xc2002544},
{0x44, 0xb606e001},
{0x48, 0x80a06008},
{0x4c, 0x08800003},
{0x50, 0xfa164018},
{0x54, 0xba07401d},
{0x58, 0x81800000},
{0x5c, 0xc2002548},
{0x60, 0x01000000},
{0x64, 0x01000000},
{0x68, 0x82774001},
{0x6c, 0xba100001},
{0x70, 0xc2168018},
{0x74, 0xba274001},
{0x78, 0xfa270000},
{0x7c, 0xc200247c},
{0xf0, 0x3b},
{0x00, 0x82004001},
{0x04, 0xfa0022f8},
{0x08, 0xb4068001},
{0x0c, 0x80a6c01d},
{0x10, 0xb2064001},
{0x14, 0x08bfffeb},
{0x18, 0xb8072038},
{0x1c, 0x9e03e001},
{0x20, 0xc20022fc},
{0x24, 0x80a3c001},
{0x28, 0x08bfffdd},
{0x2c, 0x9a036004},
{0x30, 0x81c7e008},
{0x34, 0x81e80000},
{0x38, 0xc2002540},
{0x3c, 0x80a06000},
{0x40, 0x0280000f},
{0x44, 0x1b3fc200},
{0x48, 0xc2002298},
{0x4c, 0x9a136070},
{0x50, 0xc2234000},
{0x54, 0x03000017},
{0x58, 0xc0202540},
{0x5c, 0xc0202544},
{0x60, 0x981063f8},
{0x64, 0x9a102000},
{0x68, 0x832b6002},
{0x6c, 0x9a036001},
{0x70, 0x80a36089},
{0x74, 0x08bffffd},
{0x78, 0xc020400c},
{0x7c, 0x81c3e008},
{0xf0, 0x3c},
{0x00, 0x01000000},
{0x04, 0xc200247c},
{0x08, 0xda0022f8},
{0x0c, 0x8258400d},
{0x10, 0x97306001},
{0x14, 0x98102000},
{0x18, 0x80a3000b},
{0x1c, 0x1680000e},
{0x20, 0x1b000017},
{0x24, 0x0307ffc7},
{0x28, 0x901363f8},
{0x2c, 0x921063ff},
{0x30, 0x941361d0},
{0x34, 0x9b2b2002},
{0x38, 0xc2034008},
{0x3c, 0x83306003},
{0x40, 0x82084009},
{0x44, 0x98032001},
{0x48, 0x80a3000b},
{0x4c, 0x06bffffa},
{0x50, 0xc223400a},
{0x54, 0x03000018},
{0x58, 0x9a106220},
{0x5c, 0x98102000},
{0x60, 0x832b2002},
{0x64, 0x98032001},
{0x68, 0x80a322d5},
{0x6c, 0x04bffffd},
{0x70, 0xc020400d},
{0x74, 0x81c3e008},
{0x78, 0x01000000},
{0x7c, 0x00000000},
{0xf0, 0x3d},
{0x00, 0x82102020},
{0x04, 0x82204009},
{0x08, 0x80a06040},
{0x0c, 0x04800003},
{0x10, 0x9a100008},
{0x14, 0x90023fff},
{0x18, 0x80a06080},
{0x1c, 0x34800002},
{0x20, 0x90037ffe},
{0x24, 0x80a06000},
{0x28, 0x24800002},
{0x2c, 0x90036001},
{0x30, 0x80a07fc0},
{0x34, 0x24800002},
{0x38, 0x90036002},
{0x3c, 0x81c3e008},
{0x40, 0x01000000},
{0x44, 0x900221ff},
{0x48, 0x833a201f},
{0x4c, 0x8330601a},
{0x50, 0x82020001},
{0x54, 0x82087fc0},
{0x58, 0x90220001},
{0x5c, 0x81c3e008},
{0x60, 0x90022001},
{0x64, 0x9de3bf80},
{0x68, 0x90102020},
{0x6c, 0x7ffffff6},
{0x70, 0x90220018},
{0x74, 0x82102041},
{0x78, 0x82204008},
{0x7c, 0x9b2ea003},
{0xf0, 0x3e},
{0x00, 0x98004001},
{0x04, 0x9a23401a},
{0x08, 0x98030001},
{0x0c, 0x9a03400d},
{0x10, 0x9a03401b},
{0x14, 0x03000018},
{0x18, 0x82106220},
{0x1c, 0x9b2b6002},
{0x20, 0x9a034001},
{0x24, 0xc2002300},
{0x28, 0x96020008},
{0x2c, 0x9602c008},
{0x30, 0xaa006001},
{0x34, 0xc2002308},
{0x38, 0xa52ae003},
{0x3c, 0xa8006001},
{0x40, 0xa72b2003},
{0x44, 0x96037ff8},
{0x48, 0xa0103ffe},
{0x4c, 0xb0102000},
{0x50, 0x94103ffe},
{0x54, 0xa206c010},
{0x58, 0x9804ecfc},
{0x5c, 0x9e04ace8},
{0x60, 0x9202ff90},
{0x64, 0x8206800a},
{0x68, 0x80a54001},
{0x6c, 0x9a603fff},
{0x70, 0x80a50011},
{0x74, 0x82603fff},
{0x78, 0x808b4001},
{0x7c, 0x02800003},
{0xf0, 0x3f},
{0x00, 0x9a102000},
{0x04, 0xda024000},
{0x08, 0x80a22020},
{0x0c, 0x34800003},
{0x10, 0xc2030000},
{0x14, 0xc203c000},
{0x18, 0x825b4001},
{0x1c, 0x9402a001},
{0x20, 0xb0060001},
{0x24, 0x92026038},
{0x28, 0x9e03e004},
{0x2c, 0x80a2a003},
{0x30, 0x04bfffed},
{0x34, 0x98033ffc},
{0x38, 0x832c2002},
{0x3c, 0x8200401e},
{0x40, 0xa0042001},
{0x44, 0xf0207fe8},
{0x48, 0x80a42003},
{0x4c, 0x04bfffe0},
{0x50, 0x9602e004},
{0x54, 0xd207bfe0},
{0x58, 0xd407bfe4},
{0x5c, 0xd607bfe8},
{0x60, 0xd807bfec},
{0x64, 0xda07bff0},
{0x68, 0xc207bff4},
{0x6c, 0x933a6008},
{0x70, 0x953aa008},
{0x74, 0x973ae008},
{0x78, 0x993b2008},
{0x7c, 0x9b3b6008},
{0xf0, 0x40},
{0x00, 0x83386008},
{0x04, 0x90102020},
{0x08, 0xd227bfe0},
{0x0c, 0xd427bfe4},
{0x10, 0xd627bfe8},
{0x14, 0xd827bfec},
{0x18, 0xda27bff0},
{0x1c, 0xc227bff4},
{0x20, 0x7fffffa9},
{0x24, 0x90220019},
{0x28, 0x80a22020},
{0x2c, 0x14800011},
{0x30, 0xb0102000},
{0x34, 0x82020008},
{0x38, 0x82004008},
{0x3c, 0x83286003},
{0x40, 0x90006ce8},
{0x44, 0x9807bfe0},
{0x48, 0x94102005},
{0x4c, 0xc2030000},
{0x50, 0xda020000},
{0x54, 0x8258400d},
{0x58, 0xb0060001},
{0x5c, 0x98032004},
{0x60, 0x9482bfff},
{0x64, 0x1cbffffa},
{0x68, 0x90022004},
{0x6c, 0x30800011},
{0x70, 0x82102041},
{0x74, 0x90204008},
{0x78, 0x82020008},
{0x7c, 0x82004008},
{0xf0, 0x41},
{0x00, 0x83286003},
{0x04, 0x90006cfc},
{0x08, 0x9807bfe0},
{0x0c, 0x94102005},
{0x10, 0xc2030000},
{0x14, 0xda020000},
{0x18, 0x8258400d},
{0x1c, 0xb0060001},
{0x20, 0x98032004},
{0x24, 0x9482bfff},
{0x28, 0x1cbffffa},
{0x2c, 0x90023ffc},
{0x30, 0x81c7e008},
{0x34, 0x81e80000},
{0x38, 0x9de3bf98},
{0x3c, 0x9010001a},
{0x40, 0x7fffff70},
{0x44, 0x92100018},
{0x48, 0xb4100008},
{0x4c, 0x9010001b},
{0x50, 0x7fffff6c},
{0x54, 0x92100019},
{0x58, 0x7fffff83},
{0x5c, 0x97e80008},
{0x60, 0x01000000},
{0x64, 0x9de3bf90},
{0x68, 0xa8102000},
{0x6c, 0xf427a04c},
{0x70, 0xaa102000},
{0x74, 0xac102000},
{0x78, 0xae102010},
{0x7c, 0xe827bff4},
{0xf0, 0x42},
{0x00, 0xb4250017},
{0x04, 0x9210001a},
{0x08, 0x94100018},
{0x0c, 0x96100019},
{0x10, 0x7fffffea},
{0x14, 0x90100015},
{0x18, 0xa6100008},
{0x1c, 0xb6254017},
{0x20, 0x92100014},
{0x24, 0x94100018},
{0x28, 0x96100019},
{0x2c, 0x7fffffe3},
{0x30, 0x9010001b},
{0x34, 0xa4100008},
{0x38, 0xb8050017},
{0x3c, 0x9210001c},
{0x40, 0x94100018},
{0x44, 0x96100019},
{0x48, 0x7fffffdc},
{0x4c, 0x90100015},
{0x50, 0xa2100008},
{0x54, 0xba054017},
{0x58, 0x92100014},
{0x5c, 0x94100018},
{0x60, 0x96100019},
{0x64, 0x7fffffd5},
{0x68, 0x9010001d},
{0x6c, 0xa0100008},
{0x70, 0x90100015},
{0x74, 0x92100014},
{0x78, 0x94100018},
{0x7c, 0x7fffffcf},
{0xf0, 0x43},
{0x00, 0x96100019},
{0x04, 0xa624c008},
{0x08, 0xa0240008},
{0x0c, 0xa4248008},
{0x10, 0xa2244008},
{0x14, 0x80a4e000},
{0x18, 0x04800004},
{0x1c, 0x82102000},
{0x20, 0x82100013},
{0x24, 0xac102001},
{0x28, 0x80a48001},
{0x2c, 0x04800005},
{0x30, 0x80a44001},
{0x34, 0x82100012},
{0x38, 0xac102003},
{0x3c, 0x80a44001},
{0x40, 0x04800005},
{0x44, 0x80a40001},
{0x48, 0x82100011},
{0x4c, 0xac102005},
{0x50, 0x80a40001},
{0x54, 0x04800005},
{0x58, 0x80a06000},
{0x5c, 0x82100010},
{0x60, 0xac102007},
{0x64, 0x80a06000},
{0x68, 0x14800017},
{0x6c, 0x80a5a001},
{0x70, 0x80a5e020},
{0x74, 0x12800004},
{0x78, 0x80a5e010},
{0x7c, 0x10800020},
{0xf0, 0x44},
{0x00, 0xae102010},
{0x04, 0x12800004},
{0x08, 0x80a5e008},
{0x0c, 0x1080001c},
{0x10, 0xae102008},
{0x14, 0x12800004},
{0x18, 0x80a5e004},
{0x1c, 0x10800018},
{0x20, 0xae102004},
{0x24, 0x12800004},
{0x28, 0x80a5e002},
{0x2c, 0x10800014},
{0x30, 0xae102002},
{0x34, 0x12800018},
{0x38, 0x832e2006},
{0x3c, 0x10800010},
{0x40, 0xae102001},
{0x44, 0x12800004},
{0x48, 0x80a5a003},
{0x4c, 0x1080000c},
{0x50, 0xa810001a},
{0x54, 0x12800004},
{0x58, 0x80a5a005},
{0x5c, 0x10800008},
{0x60, 0xaa10001b},
{0x64, 0x12800004},
{0x68, 0x80a5a007},
{0x6c, 0x10800004},
{0x70, 0xa810001c},
{0x74, 0x22800002},
{0x78, 0xaa10001d},
{0x7c, 0xc207bff4},
{0xf0, 0x45},
{0x00, 0x82006001},
{0x04, 0x80a0607f},
{0x08, 0x04bfff9e},
{0x0c, 0xc227bff4},
{0x10, 0x832e2006},
{0x14, 0xaa054001},
{0x18, 0x82380015},
{0x1c, 0x8338601f},
{0x20, 0xaa0d4001},
{0x24, 0x9b2e6006},
{0x28, 0xc2002308},
{0x2c, 0xa885000d},
{0x30, 0x1c800004},
{0x34, 0x83286006},
{0x38, 0x10800005},
{0x3c, 0xa8102000},
{0x40, 0x80a50001},
{0x44, 0x38800002},
{0x48, 0xa8100001},
{0x4c, 0x9a0d2fff},
{0x50, 0x832d6010},
{0x54, 0x8210400d},
{0x58, 0xd807a04c},
{0x5c, 0x9b2b2002},
{0x60, 0xc2236768},
{0x64, 0x81c7e008},
{0x68, 0x81e80000},
{0x6c, 0x9de3bf98},
{0x70, 0xfa50245a},
{0x74, 0x80a76000},
{0x78, 0x0280003d},
{0x7c, 0x9e102001},
{0xf0, 0x46},
{0x00, 0xc20022fc},
{0x04, 0x80a3c001},
{0x08, 0x18800039},
{0x0c, 0x17000018},
{0x10, 0x8212e220},
{0x14, 0x9810001d},
{0x18, 0x9a006004},
{0x1c, 0xb6102001},
{0x20, 0xf20022f8},
{0x24, 0x80a6c019},
{0x28, 0xb4102000},
{0x2c, 0x1880002b},
{0x30, 0x82102000},
{0x34, 0xf0502458},
{0x38, 0xba036038},
{0x3c, 0xf8074000},
{0x40, 0xb606e001},
{0x44, 0x80a70018},
{0x48, 0x06800004},
{0x4c, 0xba076038},
{0x50, 0xb406801c},
{0x54, 0x82006001},
{0x58, 0x80a6c019},
{0x5c, 0x28bffff9},
{0x60, 0xf8074000},
{0x64, 0x80a06000},
{0x68, 0x2280001d},
{0x6c, 0x9e03e001},
{0x70, 0x953ea01f},
{0x74, 0x8182a000},
{0x78, 0x01000000},
{0x7c, 0x01000000},
{0xf0, 0x47},
{0x00, 0x01000000},
{0x04, 0x827e8001},
{0x08, 0x8258400c},
{0x0c, 0xbb38601f},
{0x10, 0xbb376016},
{0x14, 0x8200401d},
{0x18, 0xb6102001},
{0x1c, 0xfa0022f8},
{0x20, 0x80a6c01d},
{0x24, 0x1880000d},
{0x28, 0xb538600a},
{0x2c, 0x832be002},
{0x30, 0xba006038},
{0x34, 0xb812e220},
{0x38, 0xc207401c},
{0x3c, 0x8220401a},
{0x40, 0xc227401c},
{0x44, 0xb606e001},
{0x48, 0xc20022f8},
{0x4c, 0x80a6c001},
{0x50, 0x08bffffa},
{0x54, 0xba076038},
{0x58, 0x9e03e001},
{0x5c, 0xc20022fc},
{0x60, 0x80a3c001},
{0x64, 0x08bfffce},
{0x68, 0x9a036004},
{0x6c, 0x81c7e008},
{0x70, 0x81e80000},
{0x74, 0x9de3bf48},
{0x78, 0x1b00003f},
{0x7c, 0xc2002350},
{0xf0, 0x48},
{0x00, 0x9a1363ff},
{0x04, 0xba08400d},
{0x08, 0xa4102001},
{0x0c, 0xda0022f8},
{0x10, 0x80a4800d},
{0x14, 0x18800063},
{0x18, 0xa3306010},
{0x1c, 0xae10200e},
{0x20, 0xac10200e},
{0x24, 0xaa102000},
{0x28, 0xa8102000},
{0x2c, 0xa6102000},
{0x30, 0x80a46000},
{0x34, 0x02800033},
{0x38, 0xa0102000},
{0x3c, 0x03000018},
{0x40, 0x96106220},
{0x44, 0x92102000},
{0x48, 0x9807bfa8},
{0x4c, 0x8204c009},
{0x50, 0xda086440},
{0x54, 0x8205800d},
{0x58, 0x80a36000},
{0x5c, 0x02800007},
{0x60, 0x83286002},
{0x64, 0xc200400b},
{0x68, 0xc2230000},
{0x6c, 0x92026001},
{0x70, 0x10bffff7},
{0x74, 0x98032004},
{0x78, 0x7ffffc7d},
{0x7c, 0x9007bfa8},
{0xf0, 0x49},
{0x00, 0x80a74011},
{0x04, 0x1480000b},
{0x08, 0x9210001d},
{0x0c, 0x832f6002},
{0x10, 0x8200401e},
{0x14, 0x9a007fa8},
{0x18, 0xc2034000},
{0x1c, 0x92026001},
{0x20, 0xa0040001},
{0x24, 0x80a24011},
{0x28, 0x04bffffc},
{0x2c, 0x9a036004},
{0x30, 0x8224401d},
{0x34, 0x82006001},
{0x38, 0x9b3c201f},
{0x3c, 0x81836000},
{0x40, 0x01000000},
{0x44, 0x01000000},
{0x48, 0x01000000},
{0x4c, 0xa0fc0001},
{0x50, 0x36800007},
{0x54, 0xda0023c4},
{0x58, 0xc20023c8},
{0x5c, 0x80886020},
{0x60, 0x22800026},
{0x64, 0xaa056001},
{0x68, 0xda0023c4},
{0x6c, 0x9a5c000d},
{0x70, 0x833b601f},
{0x74, 0x83306018},
{0x78, 0x9a034001},
{0x7c, 0xa13b6008},
{0xf0, 0x4a},
{0x00, 0x92102000},
{0x04, 0x11000018},
{0x08, 0x82050009},
{0x0c, 0xda086440},
{0x10, 0x8205c00d},
{0x14, 0x94122220},
{0x18, 0x97286002},
{0x1c, 0x80a36000},
{0x20, 0x02800015},
{0x24, 0x92026001},
{0x28, 0xc202c00a},
{0x2c, 0x98204010},
{0x30, 0xda0822b0},
{0x34, 0x833b201f},
{0x38, 0x80a0000d},
{0x3c, 0x8220400c},
{0x40, 0x9a402000},
{0x44, 0x8330601f},
{0x48, 0x808b4001},
{0x4c, 0x22bfffef},
{0x50, 0xd822c00a},
{0x54, 0xda0ca2b0},
{0x58, 0x9a5b000d},
{0x5c, 0x833b601f},
{0x60, 0x83306019},
{0x64, 0x9a034001},
{0x68, 0x993b6007},
{0x6c, 0x10bfffe7},
{0x70, 0xd822c00a},
{0x74, 0xaa056001},
{0x78, 0xa604e00c},
{0x7c, 0x80a56001},
{0xf0, 0x4b},
{0x00, 0x04bfffac},
{0x04, 0xa805200c},
{0x08, 0xa404a001},
{0x0c, 0xc20022f8},
{0x10, 0x80a48001},
{0x14, 0xac05a00e},
{0x18, 0x08bfffa3},
{0x1c, 0xae05e00e},
{0x20, 0x81c7e008},
{0x24, 0x81e80000},
{0x28, 0x9de3bf98},
{0x2c, 0xc21023b6},
{0x30, 0xf81023be},
{0x34, 0x96102001},
{0x38, 0xfa0022f8},
{0x3c, 0x80a2c01d},
{0x40, 0xa8004001},
{0x44, 0xa407001c},
{0x48, 0x18800088},
{0x4c, 0xe6002214},
{0x50, 0x90102038},
{0x54, 0x92102038},
{0x58, 0x9810200e},
{0x5c, 0x15000018},
{0x60, 0xb8102001},
{0x64, 0xc20022fc},
{0x68, 0x80a70001},
{0x6c, 0x38800079},
{0x70, 0x9602e001},
{0x74, 0x2f000018},
{0x78, 0xac12a220},
{0x7c, 0xaa12a224},
{0xf0, 0x4c},
{0x00, 0x8203001c},
{0x04, 0xb7286002},
{0x08, 0xfa06c016},
{0x0c, 0x80a74013},
{0x10, 0x2480006b},
{0x14, 0xb8072001},
{0x18, 0x80a74014},
{0x1c, 0x16800014},
{0x20, 0x83286002},
{0x24, 0x80a74012},
{0x28, 0x06800007},
{0x2c, 0x8215e21c},
{0x30, 0xc206c015},
{0x34, 0x80a04012},
{0x38, 0x1680000c},
{0x3c, 0x8203001c},
{0x40, 0x8215e21c},
{0x44, 0xc206c001},
{0x48, 0x80a74001},
{0x4c, 0x2680005c},
{0x50, 0xb8072001},
{0x54, 0xc206c015},
{0x58, 0x80a74001},
{0x5c, 0x24800058},
{0x60, 0xb8072001},
{0x64, 0x8203001c},
{0x68, 0x83286002},
{0x6c, 0xfa0023c8},
{0x70, 0x808f6040},
{0x74, 0xf0004016},
{0x78, 0x0280000b},
{0x7c, 0xa2072001},
{0xf0, 0x4d},
{0x00, 0xfa0022fc},
{0x04, 0x83376001},
{0x08, 0x80a70001},
{0x0c, 0x28800007},
{0x10, 0x9a102000},
{0x14, 0x8227401c},
{0x18, 0xb8006001},
{0x1c, 0x10800003},
{0x20, 0x9a102001},
{0x24, 0x9a102000},
{0x28, 0xfa00221c},
{0x2c, 0xc2002220},
{0x30, 0xba5f401c},
{0x34, 0xba074001},
{0x38, 0xba5e001d},
{0x3c, 0x833f601f},
{0x40, 0x83306016},
{0x44, 0xba074001},
{0x48, 0xc2002224},
{0x4c, 0x8258401c},
{0x50, 0xbb3f600a},
{0x54, 0xba074001},
{0x58, 0xc2002240},
{0x5c, 0xb0074001},
{0x60, 0xc2002218},
{0x64, 0xb6070001},
{0x68, 0xa012a220},
{0x6c, 0xb92ee002},
{0x70, 0xba10001c},
{0x74, 0xb2024010},
{0x78, 0x9e020010},
{0x7c, 0xc20023c8},
{0xf0, 0x4e},
{0x00, 0x80886040},
{0x04, 0xb806401c},
{0x08, 0x02800007},
{0x0c, 0xb403c01d},
{0x10, 0xc20022fc},
{0x14, 0x83306001},
{0x18, 0x80a6c001},
{0x1c, 0x38800027},
{0x20, 0xb8100011},
{0x24, 0xfa0022fc},
{0x28, 0x8227401b},
{0x2c, 0x83286002},
{0x30, 0x80a6c01d},
{0x34, 0x18800020},
{0x38, 0x82064001},
{0x3c, 0x80a36000},
{0x40, 0x32800002},
{0x44, 0xb8006004},
{0x48, 0xc2070000},
{0x4c, 0x82204018},
{0x50, 0xc2270000},
{0x54, 0xfa002228},
{0x58, 0x8226c01d},
{0x5c, 0x80a6c01d},
{0x60, 0x04800013},
{0x64, 0xb85e0001},
{0x68, 0x80a36000},
{0x6c, 0x22800008},
{0x70, 0xc200222c},
{0x74, 0xc20022fc},
{0x78, 0x8220401b},
{0x7c, 0x83286002},
{0xf0, 0x4f},
{0x00, 0x8203c001},
{0x04, 0xb4006004},
{0x08, 0xc200222c},
{0x0c, 0x825f0001},
{0x10, 0xbb38601f},
{0x14, 0xbb376018},
{0x18, 0x8200401d},
{0x1c, 0xfa068000},
{0x20, 0x83386008},
{0x24, 0xba274001},
{0x28, 0xfa268000},
{0x2c, 0x10bfffd0},
{0x30, 0xb606e001},
{0x34, 0xb8100011},
{0x38, 0xb8072001},
{0x3c, 0xc20022fc},
{0x40, 0x80a70001},
{0x44, 0x08bfff90},
{0x48, 0x8203001c},
{0x4c, 0x9602e001},
{0x50, 0xc20022f8},
{0x54, 0x80a2c001},
{0x58, 0x9803200e},
{0x5c, 0x92026038},
{0x60, 0x08bfff80},
{0x64, 0x90022038},
{0x68, 0x81c7e008},
{0x6c, 0x81e80000},
{0x70, 0x9de3bf98},
{0x74, 0xc21023b6},
{0x78, 0xf81023be},
{0x7c, 0x96102001},
{0xf0, 0x50},
{0x00, 0xfa0022fc},
{0x04, 0x80a2c01d},
{0x08, 0xa0004001},
{0x0c, 0x9207001c},
{0x10, 0x1880005e},
{0x14, 0xd0002214},
{0x18, 0x15000018},
{0x1c, 0x9a102001},
{0x20, 0xc20022f8},
{0x24, 0x80a34001},
{0x28, 0x18800053},
{0x2c, 0x832ae002},
{0x30, 0xb2006038},
{0x34, 0x27000018},
{0x38, 0xa412a220},
{0x3c, 0xa212a258},
{0x40, 0xfa064012},
{0x44, 0x80a74008},
{0x48, 0x24800047},
{0x4c, 0x9a036001},
{0x50, 0x80a74010},
{0x54, 0x36800013},
{0x58, 0xfa00221c},
{0x5c, 0x80a74009},
{0x60, 0x06800007},
{0x64, 0x8214e1e8},
{0x68, 0xc2064011},
{0x6c, 0x80a04009},
{0x70, 0x3680000c},
{0x74, 0xfa00221c},
{0x78, 0x8214e1e8},
{0x7c, 0xc2064001},
{0xf0, 0x51},
{0x00, 0x80a74001},
{0x04, 0x26800038},
{0x08, 0x9a036001},
{0x0c, 0xc2064011},
{0x10, 0x80a74001},
{0x14, 0x24800034},
{0x18, 0x9a036001},
{0x1c, 0xfa00221c},
{0x20, 0xc2002220},
{0x24, 0xba5f400d},
{0x28, 0xba074001},
{0x2c, 0xf8064012},
{0x30, 0xba5f001d},
{0x34, 0x833f601f},
{0x38, 0x83306016},
{0x3c, 0xba074001},
{0x40, 0xc2002224},
{0x44, 0x8258400d},
{0x48, 0xbb3f600a},
{0x4c, 0xba074001},
{0x50, 0xc2002218},
{0x54, 0xb6034001},
{0x58, 0xc2002240},
{0x5c, 0xb8074001},
{0x60, 0xc20022f8},
{0x64, 0x80a6c001},
{0x68, 0x1880001c},
{0x6c, 0x832ee003},
{0x70, 0x8220401b},
{0x74, 0x82004001},
{0x78, 0x8200400b},
{0x7c, 0xb5286002},
{0xf0, 0x52},
{0x00, 0x9812a220},
{0x04, 0xc206800c},
{0x08, 0x9e20401c},
{0x0c, 0xde26800c},
{0x10, 0xfa002228},
{0x14, 0x8226c01d},
{0x18, 0x80a6c01d},
{0x1c, 0xb05f0001},
{0x20, 0x0480000a},
{0x24, 0xb606e001},
{0x28, 0xc200222c},
{0x2c, 0x825e0001},
{0x30, 0xbb38601f},
{0x34, 0xbb376018},
{0x38, 0x8200401d},
{0x3c, 0x83386008},
{0x40, 0x8223c001},
{0x44, 0xc226800c},
{0x48, 0xc20022f8},
{0x4c, 0x80a6c001},
{0x50, 0x08bfffed},
{0x54, 0xb406a038},
{0x58, 0x9a036001},
{0x5c, 0xb2066038},
{0x60, 0x9a036001},
{0x64, 0xc20022f8},
{0x68, 0x80a34001},
{0x6c, 0x08bfffb5},
{0x70, 0xb2066038},
{0x74, 0x9602e001},
{0x78, 0xc20022fc},
{0x7c, 0x80a2c001},
{0xf0, 0x53},
{0x00, 0x08bfffa8},
{0x04, 0x9a102001},
{0x08, 0x81c7e008},
{0x0c, 0x81e80000},
{0x10, 0xc2002214},
{0x14, 0x80a06000},
{0x18, 0x0280000c},
{0x1c, 0x01000000},
{0x20, 0xc20023c8},
{0x24, 0x80886010},
{0x28, 0x02800005},
{0x2c, 0x01000000},
{0x30, 0x03000009},
{0x34, 0x81c061a8},
{0x38, 0x01000000},
{0x3c, 0x03000009},
{0x40, 0x81c063f0},
{0x44, 0x01000000},
{0x48, 0x01000000},
{0x4c, 0x81c3e008},
{0x50, 0x01000000},
{0x54, 0x9de3bf98},
{0x58, 0xb0102001},
{0x5c, 0xda002200},
{0x60, 0x80a6000d},
{0x64, 0x1880001d},
{0x68, 0xc0202504},
{0x6c, 0x03000018},
{0x70, 0x98106220},
{0x74, 0xde0022fc},
{0x78, 0xb2102007},
{0x7c, 0xb6102001},
{0xf0, 0x54},
{0x00, 0x80a6c00f},
{0x04, 0x18800011},
{0x08, 0x832e6003},
{0x0c, 0x8200400c},
{0x10, 0xba006004},
{0x14, 0xf4002238},
{0x18, 0xc2074000},
{0x1c, 0xb606e001},
{0x20, 0xba076004},
{0x24, 0x80a0401a},
{0x28, 0x08800005},
{0x2c, 0xb820401a},
{0x30, 0xc2002504},
{0x34, 0x8200401c},
{0x38, 0xc2202504},
{0x3c, 0x80a6c00f},
{0x40, 0x28bffff7},
{0x44, 0xc2074000},
{0x48, 0xb0062001},
{0x4c, 0x80a6000d},
{0x50, 0x08bfffeb},
{0x54, 0xb2066007},
{0x58, 0xfa002504},
{0x5c, 0xc200223c},
{0x60, 0x80a74001},
{0x64, 0x28800004},
{0x68, 0xc0202568},
{0x6c, 0x82102001},
{0x70, 0xc2202568},
{0x74, 0x033fc180},
{0x78, 0xfa002568},
{0x7c, 0x8210602c},
{0xf0, 0x55},
{0x00, 0xfa204000},
{0x04, 0xfa202570},
{0x08, 0x81c7e008},
{0x0c, 0x81e80000},
{0x10, 0x9de3bf70},
{0x14, 0x92102001},
{0x18, 0xd0002300},
{0x1c, 0x80a24008},
{0x20, 0x1880001c},
{0x24, 0x9e102000},
{0x28, 0x03000018},
{0x2c, 0xa2106220},
{0x30, 0xd4002308},
{0x34, 0x98102007},
{0x38, 0x96102001},
{0x3c, 0x80a2c00a},
{0x40, 0x38800011},
{0x44, 0x92026001},
{0x48, 0x832b2003},
{0x4c, 0x82004011},
{0x50, 0x82006004},
{0x54, 0xda004000},
{0x58, 0x80a3400f},
{0x5c, 0x04800005},
{0x60, 0x82006004},
{0x64, 0x9e10000d},
{0x68, 0xa0100009},
{0x6c, 0xa410000b},
{0x70, 0x9602e001},
{0x74, 0x80a2c00a},
{0x78, 0x28bffff8},
{0x7c, 0xda004000},
{0xf0, 0x56},
{0x00, 0x92026001},
{0x04, 0x80a24008},
{0x08, 0x08bfffec},
{0x0c, 0x98032007},
{0x10, 0xa2042001},
{0x14, 0x92043fff},
{0x18, 0x80a24011},
{0x1c, 0x1480002e},
{0x20, 0x9e102000},
{0x24, 0x832a6003},
{0x28, 0x90204009},
{0x2c, 0x03000018},
{0x30, 0xa6106220},
{0x34, 0xa004a001},
{0x38, 0x9604bfff},
{0x3c, 0x80a2c010},
{0x40, 0x14800021},
{0x44, 0x82020008},
{0x48, 0x8200400b},
{0x4c, 0x9b2be002},
{0x50, 0x83286002},
{0x54, 0x9a03401e},
{0x58, 0x94004013},
{0x5c, 0x9a037fd0},
{0x60, 0x833ae01f},
{0x64, 0x8220400b},
{0x68, 0x80a26000},
{0x6c, 0x0480000f},
{0x70, 0x9930601f},
{0x74, 0xc2002300},
{0x78, 0x80a04009},
{0x7c, 0x82603fff},
{0xf0, 0x57},
{0x00, 0x8088400c},
{0x04, 0x2280000a},
{0x08, 0xc0234000},
{0x0c, 0xc2002308},
{0x10, 0x80a2c001},
{0x14, 0x38800006},
{0x18, 0xc0234000},
{0x1c, 0xc2028000},
{0x20, 0x10800003},
{0x24, 0xc2234000},
{0x28, 0xc0234000},
{0x2c, 0x9602e001},
{0x30, 0x9e03e001},
{0x34, 0x9a036004},
{0x38, 0x80a2c010},
{0x3c, 0x04bfffe9},
{0x40, 0x9402a004},
{0x44, 0x92026001},
{0x48, 0x80a24011},
{0x4c, 0x04bfffdb},
{0x50, 0x90022007},
{0x54, 0x9007bfd0},
{0x58, 0x7ffffaa5},
{0x5c, 0x92102009},
{0x60, 0xda07bfec},
{0x64, 0xc207bfe8},
{0x68, 0x8200400d},
{0x6c, 0xda07bff0},
{0x70, 0x8200400d},
{0x74, 0x9b30601f},
{0x78, 0x8200400d},
{0x7c, 0xd6082347},
{0xf0, 0x58},
{0x00, 0x9602e001},
{0x04, 0xda00256c},
{0x08, 0xd808257f},
{0x0c, 0x9a5b400b},
{0x10, 0x98032001},
{0x14, 0x81800000},
{0x18, 0x01000000},
{0x1c, 0x01000000},
{0x20, 0x01000000},
{0x24, 0x9a73400c},
{0x28, 0x83386001},
{0x2c, 0xc2202590},
{0x30, 0xda20256c},
{0x34, 0x96102000},
{0x38, 0x94102c18},
{0x3c, 0x992ae002},
{0x40, 0xc20323b4},
{0x44, 0x80a06000},
{0x48, 0x12800009},
{0x4c, 0x80a2e002},
{0x50, 0xc2002520},
{0x54, 0x14800004},
{0x58, 0x9a200001},
{0x5c, 0x10800014},
{0x60, 0xc2232520},
{0x64, 0x10800012},
{0x68, 0xda232520},
{0x6c, 0xda1323b4},
{0x70, 0xc2002590},
{0x74, 0x8258400d},
{0x78, 0x9b38601f},
{0x7c, 0x9b336018},
{0xf0, 0x59},
{0x00, 0x8200400d},
{0x04, 0xda1323b6},
{0x08, 0x83386008},
{0x0c, 0x8200400d},
{0x10, 0xda00256c},
{0x14, 0x8258400d},
{0x18, 0x83306007},
{0x1c, 0x80a06c18},
{0x20, 0x04800003},
{0x24, 0xc2232520},
{0x28, 0xd4232520},
{0x2c, 0x9602e001},
{0x30, 0x80a2e003},
{0x34, 0x04bfffe3},
{0x38, 0x992ae002},
{0x3c, 0xda102472},
{0x40, 0xc2002288},
{0x44, 0x80a36000},
{0x48, 0x02800004},
{0x4c, 0xc220251c},
{0x50, 0x10800005},
{0x54, 0xda202530},
{0x58, 0x0300001f},
{0x5c, 0x821063ff},
{0x60, 0xc2202530},
{0x64, 0x81c7e008},
{0x68, 0x81e80000},
{0x6c, 0x9de3bf80},
{0x70, 0x832e6003},
{0x74, 0x82204019},
{0x78, 0x82004001},
{0x7c, 0x82004018},
{0xf0, 0x5a},
{0x00, 0x3b000018},
{0x04, 0x83286002},
{0x08, 0xc020254c},
{0x0c, 0xba176220},
{0x10, 0xea00401d},
{0x14, 0x9e100019},
{0x18, 0xb2100018},
{0x1c, 0xc2002528},
{0x20, 0x80a54001},
{0x24, 0x9810001a},
{0x28, 0x068000c9},
{0x2c, 0xb0102000},
{0x30, 0xa006401a},
{0x34, 0xa403c01a},
{0x38, 0x8207bfe0},
{0x3c, 0xb2102004},
{0x40, 0xc0204000},
{0x44, 0xb2867fff},
{0x48, 0x1cbffffe},
{0x4c, 0x82006004},
{0x50, 0x9e23c00c},
{0x54, 0x80a3c012},
{0x58, 0x14800061},
{0x5c, 0xb92be003},
{0x60, 0xba03c00f},
{0x64, 0x82048012},
{0x68, 0xb827000f},
{0x6c, 0xba07400f},
{0x70, 0x82004012},
{0x74, 0xba274001},
{0x78, 0x9607001c},
{0x7c, 0x92274010},
{0xf0, 0x5b},
{0x00, 0x9410000b},
{0x04, 0x2d000018},
{0x08, 0x8203000c},
{0x0c, 0xb2240001},
{0x10, 0x80a64010},
{0x14, 0x1480004c},
{0x18, 0xbb3be01f},
{0x1c, 0x82028019},
{0x20, 0xba27400f},
{0x24, 0x83286002},
{0x28, 0xb815a220},
{0x2c, 0xb6064009},
{0x30, 0x9a00401c},
{0x34, 0xa937601f},
{0x38, 0xb406e008},
{0x3c, 0x80a32001},
{0x40, 0x0280000c},
{0x44, 0x80a6600e},
{0x48, 0x18800003},
{0x4c, 0xba102001},
{0x50, 0xba102000},
{0x54, 0x80a3e019},
{0x58, 0x18800003},
{0x5c, 0x82102001},
{0x60, 0x82102000},
{0x64, 0x80974001},
{0x68, 0x32800033},
{0x6c, 0xb2066001},
{0x70, 0xc2034000},
{0x74, 0x80a04015},
{0x78, 0x14800003},
{0x7c, 0xba102001},
{0xf0, 0x5c},
{0x00, 0xba102000},
{0x04, 0x833e601f},
{0x08, 0x82204019},
{0x0c, 0x8330601f},
{0x10, 0x808f4001},
{0x14, 0x0280000c},
{0x18, 0x80a32001},
{0x1c, 0xc2002308},
{0x20, 0x80a04019},
{0x24, 0x82603fff},
{0x28, 0x80884014},
{0x2c, 0x02800006},
{0x30, 0x80a32001},
{0x34, 0xc2002300},
{0x38, 0x80a3c001},
{0x3c, 0x08800083},
{0x40, 0x80a32001},
{0x44, 0x3280001c},
{0x48, 0xb2066001},
{0x4c, 0x8202c019},
{0x50, 0xa3286002},
{0x54, 0x912b001a},
{0x58, 0xb6102000},
{0x5c, 0xa615a220},
{0x60, 0xb92ee002},
{0x64, 0xc2072520},
{0x68, 0xfa044013},
{0x6c, 0x80a74001},
{0x70, 0x0480000c},
{0x74, 0x8207bff8},
{0x78, 0x80a6e003},
{0x7c, 0x14800006},
{0xf0, 0x5d},
{0x00, 0xb0070001},
{0x04, 0xc2063fe8},
{0x08, 0x82104008},
{0x0c, 0x10800005},
{0x10, 0xc2263fe8},
{0x14, 0xc2063fe8},
{0x18, 0x82006001},
{0x1c, 0xc2263fe8},
{0x20, 0xb606e001},
{0x24, 0x80a6e004},
{0x28, 0x08bfffef},
{0x2c, 0xb92ee002},
{0x30, 0xb2066001},
{0x34, 0x9a036004},
{0x38, 0x80a64010},
{0x3c, 0x04bfffc0},
{0x40, 0xb406a001},
{0x44, 0x9e03e001},
{0x48, 0x92026003},
{0x4c, 0x9402a00e},
{0x50, 0x80a3c012},
{0x54, 0x04bfffad},
{0x58, 0x9602e00e},
{0x5c, 0xfa102470},
{0x60, 0xc207bff0},
{0x64, 0x80a0401d},
{0x68, 0x14800003},
{0x6c, 0xba102001},
{0x70, 0xba102000},
{0x74, 0x821b2002},
{0x78, 0x80a00001},
{0x7c, 0x82603fff},
{0xf0, 0x5e},
{0x00, 0x80974001},
{0x04, 0x12800052},
{0x08, 0xb0103fff},
{0x0c, 0xc207bfe0},
{0x10, 0x80886010},
{0x14, 0x0280000a},
{0x18, 0xfa07bfe4},
{0x1c, 0xc207bfec},
{0x20, 0x80886082},
{0x24, 0x02800007},
{0x28, 0x808f6082},
{0x2c, 0x80886028},
{0x30, 0x12800047},
{0x34, 0xb0102003},
{0x38, 0xfa07bfe4},
{0x3c, 0x808f6082},
{0x40, 0x02800007},
{0x44, 0x808f6028},
{0x48, 0xc207bfec},
{0x4c, 0x80886028},
{0x50, 0x3280003f},
{0x54, 0xb0102002},
{0x58, 0x808f6028},
{0x5c, 0x02800008},
{0x60, 0xf807bfe8},
{0x64, 0xc207bfec},
{0x68, 0x80886082},
{0x6c, 0x02800005},
{0x70, 0x820f200a},
{0x74, 0x10800036},
{0x78, 0xb0102002},
{0x7c, 0x820f200a},
{0xf0, 0x5f},
{0x00, 0x8218600a},
{0x04, 0x80a00001},
{0x08, 0xb2043fff},
{0x0c, 0xba603fff},
{0x10, 0x821e6001},
{0x14, 0x80a00001},
{0x18, 0xb6402000},
{0x1c, 0x808f401b},
{0x20, 0x02800005},
{0x24, 0x9e04bfff},
{0x28, 0x80a3e001},
{0x2c, 0x32800028},
{0x30, 0xb0102001},
{0x34, 0x820f2022},
{0x38, 0x80a06022},
{0x3c, 0x1280000d},
{0x40, 0x820f2088},
{0x44, 0xc2002308},
{0x48, 0x821e4001},
{0x4c, 0x80a00001},
{0x50, 0xba402000},
{0x54, 0x821be001},
{0x58, 0x80a00001},
{0x5c, 0x82402000},
{0x60, 0x808f4001},
{0x64, 0x3280001a},
{0x68, 0xb0102001},
{0x6c, 0x820f2088},
{0x70, 0x82186088},
{0x74, 0x80a00001},
{0x78, 0x82603fff},
{0x7c, 0x8088401b},
{0xf0, 0x60},
{0x00, 0x02800007},
{0x04, 0x820f20a0},
{0x08, 0xc2002300},
{0x0c, 0x80a3c001},
{0x10, 0x3280000f},
{0x14, 0xb0102001},
{0x18, 0x820f20a0},
{0x1c, 0x80a060a0},
{0x20, 0x1280000b},
{0x24, 0xb0102000},
{0x28, 0xc2002308},
{0x2c, 0x80a64001},
{0x30, 0x02800007},
{0x34, 0x01000000},
{0x38, 0xc2002300},
{0x3c, 0x80a3c001},
{0x40, 0x12800003},
{0x44, 0xb0102001},
{0x48, 0xb0102000},
{0x4c, 0x81c7e008},
{0x50, 0x81e80000},
{0x54, 0x9de3bf98},
{0x58, 0x832e2003},
{0x5c, 0x82204018},
{0x60, 0xb2100018},
{0x64, 0xbb286003},
{0x68, 0x31000018},
{0x6c, 0x82162224},
{0x70, 0xb6102002},
{0x74, 0xf40022fc},
{0x78, 0xf8074001},
{0x7c, 0x80a6c01a},
{0xf0, 0x61},
{0x00, 0x1880000f},
{0x04, 0x9e102001},
{0x08, 0x82162220},
{0x0c, 0x82074001},
{0x10, 0x82006008},
{0x14, 0xfa004000},
{0x18, 0x80a7401c},
{0x1c, 0x16800004},
{0x20, 0x82006004},
{0x24, 0xb810001d},
{0x28, 0x9e10001b},
{0x2c, 0xb606e001},
{0x30, 0x80a6c01a},
{0x34, 0x28bffff9},
{0x38, 0xfa004000},
{0x3c, 0x80a72000},
{0x40, 0x16800017},
{0x44, 0xb0102000},
{0x48, 0x832e6003},
{0x4c, 0x82204019},
{0x50, 0x82004001},
{0x54, 0x39000018},
{0x58, 0x8200400f},
{0x5c, 0x83286002},
{0x60, 0xba17221c},
{0x64, 0xb6172220},
{0x68, 0xfa00401d},
{0x6c, 0xf600401b},
{0x70, 0xb8172224},
{0x74, 0xc200401c},
{0x78, 0xba07401b},
{0x7c, 0xba074001},
{0xf0, 0x62},
{0x00, 0xc200220c},
{0x04, 0xba20001d},
{0x08, 0xba5f4001},
{0x0c, 0x833f601f},
{0x10, 0x83306018},
{0x14, 0xba074001},
{0x18, 0xb13f6008},
{0x1c, 0x81c7e008},
{0x20, 0x81e80000},
{0x24, 0x9de3bee8},
{0x28, 0xa0102000},
{0x2c, 0xc20022f8},
{0x30, 0x80a40001},
{0x34, 0x1a80000a},
{0x38, 0xa2042001},
{0x3c, 0x8207bff8},
{0x40, 0xa12c2002},
{0x44, 0xa0040001},
{0x48, 0x7fffffc3},
{0x4c, 0x90100011},
{0x50, 0xd0243fa0},
{0x54, 0x10bffff6},
{0x58, 0xa0100011},
{0x5c, 0xc0202514},
{0x60, 0xb607bff8},
{0x64, 0x8207bf48},
{0x68, 0xa2102013},
{0x6c, 0xc0204000},
{0x70, 0xa2847fff},
{0x74, 0x1cbffffe},
{0x78, 0x82006004},
{0x7c, 0xa2102000},
{0xf0, 0x63},
{0x00, 0x832c6002},
{0x04, 0xa2046001},
{0x08, 0x80a46009},
{0x0c, 0x04bffffd},
{0x10, 0xc0206768},
{0x14, 0xa0102001},
{0x18, 0xc20022f8},
{0x1c, 0x80a40001},
{0x20, 0x18800086},
{0x24, 0xb810201c},
{0x28, 0xba10200e},
{0x2c, 0xae10200e},
{0x30, 0xa2102001},
{0x34, 0xc20022fc},
{0x38, 0x80a44001},
{0x3c, 0x18800078},
{0x40, 0x03000044},
{0x44, 0xac040001},
{0x48, 0x9b2f2002},
{0x4c, 0x992f6002},
{0x50, 0x972de002},
{0x54, 0x03000050},
{0x58, 0xaa040001},
{0x5c, 0xa8036004},
{0x60, 0xa6032008},
{0x64, 0xa402e004},
{0x68, 0xc2002308},
{0x6c, 0x80a44001},
{0x70, 0x3880002f},
{0x74, 0xc2002304},
{0x78, 0xc2002300},
{0x7c, 0x80a40001},
{0xf0, 0x64},
{0x00, 0x38800041},
{0x04, 0xc200237c},
{0x08, 0x90100011},
{0x0c, 0x92100010},
{0x10, 0x7ffffeb7},
{0x14, 0x94102001},
{0x18, 0x80a22000},
{0x1c, 0x02800057},
{0x20, 0x1b000040},
{0x24, 0x1b000018},
{0x28, 0x8213621c},
{0x2c, 0x96136220},
{0x30, 0xd8048001},
{0x34, 0xd604800b},
{0x38, 0x9a136224},
{0x3c, 0x832c2002},
{0x40, 0x9803000b},
{0x44, 0xda04800d},
{0x48, 0x8200401b},
{0x4c, 0x9803000d},
{0x50, 0xc2007f9c},
{0x54, 0x80a30001},
{0x58, 0x06800048},
{0x5c, 0x1b000040},
{0x60, 0x80a22000},
{0x64, 0x3680000d},
{0x68, 0xc2002514},
{0x6c, 0x90100011},
{0x70, 0x92100010},
{0x74, 0x7ffffe9e},
{0x78, 0x94102002},
{0x7c, 0x80a22000},
{0xf0, 0x65},
{0x00, 0x0280003e},
{0x04, 0x1b000040},
{0x08, 0xc2002514},
{0x0c, 0x9b286002},
{0x10, 0x10800034},
{0x14, 0xea236768},
{0x18, 0x9b2c6010},
{0x1c, 0x9a034010},
{0x20, 0x99286002},
{0x24, 0x1080002f},
{0x28, 0xda232768},
{0x2c, 0x80a06000},
{0x30, 0x02800007},
{0x34, 0x19000018},
{0x38, 0xc2002300},
{0x3c, 0x80a40001},
{0x40, 0x0880002e},
{0x44, 0x1b000040},
{0x48, 0x19000018},
{0x4c, 0x82132220},
{0x50, 0xda04c001},
{0x54, 0xc200251c},
{0x58, 0x80a34001},
{0x5c, 0x24800027},
{0x60, 0x1b000040},
{0x64, 0x821321e8},
{0x68, 0xc204c001},
{0x6c, 0x80a0400d},
{0x70, 0x36800022},
{0x74, 0x1b000040},
{0x78, 0x82132258},
{0x7c, 0x10800013},
{0xf0, 0x66},
{0x00, 0xc204c001},
{0x04, 0x80a06000},
{0x08, 0x1280001c},
{0x0c, 0x1b000040},
{0x10, 0x19000018},
{0x14, 0x82132220},
{0x18, 0xda050001},
{0x1c, 0xc200251c},
{0x20, 0x80a34001},
{0x24, 0x24800015},
{0x28, 0x1b000040},
{0x2c, 0x8213221c},
{0x30, 0xc2050001},
{0x34, 0x80a0400d},
{0x38, 0x36800010},
{0x3c, 0x1b000040},
{0x40, 0x82132224},
{0x44, 0xc2050001},
{0x48, 0x80a34001},
{0x4c, 0x0680000b},
{0x50, 0x1b000040},
{0x54, 0xc2002514},
{0x58, 0x9b286002},
{0x5c, 0xec236768},
{0x60, 0x82006001},
{0x64, 0xc2202514},
{0x68, 0xc2002514},
{0x6c, 0x80a06009},
{0x70, 0x18800012},
{0x74, 0x1b000040},
{0x78, 0xa2046001},
{0x7c, 0xc20022fc},
{0xf0, 0x67},
{0x00, 0xac05800d},
{0x04, 0x80a44001},
{0x08, 0xa404a004},
{0x0c, 0xa604e004},
{0x10, 0xa8052004},
{0x14, 0x08bfff95},
{0x18, 0xaa05400d},
{0x1c, 0xa0042001},
{0x20, 0xc20022f8},
{0x24, 0x80a40001},
{0x28, 0xae05e00e},
{0x2c, 0xba07600e},
{0x30, 0x08bfff80},
{0x34, 0xb807200e},
{0x38, 0x81c7e008},
{0x3c, 0x81e80000},
{0x40, 0x80a22000},
{0x44, 0x2280001d},
{0x48, 0xc2002558},
{0x4c, 0xd4002208},
{0x50, 0x80a2a000},
{0x54, 0x0280002f},
{0x58, 0x01000000},
{0x5c, 0xc2002514},
{0x60, 0x80a06000},
{0x64, 0x12800007},
{0x68, 0xc2002558},
{0x6c, 0x80a06000},
{0x70, 0x02800028},
{0x74, 0x82007fff},
{0x78, 0x10800026},
{0x7c, 0xc2202558},
{0xf0, 0x68},
{0x00, 0x80a06000},
{0x04, 0x32800023},
{0x08, 0xd4202558},
{0x0c, 0x17200040},
{0x10, 0x193fc200},
{0x14, 0x8212e001},
{0x18, 0xc2230000},
{0x1c, 0xc200233c},
{0x20, 0x83306002},
{0x24, 0x9a132070},
{0x28, 0xc2234000},
{0x2c, 0xd6230000},
{0x30, 0x10800018},
{0x34, 0xd4202558},
{0x38, 0x80a06000},
{0x3c, 0x32800007},
{0x40, 0xc2002514},
{0x44, 0xc2002208},
{0x48, 0x80a06000},
{0x4c, 0x1280000e},
{0x50, 0x033fc200},
{0x54, 0xc2002514},
{0x58, 0x80a06001},
{0x5c, 0x08800006},
{0x60, 0xd800233c},
{0x64, 0x82007fff},
{0x68, 0xda002204},
{0x6c, 0x8258400d},
{0x70, 0x98030001},
{0x74, 0x033fc200},
{0x78, 0x82106070},
{0x7c, 0x10800005},
{0xf0, 0x69},
{0x00, 0xd8204000},
{0x04, 0xda002234},
{0x08, 0x82106070},
{0x0c, 0xda204000},
{0x10, 0x81c3e008},
{0x14, 0x01000000},
{0x18, 0x82220009},
{0x1c, 0x9a58400a},
{0x20, 0x833b601f},
{0x24, 0x80a20009},
{0x28, 0x83306019},
{0x2c, 0x04800004},
{0x30, 0x90102000},
{0x34, 0x82034001},
{0x38, 0x91386007},
{0x3c, 0x81c3e008},
{0x40, 0x01000000},
{0x44, 0x9de3bf98},
{0x48, 0xc2002308},
{0x4c, 0x82006001},
{0x50, 0xe60022fc},
{0x54, 0x80a4c001},
{0x58, 0x2a800019},
{0x5c, 0xe80022f8},
{0x60, 0x15000018},
{0x64, 0xa8102001},
{0x68, 0xc20022f8},
{0x6c, 0x80a50001},
{0x70, 0x1880000c},
{0x74, 0x832ce002},
{0x78, 0x9a006038},
{0x7c, 0x9612a224},
{0xf0, 0x6a},
{0x00, 0x9812a220},
{0x04, 0xc203400c},
{0x08, 0xc223400b},
{0x0c, 0xa8052001},
{0x10, 0xc20022f8},
{0x14, 0x80a50001},
{0x18, 0x08bffffb},
{0x1c, 0x9a036038},
{0x20, 0xc2002308},
{0x24, 0xa604ffff},
{0x28, 0x82006001},
{0x2c, 0x80a4c001},
{0x30, 0x1abfffee},
{0x34, 0xa8102001},
{0x38, 0xe80022f8},
{0x3c, 0x80a52000},
{0x40, 0x0280002a},
{0x44, 0x832d2003},
{0x48, 0xaa204014},
{0x4c, 0x27000018},
{0x50, 0xa52d6003},
{0x54, 0x8214e228},
{0x58, 0xa214e224},
{0x5c, 0xd2048001},
{0x60, 0xd408228c},
{0x64, 0x7fffffcd},
{0x68, 0xd0048011},
{0x6c, 0xac14e220},
{0x70, 0xd0248016},
{0x74, 0xc2002308},
{0x78, 0xa0054015},
{0x7c, 0xa0040001},
{0xf0, 0x6b},
{0x00, 0xa12c2002},
{0x04, 0x8214e21c},
{0x08, 0xd2040001},
{0x0c, 0xd408228d},
{0x10, 0x7fffffc2},
{0x14, 0xd0040016},
{0x18, 0xd0240011},
{0x1c, 0xc2002300},
{0x20, 0x80a50001},
{0x24, 0x2880000f},
{0x28, 0xa8853fff},
{0x2c, 0xa214e258},
{0x30, 0x98100016},
{0x34, 0x9a100012},
{0x38, 0xa6102000},
{0x3c, 0xc203400c},
{0x40, 0xc2234011},
{0x44, 0xc2002308},
{0x48, 0xa604e001},
{0x4c, 0x82006001},
{0x50, 0x80a4c001},
{0x54, 0x08bffffa},
{0x58, 0x9a036004},
{0x5c, 0xa8853fff},
{0x60, 0x12bfffdb},
{0x64, 0xaa057ff9},
{0x68, 0xa6102001},
{0x6c, 0xc2002308},
{0x70, 0x80a4c001},
{0x74, 0x18800019},
{0x78, 0x23000018},
{0x7c, 0xa12ce002},
{0xf0, 0x6c},
{0x00, 0x82146290},
{0x04, 0xa4146258},
{0x08, 0xd2040001},
{0x0c, 0xd408228e},
{0x10, 0x7fffffa2},
{0x14, 0xd0040012},
{0x18, 0x9a146220},
{0x1c, 0xd024000d},
{0x20, 0xc2002300},
{0x24, 0xa1286003},
{0x28, 0xa0240001},
{0x2c, 0xa0040010},
{0x30, 0xa0040013},
{0x34, 0xa12c2002},
{0x38, 0xa21461e8},
{0x3c, 0xd004000d},
{0x40, 0xd2040011},
{0x44, 0x7fffff95},
{0x48, 0xd408228f},
{0x4c, 0xd0240012},
{0x50, 0x10bfffe7},
{0x54, 0xa604e001},
{0x58, 0x17000018},
{0x5c, 0x9012e224},
{0x60, 0x9212e258},
{0x64, 0xda024000},
{0x68, 0xc2020000},
{0x6c, 0x8200400d},
{0x70, 0x9412e220},
{0x74, 0x83386001},
{0x78, 0xc2228000},
{0x7c, 0xd8002308},
{0xf0, 0x6d},
{0x00, 0x992b2002},
{0x04, 0x9612e25c},
{0x08, 0xda03000b},
{0x0c, 0xc203000a},
{0x10, 0x8200400d},
{0x14, 0x83386001},
{0x18, 0xc2230008},
{0x1c, 0xc2002300},
{0x20, 0x9b286003},
{0x24, 0x9a234001},
{0x28, 0x9b2b6003},
{0x2c, 0xd803400a},
{0x30, 0xc203400b},
{0x34, 0x8200400c},
{0x38, 0x83386001},
{0x3c, 0xc2234009},
{0x40, 0xda002300},
{0x44, 0x832b6003},
{0x48, 0x8220400d},
{0x4c, 0xda002308},
{0x50, 0x82004001},
{0x54, 0x8200400d},
{0x58, 0x83286002},
{0x5c, 0xda004009},
{0x60, 0xd8004008},
{0x64, 0x9a03400c},
{0x68, 0x9b3b6001},
{0x6c, 0xda20400b},
{0x70, 0x81c7e008},
{0x74, 0x81e80000},
{0x78, 0x80a2200d},
{0x7c, 0x82402000},
{0xf0, 0x6e},
{0x00, 0x80a26018},
{0x04, 0x90402000},
{0x08, 0x81c3e008},
{0x0c, 0x90084008},
{0x10, 0x9de3bf98},
{0x14, 0xa026001b},
{0x18, 0xae06001b},
{0x1c, 0xf427a04c},
{0x20, 0x03000007},
{0x24, 0xba1063fe},
{0x28, 0x80a40017},
{0x2c, 0xb8102000},
{0x30, 0xaa102000},
{0x34, 0xac102000},
{0x38, 0x1480001f},
{0x3c, 0xb4100010},
{0x40, 0x832c2003},
{0x44, 0x82204010},
{0x48, 0xa6004001},
{0x4c, 0xa226401b},
{0x50, 0xa806401b},
{0x54, 0x80a44014},
{0x58, 0x34800014},
{0x5c, 0xa0042001},
{0x60, 0x82044013},
{0x64, 0xa5286002},
{0x68, 0x90100011},
{0x6c, 0x7fffffe3},
{0x70, 0x92100010},
{0x74, 0x80a22000},
{0x78, 0x02800008},
{0x7c, 0xa2046001},
{0xf0, 0x6f},
{0x00, 0x03000018},
{0x04, 0x82106220},
{0x08, 0xc2048001},
{0x0c, 0x80a0401d},
{0x10, 0x26800002},
{0x14, 0xba100001},
{0x18, 0x80a44014},
{0x1c, 0x04bffff3},
{0x20, 0xa404a004},
{0x24, 0xa0042001},
{0x28, 0x80a40017},
{0x2c, 0x04bfffe8},
{0x30, 0xa604e00e},
{0x34, 0xc2002250},
{0x38, 0x80a74001},
{0x3c, 0x26800002},
{0x40, 0xba100001},
{0x44, 0xb006001b},
{0x48, 0x80a68018},
{0x4c, 0x14800029},
{0x50, 0xa010001a},
{0x54, 0x832ea003},
{0x58, 0x8220401a},
{0x5c, 0xa6004001},
{0x60, 0xa226401b},
{0x64, 0xa806401b},
{0x68, 0x80a44014},
{0x6c, 0x1480001a},
{0x70, 0x82044013},
{0x74, 0xa5286002},
{0x78, 0x90100011},
{0x7c, 0x7fffffbf},
{0xf0, 0x70},
{0x00, 0x92100010},
{0x04, 0x80a22000},
{0x08, 0x22800010},
{0x0c, 0xa2046001},
{0x10, 0x03000018},
{0x14, 0x82106220},
{0x18, 0xc2048001},
{0x1c, 0x8220401d},
{0x20, 0x9a046001},
{0x24, 0x98042001},
{0x28, 0x9658400d},
{0x2c, 0x80a06000},
{0x30, 0x04800005},
{0x34, 0x9a58400c},
{0x38, 0xaa05400d},
{0x3c, 0xac05800b},
{0x40, 0xb8070001},
{0x44, 0xa2046001},
{0x48, 0x80a44014},
{0x4c, 0x04bfffeb},
{0x50, 0xa404a004},
{0x54, 0xa0042001},
{0x58, 0x80a40018},
{0x5c, 0x04bfffe1},
{0x60, 0xa604e00e},
{0x64, 0x80a72000},
{0x68, 0x14800006},
{0x6c, 0x9b2d6006},
{0x70, 0xd807a04c},
{0x74, 0x832b2002},
{0x78, 0x1080001d},
{0x7c, 0xc0206768},
{0xf0, 0x71},
{0x00, 0x833b601f},
{0x04, 0x81806000},
{0x08, 0x01000000},
{0x0c, 0x01000000},
{0x10, 0x01000000},
{0x14, 0x9a7b401c},
{0x18, 0x832da006},
{0x1c, 0x9938601f},
{0x20, 0x81832000},
{0x24, 0x01000000},
{0x28, 0x01000000},
{0x2c, 0x01000000},
{0x30, 0x8278401c},
{0x34, 0xaa037fa0},
{0x38, 0x80a56000},
{0x3c, 0x14800003},
{0x40, 0xac007fa0},
{0x44, 0xaa102001},
{0x48, 0x80a5a000},
{0x4c, 0x24800002},
{0x50, 0xac102001},
{0x54, 0x9a0dafff},
{0x58, 0x832d6010},
{0x5c, 0x8210400d},
{0x60, 0xd807a04c},
{0x64, 0x9b2b2002},
{0x68, 0xc2236768},
{0x6c, 0x81c7e008},
{0x70, 0x81e80000},
{0x74, 0x9de3bf98},
{0x78, 0x03000018},
{0x7c, 0xb6106254},
{0xf0, 0x72},
{0x00, 0xb810625c},
{0x04, 0x96106258},
{0x08, 0xc2002274},
{0x0c, 0x80a06000},
{0x10, 0x832e2003},
{0x14, 0x82204018},
{0x18, 0x82004001},
{0x1c, 0x82004019},
{0x20, 0xb12e2006},
{0x24, 0xbb2e6006},
{0x28, 0xb5286002},
{0x2c, 0xb0063fe0},
{0x30, 0x9a066001},
{0x34, 0x98066002},
{0x38, 0x9f2e2010},
{0x3c, 0x02800020},
{0x40, 0x82077fe0},
{0x44, 0xfa06801b},
{0x48, 0xf806801c},
{0x4c, 0xf406800b},
{0x50, 0x8207401a},
{0x54, 0xb610001d},
{0x58, 0x80a7401c},
{0x5c, 0x04800003},
{0x60, 0xb000401c},
{0x64, 0xb610001c},
{0x68, 0x8227401b},
{0x6c, 0xba26801b},
{0x70, 0xba5f400d},
{0x74, 0x82584019},
{0x78, 0x8200401d},
{0x7c, 0xb827001b},
{0xf0, 0x73},
{0x00, 0xb85f000c},
{0x04, 0xba06c01b},
{0x08, 0x8200401c},
{0x0c, 0xba07401b},
{0x10, 0xba26001d},
{0x14, 0x83286006},
{0x18, 0x9b38601f},
{0x1c, 0x81836000},
{0x20, 0x01000000},
{0x24, 0x01000000},
{0x28, 0x01000000},
{0x2c, 0x8278401d},
{0x30, 0x82807fa0},
{0x34, 0x2c800002},
{0x38, 0x82102000},
{0x3c, 0xb003c001},
{0x40, 0xb0263000},
{0x44, 0x81c7e008},
{0x48, 0x81e80000},
{0x4c, 0x9de3bf98},
{0x50, 0xa2102000},
{0x54, 0xc2002514},
{0x58, 0x80a44001},
{0x5c, 0x1a800029},
{0x60, 0xa12c6002},
{0x64, 0xda042768},
{0x68, 0x93336010},
{0x6c, 0x8333600c},
{0x70, 0x900b6fff},
{0x74, 0x80886001},
{0x78, 0x02800006},
{0x7c, 0x920a6fff},
{0xf0, 0x74},
{0x00, 0x7fffffbd},
{0x04, 0xa2046001},
{0x08, 0x1080001a},
{0x0c, 0xd0242768},
{0x10, 0x80a36000},
{0x14, 0x22800017},
{0x18, 0xa2046001},
{0x1c, 0x93336010},
{0x20, 0xc200246c},
{0x24, 0x98100009},
{0x28, 0x9f33600e},
{0x2c, 0x80a06000},
{0x30, 0x900b6fff},
{0x34, 0x920a6fff},
{0x38, 0x0280000c},
{0x3c, 0x94100011},
{0x40, 0x808be001},
{0x44, 0x12800005},
{0x48, 0x96102002},
{0x4c, 0x920b2fff},
{0x50, 0x94100011},
{0x54, 0x96102001},
{0x58, 0x7fffff2e},
{0x5c, 0xa2046001},
{0x60, 0x10800005},
{0x64, 0xc2002514},
{0x68, 0x7ffff99f},
{0x6c, 0xa2046001},
{0x70, 0xc2002514},
{0x74, 0x80a44001},
{0x78, 0x0abfffdb},
{0x7c, 0xa12c6002},
{0xf0, 0x75},
{0x00, 0x81c7e008},
{0x04, 0x81e80000},
{0x08, 0x9de3bf98},
{0x0c, 0x9e102000},
{0x10, 0x832be002},
{0x14, 0xfa006768},
{0x18, 0x80a76000},
{0x1c, 0x2280002e},
{0x20, 0x9e03e001},
{0x24, 0x83376010},
{0x28, 0xba0f6fff},
{0x2c, 0x82086fff},
{0x30, 0xb403e001},
{0x34, 0x98076020},
{0x38, 0x96006020},
{0x3c, 0x80a6a009},
{0x40, 0x9a007fe0},
{0x44, 0xba077fe0},
{0x48, 0x18800022},
{0x4c, 0x832ea002},
{0x50, 0xf8006768},
{0x54, 0x80a72000},
{0x58, 0x2280001c},
{0x5c, 0xb406a001},
{0x60, 0xb7372010},
{0x64, 0xb60eefff},
{0x68, 0xb20f2fff},
{0x6c, 0x80a6c00d},
{0x70, 0x14800003},
{0x74, 0xb0102001},
{0x78, 0xb0102000},
{0x7c, 0x80a6c00b},
{0xf0, 0x76},
{0x00, 0x06800003},
{0x04, 0xb8102001},
{0x08, 0xb8102000},
{0x0c, 0x808e001c},
{0x10, 0x2280000e},
{0x14, 0xb406a001},
{0x18, 0x80a6401d},
{0x1c, 0x14800003},
{0x20, 0xb6102001},
{0x24, 0xb6102000},
{0x28, 0x80a6400c},
{0x2c, 0x06800003},
{0x30, 0xb8102001},
{0x34, 0xb8102000},
{0x38, 0x808ec01c},
{0x3c, 0x32800002},
{0x40, 0xc0206768},
{0x44, 0xb406a001},
{0x48, 0x10bfffe0},
{0x4c, 0x80a6a009},
{0x50, 0x9e03e001},
{0x54, 0x80a3e009},
{0x58, 0x08bfffcf},
{0x5c, 0x832be002},
{0x60, 0x81c7e008},
{0x64, 0x81e80000},
{0x68, 0xc2002510},
{0x6c, 0x82006001},
{0x70, 0x80a06008},
{0x74, 0x08800003},
{0x78, 0xc2202510},
{0x7c, 0xc0202510},
{0xf0, 0x77},
{0x00, 0xd8002510},
{0x04, 0x96102000},
{0x08, 0x832b2002},
{0x0c, 0x8200400c},
{0x10, 0x83286003},
{0x14, 0x82006600},
{0x18, 0x9b2ae002},
{0x1c, 0x80a32000},
{0x20, 0xc2236790},
{0x24, 0x12800003},
{0x28, 0x98033fff},
{0x2c, 0x98102008},
{0x30, 0x9602e001},
{0x34, 0x80a2e008},
{0x38, 0x04bffff5},
{0x3c, 0x832b2002},
{0x40, 0x0303ffc7},
{0x44, 0x921063ff},
{0x48, 0x98102000},
{0x4c, 0x96102000},
{0x50, 0x9b2ae002},
{0x54, 0xc2036768},
{0x58, 0x82084009},
{0x5c, 0x9602e001},
{0x60, 0x952b2002},
{0x64, 0x80a06000},
{0x68, 0x02800004},
{0x6c, 0xc2236768},
{0x70, 0x98032001},
{0x74, 0xc222a768},
{0x78, 0x80a2e009},
{0x7c, 0x24bffff6},
{0xf0, 0x78},
{0x00, 0x9b2ae002},
{0x04, 0x9610000c},
{0x08, 0x80a32009},
{0x0c, 0x14800007},
{0x10, 0xd8202514},
{0x14, 0x832ae002},
{0x18, 0x9602e001},
{0x1c, 0x80a2e009},
{0x20, 0x04bffffd},
{0x24, 0xc0206768},
{0x28, 0x81c3e008},
{0x2c, 0x01000000},
{0x30, 0x9de3bf98},
{0x34, 0xc20022f4},
{0x38, 0x80a06000},
{0x3c, 0x02800049},
{0x40, 0xb0102000},
{0x44, 0xc2002514},
{0x48, 0x80a60001},
{0x4c, 0x1a800045},
{0x50, 0x033c003f},
{0x54, 0x9e1063ff},
{0x58, 0xb52e2002},
{0x5c, 0xfa06a768},
{0x60, 0x8337600c},
{0x64, 0x80886001},
{0x68, 0x3280003a},
{0x6c, 0xb0062001},
{0x70, 0xb9376010},
{0x74, 0xb80f2fff},
{0x78, 0x80a7201f},
{0x7c, 0x2880001a},
{0xf0, 0x79},
{0x00, 0xfa06a768},
{0x04, 0xc2002300},
{0x08, 0x83286006},
{0x0c, 0x82007fe0},
{0x10, 0x80a70001},
{0x14, 0x38800014},
{0x18, 0xfa06a768},
{0x1c, 0x808f2020},
{0x20, 0x02800008},
{0x24, 0xb60f3fe0},
{0x28, 0x8238001c},
{0x2c, 0x8208601f},
{0x30, 0xc20862d4},
{0x34, 0x8226c001},
{0x38, 0x10800005},
{0x3c, 0x8200601f},
{0x40, 0x820f201f},
{0x44, 0xc20862d4},
{0x48, 0x8206c001},
{0x4c, 0x82086fff},
{0x50, 0x83286010},
{0x54, 0xba0f400f},
{0x58, 0xba174001},
{0x5c, 0xfa26a768},
{0x60, 0xfa06a768},
{0x64, 0xb80f6fff},
{0x68, 0x80a7201f},
{0x6c, 0x28800019},
{0x70, 0xb0062001},
{0x74, 0xc2002308},
{0x78, 0x83286006},
{0x7c, 0x82007fe0},
{0xf0, 0x7a},
{0x00, 0x80a70001},
{0x04, 0x38800013},
{0x08, 0xb0062001},
{0x0c, 0x808f6020},
{0x10, 0xb60f6fe0},
{0x14, 0x02800008},
{0x18, 0xb20f7000},
{0x1c, 0x8238001c},
{0x20, 0x8208601f},
{0x24, 0xc2086254},
{0x28, 0x8226c001},
{0x2c, 0x10800005},
{0x30, 0x8200601f},
{0x34, 0x820f601f},
{0x38, 0xc2086254},
{0x3c, 0x8206c001},
{0x40, 0x82086fff},
{0x44, 0x82164001},
{0x48, 0xc226a768},
{0x4c, 0xb0062001},
{0x50, 0xc2002514},
{0x54, 0x80a60001},
{0x58, 0x0abfffc1},
{0x5c, 0xb52e2002},
{0x60, 0x81c7e008},
{0x64, 0x81e80000},
{0x68, 0x912a2002},
{0x6c, 0xc2002794},
{0x70, 0xda004008},
{0x74, 0x033c003c},
{0x78, 0x822b4001},
{0x7c, 0x98102790},
{0xf0, 0x7b},
{0x00, 0xda030000},
{0x04, 0xc2234008},
{0x08, 0xd8030000},
{0x0c, 0xda030008},
{0x10, 0x03000020},
{0x14, 0x822b4001},
{0x18, 0x81c3e008},
{0x1c, 0xc2230008},
{0x20, 0x912a2002},
{0x24, 0xc2002790},
{0x28, 0xc0204008},
{0x2c, 0xc2002794},
{0x30, 0xc2104008},
{0x34, 0xda002798},
{0x38, 0xda134008},
{0x3c, 0x82086fff},
{0x40, 0x94004001},
{0x44, 0x9a0b6fff},
{0x48, 0x80a2800d},
{0x4c, 0x18800003},
{0x50, 0x9422800d},
{0x54, 0x94102000},
{0x58, 0xd6002790},
{0x5c, 0x9a0aafff},
{0x60, 0xd802c008},
{0x64, 0x0303ffc0},
{0x68, 0x9b2b6010},
{0x6c, 0x822b0001},
{0x70, 0x8210400d},
{0x74, 0xc222c008},
{0x78, 0xc2002794},
{0x7c, 0xc2004008},
{0xf0, 0x7c},
{0x00, 0xda002798},
{0x04, 0xda034008},
{0x08, 0x82086fff},
{0x0c, 0x94004001},
{0x10, 0x9a0b6fff},
{0x14, 0x80a2800d},
{0x18, 0x18800003},
{0x1c, 0x9422800d},
{0x20, 0x94102000},
{0x24, 0xd8002790},
{0x28, 0xc2030008},
{0x2c, 0x9a0aafff},
{0x30, 0x82087000},
{0x34, 0x8210400d},
{0x38, 0xc2230008},
{0x3c, 0xd8002790},
{0x40, 0xc2030008},
{0x44, 0x1b000020},
{0x48, 0x8210400d},
{0x4c, 0x81c3e008},
{0x50, 0xc2230008},
{0x54, 0x912a2002},
{0x58, 0xc2002790},
{0x5c, 0xc0204008},
{0x60, 0xc2002794},
{0x64, 0xda104008},
{0x68, 0xc200279c},
{0x6c, 0xd6104008},
{0x70, 0xc2002798},
{0x74, 0x9a0b6fff},
{0x78, 0xd8104008},
{0x7c, 0x832b6002},
{0xf0, 0x7d},
{0x00, 0x8200400d},
{0x04, 0x960aefff},
{0x08, 0x980b2fff},
{0x0c, 0x8200400b},
{0x10, 0x992b2002},
{0x14, 0x80a0400c},
{0x18, 0x18800003},
{0x1c, 0x8220400c},
{0x20, 0x82102000},
{0x24, 0xd6002790},
{0x28, 0x9b306001},
{0x2c, 0xd802c008},
{0x30, 0x9a0b6fff},
{0x34, 0x0303ffc0},
{0x38, 0x822b0001},
{0x3c, 0x9b2b6010},
{0x40, 0x8210400d},
{0x44, 0xc222c008},
{0x48, 0xc2002794},
{0x4c, 0xda004008},
{0x50, 0xc200279c},
{0x54, 0xd6004008},
{0x58, 0xc2002798},
{0x5c, 0x9a0b6fff},
{0x60, 0xd8004008},
{0x64, 0x832b6002},
{0x68, 0x8200400d},
{0x6c, 0x960aefff},
{0x70, 0x980b2fff},
{0x74, 0x8200400b},
{0x78, 0x992b2002},
{0x7c, 0x80a0400c},
{0xf0, 0x7e},
{0x00, 0x18800003},
{0x04, 0x8220400c},
{0x08, 0x82102000},
{0x0c, 0xd8002790},
{0x10, 0x9b306001},
{0x14, 0xc2030008},
{0x18, 0x9a0b6fff},
{0x1c, 0x82087000},
{0x20, 0x8210400d},
{0x24, 0xc2230008},
{0x28, 0xd8002790},
{0x2c, 0xc2030008},
{0x30, 0x1b000020},
{0x34, 0x8210400d},
{0x38, 0x81c3e008},
{0x3c, 0xc2230008},
{0x40, 0x9de3bf98},
{0x44, 0xa2102000},
{0x48, 0xa12c6002},
{0x4c, 0xc2002794},
{0x50, 0xc2004010},
{0x54, 0x80a06000},
{0x58, 0x0280001f},
{0x5c, 0x0303ffc3},
{0x60, 0xc2002798},
{0x64, 0xc2004010},
{0x68, 0x80a06000},
{0x6c, 0x0280000c},
{0x70, 0x01000000},
{0x74, 0x8330600d},
{0x78, 0x80886001},
{0x7c, 0x12800008},
{0xf0, 0x7f},
{0x00, 0x01000000},
{0x04, 0xc200279c},
{0x08, 0xda004010},
{0x0c, 0x8333600d},
{0x10, 0x80886001},
{0x14, 0x02800006},
{0x18, 0x80a36000},
{0x1c, 0x7fffff73},
{0x20, 0x90100011},
{0x24, 0x10800010},
{0x28, 0xc2002794},
{0x2c, 0x02800006},
{0x30, 0x01000000},
{0x34, 0x7fffffa8},
{0x38, 0x90100011},
{0x3c, 0x1080000a},
{0x40, 0xc2002794},
{0x44, 0x7fffff77},
{0x48, 0x90100011},
{0x4c, 0x10800006},
{0x50, 0xc2002794},
{0x54, 0x821063ff},
{0x58, 0xda002790},
{0x5c, 0xc2234010},
{0x60, 0xc2002794},
{0x64, 0xc2004010},
{0x68, 0x8330600c},
{0x6c, 0x80886001},
{0x70, 0x02800007},
{0x74, 0xa2046001},
{0x78, 0xc2002790},
{0x7c, 0xda004010},
{0xf0, 0x80},
{0x00, 0x19000004},
{0x04, 0x9a13400c},
{0x08, 0xda204010},
{0x0c, 0x80a46009},
{0x10, 0x04bfffcf},
{0x14, 0xa12c6002},
{0x18, 0x81c7e008},
{0x1c, 0x81e80000},
{0x20, 0xd6020000},
{0x24, 0xd8024000},
{0x28, 0x9132e010},
{0x2c, 0x95332010},
{0x30, 0x900a2fff},
{0x34, 0x940aafff},
{0x38, 0x03000007},
{0x3c, 0x9a22000a},
{0x40, 0x821063ff},
{0x44, 0x940b0001},
{0x48, 0x900ac001},
{0x4c, 0x9022000a},
{0x50, 0x9a5b400d},
{0x54, 0x905a0008},
{0x58, 0x81c3e008},
{0x5c, 0x90034008},
{0x60, 0x031fffff},
{0x64, 0x9002200c},
{0x68, 0x821063ff},
{0x6c, 0x9a102063},
{0x70, 0xc2220000},
{0x74, 0x9a837fff},
{0x78, 0x1cbffffe},
{0x7c, 0x90022004},
{0xf0, 0x81},
{0x00, 0x81c3e008},
{0x04, 0x01000000},
{0x08, 0x031fffff},
{0x0c, 0x821063ff},
{0x10, 0xc2222008},
{0x14, 0x92102000},
{0x18, 0x96100008},
{0x1c, 0x94102000},
{0x20, 0x9a02e00c},
{0x24, 0xd8034000},
{0x28, 0xc2022008},
{0x2c, 0x80a30001},
{0x30, 0x16800005},
{0x34, 0x9a036004},
{0x38, 0xd8222008},
{0x3c, 0xd4220000},
{0x40, 0xd2222004},
{0x44, 0x9402a001},
{0x48, 0x80a2a009},
{0x4c, 0x24bffff7},
{0x50, 0xd8034000},
{0x54, 0x92026001},
{0x58, 0x80a26009},
{0x5c, 0x04bffff0},
{0x60, 0x9602e028},
{0x64, 0xda022008},
{0x68, 0x03200000},
{0x6c, 0x8238400d},
{0x70, 0x80a00001},
{0x74, 0x81c3e008},
{0x78, 0x90402000},
{0x7c, 0xc2022004},
{0xf0, 0x82},
{0x00, 0x9b286002},
{0x04, 0x9a034001},
{0x08, 0x031fffff},
{0x0c, 0x9b2b6003},
{0x10, 0x9a034008},
{0x14, 0x981063ff},
{0x18, 0x9a03600c},
{0x1c, 0x82102009},
{0x20, 0xd8234000},
{0x24, 0x82807fff},
{0x28, 0x1cbffffe},
{0x2c, 0x9a036004},
{0x30, 0xc2020000},
{0x34, 0x83286002},
{0x38, 0x82004008},
{0x3c, 0x8200600c},
{0x40, 0x9a102009},
{0x44, 0xd8204000},
{0x48, 0x9a837fff},
{0x4c, 0x1cbffffe},
{0x50, 0x82006028},
{0x54, 0x81c3e008},
{0x58, 0x01000000},
{0x5c, 0x98100008},
{0x60, 0x90102008},
{0x64, 0x9a102100},
{0x68, 0x832b4008},
{0x6c, 0x80a30001},
{0x70, 0x14800006},
{0x74, 0x01000000},
{0x78, 0x90023fff},
{0x7c, 0x80a22000},
{0xf0, 0x83},
{0x00, 0x14bffffb},
{0x04, 0x832b4008},
{0x08, 0x81c3e008},
{0x0c, 0x01000000},
{0x10, 0x9de3bdd0},
{0x14, 0xae07be58},
{0x18, 0x7fffffb2},
{0x1c, 0x90100017},
{0x20, 0xa6102000},
{0x24, 0xa12ce002},
{0x28, 0xd2002790},
{0x2c, 0xc2024010},
{0x30, 0x8330600f},
{0x34, 0x80886001},
{0x38, 0x2280000f},
{0x3c, 0xd000245c},
{0x40, 0xc2002794},
{0x44, 0x90004010},
{0x48, 0xc2004010},
{0x4c, 0x8330600d},
{0x50, 0x80886001},
{0x54, 0x02800004},
{0x58, 0x92024010},
{0x5c, 0x10800006},
{0x60, 0xd000245c},
{0x64, 0x7fffff8f},
{0x68, 0x01000000},
{0x6c, 0x7fffffdc},
{0x70, 0x01000000},
{0x74, 0xc2002358},
{0x78, 0x9807bff8},
{0x7c, 0x825a0001},
{0xf0, 0x84},
{0x00, 0x9a04000c},
{0x04, 0xa604e001},
{0x08, 0x80a4e009},
{0x0c, 0x04bfffe6},
{0x10, 0xc2237e38},
{0x14, 0xac10000c},
{0x18, 0xa6102000},
{0x1c, 0xa8102000},
{0x20, 0xea002790},
{0x24, 0x0303ffc3},
{0x28, 0xda054014},
{0x2c, 0x821063ff},
{0x30, 0x80a34001},
{0x34, 0x22800014},
{0x38, 0xa604e001},
{0x3c, 0xa2102000},
{0x40, 0xc2002514},
{0x44, 0x80a44001},
{0x48, 0x3a80000f},
{0x4c, 0xa604e001},
{0x50, 0xa005be6c},
{0x54, 0xa4102768},
{0x58, 0x90100012},
{0x5c, 0x7fffff71},
{0x60, 0x92054014},
{0x64, 0xd0240000},
{0x68, 0xa2046001},
{0x6c, 0xc2002514},
{0x70, 0x80a44001},
{0x74, 0xa404a004},
{0x78, 0x0abffff8},
{0x7c, 0xa0042028},
{0xf0, 0x85},
{0x00, 0xa604e001},
{0x04, 0xa8052004},
{0x08, 0x80a4e009},
{0x0c, 0x04bfffe5},
{0x10, 0xac05a004},
{0x14, 0xa2102000},
{0x18, 0xc2002514},
{0x1c, 0x80a44001},
{0x20, 0x1a80002d},
{0x24, 0x01000000},
{0x28, 0x7fffff78},
{0x2c, 0x90100017},
{0x30, 0x80a22000},
{0x34, 0xa0046001},
{0x38, 0x02800027},
{0x3c, 0x90100017},
{0x40, 0xd807be58},
{0x44, 0x832b2002},
{0x48, 0x8200401e},
{0x4c, 0xc2007e30},
{0x50, 0xda002230},
{0x54, 0x9a034001},
{0x58, 0xc2002548},
{0x5c, 0x9a5b4001},
{0x60, 0xc2002334},
{0x64, 0x82006001},
{0x68, 0x81800000},
{0x6c, 0x01000000},
{0x70, 0x01000000},
{0x74, 0x01000000},
{0x78, 0x9a734001},
{0x7c, 0xc207be60},
{0xf0, 0x86},
{0x00, 0x80a0400d},
{0x04, 0x98032001},
{0x08, 0xc207be5c},
{0x0c, 0x992b201c},
{0x10, 0x0a800007},
{0x14, 0x95286002},
{0x18, 0xc202a768},
{0x1c, 0x1b3c0000},
{0x20, 0x8210400d},
{0x24, 0x10800008},
{0x28, 0xc222a768},
{0x2c, 0xda02a768},
{0x30, 0x033c0000},
{0x34, 0x822b4001},
{0x38, 0x8210400c},
{0x3c, 0x7fffff70},
{0x40, 0xc222a768},
{0x44, 0xc2002514},
{0x48, 0x80a40001},
{0x4c, 0x0abfffd7},
{0x50, 0xa2100010},
{0x54, 0x81c7e008},
{0x58, 0x81e80000},
{0x5c, 0x92102000},
{0x60, 0xc2002514},
{0x64, 0x80a24001},
{0x68, 0x1a800037},
{0x6c, 0x0303ffff},
{0x70, 0x901063ff},
{0x74, 0x952a6002},
{0x78, 0xc202a768},
{0x7c, 0x8330601c},
{0xf0, 0x87},
{0x00, 0x80a00001},
{0x04, 0x9a603fff},
{0x08, 0x8218600f},
{0x0c, 0x80a00001},
{0x10, 0x82603fff},
{0x14, 0x80934001},
{0x18, 0x22800027},
{0x1c, 0x92026001},
{0x20, 0x9a102001},
{0x24, 0x96102000},
{0x28, 0x992ae002},
{0x2c, 0xc2032768},
{0x30, 0x8330601c},
{0x34, 0x80a0400d},
{0x38, 0x02800013},
{0x3c, 0x80a2e00a},
{0x40, 0xc2002794},
{0x44, 0xc200400c},
{0x48, 0x8330601c},
{0x4c, 0x80a0400d},
{0x50, 0x0280000d},
{0x54, 0x80a2e00a},
{0x58, 0xc2002798},
{0x5c, 0xc200400c},
{0x60, 0x8330601c},
{0x64, 0x80a0400d},
{0x68, 0x02800007},
{0x6c, 0x80a2e00a},
{0x70, 0x9602e001},
{0x74, 0x80a2e009},
{0x78, 0x08bfffed},
{0x7c, 0x992ae002},
{0xf0, 0x88},
{0x00, 0x80a2e00a},
{0x04, 0x22800007},
{0x08, 0xc202a768},
{0x0c, 0x9a036001},
{0x10, 0x80a3600a},
{0x14, 0x08bfffe5},
{0x18, 0x96102000},
{0x1c, 0xc202a768},
{0x20, 0x9b2b601c},
{0x24, 0x82084008},
{0x28, 0x8210400d},
{0x2c, 0xc222a768},
{0x30, 0x92026001},
{0x34, 0xc2002514},
{0x38, 0x80a24001},
{0x3c, 0x0abfffcf},
{0x40, 0x952a6002},
{0x44, 0x81c3e008},
{0x48, 0x01000000},
{0x4c, 0x98102000},
{0x50, 0x9b2b2002},
{0x54, 0x98032001},
{0x58, 0xc2002790},
{0x5c, 0x80a32009},
{0x60, 0x08bffffc},
{0x64, 0xc020400d},
{0x68, 0x98102000},
{0x6c, 0xc2002514},
{0x70, 0x80a30001},
{0x74, 0x1a800012},
{0x78, 0x033fffc7},
{0x7c, 0x941063ff},
{0xf0, 0x89},
{0x00, 0x832b2002},
{0x04, 0xda006768},
{0x08, 0x8333601c},
{0x0c, 0x82007fff},
{0x10, 0x98032001},
{0x14, 0x80a06009},
{0x18, 0x97286002},
{0x1c, 0x18800004},
{0x20, 0x9a0b400a},
{0x24, 0xc2002790},
{0x28, 0xda20400b},
{0x2c, 0xc2002514},
{0x30, 0x80a30001},
{0x34, 0x0abffff4},
{0x38, 0x832b2002},
{0x3c, 0x81c3e008},
{0x40, 0x01000000},
{0x44, 0x9de3bf98},
{0x48, 0x92102000},
{0x4c, 0x94026001},
{0x50, 0x80a2a009},
{0x54, 0x18800068},
{0x58, 0x9610000a},
{0x5c, 0x033c003f},
{0x60, 0x901063ff},
{0x64, 0xf6002790},
{0x68, 0xb32ae002},
{0x6c, 0xfa06c019},
{0x70, 0x80a76000},
{0x74, 0x2280005c},
{0x78, 0x9602e001},
{0x7c, 0xb52a6002},
{0xf0, 0x8a},
{0x00, 0xc206c01a},
{0x04, 0x80a06000},
{0x08, 0x22800057},
{0x0c, 0x9602e001},
{0x10, 0xda002794},
{0x14, 0xf0034019},
{0x18, 0x80a62000},
{0x1c, 0x22800052},
{0x20, 0x9602e001},
{0x24, 0xf803401a},
{0x28, 0x80a72000},
{0x2c, 0x2280004e},
{0x30, 0x9602e001},
{0x34, 0x83306010},
{0x38, 0xbb376010},
{0x3c, 0x98086fff},
{0x40, 0x9e0f6fff},
{0x44, 0x80a3000f},
{0x48, 0x16800009},
{0x4c, 0xbb372010},
{0x50, 0x83362010},
{0x54, 0xba0f6fff},
{0x58, 0x82086fff},
{0x5c, 0x80a74001},
{0x60, 0x3480000d},
{0x64, 0xc206c01a},
{0x68, 0x80a3000f},
{0x6c, 0x2480003e},
{0x70, 0x9602e001},
{0x74, 0xbb372010},
{0x78, 0x83362010},
{0x7c, 0xba0f6fff},
{0xf0, 0x8b},
{0x00, 0x82086fff},
{0x04, 0x80a74001},
{0x08, 0x36800037},
{0x0c, 0x9602e001},
{0x10, 0xc206c01a},
{0x14, 0xfa06c019},
{0x18, 0xb0086fff},
{0x1c, 0xb80f6fff},
{0x20, 0x80a6001c},
{0x24, 0x1680000a},
{0x28, 0x01000000},
{0x2c, 0xfa034019},
{0x30, 0xc203401a},
{0x34, 0x82086fff},
{0x38, 0xba0f6fff},
{0x3c, 0x80a0401d},
{0x40, 0x3480000e},
{0x44, 0xfa16c01a},
{0x48, 0x80a6001c},
{0x4c, 0x24800026},
{0x50, 0x9602e001},
{0x54, 0xc2002794},
{0x58, 0xfa004019},
{0x5c, 0xc200401a},
{0x60, 0x82086fff},
{0x64, 0xba0f6fff},
{0x68, 0x80a0401d},
{0x6c, 0x3680001e},
{0x70, 0x9602e001},
{0x74, 0xfa16c01a},
{0x78, 0xf806c019},
{0x7c, 0xba0f6fff},
{0xf0, 0x8c},
{0x00, 0xbb2f6010},
{0x04, 0x820f0008},
{0x08, 0x8210401d},
{0x0c, 0xc226c019},
{0x10, 0xf6002790},
{0x14, 0xc206c01a},
{0x18, 0x3b03ffc0},
{0x1c, 0xb80f001d},
{0x20, 0x82084008},
{0x24, 0x8210401c},
{0x28, 0xc226c01a},
{0x2c, 0xf8002790},
{0x30, 0xf6070019},
{0x34, 0xfa07001a},
{0x38, 0xba0f6fff},
{0x3c, 0x820ef000},
{0x40, 0x8210401d},
{0x44, 0xc2270019},
{0x48, 0xfa002790},
{0x4c, 0xc207401a},
{0x50, 0x82087000},
{0x54, 0xb60eefff},
{0x58, 0x8210401b},
{0x5c, 0xc227401a},
{0x60, 0x9602e001},
{0x64, 0x80a2e009},
{0x68, 0x28bfffa0},
{0x6c, 0xf6002790},
{0x70, 0x80a2a009},
{0x74, 0x08bfff96},
{0x78, 0x9210000a},
{0x7c, 0x81c7e008},
{0xf0, 0x8d},
{0x00, 0x81e80000},
{0x04, 0x9de3bf98},
{0x08, 0xa6102000},
{0x0c, 0xda002244},
{0x10, 0x80a36000},
{0x14, 0x02800033},
{0x18, 0xa12ce002},
{0x1c, 0xe4002790},
{0x20, 0xc2048010},
{0x24, 0x80a06000},
{0x28, 0x22800004},
{0x2c, 0xc204282c},
{0x30, 0x1080002c},
{0x34, 0xc024282c},
{0x38, 0x80a06000},
{0x3c, 0x2280000b},
{0x40, 0xc2002518},
{0x44, 0xc2002794},
{0x48, 0xc2004010},
{0x4c, 0x1b000008},
{0x50, 0x8210400d},
{0x54, 0xc2248010},
{0x58, 0xc204282c},
{0x5c, 0x82007fff},
{0x60, 0x10800020},
{0x64, 0xc224282c},
{0x68, 0x80a0400d},
{0x6c, 0x2a80001e},
{0x70, 0xa604e001},
{0x74, 0xe2002794},
{0x78, 0xc2044010},
{0x7c, 0x80a06000},
{0xf0, 0x8e},
{0x00, 0x22800019},
{0x04, 0xa604e001},
{0x08, 0x8330600d},
{0x0c, 0x80886001},
{0x10, 0x32800015},
{0x14, 0xa604e001},
{0x18, 0xd2002798},
{0x1c, 0xc2024010},
{0x20, 0x80a06000},
{0x24, 0x22800010},
{0x28, 0xa604e001},
{0x2c, 0x92024010},
{0x30, 0x7ffffe3c},
{0x34, 0x90044010},
{0x38, 0xc200224c},
{0x3c, 0x80a20001},
{0x40, 0x38800009},
{0x44, 0xa604e001},
{0x48, 0xc2002248},
{0x4c, 0xc224282c},
{0x50, 0xc2044010},
{0x54, 0x1b000008},
{0x58, 0x8210400d},
{0x5c, 0xc2248010},
{0x60, 0xa604e001},
{0x64, 0x80a4e009},
{0x68, 0x24bfffca},
{0x6c, 0xda002244},
{0x70, 0x81c7e008},
{0x74, 0x81e80000},
{0x78, 0x9de3bf98},
{0x7c, 0xc2002514},
{0xf0, 0x8f},
{0x00, 0x80a06000},
{0x04, 0x22800006},
{0x08, 0xc2002200},
{0x0c, 0xc2002314},
{0x10, 0x82200001},
{0x14, 0x10800062},
{0x18, 0xc2202538},
{0x1c, 0x80a06000},
{0x20, 0x1280005f},
{0x24, 0x01000000},
{0x28, 0xfa002314},
{0x2c, 0x80a76000},
{0x30, 0x0280005b},
{0x34, 0x01000000},
{0x38, 0xc2002538},
{0x3c, 0x82006001},
{0x40, 0x80a0401d},
{0x44, 0x06800056},
{0x48, 0xc2202538},
{0x4c, 0x9e102001},
{0x50, 0xc20022fc},
{0x54, 0x80a3c001},
{0x58, 0x18800051},
{0x5c, 0xc0202538},
{0x60, 0x13000017},
{0x64, 0x9a102001},
{0x68, 0xc20022f8},
{0x6c, 0x80a34001},
{0x70, 0x18800046},
{0x74, 0xf20be37f},
{0x78, 0x0300003f},
{0x7c, 0x941063ff},
{0xf0, 0x90},
{0x00, 0x21000017},
{0x04, 0x961263f8},
{0x08, 0x901261d0},
{0x0c, 0x98102001},
{0x10, 0xf8002548},
{0x14, 0x80a72008},
{0x18, 0xf400234c},
{0x1c, 0x08800005},
{0x20, 0x82064019},
{0x24, 0xc210400b},
{0x28, 0x10800003},
{0x2c, 0xb6004001},
{0x30, 0xf610400b},
{0x34, 0xb0064019},
{0x38, 0x81800000},
{0x3c, 0x01000000},
{0x40, 0x01000000},
{0x44, 0x01000000},
{0x48, 0xba76c01c},
{0x4c, 0xc2160008},
{0x50, 0xb6a74001},
{0x54, 0x22800027},
{0x58, 0xc200247c},
{0x5c, 0x80a6e000},
{0x60, 0x04800007},
{0x64, 0x832b001a},
{0x68, 0x80a6c001},
{0x6c, 0x3480000c},
{0x70, 0xb73ec01a},
{0x74, 0x1080000a},
{0x78, 0xb6102001},
{0x7c, 0x36800009},
{0xf0, 0x91},
{0x00, 0xb41421d0},
{0x04, 0x832b001a},
{0x08, 0x82200001},
{0x0c, 0x80a6c001},
{0x10, 0x36800003},
{0x14, 0xb6103fff},
{0x18, 0xb73ec01a},
{0x1c, 0xb41421d0},
{0x20, 0xc216001a},
{0x24, 0xb606c001},
{0x28, 0x808e6001},
{0x2c, 0x0280000a},
{0x30, 0x83366001},
{0x34, 0xb9286002},
{0x38, 0xc207001a},
{0x3c, 0x3b3fffc0},
{0x40, 0x8208401d},
{0x44, 0xba0ec00a},
{0x48, 0x8200401d},
{0x4c, 0x10800008},
{0x50, 0xc227001a},
{0x54, 0x83286002},
{0x58, 0xfa00401a},
{0x5c, 0xb92ee010},
{0x60, 0xba0f400a},
{0x64, 0xb807001d},
{0x68, 0xf820401a},
{0x6c, 0xc200247c},
{0x70, 0xb2064001},
{0x74, 0x9a036001},
{0x78, 0xc20022f8},
{0x7c, 0x80a34001},
{0xf0, 0x92},
{0x00, 0x28bfffc5},
{0x04, 0xf8002548},
{0x08, 0x9e03e001},
{0x0c, 0xc20022fc},
{0x10, 0x80a3c001},
{0x14, 0x08bfffb5},
{0x18, 0x9a102001},
{0x1c, 0x81c7e008},
{0x20, 0x81e80000},
{0x24, 0xc0202514},
{0x28, 0x9a102000},
{0x2c, 0x832b6002},
{0x30, 0xc2020001},
{0x34, 0x80a06000},
{0x38, 0x02800005},
{0x3c, 0x9a036001},
{0x40, 0xc2002514},
{0x44, 0x82006001},
{0x48, 0xc2202514},
{0x4c, 0x80a36009},
{0x50, 0x04bffff8},
{0x54, 0x832b6002},
{0x58, 0x81c3e008},
{0x5c, 0x01000000},
{0x60, 0x9de3bf98},
{0x64, 0xa8102000},
{0x68, 0xa0102000},
{0x6c, 0xc200235c},
{0x70, 0x80a06000},
{0x74, 0x32800004},
{0x78, 0xc0242768},
{0x7c, 0x1080005d},
{0xf0, 0x93},
{0x00, 0xc2002790},
{0x04, 0xc2002790},
{0x08, 0xc2004010},
{0x0c, 0x80a06000},
{0x10, 0x02800019},
{0x14, 0xda042854},
{0x18, 0x03300000},
{0x1c, 0x808b4001},
{0x20, 0x32800010},
{0x24, 0xc2002790},
{0x28, 0xda002514},
{0x2c, 0x80a36000},
{0x30, 0x22800053},
{0x34, 0xa8052001},
{0x38, 0x8203400d},
{0x3c, 0x8200400d},
{0x40, 0x82007ffd},
{0x44, 0xda00235c},
{0x48, 0x9b334001},
{0x4c, 0x9a0b6007},
{0x50, 0x03200000},
{0x54, 0x9a134001},
{0x58, 0xda242854},
{0x5c, 0xc2002790},
{0x60, 0xc2004010},
{0x64, 0x80a06000},
{0x68, 0x32800007},
{0x6c, 0xc2042854},
{0x70, 0xda042854},
{0x74, 0x03200000},
{0x78, 0x822b4001},
{0x7c, 0xc2242854},
{0xf0, 0x94},
{0x00, 0xc2042854},
{0x04, 0x1b300000},
{0x08, 0x9a08400d},
{0x0c, 0x19200000},
{0x10, 0x80a3400c},
{0x14, 0x12800019},
{0x18, 0xa40860ff},
{0x1c, 0x98102000},
{0x20, 0x832b2002},
{0x24, 0xc2006790},
{0x28, 0xc2004010},
{0x2c, 0x80a06000},
{0x30, 0x0280000b},
{0x34, 0x9b30600d},
{0x38, 0x808b6001},
{0x3c, 0x12800009},
{0x40, 0x80a30012},
{0x44, 0x98032001},
{0x48, 0x80a30012},
{0x4c, 0x24bffff6},
{0x50, 0x832b2002},
{0x54, 0x10800006},
{0x58, 0xc2042854},
{0x5c, 0x80a30012},
{0x60, 0x24800027},
{0x64, 0xa8052001},
{0x68, 0xc2042854},
{0x6c, 0x1b100000},
{0x70, 0x8210400d},
{0x74, 0xc2242854},
{0x78, 0xa32ca002},
{0x7c, 0xd0046790},
{0xf0, 0x95},
{0x00, 0xc2020010},
{0x04, 0x80a06000},
{0x08, 0x12800006},
{0x0c, 0x03100000},
{0x10, 0xda042854},
{0x14, 0x822b4001},
{0x18, 0x10800018},
{0x1c, 0xc2242854},
{0x20, 0xe6042854},
{0x24, 0x8334e01e},
{0x28, 0x80886001},
{0x2c, 0x22800014},
{0x30, 0xa8052001},
{0x34, 0x80a4a000},
{0x38, 0x2280000e},
{0x3c, 0xc2046790},
{0x40, 0xd204678c},
{0x44, 0x90020010},
{0x48, 0x7ffffd56},
{0x4c, 0x92024010},
{0x50, 0x80a22008},
{0x54, 0x34800007},
{0x58, 0xc2046790},
{0x5c, 0x820cfff0},
{0x60, 0x9a04bfff},
{0x64, 0x8210400d},
{0x68, 0xc2242854},
{0x6c, 0xc2046790},
{0x70, 0xc2004010},
{0x74, 0xc2242768},
{0x78, 0xa8052001},
{0x7c, 0x80a52009},
{0xf0, 0x96},
{0x00, 0x04bfff9b},
{0x04, 0xa0042004},
{0x08, 0x81c7e008},
{0x0c, 0x81e80000},
{0x10, 0x8332a01f},
{0x14, 0x8200400a},
{0x18, 0x83386001},
{0x1c, 0x80a24001},
{0x20, 0x26800015},
{0x24, 0x90102000},
{0x28, 0x9a024001},
{0x2c, 0x80a36008},
{0x30, 0x24800004},
{0x34, 0x92224001},
{0x38, 0x1080000f},
{0x3c, 0x90102000},
{0x40, 0x80a2400d},
{0x44, 0x1480000b},
{0x48, 0x912a2002},
{0x4c, 0x832a6002},
{0x50, 0xc2006790},
{0x54, 0xc2004008},
{0x58, 0x80a06000},
{0x5c, 0x02bffff7},
{0x60, 0x92026001},
{0x64, 0x80a2400d},
{0x68, 0x04bffffa},
{0x6c, 0x832a6002},
{0x70, 0x90102001},
{0x74, 0x81c3e008},
{0x78, 0x01000000},
{0x7c, 0x9de3bf98},
{0xf0, 0x97},
{0x00, 0x92100019},
{0x04, 0x90100018},
{0x08, 0x7fffffe2},
{0x0c, 0x9410001a},
{0x10, 0xa4100018},
{0x14, 0x80a22000},
{0x18, 0x12800028},
{0x1c, 0x92100019},
{0x20, 0xa33ea01f},
{0x24, 0x8334601f},
{0x28, 0x82068001},
{0x2c, 0x83386001},
{0x30, 0x80a64001},
{0x34, 0x2680000e},
{0x38, 0x8334601f},
{0x3c, 0x82264001},
{0x40, 0x83286002},
{0x44, 0xda006790},
{0x48, 0x832e2002},
{0x4c, 0xc2034001},
{0x50, 0x80a06000},
{0x54, 0x02800019},
{0x58, 0x92103fff},
{0x5c, 0x10800004},
{0x60, 0x8334601f},
{0x64, 0x10800015},
{0x68, 0x92100018},
{0x6c, 0x82068001},
{0x70, 0x83386001},
{0x74, 0xa0102001},
{0x78, 0x80a40001},
{0x7c, 0x1480000e},
{0xf0, 0x98},
{0x00, 0x90100012},
{0x04, 0xb0064010},
{0x08, 0x92100018},
{0x0c, 0x7fffffc1},
{0x10, 0x9410001a},
{0x14, 0x8334601f},
{0x18, 0x82068001},
{0x1c, 0xa0042001},
{0x20, 0x80a22000},
{0x24, 0x12bffff0},
{0x28, 0x83386001},
{0x2c, 0x10bffff4},
{0x30, 0x80a40001},
{0x34, 0x92103fff},
{0x38, 0x81c7e008},
{0x3c, 0x91e80009},
{0x40, 0x9de3bf98},
{0x44, 0xa32e2002},
{0x48, 0xc20467b4},
{0x4c, 0x80a06000},
{0x50, 0x0280001c},
{0x54, 0xb0102001},
{0x58, 0x8336a01f},
{0x5c, 0x82068001},
{0x60, 0xb5386001},
{0x64, 0xa026401a},
{0x68, 0xb2066001},
{0x6c, 0xc20ea35f},
{0x70, 0xb4584001},
{0x74, 0x80a40019},
{0x78, 0x14800011},
{0x7c, 0xb0102000},
{0xf0, 0x99},
{0x00, 0x832c2002},
{0x04, 0xd0006790},
{0x08, 0x90020011},
{0x0c, 0x7ffffce5},
{0x10, 0x920467b4},
{0x14, 0x80a2001a},
{0x18, 0x04800003},
{0x1c, 0xa0042001},
{0x20, 0xb0062001},
{0x24, 0x80a40019},
{0x28, 0x04bffff7},
{0x2c, 0x832c2002},
{0x30, 0x80a62001},
{0x34, 0x14800003},
{0x38, 0xb0102001},
{0x3c, 0xb0102000},
{0x40, 0x81c7e008},
{0x44, 0x81e80000},
{0x48, 0x9de3bf48},
{0x4c, 0xc2082360},
{0x50, 0x80a06000},
{0x54, 0x0280007c},
{0x58, 0xba102000},
{0x5c, 0xa6102000},
{0x60, 0xda04e854},
{0x64, 0x8333601e},
{0x68, 0x80886001},
{0x6c, 0x22800073},
{0x70, 0xba076001},
{0x74, 0x83336008},
{0x78, 0x820860ff},
{0x7c, 0x80a06002},
{0xf0, 0x9a},
{0x00, 0x0480000c},
{0x04, 0xa4102003},
{0x08, 0x82006002},
{0x0c, 0xa4106001},
{0x10, 0x80a4a009},
{0x14, 0x04800005},
{0x18, 0x80a4a002},
{0x1c, 0x10800005},
{0x20, 0xa4102009},
{0x24, 0x80a4a002},
{0x28, 0x0480005d},
{0x2c, 0x1b3fffc0},
{0x30, 0x94100012},
{0x34, 0xd20ce857},
{0x38, 0x7fffff91},
{0x3c, 0x9010001d},
{0x40, 0xa2100008},
{0x44, 0x94100012},
{0x48, 0x92946000},
{0x4c, 0x04800051},
{0x50, 0x9010001d},
{0x54, 0x7fffffbb},
{0x58, 0x01000000},
{0x5c, 0x80a22000},
{0x60, 0x32bffff1},
{0x64, 0xa404bffe},
{0x68, 0xad3ca01f},
{0x6c, 0x8335a01f},
{0x70, 0x82048001},
{0x74, 0x83386001},
{0x78, 0x9a044001},
{0x7c, 0xa0244001},
{0xf0, 0x9b},
{0x00, 0x80a4000d},
{0x04, 0x1480000f},
{0x08, 0x9610000d},
{0x0c, 0x9807bff8},
{0x10, 0x832c2002},
{0x14, 0xda006790},
{0x18, 0xc2134013},
{0x1c, 0x82086fff},
{0x20, 0xc2233fd8},
{0x24, 0xc2034013},
{0x28, 0x82086fff},
{0x2c, 0xc2233fb0},
{0x30, 0xa0042001},
{0x34, 0x80a4000b},
{0x38, 0x04bffff6},
{0x3c, 0x98032004},
{0x40, 0x92100012},
{0x44, 0x7ffff22a},
{0x48, 0x9007bfd0},
{0x4c, 0x9007bfa8},
{0x50, 0x7ffff227},
{0x54, 0x92100012},
{0x58, 0x9935a01f},
{0x5c, 0x9804800c},
{0x60, 0x993b2001},
{0x64, 0x8207bff8},
{0x68, 0x952b2002},
{0x6c, 0x94028001},
{0x70, 0xda02bfd8},
{0x74, 0xd604e768},
{0x78, 0x9a0b6fff},
{0x7c, 0x0303ffc0},
{0xf0, 0x9c},
{0x00, 0x9b2b6010},
{0x04, 0x822ac001},
{0x08, 0x8210400d},
{0x0c, 0xc224e768},
{0x10, 0xda02bfb0},
{0x14, 0x9a0b6fff},
{0x18, 0x82087000},
{0x1c, 0x8210400d},
{0x20, 0xc224e768},
{0x24, 0x832c6002},
{0x28, 0xda006790},
{0x2c, 0x8204400c},
{0x30, 0xa024400c},
{0x34, 0x80a40001},
{0x38, 0x031fffff},
{0x3c, 0xea034013},
{0x40, 0xae1063ff},
{0x44, 0x14800011},
{0x48, 0x832c2002},
{0x4c, 0xe8006790},
{0x50, 0x90050013},
{0x54, 0x7ffffc73},
{0x58, 0x9204e768},
{0x5c, 0x8335a01f},
{0x60, 0x82048001},
{0x64, 0x83386001},
{0x68, 0xa0042001},
{0x6c, 0x80a20017},
{0x70, 0x16800004},
{0x74, 0x82044001},
{0x78, 0xae100008},
{0x7c, 0xea050013},
{0xf0, 0x9d},
{0x00, 0x10bffff1},
{0x04, 0x80a40001},
{0x08, 0x10800004},
{0x0c, 0xea24e768},
{0x10, 0x10bfffa5},
{0x14, 0xa404bffe},
{0x18, 0x1b3fffc0},
{0x1c, 0xc204e854},
{0x20, 0x9a1360ff},
{0x24, 0x8208400d},
{0x28, 0x9b2ca008},
{0x2c, 0x8210400d},
{0x30, 0xc224e854},
{0x34, 0xba076001},
{0x38, 0x80a76009},
{0x3c, 0x04bfff89},
{0x40, 0xa604e004},
{0x44, 0x81c7e008},
{0x48, 0x81e80000},
{0x4c, 0x9de3bf98},
{0x50, 0xa6102000},
{0x54, 0xa12ce002},
{0x58, 0xda042768},
{0x5c, 0x80a36000},
{0x60, 0x12800008},
{0x64, 0x82102001},
{0x68, 0xc02427b4},
{0x6c, 0xda002550},
{0x70, 0x83284013},
{0x74, 0x822b4001},
{0x78, 0x1080001c},
{0x7c, 0xc2202550},
{0xf0, 0x9e},
{0x00, 0xe80427b4},
{0x04, 0x80a52000},
{0x08, 0x12800004},
{0x0c, 0xa5284013},
{0x10, 0x10800016},
{0x14, 0xda2427b4},
{0x18, 0xe2002550},
{0x1c, 0x808c4012},
{0x20, 0x32800011},
{0x24, 0xc2042768},
{0x28, 0x8333600c},
{0x2c, 0x80886001},
{0x30, 0x3280000d},
{0x34, 0xc2042768},
{0x38, 0x90042768},
{0x3c, 0x7ffffc39},
{0x40, 0x920427b4},
{0x44, 0xc2002354},
{0x48, 0x80a20001},
{0x4c, 0x1a800004},
{0x50, 0x82144012},
{0x54, 0x10800005},
{0x58, 0xe8242768},
{0x5c, 0xc2202550},
{0x60, 0xc2042768},
{0x64, 0xc22427b4},
{0x68, 0xa604e001},
{0x6c, 0x80a4e009},
{0x70, 0x08bfffda},
{0x74, 0xa12ce002},
{0x78, 0x81c7e008},
{0x7c, 0x81e80000},
{0xf0, 0x9f},
{0x00, 0x9de3bf98},
{0x04, 0xc2060000},
{0x08, 0xbb30600c},
{0x0c, 0xb9306010},
{0x10, 0xb80f2fff},
{0x14, 0xb08f6001},
{0x18, 0xb6086fff},
{0x1c, 0x12800014},
{0x20, 0x9f30601c},
{0x24, 0xc250229e},
{0x28, 0xfa5022a2},
{0x2c, 0x8226c001},
{0x30, 0xba27001d},
{0x34, 0xf850229c},
{0x38, 0xf65022a0},
{0x3c, 0x8258401c},
{0x40, 0xba5f401b},
{0x44, 0x82006800},
{0x48, 0xba076800},
{0x4c, 0xb938601f},
{0x50, 0xb73f601f},
{0x54, 0xb9372014},
{0x58, 0xb736e014},
{0x5c, 0x8200401c},
{0x60, 0xba07401b},
{0x64, 0xb738600c},
{0x68, 0xb93f600c},
{0x6c, 0xf4002324},
{0x70, 0xf2002328},
{0x74, 0xfa002308},
{0x78, 0xc2002300},
{0x7c, 0xb65ec01a},
{0xf0, 0xa0},
{0x00, 0xbb2f6006},
{0x04, 0xb85f0019},
{0x08, 0x83286006},
{0x0c, 0x9b3ee01f},
{0x10, 0x81836000},
{0x14, 0x01000000},
{0x18, 0x01000000},
{0x1c, 0x01000000},
{0x20, 0xb67ec01d},
{0x24, 0x9b3f201f},
{0x28, 0x81836000},
{0x2c, 0x01000000},
{0x30, 0x01000000},
{0x34, 0x01000000},
{0x38, 0xb87f0001},
{0x3c, 0x80a62000},
{0x40, 0x32800031},
{0x44, 0x3b03ffc0},
{0x48, 0xc20022a4},
{0x4c, 0x80a06000},
{0x50, 0x0280000a},
{0x54, 0x80a6e000},
{0x58, 0xc25022a6},
{0x5c, 0x80a6c001},
{0x60, 0x14800031},
{0x64, 0xb0102000},
{0x68, 0xc25022a4},
{0x6c, 0x80a6c001},
{0x70, 0x0680002d},
{0x74, 0x80a6e000},
{0x78, 0x24800002},
{0x7c, 0xb6102001},
{0xf0, 0xa1},
{0x00, 0x80a6c01a},
{0x04, 0x3a800002},
{0x08, 0xb606bfff},
{0x0c, 0xc20022a8},
{0x10, 0x80a06000},
{0x14, 0x0280000a},
{0x18, 0x80a72000},
{0x1c, 0xc25022aa},
{0x20, 0x80a70001},
{0x24, 0x14800020},
{0x28, 0xb0102000},
{0x2c, 0xc25022a8},
{0x30, 0x80a70001},
{0x34, 0x0680001c},
{0x38, 0x80a72000},
{0x3c, 0x24800002},
{0x40, 0xb8102001},
{0x44, 0x80a70019},
{0x48, 0x3a800002},
{0x4c, 0xb8067fff},
{0x50, 0xc20023c8},
{0x54, 0x80886002},
{0x58, 0x32800002},
{0x5c, 0xb626801b},
{0x60, 0x80886004},
{0x64, 0x32800002},
{0x68, 0xb826401c},
{0x6c, 0x80886008},
{0x70, 0x02800005},
{0x74, 0x3b03ffc0},
{0x78, 0xb61ec01c},
{0x7c, 0xb81f001b},
{0xf0, 0xa2},
{0x00, 0xb61ec01c},
{0x04, 0x832ee010},
{0x08, 0x8208401d},
{0x0c, 0xbb2be01c},
{0x10, 0xba074001},
{0x14, 0x0300003f},
{0x18, 0x821063ff},
{0x1c, 0x820f0001},
{0x20, 0xb0074001},
{0x24, 0x81c7e008},
{0x28, 0x81e80000},
{0x2c, 0x9de3bf98},
{0x30, 0xda002514},
{0x34, 0xc2002284},
{0x38, 0x80a34001},
{0x3c, 0x0880000a},
{0x40, 0xa0102000},
{0x44, 0xc20023c8},
{0x48, 0x80886001},
{0x4c, 0x02800007},
{0x50, 0xa2102000},
{0x54, 0x033fc180},
{0x58, 0xc0204000},
{0x5c, 0x1080001c},
{0x60, 0xc0202514},
{0x64, 0xa2102000},
{0x68, 0x912c6002},
{0x6c, 0xc2022768},
{0x70, 0x9b30601c},
{0x74, 0x80a36000},
{0x78, 0x0280000f},
{0x7c, 0xa2046001},
{0xf0, 0xa3},
{0x00, 0xc2002284},
{0x04, 0x80a34001},
{0x08, 0x1880000b},
{0x0c, 0x90022768},
{0x10, 0x7fffff7c},
{0x14, 0x01000000},
{0x18, 0x80a22000},
{0x1c, 0x02800007},
{0x20, 0x80a46009},
{0x24, 0xa0042001},
{0x28, 0x9b2c2002},
{0x2c, 0x033fc180},
{0x30, 0xd0234001},
{0x34, 0x80a46009},
{0x38, 0x28bfffed},
{0x3c, 0x912c6002},
{0x40, 0x033fc180},
{0x44, 0xe0204000},
{0x48, 0xe0202514},
{0x4c, 0x81c7e008},
{0x50, 0x81e80000},
{0x54, 0x9de3bf98},
{0x58, 0xd0002320},
{0x5c, 0x80a22000},
{0x60, 0x0280004b},
{0x64, 0x01000000},
{0x68, 0xc200231c},
{0x6c, 0x80a06000},
{0x70, 0x22800016},
{0x74, 0xd800231c},
{0x78, 0x82063fff},
{0x7c, 0x80a06001},
{0xf0, 0xa4},
{0x00, 0x38800012},
{0x04, 0xd800231c},
{0x08, 0xc2002318},
{0x0c, 0x80a06000},
{0x10, 0x12800008},
{0x14, 0x213fc000},
{0x18, 0xa0142020},
{0x1c, 0x82102001},
{0x20, 0x7ffff019},
{0x24, 0xc2240000},
{0x28, 0x10800007},
{0x2c, 0xc0240000},
{0x30, 0xa0142020},
{0x34, 0x7ffff014},
{0x38, 0xc0240000},
{0x3c, 0x82102001},
{0x40, 0xc2240000},
{0x44, 0xd800231c},
{0x48, 0x80a0000c},
{0x4c, 0x82603fff},
{0x50, 0x9a1e2001},
{0x54, 0x80a0000d},
{0x58, 0x9a603fff},
{0x5c, 0x8088400d},
{0x60, 0x0280000d},
{0x64, 0x80a0000c},
{0x68, 0xc2002318},
{0x6c, 0x80a06000},
{0x70, 0x12800006},
{0x74, 0x033fc000},
{0x78, 0x9a102001},
{0x7c, 0x82106020},
{0xf0, 0xa5},
{0x00, 0x10800004},
{0x04, 0xda204000},
{0x08, 0x82106020},
{0x0c, 0xc0204000},
{0x10, 0x80a0000c},
{0x14, 0x82603fff},
{0x18, 0x9a1e2002},
{0x1c, 0x80a0000d},
{0x20, 0x9a603fff},
{0x24, 0x8088400d},
{0x28, 0x0280000d},
{0x2c, 0x80a62000},
{0x30, 0xc2002318},
{0x34, 0x80a06000},
{0x38, 0x12800005},
{0x3c, 0x033fc000},
{0x40, 0x82106020},
{0x44, 0x10800005},
{0x48, 0xc0204000},
{0x4c, 0x9a102001},
{0x50, 0x82106020},
{0x54, 0xda204000},
{0x58, 0x80a62000},
{0x5c, 0x1280000c},
{0x60, 0x01000000},
{0x64, 0xc2002318},
{0x68, 0x80a06000},
{0x6c, 0x12800005},
{0x70, 0x033fc000},
{0x74, 0x82106020},
{0x78, 0x10800005},
{0x7c, 0xc0204000},
{0xf0, 0xa6},
{0x00, 0x9a102001},
{0x04, 0x82106020},
{0x08, 0xda204000},
{0x0c, 0x81c7e008},
{0x10, 0x81e80000},
{0x14, 0x9de3bf98},
{0x18, 0xc2002514},
{0x1c, 0x80a06000},
{0x20, 0x12800007},
{0x24, 0x90102001},
{0x28, 0xda002568},
{0x2c, 0xc2002570},
{0x30, 0x80a34001},
{0x34, 0x22800006},
{0x38, 0xc2002514},
{0x3c, 0x82102001},
{0x40, 0x7fffffa5},
{0x44, 0xc220250c},
{0x48, 0xc2002514},
{0x4c, 0x80a06000},
{0x50, 0x1280000c},
{0x54, 0x01000000},
{0x58, 0xc200250c},
{0x5c, 0x80a06000},
{0x60, 0x02800008},
{0x64, 0x9a007fff},
{0x68, 0xb0102002},
{0x6c, 0x80a36000},
{0x70, 0x12800004},
{0x74, 0xda20250c},
{0x78, 0x7fffff97},
{0x7c, 0x81e80000},
{0xf0, 0xa7},
{0x00, 0x01000000},
{0x04, 0x81c7e008},
{0x08, 0x81e80000},
{0x0c, 0x01000000},
{0x10, 0x27001040},
{0x14, 0xa614e00f},
{0x18, 0xe6a00040},
{0x1c, 0x01000000},
{0x20, 0x81c3e008},
{0x24, 0x01000000},
{0x28, 0x9de3bf98},
{0x2c, 0xc2002508},
{0x30, 0x80a06000},
{0x34, 0x0280000e},
{0x38, 0x1b3fc180},
{0x3c, 0x82102001},
{0x40, 0x9a13603c},
{0x44, 0xc2234000},
{0x48, 0xc2002508},
{0x4c, 0x80a06000},
{0x50, 0x02800005},
{0x54, 0x033fc180},
{0x58, 0x7fffffed},
{0x5c, 0x01000000},
{0x60, 0x30bffffa},
{0x64, 0x8210603c},
{0x68, 0xc0204000},
{0x6c, 0x81c7e008},
{0x70, 0x81e80000},
{0x74, 0x9de3bf98},
{0x78, 0xda002500},
{0x7c, 0xc20022d0},
{0xf0, 0xa8},
{0x00, 0x80a34001},
{0x04, 0x18800025},
{0x08, 0xa4102000},
{0x0c, 0xd2002790},
{0x10, 0x832ca002},
{0x14, 0xe2024001},
{0x18, 0x80a46000},
{0x1c, 0x12800004},
{0x20, 0xa12ca003},
{0x24, 0x10800019},
{0x28, 0xc02427dc},
{0x2c, 0x92024001},
{0x30, 0xc20427dc},
{0x34, 0x80a06000},
{0x38, 0x02800008},
{0x3c, 0x900427dc},
{0x40, 0x7ffffaf8},
{0x44, 0x01000000},
{0x48, 0xc20022ac},
{0x4c, 0x80a20001},
{0x50, 0x28800005},
{0x54, 0xc20427e0},
{0x58, 0xe22427dc},
{0x5c, 0x1080000b},
{0x60, 0xc02427e0},
{0x64, 0x82006001},
{0x68, 0xc22427e0},
{0x6c, 0xda002378},
{0x70, 0x80a0400d},
{0x74, 0x28800006},
{0x78, 0xa404a001},
{0x7c, 0x7ffff069},
{0xf0, 0xa9},
{0x00, 0x01000000},
{0x04, 0x30800005},
{0x08, 0xa404a001},
{0x0c, 0x80a4a009},
{0x10, 0x24bfffe0},
{0x14, 0xd2002790},
{0x18, 0x81c7e008},
{0x1c, 0x81e80000},
{0x20, 0x9de3bf98},
{0x24, 0x7ffff54c},
{0x28, 0x01000000},
{0x2c, 0x7ffff390},
{0x30, 0x01000000},
{0x34, 0x7ffff3d0},
{0x38, 0x01000000},
{0x3c, 0x7ffff535},
{0x40, 0x01000000},
{0x44, 0x7ffff800},
{0x48, 0x01000000},
{0x4c, 0x7ffff571},
{0x50, 0x01000000},
{0x54, 0x7ffff714},
{0x58, 0x01000000},
{0x5c, 0x7ffff7b9},
{0x60, 0x90102001},
{0x64, 0x7ffff93a},
{0x68, 0x01000000},
{0x6c, 0x7ffffca3},
{0x70, 0x01000000},
{0x74, 0x7ffff9cf},
{0x78, 0x01000000},
{0x7c, 0x7ffff963},
{0xf0, 0xaa},
{0x00, 0x01000000},
{0x04, 0x7ffffd08},
{0x08, 0x90102768},
{0x0c, 0x7ffff997},
{0x10, 0x01000000},
{0x14, 0x7ffffa8b},
{0x18, 0x01000000},
{0x1c, 0x7ffffb1d},
{0x20, 0x01000000},
{0x24, 0x7ffffb8e},
{0x28, 0x01000000},
{0x2c, 0x7ffffbc8},
{0x30, 0x01000000},
{0x34, 0x7ffffbe4},
{0x38, 0x01000000},
{0x3c, 0x7ffffc52},
{0x40, 0x01000000},
{0x44, 0x7ffffcf8},
{0x48, 0xd0002790},
{0x4c, 0xc2002514},
{0x50, 0x7ffffd04},
{0x54, 0xc2202518},
{0x58, 0x7ffffddc},
{0x5c, 0x01000000},
{0x60, 0x7ffffe5b},
{0x64, 0x01000000},
{0x68, 0x7fffffa3},
{0x6c, 0x01000000},
{0x70, 0x7ffffeef},
{0x74, 0x01000000},
{0x78, 0x7fffff67},
{0x7c, 0x01000000},
{0xf0, 0xab},
{0x00, 0x7fffff8a},
{0x04, 0x81e80000},
{0x08, 0x01000000},
{0x0c, 0x9de3bf98},
{0x10, 0xc200253c},
{0x14, 0x80a06000},
{0x18, 0x12800048},
{0x1c, 0xb0102000},
{0x20, 0xd6002460},
{0x24, 0x82102080},
{0x28, 0x80a2e000},
{0x2c, 0x02800043},
{0x30, 0xc220256c},
{0x34, 0x10800005},
{0x38, 0xb0102001},
{0x3c, 0xc220256c},
{0x40, 0x1080003e},
{0x44, 0xf00e2468},
{0x48, 0xd80022fc},
{0x4c, 0x80a6000c},
{0x50, 0x1880002d},
{0x54, 0x9a102000},
{0x58, 0xd40022f8},
{0x5c, 0x33000018},
{0x60, 0xb6102001},
{0x64, 0x80a6c00a},
{0x68, 0x18800020},
{0x6c, 0xb4102000},
{0x70, 0x832e2002},
{0x74, 0xb8006038},
{0x78, 0xa0166220},
{0x7c, 0x901661e8},
{0xf0, 0xac},
{0x00, 0x92166258},
{0x04, 0xde0022f8},
{0x08, 0xfa070010},
{0x0c, 0x80a7400b},
{0x10, 0x26800013},
{0x14, 0xb606e001},
{0x18, 0x80a6e001},
{0x1c, 0x22800007},
{0x20, 0xc20022f8},
{0x24, 0xc2070008},
{0x28, 0x80a74001},
{0x2c, 0x2480000c},
{0x30, 0xb606e001},
{0x34, 0xc20022f8},
{0x38, 0x80a6c001},
{0x3c, 0x22800007},
{0x40, 0xb406a001},
{0x44, 0xc2070009},
{0x48, 0x80a74001},
{0x4c, 0x26800004},
{0x50, 0xb606e001},
{0x54, 0xb406a001},
{0x58, 0xb606e001},
{0x5c, 0x80a6c00f},
{0x60, 0x08bfffea},
{0x64, 0xb8072038},
{0x68, 0x80a6800d},
{0x6c, 0x34800002},
{0x70, 0x9a10001a},
{0x74, 0xb0062001},
{0x78, 0x80a6000c},
{0x7c, 0x28bfffda},
{0xf0, 0xad},
{0x00, 0xb6102001},
{0x04, 0xb0102000},
{0x08, 0xc20e2464},
{0x0c, 0x80a06000},
{0x10, 0x22800006},
{0x14, 0xb0062001},
{0x18, 0x80a34001},
{0x1c, 0x34bfffc8},
{0x20, 0xc20e2278},
{0x24, 0xb0062001},
{0x28, 0x80a62003},
{0x2c, 0x24bffff8},
{0x30, 0xc20e2464},
{0x34, 0xb0102000},
{0x38, 0x81c7e008},
{0x3c, 0x81e80000},
{0x40, 0x9de3bf98},
{0x44, 0xc2002574},
{0x48, 0x80a06000},
{0x4c, 0x02800021},
{0x50, 0x90100018},
{0x54, 0x82007fff},
{0x58, 0x7ffff164},
{0x5c, 0xc2202574},
{0x60, 0xc2002574},
{0x64, 0x80a06000},
{0x68, 0x3280001b},
{0x6c, 0xc2002578},
{0x70, 0xc200253c},
{0x74, 0xda002334},
{0x78, 0x8200400d},
{0x7c, 0x82006001},
{0xf0, 0xae},
{0x00, 0xc2202548},
{0x04, 0xc2002564},
{0x08, 0x80a06000},
{0x0c, 0x1280000f},
{0x10, 0x01000000},
{0x14, 0x7ffff1bc},
{0x18, 0x01000000},
{0x1c, 0x033fc200},
{0x20, 0xda002334},
{0x24, 0xd800232c},
{0x28, 0x82106074},
{0x2c, 0xd8204000},
{0x30, 0x96102001},
{0x34, 0x9a036001},
{0x38, 0xda202574},
{0x3c, 0xd6202540},
{0x40, 0x10800004},
{0x44, 0xd6202564},
{0x48, 0x7ffff16c},
{0x4c, 0x01000000},
{0x50, 0xc2002578},
{0x54, 0x80a06000},
{0x58, 0x12800014},
{0x5c, 0x01000000},
{0x60, 0xc2002574},
{0x64, 0x80a06000},
{0x68, 0x12800010},
{0x6c, 0x01000000},
{0x70, 0x7fffff87},
{0x74, 0x01000000},
{0x78, 0x80a22000},
{0x7c, 0x1280000a},
{0xf0, 0xaf},
{0x00, 0xd020253c},
{0x04, 0xc2002334},
{0x08, 0x9a102001},
{0x0c, 0x82006001},
{0x10, 0xc2202574},
{0x14, 0xda202578},
{0x18, 0xda202540},
{0x1c, 0x7ffff709},
{0x20, 0x91e82000},
{0x24, 0xd0202574},
{0x28, 0x81c7e008},
{0x2c, 0x81e80000},
{0x30, 0x9de3bf98},
{0x34, 0x033fc200},
{0x38, 0x82106030},
{0x3c, 0xda004000},
{0x40, 0xc200257c},
{0x44, 0x80a34001},
{0x48, 0x12800017},
{0x4c, 0x01000000},
{0x50, 0x7ffff01d},
{0x54, 0x01000000},
{0x58, 0x80a22000},
{0x5c, 0x32800008},
{0x60, 0xc2002514},
{0x64, 0x7ffff066},
{0x68, 0xb0102000},
{0x6c, 0x80a22000},
{0x70, 0x0280000f},
{0x74, 0x01000000},
{0x78, 0xc2002514},
{0x7c, 0x80a06000},
{0xf0, 0xb0},
{0x00, 0x12800006},
{0x04, 0x90102002},
{0x08, 0xc200250c},
{0x0c, 0x80a06000},
{0x10, 0x02800005},
{0x14, 0x01000000},
{0x18, 0x033fc180},
{0x1c, 0x7ffffe6e},
{0x20, 0xc0204000},
{0x24, 0x7fffef7f},
{0x28, 0xb0102001},
{0x2c, 0x81c7e008},
{0x30, 0x81e80000},
{0x34, 0x9de3bf98},
{0x38, 0x7ffffed5},
{0x3c, 0x01000000},
{0x40, 0xe0002500},
{0x44, 0x80a42015},
{0x48, 0x08800016},
{0x4c, 0x80a42000},
{0x50, 0x7ffff15a},
{0x54, 0x01000000},
{0x58, 0x033fc140},
{0x5c, 0x82106048},
{0x60, 0xda004000},
{0x64, 0x03000040},
{0x68, 0x11000016},
{0x6c, 0x808b4001},
{0x70, 0x12800004},
{0x74, 0x90122180},
{0x78, 0x11000016},
{0x7c, 0x901223a8},
{0xf0, 0xb1},
{0x00, 0x7fffff90},
{0x04, 0x01000000},
{0x08, 0x7fffffca},
{0x0c, 0x01000000},
{0x10, 0x80a22000},
{0x14, 0x2280001d},
{0x18, 0xc2002500},
{0x1c, 0x3080002f},
{0x20, 0x1280000f},
{0x24, 0x80a42014},
{0x28, 0x7fffef21},
{0x2c, 0x01000000},
{0x30, 0x80a22000},
{0x34, 0x32800003},
{0x38, 0x90102002},
{0x3c, 0x90102001},
{0x40, 0x7ffffe45},
{0x44, 0x01000000},
{0x48, 0x7fffef56},
{0x4c, 0x01000000},
{0x50, 0x7fffee94},
{0x54, 0x01000000},
{0x58, 0x30800009},
{0x5c, 0x3880000b},
{0x60, 0xc2002500},
{0x64, 0x808c2001},
{0x68, 0x32800008},
{0x6c, 0xc2002500},
{0x70, 0x90043ff8},
{0x74, 0x7ffff074},
{0x78, 0x91322001},
{0x7c, 0x7ffff0cf},
{0xf0, 0xb2},
{0x00, 0x01000000},
{0x04, 0xc2002500},
{0x08, 0x80a40001},
{0x0c, 0x3280000d},
{0x10, 0xc2002578},
{0x14, 0x031fffff},
{0x18, 0x821063f0},
{0x1c, 0x80a40001},
{0x20, 0x38800003},
{0x24, 0x21040000},
{0x28, 0xa0042001},
{0x2c, 0x033fc180},
{0x30, 0x82106034},
{0x34, 0xe0204000},
{0x38, 0xe0202500},
{0x3c, 0xc2002578},
{0x40, 0x80a06000},
{0x44, 0x02800005},
{0x48, 0x01000000},
{0x4c, 0x7ffffed5},
{0x50, 0x01000000},
{0x54, 0xc0202578},
{0x58, 0x81c7e008},
{0x5c, 0x81e80000},
{0x60, 0x81c3e008},
{0x64, 0x01000000},
{0x68, 0x01000000},
{0x6c, 0x01000000},
{0x70, 0x01000000},
{0x74, 0x01000000},
{0x78, 0x01000000},
{0x7c, 0x01000000},
{0xf0, 0xb3},
{0x00, 0x00001682},
{0x04, 0x00000000},
{0x08, 0x46656220},
{0x0c, 0x20352032},
{0x10, 0x30313300},
{0x14, 0x00000000},
{0x18, 0x31353a34},
{0x1c, 0x383a3334},
{0x20, 0x00000000},
{0x24, 0x00000000},
{0x28, 0x00000000},
{0x2c, 0x00000000},
{0x30, 0x00000000},
{0x34, 0x00000000},
{0x38, 0x00000000},
{0x3c, 0x00000000},
{0x40, 0x00000000},
{0x44, 0x00000000},
{0x48, 0x00000000},
{0x4c, 0x00000000},
{0x50, 0x00000000},
{0x54, 0x00000000},
{0x58, 0x00000000},
{0x5c, 0x00000000},
{0x60, 0x00000000},
{0x64, 0x00000000},
{0x68, 0x00000000},
{0x6c, 0x00000000},
{0x70, 0x00000000},
{0x74, 0x00000000},
{0x78, 0x00000000},
{0x7c, 0x00000000},
};
