#ifndef _LINUX_REBOOT_H
#define _LINUX_REBOOT_H


#include <linux/notifier.h>
#include <uapi/linux/reboot.h>

#define SYS_DOWN	0x0001	/* Notify of system down */
#define SYS_RESTART	SYS_DOWN
#define SYS_HALT	0x0002	/* Notify of system halt */
#define SYS_POWER_OFF	0x0003	/* Notify of system power off */

enum reboot_mode {
	REBOOT_COLD = 0,
	REBOOT_WARM,
	REBOOT_HARD,
	REBOOT_SOFT,
	REBOOT_GPIO,
};
extern enum reboot_mode reboot_mode;

enum reboot_type {
	BOOT_TRIPLE	= 't',
	BOOT_KBD	= 'k',
	BOOT_BIOS	= 'b',
	BOOT_ACPI	= 'a',
	BOOT_EFI	= 'e',
	BOOT_CF9_FORCE	= 'p',
	BOOT_CF9_SAFE	= 'q',
};
extern enum reboot_type reboot_type;

extern int reboot_default;
extern int reboot_cpu;
extern int reboot_force;


extern int register_reboot_notifier(struct notifier_block *);
extern int unregister_reboot_notifier(struct notifier_block *);

extern int register_restart_handler(struct notifier_block *);
extern int unregister_restart_handler(struct notifier_block *);
extern void do_kernel_restart(char *cmd);

/*
 * Architecture-specific implementations of sys_reboot commands.
 */

extern void migrate_to_reboot_cpu(void);
extern void machine_restart(char *cmd);
extern void machine_halt(void);
extern void machine_power_off(void);

extern void machine_shutdown(void);
struct pt_regs;
extern void machine_crash_shutdown(struct pt_regs *);

/*
 * Architecture independent implemenations of sys_reboot commands.
 */

extern void kernel_restart_prepare(char *cmd);
extern void kernel_restart(char *cmd);
extern void kernel_halt(void);
extern void kernel_power_off(void);

extern int C_A_D; /* for sysctl */
void ctrl_alt_del(void);

#define POWEROFF_CMD_PATH_LEN	256
extern char poweroff_cmd[POWEROFF_CMD_PATH_LEN];

extern void orderly_poweroff(bool force);
extern void orderly_reboot(void);

/*
 * Emergency restart, callable from an interrupt handler.
 */

extern void emergency_restart(void);
#include <asm/emergency-restart.h>

#if defined(CONFIG_NECPF_IPQ6018_CLOCK_BACKUP)
#define CLOCK_MAGIC_ADDR	0x86006c0
#define CLOCK_ADDR		0x86006c8
#define CLOCK_VERI_ADDR		0x86006cc
#define CLOCK_MAGIC1_NUM	0x92dcac3f
#define CLOCK_MAGIC2_NUM	0x6d2353c0
struct clock_ctrl {
	u32 magic1;
	u32 magic2;
	u32 clock;
	u32 verify;
};

extern int clock_backup_init(void);
extern void clock_backup(void);
#endif	/* CONFIG_NECPF_IPQ6018_CLOCK_BACKUP */

#if defined(CONFIG_NECPF_IPQ6018_RESET_REASON)
#define REASON_MAGIC_ADDR	0x86006d0
#define REASON_ADDR		0x86006d8
#define REASON_MAGIC1_NUM	0x8d72c37a
#define REASON_MAGIC2_NUM	0x728d3c85
struct reset_reason_ctrl {
	u32 magic1;
	u32 magic2;
	u32 reason;
};

#define RESET_REASON_WDT	0
#define RESET_REASON_PANIC	1
#define RESET_REASON_REBOOT	2
#define REASON_WDT		(1 << 1)
#define REASON_PANIC		(1 << 2)
#define REASON_REBOOT		(1 << 3)
#define WRITE_FLAG		(1 << 15)
#define REASON_VERIFY_BIT_OFFSET(x)	(x << 16) /* bit16-31 : verify 用 */

extern int reset_reason_init(void);
extern void set_reset_reason(int reason);
#endif	/* CONFIG_NECPF_IPQ6018_RESET_REASON */

#endif /* _LINUX_REBOOT_H */
